/* vbffile.c generated by valac 0.12.1.1-323029-dirty, the Vala compiler
 * generated from vbffile.vala, do not modify */

/*
 *  vbffile.vala - Vala Build Framework library
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define VBF_TYPE_FILE_TYPES (vbf_file_types_get_type ())

#define VBF_TYPE_FILE (vbf_file_get_type ())
#define VBF_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_FILE, VbfFile))
#define VBF_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_FILE, VbfFileClass))
#define VBF_IS_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_FILE))
#define VBF_IS_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_FILE))
#define VBF_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_FILE, VbfFileClass))

typedef struct _VbfFile VbfFile;
typedef struct _VbfFileClass VbfFileClass;
typedef struct _VbfFilePrivate VbfFilePrivate;

#define VBF_TYPE_TARGET (vbf_target_get_type ())
#define VBF_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_TARGET, VbfTarget))
#define VBF_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_TARGET, VbfTargetClass))
#define VBF_IS_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_TARGET))
#define VBF_IS_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_TARGET))
#define VBF_TARGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_TARGET, VbfTargetClass))

typedef struct _VbfTarget VbfTarget;
typedef struct _VbfTargetClass VbfTargetClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	VBF_FILE_TYPES_UNKNOWN,
	VBF_FILE_TYPES_DATA,
	VBF_FILE_TYPES_VALA_SOURCE,
	VBF_FILE_TYPES_OTHER_SOURCE
} VbfFileTypes;

struct _VbfFile {
	GObject parent_instance;
	VbfFilePrivate * priv;
	gchar* name;
	gchar* filename;
	gchar* uri;
	VbfFileTypes type;
	VbfTarget* target;
};

struct _VbfFileClass {
	GObjectClass parent_class;
};


static gpointer vbf_file_parent_class = NULL;

GType vbf_file_types_get_type (void) G_GNUC_CONST;
GType vbf_file_get_type (void) G_GNUC_CONST;
GType vbf_target_get_type (void) G_GNUC_CONST;
enum  {
	VBF_FILE_DUMMY_PROPERTY
};
VbfFile* vbf_file_new (VbfTarget* target, const gchar* filename);
VbfFile* vbf_file_construct (GType object_type, VbfTarget* target, const gchar* filename);
VbfFile* vbf_file_new_with_type (VbfTarget* target, const gchar* filename, VbfFileTypes type);
VbfFile* vbf_file_construct_with_type (GType object_type, VbfTarget* target, const gchar* filename, VbfFileTypes type);
void vbf_file_update_file_data (VbfFile* self, const gchar* filename);
static void vbf_file_finalize (GObject* obj);


GType vbf_file_types_get_type (void) {
	static volatile gsize vbf_file_types_type_id__volatile = 0;
	if (g_once_init_enter (&vbf_file_types_type_id__volatile)) {
		static const GEnumValue values[] = {{VBF_FILE_TYPES_UNKNOWN, "VBF_FILE_TYPES_UNKNOWN", "unknown"}, {VBF_FILE_TYPES_DATA, "VBF_FILE_TYPES_DATA", "data"}, {VBF_FILE_TYPES_VALA_SOURCE, "VBF_FILE_TYPES_VALA_SOURCE", "vala-source"}, {VBF_FILE_TYPES_OTHER_SOURCE, "VBF_FILE_TYPES_OTHER_SOURCE", "other-source"}, {0, NULL, NULL}};
		GType vbf_file_types_type_id;
		vbf_file_types_type_id = g_enum_register_static ("VbfFileTypes", values);
		g_once_init_leave (&vbf_file_types_type_id__volatile, vbf_file_types_type_id);
	}
	return vbf_file_types_type_id__volatile;
}


VbfFile* vbf_file_construct (GType object_type, VbfTarget* target, const gchar* filename) {
	VbfFile * self = NULL;
	g_return_val_if_fail (target != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	self = (VbfFile*) vbf_file_construct_with_type (object_type, target, filename, VBF_FILE_TYPES_UNKNOWN);
	return self;
}


VbfFile* vbf_file_new (VbfTarget* target, const gchar* filename) {
	return vbf_file_construct (VBF_TYPE_FILE, target, filename);
}


VbfFile* vbf_file_construct_with_type (GType object_type, VbfTarget* target, const gchar* filename, VbfFileTypes type) {
	VbfFile * self = NULL;
	g_return_val_if_fail (target != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	self = (VbfFile*) g_object_new (object_type, NULL);
	vbf_file_update_file_data (self, filename);
	self->target = target;
	self->type = type;
	return self;
}


VbfFile* vbf_file_new_with_type (VbfTarget* target, const gchar* filename, VbfFileTypes type) {
	return vbf_file_construct_with_type (VBF_TYPE_FILE, target, filename, type);
}


void vbf_file_update_file_data (VbfFile* self, const gchar* filename) {
	gchar* _tmp0_;
	gchar* file;
	gboolean _tmp1_;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_tmp0_ = g_strdup (filename);
	file = _tmp0_;
	_tmp1_ = g_path_is_absolute (file);
	if (!_tmp1_) {
		GFile* _tmp2_ = NULL;
		GFile* f;
		GFile* _tmp3_ = NULL;
		GFile* _tmp4_;
		gchar* _tmp5_ = NULL;
		_tmp2_ = g_file_new_for_path (file);
		f = _tmp2_;
		_tmp3_ = g_file_resolve_relative_path (f, file);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_get_path (_tmp4_);
		_g_free0 (file);
		file = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_g_object_unref0 (f);
	}
	_tmp6_ = g_strdup (file);
	_g_free0 (self->filename);
	self->filename = _tmp6_;
	_tmp7_ = g_filename_to_uri (file, NULL, &_inner_error_);
	_tmp8_ = _tmp7_;
	if (_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	_g_free0 (self->uri);
	self->uri = _tmp8_;
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("vbffile.vala:65: error %s converting file %s to uri", e->message, file);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_free0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp9_ = g_filename_display_basename (file);
	_g_free0 (self->name);
	self->name = _tmp9_;
	_g_free0 (file);
}


static void vbf_file_class_init (VbfFileClass * klass) {
	vbf_file_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = vbf_file_finalize;
}


static void vbf_file_instance_init (VbfFile * self) {
}


static void vbf_file_finalize (GObject* obj) {
	VbfFile * self;
	self = VBF_FILE (obj);
	_g_free0 (self->name);
	_g_free0 (self->filename);
	_g_free0 (self->uri);
	G_OBJECT_CLASS (vbf_file_parent_class)->finalize (obj);
}


GType vbf_file_get_type (void) {
	static volatile gsize vbf_file_type_id__volatile = 0;
	if (g_once_init_enter (&vbf_file_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VbfFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vbf_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VbfFile), 0, (GInstanceInitFunc) vbf_file_instance_init, NULL };
		GType vbf_file_type_id;
		vbf_file_type_id = g_type_register_static (G_TYPE_OBJECT, "VbfFile", &g_define_type_info, 0);
		g_once_init_leave (&vbf_file_type_id__volatile, vbf_file_type_id);
	}
	return vbf_file_type_id__volatile;
}



