/* vbftarget.c generated by valac 0.12.1.1-323029-dirty, the Vala compiler
 * generated from vbftarget.vala, do not modify */

/*
 *  vbftarget.vala - Vala Build Framework library
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VBF_TYPE_TARGET_TYPES (vbf_target_types_get_type ())

#define VBF_TYPE_TARGET (vbf_target_get_type ())
#define VBF_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_TARGET, VbfTarget))
#define VBF_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_TARGET, VbfTargetClass))
#define VBF_IS_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_TARGET))
#define VBF_IS_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_TARGET))
#define VBF_TARGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_TARGET, VbfTargetClass))

typedef struct _VbfTarget VbfTarget;
typedef struct _VbfTargetClass VbfTargetClass;
typedef struct _VbfTargetPrivate VbfTargetPrivate;

#define VBF_TYPE_GROUP (vbf_group_get_type ())
#define VBF_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_GROUP, VbfGroup))
#define VBF_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_GROUP, VbfGroupClass))
#define VBF_IS_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_GROUP))
#define VBF_IS_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_GROUP))
#define VBF_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_GROUP, VbfGroupClass))

typedef struct _VbfGroup VbfGroup;
typedef struct _VbfGroupClass VbfGroupClass;

#define VBF_TYPE_FILE (vbf_file_get_type ())
#define VBF_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_FILE, VbfFile))
#define VBF_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_FILE, VbfFileClass))
#define VBF_IS_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_FILE))
#define VBF_IS_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_FILE))
#define VBF_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_FILE, VbfFileClass))

typedef struct _VbfFile VbfFile;
typedef struct _VbfFileClass VbfFileClass;

#define VBF_TYPE_SOURCE (vbf_source_get_type ())
#define VBF_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_SOURCE, VbfSource))
#define VBF_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_SOURCE, VbfSourceClass))
#define VBF_IS_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_SOURCE))
#define VBF_IS_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_SOURCE))
#define VBF_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_SOURCE, VbfSourceClass))

typedef struct _VbfSource VbfSource;
typedef struct _VbfSourceClass VbfSourceClass;

#define VBF_TYPE_PACKAGE (vbf_package_get_type ())
#define VBF_PACKAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_PACKAGE, VbfPackage))
#define VBF_PACKAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_PACKAGE, VbfPackageClass))
#define VBF_IS_PACKAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_PACKAGE))
#define VBF_IS_PACKAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_PACKAGE))
#define VBF_PACKAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_PACKAGE, VbfPackageClass))

typedef struct _VbfPackage VbfPackage;
typedef struct _VbfPackageClass VbfPackageClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
typedef struct _VbfFilePrivate VbfFilePrivate;

#define VBF_TYPE_FILE_TYPES (vbf_file_types_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _VbfPackagePrivate VbfPackagePrivate;

#define VBF_TYPE_CONFIG_NODE (vbf_config_node_get_type ())
#define VBF_CONFIG_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_CONFIG_NODE, VbfConfigNode))
#define VBF_CONFIG_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_CONFIG_NODE, VbfConfigNodeClass))
#define VBF_IS_CONFIG_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_CONFIG_NODE))
#define VBF_IS_CONFIG_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_CONFIG_NODE))
#define VBF_CONFIG_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_CONFIG_NODE, VbfConfigNodeClass))

typedef struct _VbfConfigNode VbfConfigNode;
typedef struct _VbfConfigNodeClass VbfConfigNodeClass;

#define VBF_TYPE_MODULE (vbf_module_get_type ())
#define VBF_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_MODULE, VbfModule))
#define VBF_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_MODULE, VbfModuleClass))
#define VBF_IS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_MODULE))
#define VBF_IS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_MODULE))
#define VBF_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_MODULE, VbfModuleClass))

typedef struct _VbfModule VbfModule;
typedef struct _VbfModuleClass VbfModuleClass;

typedef enum  {
	VBF_TARGET_TYPES_PROGRAM,
	VBF_TARGET_TYPES_LIBRARY,
	VBF_TARGET_TYPES_DATA,
	VBF_TARGET_TYPES_BUILT_SOURCES
} VbfTargetTypes;

struct _VbfTarget {
	GObject parent_instance;
	VbfTargetPrivate * priv;
	gchar* id;
	gchar* name;
	VbfTargetTypes type;
	gboolean no_install;
	VbfGroup* group;
};

struct _VbfTargetClass {
	GObjectClass parent_class;
};

struct _VbfTargetPrivate {
	ValaList* sources;
	ValaList* files;
	ValaList* packages;
	ValaList* include_dirs;
	ValaList* built_libraries;
};

typedef enum  {
	VBF_FILE_TYPES_UNKNOWN,
	VBF_FILE_TYPES_DATA,
	VBF_FILE_TYPES_VALA_SOURCE,
	VBF_FILE_TYPES_OTHER_SOURCE
} VbfFileTypes;

struct _VbfFile {
	GObject parent_instance;
	VbfFilePrivate * priv;
	gchar* name;
	gchar* filename;
	gchar* uri;
	VbfFileTypes type;
	VbfTarget* target;
};

struct _VbfFileClass {
	GObjectClass parent_class;
};

struct _VbfPackage {
	GObject parent_instance;
	VbfPackagePrivate * priv;
	gchar* id;
	gchar* name;
	gchar* constraint;
	VbfConfigNode* version;
	VbfTarget* parent_target;
	VbfGroup* parent_group;
	VbfModule* parent_module;
};

struct _VbfPackageClass {
	GObjectClass parent_class;
};


static gpointer vbf_target_parent_class = NULL;

GType vbf_target_types_get_type (void) G_GNUC_CONST;
GType vbf_target_get_type (void) G_GNUC_CONST;
GType vbf_group_get_type (void) G_GNUC_CONST;
GType vbf_file_get_type (void) G_GNUC_CONST;
GType vbf_source_get_type (void) G_GNUC_CONST;
GType vbf_package_get_type (void) G_GNUC_CONST;
#define VBF_TARGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VBF_TYPE_TARGET, VbfTargetPrivate))
enum  {
	VBF_TARGET_DUMMY_PROPERTY
};
VbfTarget* vbf_target_new (VbfGroup* group, VbfTargetTypes type, const gchar* id, const gchar* name);
VbfTarget* vbf_target_construct (GType object_type, VbfGroup* group, VbfTargetTypes type, const gchar* id, const gchar* name);
ValaList* vbf_target_get_sources (VbfTarget* self);
VbfSource* vbf_target_get_source (VbfTarget* self, const gchar* filename);
GType vbf_file_types_get_type (void) G_GNUC_CONST;
gboolean vbf_target_has_sources_of_type (VbfTarget* self, VbfFileTypes type);
void vbf_target_add_source (VbfTarget* self, VbfSource* source);
void vbf_target_remove_source (VbfTarget* self, VbfSource* source);
gboolean vbf_target_has_file_of_type (VbfTarget* self, VbfFileTypes type);
gboolean vbf_target_has_file_with_extension (VbfTarget* self, const gchar* extension);
ValaList* vbf_target_get_files (VbfTarget* self);
void vbf_target_add_file (VbfTarget* self, VbfFile* file);
ValaList* vbf_target_get_packages (VbfTarget* self);
void vbf_target_add_package (VbfTarget* self, VbfPackage* package);
GType vbf_config_node_get_type (void) G_GNUC_CONST;
GType vbf_module_get_type (void) G_GNUC_CONST;
gboolean vbf_target_contains_package (VbfTarget* self, const gchar* package_id);
ValaList* vbf_target_get_include_dirs (VbfTarget* self);
gboolean vbf_target_contains_include_dir (VbfTarget* self, const gchar* dir);
void vbf_target_add_include_dir (VbfTarget* self, const gchar* dir);
ValaList* vbf_target_get_built_libraries (VbfTarget* self);
void vbf_target_add_built_library (VbfTarget* self, const gchar* dir);
static void vbf_target_finalize (GObject* obj);


GType vbf_target_types_get_type (void) {
	static volatile gsize vbf_target_types_type_id__volatile = 0;
	if (g_once_init_enter (&vbf_target_types_type_id__volatile)) {
		static const GEnumValue values[] = {{VBF_TARGET_TYPES_PROGRAM, "VBF_TARGET_TYPES_PROGRAM", "program"}, {VBF_TARGET_TYPES_LIBRARY, "VBF_TARGET_TYPES_LIBRARY", "library"}, {VBF_TARGET_TYPES_DATA, "VBF_TARGET_TYPES_DATA", "data"}, {VBF_TARGET_TYPES_BUILT_SOURCES, "VBF_TARGET_TYPES_BUILT_SOURCES", "built-sources"}, {0, NULL, NULL}};
		GType vbf_target_types_type_id;
		vbf_target_types_type_id = g_enum_register_static ("VbfTargetTypes", values);
		g_once_init_leave (&vbf_target_types_type_id__volatile, vbf_target_types_type_id);
	}
	return vbf_target_types_type_id__volatile;
}


VbfTarget* vbf_target_construct (GType object_type, VbfGroup* group, VbfTargetTypes type, const gchar* id, const gchar* name) {
	VbfTarget * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (VbfTarget*) g_object_new (object_type, NULL);
	self->group = group;
	_tmp0_ = g_strdup (id);
	_g_free0 (self->id);
	self->id = _tmp0_;
	_tmp1_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp1_;
	self->type = type;
	return self;
}


VbfTarget* vbf_target_new (VbfGroup* group, VbfTargetTypes type, const gchar* id, const gchar* name) {
	return vbf_target_construct (VBF_TYPE_TARGET, group, type, id, name);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vbf_target_get_sources (VbfTarget* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->sources);
	result = _tmp0_;
	return result;
}


VbfSource* vbf_target_get_source (VbfTarget* self, const gchar* filename) {
	VbfSource* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	{
		ValaList* _tmp0_;
		ValaList* _source_list;
		gint _tmp1_;
		gint _source_size;
		gint _source_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->sources);
		_source_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _source_list);
		_source_size = _tmp1_;
		_source_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			VbfSource* source;
			_source_index = _source_index + 1;
			if (!(_source_index < _source_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_source_list, _source_index);
			source = (VbfSource*) _tmp2_;
			if (g_strcmp0 (((VbfFile*) source)->filename, filename) == 0) {
				result = source;
				_vala_iterable_unref0 (_source_list);
				return result;
			}
			_g_object_unref0 (source);
		}
		_vala_iterable_unref0 (_source_list);
	}
	result = NULL;
	return result;
}


gboolean vbf_target_has_sources_of_type (VbfTarget* self, VbfFileTypes type) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		ValaList* _tmp0_;
		ValaList* _source_list;
		gint _tmp1_;
		gint _source_size;
		gint _source_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->sources);
		_source_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _source_list);
		_source_size = _tmp1_;
		_source_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			VbfSource* source;
			_source_index = _source_index + 1;
			if (!(_source_index < _source_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_source_list, _source_index);
			source = (VbfSource*) _tmp2_;
			if (((VbfFile*) source)->type == type) {
				result = TRUE;
				_g_object_unref0 (source);
				_vala_iterable_unref0 (_source_list);
				return result;
			}
			_g_object_unref0 (source);
		}
		_vala_iterable_unref0 (_source_list);
	}
	result = FALSE;
	return result;
}


void vbf_target_add_source (VbfTarget* self, VbfSource* source) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	vala_collection_add ((ValaCollection*) self->priv->sources, source);
}


void vbf_target_remove_source (VbfTarget* self, VbfSource* source) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	vala_collection_remove ((ValaCollection*) self->priv->sources, source);
}


gboolean vbf_target_has_file_of_type (VbfTarget* self, VbfFileTypes type) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		ValaList* _tmp0_;
		ValaList* _file_list;
		gint _tmp1_;
		gint _file_size;
		gint _file_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->files);
		_file_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _file_list);
		_file_size = _tmp1_;
		_file_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			VbfFile* file;
			_file_index = _file_index + 1;
			if (!(_file_index < _file_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_file_list, _file_index);
			file = (VbfFile*) _tmp2_;
			if (file->type == type) {
				result = TRUE;
				_g_object_unref0 (file);
				_vala_iterable_unref0 (_file_list);
				return result;
			}
			_g_object_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	result = FALSE;
	return result;
}


gboolean vbf_target_has_file_with_extension (VbfTarget* self, const gchar* extension) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* ext;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (extension != NULL, FALSE);
	_tmp0_ = g_strdup_printf (".%s", extension);
	ext = _tmp0_;
	{
		ValaList* _tmp1_;
		ValaList* _file_list;
		gint _tmp2_;
		gint _file_size;
		gint _file_index;
		_tmp1_ = _vala_iterable_ref0 (self->priv->files);
		_file_list = _tmp1_;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _file_list);
		_file_size = _tmp2_;
		_file_index = -1;
		while (TRUE) {
			gpointer _tmp3_ = NULL;
			VbfFile* file;
			gboolean _tmp4_;
			_file_index = _file_index + 1;
			if (!(_file_index < _file_size)) {
				break;
			}
			_tmp3_ = vala_list_get (_file_list, _file_index);
			file = (VbfFile*) _tmp3_;
			_tmp4_ = g_str_has_suffix (file->filename, ext);
			if (_tmp4_) {
				result = TRUE;
				_g_object_unref0 (file);
				_vala_iterable_unref0 (_file_list);
				_g_free0 (ext);
				return result;
			}
			_g_object_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	result = FALSE;
	_g_free0 (ext);
	return result;
}


ValaList* vbf_target_get_files (VbfTarget* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->files);
	result = _tmp0_;
	return result;
}


void vbf_target_add_file (VbfTarget* self, VbfFile* file) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	vala_collection_add ((ValaCollection*) self->priv->files, file);
}


ValaList* vbf_target_get_packages (VbfTarget* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->packages);
	result = _tmp0_;
	return result;
}


void vbf_target_add_package (VbfTarget* self, VbfPackage* package) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (package != NULL);
	vala_collection_add ((ValaCollection*) self->priv->packages, package);
	package->parent_target = self;
}


gboolean vbf_target_contains_package (VbfTarget* self, const gchar* package_id) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (package_id != NULL, FALSE);
	{
		ValaList* _tmp0_;
		ValaList* _package_list;
		gint _tmp1_;
		gint _package_size;
		gint _package_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->packages);
		_package_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _package_list);
		_package_size = _tmp1_;
		_package_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			VbfPackage* package;
			_package_index = _package_index + 1;
			if (!(_package_index < _package_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_package_list, _package_index);
			package = (VbfPackage*) _tmp2_;
			if (g_strcmp0 (package->id, package_id) == 0) {
				result = TRUE;
				_g_object_unref0 (package);
				_vala_iterable_unref0 (_package_list);
				return result;
			}
			_g_object_unref0 (package);
		}
		_vala_iterable_unref0 (_package_list);
	}
	result = FALSE;
	return result;
}


ValaList* vbf_target_get_include_dirs (VbfTarget* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->include_dirs);
	result = _tmp0_;
	return result;
}


gboolean vbf_target_contains_include_dir (VbfTarget* self, const gchar* dir) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dir != NULL, FALSE);
	{
		ValaList* _tmp0_;
		ValaList* _item_list;
		gint _tmp1_;
		gint _item_size;
		gint _item_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->include_dirs);
		_item_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _item_list);
		_item_size = _tmp1_;
		_item_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			gchar* item;
			_item_index = _item_index + 1;
			if (!(_item_index < _item_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_item_list, _item_index);
			item = (gchar*) _tmp2_;
			if (g_strcmp0 (item, dir) == 0) {
				result = TRUE;
				_g_free0 (item);
				_vala_iterable_unref0 (_item_list);
				return result;
			}
			_g_free0 (item);
		}
		_vala_iterable_unref0 (_item_list);
	}
	result = FALSE;
	return result;
}


void vbf_target_add_include_dir (VbfTarget* self, const gchar* dir) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	vala_collection_add ((ValaCollection*) self->priv->include_dirs, dir);
}


ValaList* vbf_target_get_built_libraries (VbfTarget* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->built_libraries);
	result = _tmp0_;
	return result;
}


void vbf_target_add_built_library (VbfTarget* self, const gchar* dir) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	vala_collection_add ((ValaCollection*) self->priv->built_libraries, dir);
}


static void vbf_target_class_init (VbfTargetClass * klass) {
	vbf_target_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VbfTargetPrivate));
	G_OBJECT_CLASS (klass)->finalize = vbf_target_finalize;
}


static void vbf_target_instance_init (VbfTarget * self) {
	ValaArrayList* _tmp0_ = NULL;
	ValaArrayList* _tmp1_ = NULL;
	ValaArrayList* _tmp2_ = NULL;
	ValaArrayList* _tmp3_ = NULL;
	ValaArrayList* _tmp4_ = NULL;
	self->priv = VBF_TARGET_GET_PRIVATE (self);
	self->no_install = FALSE;
	_tmp0_ = vala_array_list_new (VBF_TYPE_SOURCE, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	self->priv->sources = (ValaList*) _tmp0_;
	_tmp1_ = vala_array_list_new (VBF_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	self->priv->files = (ValaList*) _tmp1_;
	_tmp2_ = vala_array_list_new (VBF_TYPE_PACKAGE, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	self->priv->packages = (ValaList*) _tmp2_;
	_tmp3_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	self->priv->include_dirs = (ValaList*) _tmp3_;
	_tmp4_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	self->priv->built_libraries = (ValaList*) _tmp4_;
}


static void vbf_target_finalize (GObject* obj) {
	VbfTarget * self;
	self = VBF_TARGET (obj);
	_g_free0 (self->id);
	_g_free0 (self->name);
	_vala_iterable_unref0 (self->priv->sources);
	_vala_iterable_unref0 (self->priv->files);
	_vala_iterable_unref0 (self->priv->packages);
	_vala_iterable_unref0 (self->priv->include_dirs);
	_vala_iterable_unref0 (self->priv->built_libraries);
	G_OBJECT_CLASS (vbf_target_parent_class)->finalize (obj);
}


GType vbf_target_get_type (void) {
	static volatile gsize vbf_target_type_id__volatile = 0;
	if (g_once_init_enter (&vbf_target_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VbfTargetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vbf_target_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VbfTarget), 0, (GInstanceInitFunc) vbf_target_instance_init, NULL };
		GType vbf_target_type_id;
		vbf_target_type_id = g_type_register_static (G_TYPE_OBJECT, "VbfTarget", &g_define_type_info, 0);
		g_once_init_leave (&vbf_target_type_id__volatile, vbf_target_type_id);
	}
	return vbf_target_type_id__volatile;
}



