/*
 * Copyright (C) 1999 Jonathan R. Hudson
 * Developed by Jonathan R. Hudson <jrhudson@bigfoot.com>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <vdk/vdk.h>
#include <stdlib.h>
#include <sys/types.h>
#include "input.h"


class MyApp: public VDKApplication
{
  protected:
    static void plumber(int);
    static MyApp *me;    
  public:
    char **args;
    MyApp(int* argc, char** argv):
        VDKApplication(argc,argv), args(argv+1) {}
    ~MyApp() {}
    void Setup();
}; 

#define IO_NONE 0
#define IO_STDOUT 1

class MyForm: public VDKForm
{
  private:
    VDKLabelButton *quit;
    VDKText *text;
    VDKEntry *entry;
    VDKTimer *timer;
    
    bool Quit(VDKObject*);
    bool runcmd (VDKObject*);
    bool DoIO (VDKObject*);
    bool Stop (VDKObject*);    
    bool CanClose(void);
    bool Mourn(VDKObject*);
    bool sendstuff(VDKObject*);    
    
  public:
    MyForm(VDKApplication* app, gchar* title):
        VDKForm(app,title),  timer(0), inp1(0){}
    ~MyForm() { }
    void Setup(void); 
    inline  VDKText * Text() {return text;}
    void ShowInfanticide();
    VDKInput *inp1;
    Socket *sock;
    
    DECLARE_SIGNAL_MAP(MyForm);  
    DECLARE_SIGNAL_LIST(MyForm);
};
