/*
file: rangewin.cc
*/ 
#include "rangewin.h"


static char buff[64];
DEFINE_SIGNAL_MAP(RangeWin,VDKForm)
  ON_SIGNAL(h_slider,value_changed_signal,HandleSliders),
  ON_SIGNAL(v_slider,value_changed_signal,HandleSliders),
  ON_SIGNAL(month,value_changed_signal,HandleSpins),
  ON_SIGNAL(day,value_changed_signal,HandleSpins),
  ON_SIGNAL(year,value_changed_signal,HandleSpins),
  ON_SIGNAL(month,focus_out_signal,HandleSpins),
  ON_SIGNAL(day,focus_out_signal,HandleSpins),
  ON_SIGNAL(year,focus_out_signal,HandleSpins) 
END_SIGNAL_MAP
 
void  
RangeWin::Setup()
{ 
calendardate today;
VDKBox* box = new VDKBox(this,v_box);
 VDKBox* vbox1 = new VDKBox(this,v_box);
  h_slider = new VDKSlider(this,10,10,90,.2,h_box,200,30);
  vbox1->Add(h_slider);
box->Add(vbox1);
box->Add(new VDKSeparator(this));
 VDKBox* hbox = new VDKBox(this,h_box);
 v_slider = new VDKSlider(this,0,0,1,0.1,v_box,40,200);
 v_slider->Digits = 3;  
 hbox->Add(v_slider,l_justify,FALSE,FALSE,0); 
 VDKFrame* frame = new VDKFrame(this,"Spins",v_box,shadow_etched_in);
  frame->Add(new VDKLabel(this,"Month"));
  month = new VDKSpinButton(this,
			    float(today.Month()), // default value
			    1.0, // lower bound
			    12.0, // upper bound
			    1.0, // step
			    0.0); // climb
  month->Digits = 0;
  frame->Add(month);
  frame->Add(new VDKLabel(this,"Day"));
  day = new VDKSpinButton(this,
			    float(today.Day()), // default value
			    1.0, // lower bound
			    31.0, // upper bound
			    1.0, // step
			    0.0); // climb
  day->Digits = 0;
  frame->Add(day);
  frame->Add(new VDKLabel(this,"Year"));
  year = new VDKSpinButton(this,
			    float(today.Year()), // default value
			    1900, // lower bound
			    2100, // upper bound
			    1.0, // step
			    0.0); // climb
  year->Digits = 0;
  frame->Add(year); 
  frame->Add(date_label = new VDKLabel(this,""));
 hbox->Add(frame);
box->Add(hbox);
box->Add(new VDKSeparator(this)); 
sprintf(buff,"Slider value: %.3f", float(h_slider->Value));
box->Add(label = new VDKLabel(this,buff)); 
h_slider->Foreground = clSiena;
v_slider->Foreground = clNavyBlue; 
Add(box); 
}   
 
 
bool RangeWin::HandleSliders(VDKObject* s)
{
VDKSlider* sender = dynamic_cast<VDKSlider*>(s);
if(!sender)
  return true;
sprintf(buff,"%s Slider value:%.3f",
	sender == h_slider ? "Hor." : "Vert.",
	(float) sender->Value);
label->Caption = buff;
return true;
}

bool RangeWin::HandleSpins(VDKObject* s)
{
VDKSpinButton* sender = dynamic_cast<VDKSpinButton*>(s);
if(!sender)
  return true;
calendardate date(day->ValueAsInt,
		  month->ValueAsInt,
		  year->ValueAsInt);
if(date.Valid())
  date_label->Caption = date.CalendarDate();
else
  date_label->Caption = "Invalid date";
return true;
} 


 
 
