/* gtkiconfileselection - gtkiconfileselection dialog widget for gtk+
 * Copyright 1999-2001  Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <sys/types.h>
#include <sys/stat.h>
#define HAVE_DIRENT_H
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_DIRENT_H
#include <dirent.h>
#endif

#include <string.h>
#include <vdk/gtkiconfilesel.h>

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif

#ifndef MAXPATHLEN
#define MAXPATHLEN 1024
#endif

static void gtk_icon_file_selection_class_init          (GtkIconFileSelClass *klass);
static void gtk_icon_file_selection_init                (GtkIconFileSel *filesel);
static void open_dir					(GtkWidget *widget, 
							 GtkCTreeNode *node, 
							 gint n,
                                                         gpointer data);
static void entry_set_file				(GtkWidget *widget, 
							 GdkEventKey *key, 
							 gpointer data);
static void real_set_file				(GtkWidget *widget, 
							 gpointer data);
static void set_filter					(GtkWidget *widget, 
                                                         GdkEventKey *key,
							 gpointer data);
static void select_icon					(GtkIconList *iconlist, 
            						 GtkIconListItem *icon,
            						 GdkEvent *event, 
							 gpointer data);
static void insert_text     				(GtkEditable *editable,
                 					 const gchar *new_text,
                 					 gint  new_text_length,
                 					 gint  *position,
                 					 gpointer data);
static GtkWindowClass *parent_class = NULL;


GtkType
gtk_icon_file_selection_get_type (void)
{
  static GtkType filesel_type = 0;
  
  if (!filesel_type)
    {
      GtkTypeInfo filesel_info =
      {
	"GtkIconFileSel",
	sizeof (GtkIconFileSel),
	sizeof (GtkIconFileSelClass),
	(GtkClassInitFunc) gtk_icon_file_selection_class_init,
	(GtkObjectInitFunc) gtk_icon_file_selection_init,
	/* reserved_1 */ NULL,
        /* reserved_2 */ NULL,
        (GtkClassInitFunc) NULL,
      };
      
      filesel_type = gtk_type_unique (gtk_window_get_type(), &filesel_info);
    }
  
  return filesel_type;
}

GtkWidget*
gtk_icon_file_selection_new (const gchar *title)
{
  GtkWidget *widget;

  widget = gtk_widget_new (gtk_icon_file_selection_get_type(), NULL);

/*  GTK_ICON_FILESEL(widget)->title = g_strdup(title);
*/
  gtk_window_set_title(GTK_WINDOW(widget),title);
  return widget;
}

static void
gtk_icon_file_selection_class_init (GtkIconFileSelClass *klass)
{
  GtkWidgetClass *widget_class;
  
  widget_class = (GtkWidgetClass*) klass;
  parent_class = gtk_type_class (gtk_window_get_type ());
 
}

static void
gtk_icon_file_selection_init (GtkIconFileSel *filesel)
{
  GtkWidget *main_vbox;
  GtkWidget *hbox, *box;
  GtkWidget *table;
  GtkWidget *label;
  GtkWidget *scrolled_window;

  gtk_window_set_policy(GTK_WINDOW(filesel), FALSE, FALSE, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (filesel), 10);

  main_vbox=gtk_vbox_new(FALSE,1);
  gtk_container_set_border_width(GTK_CONTAINER(main_vbox),0);
  gtk_container_add(GTK_CONTAINER(filesel), main_vbox);
  gtk_widget_show(main_vbox);

  filesel->path_label = gtk_label_new(G_DIR_SEPARATOR_S);
  gtk_misc_set_alignment(GTK_MISC(filesel->path_label), 0., .5);
  gtk_box_pack_start(GTK_BOX(main_vbox), filesel->path_label, TRUE, TRUE, 0);
  gtk_widget_show(filesel->path_label);

  hbox=gtk_hbox_new(FALSE,1);
  gtk_box_pack_start(GTK_BOX(main_vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show(hbox);

  scrolled_window=gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_set_usize(scrolled_window, 200, 250);
  gtk_box_pack_start(GTK_BOX(hbox), scrolled_window, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window),
                                 GTK_POLICY_AUTOMATIC,
                                 GTK_POLICY_AUTOMATIC);

  filesel->dir_tree = gtk_dir_tree_new();
  gtk_container_add(GTK_CONTAINER(scrolled_window), filesel->dir_tree);
  gtk_widget_show(filesel->dir_tree);
  gtk_widget_show(scrolled_window);

  gtk_box_pack_start(GTK_BOX(hbox), gtk_vseparator_new(), TRUE, TRUE, 0);

  scrolled_window=gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_set_usize(scrolled_window, 380, 250);
  gtk_box_pack_start(GTK_BOX(hbox), scrolled_window, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window),
                                 GTK_POLICY_AUTOMATIC,
                                 GTK_POLICY_AUTOMATIC);

  filesel->file_list = gtk_file_list_new(20, GTK_ICON_LIST_TEXT_RIGHT, G_DIR_SEPARATOR_S);
  GTK_ICON_LIST(filesel->file_list)->is_editable =  FALSE;
  GTK_FILE_LIST(filesel->file_list)->show_folders = FALSE;
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_window), 
                                        filesel->file_list);
  gtk_widget_show(filesel->file_list);
  gtk_widget_show(scrolled_window);

  gtk_signal_connect(GTK_OBJECT(filesel->dir_tree), "tree_select_row",
                     GTK_SIGNAL_FUNC(open_dir), filesel);

  gtk_signal_connect(GTK_OBJECT(filesel->file_list), "select_icon",
                     GTK_SIGNAL_FUNC(select_icon), filesel);

  filesel->action_area = table = gtk_table_new(TRUE, 2, 4);
  gtk_box_pack_start(GTK_BOX(main_vbox), table, TRUE, TRUE, 3);
  gtk_widget_show(table);

  label = gtk_label_new("File:        ");
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
  gtk_table_attach_defaults(GTK_TABLE(table),
                            label,
                            0, 1, 0, 1);
  gtk_widget_show(label);

  label = gtk_label_new("Filter:        ");
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
  gtk_table_attach_defaults(GTK_TABLE(table),
                            label,
                            0, 1, 1, 2);
  gtk_widget_show(label);

  filesel->file_entry = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(table), filesel->file_entry, 1, 3, 0, 1);
  gtk_widget_show(filesel->file_entry);

  gtk_signal_connect(GTK_OBJECT(filesel->file_entry), "key_press_event",
                     GTK_SIGNAL_FUNC(entry_set_file), filesel);

  filesel->filter_entry = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(table), filesel->filter_entry, 1, 3, 1, 2);
  gtk_widget_show(filesel->filter_entry);

  gtk_signal_connect(GTK_OBJECT(filesel->filter_entry), "key_press_event",
                     GTK_SIGNAL_FUNC(set_filter), filesel);

  gtk_signal_connect(GTK_OBJECT(filesel->filter_entry), "insert_text",
                     GTK_SIGNAL_FUNC(insert_text), NULL);

  box = gtk_vbutton_box_new();
  gtk_table_attach_defaults(GTK_TABLE(table), box, 3, 4, 0, 2);
  gtk_widget_show(box);

  filesel->ok_button = gtk_button_new_with_label("OK");
  gtk_box_pack_end (GTK_BOX (box), filesel->ok_button, TRUE, TRUE, 0);
  gtk_widget_show(filesel->ok_button);

  gtk_signal_connect(GTK_OBJECT(filesel->ok_button), "clicked",
                     GTK_SIGNAL_FUNC(real_set_file), filesel);

  filesel->cancel_button = gtk_button_new_with_label("Cancel");
  gtk_box_pack_end (GTK_BOX (box), filesel->cancel_button, TRUE, TRUE, 0);
  gtk_widget_show(filesel->cancel_button);
}

static void
insert_text     (GtkEditable *editable,
                 const gchar *new_text,
                 gint         new_text_length,
                 gint        *position,
                 gpointer data)
{
  gtk_signal_emit_stop_by_name(GTK_OBJECT(editable), "insert_text");
  if(new_text[0] != ' '){
     GTK_EDITABLE_CLASS (gtk_type_class(GTK_TYPE_ENTRY))->insert_text(editable,
                                                              new_text,
                                                              new_text_length, 
                                                              position);


  }

}

static void
select_icon(GtkIconList *iconlist, 
            GtkIconListItem *icon,
            GdkEvent *event, gpointer data)
{
  GtkIconFileSel *filesel;

  filesel = GTK_ICON_FILESEL(data);
  gtk_entry_set_text(GTK_ENTRY(filesel->file_entry),
                     icon->label);

}

static void
entry_set_file(GtkWidget *widget, GdkEventKey *key, gpointer data)
{

  if(key->keyval != GDK_Return && key->keyval != GDK_KP_Enter) return;

  real_set_file(widget, data);
}

static void
real_set_file(GtkWidget *widget, gpointer data)
{
  GtkIconFileSel *filesel;
  GtkIconListItem *item;
  GList *list;
  gchar *c, *last, *text;
  gchar *folder;
  gchar *file;
  gint nlen, file_len;

  filesel = (GtkIconFileSel *)data;

  c = gtk_entry_get_text(GTK_ENTRY(filesel->file_entry));
  folder = NULL;
  file = NULL;
  last = NULL;
  file_len = nlen = 0;

  while(*c != '\0' && *c != '\n' && c != NULL){
   nlen++;
   file_len++;
   folder = (char *)g_realloc(folder, (nlen+1)*sizeof(char));
   folder[nlen-1] = *c;
   folder[nlen]='\0';
   file = (char *)g_realloc(file, (file_len+1)*sizeof(char));
   file[file_len-1] = *c;
   file[file_len]='\0';
   if(*c == G_DIR_SEPARATOR){
       g_free(file);
       g_free(last);
       last = g_strdup(folder);
       file_len = 0;
       file = NULL;
   }
   c++;
  }

  if(last) gtk_icon_file_selection_open_dir(filesel, last); 

  if(file){
    list = GTK_ICON_LIST(filesel->file_list)->icons;
    while(list){
      item = (GtkIconListItem *)list->data;
      text = ((GtkFileListItem *)item->link)->file_name;
      if(strcmp(text, file) == 0){
         gtk_icon_list_select_icon(GTK_ICON_LIST(filesel->file_list), item);
         break;
      }
      list = list->next;
    }
  }


  g_free(folder);
  g_free(file);
  g_free(last);
}

static void
set_filter(GtkWidget *widget, GdkEventKey *key, gpointer data)
{
  GtkIconFileSel *filesel;

  if(key->keyval != GDK_Return && key->keyval != GDK_KP_Enter) return;

  filesel = (GtkIconFileSel *)data;
  gtk_file_list_set_filter(GTK_FILE_LIST(filesel->file_list), 
                           gtk_entry_get_text(GTK_ENTRY(widget)));
}

static void
open_dir(GtkWidget *widget, GtkCTreeNode *node, gint n, gpointer data)
{
  DIR *dir;
  GtkDirTreeNode *dirnode;
  gchar *path, *last_path;
  GtkIconFileSel *filesel;

  filesel = GTK_ICON_FILESEL(data);


  dirnode=gtk_ctree_node_get_row_data(GTK_CTREE(widget),node);

  path = dirnode->path;

  last_path = gtk_file_list_get_path(GTK_FILE_LIST(filesel->file_list));

  if(strcmp(last_path, G_DIR_SEPARATOR_S) !=0 && strcmp(last_path, path) == 0) return; 

  gtk_widget_unmap(filesel->file_list);

  if((dir = opendir(path)) == NULL){
    return;
  }
  closedir(dir);

  gtk_label_set(GTK_LABEL(filesel->path_label), "Scanning..............");

  gtk_file_list_open_dir(GTK_FILE_LIST(filesel->file_list), path);

  gtk_widget_map(filesel->file_list);

  gtk_label_set(GTK_LABEL(filesel->path_label), path);
}

gint
gtk_icon_file_selection_open_dir(GtkIconFileSel *filesel, const gchar *path)
{
 
  return (gtk_dir_tree_open_dir(GTK_DIR_TREE(filesel->dir_tree), path));

}

