/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/

#include "vdk/paned.h"
#include "vdk/forms.h"
/*
 */
VDKPaned::VDKPaned(VDKForm* owner,int mode)
  :VDKObjectContainer(owner)
{
  widget = mode == v_box ? gtk_vpaned_new() : gtk_hpaned_new();
  //  ConnectDefaultSignals();
}
/*
 */ 
VDKPaned::~VDKPaned()
{}
/*
 */
void 
VDKPaned::Add(VDKObject* obj, int pane,
		   int , int , int  )
{
  items.add(obj);
  //BorderWidth(1); 
  if(pane == 1)
    gtk_paned_add1(GTK_PANED(widget),obj->Widget());
  else
    gtk_paned_add2(GTK_PANED(widget),obj->Widget());
  gtk_widget_show(obj->Widget());
  obj->Parent(this);
  obj->Setup();
}

void 
VDKPaned::Pack(VDKObject* obj, int pane , bool resize, bool shrink)
{
  items.add(obj);
  // BorderWidth(1); 
  if(pane == 1)
    gtk_paned_pack1(GTK_PANED(widget),obj->Widget(), resize, shrink);
  else
    gtk_paned_pack2(GTK_PANED(widget),obj->Widget(), resize, shrink);
  gtk_widget_show(obj->Widget());
  obj->Parent(this);
  obj->Setup();
}
