
#include <customtree.h>
/*
defining signal and events
dynamics tables
*/
DEFINE_SIGNAL_LIST(CustomtreeForm,VDKForm);
DEFINE_EVENT_LIST(CustomtreeForm,VDKForm);
/*
defining signal static table
*/
DEFINE_SIGNAL_MAP(CustomtreeForm,VDKForm)
ON_SIGNAL(tree,select_node_signal,ShowSelection),
ON_SIGNAL(remove,clicked_signal,RemoveSelection),
ON_SIGNAL(build,clicked_signal,BuildTree),
ON_SIGNAL(clear,clicked_signal,ClearTree),
ON_SIGNAL(expand,clicked_signal,ExpandNode)
END_SIGNAL_MAP
/*
main form setup
*/
void
CustomtreeForm::GUISetup(void)
{
	SetSize(306,234);
	Title = "Custom tree example";
hbox17 = new VDKBox(this,h_box);
Add(hbox17,0,1,1,0);
vbox18 = new VDKBox(this,v_box);
vbox18->SetSize(210,230);
hbox17->Add(vbox18,0,1,1,0);
vbox18->BorderWidth(0);
char* treeTitles[] = { "Folders & files" };
tree = new VDKCustomTree(this,1,treeTitles,(GtkSelectionMode) 0);
tree->SetSize(210,230);
vbox18->Add(tree,0,1,1,0);
vbox19 = new VDKBox(this,v_box);
vbox19->SetSize(94,230);
hbox17->Add(vbox19,0,1,1,0);
vbox19->BorderWidth(0);
quit = new VDKLabelButton(this,"Quit");
vbox19->Add(quit,0,1,1,0);
remove = new VDKLabelButton(this,"Remove sel nodes");
vbox19->Add(remove,0,1,1,0);
clear = new VDKLabelButton(this,"Clear tree");
vbox19->Add(clear,0,1,1,0);
build = new VDKLabelButton(this,"Rebuild tree");
vbox19->Add(build,0,1,1,0);
expand = new VDKLabelButton(this,"Expand/Collapse");
vbox19->Add(expand,0,1,1,0);
pixmap0 = new VDKPixmap(this,"vdk-logo.xpm");
vbox19->Add(pixmap0,0,1,1,0);
}

// do not remove this mark: #!#
// end of file:customtree_gui.cc