/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_editor_h
#define _vdkb_editor_h
///////////////////////
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <vdk/vdk.h>
#include <vdkb/vdkb_text.h>
#include <vdkb/vdkb_nbook.h>
#include <vdkb/vdkb_unit.h>
#include <vdkb/vdkb_types.h>
#include <vdk/panelbar.h>

// for safe
#ifndef HAVE_SYNTAX
#undef  HAVE_HINTS
#endif

#ifdef  HAVE_HINTS
//#include <vdk/vdkbtrees.h>
#include <vdk/value_sem_list.h>
struct VDKBHint
{
  VDKString match,text;
  bool operator==(VDKBHint& hint)
    { return match == hint.match; }
  bool operator<(VDKBHint& hint)
    { return match < hint.match; }
} ;
//typedef VDKBtree<VDKBHint> HintDb;
typedef VDKValueList<VDKBHint> HintDb;
#endif

typedef VDKValueList<VDKBText*> TextList;
typedef VDKValueListIterator<VDKBText*> TextListIterator;

class VDKBEditor: public VDKForm
{

 protected:
  VDKPanelbar *bar;
  VDKToolbar * toolbar;
  bool GoToLine(VDKString& file, int line,bool enlight = false);
  VDKMenu *popmenu;
  VDKMenuItem *toggleHeader,*closePage,*fileSave,
    *fileSaveAs,*search,*repeatsearch;
  VDKMenuItem *undo,*redo,*hilite,*shortcut;
  void UpdateUnit(VDKBText* text,VDKString& rep);
  int Replace(VDKBText* text, int pos, char* match, char* replace);
  VDKTimer* autosavetimer;
  VDKHandleBox* handle;
 public:
  //
  TextList    textlist;
  VDKBNotebook *nbook;
  VDKCustomList *messages;
  bool ForceToClose;
  VDKBEditor(VDKForm* owner);
  virtual ~VDKBEditor();
  void Setup();
  void AddNewUnit();
  void AddText(char* text_name, bool editable,bool hilite);
  bool CanClose();
  void OnShow(VDKForm*);
  void ClearMessages();
  void FillMessages(VDKBStringList* list);
  bool Search(VDKObject*);
  bool RepeatSearch(VDKObject*);
  void ReplaceText();
  void UpdateFiles();
  void EnableMaker(bool flag);
  void OnChildClosing(VDKForm* child);
  ///////
  bool OnTextChanged(VDKObject* );
  bool OnPageChanged(VDKObject* );
  bool OnLineChanged(VDKObject* );
  bool JumpToError(VDKObject* );
  bool OnPopMenu(VDKObject* );
  bool OnClosePage(VDKObject* );
  bool OnToggleHeader(VDKObject* );
  bool FileSaveAs(VDKObject* );
  bool FileSave(VDKObject* );
  bool NoMoreUndo(VDKObject*);
  bool Hilite(VDKObject* );
  bool OnAutosaveTimer(VDKObject* );
  bool NewForm(char* name);
  bool WriteFormCC(char* name, FILE* fp);
  bool WriteFormH(char* name,FILE* fp);
  bool WriteFrm(char* fname,FILE* fp);
  bool HandleToolbar(VDKObject*);
  bool Undo(VDKObject*);
  bool UserPrompt(VDKObject*);
  bool OnHandleAttach(VDKObject* sender);
  bool OnHandleDetach(VDKObject* sender);
  bool ShortCut(VDKObject*);
DECLARE_SIGNAL_LIST(VDKBEditor);
DECLARE_SIGNAL_MAP(VDKBEditor);
};
////////////////////////
#endif



