/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_table_h
#define _vdkb_table_h

#include <vdkb/vdkb_evcontain.h>
#include <vdkb/vdkb_evbox.h>
#include <vdk/menu.h>

class VDKBGuiForm;
class VDKBParser;
class VDKBObjectInspector;

class VDKBTable: public VDKBEventContainer
{
 protected:
  VDKMenuItem *delBox;
  VDKMenuItem *addwidget,*delwidget,*setsize;
  // property controls used by object inspector
  VDKSpinButton *rowspacing,*colspacing;
  VDKCheckButton *homogeneous;
  void Init();
  int rows,cols;
  bool homo;
 public:
  static int Counter;
  static int MakeWidget(VDKBGuiForm* owner, GdkEvent* ev = NULL);
  static char* CreateSource(char* buffer,VDKBParser& parser);
  static bool CreateWidget(VDKBGuiForm* owner, char* buffer,
			   VDKBParser& parser);
  VDKObjectContainer*  ExtraWidget(VDKBObjectInspector* isp);
  void WriteOnFrm(FILE* fp, VDKBObject* parentobj);
  VDKBTable(char* name, VDKForm* owner, 
	    int rows, int cols,bool homo);
  VDKBTable(char* name, VDKBEventContainer* outer, 
	    int rows, int cols,bool homo);
  virtual ~VDKBTable() {}
  void AddBox(char* name);
  void PopMenu() { popmenu->Popup(); }
  void Add(VDKObject* wid, int justify,
			int expand, int fill , int padding,
			bool forceArgs);
  bool OnButtonPressed(VDKObject* sender, GdkEvent* event);
  bool DelBox(VDKObject* sender);
  
  virtual int Type() { return vdkbtable_class; }

  virtual int isA() { return vdkbtable_class; }

  void AddWidget(VDKObject* w, int justify = l_justify,
		 int expand = TRUE, int fill = TRUE , 
		 int padding = 0, bool forceArgs = false);

  virtual char* VDKName() { return "VDKTable"; }
  bool SetBoxSize(VDKObject* sender);
  bool OnSetHomogeneous(VDKObject*);
  bool OnRowColSpacing(VDKObject*);
  // designer
  DECLARE_EVENT_LIST(VDKBTable);
  DECLARE_SIGNAL_LIST(VDKBTable);
};

#endif

