/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#ifndef _vdkb_xclist_h
#define _vdkb_xclist_h
#if HAVE_CONFIG_H
#include <config.h>
#endif
#if USE_XDB
#include <vdk/vdk.h>
#include <vdkxdb/vdkxdb.h>
#include <vdkxdb/vdkxtable.h>
#include <vdkxdb/vdkxclist.h>
#include <vdkb/vdkb_object.h>
#include <vdkb/vdkb_widpopmenu.h>
typedef VDKArray<VDKString> TitlesArray;

class VDKBGuiForm;
class VDKBParser;
class VDKBXCustomList: public VDKXCustomList, public VDKBObject
{
 protected:
  VDKBWidgetPopMenu *popmenu;
  VDKMenuItem *setsize,*delwidget;
  VDKBObjectInspector* inspector; // object inspector
  VDKEntry *columnTitle;
  VDKCheckButton *autoresize;
  VDKCombo *shadow,*selmode;
  VDKCustomList* tablelist,*fieldlist;
  VDKCustomButton* assignButton,*assignTableButton,*resetTableButton;
  TitlesArray assigned_fields;
 public:
  TitlesArray column_titles;
  static int Counter;
  static char* CreateSource(char* buffer,VDKBParser& parser);
  static bool CreateWidget(VDKBGuiForm* owner, 
			   char* buffer,VDKBParser& parser);
  static int MakeWidget(VDKBGuiForm* owner, GdkEvent* ev = NULL);
  VDKBXCustomList(char* name,
		 VDKForm* owner, 
		 int cols, 
		 char** titles,
		 GtkSelectionMode mode = GTK_SELECTION_SINGLE);
  virtual ~VDKBXCustomList() {}
  virtual int Type() { return vdkbclass_xclist; }
  virtual char* VDKName() { return "VDKXCustomList"; }
  virtual int isA() { return vdkbclass_xclist; }
  virtual VDKObjectContainer* ExtraWidget(VDKBObjectInspector* isp);
  void AssignFieldsToColumn(char* assignfield,
			    VDKXTable* table);
  bool DelWidget(VDKObject*);
  bool SetWidgetSize(VDKObject* sender);
  bool OnColumnClicked(VDKObject*);
  bool OnSetColumnTitle(VDKObject*);
  bool OnSetAutoResize(VDKObject*);
  bool OnSetShadow(VDKObject*);
  bool OnSetSelectionMode(VDKObject*);
  void PopMenu() { popmenu->Popup(); }
  bool OnAssignButtonClicked(VDKObject*);
  bool OnAssignTableButtonClicked(VDKObject*);
  bool OnResetTableButtonClicked(VDKObject*);
  bool OnTableListSelectRow(VDKObject*);
  bool OnTableListUnselectRow(VDKObject*);
  virtual void WriteOnFrm(FILE* fp,VDKBObject* parentobj);
  DECLARE_SIGNAL_LIST(VDKBXCustomList);
  DECLARE_EVENT_LIST(VDKBXCustomList);
};
#endif
#endif
