/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.7
 * September 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
#define _(str) gettext(str)
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb/vdkb_cbuttdlg.h>

DEFINE_SIGNAL_MAP(VDKBComboButtonDlg,VDKForm)
  ON_SIGNAL(acceptButton,clicked_signal,OnacceptButtonClick),
  ON_SIGNAL(defaultButton,clicked_signal,OndefaultButtonClick)
  END_SIGNAL_MAP
/*
  main form setup
*/
static char *label_position[] = 
{
  "GTK_POS_LEFT",
  "GTK_POS_RIGHT",
  "GTK_POS_TOP",
  "GTK_POS_BOTTOM",
  0
};

void
VDKBComboButtonDlg::GUISetup(void)
{
  SetSize(223,138);
  Title = _("VDKCustomButton Dialog");
  frame0 = new VDKFrame(this,
			_("VDKCustomButton options"),
			v_box,shadow_etched_in);
  Add(frame0,0,1,1,0);
  vbox1 = new VDKBox(this,v_box);
  frame0->Add(vbox1,l_justify,1,1,0);
  vbox1->BorderWidth(0);
  table1 = new VDKTable(this,3,2,false);
  table1->RowSpacing = 2;
  table1->ColSpacing = 2;
  vbox1->Add(table1,0,1,1,0);
  vbox10 = new VDKBox(this,v_box);
  table1->AddToCell(vbox10,0,0);
  pixmapCb = new VDKCheckButton(this,_("pixmapped"));
  vbox10->Add(pixmapCb,0,1,1,0);
  vbox11 = new VDKBox(this,v_box);
  table1->AddToCell(vbox11,0,1);
  label0 = new VDKLabel(this,_("Label position"));
  vbox11->Add(label0,0,1,1,0);
  labelPosCombo = new VDKCombo(this);
  labelPosCombo->SetSize(100,22);
  vbox11->Add(labelPosCombo,0,1,1,0);
  vbox12 = new VDKBox(this,v_box);
  table1->AddToCell(vbox12,1,0);
  VRadioButtonGroup16 = new VDKRadioButtonGroup(this,v_box);
  vbox12->Add(VRadioButtonGroup16,0,1,1,0);
  radiobutton4 = new VDKRadioButton(this,_("untoggled"));
  VRadioButtonGroup16->Add(radiobutton4,0,1,1,0);
  radiobutton6 = new VDKRadioButton(this,_("toggled"));
  VRadioButtonGroup16->Add(radiobutton6,0,1,1,0);
  vbox13 = new VDKBox(this,v_box);
  table1->AddToCell(vbox13,1,1);
  VRadioButtonGroup17 = new VDKRadioButtonGroup(this,v_box);
  vbox13->Add(VRadioButtonGroup17,0,1,1,0);
  radiobutton8 = new VDKRadioButton(this,_("normal"));
  VRadioButtonGroup17->Add(radiobutton8,0,1,1,0);
  radiobutton10 = new VDKRadioButton(this,_("Combo button"));
  VRadioButtonGroup17->Add(radiobutton10,0,1,1,0);
  vbox14 = new VDKBox(this,v_box);
  table1->AddToCell(vbox14,2,0);
  acceptButton = new VDKLabelButton(this,_("Accept"));
  vbox14->Add(acceptButton,0,1,1,0);
  vbox15 = new VDKBox(this,v_box);
  table1->AddToCell(vbox15,2,1);
  defaultButton = new VDKLabelButton(this,_("Defaults"));
  vbox15->Add(defaultButton,0,1,1,0);
}

/*
  main form constructor
*/
VDKBComboButtonDlg::VDKBComboButtonDlg(VDKForm* owner, 
				       char* title,
				       int* pixmapped,
				       unsigned int* type,
				       GtkPositionType* label_pos):
  VDKForm(owner,title),pixmapped(pixmapped),type(type),label_pos(label_pos)
{
  // set defaults;
  *pixmapped = 0;
  *type = VDK_CBUTTON_UNTOGGLED | VDK_CBUTTON_NORMAL;
  *label_pos = GTK_POS_RIGHT;
}

/*
  main form destructor
*/
VDKBComboButtonDlg::~VDKBComboButtonDlg()
{
}

/*
  main form setup
*/
void
VDKBComboButtonDlg::Setup(void)
{
  StringList s;
  int t;
  GUISetup(); // vdkb gui setup
  // put your code below here
  for(t = 0 ;label_position[t];t++)
    s.add(VDKString(label_position[t]));
  labelPosCombo->PopdownStrings = s;
  labelPosCombo->SelectItem((int) GTK_POS_RIGHT);
}

// signal response method 
bool
VDKBComboButtonDlg::OnacceptButtonClick(VDKObject* sender)
{
  int sel;
  *pixmapped = (pixmapCb->Checked == true) ? 1 : 0;
  unsigned int toggled = (VRadioButtonGroup16->Selected == 0) ?
    VDK_CBUTTON_UNTOGGLED : VDK_CBUTTON_TOGGLED;
  unsigned int mode = (VRadioButtonGroup17->Selected) == 0 ?
    VDK_CBUTTON_NORMAL : VDK_CBUTTON_COMBO;
  *type = toggled | mode;
  sel = labelPosCombo->Selected; 
  if(sel < 0)
    *label_pos = GTK_POS_RIGHT;
  else
    *label_pos = (GtkPositionType) sel;
  Close();
  return true;
}

// signal response method 
bool
VDKBComboButtonDlg::OndefaultButtonClick(VDKObject* sender)
{
  Close();
  return true;
}
