/*
 * DVD Player plugin for VDR
 *
 * Copyright (C) 2001.2002 Andreas Schultz <aschultz@warp10.net>
 *
 * This code is distributed under the terms and conditions of the 
 * GNU GENERAL PUBLIC LICENSE. See the file COPYING for details.
 *
 */

#include "i18n.h"

const char *Languages[] = {
    "English",
    "Deutsch",
    "Slovenski",
    "Italiano",
    "Nederlands",
    "Portugus",
    "Franais",
    "Norsk",
    "Suomi",
    "Polski",
    "Espaol",
    "Ellinika",
    "Svenska",
    "Romaneste",
    NULL
};

const char *ISO639code[] = {
  // Language ISO 639 codes for DVD
    "en",
    "de",
    "sl",
    "it",
    "nl",
    "pt",
    "fr",
    "no",
    "fi",
    "pl",
    "es",
    "el",
    "se",
    "ro",
    NULL
};

const tI18nPhrase DvdPhrases[] = {
    {
	"Setup.DVD$Preferred menu language",                 // English
	"Bevorzugte Spache fr Mens",                      // Deutsch
        "", // Slovenski
        "menu - linguaggio preferito",                      // Italiano
        "Taalkeuze voor menu",                              // Nederlands
        "", // Portugus
        "Langage prfr pour les menus",                   // Franais
        "", // Norsk
        "Haluttu valikon kieli",			    // Suomi
        "", // Polski
        "Idioma preferido para los mens",                  // Espaol
        "", // Ellinika
        "", // Svenska
        "", // Romaneste
    },
    {
	"Setup.DVD$Preferred audio language",                // English
        "Bevorzugte Sprache fr Dialog",                    // Deutsch
        "", // Slovenski
        "audio - linguaggio preferito",                     // Italiano
        "Taalkeuze voor geluid",                            // Nederlands
        "", // Portugus
        "Langage prfr pour le son",                      // Franais
        "", // Norsk
        "Haluttu nityksen kieli",			    // Suomi
        "", // Polski
        "Idioma preferido para el sonido",                  // Espaol
        "", // Ellinika
        "", // Svenska
        "", // Romaneste
    },
    {
	"Setup.DVD$Preferred subtitle language",             // English
        "Bevorzugte Spache fr Untertitel",                 // Deutsch
        "", // Slovenski
        "sottotitoli - linguaggio preferito",               // Italiano
        "Taalkeuze voor ondertitels",                       // Nederlands
        "", // Portugus
        "Langage prfr pour les sous-titres",             // Franais
        "", // Norsk
        "Haluttu tekstityksen kieli",			    // Suomi
        "", // Polski
        "Idioma preferido para los subttulos",             // Espaol
        "", // Ellinika
        "", // Svenska
        "", // Romaneste
    },
    {
	"Setup.DVD$Player region code",                     // English
        "Regions Kode fr Player",                          // Deutsch
        "", // Slovenski
        "region code del DVD player",                       // Italiano
        "Regiocode van Speler",                             // Nederlands
        "", // Portugus
        "Code rgion du lecteur",                           // Franais
        "", // Norsk
        "Soittimen aluekoodi",			            // Suomi
        "", // Polski
        "Cdigo de zona del lector",                        // Espaol
        "", // Ellinika
        "", // Svenska
        "", // Romaneste
    },
    {
	"Setup.DVD$Display subtitles",                      // English
        "Untertitel anzeigen",                              // Deutsch
        "", // Slovenski
        "Visualizza sottotitoli",                           // Italiano
        "Toon ondertitels",                                 // Nederlands
        "", // Portugus
        "Affiche les sous-titres",                          // Franais
        "", // Norsk
        "Nyt tekstitys",				    // Suomi
        "", // Polski
        "Mostrar subttulos",                               // Espaol
        "", // Ellinika
        "", // Svenska
        "", // Romaneste
    },
    {
	"Setup.DVD$Hide Mainmenu Entry",
    },
    { NULL }
};


