dnl	AC_FUNC_HASH_MAP
dnl
dnl	By Pierre Sarrazin <http://sarrazip.com/>
dnl	This file is in the public domain.
dnl
dnl	Determines the header file that defines the C++ hash_map type,
dnl	and in which namespace it is defined.
dnl	Defines the macros HASH_MAP_HEADER and HASH_MAP_NAMESPACE with
dnl	these two values.
dnl	Fails if no appropriate values can be found.

AC_DEFUN([AC_FUNC_HASH_MAP],
[
	AC_MSG_CHECKING([how to use C++ hash_map type])

	AC_LANG_SAVE
	AC_LANG_CPLUSPLUS

	hash_map_namespace=
	hash_map_header=

	if test "_$hash_map_namespace" = _; then
		AC_TRY_COMPILE(
		[#include <hash_map>],
		[std::hash_map<int, int> t; return 0;],
		[hash_map_header=hash_map; hash_map_namespace=std]
		[true])
	fi

	if test "_$hash_map_namespace" = _; then
		AC_TRY_COMPILE(
		[#include <ext/hash_map>],
		[std::hash_map<int, int> t; return 0;],
		[hash_map_header=ext/hash_map; hash_map_namespace=std]
		[true])
	fi

	if test "_$hash_map_namespace" = _; then
		AC_TRY_COMPILE(
		[#include <ext/hash_map>],
		[__gnu_cxx::hash_map<int, int> t; return 0;],
		[hash_map_header=ext/hash_map; hash_map_namespace=__gnu_cxx]
		[true])
	fi

	AC_LANG_RESTORE

	if test "_$hash_map_namespace" = _; then
		AC_MSG_ERROR([could not find <hash_map>])
	else
		hash_map_header="<$hash_map_header>"
		AC_MSG_RESULT([header is $hash_map_header, namespace is $hash_map_namespace])
		AC_DEFINE_UNQUOTED(HASH_MAP_HEADER, $hash_map_header,
				[namespace in which hash_map is defined])
		AC_DEFINE_UNQUOTED(HASH_MAP_NAMESPACE, $hash_map_namespace,
				[namespace in which hash_map is defined])
	fi
])
