/*
                Editor List IO, Management, and Utilities
 */

#ifndef EDITORLIST_H
#define EDITORLIST_H

#include <gtk/gtk.h>

#include "v3dmp.h"
#include "v3dmodel.h"
#include "editor.h"


/*
 *	Model header item (real list) setting.
 */
extern void EditorListHeaderSetHeightFieldBaseDir(
        ma_editor_struct *editor,
        const char *path
);
extern char *EditorListHeaderGetHeightFieldBaseDir(ma_editor_struct *editor);
extern void EditorListHeaderSetTextureBaseDir(
        ma_editor_struct *editor,
        const char *path
);
extern char *EditorListHeaderGetTextureBaseDir(ma_editor_struct *editor);

/*
 *	Real list to GUI list item setting.
 */
extern void EditorListPrimitivesSetComment(
	GtkWidget *clist, int row,
	void *p, gbool has_change
);
extern void EditorListPrimitivesSetTranslate(
	GtkWidget *clist, int row,
	void *p, gbool has_change
);
extern void EditorListPrimitivesSetDrawn(
	GtkWidget *clist, int row,
	void *p, gbool has_change
);
extern void EditorListPrimitivesSetColor(
        GtkWidget *clist, int row,
        void *p, gbool has_change
);
extern void EditorListPrimitivesSetTexture(
        GtkWidget *clist, int row,
        void *p, gbool has_change
);
extern void EditorListPrimitivesSetHeightField(
        GtkWidget *clist, int row,
        void *p, gbool has_change
);
extern void EditorListPrimitivesSet(
        GtkWidget *clist, int row,
        void *p, gbool has_change
);

extern void EditorListModelsSet(
        GtkWidget *clist, int row,  
        v3d_model_struct *model, gbool has_change
);


/*
 *	Note, in function names contained here, the G means GUI
 *	displayed list and the R means Real actual list.
 *
 *	For instance GR would mean `GUI to Real', and vice versa.
 */

/* Real list to GUI list adding. */
extern int EditorListAddModelsRG(ma_editor_struct *editor);
extern int EditorListAddPrimitivesRG(
	ma_editor_struct *editor,
	v3d_model_struct *model
);
extern int EditorListAddValuesRG(
        ma_editor_struct *editor, void *p
);

/* Values text prompts IO. */
extern int EditorListValuePromptApply(
        ma_editor_struct *editor, GtkWidget *entry, gbool record_undo
);
/* Values text prompts IO. */
extern int EditorListValuePromptFetch(
        ma_editor_struct *editor,
	void *p
);


/* List item deletion. */
extern void EditorListDeleteModelsG(ma_editor_struct *editor);
extern void EditorListDeletePrimitivesG(ma_editor_struct *editor);
extern void EditorListDeleteValuesG(ma_editor_struct *editor);

extern void EditorListDeleteAllLists(ma_editor_struct *editor);



#endif	/* EDITORLIST_H */
