/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                             A N N O T A T E . C                              *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 2000                   *
*                                                                              *
********************************************************************************
*
* $Id: annotate.c,v 1.4 2000/12/10 15:01:05 jrh Exp $
* $Log: annotate.c,v $
* Revision 1.4  2000/12/10 15:01:05  jrh
* Release 2.3
*
* Revision 1.3  1999/05/24 01:24:31  jrh
* Release 2.2.1
*
* Revision 1.2  1999/02/07 21:43:52  jrh
* Release 2.2
*
* Revision 1.1  1998/01/26 00:33:05  jrh
* Initial revision
*
*/
#include<stdio.h>
#include<string.h>
#include<X11/StringDefs.h>
#include<X11/cursorfont.h>
#include<Xm/Xm.h>
#include<Xm/Text.h>
#include "viewmol.h"

void modifyAnnotation(int, int, int);
void getAnnotation(Widget, caddr_t, caddr_t);
int  makeAnnotation(int, int, float, float, float, int, const GLfloat *, int,
                    int, char *);
void deleteAnnotation(int *);
void moveAnnotation(int);
void setAnnotation(Widget, caddr_t, XmDrawingAreaCallbackStruct *);
int TextGetBaseline(Widget);

static Widget text;
static int active=(-1);

extern void redraw(int);
extern void pixelToWorld(int, double *, double *);
extern void setCursor(Widget, unsigned int);
extern int StringWidth(XFontStruct *, char *);
extern int StringHeight(XFontStruct *);
extern void *getmem(size_t, size_t);
extern void *expmem(void *, size_t, size_t);
extern void fremem(void **);
extern char *getStringResource(Widget, char *);
extern void getScreenCoordinates(double, double, double, double *, double *,
                                 double *);
extern void modifyGeometry(int, char *);
extern PyLabelSpecObject *label_new(void);

extern struct WINDOW windows[];
extern struct MOLECULE *molecules;
extern struct ANNOTATION *annotation;
extern int nAnnotations, annotate, imol;
extern Pixel stdcol[9];

void modifyAnnotation(int which, int x, int y)
{
  XmFontListEntry entry;
  XmFontList fontlist;
  XmFontType ret;
  XFontStruct *font;
  Dimension height;
  Pixel bg;
  Position xs;
  char str[MAXLENLINE], def[]="variable";
  register int l;
  register char *p; 

  if ((which != (-1)) || annotate)
  {
    if ((p=getStringResource(windows[VIEWER].widget, "font")) == NULL) p=def;
    entry=XmFontListEntryLoad(XtDisplay(windows[VIEWER].widget), p, XmFONT_IS_FONT, "TAG");
    fontlist=XmFontListAppendEntry(NULL, entry);
    font=(XFontStruct *)XmFontListEntryGetFont(entry, &ret);
    XmFontListEntryFree(&entry);
    XtVaGetValues(windows[VIEWER].widget, XtNbackground, &bg, NULL);
    text=XtVaCreateWidget("annotation", xmTextWidgetClass, windows[VIEWER].widget,
                          XmNfontList, fontlist,
                          XmNshadowThickness, 0,
                          XmNmarginWidth, 3,
                          XmNmarginHeight, 0,
                          XmNcolumns, 10,
                          XmNresizeWidth, True,
                          XtNbackground, bg,
                          NULL);
/*  Lesstif does not yet have XmTextGetBaseline implemented */
/*  height=XmTextGetBaseline(text); */
    height=TextGetBaseline(text);
    if (which == (-1)) XtVaSetValues(text, XmNx, x-3, XmNy, y-height-1, NULL);
    if (which != (-1))
    {
      moveAnnotation(which);
      XtVaGetValues(text, XmNx, &xs, NULL);
      l=xs;
      p=annotation[which].text;
      while (*p && (l < x))
      {
        strncpy(str, annotation[which].text, p-annotation[which].text+1);
        p++;
        l=xs+StringWidth(windows[VIEWER].font, str);
      }
      XtVaSetValues(text, XmNvalue, annotation[which].text,
                    XmNcursorPosition, (XmTextPosition)(p-annotation[which].text-1),
                    XmNcolumns, (int)strlen(annotation[which].text),
                    NULL);
      annotation[which].flags&=~DRAWANN;
      active=which;
    }
    XtManageChild(text);
    XtAddCallback(text, XmNactivateCallback, (XtCallbackProc)getAnnotation, NULL);
    XmProcessTraversal(text, XmTRAVERSE_CURRENT);
  }
  setCursor(windows[VIEWER].widget, XC_top_left_arrow);
  annotate=FALSE;
}

void getAnnotation(Widget w, caddr_t dummy, caddr_t call_data)
{
  Dimension h;
  Position x, y;
  const GLfloat black[4] = {0.0, 0.0, 0.0, 0.0};
  double xpix, ypix;
  char *text;

  text=XmTextGetString(w);
  if (*text != '\0')
  {
    XtVaGetValues(w, XmNx, &x, XmNy, &y, NULL);
    pixelToWorld(VIEWER, &xpix, &ypix);
/*  h=XmTextGetBaseline(w); */
    h=TextGetBaseline(w);

    if (active == (-1))
    {
      x+=3;
      y+=h;
      (void)makeAnnotation((-1), COORDINATES, (float)(windows[VIEWER].left+x*xpix),
                           (float)(windows[VIEWER].top-y*ypix), 0.0,
                           stdcol[BLACK], black, EDITABLE | MOVEABLE, 0, text); 
    }
    else
    {
      if (annotation[active].flags & GEOMETRY)
      {
        molecules[imol].internals[annotation[active].userdata].type=
         (-molecules[imol].internals[annotation[active].userdata].type);
        if (strcmp(annotation[active].text, text))
          modifyGeometry(annotation[active].userdata, text);
        deleteAnnotation(&active);
      }
      else
      {
        strcpy(annotation[active].text, text);
        annotation[active].flags|=DRAWANN;
      }
      active=(-1);
    }
  }
  else
    deleteAnnotation(&active);
  XtFree(text);
  XtDestroyWidget(w);
}

int makeAnnotation(int which, int type, float x, float y, float z, int color,
                   const GLfloat color_rgb[4], int flags, int userdata, char *text)
{
  PyLabelSpecObject *newLabel;
  double xpix, ypix;
  register int i;

  if (which == (-1))
  {
    nAnnotations++;
    if (annotation == NULL)
      annotation=(struct ANNOTATION *)getmem(1, sizeof(struct ANNOTATION));
    else
      annotation=(struct ANNOTATION *)expmem((void *)annotation, nAnnotations,
                                             sizeof(struct ANNOTATION));
    which=nAnnotations-1;
  }
  if ((newLabel=label_new()) != NULL)
  {
    newLabel->labelID=which;
    annotation[which].pyObject=newLabel;
  }
  if (text != NULL)
    strncpy(annotation[which].text, text, MAXLENLINE-1);
  if (type == CENTERED)
  {
    pixelToWorld(VIEWER, &xpix, &ypix);
    i=StringHeight(windows[VIEWER].font);
    annotation[which].x=(windows[VIEWER].left+windows[VIEWER].right
                        -xpix*(double)StringWidth(windows[VIEWER].font,
                        annotation[which].text))*0.5;
    annotation[which].y=windows[VIEWER].top-2.*(double)y*ypix*(double)i;
    annotation[which].z=0.0;
  }
  else
  {
    annotation[which].x=x;
    annotation[which].y=y;
    annotation[which].z=z;
  }
  annotation[which].color=color;
  annotation[which].color_rgb[0]=color_rgb[0];
  annotation[which].color_rgb[1]=color_rgb[1];
  annotation[which].color_rgb[2]=color_rgb[2];
  annotation[which].color_rgb[3]=color_rgb[3];
  annotation[which].flags=flags | DRAWANN;
  annotation[which].userdata=userdata;

  return(which);
}

void deleteAnnotation(int *which)
{
  register int i;

  if (*which != (-1))
  {
    Py_DECREF(annotation[*which].pyObject);
  }
  if (*which > (-1) && *which != nAnnotations-1)
  {
    for (i=(*which)+1; i<nAnnotations; i++)
    {
	(annotation[i-1].pyObject)->labelID=i-1;
      annotation[i-1].x=annotation[i].x;
      annotation[i-1].y=annotation[i].y;
      annotation[i-1].z=annotation[i].z;
      annotation[i-1].color=annotation[i].color;
      annotation[i-1].color_rgb[0]=annotation[i].color_rgb[0];
      annotation[i-1].color_rgb[1]=annotation[i].color_rgb[1];
      annotation[i-1].color_rgb[2]=annotation[i].color_rgb[2];
      annotation[i-1].color_rgb[3]=annotation[i].color_rgb[3];
      annotation[i-1].flags=annotation[i].flags;
      annotation[i-1].userdata=annotation[i].userdata;
      strcpy(annotation[i-1].text, annotation[i].text);
    }
  }
  if (*which != (-1))
  {
    nAnnotations--;
    if (nAnnotations)
      annotation=(struct ANNOTATION *)expmem((void *)annotation, nAnnotations,
                  sizeof(struct ANNOTATION));
    else
      fremem((void *)&annotation);
    *which=(-1);
  }
}

void scaleAnnotation(float scale)
{
  register int i;

  for (i=0; i<nAnnotations; i++)
  {
    annotation[i].x*=scale;
    annotation[i].y*=scale;
    annotation[i].z*=scale;
  }
}

void moveAnnotation(int which)
{
  Dimension height;
  double xs, ys, zs;

/*height=XmTextGetBaseline(text);*/
  height=TextGetBaseline(text);
  getScreenCoordinates(annotation[which].x, annotation[which].y,
                       annotation[which].z, &xs, &ys, &zs);
  xs-=3.0;
  ys-=(double)height-1.0;
  XtVaSetValues(text, XmNx, (Position)xs, XmNy, (Position)ys, NULL);
}

void setAnnotation(Widget w, caddr_t data, XmDrawingAreaCallbackStruct *dummy)
{
  setCursor(windows[VIEWER].widget, XC_xterm);
  annotate=TRUE;
  redraw(VIEWER);
}

void destroyAnnotation(void)
{
  XtDestroyWidget(text);
}

int TextGetBaseline(Widget w)
{
  XmFontList fontlist;
  XmFontContext context;
  XmFontListEntry entry;
  XmFontType ret;
  XFontStruct *font=(XFontStruct *)NULL;
  Dimension margin;

  XtVaGetValues(w, XmNfontList, &fontlist, XmNmarginHeight, &margin, NULL);
  if (!XmFontListInitFontContext(&context, fontlist)) return(0);
  if ((entry=XmFontListNextEntry(context)) != NULL)
    font=(XFontStruct *)XmFontListEntryGetFont(entry, &ret);
  XmFontListFreeFontContext(context);
  return(font->ascent+margin+1);
}
