/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                           R E A D G A M E S S . C                            *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 2000                   *
*                                                                              *
********************************************************************************
*
* $Id: readgamess.c,v 1.1 2000/12/10 15:15:13 jrh Exp $
* $Log: readgamess.c,v $
* Revision 1.1  2000/12/10 15:15:13  jrh
* Initial revision
*
*
*/
#include<ctype.h>
#include<stdio.h>
#include<stdlib.h>
#include<string.h>

#define TRUE  1
#define FALSE 0

#define MAXLENLINE 134

int  main(int, char **);
void readBasis(FILE *, int);
void readMOs(int, FILE *);
void readFrq(FILE *, int, int);
int  readOpg(FILE *, int);
void printCoord(double **, char **, int);
void makeLower(char *);
void changeDs(char *);

extern void *getmem(size_t, size_t);
extern void *expmem(void *, size_t, size_t);
extern void fremem(void **);
extern void eof(char *, char *, int);

int main(int argc, char **argv)
{
  FILE *file;
  int found, na, mna=50, cycle=0;
  int freq=FALSE, opt=FALSE, nout=0;
  char line[MAXLENLINE], pgroup[8], *word, *p, *symbol;
  register int i, j, k;

  if ((file=fopen(argv[1], "r")) == NULL) eof("noFile", argv[1], 1);

  /* Check whether it really is a GAMESS output file */

  do
  {
    if (fgets(line, MAXLENLINE, file) == NULL) eof("wrongFiletype", argv[1], 1);
    makeLower(line);
  } while (!strstr(line, "gamess"));

  /* Load Title */

  found=TRUE;
  do
  {
    if (fgets(line, MAXLENLINE, file) == NULL)
    {
	found=FALSE;
      rewind(file);
	break;
    }
  } while (!strstr(line, "RUN TITLE"));
  if (found)
  {
    fgets(line, MAXLENLINE, file);
    fgets(line, MAXLENLINE, file);
    printf("$title\n%s", line);
  }

  /* Load symmetry */

  found=TRUE;
  do
  {
    if (fgets(line, MAXLENLINE, file) == NULL)
    {
	found=FALSE;
      rewind(file);
	break;
    }
  } while (!strstr(line, "THE POINT GROUP OF THE MOLECULE IS"));
  if (found)
  {
    word=strtok(line, " ");
    for (i=0; i<7; i++)
	word=strtok(NULL, " ");
    strcpy(pgroup, word);
    fgets(line, MAXLENLINE, file);
    if (strstr(line, "THE ORDER OF THE PRINCIPAL AXIS IS"))
    {
	word=strtok(line, " ");
	for (i=0; i<7; i++)
	  word=strtok(NULL, " \n");
	if (*word != '0' && (p=strchr(pgroup, 'N')) != NULL) *p=*word;
    }
    printf("$symmetry %s\n", pgroup);
    if (strcmp(pgroup, "C1")) printf("$error onlySymmetricBasis 0\n");
  }

  /* Check run type */
  do
  {
    fgets(line, MAXLENLINE, file);
  } while (!(word=strstr(line, "RUNTYP=")));
  if (!strncmp(word+7, "OPTIMIZE", 8)) opt=TRUE;

  /* Load coordinates */

  rewind(file);
  do
  {
    if (fgets(line, MAXLENLINE, file) == NULL) eof("noCoordinates", argv[1], 1);
  } while (!strstr(line, "ATOM      ATOMIC                      COORDINATES (BOHR)"));
  fgets(line, MAXLENLINE, file);
  fgets(line, MAXLENLINE, file);
  na=0;
  symbol=(char *)getmem((size_t)mna, (size_t)(3*sizeof(char)));
  if (!opt) printf("$coord 0.52917706\n");
  while (line[0] != '\n')
  {
    strncpy(&symbol[3*na], strtok(line, " \t"), 2);
    symbol[3*na+2]='\0';
    if (!opt)
    {
      p=strtok(NULL, " \t");
      p=strtok(NULL, " \t");
      printf("%s ", p);
      p=strtok(NULL, " \t");
      printf("%s ", p);
      p=strtok(NULL, " \t\n");
      printf("%s %s\n", p, &symbol[3*na]);
    }
    na++;
    if (na >= mna)
    {
      mna+=50;
	symbol=(char *)expmem((void *)symbol, (size_t)mna, (size_t)(3*sizeof(char)));
    }
    fgets(line, MAXLENLINE, file);
  }

/* Load optimization history */

  if (opt) cycle=readOpg(file, na);

/* Load basis functions */

  rewind(file);
  do
  {
    fgets(line, MAXLENLINE, file);
  } while (!strstr(line, "ATOMIC BASIS SET"));
  fgets(line, MAXLENLINE, file);
  fgets(line, MAXLENLINE, file);
  fgets(line, MAXLENLINE, file);
  fgets(line, MAXLENLINE, file);
  fgets(line, MAXLENLINE, file);
  fgets(line, MAXLENLINE, file);
  printf("$atoms\n");
  j=1;
  for (i=0; i<na; i++)
  {
    if (symbol[3*i] != '\0')
    {
      printf("%s %d", &symbol[3*i], i+1);
	for (k=i+1; k<na; k++)
	{
	  if (!strncmp(&symbol[3*k], &symbol[3*i], 2))
	  {
	    symbol[3*k]='\0';
	    printf(",%d", k+1);
        }
	}
	printf(" \\\n");
      printf("   basis =%s basis%d\n", &symbol[3*i], j++);
	symbol[3*i]='\0';
    }
  }
  readBasis(file, na);

/* Load orbital energies and symmetries */

  readMOs(cycle, file);

/* Load frequencies and normal modes vectors */

  if (na <= 1) freq=FALSE;
  if (freq) readFrq(file, na, nout);

  printf("$end\n");
  fclose(file);
  return(0);
}

void readBasis(FILE *file, int na)
{
  double *ex, *scoeff, *pcoeff, *dcoeff, *fcoeff;
  int maxpri=20, atom, found;
  char line[MAXLENLINE], shell[3], previous[MAXLENLINE]="";
  char *word, *symbol;
  register int i, j;

  ex=(double *)getmem(maxpri, sizeof(double));
  scoeff=(double *)getmem(maxpri, sizeof(double));
  pcoeff=(double *)getmem(maxpri, sizeof(double));
  dcoeff=(double *)getmem(maxpri, sizeof(double));
  fcoeff=(double *)getmem(maxpri, sizeof(double));
  symbol=(char *)getmem((size_t)na, (size_t)3);

  printf("$basis\n");
  atom=1;
  fgets(line, MAXLENLINE, file);
  while (!strstr(line, "TOTAL NUMBER OF SHELLS"))
  {
    word=strtok(line, " \t");
    strcpy(shell, word);
    strcat(shell, ",");
    if (!strstr(previous, shell))
    {
	found=FALSE;
      printf("*\n%s basis%d\n*\n", word, atom++);
      strcat(previous, word);
      strcat(previous, ",");
    }
    else
      found=TRUE;
    fgets(line, MAXLENLINE, file);
    fgets(line, MAXLENLINE, file);
    do
    {
      i=0;
      while (line[0] != '\n')
      {
        word=strtok(line, " \t");
        strncpy(shell, strtok(NULL, " \t"), 2);
        (void)strtok(NULL, " \t");
	  ex[i]=atof(strtok(NULL, " \t"));
	  switch (shell[0])
	  {
	    case 'S': scoeff[i]=atof(strtok(NULL, " \t"));
	              break;
	    case 'P': pcoeff[i]=atof(strtok(NULL, " \t"));
	              break;
	    case 'L': scoeff[i]=atof(strtok(NULL, " \t"));
			  strcpy(shell, "SP");
			  (void)strtok(NULL, " \t") ;
	  		  (void)strtok(NULL, " \t");
	              pcoeff[i]=atof(strtok(NULL, " \t"));
	              break;
	    case 'D': dcoeff[i]=atof(strtok(NULL, " \t"));
	              break;
	    case 'F': fcoeff[i]=atof(strtok(NULL, " \t"));
	              break;

	  }
	  i++;
	  if (i > maxpri)
  	  {
          maxpri+=20;
          ex=(double *)expmem((void *)ex, maxpri, sizeof(double));
          scoeff=(double *)expmem((void *)scoeff, maxpri, sizeof(double));
          pcoeff=(double *)expmem((void *)pcoeff, maxpri, sizeof(double));
          dcoeff=(double *)expmem((void *)dcoeff, maxpri, sizeof(double));
          fcoeff=(double *)expmem((void *)fcoeff, maxpri, sizeof(double));
	  }
        fgets(line, MAXLENLINE, file);
      }
	if (!found)
	{
        for (word=&shell[0]; *word; word++)
        {
          printf("%4d  %c\n", i, tolower(*word));
          for (j=0; j<i; j++)
          {
            switch (*word)
            {
              case 'S': printf("%15.6f %10.6f\n", ex[j], scoeff[j]);
                        break;
              case 'P': printf("%15.6f %10.6f\n", ex[j], pcoeff[j]);
                        break;
              case 'D': printf("%15.6f %10.6f\n", ex[j], dcoeff[j]);
                        break;
              case 'F': printf("%15.6f %10.6f\n", ex[j], fcoeff[j]);
                        break;
            }
          }
        }
	}
      fgets(line, MAXLENLINE, file);
	if (strstr(line, "TOTAL NUMBER OF SHELLS")) break;
    } while (isalpha(line[7]));
  }

/* To use Spherical Harmonics, i.e. 5d functions, you need
   to include ISPHER=1 in the $CONTRL Section. */

  printf("*\n$pople 6d 10f 15g\n");
  fremem((void **)&ex);
  fremem((void **)&scoeff);
  fremem((void **)&pcoeff);
  fremem((void **)&dcoeff);
  fremem((void **)&fcoeff);
}

void readMOs(int cycle, FILE *file)
{
  double *eorb, *cmo;
  int mno=20, mnc=200, norbital=0, nbasfu=0, nocc=0, offset, found;
  char line[MAXLENLINE], *word, *symorb;
  register int i, j, k;

  rewind(file);
  do
  {
    if (fgets(line, MAXLENLINE, file) == NULL) return;
  } while (!strstr(line, "ORBITALS ARE OCCUPIED"));
  nocc=atoi(strtok(line, " \t"));

  eorb=(double *)getmem((size_t)mno, sizeof(double));
  symorb=(char *)getmem((size_t)mno, 4*sizeof(char));
  cmo=(double *)getmem((size_t)mnc, sizeof(double));

  do
  {
    if (fgets(line, MAXLENLINE, file) == NULL) return;
  } while (!strstr(line, "MOLECULAR ORBITALS"));

  i=j=k=0;
  fgets(line, MAXLENLINE, file);
  fgets(line, MAXLENLINE, file);
  while (TRUE)
  {
    fgets(line, MAXLENLINE, file);
    if (strstr(line, "-----------------") != NULL) break;
    fgets(line, MAXLENLINE, file);

    word=strtok(line, " \t\n");
    while (word)
    {
      eorb[i++]=atof(word);
      if (i >= mno)
      {
        mno+=20;
        eorb=(double *)expmem((void *)eorb, (size_t)mno, sizeof(double));
        symorb=(char *)expmem((void *)symorb, (size_t)mno, 4*sizeof(char));
      }
      word=strtok(NULL, " \t\n");
    }
    fgets(line, MAXLENLINE, file);
    word=strtok(line, " \t\n");
    while (word)
    {
      strncpy(&symorb[j], word, 4);
      j+=4*sizeof(char);
      word=strtok(NULL, " \t\n");
    }
    fgets(line, MAXLENLINE, file);
    while (line[0] != '\n')
    {
      (void)strtok(line, " \t\n");
      (void)strtok(NULL, " \t\n");
      word=strtok(NULL, " \t\n");
	if (word[0] >= '0' && word[0] <= '9') (void)strtok(NULL, " \t\n");
	while ((word=strtok(NULL, " \t")))
	{
        cmo[k]=atof(word);
        if (++k >= mnc)
        {
          mnc+=200;
          cmo=(double *)expmem((void *)cmo, (size_t)mnc, sizeof(double));
        }
	}
      fgets(line, MAXLENLINE, file);
/*    if (strstr(line, " ...... END OF")) break;
	if (strstr(line, "-----------------")) break; */
    }
  }
  norbital=i;
  nbasfu=k/i;

  printf("$scfmo gaussian\n");
  k=0;
  for (i=0; i<norbital; i++)
  {
    word=&symorb[4*i];
    printf("%6d  %s     eigenvalue=%20.14e   nsaos=%d\n", i+1, word, eorb[i], nbasfu);
    if (norbital-i <= norbital % 10)
	offset=norbital % 10;
    else
      offset=10;
    for (j=0; j<nbasfu; j++)
    {
      printf(" %19.14e", cmo[k+j*offset]);
      if ((j+1) % 4 == 0) printf("\n");
    }
    if (j % 4 != 0) printf("\n");
    if ((k+1) % 10 == 0)
	k+=10*nbasfu-9;
    else
	k++;
  }
  fremem((void **)&eorb);
  fremem((void **)&cmo);

  printf("$closed shells\n");
  for (i=0; i<nocc; i++)
  {
    found=FALSE;
    for (j=0; j<nocc; j++)
    {
      if (symorb[4*j] != '\0')
	{
	  strcpy(line, &symorb[4*j]);
	  found=TRUE;
	  break;
      }
    }
    if (found)
    {
      k=0;
      for (j=0; j<nocc; j++)
      {
	  if (!strcmp(&symorb[4*j], line))
	  {
	    k++;
	    symorb[4*j]='\0';
  	  }
      }
      printf(" %s 1-%d\n", line, k);
    }
    else
      break;
  }
  fremem((void **)&symorb);
}

void readFrq(FILE *file, int na, int nout)
{
}

int readOpg(FILE *file, int na)
{
  double *x, *y, *z, *gx, *gy, *gz;
  double energy, gnorm;
  int cycle=0;
  char line[MAXLENLINE], *symbol, *word;
  register int i;

  x=(double *)getmem(na, 6*sizeof(double));
  y=x+na;
  z=y+na;
  gx=z+na;
  gy=gx+na;
  gz=gy+na;
  symbol=(char *)getmem(na, 3*sizeof(char));

  rewind(file);
  word=fgets(line, MAXLENLINE, file);
  while (word)
  {
    do
    {
      if (fgets(line, MAXLENLINE, file) == NULL)
      {
        printCoord(&x, &symbol, na);
        return(cycle);
      }
    } while (!strstr(line, "ENERGY="));
    energy=atof(&line[33]);

    fgets(line, MAXLENLINE, file);
    fgets(line, MAXLENLINE, file);
    fgets(line, MAXLENLINE, file);
    fgets(line, MAXLENLINE, file);
    fgets(line, MAXLENLINE, file);
    fgets(line, MAXLENLINE, file);
    fgets(line, MAXLENLINE, file);
    fgets(line, MAXLENLINE, file);
    fgets(line, MAXLENLINE, file);
    i=0;
    while (line[0] != '\n')
    {
      strtok(line, " \t");
      strncpy(&symbol[3*i], strtok(NULL, " \t"), 2);
      symbol[3*i+2]='\0';
      (void)strtok(NULL, " \t");
      x[i]=atof(strtok(NULL, " \t\n"));
      y[i]=atof(strtok(NULL, " \t\n"));
      z[i]=atof(strtok(NULL, " \t\n"));
      gx[i]=atof(strtok(NULL, " \t\n"));
      gy[i]=atof(strtok(NULL, " \t\n"));
      gz[i]=atof(strtok(NULL, " \t\n"));
      i++;
      fgets(line, MAXLENLINE, file);
    }
    word=fgets(line, MAXLENLINE, file);
    (void)strtok(line, " \t");
    (void)strtok(NULL, " \t");
    (void)strtok(NULL, " \t");
    (void)strtok(NULL, " \t");
    (void)strtok(NULL, " \t");
    (void)strtok(NULL, " \t");
    (void)strtok(NULL, " \t");
    gnorm=atof(strtok(NULL, " \t"));
    if (!cycle++) printf("$grad\n");
    printf("  cycle = %3d    SCF energy = %17.10f   |dE/xyz| = %9.6f\n", cycle, energy, gnorm);
    for (i=0; i<na; i++)
      printf("%22.14f%22.14f%22.14f  %s\n", x[i], y[i], z[i], &symbol[3*i]);
    for (i=0; i<na; i++)
      printf("%22.14e%22.14e%22.14e\n", gx[i], gy[i], gz[i]);
  }
  return(cycle);
}

void printCoord(double **coord, char **symbol, int na)
{
  double *x, *y, *z;
  char *s;
  register int i;

  x=*coord;
  y=x+na;
  z=y+na;
  s=*symbol;
  printf("$coord 0.52917706\n");
  for (i=0; i<na; i++)
    printf("%22.14f%22.14f%22.14f  %s\n", x[i], y[i], z[i], &s[3*i]);

  fremem((void **)coord);
  fremem((void **)symbol);
}

void makeLower(char *line)
{
  char *p=line;

  while (*p)
  {
    *p=tolower(*p);
    p++;
  }
}

void changeDs(char *line)
{
  char *p;

  p=line;
  while (*p)
  {
    if (*p == 'D') *p='e';
    if (*p == '\n') *p='\0';
    p++;
  }
}
