/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                            R U N S C R I P T . C                             *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 2000                   *
*                                                                              *
********************************************************************************
*
* $Id: runscript.c,v 1.1 2000/12/10 15:16:22 jrh Exp $
* $Log: runscript.c,v $
* Revision 1.1  2000/12/10 15:16:22  jrh
* Initial revision
*
*/
#include<stdio.h>
#include<Xm/Xm.h>
#include "viewmol.h"
#include "dialog.h"

extern char *selectFile(char *, char *, int);
extern char *getStringResource(Widget, char *);
extern int messgb(Widget, int, char *, struct PushButtonRow *, int);
extern void GetMessageBoxButton(Widget, XtPointer, caddr_t);

extern Widget topShell;
extern int pythonInterrupt;

void runScript(Widget w, caddr_t data, XmAnyCallbackStruct *dummy)
{
  FILE *file;
  static struct PushButtonRow buttons[] = {{"continue", GetMessageBoxButton, (XtPointer)0, NULL}};
  static char *filename="";
  char line[MAXLENLINE], *word;

  if ((char *)data == NULL)
    filename=selectFile("*.py", filename, TRUE);
  else
    filename=(char *)data;

  if (filename != NULL)
  {
    if ((file=fopen(filename, "r")) == NULL)
    {
	word=getStringResource(topShell, "noFile");
	sprintf(line, word, filename);
	(void)messgb(topShell, 1, line, buttons, 1);
    }
    else
    {
	pythonInterrupt=FALSE;
      PyRun_SimpleFile(file, filename);
	fclose(file);
    }
  }
}
