/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef SMITHVIEW_H
#define SMITHVIEW_H

#include <GraphView.h>

#include <qwidget.h>
#include <qpainter.h>
#include <qprinter.h>
#include <qstring.h>
#include <qlist.h>
#include <math.h>

class SmithView : public GraphView
{
public:
  SmithView( const char * name=0, WFlags f=0 );
  virtual ~SmithView();
  
  void setOrigin(TComplex value);
  
  virtual void draw( QPainter * );
  virtual void drawCursors( QPainter* p );
  
protected:
  virtual void print( QPainter * );
  virtual QPoint  toClient( TReal xValue, TReal yValue );
  virtual TComplex fromClient( int x, int y );
  virtual TComplex transformCoordinates( TComplex coord );
  virtual bool isInsideView( const QPoint& p );
  virtual void computeScaling( QPainter* p );
  virtual void setDefaults();
  
private:
  void rCircle(QPainter *p, double r );
  void xCircle(QPainter *p, double x);
  void drawGrid(QPainter* p);
  
private:
  TReal reOrigin_;
  TReal imOrigin_;
  
  int width_;
  int height_;
  int gap_;
  int radius_;
  int xOrigin_;
  int yOrigin_;
  
  QRect cursorLegendRect_;
  
};

#endif
