/* -*- C++ -*-
   
  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
*/

#include <DrawingFrame.h>

#include <GraphView.h>

#include <qpainter.h>
#include <iostream>

using namespace std;

//----------------------------------------------------------------------------
DrawingFrame::DrawingFrame(GraphView& parent, const char *name )
    : QFrame(&parent,name),
    needsRedraw_(true),
    view_(parent)
{
  setBackgroundColor( white );
}

//----------------------------------------------------------------------------
DrawingFrame::~DrawingFrame()
{}

//----------------------------------------------------------------------------
void DrawingFrame::mouseMoveEvent( QMouseEvent* e)
{
  view_.mouseMoveEvent(e);
  repaint( FALSE );
}

//----------------------------------------------------------------------------
void DrawingFrame::mousePressEvent( QMouseEvent* e)
{
  view_.mousePressEvent(e);
  repaint( FALSE );
}

//----------------------------------------------------------------------------
void DrawingFrame::drawContents( QPainter * p)
{
  if (needsRedraw_)
    {
      QPainter painter;
      painter.begin(&buffer_);
      view_.draw(&painter);
      painter.end();
      needsRedraw_ = false;
    }
  bitBlt(this, 0, 0, &buffer_);
  view_.drawCursors(p);
}

//----------------------------------------------------------------------------
void DrawingFrame::resizeEvent( QResizeEvent* event )
{
  buffer_.resize(event->size());
  reDraw();
}

//----------------------------------------------------------------------------
void DrawingFrame::clear()
{
  buffer_.fill(white);
  needsRedraw_ = TRUE;
}

//----------------------------------------------------------------------------
void DrawingFrame::reDraw()
{
  clear();
  QPainter painter(this);
  drawContents(&painter);
}
