/* -*- C++ -*-
 
  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
*/

#include <Strings.h>

#include <qobject.h>
#include <qapplication.h>

#include <iostream>

const QString Strings::LanguageName = QT_TR_NOOP("LanguageName");

const QString Strings::MainWindowName = "MAIN_WINDOW";
const QString Strings::SchematicWindowName = "SCHEMATIC_WINDOW";
const QString Strings::NavigationWindowName = "NAVIGATION_WINDOW";
const QString Strings::ToolBarName = "TOOL_BAR";
const QString Strings::SymbolBarName = "SYMBOL_BAR";

const QString Strings::MainWindowTitle = QT_TR_NOOP("ViPEC");
const QString Strings::HelpWindowTitle = QT_TR_NOOP("ViPEC online help");
const QString Strings::NewSchematicWindowTitle = QT_TR_NOOP("Schematic name");
const QString Strings::AboutWindowTitle = QT_TR_NOOP("About ViPEC");
const QString Strings::AboutQtWindowTitle = QT_TR_NOOP("About Qt");
const QString Strings::NewVariableWindowTitle = QT_TR_NOOP("Add new variable");
const QString Strings::ModifySweepWindowTitle = QT_TR_NOOP("Modify frequency sweep");
const QString Strings::ModifyGridWindowTitle = QT_TR_NOOP("Modify grid");
const QString Strings::ModifySmithWindowTitle = QT_TR_NOOP("Modify Smith chart");
const QString Strings::ChangeVariableWindowTitle = QT_TR_NOOP("Change variable value");
const QString Strings::RenameVariableWindowTitle = QT_TR_NOOP("Rename variable");
const QString Strings::RenameSubstrateWindowTitle = QT_TR_NOOP("Rename substrate");
const QString Strings::ChangeDimensionWindowTitle = QT_TR_NOOP("Change dimension value");
const QString Strings::EditComponentAttributesWindowTitle = QT_TR_NOOP("Edit component attributes");
const QString Strings::RenameSchematicWindowTitle = QT_TR_NOOP("Rename schematic");
const QString Strings::NewGraphViewWindowTitle = QT_TR_NOOP("Add new graph");
const QString Strings::RenameGraphViewWindowTitle = QT_TR_NOOP("Rename grid");
const QString Strings::RemoveGraphViewWindowTitle = QT_TR_NOOP("Delete grid");
const QString Strings::MicroStripCalcWindowTitle = QT_TR_NOOP("Micro strip calculator");
const QString Strings::SchematicSizeWindowTitle = QT_TR_NOOP("Change schematic size");
const QString Strings::CircuitTunerWindowTitle = QT_TR_NOOP("Circuit tuner");
const QString Strings::DefineSubstrateWindowTitle = QT_TR_NOOP("Define substrate");
const QString Strings::OutputParameterDefinitionWindowTitle = QT_TR_NOOP("Output parameter definition");
const QString Strings::SetupLanguageWindowTitle = QT_TR_NOOP("Select Language");

const QString Strings::StatusMessageReady = QT_TR_NOOP("Ready ...");
const QString Strings::StatusMessageFileSaved = QT_TR_NOOP("File saved");
const QString Strings::StatusMessageFileLoaded = QT_TR_NOOP("File loaded");
const QString Strings::StatusMessageCheckingSchematic = QT_TR_NOOP("Checking schematic %1 ...");
const QString Strings::StatusMessageSweepingSchematic = QT_TR_NOOP("Calculating response of schematic %1 ...");
const QString Strings::StatusMessageSweepingDone = QT_TR_NOOP("Frequency sweep done ...");
const QString Strings::StatusMessageSchematicsOk = QT_TR_NOOP("All schematics passed checks ...");

const QString Strings::MenuLabelFile = QT_TR_NOOP("&File");
const QString Strings::MenuLabelOpen = QT_TR_NOOP("&Open ...");
const QString Strings::MenuLabelSave = QT_TR_NOOP("&Save");
const QString Strings::MenuLabelSaveAs = QT_TR_NOOP("Save &as ...");
const QString Strings::MenuLabelClose = QT_TR_NOOP("&Close");
const QString Strings::MenuLabelNewSchematic = QT_TR_NOOP("&New schematic ...");
const QString Strings::MenuLabelPrint = QT_TR_NOOP("&Print");
const QString Strings::MenuLabelQuit = QT_TR_NOOP("&Quit");
const QString Strings::MenuLabelControls = QT_TR_NOOP("&Controls");
const QString Strings::MenuLabelHelp = QT_TR_NOOP("&Help");
const QString Strings::MenuLabelIndex = QT_TR_NOOP("&Index");
const QString Strings::MenuLabelAbout = QT_TR_NOOP("&About");
const QString Strings::MenuLabelAboutQt = QT_TR_NOOP("About &Qt");
const QString Strings::MenuLabelNewItem = QT_TR_NOOP("&New item...");
const QString Strings::MenuLabelChangeItem = QT_TR_NOOP("&Modify item ...");
const QString Strings::MenuLabelRenameItem = QT_TR_NOOP("&Rename item ...");
const QString Strings::MenuLabelDeleteItem = QT_TR_NOOP("&Delete item");
const QString Strings::MenuLabelTools = QT_TR_NOOP("&Tools");
const QString Strings::MenuLabelMicroStripCalc = QT_TR_NOOP("&Micro strip calculator ...");
const QString Strings::MenuLabelTuner = QT_TR_NOOP("&Tuner ...");
const QString Strings::MenuLabelView = QT_TR_NOOP("&View");
const QString Strings::MenuLabelRefresh = QT_TR_NOOP("&Refresh");
const QString Strings::MenuLabelMarkers = QT_TR_NOOP("&Markers");
const QString Strings::MenuLabelToggle = QT_TR_NOOP("&Toggle");
const QString Strings::MenuLabelFonts = QT_TR_NOOP("&Fonts");
const QString Strings::MenuLabelTitleFont = QT_TR_NOOP("&Title font ...");
const QString Strings::MenuLabelLabelFont = QT_TR_NOOP("&Label font ...");
const QString Strings::MenuLabelSetup = QT_TR_NOOP("&Setup");
const QString Strings::MenuLabelLanguage = QT_TR_NOOP("&Langauge");

const QString Strings::MsgConfirmLooseChanges = QT_TR_NOOP("Your current changes are not saved! Do you wish to continue?");
const QString Strings::MsgCouldNotWriteFile = QT_TR_NOOP("Could not write file!");
const QString Strings::MsgCouldNotOpenFile = QT_TR_NOOP("Could not open file!");
const QString Strings::MsgNewSchematicName = QT_TR_NOOP("Please enter a name for the schematic");
const QString Strings::MsgSchematicAlreadyExists = QT_TR_NOOP("A schematic with that name already exists!");
const QString Strings::MsgNewVariableName = QT_TR_NOOP("Please enter a name for the new variable");
const QString Strings::MsgVariableAlreadyExists = QT_TR_NOOP("A variable with that name already exists!");
const QString Strings::MsgEnterVariableValue = QT_TR_NOOP("Please enter a value for the new variable");
const QString Strings::MsgChangeVariableValue = QT_TR_NOOP("Please enter a new value for the variable named %1");
const QString Strings::MsgRenameVariable = QT_TR_NOOP("Please enter a new name for the variable named %1");
const QString Strings::MsgConfirmDeleteVariable = QT_TR_NOOP("Do you really want to remove the variable named %1?");
const QString Strings::MsgRenameSubstrate = QT_TR_NOOP("Please enter a new name for the substrate named %1");
const QString Strings::MsgConfirmDeleteSubstrate = QT_TR_NOOP("Do you really want to remove the substrate named %1?");
const QString Strings::MsgFloatingNodes =  QT_TR_NOOP("There are some floating nodes!");
const QString Strings::MsgPortNodesShorted =  QT_TR_NOOP("Some port nodes are shorted together!");
const QString Strings::MsgRenameSchematic = QT_TR_NOOP("Please enter a new name for the schematic named %1");
const QString Strings::MsgConfirmDeleteSchematic = QT_TR_NOOP("Do you really want to remove the schematic named %1?");
const QString Strings::MsgNewGraphView = QT_TR_NOOP("Please enter a name for the graph");
const QString Strings::MsgRenameGraphView = QT_TR_NOOP("Please enter a new name for the graph named %1");
const QString Strings::MsgGraphAlreadyExists = QT_TR_NOOP("A graph with the name %1 already exists!");
const QString Strings::MsgConfirmDeleteGraphView = QT_TR_NOOP("Do you really want to remove the graph named %1?");
const QString Strings::MsgNoSchematicsDefined = QT_TR_NOOP("There are no schematics defined!");
const QString Strings::MsgNoRangeVariables = QT_TR_NOOP("There are no range variables defined!");
const QString Strings::MsgMissingAttrValue = QT_TR_NOOP("Missing attribute value in circuit %1!");
const QString Strings::MsgUndefinedVariable = QT_TR_NOOP("Undefined variable in cicuit %1!");
const QString Strings::MsgVariableHasNoValue = QT_TR_NOOP("Variable used in circuit %1 has no value!");
const QString Strings::MsgUndefinedSubstrate = QT_TR_NOOP("Undefined substrate in circuit %1!");
const QString Strings::MsgUnknownException = QT_TR_NOOP("Unknown exception!!!");
const QString Strings::MsgOutputContainsInvalidCircuit = QT_TR_NOOP("The output definitions contains an invalid circuit name!");
const QString Strings::MsgStabilityFactorOnlyFor2Port = QT_TR_NOOP("Stability factors are only defined for 2 port circuits!");
const QString Strings::MsgNoSolutionForCircuit = QT_TR_NOOP("Singular matrix - no solution possible!");
const QString Strings::MsgNumberOfPortsDoesNotMatch = QT_TR_NOOP("The number of ports are not matched!");
const QString Strings::MsgUndefinedBlock = QT_TR_NOOP("Undefined block in circuit %1!");
const QString Strings::MsgSweepBeyondBlockRange = QT_TR_NOOP("Sweep frequency beyond limits of block data in circuit %1");
const QString Strings::MsgTakeEffectWhenRestarted = QT_TR_NOOP("New settings will take effect when ViPEC is restarted");

const QString Strings::LabelApplicationName = "ViPEC";
const QString Strings::LabelFilenameFilter = QT_TR_NOOP("Circuit files (*.ckt)");
const QString Strings::LabelOk = QT_TR_NOOP("&Ok");
const QString Strings::LabelYes = QT_TR_NOOP("&Yes");
const QString Strings::LabelCancel = QT_TR_NOOP("&Cancel");
const QString Strings::LabelSweep = QT_TR_NOOP("&Sweep");
const QString Strings::LabelClose = QT_TR_NOOP("&Close");
const QString Strings::LabelSmall = QT_TR_NOOP("Small");
const QString Strings::LabelMedium = QT_TR_NOOP("Medium");
const QString Strings::LabelLarge = QT_TR_NOOP("Large");
const QString Strings::LabelNavigation = QT_TR_NOOP("Navigation");
const QString Strings::LabelGraphName = QT_TR_NOOP("Graph name");
const QString Strings::LabelGraphType = QT_TR_NOOP("Graph type");
const QString Strings::LabelRectangleGraphType = QT_TR_NOOP("Rectangular");
const QString Strings::LabelSmithGraphType = QT_TR_NOOP("Smith chart");
const QString Strings::LabelTableGraphType = QT_TR_NOOP("Table");
const QString Strings::LabelGridTitle = QT_TR_NOOP("Grid title");
const QString Strings::LabelSmithTitle = QT_TR_NOOP("Smith chart title");
const QString Strings::LabelMinXAxisInput = QT_TR_NOOP("Minimum X axis value");
const QString Strings::LabelMaxXAxisInput = QT_TR_NOOP("Maximum X axis value");
const QString Strings::LabelNoXAxisTicks = QT_TR_NOOP("Number of X axis ticks");
const QString Strings::LabelMinYAxisInput = QT_TR_NOOP("Minimum Y axis value");
const QString Strings::LabelMaxYAxisInput = QT_TR_NOOP("Maximum Y axis value");
const QString Strings::LabelNoYAxisTicks = QT_TR_NOOP("Number of Y axis ticks");
const QString Strings::LabelPortParameters = QT_TR_NOOP("Port parameters");
const QString Strings::LabelLinvillStablilityFactor = QT_TR_NOOP("Linvill stability factor");
const QString Strings::LabelSternStabilityFactor = QT_TR_NOOP("Stern stability factor");
const QString Strings::LabelS_Parameters = QT_TR_NOOP("S-Parameters");
const QString Strings::LabelY_Parameters = QT_TR_NOOP("Y-Parameters");
const QString Strings::LabelZ_Parameters = QT_TR_NOOP("Z-Parameters");
const QString Strings::LabelGroupDelay = QT_TR_NOOP("Group delay");
const QString Strings::LabelMeasurementType = QT_TR_NOOP("Measurement type");
const QString Strings::LabelMeasurement = QT_TR_NOOP("Measurement");
const QString Strings::LabelFormat = QT_TR_NOOP("Format");
const QString Strings::LabelReal = QT_TR_NOOP("Real");
const QString Strings::LabelImag = QT_TR_NOOP("Imag");
const QString Strings::LabelMagnitude = QT_TR_NOOP("Mag");
const QString Strings::LabelAngle = QT_TR_NOOP("Ang");
const QString Strings::LabelResultsInDB = QT_TR_NOOP("Results in DB");
const QString Strings::LabelDataSource = QT_TR_NOOP("Data source");
const QString Strings::LabelToPort = QT_TR_NOOP("To port");
const QString Strings::LabelFromPort = QT_TR_NOOP("From port");
const QString Strings::LabelTrackProjFreq = QT_TR_NOOP("X-axis tracks project frequency");
const QString Strings::LabelAutoSweep = QT_TR_NOOP("Auto sweep");
const QString Strings::LabelSubstrateName = QT_TR_NOOP("Substrate name");
const QString Strings::LabelSubstrateType = QT_TR_NOOP("Substrate type");
const QString Strings::LabelMicroStripType = QT_TR_NOOP("Microstrip");
const QString Strings::LabelStripLineType = QT_TR_NOOP("Stripline");
const QString Strings::LabelDielectricConst = QT_TR_NOOP("Dielectric constant (Er)");
const QString Strings::LabelHeight = QT_TR_NOOP("Height (H)");
const QString Strings::LabelConductorThickness = QT_TR_NOOP("Conductor thickness (T)");
const QString Strings::LabelLossTangent = QT_TR_NOOP("Loss tangent (rho)");
const QString Strings::LabelSchematicSize = QT_TR_NOOP("Schematic size");
const QString Strings::LabelLanguage = QT_TR_NOOP("Language");

const QString Strings::TooltipOpenFile = QT_TR_NOOP("Open File");
const QString Strings::TooltipSaveFile = QT_TR_NOOP("Save File");
const QString Strings::TooltipNewSchematic = QT_TR_NOOP("New schematic");
const QString Strings::TooltipPlaceSymbol = QT_TR_NOOP("Place symbol");
const QString Strings::TooltipLineSymbol = QT_TR_NOOP("Connect symbols");
const QString Strings::TooltipToggleGrid = QT_TR_NOOP("Toggle grid");
const QString Strings::TooltipToggleText = QT_TR_NOOP("Toggle component text");
const QString Strings::TooltipRotateSymbol = QT_TR_NOOP("Rotate symbol");
const QString Strings::TooltipSweepCircuit = QT_TR_NOOP("Sweep");
const QString Strings::TooltipDeleteSymbol = QT_TR_NOOP("Delete symbol");

const QString Strings::PortCatagory = QT_TR_NOOP("Port components");
const QString Strings::BlockCatagory = QT_TR_NOOP("Block components");
const QString Strings::LumpedCatagory = QT_TR_NOOP("Lumped components");
const QString Strings::TransmissionLineCatagory = QT_TR_NOOP("Transmission line components");

const QString Strings::VccsName = QT_TR_NOOP("VCCS");
const QString Strings::GyratorName = QT_TR_NOOP("GYRATOR");
const QString Strings::ResistorName = QT_TR_NOOP("RESISTOR");
const QString Strings::CapacitorName = QT_TR_NOOP("CAPACITOR");
const QString Strings::CapacitorQName = QT_TR_NOOP("CAPACITORQ");
const QString Strings::InductorName = QT_TR_NOOP("INDUCTOR");
const QString Strings::InductorQName = QT_TR_NOOP("INDUCTORQ");
const QString Strings::InductorMName = QT_TR_NOOP("INDUCTORM");
const QString Strings::TransistorName = QT_TR_NOOP("TRANSISTOR");
const QString Strings::TLin2PortName = QT_TR_NOOP("TLIN2PORT");
const QString Strings::TLin4PortName = QT_TR_NOOP("TLIN4PORT");
const QString Strings::TLinPhysicalName = QT_TR_NOOP("TLINPHYSICAL");
const QString Strings::CLinName = QT_TR_NOOP("CLIN");
const QString Strings::SignalGndName = QT_TR_NOOP("GND");
const QString Strings::SignalPortName = QT_TR_NOOP("PORT");
const QString Strings::Block1PortName = QT_TR_NOOP("BLOCK1PORT");
const QString Strings::Block2PortName = QT_TR_NOOP("BLOCK2PORT");

const QString Strings::TreeItemSchematics = QT_TR_NOOP("Schematics");
const QString Strings::TreeItemSweep = QT_TR_NOOP("Project frequencies");
const QString Strings::TreeItemGraphs = QT_TR_NOOP("Graphs");
const QString Strings::TreeItemVariables = QT_TR_NOOP("Variables");
const QString Strings::TreeItemDimensions = QT_TR_NOOP("Units");
const QString Strings::TreeItemSubstrates = QT_TR_NOOP("Substrate definitions");
const QString Strings::TreeItemDataFiles = QT_TR_NOOP("Data files");

const QString Strings::EmptyFileName = QT_TR_NOOP("noname.ckt");
const QString Strings::ParameterFileFilter = QT_TR_NOOP("Parameter files (*.?2p)");

const QString Strings::SweepType = QT_TR_NOOP("Sweep type");
const QString Strings::SweepLinearType = QT_TR_NOOP("Linear");
const QString Strings::SweepLogType = QT_TR_NOOP("Logarithmic");
const QString Strings::SweepStartFrequency = QT_TR_NOOP("Start frequency");
const QString Strings::SweepStopFrequency = QT_TR_NOOP("Stop frequency");
const QString Strings::SweepNumberOfPoints = QT_TR_NOOP("Number of points");

const QString Strings::FrequencyDim = QT_TR_NOOP("Frequency");
const QString Strings::ResistanceDim = QT_TR_NOOP("Resistance");
const QString Strings::CapacitanceDim = QT_TR_NOOP("Capacitance");
const QString Strings::InductanceDim = QT_TR_NOOP("Inductance");
const QString Strings::AngularDim = QT_TR_NOOP("Angle");
const QString Strings::LengthDim = QT_TR_NOOP("Length");
const QString Strings::TimeDim = QT_TR_NOOP("Time");

const QString Strings::AttrResistance = QT_TR_NOOP("Resistance");
const QString Strings::AttrCapacitance = QT_TR_NOOP("Capacitance");
const QString Strings::AttrInductance = QT_TR_NOOP("Inductance");
const QString Strings::AttrPrimaryInductance = QT_TR_NOOP("Primary inductance (L1)");
const QString Strings::AttrSecondaryInductance = QT_TR_NOOP("Secondary inductance (L2)");
const QString Strings::AttrImpedance = QT_TR_NOOP("Impedance");
const QString Strings::AttrCoupleFactor = QT_TR_NOOP("Coupling factor");
const QString Strings::AttrOddModeImpedance = QT_TR_NOOP("Odd mode impedance");
const QString Strings::AttrEvenModeImpedance = QT_TR_NOOP("Even mode impedance");
const QString Strings::AttrElectricalLng = QT_TR_NOOP("Electrical length in degrees");
const QString Strings::AttrElectricalLngFreq = QT_TR_NOOP("Frequency at which electrical length is defined");
const QString Strings::AttrSubstrateName = QT_TR_NOOP("Substrate");
const QString Strings::AttrPortImpedance = QT_TR_NOOP("Port impedance");
const QString Strings::AttrBlockname = QT_TR_NOOP("Block name");
const QString Strings::AttrQFactor = QT_TR_NOOP("Quality factor");
const QString Strings::AttrTransConductance = QT_TR_NOOP("Trans conductance");
const QString Strings::AttrGyratorFactor = QT_TR_NOOP("Gyrator factor");
const QString Strings::AttrLineWidth = QT_TR_NOOP("Line width");
const QString Strings::AttrLineLength = QT_TR_NOOP("Line length");

const QString Strings::CalcDielectricConstant = QT_TR_NOOP("&Dielectric constant");
const QString Strings::CalcSubstraceHeight = QT_TR_NOOP("&Substrate height");
const QString Strings::CalcFrequency = QT_TR_NOOP("F&requency");
const QString Strings::CalcLineLength = QT_TR_NOOP("Line &length");
const QString Strings::CalcLineWidth = QT_TR_NOOP("Line &width");
const QString Strings::CalcElectricalLength = QT_TR_NOOP("Elec&trical length");
const QString Strings::CalcLineImpedance = QT_TR_NOOP("Line &impedance");
const QString Strings::CalcElectrical = QT_TR_NOOP("&Electrical");
const QString Strings::CalcPhysical = QT_TR_NOOP("&Physical");
const QString Strings::CalcDegrees = QT_TR_NOOP("degrees");
const QString Strings::CalcImpedance = QT_TR_NOOP("impedance");

//----------------------------------------------------------------------------
QString Strings::translate( const QString& text )
{
  ASSERT( qApp != 0 );
  QString translation = qApp->translate( "Strings", text, "" );
  return translation;
}
