/* @(#) im_desc_hd: Copies vips file header to an IMAGE descriptor.
 * @(#) 
 * @(#) void 
 * @(#) im_desc_hd( image, header )
 * @(#) IMAGE *image;
 * @(#) VAS_HDR *header;
 * @(#)
 * @(#) Returns 0 on success and -1 on error
 *
 * Copyright: Nicos Dessipris
 * Written on: 13/02/1990
 * Modified on : 22/2/92 v6.3 Kirk Martinez
 * 17/11/94 JC
 *	- read compression fields too
 * 28/10/98 JC
 * 	- byteswap stuff added
 * 21/8/02 JC
 *	- oops, was truncating float
 * 14/10/05
 * 	- revised to stop gcc4 -O2 breaking it
 */

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/
#include <vips/intl.h>

#include <stdio.h>

#include <vips/vips.h>  

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif /*WITH_DMALLOC*/

/* Read and byteswap.
 */
static void
read_4byte( int msb_first, unsigned char *to, unsigned char **from )
{
	unsigned char *p = *from;
	int out;

	if( msb_first )
		out = p[0] << 24 | p[1] << 16 | p[2] << 8 | p[3];
	else
		out = p[3] << 24 | p[2] << 16 | p[1] << 8 | p[0];

	*from += 4;
	*((int *) to) = out;
}

static void
read_2byte( int msb_first, unsigned char *to, unsigned char **from )
{
	unsigned char *p = *from;
	int out;

	if( msb_first )
		out = p[0] << 8 | p[1];
	else
		out = p[1] << 8 | p[0];

	*from += 2;
	*((short *) to) = out;
}

int
im_desc_hd( IMAGE *image, VAS_HD *header )
{
	unsigned char *from;
	int msb_first;

	from = (unsigned char *) header;
	read_4byte( 1, (unsigned char *) &image->magic, &from );

	if( image->magic != IM_MAGIC_INTEL &&
		image->magic != IM_MAGIC_SPARC ) {
		im_errormsg( "im_open: \"%s\" is not a VIPS image", 
			image->filename );
		return( -1 );
	}
	msb_first = image->magic == IM_MAGIC_SPARC;

	read_4byte( msb_first, (unsigned char *) &image->Xsize, &from );
	read_4byte( msb_first, (unsigned char *) &image->Ysize, &from );
	read_4byte( msb_first, (unsigned char *) &image->Bands, &from );
	read_4byte( msb_first, (unsigned char *) &image->Bbits, &from );
	read_4byte( msb_first, (unsigned char *) &image->BandFmt, &from );
	read_4byte( msb_first, (unsigned char *) &image->Coding, &from );
	read_4byte( msb_first, (unsigned char *) &image->Type, &from );
	read_4byte( msb_first, (unsigned char *) &image->Xres, &from );
	read_4byte( msb_first, (unsigned char *) &image->Yres, &from );
	read_4byte( msb_first, (unsigned char *) &image->Length, &from );
	read_2byte( msb_first, (unsigned char *) &image->Compression, &from );
	read_2byte( msb_first, (unsigned char *) &image->Level, &from );
	read_4byte( msb_first, (unsigned char *) &image->Xoffset, &from );
	read_4byte( msb_first, (unsigned char *) &image->Yoffset, &from );

#ifdef VERBOSEDEBUG
	fprintf(stderr, "Debug: im_desc_hd: Printing the set image descriptor");
	im_printdesc(image);
#endif

	return( 0 );
}
