(**
   Implements a tab groupobject.

  TODO
  * Hide is suboptimal.
**)

MODULE VOMulti;

(*
    Implements a unvisible tab gadget.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)


IMPORT D  := VODisplay,
       E  := VOEvent,
       G  := VOGUIObject,
       O  := VOObject;

CONST
  setMsg* = 0;

TYPE
  Prefs*     = POINTER TO PrefsDesc;

  (**
    In this class all preferences stuff of the button is stored.
  **)

  PrefsDesc* = RECORD (G.PrefsDesc)
               END;


  Multi*     = POINTER TO MultiDesc;
  MultiDesc* = RECORD (G.GroupDesc)
               prefs    : Prefs;
               current  : G.Object;
               selected : LONGINT;
             END;

  SetMsg*        = POINTER TO SetMsgDesc;
  SetMsgDesc*    = RECORD (O.MessageDesc)
                     pos* : LONGINT;
                   END;

VAR
  prefs* : Prefs;

  PROCEDURE (p : Prefs) SetPrefs(m : Multi);

  BEGIN
    m.prefs:=p;   (* We set the prefs *)

    IF p.background#NIL THEN
      m.SetBackgroundObject(p.background.Copy());
      m.backgroundObject.source:=m;
    END;
  END SetPrefs;

  PROCEDURE (m : Multi) Init*;

  BEGIN
    m.Init^;

    prefs.SetPrefs(m);

    m.current:=NIL;
    m.selected:=-1;
  END Init;

  PROCEDURE (m : Multi) CalcSize*(display : D.Display);

  VAR
    entry : G.Object;

  BEGIN
    m.width:=0;
    m.height:=0;
    m.minWidth:=0;
    m.minHeight:=0;

    entry:=m.list;
    WHILE entry#NIL DO
      entry.CalcSize(display);

      m.width:=G.MaxLong(m.width,entry.oWidth);
      m.height:=G.MaxLong(m.height,entry.oHeight);

      m.minWidth:=G.MaxLong(m.minWidth,entry.oMinWidth);
      m.minHeight:=G.MaxLong(m.minHeight,entry.oMinHeight);

      entry:=entry.next;
    END;

    m.CalcSize^(display);
  END CalcSize;

  PROCEDURE (m : Multi) GetEntry(count :LONGINT): G.Object;

  VAR
    entry : G.Object;

  BEGIN
    entry:=m.list;
    WHILE count>1 DO
      entry:=entry.next;
      DEC(count);
    END;
    RETURN entry;
  END GetEntry;

  (**
    Set the nth entry the multi object should display.
  **)

  PROCEDURE (m : Multi) SetEntry*(pos : LONGINT);

  VAR
    old : G.Object;

  BEGIN
    old:=m.current;
    m.current:=m.GetEntry(pos);
    m.selected:=pos;
    IF m.current#old THEN
      IF old#NIL THEN
        old.Hide;
      END;
      m.Redraw;
    END;
  END SetEntry;

  PROCEDURE (m : Multi) GetFocus*(event : E.Event):G.Object;

  BEGIN
    IF ~m.visible OR m.disabled THEN
      RETURN NIL;
    END;

    IF m.current#NIL THEN
      RETURN m.current.GetFocus(event);
    ELSE
      RETURN NIL;
    END;
  END GetFocus;

  PROCEDURE (m : Multi) Draw*(x,y : LONGINT; draw :  D.DrawInfo);

  BEGIN
    m.Draw^(x,y,draw);

    m.DrawBackground(m.x,m.y,m.width,m.height);

    IF m.selected<1 THEN
      m.SetEntry(1);
    END;

    IF m.current#NIL THEN
      m.current.Resize(m.width,m.height);
      m.current.Draw(m.x+(m.width-m.current.oWidth) DIV 2,
                     m.y+(m.height-m.current.oHeight) DIV 2,draw);
    END;
  END Draw;

  PROCEDURE (m : Multi) Refresh*(x,y,w,h : LONGINT);

  BEGIN
    IF m.visible & m.Intersect(x,y,w,h) THEN
      m.RestrictToBounds(x,y,w,h);
      m.DrawBackground(x,y,w,h);
      IF m.current#NIL THEN
        m.current.Redraw;
      END;
    END;
  END Refresh;

  PROCEDURE (m : Multi) Hide*;

  BEGIN
    IF m.visible THEN
      IF m.current#NIL THEN
        m.current.Hide;
      END;
      m.DrawHide;
      m.Hide^;
    END;
  END Hide;

  (**
    The Handler for messages from user and other objects
  **)

  PROCEDURE (m : Multi) Receive*(message : O.Message);

  BEGIN
    WITH
      message: SetMsg DO
        m.SetEntry(message.pos);
    ELSE
    END;
  END Receive;

BEGIN
  NEW(prefs);
  prefs.Init;
END VOMulti.