(**
  Implements popup-windows.

  TODO
  * Share more code with VOWindow
**)

MODULE VOPopup;

(*
    Implements popups.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)


IMPORT D   := VODisplay,
       E   := VOEvent,
       F   := VOFrame,
       G   := VOGUIObject,
       K   := VOKeyHandler,
       O   := VOObject,
       P   := VOPrefs;

CONST
  openMsg*   = 0;
  closeMsg*  = 1;

TYPE
  Prefs*     = POINTER TO PrefsDesc;

  (**
    In this class all preferences stuff of the button is stored.
  **)

  PrefsDesc* = RECORD (P.PrefsDesc)
                 frame* : LONGINT; (* the frame to use for the button *)
               END;

  Popup*     = POINTER TO PopupDesc;
  PopupDesc* = RECORD (D.WindowDesc)
                 prefs       : Prefs;
                 top,
                 reference,
                 current     : G.Object;
                 keyHandler- : K.KeyHandler;
                 frame       : F.Frame;   (* frames menu *)
                 inited      : BOOLEAN;
               END;

  (* Some messages *)

  OpenMsg*         = POINTER TO OpenMsgDesc;
  OpenMsgDesc*     = RECORD (O.MessageDesc)
                     END;

  CloseMsg*       = POINTER TO CloseMsgDesc;
  CloseMsgDesc*   = RECORD (O.MessageDesc)
                    END;

  (* Some messagehandler *)

  Msg2Open*       = POINTER TO Msg2OpenDesc;
  Msg2OpenDesc*   = RECORD (O.HandlerDesc)
                    END;

  Msg2Close*      = POINTER TO Msg2CloseDesc;
  Msg2CloseDesc*  = RECORD (O.HandlerDesc)
                    END;


VAR
  prefs* : Prefs;

  PROCEDURE (p : Prefs) Init*;

  BEGIN
    p.Init^;

    p.frame:=F.double3DOut;
  END Init;

  (**

  **)

  PROCEDURE (p : Popup) Init*;

  BEGIN
    p.Init^;

    p.prefs:=prefs;

    p.top:=NIL;
    p.reference:=NIL;
    p.current:=NIL;
    p.frame:=NIL;
    p.keyHandler:=NIL;

    p.inited:=FALSE;

    p.Grab(TRUE);
    p.CreateAllways(TRUE);
    p.Borderless(TRUE);

    NEW(p.frame);
    p.frame.Init;
    p.frame.SetFlags({G.horizontalFlex,G.verticalFlex});

  END Init;

  (**
    Set the top object for this window and its reference. The popup tries
    to open itself directly under the referenced object. It also tires to
    get the same width as the popup.
  **)

  PROCEDURE(p : Popup) SetTop*(top,reference : G.Object);

  BEGIN
    p.top:=top;
    p.reference:=reference;
  END SetTop;

  PROCEDURE (p : Popup) CalcSize;

  BEGIN
    p.top.CalcSize(p.display);
    p.frame.SetInternalFrame(p.prefs.frame);
    p.frame.CalcSize(p.display);
    (* Is is nice, when reference and popup have the same width *)
    p.top.Resize(p.reference.width-p.frame.leftBorder-p.frame.rightBorder,-1);
    p.SetSize(p.frame.leftBorder+p.top.oWidth+p.frame.rightBorder,
              p.frame.topBorder+p.top.oHeight+p.frame.bottomBorder);
    p.frame.Resize(p.width,p.height);
  END CalcSize;

  PROCEDURE (p : Popup) CursorIsIn():BOOLEAN;

  VAR
    rx,ry,
    wx,wy  : LONGINT;

  BEGIN
    p.GetMousePos(rx,ry,wx,wy);
    IF (wx>=0) & (wx<=p.width-1) & (wy>=0) & (wy<=p.height-1) THEN
      RETURN TRUE;
    ELSE
      RETURN FALSE;
    END;
  END CursorIsIn;

  PROCEDURE (p : Popup) PreInit*;

  VAR
    x,y : LONGINT;

  BEGIN
    p.CalcSize;

    p.display.currentWin.GetXY(x,y);
    INC(x,p.reference.x);
    INC(y,p.reference.y+p.reference.height);

    x:=G.RoundRange(x,0,p.display.scrWidth-1-p.width);
    y:=G.RoundRange(y,0,p.display.scrHeight-1-p.height);

    p.SetPos(x,y);

    p.PreInit^;
  END PreInit;

  (**
    Add a keyhandler to the popup window.
  **)

  PROCEDURE (p : Popup) AddKeyHandler*(handler : K.KeyHandler);

  BEGIN
    p.keyHandler:=handler;
  END AddKeyHandler;

  (* -- handler for some common windowevents -- *)

  PROCEDURE (p : Popup) Draw*;

  BEGIN
    p.frame.Draw(0,0,p.draw);
    p.top.Draw((p.width-p.top.oWidth) DIV 2,(p.height-p.top.oHeight) DIV 2,p.draw);
  END Draw;

  PROCEDURE (p : Popup) Redraw*(x,y,width,height : LONGINT);

  BEGIN
    p.top.Refresh(x,y,width,height);
  END Redraw;

  PROCEDURE(p : Popup) Hide*;

  BEGIN
    p.top.Hide;
    p.frame.Hide;
  END Hide;

  PROCEDURE (p : Popup) FocusIn*;

  BEGIN
    p.FocusIn^;
    IF p.keyHandler#NIL THEN
      p.keyHandler.Activate;
    END;
  END FocusIn;

  PROCEDURE (p : Popup) FocusOut*;

  BEGIN
    p.FocusOut^;
    IF p.keyHandler#NIL THEN
      p.keyHandler.Deactivate;
    END;
    p.Close;
  END FocusOut;

  PROCEDURE (p : Popup) GetPosObject(mode : LONGINT):G.Object;

  VAR
    rx,ry,
    wx,wy : LONGINT;

  BEGIN
    p.GetMousePos(rx,ry,wx,wy);
    RETURN p.top.GetPosObject(wx,wy,mode);
  END GetPosObject;

  (**
    Returns the object that coveres the given point and that supports
    dragging of data.

    If drag is TRUE, when want to find a object that we can drag data from,
    else we want an object to drop data on.
  **)

  PROCEDURE (p : Popup) GetDnDObject*(x,y : LONGINT; drag : BOOLEAN):G.Object;

  BEGIN
    RETURN p.top.GetDnDObject(x,y,drag);
  END GetDnDObject;

  PROCEDURE (p : Popup) ContextHelp*;

  VAR
    object : G.Object;
    help   : D.Window;

  BEGIN
    IF p.current=NIL THEN
      object:=p.GetPosObject(G.helpGadget);
      IF object#NIL THEN
        help:=object.GetHelpObject();
        IF help#NIL THEN
          help.Open;
        END;
      END;
    END;
  END ContextHelp;

  PROCEDURE (p : Popup) ContextMenu*():BOOLEAN;

  VAR
    object : G.Object;
    menu   : D.Window;

  BEGIN
    object:=p.GetPosObject(G.menuGadget);
    IF object#NIL THEN
      menu:=object.GetMenuObject();
      IF menu#NIL THEN
        menu.Open;
        RETURN TRUE;
      END;
    END;
    RETURN FALSE;
  END ContextMenu;


  PROCEDURE (p : Popup) HandleEvent*(event : E.Event):BOOLEAN;

  BEGIN
    IF p.HandleEvent^(event) THEN
      RETURN TRUE;
    END;

    IF (event IS E.MouseEvent) & (event(E.MouseEvent).type=E.mouseDown) THEN
      IF ~p.CursorIsIn() THEN
        p.Close;
        RETURN TRUE;
      END;
    END;

    IF (event IS E.KeyEvent) & (p.keyHandler#NIL) THEN
      IF p.keyHandler.HandleEvent(event(E.KeyEvent),TRUE) THEN
        RETURN TRUE;
      END;
    END;

    IF p.current#NIL THEN
      IF p.current.HandleEvent(event) THEN
        p.current:=NIL;
      END;
    ELSE
      p.current:=p.top.GetFocus(event);
      IF p.current#NIL THEN
        IF p.keyHandler#NIL THEN
          p.keyHandler.SetCurrentObject(p.current(G.Gadget));
        END;
      ELSE
        IF (event IS E.KeyEvent) & (p.keyHandler#NIL) THEN
          IF p.keyHandler.HandleEvent(event(E.KeyEvent),FALSE) THEN END;
        END;
      END;
    END;

    RETURN TRUE;
  END HandleEvent;

  (*
    The Handler for messages by user and other objects
  *)

  PROCEDURE (p : Popup) FocusNext*;

  BEGIN
    IF p.keyHandler#NIL THEN
      p.keyHandler.NextObject;
    END;
  END FocusNext;

  PROCEDURE (p : Popup) FocusObjectHides*;

  BEGIN
    ASSERT(p.keyHandler#NIL);
    p.keyHandler.FindNewObject;
  END FocusObjectHides;

  PROCEDURE (p : Popup) Receive*(message : O.Message);

  BEGIN
    WITH
      message: OpenMsg DO
        p.Open;
    | message: CloseMsg DO
        p.Close;
    ELSE
    END;
  END Receive;

  (*
    some predefined message-converter
  *)

  PROCEDURE (h : Msg2Open) Convert*(message : O.Message):O.Message;

  VAR
    new : OpenMsg;

  BEGIN
    NEW(new);
    RETURN new;
  END Convert;

  PROCEDURE (h : Msg2Close) Convert*(message : O.Message):O.Message;

  VAR
    new : CloseMsg;

  BEGIN
    NEW(new);
    RETURN new;
  END Convert;

BEGIN
  NEW(prefs);
  prefs.Init;

END VOPopup.