MODULE VOSliderPrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT B   := VOButton,
       BG  := VOBackground,
       F   := VOFrameGroup,
       ISD := VOImgSelDlg,
       G   := VOGUIObject,
       L   := VOLabel,
       O   := VOObject,
       PG  := VOPrefsGUI,
       PP  := VOPrefsParser,
       S   := VOSlider,
       V   := VOVecImage;

TYPE
  Item*     = POINTER TO ItemDesc;
  ItemDesc* = RECORD (PG.PrefsItemDesc)
                prefs      : S.PrefsDesc;
                hImgSelDlg : ISD.ImgSelDlg;
                hImage     : V.VecImage;
                vImgSelDlg : ISD.ImgSelDlg;
                vImage     : V.VecImage;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="Slider";
    PG.settings.AddItem(d);

    NEW(d.hImgSelDlg);
    d.hImgSelDlg.Init;
    NEW(d.vImgSelDlg);
    d.vImgSelDlg.Init;
  END Init;

  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    button   : B.Button;
    frame    : F.FrameGroup;
    label    : L.Label;

  BEGIN
    d.hImgSelDlg.SetDisplay(d.display);
    d.hImgSelDlg.Forward(ISD.setMsg,d);

    d.vImgSelDlg.SetDisplay(d.display);
    d.vImgSelDlg.Forward(ISD.setMsg,d);

    NEW(frame);
    frame.Init;
    frame.SetTextLabel("Image");

      NEW(label);
      label.Init;

        button:=PG.CreateImageButton(d.prefs.hKnob,d.hImage,d.display,d.hImgSelDlg,
                                     d.window.keyHandler,"Select image");
      label.AddTextLabel("horizontal",button);

        button:=PG.CreateImageButton(d.prefs.vKnob,d.vImage,d.display,d.vImgSelDlg,
                                     d.window.keyHandler,"Select image");
      label.AddTextLabel("vertical",button);
    frame.Add(label);

    RETURN frame;
  END GetObject;

  PROCEDURE (p : Item) Refresh*;

  BEGIN
    p.prefs:=S.prefs^;

    p.hImgSelDlg.SetImage(p.prefs.hKnob);
    p.hImage.Set(p.prefs.hKnob);
    p.vImgSelDlg.SetImage(p.prefs.vKnob);
    p.vImage.Set(p.prefs.vKnob);
  END Refresh;

  PROCEDURE (p : Item) LoadPrefs*(appName : ARRAY OF CHAR);

  VAR
    buffer : ARRAY 256 OF CHAR;
    pos    : LONGINT;
    top    : PP.Item;


  BEGIN
    p.LoadPrefs^(appName);

    top:=p.LoadPrefsFile("Slider",appName);
    IF top=NIL THEN
      RETURN;
    END;
    top:=top.GetEntry("SLIDER");
    IF top=NIL THEN
      RETURN;
    END;

    IF top.GetStringEntry("hImage",buffer) THEN
      pos:=V.GetImageEntry(buffer);
      IF pos>=0 THEN
        S.prefs.hKnob:=pos;
      ELSE
        p.ErrorWrongData("SLIDER/hImage",buffer);
      END;
    END;
    IF top.GetStringEntry("vImage",buffer) THEN
      pos:=V.GetImageEntry(buffer);
      IF pos>=0 THEN
        S.prefs.vKnob:=pos;
      ELSE
        p.ErrorWrongData("SLIDER/vImage",buffer);
      END;
    END;

    S.prefs.background:=BG.LoadBackground(top);
  END LoadPrefs;

  PROCEDURE (p : Item) Apply*;

  BEGIN
    S.prefs^:=p.prefs;
  END Apply;

  PROCEDURE (p : Item) Save*;

  VAR
    block    : PP.BlockItem;
    value    : PP.ValueItem;

  BEGIN
    NEW(block);
    block.Init;
    block.SetName("SLIDER");
      NEW(value);
      value.Init;
      value.SetValue("hImage",V.images[p.prefs.hKnob]);
    block.AddItem(value);
      NEW(value);
      value.Init;
      value.SetValue("vImage",V.images[p.prefs.vKnob]);
    block.AddItem(value);

    BG.SaveBackground(block,p.prefs.background);

    p.SaveItems("Slider",block);
  END Save;


  PROCEDURE (p : Item) Receive*(message : O.Message);

  BEGIN
    WITH message : ISD.SetMsg DO
        p.hImage.Set(message.image);
        p.prefs.hKnob:=message.image;
        p.vImage.Set(message.image);
        p.prefs.vKnob:=message.image;
    ELSE
      p.Receive^(message);
    END;
  END Receive;

BEGIN
  NEW(prefs);
  prefs.Init;

END VOSliderPrefs.