#!/usr/bin/perl -w

use Data::Dumper;

#### External programs ####
my $lspci = "/sbin/lspci -nd 1923:0300";


#### MAIN ####

my @pcibus = `$lspci`;
#print Dumper(@pcibus);
my $cardcount = $#pcibus +1;
my (@boards,$board);
my ($conf,$ch);
foreach $board (@pcibus){
	chomp($board);
	$board =~ s/ .*$//;
	push @boards,$board;
}
print("Found $cardcount cards on the PCI bus.\n");
my $port=0;
foreach $board (@boards){
	print("============= Card [$board] =============\n");
	print(" Is this a single span card ? [Y|y|N|n](y):");
	$ch = readline STDIN;
	my ($bus,$slotq)=split(":",$board);
	my ($slot,@junk) = split(/\./,$slotq);
	$bus = 0 + $bus;
	$slot = hex($slot);

	if ($ch =~ /n/i ){
		printf(" [$board] is Dual span\n");
		$port++;
		$conf->{$port}->{"CPU"}="A";
		$conf->{$port}->{"card"}="$board";
		$conf->{$port}->{"bus"}="$bus";
		$conf->{$port}->{"slot"}="$slot";
		$port++;
		$conf->{$port}->{"CPU"}="B";
		$conf->{$port}->{"card"}="$board";
		$conf->{$port}->{"bus"}="$bus";
		$conf->{$port}->{"slot"}="$slot";
	}
	else {
		printf(" [$board] is Single span\n");
		$port++;
		$conf->{$port}->{"CPU"}="A";
		$conf->{$port}->{"card"}="$board";
		$conf->{$port}->{"bus"}="$bus";
		$conf->{$port}->{"slot"}="$slot";
	}
}
print("A total of $port ports will now be configured.\n");
for ($i=1;$i<=$port;$i++){
	print("============= Port [$i] =============\n");
	print(" Is this port E1 or T1 ? [E|e|T|t](e):");
	$ch = readline STDIN;
	if ($ch =~ /t/i ){
		printf(" port $i is T1/J1\n");
		$conf->{$i}->{"media"}="T1";
	}
	else {
		printf(" port $i is E1\n");
		$conf->{$i}->{"media"}="E1";
	}
	print(" Is this port Client or Network? [C|c|N|n](c):");
	$ch = readline STDIN;
	if ($ch =~ /n/i ){
		printf(" port $i is Network\n");
		$conf->{$i}->{"clock"}="network";
	}
	else {
		printf(" port $i is Client\n");
		$conf->{$i}->{"clock"}="client";
	}
}
#print Dumper($conf);
print("Making wanpipe config files now....\n");
my $channels=0;
for ($i=1;$i<=$port;$i++){
	my $filename = "wanpipe$i.conf";
	open FH,">",$filename;
	print FH "[devices]\n";
	print FH "wanpipe$i = WAN_AFT, Comment\n\n";
	print FH "[interfaces]\n";
	if ($conf->{$i}->{"media"} eq "E1"){
		$channels = $channels + 30;
		print FH "wp".$i."aft1 = wanpipe$i, auto, API, Comment\n";
		print FH "wp".$i."aft2 = wanpipe$i, auto, API, Comment\n";
		print FH "wp".$i."aft3 = wanpipe$i, auto, API, Comment\n";
	} else {
		$channels = $channels + 23;
		print FH "wp".$i."aft1 = wanpipe$i, auto, API, Comment\n";
		print FH "wp".$i."aft2 = wanpipe$i, auto, API, Comment\n";
	}
	print FH "\n";
	print FH "[wanpipe$i]\n";
	print FH "CARD_TYPE         = AFT\n";
	print FH "S514CPU           = ".$conf->{$i}->{"CPU"}."\n";
	print FH "AUTO_PCISLOT      = NO\n";
	print FH "PCISLOT           = ".$conf->{$i}->{"slot"}."\n";
	print FH "PCIBUS            = ".$conf->{$i}->{"bus"}."\n";
	print FH "MEDIA             = ".$conf->{$i}->{"media"}."\n";
	print FH "TE_CLOCK          = NORMAL\n";
	if ($conf->{$i}->{"media"} eq "E1"){
		print FH "LCODE             = HDB3\n";
		print FH "FRAME             = CRC4\n";
	} else {
		print FH "LCODE             = B8ZS\n";
		print FH "FRAME             = ESF\n";
		print FH "TE_LBO            = 0DB\n";
	}
	print FH "ACTIVE_CH         = ALL\n";
	if ($conf->{$i}->{"clock"} eq "client"){
		print FH "Clocking          = External\n";
	} else {
		print FH "Clocking          = Internal\n";
	}
	print FH "Firmware          = /etc/wanpipe/firmware/cdual514.sfm\n";
	print FH "Interface         = V35\n";
	print FH "BaudRate          = 1540000\n";
	print FH "MTU               = 1500\n";
	print FH "UDPPORT           = 9000\n";
	print FH "TTL               = 255\n";
	print FH "IGNORE_FRONT_END  = NO\n";
	print FH "TE_HIGHIMPEDANCE  = NO\n";
	print FH "\n";

	print FH "[wp".$i."aft1]\n";
	if ($conf->{$i}->{"media"} eq "E1"){
		print FH "ACTIVE_CH       = 1-15\n";
	} else {
		print FH "ACTIVE_CH       = 1-23\n";
	}
	print FH "HDLC_STREAMING  = NO\n";
	print FH "IDLE_FLAG       = 0x7E\n";
	if ($conf->{$i}->{"media"} eq "E1"){
		print FH "MTU             = 120\n";
		print FH "MRU             = 120\n";
	} else {
		print FH "MTU             = 184\n";
		print FH "MRU             = 184\n";
	}
	print FH "\n";

	print FH "[wp".$i."aft2]\n";
	if ($conf->{$i}->{"media"} eq "E1"){
		print FH "ACTIVE_CH       = 16\n";
	} else {
		print FH "ACTIVE_CH       = 24\n";
	}
	print FH "HDLC_STREAMING  = YES\n";
	print FH "\n";

	if ($conf->{$i}->{"media"} eq "E1"){
		print FH "[wp".$i."aft3]\n";
		print FH "ACTIVE_CH       = 17-31\n";
		print FH "HDLC_STREAMING  = NO\n";
		print FH "IDLE_FLAG       = 0x7E\n";
		print FH "MTU             = 120\n";
		print FH "MRU             = 120\n";
	}
	close FH;
	print "Done wanpipe".$i.".conf \n";
}
print "Making openpri.conf config file now...\n";
open FH,">","openpri.conf";
print FH "[general]\n";
print FH "name=openpri\n";
print FH "channels=$channels\n";
print FH "cards=$port\n\n";
for ($i=0;$i<$port;$i++){
	my $idx=$i+1;
	print FH "[card$i]\n";
	print FH "priverbose=0\n";
	print FH "name=wanpipe$idx\n";
	print FH "iftype=".$conf->{$idx}->{"media"}."\n";
	print FH "node=".$conf->{$idx}->{"clock"}."\n";
	if ($conf->{$idx}->{"media"} eq "E1"){
		print FH "protocol=euroisdn_e1\n";
	} else {
		print FH "protocol=ni2\n";
	}
	print FH "dialplan=national\n";
	print FH "localdialplan=national\n";
	if ($conf->{$idx}->{"media"} eq "E1"){
		print FH "dchannel=16\n";
		print FH "encoding=alaw\n";
	} else {
		print FH "dchannel=24\n";
		print FH "encoding=mulaw\n";
	}
	if ($conf->{$idx}->{"media"} eq "E1"){
		for ($x=1;$x<16;$x++){
			print FH "channel$x=wp".$idx."aft1\n";
		}
		print FH "channel16=wp".$idx."aft2\n";
		for ($x=17;$x<32;$x++){
			print FH "channel$x=wp".$idx."aft3\n";
		}
	} else {
		for ($x=1;$x<24;$x++){
			print FH "channel$x=wp".$idx."aft1\n";
		}
		print FH "channel24=wp".$idx."aft2\n";
	}
	print FH "\n";
}

