#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "user.h"	/* USER_TYPE */
#include "list.h"
#include "grid.h"
#include "dart.h"
#include "col.h"        /* COL_ONCE */

#include "zv.h"		/* parseGeometry */
#include "payload.h"	/* Payload */
#include "helpers.h"	/* playSound */


const WClass Dart::wclass(DART_TYPE, "Dart", NULL, Dart::replicator);


/* update times */
void Dart::updateTime(time_t sec, time_t usec, float *lasting)
{
  *lasting = (float) (sec - move.sec) + (float) (usec - move.usec) / 1e6;
  if (move.sec == 0) {
    *lasting = move.ttl -= DART_LASTING;
    move.sec = sec;
    move.usec = usec;
    return;
  }
  if (*lasting < move.ttl) {
    move.ttl -= *lasting;
    move.sec = sec;
    move.usec = usec;
  }
  else {
    *lasting = move.ttl;
    move.ttl = 0;
    move.sec = move.usec = 0;

    /* the dart has spent its time to live => destroyed */
    notice("%s destroyed", name.instance_name);
    objectToDelete(this);
  }
}

/* systeme d'equations regissant les mouvements imposes */
void Dart::changePosition(float lasting)
{
  pos.x += lasting * move.lspeed.v[0];
  pos.y += lasting * move.lspeed.v[1];
  pos.z += lasting * move.lspeed.v[2];
  pos.az += lasting * move.aspeed.v[0];
}

/* condition to do position modifications */
boolean Dart::change()
{
  return (move.ttl > 0.0005) ? TRUE : FALSE;
}

static
void dartCreation(int methnum, User *pu, void *data, time_t sec, time_t usec)
{
  new Dart(pu, data, sec, usec);
}

Dart::Dart(WObject *pu, void *data, time_t sec, time_t usec)
{
  pos.x = pu->pos.x;	//BAD + move.lspeed.v[0] * 0.2;
  pos.y = pu->pos.y;	//BAD + move.lspeed.v[1] * 0.2;
  pos.z = pu->pos.z /* + 0.3 * USER_DEFAULTHEIGHT */;
  pos.az = pu->pos.az;
  move.perm_sec = -1;
  move.perm_usec = 0;
  lspeed = DART_SPEED;
  move.lspeed.v[0] = (float)(Cos((double)pu->pos.az)) * lspeed;
  move.lspeed.v[1] = (float)(Sin((double)pu->pos.az)) * lspeed;
  move.sec = sec;
  move.usec = usec;
  move.ttl = DART_TTL;

  char geom[80];
  sprintf(geom,"box,size=%s,ambient=%s", DART_GEOMETRY, DART_COLOR);
  soh = parseGeometry(geom);

  initializeObject(this, DART_TYPE, VR_MOBILE);
  maxlasting[DART_TYPE] = DART_LASTING;

  noh.nbprop = DART_PROPS;
  propertiesnumber[DART_TYPE] = DART_PROPS;
  createNetObject((NetObject *) this, VR_VOLATILE);
  declareObjCreation(&(this->noh));
}

/* dart creation: this method is invisible by dart, called by the user */
static
void dartCreateByUser(User *pu, void *data, time_t sec, time_t usec)
{
  dartCreation(DART_CREAT, pu, data, sec, usec);
  playSound(SHOOTSND);
}

/* dart creation from the network */
WObject * Dart::replicator(u_int8 type_id, struct _NetObjectId noid, Payload *pp)
{
  return new Dart(type_id, noid, pp);
}

Dart::Dart(u_int8 type_id, struct _NetObjectId noid, Payload *pp)
{
  noh.type = type_id;
  noh.noid = noid;
  propertiesnumber[DART_TYPE] = DART_PROPS;

  char geom[256];
  sprintf(geom, "box,size=%s,ambient=%s", DART_GEOMETRY, DART_COLOR);
  soh = parseGeometry(geom);
  initializeObject(this, DART_TYPE, VR_MOBILE);
  setAllProperties((NetObject *) this, pp);
  initBB(this->pos);

  lspeed = DART_SPEED;
  move.ttl = DART_TTL;
  move.perm_sec = -1;
  move.perm_usec = 0;
  playSound(SHOOTSND);
}

static
void dartSetHit(Dart *pcur, Payload *pp)
{
  Pos oldpos = pcur->pos;

  getPayload(pp, "c", &(pcur->hit));
//  dumpPayload(stdout, pp);

  if (pcur->hit == 1) {
    pcur->hit = 0;
    notice("%s hits me", pcur->name.instance_name);
    playSound(OUILLESND);
  }
  updateReplica(pcur, oldpos);
}

/* dart update to the network */
boolean Dart::updateToNetwork(const Pos &oldpos)
{
  boolean change = FALSE;

  if ((pos.x != oldpos.x) || (pos.y != oldpos.y)) {
    declareObjDelta(&(this->noh), DART_PROPXY);
    change = TRUE;
  }
  if (ABSF(pos.z - oldpos.z) > DART_DELTAZ)
    change = TRUE;
  if (pos.az != oldpos.az)
    change = TRUE;
#if 0 // NOT USED
  if (hit != pold->hit) {
    /* declareObjDelta(&(this->noh), DART_PROPHIT); */
    trace(DBG_FORCE, "dartUpdateToNetwork: curhit=%d oldhit=%d", hit, pold->hit);
    change = TRUE;
  }
#endif
  return change;
}

void Dart::whenIntersect(WObject *pcur, WObject *pold)
{
  notice("%s intersects %s", pcur->name.instance_name, name.instance_name);
  switch (pcur->noh.type) {
  case USER_TYPE:
    /* dart intersects an user in movement: hit */
    notice("%s hit by %s", pcur->name.instance_name, name.instance_name);
    copyPositionAndBB(pold, pcur);
    break;
  case DART_TYPE:
    copyPositionAndBB(pold, pcur);
    break;
  default:
    copyPositionAndBB(pold, pcur);
  }
  objectToDelete(this);	/* segfault in deleteSolidFromList */
}

void Dart::whenWallIntersect(WObject *pold, V3 *norm)
{
  this->nature.collision = COL_ONCE;

  float dx, dy, dxn, dyn;
  float vx, vy, nn;
  float scalprod;

  /* we do not change the position, we only change the deltas */
  copyPositionAndBB(pold, this);

  vx = norm->v[0];
  vy = norm->v[1];
  dx = move.lspeed.v[0];
  dy = move.lspeed.v[1];

  nn = sqrt(dx*dx + dy*dy);
  dxn = dx / nn;
  dyn = dy / nn;
  scalprod = dxn * vx + dyn * vy;
  if (scalprod >= 0.0)
    return;

  move.lspeed.v[0] = (dxn - 2 * scalprod * vx) * nn;
  move.lspeed.v[1] = (dyn - 2 * scalprod * vy) * nn;
}

void dartInitFuncList(void)
{
  setFuncList[DART_PROPXY][DART_TYPE].pf = WO_PAYLOAD set_xy;
  setFuncList[DART_PROPZ][DART_TYPE].pf = WO_PAYLOAD set_z;
  setFuncList[DART_PROPAZ][DART_TYPE].pf = WO_PAYLOAD set_az;
  setFuncList[DART_PROPHNAME][DART_TYPE].pf = WO_PAYLOAD set_hname;
  setFuncList[DART_PROPHIT][DART_TYPE].pf = WO_PAYLOAD dartSetHit;

  getFuncList[DART_PROPXY][DART_TYPE].pf = WO_PAYLOAD get_xy;
  getFuncList[DART_PROPZ][DART_TYPE].pf = WO_PAYLOAD get_z;
  getFuncList[DART_PROPAZ][DART_TYPE].pf = WO_PAYLOAD get_az;
  getFuncList[DART_PROPHNAME][DART_TYPE].pf = WO_PAYLOAD get_hname;
  getFuncList[DART_PROPHIT][DART_TYPE].pf = WO_PAYLOAD dartGetHit; /* user.c */

  setMethodFunc(DART_TYPE, 0, WO_ACTION dartCreateByUser, "");
}

#endif /* !VRENGD */
