#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "parse.h"
#include "col.h"	/* COL_ONCE */
#include "doc.h"

#include "zv.h"		/* parseGeometry */
#include "helpers.h"	/* startbrowser */


const WClass Doc::wclass(DOC_TYPE, "Doc", Doc::creator);


/* doc initialization from a file */
void Doc::creator(char *l)
{
  new Doc(l);
}

Doc::Doc(char *l)
{
  l = parseName(l, this);
  l = parsePosition(l, this);
  l = parseURL(l, this);
  soh = parseGeometry(l);

  initializeObject(this, DOC_TYPE, VR_STILL);
  nature.collision = COL_ONCE;
} 

/* intersection: stop */
void Doc::whenIntersect(WObject *pcur, WObject *pold)
{
  copyPositionAndBB(pold, pcur);
}

/* view */
static
void docView(Doc *po, void *data, time_t sec, time_t usec)
{
#if 1	// HAVE_WGET
  viewps(po->name.url);
#else
  startbrowser(po->name.url);
#endif
}

/* print */
static
void docPrint(Doc *po, void *data, time_t sec, time_t usec)
{
#if 1	// HAVE_WGET
  printps(po->name.url);
#else
  startbrowser(po->name.url);
#endif
}

void Doc::quit()
{
  quitps();
}

void docInitFuncList(void)
{
  setMethodFunc(DOC_TYPE, 0, WO_ACTION docView, "View");
  setMethodFunc(DOC_TYPE, 1, WO_ACTION docPrint, "Print");
}

#endif /* !VRENGD */
