
  // ------------------------------------------------------------------------ //
  // Author               : This file has been written by                     //
  //                            Yann Renard (MyselF / Dim4)                   //
  // Copyright            : This file is totaly free and you may distribute   //
  //                        it to anyone you want, without modifying this     //
  //                        header. If you use it in a commercial project (?) //
  //                        or in bigger project (!), I would be glad to know //
  //                        about it :) Please mail me...                     //
  //                        be glad to know about it, please mail me          //
  // Contact              : You can contact me at                             //
  //                            renard@esiea-ouest.fr                         //
  //                            myself_yr@hotmail.com                         //
  // Bug reports          : Mail me please so I can know about it             //
  // Purpose of this file : This package is my first experiment in bones      //
  //                        programming. I feel it works great for a first    //
  //                        time. For sure their are lots of optim to do...   //
  //                        Your ideas are welcome :)                         //
  // Version              : 1.0                                               //
  // History              : none                                              //
  // ToDo                 : lot's of things :)                                //
  //                        other things :))))                                //
  //                        Maybe buid an HTML tutorial about this subject ?  //
  // Greets               : Dim4 members :)                                   //
  //                        Latex, teacher forever                            //
  //                        Ethereal, thx for ideas of implementation         //
  //                        #codefr, thx for url                              //
  //                        comp.graphics.algorithm && comp.graphics.opengl   //
  //                        pech' and yoyo... newbies in demo hey !           //
  // ------------------------------------------------------------------------ //

#ifndef __BONEVECT3D_H__
#define __BONEVECT3D_H__

#include "boneCommon.h"

   class VECT3D
    {
     public :

     //----------------------------
     // Champs de la classe vect3d
     float x,y,z;

     //-----------------------------
     // Constructeurs / destructeur
     inline VECT3D ( float ox = 0.0f , float oy = 0.0f , float oz = 0.0f )
      {
       x = ox;
       y = oy;
       z = oz;
      }

     inline VECT3D ( VECT3D & op )
      {
       x = op.x;
       y = op.y;
       z = op.z;
      }

     inline VECT3D ( VECT3D * op )
      {
       x = op->x;
       y = op->y;
       z = op->z;
      }

     inline ~VECT3D ( void ) { }

     //------------------------
     // Actions sur les champs
     inline void setValue ( float ox, float oy, float oz )
      {
       x = ox;
       y = oy;
       z = oz;
      }

     inline void reset ( void )
      {
       x = 0.0f;
       y = 0.0f;
       z = 0.0f;
      }

     //---------------------------
     // Fonction sur les vecteurs
     inline float length ( void )
      {
       return (float) sqrt(x*x + y*y + z*z);
      }

     inline void normalize ( void )
      {
       float len = length();
       if (len != 0.0f)
        {
         float invLen = 1.0f / len;
         x *= invLen;
         y *= invLen;
         z *= invLen;
        }
      }

     //------------
     // Operateurs
     // -> Addition
     inline friend VECT3D operator + ( VECT3D & op1, VECT3D & op2 )
      {
       VECT3D result;
       result.x = op1.x + op2.x;
       result.y = op1.y + op2.y;
       result.z = op1.z + op2.z;
       return result;
      }
     inline void operator += ( VECT3D & op )
      {
       x += op.x;
       y += op.y;
       z += op.z;
      }
     // -> Soustraction
     inline friend VECT3D operator - ( VECT3D & op1, VECT3D & op2 )
      {
       VECT3D result;
       result.x = op1.x - op2.x;
       result.y = op1.y - op2.y;
       result.z = op1.z - op2.z;
       return result;
      }
     inline void operator -= ( VECT3D & op )
      {
       x -= op.x;
       y -= op.y;
       z -= op.z;
      }
     // -> Mise a l'echelle
     friend VECT3D operator * ( VECT3D & op1, float op2 )
      {
       VECT3D result;
       result.x = op1.x * op2;
       result.y = op1.y * op2;
       result.z = op1.z * op2;
       return result;
      }
     inline void operator *= ( float op )
      {
       x *= op;
       y *= op;
       z *= op;
      }
     // -> Mise a l'echelle
     inline friend VECT3D operator * ( float op1, VECT3D & op2 )
      {
       VECT3D result;
       result.x = op1 * op2.x;
       result.y = op1 * op2.y;
       result.z = op1 * op2.z;
       return result;
      }
     inline void operator *= ( VECT3D & op )
      {
       x *= op.x;
       y *= op.y;
       z *= op.z;
      }
     // -> Multiplication matricielle
     inline friend VECT3D operator * ( float * mat, VECT3D & vect )
      {
       VECT3D result;
       result.x = vect.x * mat[ 0] + vect.y * mat[ 4] + vect.z * mat[ 8] + mat[12];
       result.y = vect.x * mat[ 1] + vect.y * mat[ 5] + vect.z * mat[ 9] + mat[13];
       result.z = vect.x * mat[ 2] + vect.y * mat[ 6] + vect.z * mat[10] + mat[14];
       return result;
      }
     inline void operator *= ( float * mat )
      {
       float tx = x;
       float ty = y;
       float tz = z;
       x = tx * mat[ 0] + ty * mat[ 4] + tz * mat[ 8] + mat[12];
       y = tx * mat[ 1] + ty * mat[ 5] + tz * mat[ 9] + mat[13];
       z = tx * mat[ 2] + ty * mat[ 6] + tz * mat[10] + mat[14];
      }
     // -> Mise a l'echelle par division ( sans doute peu utile )
     inline friend VECT3D operator / ( VECT3D & op1, float op2 )
      {
       VECT3D result;
       float inv = 1.0f / op2;
       result.x = op1.x * inv;
       result.y = op1.y * inv;
       result.z = op1.z * inv;
       return result;
      }
     inline void operator / ( float op )
      {
       float inv = 1.0f / op;
       x *= inv;
       y *= inv;
       z *= inv;
      }

     //-------------------
     // Methodes avancees
     // -> Produit scalaire
     static inline float dotProduct ( VECT3D & op1, VECT3D & op2 )
      {
       return op1.x * op2.x + op1.y * op2.y + op1.z * op2.z;
      }

     static inline float dotProduct ( VECT3D * op1, VECT3D * op2 )
      {
       return op1->x * op2->x + op1->y * op2->y + op1->z * op2->z;
      }
     // -> Produit vectoriel
     inline void crossProduct ( VECT3D & op1, VECT3D & op2 )
      {
       x = op1.y * op2.z - op1.z * op2.y;
       y = op1.z * op2.x - op1.x * op2.z;
       z = op1.x * op2.y - op1.y * op2.x;
      }

     inline void crossProduct ( VECT3D * op1, VECT3D * op2 )
      {
       x = op1->y * op2->z - op1->z * op2->y;
       y = op1->z * op2->x - op1->x * op2->z;
       z = op1->x * op2->y - op1->y * op2->x;
      }
    };

#endif
