
  // ------------------------------------------------------------------------ //
  // Author               : This file has been written by                     //
  //                            Yann Renard (MyselF / Dim4)                   //
  // Copyright            : This file is totaly free and you may distribute   //
  //                        it to anyone you want, without modifying this     //
  //                        header. If you use it in a commercial project (?) //
  //                        or in bigger project (!), I would be glad to know //
  //                        about it :) Please mail me...                     //
  //                        be glad to know about it, please mail me          //
  // Contact              : You can contact me at                             //
  //                            renard@esiea-ouest.fr                         //
  //                            myself_yr@hotmail.com                         //
  // Bug reports          : Mail me please so I can know about it             //
  // Purpose of this file : This package is my first experiment in bones      //
  //                        programming. I feel it works great for a first    //
  //                        time. For sure their are lots of optim to do...   //
  //                        Your ideas are welcome :)                         //
  // Version              : 1.0                                               //
  // History              : none                                              //
  // ToDo                 : lot's of things :)                                //
  //                        other things :))))                                //
  //                        Maybe buid an HTML tutorial about this subject ?  //
  // Greets               : Dim4 members :)                                   //
  //                        Latex, teacher forever                            //
  //                        Ethereal, thx for ideas of implementation         //
  //                        #codefr, thx for url                              //
  //                        comp.graphics.algorithm && comp.graphics.opengl   //
  //                        pech' and yoyo... newbies in demo hey !           //
  // ------------------------------------------------------------------------ //

  //------------------------------------------------
  // This class represents the extremity of a bone
  // So a bone is made of one of this class (that
  // contains translation/rotation) and a reference
  // to it's father ( the extremity it depends of )
  // This extremity also has several children whom
  // he'll be the father ( see that like a tree )

#ifndef __BONEVERT_H__
#define __BONEVERT_H__

#include "boneCommon.h"
#include "boneName.h"
#include "boneVect3d.h"
#include "boneList.h"
#include "boneIO.h"

   class LINK;

   class BONEVERTEX : public NAMEABLE
    {
     public :

     //--------------------------------
     // Datas in the bone vertex class

     // -> Position at the begining
     VECT3D initialPosition;
     float  initialAngle;
     VECT3D initialAxis;

     // -> Position during the animation
     VECT3D currentPosition;
     float  currentAngle;
     VECT3D currentAxis;

     // -> Children management
     LIST < BONEVERTEX > childList;
     BONEVERTEX ** child;
     BONEVERTEX *  father;
     int           children;
     int           childListCompiled;

     // -> Links management
     // ( a link is defined by a bone vertex, a vertex of
     // the mesh and a weight )
     LIST < LINK > linkList;
     LINK ** link;
     int     links;
     int     linkListCompiled;

     // -> Saves of the matrices
     float initialMatrix[16];
     float initialMatrixInverted[16];
     float currentMatrix[16];
     // -> Same for rotation matrices ( may be used
     //    for normal computations )
     float initialRotMatrix[16];
     float initialRotMatrixInverted[16];
     float currentRotMatrix[16];

     // -> a field to scale the influence of this boneVertex
     float influenceScaleFactor;

     // -> a field to tell if this boneVertex should animated or not
     int animated;

     //----------------------
     // Construct / destruct
     BONEVERTEX ( void );
     BONEVERTEX ( VECT3D & zePosition, float zeAngle, VECT3D & zeAxis );
     BONEVERTEX ( VECT3D * zePosition, float zeAngle, VECT3D * zeAxis );
     ~BONEVERTEX ( void );

     //----------------------------------
     // Accessing initial position datas
     void setInitialPosition ( VECT3D & zePosition );
     void setInitialPosition ( VECT3D * zePosition );
     void setInitialPosition ( float ox, float oy, float oz );
     void setInitialRotation ( float zeAngle, VECT3D & zeAxis );
     void setInitialRotation ( float zeAngle, VECT3D * zeAxis );
     void setInitialRotation ( float zeAngle, float axisx, float axisy, float axisz );

     //-------------------------------------------------------
     // Accessing current position datas ( during animation )
     void setCurrentPosition ( VECT3D & zePosition );
     void setCurrentPosition ( VECT3D * zePosition );
     void setCurrentPosition ( float ox, float oy, float oz );
     void setCurrentRotation ( float zeAngle, VECT3D & zeAxis );
     void setCurrentRotation ( float zeAngle, VECT3D * zeAxis );
     void setCurrentRotation ( float zeAngle, float axisx, float axisy, float axisz );

     //-------------------------------------------------------
     // Accessing current position datas ( during animation )
     // with relative values (realtive to initial position )
     void resetCurrentPosition ( void );
     void resetCurrentRotation ( void );
     void translateCurrentPosition ( VECT3D & delta );
     void translateCurrentPosition ( VECT3D * delta );
     void translateCurrentPosition ( float dx, float dy, float dz );
     void scaleCurrentPosition ( float scalex, float scaley, float scalez );
     void scaleCurrentPosition ( float scale );

     //---------------------------------------
     // Actions on this node and its children
     // Those actions are definitives
     void scale ( float sx, float sy, float sz );

     //------------------------
     // Children list managing
     void setFather ( BONEVERTEX * zeFather );
     void addChild  ( BONEVERTEX * newChild );
     void removeChild ( char * zeName );
     BONEVERTEX * findChild ( char * zeName );

     //--------------------
     // Link list managing
     void addLink ( LINK * zeLink );
     void removeLink ( LINK * zeLink );

     //--------------------------------------------------------------------
     // Intern functions to compile the lists... should be private maybe ?
     void compileChildList ( void );
     void compileLinkList ( void );
     void generateInitialMatrix ( void ); // needs glPush / glPop and glLoadIdentity at the begining
     void generateCurrentMatrix ( void ); // needs glPush / glPop and glLoadIdentity at the begining

     //---------------
     // I/O functions
     void read ( char * filename, float size = 1.0f );
     void write ( char * filename );
     void readFromFile ( FILE * file, float size = 1.0f );
     void writeToFile  ( FILE * file );
     void print ( int cpt = 0, FILE * dest = stderr );
    };

#endif
