#ifndef TEXTURE_H
#define TEXTURE_H


#include "images.h"	/* Image */


#if WITH_TINYGL
#define TEXTURE_SIZE 256	/* originaly 256 */
#define VRENG_TEXTURE_TYPE 3
#else
#define TEXTURE_SIZE 128	/* originaly 256 */
#define VRENG_TEXTURE_TYPE GL_RGB
#endif
#define MIME_LEN 16


typedef struct _TextureCacheEntry {
  int  num;
  char url[URL_LEN];
  char mime[MIME_LEN];
  void *handle;
  Image *image;
  int  loaded;
  struct _TextureCacheEntry *next;
} TextureCacheEntry;


void initTextureCache(int quality);
void closeTextureCache(void);
int getTextureFromCache(const char *url);
int getCurrentTextureNumber(void);
TextureCacheEntry * getTextureEntryByUrl(const char *url);
TextureCacheEntry * getTextureEntryByNumber(int);
void updateTextures(void);


#endif /* TEXTURE_H */
