#include <qlineedit.h>

#include "findwindow.h"
#include "version.h"


FindWindow::FindWindow(QWidget* parent, const char* name) 
	: QGroupBox( 0, Horizontal, "Find", parent, name )

{
	setCaption (__VYM " - " +tr("Find Text"));
	//resize (180,130);
	move (130,130);

	setMargin( 100 );

    QVBoxLayout* box = new QVBoxLayout( layout() );
    
    QHBoxLayout *row1 = new QHBoxLayout( box );
    row1->setMargin( 10 );

    // Create a Label
    QLabel* label = new QLabel( "Text to find: ", this);
    row1->addWidget( label );

	// Create LineEdit (here QComboBox)
    QHBoxLayout *row2 = new QHBoxLayout( box );
    row2->setMargin( 10 );
    findcombo = new QComboBox( true, this );
	findcombo->setMinimumWidth(150);
    row2->addWidget( findcombo );
	connect ( findcombo, SIGNAL( highlighted(int) ), 
		this, SLOT( findPressed() ) );
	connect ( findcombo, SIGNAL( textChanged(const QString &) ), 
		this, SLOT( findTextChanged(const QString&) ) );
    //findcombo->insertItem( "Normal", -1 );

	// Create Buttons
    QHBoxLayout *row3 = new QHBoxLayout( box );
    row3->setMargin( 10 );
	clearbutton = new QPushButton (tr("Clear"),this);
	connect ( clearbutton, SIGNAL( clicked() ), 
		findcombo, SLOT( clearEdit() ) );
	row3->addWidget (clearbutton);
	
	QSpacerItem *si1= new QSpacerItem (10,0,QSizePolicy::Minimum, QSizePolicy::Expanding );
	row3->addItem(si1);
	
	cancelbutton = new QPushButton (tr("Cancel"),this);
	cancelbutton->setAccel (Key_Escape);
	connect ( cancelbutton, SIGNAL( clicked() ), 
		this, SLOT( cancelPressed() ) );
	row3->addWidget (cancelbutton);

	QSpacerItem *si2= new QSpacerItem (10,0,QSizePolicy::Fixed, QSizePolicy::Fixed);
	row3->addItem(si2);
	
	findbutton = new QPushButton (tr("Find"),this);
	findbutton->setDefault (true);
	connect ( findbutton, SIGNAL( clicked() ), 
		this, SLOT( findPressed() ) );
	row3->add(findbutton);
	
	findcombo->setFocus();
}

void FindWindow::popup()
{
	findcombo->lineEdit()->selectAll();
	show();
}

void FindWindow::cancelPressed()
{
	hide();
}

void FindWindow::findPressed()
{
	emit (findButton(findcombo->currentText() ) );
}

void FindWindow::findTextChanged(const QString&)
{
	emit (somethingChanged() );
}
