#ifndef MAPOBJ_H
#define MAPOBJ_H

#include <qcanvas.h>
#include <iostream>

#include "misc.h"

using namespace std;

#define Z_BBOX      0
#define Z_XLINK    10
#define Z_LINK     20
#define Z_FRAME    50
#define Z_SELBOX   60
#define Z_FLOATIMG 65
#define Z_ICON     80
#define Z_TEXT    100

class MapObj:public xmlObj {
public:
    MapObj ();
    MapObj (QCanvas*);
    MapObj (MapObj*);
    virtual ~MapObj ();
    virtual void init ();
    virtual void copy (MapObj*);
	virtual QCanvas* getCanvas();
    virtual int x();
    virtual int y();
	virtual int width();
	virtual int height();
	virtual QPoint getAbsPos();
	virtual QString getPos();					// Return position as string (x,y)
    virtual void move (double x,double y);      // move to absolute Position
    virtual void moveBy (double x,double y);    // move to relative Position
    virtual bool inBox(const QPoint&);			// Check if Point is within clickbox
    virtual QRect getBBox();					// returns bounding box
    virtual QRect addBBox(QRect,QRect);			// returns bbox which includes both boxes
    virtual QSize getSize();					// returns size of bounding box
    virtual bool isVisibleObj();
    virtual void setVisibility(bool);
    virtual void positionBBox()=0;       
	virtual void calcBBoxSize()=0;
protected:  
    QCanvas* canvas;
    QRect bbox;									// bounding box of MO itself
	QRect clickBox;								// area where mouseclicks are found
    QPoint absPos;							    // Position on canvas
    bool visible;
};

#endif
