#ifndef N_
#define N_(String) (String)
#endif

def_rcsect_begin(display)
def_rcitem(tabstop, P_NZINT, PI_TEXT, (void *) &Tabstop, CMT_TABSTOP, NULL)
def_rcitem(pixel_per_char, P_PIXELS, PI_TEXT, (void *)&pixel_per_char, CMT_PIXEL_PER_CHAR, NULL)
#ifdef USE_IMAGE
def_rcitem(pixel_per_line, P_PIXELS, PI_TEXT, (void *)&pixel_per_line, CMT_PIXEL_PER_LINE, NULL)
#endif
#if LANG == JA
def_rcitem(kanjicode, P_CODE, PI_SEL_C, (void *) &DisplayCode, CMT_KANJICODE, kcodestr)
def_rcitem(document_code, P_CODE, PI_SEL_C, (void *) &main_p0env.DocumentCode, CMT_DOCUMENTCODE, dcodestr)
def_rcitem(system_code, P_CODE, PI_SEL_C, (void *) &SystemCode, CMT_SYSTEMCODE, scodestr)
#endif
def_rcitem(frame, P_CHARINT, PI_ONOFF, (void *) &main_p0env.RenderFrame, CMT_FRAME, NULL)
def_rcitem(target_self, P_CHARINT, PI_ONOFF, (void *) &TargetSelf, CMT_TSELF, NULL)
def_rcitem(display_link, P_INT, PI_ONOFF, (void *) &displayLink, CMT_DISPLINK, NULL)
def_rcitem(display_line_info, P_INT, PI_ONOFF, (void *)&displayLineInfo, CMT_DISPLINEINFO, NULL)
def_rcitem(ext_dirlist, P_INT, PI_ONOFF, (void *) &UseExternalDirBuffer, CMT_EXT_DIRLIST, NULL)
def_rcitem(dirlist_cmd, P_STRING, PI_TEXT, (void *) &DirBufferCommand, CMT_DIRLIST_CMD, NULL)
def_rcitem(multicol, P_INT, PI_ONOFF, (void *) &multicolList, CMT_MULTICOL, NULL)
def_rcitem(alt_entity, P_CHARINT, PI_ONOFF, (void *) &UseAltEntity, CMT_ALT_ENTITY, NULL)
def_rcitem(fold_textarea, P_CHARINT, PI_ONOFF, (void *)&FoldTextarea, CMT_FOLD_TEXTAREA, NULL)
def_rcitem(ignore_null_img_alt, P_INT, PI_ONOFF, (void *) &ignore_null_img_alt, CMT_IGNORE_NULL_IMG_ALT, NULL)
def_rcitem(anchor_num_style, P_STRING, PI_TEXT, (void *)&anchor_num_style, CMT_ANCHOR_NUM_STYLE, NULL)
def_rcitem(img_num_style, P_STRING, PI_TEXT, (void *)&img_num_style, CMT_IMG_NUM_STYLE, NULL)
def_rcitem(label_withinpage_style, P_STRING, PI_TEXT, (void *)&label_withinpage_style, CMT_LABEL_WITHINPAGE_STYLE, NULL)
def_rcitem(link_num_url, P_STRING, PI_TEXT, (void *)&link_num_url, CMT_LINK_NUM_URL, NULL)
def_rcitem(scroll_amount, P_INT, PI_TEXT, (void *)&scroll_amount, CMT_SCROLL_AMOUNT, NULL)
def_rcitem(wrap_line, P_INT, PI_ONOFF, (void *)&WrapLine, CMT_WRAP_LINE, NULL)
def_rcitem(line_truncated, P_STRING, PI_TEXT, (void *)&LineTruncated, CMT_LINE_TRUNCATED, NULL)
def_rcitem(line_continued, P_STRING, PI_TEXT, (void *)&LineContinued, CMT_LINE_CONTINUED, NULL)
def_rcitem(view_unseenobject, P_INT, PI_ONOFF, (void *) &view_unseenobject, CMT_VIEW_UNSEENOBJECTS, NULL)
#ifdef USE_IMAGE
def_rcitem(display_image, P_INT, PI_ONOFF, (void *)&main_p0env.displayImage, CMT_DISP_IMAGE, NULL)
def_rcitem(preload_image, P_INT, PI_ONOFF, (void *)&preload_image, CMT_PRELOAD_IMAGE, NULL)
def_rcitem(image_scale, P_SCALE, PI_TEXT, (void *)&image_scale, CMT_IMAGE_SCALE, NULL)
def_rcitem(imgdisplay, P_STRING, PI_TEXT, (void *)&Imgdisplay, CMT_IMGDISPLAY, NULL)
def_rcitem(imgsize, P_STRING, PI_TEXT, (void *)&Imgsize, CMT_IMGSIZE, NULL)
def_rcitem(img_valign, P_SEL, PI_SEL_C, (void *)&img_valign, CMT_IMG_VALIGN, img_valign_sel)
def_rcitem(table_valign, P_SEL, PI_SEL_C, (void *)&table_valign, CMT_TABLE_VALIGN, table_valign_sel)
#endif
def_rcitem(show_lnum, P_INT, PI_ONOFF, (void *) &showLineNum, CMT_SHOW_NUM, NULL)
def_rcitem(show_srch_str, P_INT, PI_ONOFF, (void *)&show_srch_str, CMT_SHOW_SRCH_STR, NULL)
def_rcsect_end(display)

#ifdef USE_COLOR
def_rcsect_begin(color)
def_rcitem(color, P_INT, PI_ONOFF, (void *) &useColor, CMT_COLOR, NULL)
def_rcitem(basic_color, P_COLOR, PI_SEL_C, (void *) &basic_color, CMT_B_COLOR, colorstr)
def_rcitem(anchor_color, P_COLOR, PI_SEL_C, (void *) &anchor_color, CMT_A_COLOR, colorstr)
def_rcitem(image_color, P_COLOR, PI_SEL_C, (void *) &image_color, CMT_I_COLOR, colorstr)
def_rcitem(form_color, P_COLOR, PI_SEL_C, (void *) &form_color, CMT_F_COLOR, colorstr)
#ifdef USE_BG_COLOR
def_rcitem(mark_color, P_COLOR, PI_SEL_C, (void *)&mark_color, CMT_MARK_COLOR, colorstr)
def_rcitem(bg_color, P_COLOR, PI_SEL_C, (void *) &bg_color, CMT_BG_COLOR, colorstr)
#endif
def_rcitem(active_style, P_INT, PI_ONOFF, (void *) &useActiveColor, CMT_ACTIVE_STYLE, NULL)
def_rcitem(active_color, P_COLOR, PI_SEL_C, (void *) &active_color, CMT_C_COLOR, colorstr)
def_rcitem(visited_anchor, P_INT, PI_ONOFF, (void *) &useVisitedColor, CMT_VISITED_ANCHOR, NULL)
def_rcitem(visited_color, P_COLOR, PI_SEL_C, (void *) &visited_color, CMT_V_COLOR, colorstr)
def_rcsect_end(color)
#endif

def_rcsect_begin(misc)
def_rcitem(pagerline, P_INT, PI_TEXT, (void *) &PagerMax, CMT_PAGERLINE, NULL)
#ifdef USE_HISTORY
def_rcitem(history, P_INT, PI_TEXT, (void *) &URLHistSize, CMT_HISTSIZE, NULL)
def_rcitem(save_hist, P_INT, PI_ONOFF, (void *) &SaveURLHist, CMT_SAVEHIST, NULL)
#endif
def_rcitem(confirm_qq, P_INT, PI_ONOFF, (void *) &confirm_on_quit, CMT_CONFIRM_QQ, NULL)
#ifdef USE_MARK
def_rcitem(mark, P_INT, PI_ONOFF, (void *)&use_mark, CMT_USE_MARK, NULL)
#endif
#ifdef EMACS_LIKE_LINEEDIT
def_rcitem(emacs_like_lineedit, P_INT, PI_ONOFF, (void *)&emacs_like_lineedit, CMT_EMACS_LIKE_LINEEDIT, NULL)
#endif
#ifdef VI_PREC_NUM
def_rcitem(vi_prec_num, P_INT, PI_ONOFF, (void *)&vi_prec_num, CMT_VI_PREC_NUM, NULL)
#endif
def_rcitem(language_extension, P_STRING, PI_TEXT, (void *) &LangExt, CMT_LANGEXT, NULL)
#ifdef USE_MOUSE
def_rcitem(use_mouse, P_INT, PI_ONOFF, (void *) &use_mouse, CMT_MOUSE, NULL)
def_rcitem(reverse_mouse, P_INT, PI_ONOFF, (void *) &reverse_mouse, CMT_REVERSE_MOUSE, NULL)
#endif				/* USE_MOUSE */
def_rcitem(clear_buffer, P_INT, PI_ONOFF, (void *) &clear_buffer, CMT_CLEAR_BUF, NULL)
def_rcitem(decode_cte, P_CHARINT, PI_ONOFF, (void *) &DecodeCTE, CMT_DECODE_CTE, NULL)
def_rcitem(concurrent, P_SINT, PI_TEXT, &concurrent, CMT_CONCURRENT, NULL)
def_rcitem(concurrent_per_server, P_SINT, PI_TEXT, &concurrent_per_server, CMT_CONCURRENT_PER_SERVER, NULL)
def_rcitem(message_about_config_save, P_STRING, PI_TEXT, (void *)&message_about_config_save, CMT_MESSAGE_ABOUT_CONFIG_SAVE, NULL)
def_rcsect_end(misc)

def_rcsect_begin(proxy)
def_rcitem(http_proxy, P_STRING, PI_TEXT, (void *) &HTTP_proxy, CMT_HTTP_PROXY, NULL)
#ifdef USE_GOPHER
def_rcitem(gopher_proxy, P_STRING, PI_TEXT, (void *) &GOPHER_proxy, CMT_GOPHER_PROXY, NULL)
#endif				/* USE_GOPHER */
def_rcitem(ftp_proxy, P_STRING, PI_TEXT, (void *) &FTP_proxy, CMT_FTP_PROXY, NULL)
def_rcitem(no_proxy, P_STRING, PI_TEXT, (void *) &NO_proxy, CMT_NO_PROXY, NULL)
def_rcitem(noproxy_netaddr, P_INT, PI_ONOFF, (void *) &NOproxy_netaddr, CMT_NOPROXY_NETADDR, NULL)
def_rcitem(no_cache, P_CHARINT, PI_ONOFF, (void *) &NoCache, CMT_NO_CACHE, NULL)
def_rcsect_end(proxy)

def_rcsect_begin(directory)
def_rcitem(document_root, P_STRING, PI_TEXT, (void *) &document_root, CMT_DROOT, NULL)
def_rcitem(personal_document_root, P_STRING, PI_TEXT, (void *) &personal_document_root, CMT_PDROOT, NULL)
def_rcitem(cgi_bin, P_STRING, PI_TEXT, (void *) &cgi_bin, CMT_CGIBIN, NULL)
def_rcitem(index_file, P_STRING, PI_TEXT, (void *) &index_file, CMT_IFILE, NULL)
def_rcsect_end(directory)

def_rcsect_begin(external)
def_rcitem(mime_types, P_STRING, PI_TEXT, (void *) &mimetypes_files, CMT_MIMETYPES, NULL)
def_rcitem(mailcap, P_STRING, PI_TEXT, (void *) &mailcap_files, CMT_MAILCAP, NULL)
def_rcitem(mailcap_entry, P_STRINGV, PI_TEXTA, (void *) &mailcap_entries, CMT_MAILCAP_ENTRY, NULL)
def_rcitem(browsecap_entry, P_STRINGV, PI_TEXTA, (void *) &browsecap_entries, CMT_BROWSECAP_ENTRY, NULL)
def_rcitem(extbrowser, P_STRING, PI_TEXT, (void *) &ExtBrowser, CMT_EXTBRZ, NULL)
def_rcitem(extbrowser2, P_STRING, PI_TEXT, (void *) &ExtBrowser2, CMT_EXTBRZ2, NULL)
def_rcitem(extbrowser3, P_STRING, PI_TEXT, (void *) &ExtBrowser3, CMT_EXTBRZ3, NULL)
def_rcitem(bgextviewer, P_INT, PI_ONOFF, (void *) &BackgroundExtViewer, CMT_BGEXTVIEW, NULL)
def_rcitem(use_lessopen, P_INT, PI_ONOFF, (void *) &use_lessopen, CMT_USE_LESSOPEN, NULL)
def_rcsect_end(external)

#ifdef USE_SSL
def_rcsect_begin(ssl)
def_rcitem(ssl_forbid_method, P_STRING, PI_TEXT, (void *) &ssl_forbid_method, CMT_SSL_FORBID_METHOD, NULL)
#ifdef USE_SSL_VERIFY
def_rcitem(ssl_verify_server, P_INT, PI_ONOFF, (void *) &ssl_verify_server, CMT_SSL_VERIFY_SERVER, NULL)
def_rcitem(ssl_cert_file, P_SSLPATH, PI_TEXT, (void *) &ssl_cert_file, CMT_SSL_CERT_FILE, NULL)
def_rcitem(ssl_key_file, P_SSLPATH, PI_TEXT, (void *) &ssl_key_file, CMT_SSL_KEY_FILE, NULL)
def_rcitem(ssl_ca_path, P_SSLPATH, PI_TEXT, (void *) &ssl_ca_path, CMT_SSL_CA_PATH, NULL)
def_rcitem(ssl_ca_file, P_SSLPATH, PI_TEXT, (void *) &ssl_ca_file, CMT_SSL_CA_FILE, NULL)
#endif
def_rcsect_end(ssl)
#endif

#ifdef USE_COOKIE
def_rcsect_begin(cookie)
def_rcitem(use_cookie, P_INT, PI_ONOFF, (void *) &use_cookie, CMT_USECOOKIE, NULL)
def_rcitem(accept_cookie, P_INT, PI_ONOFF, (void *) &accept_cookie, CMT_ACCEPTCOOKIE, NULL)
def_rcitem(accept_bad_cookie, P_SEL,  PI_SEL_C, (void *) &accept_bad_cookie, CMT_ACCEPTBADCOOKIE, badcookiestr)
def_rcitem(cookie_reject_domains, P_STRING, PI_TEXT, (void *) &cookie_reject_domains, CMT_COOKIE_REJECT_DOMAINS, NULL)
def_rcitem(cookie_accept_domains, P_STRING, PI_TEXT, (void *) &cookie_accept_domains, CMT_COOKIE_ACCEPT_DOMAINS, NULL)
def_rcsect_end(cookie)
#endif

def_rcsect_begin(search)
def_rcitem(mark_all_pages, P_INT, PI_ONOFF, (void *)&MarkAllPages, CMT_MARK_ALL_PAGES, NULL)
def_rcitem(wrap_search, P_INT, PI_ONOFF, (void *) &WrapDefault, CMT_WRAP, NULL)
def_rcitem(ignorecase_search, P_INT, PI_ONOFF, (void *) &IgnoreCase, CMT_IGNORE_CASE, NULL)
def_rcitem(search_across_lines, P_INT, PI_ONOFF, (void *) &AcrossLines, CMT_SEARCH_ACROSS_LINES, NULL)
#ifdef USE_ROMAJI
def_rcitem(use_romaji_search, P_INT, PI_ONOFF, (void *) &use_romaji_search, CMT_USE_ROMAJI_SEARCH, NULL)
def_rcitem(romaji_filter, P_STRING, PI_TEXT, (void *) &romaji_filter, CMT_ROMAJI_FILTER, NULL)
#endif
def_rcsect_end(search)

def_rcsect_begin(network)
def_rcitem(ftppasswd, P_STRING, PI_TEXT, (void *) &ftppasswd, CMT_FTPPASS, NULL)
#ifdef FTPPASS_HOSTNAMEGEN
def_rcitem(ftppass_hostnamegen, P_INT, PI_ONOFF, (void *)&ftppass_hostnamegen, CMT_FTPPASS_HOSTNAMEGEN, NULL)
#endif
def_rcitem(no_referer, P_INT, PI_ONOFF, (void *) &NoSendReferer, CMT_NOSENDREFERER, NULL)
def_rcitem(accept_encoding, P_STRINGV, PI_TEXTA, (void *) &AcceptEnc, CMT_ACCEPTENC, NULL)
def_rcitem(request_header, P_STRINGV, PI_TEXTA, (void *) &InitHTTPRequestHeaderList, CMT_REQUESTHEADER, NULL)
def_rcitem(http_version, P_STRING, PI_TEXT, (void *) &HTTPVersion, CMT_HTTPVERSION, NULL)
def_rcitem(retry_http, P_INT, PI_ONOFF, (void *) &retryAsHttp, CMT_RETRY_HTTP, NULL)
def_rcitem(default_url, P_SEL, PI_SEL_C, (void *)&DefaultURLString, CMT_DEFAULT_URL, defaulturls)
def_rcitem(argv_is_url, P_CHARINT, PI_ONOFF, (void *) &ArgvIsURL, CMT_ARGV_IS_URL, NULL)
def_rcitem(follow_redirection, P_INT, PI_TEXT, &FollowRedirection, CMT_FOLLOW_REDIRECTION, NULL)
def_rcitem(when_redirected, P_SEL, PI_SEL_C, &WhenRedirected, CMT_WHEN_REDIRECTED, when_redirected_sel)
#ifdef INET6
def_rcitem(dns_order, P_SEL, PI_SEL_C, (void *) &DNS_order, CMT_DNS_ORDER, dnsorders)
#endif				/* INET6 */
def_rcsect_end(network)

#if LANG == MANY

def_rcsect_begin(rc)
#ifdef USE_MOUSE
def_rcstr(view_buf, VIEW_BUF, N_("Viewing <%s> "), N_("Message when viewing mouse disabled buffer"))
def_rcstr(view_buf_with_mouse, VIEW_BUF_WITH_MOUSE, N_("<=UpDn Viewing <%s> "), N_("Message when viewing mouse enabled buffer"))
#else
def_rcstr(view_buf, VIEW_BUF, N_("Viewing <%s> "), N_("Message when viewing buffer"))
#endif
def_rcstr(omitted, OMITTED, N_(".."), N_("Omission mark of a long URL"))
#ifdef KANJI_SYMBOLS
def_rcstr(ul_marks, UL_MARKS, N_("&nbsp;*,&nbsp;+,&nbsp;o,&nbsp;#,&nbsp;@,&nbsp;-,&nbsp;=,**,--"),
	  N_("Comma separated list of marks of &lt;UL&gt; items"))
def_rcstr(ul_type_disc, UL_TYPE_DISC, N_("&nbsp;*"), N_("Disk mark of &lt;UL&gt;"))
def_rcstr(ul_type_circle, UL_TYPE_CIRCLE, N_("&nbsp;o"), N_("Circle mark of &lt;UL&gt; items"))
def_rcstr(ul_type_square, UL_TYPE_SQUARE, N_("&nbsp;#"), N_("Square mark of &lt;UL&gt; items"))
def_rcstr(small_img_alt, SMALL_IMG_ALT, N_("#"), N_("Alternative text for small image"))
def_rcstr(hr_rule, HR_RULE, N_("-"), N_("Horizontal rule"))
#ifdef USE_MENU
def_rcstr(menu_frame, MENU_FRAME, N_("+,-,+,|, ,|,+,-,+,:,:"), N_("Comma separated list of frame components"))
#endif
def_rcstr(rule, RULE, N_("+,+,+,+,+,|,+,+,+,-,+,&nbsp;"), N_("Comma separated list of rules"))
def_rcstr(rule_bold, RULE_BOLD, N_(",#,#,#,#,|,#,#,#,=,#,"), N_("Comma separated list of bold rules"))
#endif
def_rcitem(charset_cname, P_STRINGV, PI_TEXTA, (void *)&charset_cnames, N_("Canonical name of non-standard charsets"), NULL)
def_rcsect_end(rc)

def_rcsect_begin(mb)
def_mbsetup(mylang, MYLANG, PI_TEXT, N_("Language"))
def_mbsetup(mylang_charset, MYLANG_CHARSET, PI_TEXT, N_("Default charset in your language"))
def_mbsetup(tty_charset, TTY_CHARSET, PI_TEXT, N_("Charset of your terminal"))
def_mbsetup(tty_initial_charset, TTY_INITIAL_INPUT_CHARSET, PI_TEXT, N_("Initial charset of your terminal (deprecated)"))
def_mbsetup(tty_initial_input_charset, TTY_INITIAL_INPUT_CHARSET, PI_TEXT, N_("Initial charset of input from your terminal"))
def_mbsetup(tty_initial_output_charset, TTY_INITIAL_OUTPUT_CHARSET, PI_TEXT, N_("Initial charset of output to your terminal"))
def_mbsetup(tty_input_converters, TTY_INPUT_CONVERTERS, PI_TEXT, N_("Character encoding converters for tty input"))
def_mbsetup(tty_output_converters, TTY_OUTPUT_CONVERTERS, PI_TEXT, N_("Character encoding converters for tty output"))
def_mbsetup(tty_fallback_converters, TTY_FALLBACK_CONVERTERS, PI_TEXT, N_("Fallback character encoding converters for tty output"))
def_mbsetup(input_charset, INPUT_CHARSET, PI_TEXT, N_("Default charset of input stream"))
def_mbsetup(input_converters, INPUT_CONVERTERS, PI_TEXT, N_("Character encoding converters for input stream"))
def_mbsetup(output_charset, OUTPUT_CHARSET, PI_TEXT, N_("Default charset of output stream"))
def_mbsetup(output_converters, OUTPUT_CONVERTERS, PI_TEXT, N_("Character encoding converters for output stream"))
def_mbsetup(process_charset, PROCESS_CHARSET, PI_TEXT, N_("Charset for local process"))
def_mbsetup(unicode_width, UNICODE_WIDTH, PI_TEXT, N_("Name of unicode width table"))
def_rcitem(tty_character_conversion, P_STRINGV, PI_TEXTA, (void *)&tty_char_conv_list, N_("Character conversion for tty output"), NULL)
def_rcitem(tty_character_replacement, P_STRING, PI_TEXT, (void *)&term_char_repl,
	   N_("Replacement of characters which tty rejects"), NULL)
def_rcsect_end(mb)

#endif
