orig="$HOME/.w3mmee/cookie"
work=/tmp
expirerex='1[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]'
doit=no
umask=077

while [ $# -gt 0 ]; do
 case "$1" in #(
  -orig) orig="$2";; #(
  -work) fixed="$2";; #(
  -expirerex) expirerex="$2";; #(
  -umask) umask="$2";; #(
  -doit) doit="$2";; #(
  *) break;
 esac

 shift 2
done

fixed="$work/w3mmee-`basename $orig`-$$.fixed"

case "$doit" in #(
 Y|YES|Yes|y|yes) #(
 if [ -f $orig ]
 then
  umask $umask

  if egrep "^[^	]*	[^	]*	[^	]*	$expirerex	.*" < $orig > $fixed
  then
   if [ \! -f $orig.broken ]
   then
    if cat $orig >$orig.broken
    then
     :
    else
     echo "cat $orig >$orig.broken: $?"
     exit 1
    fi
   fi

   cat $fixed >$orig
  fi

  rm -f $fixed
 else
  echo "$orig does not exist, so no need of fix"
 fi
 ;;

 *)
 cat <<EOF

W3MMEE (p22 .. p22-3) keeps the cookies which should expire when
w3mmee exits, as if they will expire in very far future.  This B-sh
script may removes such cookies automatically.

SYNOPSIS:
	sh $0 \\
		[-doit <yes or no>] \\
		[-orig <path to cookie file>] \\
		[-work <directory for temporary file>] \\
		[-expirerex <regex. of right expire>]
		[-umask <umask>]
DEFAULTS:
	-orig $orig
	-work $work
	-expirerex $expirerex
	-umask $umask

If you can accept these defaults, please try
	sh $0 -doit yes
then following commands will be issued:
 if [ -f $orig ]
 then
  if egrep "^[^	]*	[^	]*	[^	]*	$expirerex	.*" < $orig > $fixed
  then
   if [ \\! -f $orig.broken ]
   then
    if mv $orig $orig.broken
     :
    then
     exit 1
    fi
   fi

   cat $fixed >$orig
  fi

  rm -f $fixed
 fi
EOF
 ;;
esac
