#ifndef  __SANGUART_HPP
 #define  __SANGUART_HPP

#include "gtypes.h"
#include "serintf.hpp"
#include "cs508ldr.hpp"

struct s_sang_mail_box {
   char opp_flag;                               /* the opp flag */
   char command;                                /* the user command */
   unsigned short buffer_length;                /* the data length */
   char return_code;                            /* the return code */
   char reserved[11];                           /* reserved for later use */
   char data[1024];                             /* the data area */
   };

/*

MANUAL FOR THE SANGOMA S508 BASIC ASYNCHRONOUS CODE
---------------------------------------------------

PROGRAMMER'S DOCUMENTATION
--------------------------

The mailbox is at offset 0x0000 from the defined memory window (physical offset
0xE000 on the adapter). There is a single mailbox, and it is used for all
interface commands.

The mailbox structure is defined as follows:

SEE ABOVE

The procedure for the mailbox usage is as follows:

1) Complete the parameters required for the specific commands defined below.
   For example, for a SET_BAUD_RATE command, the 'command' byte is set to
   0x03, the 'buffer_length' is set to the length of the passed baud rate value
   (0x04), and the 'data' area contains the baud rate.

2) Set the 'opp_flag' to 0x01. The code on the SDLA hardware will now process
   the interface command.

3) Poll the 'opp_flag' until it is set to 0x00. The return code, and other
   parameters relevant to the particular command are now valid.


The commands to be used are as follows:
   RECEIVE_DATA                   0x01
   TRANSMIT_DATA                  0x02
   SET_BAUD_RATE                  0x03
   READ_CODE_VERSION              0x10



RECEIVE_DATA (0x01)
-------------------

Read received data from the adapter.


Parameters to be set on entry
-----------------------------

   command       - set to 0x01

   buffer_length - set to 0x00


Parameters set on completion
----------------------------

   return_code   - set to 0x00 if data is available
                 - set to 0x01 if no data has been received

   buffer_length - (valid for a return code of 0x00)
                   set to the number of data bytes received

   data - (valid for a return code of 0x00)
          contains the received data



TRANSMIT_DATA (0x02)
--------------------

Pass data to the adapter for transmission. Note that a return code other than
0x00 means that the passed data has not been transmitted and this command
should be repeated in its entirety.


Parameters to be set on entry
-----------------------------

   command       - set to 0x02

   buffer_length - set to the number of data bytes to be transmitted (maximum
                   is 1024 bytes)

   data - contains the actual data to be transmitted


Parameters set on completion
----------------------------

   return_code   - set to 0x00 if the data has been queued on the adapter for
                   transmission
                 - set to 0x01 if the passed data length is invalid
                 - set to 0x02 if the transmit buffer is full




SET_BAUD_RATE (0x03)
--------------------

Set the baud rate to be used.
Note that the baud rate defaults to 19200 bps if this command is not used.


Parameters to be set on entry
-----------------------------

   command       - set to 0x03

   buffer_length - set to 0x04 (the length of the baud rate definition - an
                   unsigned long value)

   data - contains the required baud rate as an unsigned long variable (first
           byte last format). Valid values are from 1 to 200000 bps.


Parameters set on completion
----------------------------

   return_code   - set to 0x00 if call was successfull
                 - set to 0x01 if the passed baud rate is invalid

   buffer_length - (valid for a return code of 0x00)
                   set to 0x04

   data - (valid for a return code of 0x00)
          contains the actual baud rate set on the adapter - this allows the
          user to check that the baud rate generated by the S508 is indeed
          within permissible limits.



READ_CODE_VERSION (0x10)
------------------------

Read the version number of the downloaded code.


Parameters to be set on entry
-----------------------------

   command - set to 0x10

   buffer_length - set to 0x00


Parameters set on completion
----------------------------

   return_code - set to 0x00 if the call was successfull

   buffer_length - set to 0x04

   data - consists of the code version string in an ASCII format.

*/

class  cSangVirtUart : public  cSerialDataInterface
{
    private:
    BOOL     c_b_sang_loaded;
    char    *c_cp_read_buf;
    USHORT   c_us_data_avail;
    USHORT   c_us_read_offset;

    ULONG    c_ul_port_addr;
    ULONG    c_ul_windowphysaddr;

    cS508Loader   *c_Cp_X25s508ldr;

    volatile s_sang_mail_box    *c_sp_mail_box;
    USHORT   c_us_channel;

    BOOL     setCommandValid(char);
    USHORT   underflow();
    public:

    cSangVirtUart(ULONG    port_addr, ULONG  mem_addr, USHORT chan=0);
    virtual ~cSangVirtUart();
    BOOL     InitUart();
    BOOL     InitUart(USHORT, UBYTE  *);
    BOOL     DeInitUart(){return TRUE;};
    BOOL     putChar(char   *the_char);
    USHORT   putBlock(char  *some_chars, USHORT  len);
    BOOL     getChar(char   *the_char);
    USHORT   getBlock(char  *get_buffer, USHORT  get_buf_len);
    BOOL     isTxAvail();
};
#endif   // __SANGUART_HPP
