#ifndef TERMINATION_MANAGER_H
#define TERMINATION_MANAGER_H

// Copyright (c) Clifton Labs, Inc.
// All rights reserved.

// CLIFTON LABS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
// SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT
// NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  CLIFTON LABS SHALL NOT BE
// LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, RESULT
// OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors:
//          Dale E. Martin              dmartin@cliftonlabs.com

#include "CommunicatingEntity.h"

/**
   Interface describing a termination manager.
*/

class TerminationManager : public CommunicatingEntity {
public:
  /**
     This method gets called by the kernel to see if it's time to
     terminate.
  */
  virtual bool terminateSimulation() = 0;

  /**
     A type defining our simulation manager's idle status.
  */
  enum SIM_MGR_IDLE_STATUS { IDLE, ACTIVE };

  /**
     Our simulation manager calls this to set our status as active.
  */
  virtual void setStatusActive() = 0;

};

#endif
