/*
 *   Copyright (C) 1997, 1998, 1999 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifndef _html_href_h
#define _html_href_h

#include <uri.h>
#include <html_parser.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Possible values of the info callback argument
 */
#define HTML_URI_BASE		0x01
#define HTML_URI_A		0x02
#define HTML_URI_META		0x04
#define HTML_URI_FRAME		0x08
#define HTML_URI_AREA		0x10
#define HTML_URI_IMG		0x20

typedef int (*html_href_callback_t)(int info, uri_t* uri, void* data);

/*
 * Completely define the context of parsing. 
 */
typedef struct html_href {
  html_parser_t parser;
  /*
   * Additional values for html_content_t info field
   */
  /*
   * Do not keep relative URLs
   */
#define HTML_STRIP_RELATIVE	0x0100

  /*
   * Called whenever a href is recognized
   */
  html_href_callback_t href_callback;
  void* href_data;

} html_href_t;

/*
 * Initialize the arg structure.
 */
void html_href_reset(html_href_t* arg);

/*
 * Translate a string HTML_URI_BASE,HTML_URI_A into the corresponding
 * token integer.
 */
int html_href_string2token(char* string, int string_length);
/*
 * Translate a token (one or more values) into a readable string.
 */
char* html_href_token2string(int token);

/*
 * Run the href parser according to arg specifications (see above)
 */
int html_href_parse(html_href_t* arg);

/*
 * Print all the hrefs
 */
int html_href_parse_print(html_href_t* arg);

/*
 * Main loop for standalone parsers.
 */
int html_href_main(int ac, char **av);

#ifdef __cplusplus
}
#endif

#endif /* _html_href_h */
