<?php
/*
* Configuration file for the WebIssues Server.
*/

/*
* Database configuration.
*
* Create the database and set correct values below before running the setup.php script.
*/

// database engine, can be: 'mysql', 'mysqli', 'pgsql' or 'mssql'
$config[ 'db_engine' ]        = 'mysql';

// database server, can be: 'host', 'host:port', ':/path/to/socket' or 'host\dbinstance'
$config[ 'db_host' ]          = 'localhost';

// database name
$config[ 'db_database' ]      = 'webissues';

// optional: database user login (if blank, integrated authentication is used)
$config[ 'db_user' ]          = 'webissues';

// optional: database user password
$config[ 'db_password' ]      = 'secret';

// optional: prefix of table names (e.g. 'xyz_' so all tables will be 'xyz_table_name')
$config[ 'db_prefix' ]        = '';

/*
* Attachment storage configuration.
*
* Create the storage directory with write permissions for the HTTP server.
* The path can be absolute or relative to index.php.
*/

// optional: path of the storage folder (if blank, file storage is disabled)
$config[ 'storage_path' ]     = 'storage';

// minimum size of attachments stored as files
$config[ 'storage_min_size' ] = 4000;

/*
* Logging configuration.
*
* Enter a file path to enable the appropriate log, otherwise leave blank.
* The log directory must exist and must be writable for the HTTP server.
* Paths can be absolute or relative to index.php.
*/

// optional: logging PHP and SQL errors
$config[ 'log_errors' ]       = 'log/errors.log';

// optional: logging commands from the client and server responses (warning: use for debugging only)
$config[ 'log_commands' ]     = '';

// optional: logging SQL queries (warning: use for debugging only)
$config[ 'log_sql' ]          = '';
