/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "filtervalueeditors.h"

#include <QSpinBox>

using namespace WebIssues;

/* TRANSLATOR WebIssues::AgeValueEditor */

AgeValueEditor::AgeValueEditor( QObject* parent, QWidget* parentWidget ) :
    AbstractValueEditor( parent )
{
    QSpinBox* spin = new QSpinBox( parentWidget );
    spin->setRange( 1, 10000 );
    spin->setSuffix( tr( " days" ) );

    setWidget( spin );
}

AgeValueEditor::~AgeValueEditor()
{
}

void AgeValueEditor::setValue( const QString& value )
{
    QSpinBox* spin = (QSpinBox*)widget();
    spin->setValue( value.toInt() / 86400 );
}

QString AgeValueEditor::value()
{
    QSpinBox* spin = (QSpinBox*)widget();
    return QString::number( spin->value() * 86400 );
}
