#!/usr/local/bin/perl
# index.cgi
# Display hosts on which software packages are being managed, a form for
# finding existing packages and a form for installing more

require './cluster-software-lib.pl';
&ui_print_header(undef, $text{'index_title'}, "", "intro", 1, 1);

# Display hosts on which software will be installed
print "<h3>$text{'index_hosts'}</h3>\n";
@servers = &list_servers();
@hosts = &list_software_hosts();
if ($config{'sort_mode'} == 1) {
	@hosts = sort { my ($as) = grep { $_->{'id'} == $a->{'id'} } @servers;
			my ($bs) = grep { $_->{'id'} == $b->{'id'} } @servers;
			lc($as->{'host'}) cmp lc($bs->{'host'}) } @hosts;
	}
elsif ($config{'sort_mode'} == 2) {
	@hosts = sort { my ($as) = grep { $_->{'id'} == $a->{'id'} } @servers;
			my ($bs) = grep { $_->{'id'} == $b->{'id'} } @servers;
			lc(&server_name($as)) cmp lc(&server_name($bs)) }@hosts;
	}
$formno = 0;
foreach $h (@hosts) {
	local ($s) = grep { $_->{'id'} == $h->{'id'} } @servers;
	next if (!$s);
	local $count = @{$h->{'packages'}};
	push(@titles, ($s->{'desc'} ? $s->{'desc'}
				   : "$s->{'host'}:$s->{'port'}")."<br>".
		      &text('index_count', $count));
	push(@links, "edit_host.cgi?id=$h->{'id'}");
	push(@icons, "$gconfig{'webprefix'}/servers/images/$s->{'type'}.gif");
	push(@installed, $count);
	$gothost{$h->{'id'}}++;
	}
if (@links) {
	&icons_table(\@links, \@titles, \@icons);
	}
else {
	print "<b>$text{'index_nohosts'}</b><p>\n";
	}
$formno++;

# Show form for adding a server
print "<table width=100%><tr>\n";
@addservers = grep { !$gothost{$_->{'id'}} } @servers;
if (@addservers) {
	print "<form action=add.cgi>\n";
	print "<td width=33%>\n";
	print "<input type=submit name=add value='$text{'index_add'}'>\n";
	print "<select name=server>\n";
	foreach $s (@addservers) {
		print "<option value=$s->{'id'}>",
			$s->{'desc'} ? $s->{'desc'} : $s->{'host'},"\n";
		}
	print "</select></td>\n";
	print "</form>\n";
	}

# Show button for compare form
if (@servers) {
	print "<form action=compare_form.cgi>\n";
	print "<td align=center width=33%>\n";
	print "<input type=submit value='$text{'index_compare'}'>\n";
	print "</td>\n";
	print "</form>\n";
	}

# Show form for adding a group of servers
@groups = &servers::list_all_groups(\@servers);
if (@groups) {
	print "<form action=add.cgi>\n";
	print "<td align=right width=33%>\n";
	print "<input type=submit name=gadd value='$text{'index_gadd'}'>\n";
	print "<select name=group>\n";
	foreach $g (@groups) {
		print "<option>$g->{'name'}\n";
		}
	print "</select></td>\n";
	print "</form>\n";
	}
print "</tr></table>\n";

if (@hosts) {
	# Display search form
	print "<hr>\n";
	print "<h3>$text{'index_installed'}</h3>\n";
	print "<table cellpadding=0 cellspacing=0 width=100%><tr><td>\n";
	$formno += 2;
	print "<form action=search.cgi>\n";
	print "<input type=submit value=\"$text{'index_search'}\">\n";
	print "<input name=search size=30>\n";
	print "</form></td>\n";

	print "<td align=right><form action=refresh.cgi>\n";
	print "<input type=submit value=\"$text{'index_refresh'}\">\n";
	print "</form></td> </tr></table>\n";

	# Display cross-cluster install form
	print "<hr>\n";
	print "<h3>$text{'index_install'}</h3>\n";
	print "$text{'index_installmsg'}<p>\n";
	print "<form action=install_pack.cgi method=post ",
	      "enctype=multipart/form-data>\n";
	print "<input type=radio name=source value=0 checked> $text{'index_local'}\n";
	print "<input name=local size=50>\n";
	print &file_chooser_button("local", 0, $formno); print "<br>\n";
	print "<input type=radio name=source value=1> $text{'index_uploaded'}\n";
	print "<input type=file name=upload size=20><br>\n";
	print "<input type=radio name=source value=2> $text{'index_ftp'}\n";
	print "<input name=url size=50><br>\n";
	print "&nbsp;" x 5,"<input type=checkbox name=down value=1> ",
	      "$text{'index_down'}<br>\n";

	print "<input type=submit value=\"$text{'index_installok'}\">\n";
	print "</form>\n";
	}

&ui_print_footer("/", $text{'index'});

