#!/usr/local/bin/perl
# autoreply.pl
# Simple autoreply script

# read sendmail module config
$p = -l $0 ? readlink($0) : $0;
$p =~ /^(.*)\/[^\/]+$/;
if (open(CONF, "$1/config")) {
	while(<CONF>) {
		if (/^(\S+)=(.*)/) {
			$config{$1} = $2;
			}
		}
	close(CONF);
	}
else {
	# Make some guesses about sendmail
	if (-x "/usr/sbin/sendmail") {
		%config = ( 'sendmail_path' => '/usr/sbin/sendmail' );
		}
	elsif (-x "/usr/lib/sendmail") {
		%config = ( 'sendmail_path' => '/usr/lib/sendmail' );
		}
	else {
		die "Failed to find sendmail or config file";
		}
	}

# read headers and body
while(<STDIN>) {
	s/\r|\n//g;
	if (/^(\S+):\s+(.*)/) {
		$header{lc($1)} = $2;
		}
	elsif (!$_) { last; }
	}
while(<STDIN>) {
	$body .= $_;
	}
if ($header{'from'} =~ /mailer-daemon/i) {
	print STDERR "Cancelling autoreply to bounced email\n";
	exit 1;
	}
if ($header{'x-webmin-autoreply'}) {
	print STDERR "Cancelling autoreply to an autoreply\n";
	exit 1;
	}

# work out the correct to address
@to = split(/\s*,\s*/, $header{'to'});
$to = $to[0];
foreach $t (@to) {
	if ($t =~ /([^<>\s,'"\@]+)\@([A-z0-9\-\.\!]+)/ && $1 eq $ARGV[1]) {
		$to = $t;
		}
	}

# build list of default reply headers
$rheader{'From'} = $to;
$rheader{'To'} = $header{'reply-to'} ? $header{'reply-to'}
				     : $header{'from'};
$rheader{'Subject'} = "Autoreply to $header{'subject'}";
$rheader{'X-Webmin-Autoreply'} = 1;
$rheader{'X-Originally-To'} = $header{'to'};

# read the autoreply file
if (open(AUTO, $ARGV[0])) {
	while(<AUTO>) {
		s/\$SUBJECT/$header{'subject'}/g;
		s/\$FROM/$header{'from'}/g;
		s/\$TO/$to/g;
		s/\$DATE/$header{'date'}/g;
		s/\$BODY/$body/g;
		if (/^(\S+):\s*(.*)/ && !$doneheaders) {
			$rheader{$1} = $2;
			}
		else {
			$rbody .= $_;
			$doneheaders = 1;
			}
		}
	close(AUTO);
	}
else {
	$rbody = "Autoreply file $ARGV[0] does not exist!\n";
	}

# run sendmail and feed it the reply
open(MAIL, "|$config{'sendmail_path'} -t");
foreach $h (keys %rheader) {
	print MAIL "$h: $rheader{$h}\n";
	}
print MAIL "\n";
print MAIL $rbody;
close(MAIL);

