# webmin-lib.pl
# Common functions for configuring miniserv

do '../web-lib.pl';
&init_config("webmin");

@cs_codes = ( 'cs_page', 'cs_text', 'cs_table', 'cs_header', 'cs_link' );
@cs_names = map { $text{$_} } @cs_codes;

$update_host = "www.webmin.com";
$update_port = 80;
$update_page = "/updates/updates.txt";

sub setup_ca
{
local $conf = `cat ../acl/openssl.cnf`;
local $acl = "$config_directory/acl";
$conf =~ s/DIRECTORY/$acl/g;
&lock_file("$acl/openssl.cnf");
open(CONF, ">$acl/openssl.cnf");
print CONF $conf;
close(CONF);
&unlock_file("$acl/openssl.cnf");
&lock_file("$acl/index.txt");
open(INDEX, ">$acl/index.txt");
close(INDEX);
&unlock_file("$acl/index.txt");
&lock_file("$acl/serial");
open(SERIAL, ">$acl/serial");
print SERIAL "011E\n";
close(SERIAL);
&unlock_file("$acl/serial");
&lock_file("$acl/newcerts");
mkdir("$acl/newcerts", 0755);
&unlock_file("$acl/newcerts");
$miniserv{'ca'} = "$acl/ca.pem";
}

# list_themes()
# Returns an array of all installed themes
sub list_themes
{
local @rv;
opendir(DIR, "..");
foreach $m (readdir(DIR)) {
	local %tinfo;
	next if ($m =~ /^\./);
	next if (!&read_file("../$m/theme.info", \%tinfo));
	next if (!&check_os_support(\%tinfo));
	if ($tinfo{'desc_'.$current_lang}) {
		$tinfo{'desc'} = $tinfo{'desc_'.$current_lang};
		}
	$tinfo{'dir'} = $m;
	push(@rv, \%tinfo);
	}
closedir(DIR);
return @rv;
}

# install_webmin_module(file, unlink, &descs, &dirs, &sizes, nodeps)
# Installs a webmin module or theme, or calls &error()
sub install_webmin_module
{
local ($file, $need_unlink, $mdescs, $mdirs, $msizes) = @_;

# Uncompress the module file if needed
open(MFILE, $file);
read(MFILE, $two, 2);
close(MFILE);
if ($two eq "\037\235") {
	if (!&has_command("uncompress")) {
		unlink($file) if ($need_unlink);
		&error(&text('install_ecomp', "<tt>uncompress</tt>"));
		}
	local $temp = $file =~ /\/([^\/]+)\.Z/i ? &tempname("$1")
						: &tempname();
	local $out = `uncompress -c "$file" 2>&1 >$temp`;
	unlink($file) if ($need_unlink);
	if ($?) {
		unlink($temp);
		&error(&text('install_ecomp2', $out));
		}
	$file = $temp;
	$need_unlink = 1;
	}
elsif ($two eq "\037\213") {
	if (!&has_command("gunzip")) {
		unlink($file) if ($need_unlink);
		&error(&text('install_egzip', "<tt>gunzip</tt>"));
		}
	local $temp = $file =~ /\/([^\/]+)\.gz/i ? &tempname("$1")
						 : &tempname();
	local $out = `gunzip -c "$file" 2>&1 >$temp`;
	unlink($file) if ($need_unlink);
	if ($?) {
		unlink($temp);
		&error(&text('install_egzip2', $out));
		}
	$file = $temp;
	$need_unlink = 1;
	}

# Check if this is an RPM webmin module or theme
local ($type, $redirect_to);
open(TYPE, "../install-type");
chop($type = <TYPE>);
close(TYPE);
if ($type eq 'rpm' && $file =~ /\.rpm$/i &&
    ($out = `rpm -qp $file 2>/dev/null`)) {
	# Looks like an RPM of some kind, hopefully an RPM webmin module
	# or theme
	local ($out, %minfo, %tinfo);
	$out =~ /^(wbm|wbt)-([^\s\-]+)/ || &inst_error($text{'install_erpm'});
	$redirect_to = $name = $2;
	$out = &backquote_logged("rpm -U \"$file\" 2>&1");
	if ($?) {
		&inst_error(&text('install_eirpm', "<tt>$out</tt>"));
		}

	chop($mdirs->[0] = `cd ../$name ; pwd`);
	if (%minfo = &get_module_info($name)) {
		# Get the new module info
		$mdescs->[0] = $minfo{'desc'};
		$msizes->[0] = &disk_usage_kb("../$name");

		# Update the ACL for this user
		local %acl;
		&read_acl(undef, \%acl);
		open(ACL, "> ".&acl_filename());
		foreach $u (keys %acl) {
			local @mods = @{$acl{$u}};
			if ($u eq $base_remote_user) {
				push(@mods, $name);
				@mods = &unique(@mods);
				}
			print ACL "$u: ",join(' ', @mods),"\n";
			}
		close(ACL);
		&webmin_log("install", undef, $name,
			    { 'desc' => $mdescs->[0] });
		}
	elsif (%tinfo = &get_theme_info($name)) {
		# Get the theme info
		$mdescs->[0] = $tinfo{'desc'};
		$msizes->[0] = &disk_usage_kb("../$name");
		&webmin_log("tinstall", undef, $name,
			    { 'desc' => $mdescs->[0] });
		}
	else {
		&error($text{'install_eneither'});
		}
	}
else {
	# Check if this is a valid module (a tar file of multiple module or
	# theme directories)
	local (%mods, %hasfile);
	local $tar = `tar tf "$file" 2>&1`;
	if ($?) { &inst_error(&text('install_etar', $tar)); }
	foreach $f (split(/\n/, $tar)) {
		if ($f =~ /^\.\/([^\/]+)\/(.*)$/ || $f =~ /^([^\/]+)\/(.*)$/) {
			$redirect_to = $1 if (!$redirect_to);
			$mods{$1}++;
			$hasfile{$1,$2}++;
			}
		}
	foreach $m (keys %mods) {
		$hasfile{$m,"module.info"} || $hasfile{$m,"theme.info"} ||
			&inst_error(&text('install_einfo', "<tt>$m</tt>"));
		}
	if (!%mods) {
		&inst_error($text{'install_enone'});
		}

	# Get the module.info files to check dependancies
	local $ver = &get_webmin_version();
	local $tmpdir = &tempname();
	mkdir($tmpdir, 0700);
	local $err;
	local @realmods;
	foreach $m (keys %mods) {
		next if (!$hasfile{$m,"module.info"});
		push(@realmods, $m);
		local %minfo;
		system("cd $tmpdir ; tar xf \"$file\" $m/module.info ./$m/module.info >/dev/null 2>&1");
		if (!&read_file("$tmpdir/$m/module.info", \%minfo)) {
			$err = &text('install_einfo', "<tt>$m</tt>");
			}
		elsif (!&check_os_support(\%minfo)) {
			$err = &text('install_eos', "<tt>$m</tt>",
				     $gconfig{'real_os_type'},
				     $gconfig{'real_os_version'});
			}
		elsif (!$_[5]) {
			foreach $dep (split(/\s+/, $minfo{'depends'})) {
				if ($dep =~ /^[0-9\.]+$/) {
					if ($dep > $ver) {
						$err = &text('install_ever',
							"<tt>$m</tt>",
							"<tt>$dep</tt>");
						}
					}
				elsif (!-r "../$dep/module.info" &&
				       !$mods{$dep}) {
					$err = &text('install_edep',
					        "<tt>$m</tt>", "<tt>$dep</tt>");
					}
				}
			foreach $dep (split(/\s+/, $minfo{'perldepends'})) {
				eval "use $dep";
				if ($@) {
					$err = &text('install_eperldep',
					     "<tt>$m</tt>", "<tt>$dep</tt>",
					     "/cpan/download.cgi?source=3&cpan=$dep");
					}
				}
			}
		last if ($err);
		}
	system("rm -rf $tmpdir >/dev/null 2>&1");
	&inst_error($err) if ($err);

	# Delete modules or themes being replaced
	foreach $m (@realmods) {
		system("rm -rf '../$m' 2>&1 >/dev/null") if ($m ne 'webmin');
		}

	# Extract all the modules and update perl path and ownership
	local $out = `cd .. ; tar xf "$file" 2>&1 >/dev/null`;
	if ($?) { &inst_error(&text('install_eextract', $out)); }
	if ($need_unlink) { unlink($file); }
	local $perl;
	open(PERL, $0);
	<PERL> =~ /^#!(\S+)/; $perl = $1;
	close(PERL);
	local @st = stat($0);
	foreach $moddir (keys %mods) {
		chdir("../$moddir");
		if ($hasfile{$moddir,"module.info"}) {
			local %minfo = &get_module_info($moddir);
			push(@$mdescs, $minfo{'desc'});
			chop($pwd = `pwd`); push(@$mdirs, $pwd);
			push(@$msizes, &disk_usage_kb("."));
			&webmin_log("install", undef, $moddir,
				    { 'desc' => $minfo{'desc'} });
			}
		else {
			local %tinfo;
			&read_file("theme.info", \%tinfo);
			push(@$mdescs, $tinfo{'desc'});
			chop($pwd = `pwd`); push(@$mdirs, $pwd);
			push(@$msizes, &disk_usage_kb("."));
			&webmin_log("tinstall", undef, $moddir,
				    { 'desc' => $tinfo{'desc'} });
			}
		system("(find . -name '*.cgi' ; find . -name '*.pl') 2>/dev/null | xargs $perl ../perlpath.pl $perl");
		system("chown -R $st[4]:$st[5] .");
		}

	# Copy appropriate config file from modules to /etc/webmin
	system("$perl ../copyconfig.pl $gconfig{'os_type'} $gconfig{'os_version'} .. $config_directory ".join(' ', @realmods));

	# Update ACL for this user so they can access the new modules
	local %acl;
	&read_acl(undef, \%acl);
	open(ACL, "> ".&acl_filename());
	foreach $u (keys %acl) {
		local @mods = @{$acl{$u}};
		if ($u eq $base_remote_user) {
			push(@mods, @realmods);
			@mods = &unique(@mods);
			}
		print ACL "$u: ",join(' ', @mods),"\n";
		}
	close(ACL);
	}
return $redirect_to;
}

1;
