/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

using namespace std;

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdio.h> /* for snprintf */
#include <sstream>

#include "timediff.h"
#include "defs.h"


string
timediff_tostr(time_t start, time_t end) {
  char str[3 + 3 + 3 + 2 + 1];
  int days, hours, mins, secs;
  time_t diff;

  if (end == 0)
    return "-";

  diff = end - start;
  if (diff < 0)
    return "??";

  days = diff / 86400; /* days */
  diff = diff % 86400;
  hours = diff / 3600; /* hours */
  diff = diff % 3600;
  mins = diff / 60;
  diff = diff % 60;
  secs = diff;

  // not a very satisfying way of doing things ALL@@3
  snprintf(str, sizeof(str), "%02d:%02d:%02d:%02d",
	   days, hours, mins, secs);
  return str;
}

string
timediff_tohumanstr(time_t start, time_t end) {
  ostringstream os;
  int days, hours, mins, secs;
  time_t diff;
  bool notfirst = false;

  if (end == 0)
    return "-";

  diff = end - start;
  if (diff < 0)
    return "??";

  days = diff / 86400; /* days */
  diff = diff % 86400;
  hours = diff / 3600; /* hours */
  diff = diff % 3600;
  mins = diff / 60;
  diff = diff % 60;
  secs = diff;

  if (days) {
    os << days << ' ' << _("days");
    notfirst = true;
  }
  if (hours) {
    if (notfirst) os << ' ';
    os << hours << ' ' << _("hours");
    notfirst = true;
  }
  if (mins) {
    if (notfirst) os << ' ';
    os << mins << ' ' << _("mins");
    notfirst = true;
  }
  if (secs || !notfirst) {
    if (notfirst) os << ' ';
    os << secs << ' ' << _("secs");
  }
  return os.str();
}
