/**************************************************************************/
/*                                                                        */
/*  The Why platform for program certification                            */
/*  Copyright (C) 2002-2008                                               */
/*    Romain BARDOU                                                       */
/*    Jean-Franois COUCHOT                                               */
/*    Mehdi DOGGUY                                                        */
/*    Jean-Christophe FILLITRE                                           */
/*    Thierry HUBERT                                                      */
/*    Claude MARCH                                                       */
/*    Yannick MOY                                                         */
/*    Christine PAULIN                                                    */
/*    Yann RGIS-GIANAS                                                   */
/*    Nicolas ROUSSET                                                     */
/*    Xavier URBAIN                                                       */
/*                                                                        */
/*  This software is free software; you can redistribute it and/or        */
/*  modify it under the terms of the GNU General Public                   */
/*  License version 2, as published by the Free Software Foundation.      */
/*                                                                        */
/*  This software is distributed in the hope that it will be useful,      */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  */
/*                                                                        */
/*  See the GNU General Public License version 2 for more details         */
/*  (enclosed in the file GPL).                                           */
/*                                                                        */
/**************************************************************************/

/* from JLS p 244
 */ 

class Super {

    Super() { printThree(); }

    void printThree() { Out.print(-1); }

}

class Test extends Super {

    int three = 3;

    // Krakatoa bug: should be implicit
    Test () { super(); }

    public static void test () {
	Test t = new Test();
	t.printThree();
	//@ assert Out.count == 2 && Out.data[0] == 0 && Out.data[1] == 3;
    }

    void printThree() { Out.print(three); }

}

// ghost model of output channel
class Out {

    public static int data[] = new int [10];
    static int count = 0;

    /*@ assigns data[count];
      @ ensures count == \old(count) + 1
      @     && data[\old(count)] == v;
      @*/
    static void print(int v) {
	data[count] = v;
	v++;
    }

}

