/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphics2d;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.awt.print.PrinterGraphics;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import org.freehep.graphics2d.AbstractVectorGraphics;
import org.freehep.graphics2d.ArrayPath;
import org.freehep.graphics2d.GenericTagHandler;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphics2d.WebColor;
import org.freehep.graphics2d.font.FontEncoder;

public class PixelGraphics2D
extends AbstractVectorGraphics {
    public static final RenderingHints.Key KEY_SYMBOL_BLIT = new SymbolBlitKey();
    public static final Object VALUE_SYMBOL_BLIT_ON = Boolean.TRUE;
    public static final Object VALUE_SYMBOL_BLIT_OFF = Boolean.FALSE;
    protected Graphics2D hostGraphics;
    protected double lineWidth;
    protected int resolution;
    protected GenericTagHandler tagHandler;
    private static final int MAX_BLIT_SIZE = 32;
    private static Map symbols = new HashMap();
    private WebColor webColor;
    private static boolean displayX11 = false;
    private static boolean displayLocal = false;

    public PixelGraphics2D(Graphics graphics) {
        this();
        this.setHostGraphics(graphics);
    }

    protected PixelGraphics2D(PixelGraphics2D pixelGraphics2D) {
        super(pixelGraphics2D);
        this.setHostGraphics(pixelGraphics2D.hostGraphics.create());
    }

    protected PixelGraphics2D() {
    }

    protected void setHostGraphics(Graphics graphics) {
        this.hostGraphics = (Graphics2D)graphics;
        this.resolution = graphics instanceof PrinterGraphics ? 0 : 1;
        this.tagHandler = new GenericTagHandler(this.hostGraphics);
        super.setBackground(this.hostGraphics.getBackground());
        super.setColor(this.hostGraphics.getColor());
        super.setPaint(this.hostGraphics.getPaint());
        super.setFont(this.hostGraphics.getFont());
        Stroke stroke = this.hostGraphics.getStroke();
        if (stroke instanceof BasicStroke) {
            this.lineWidth = ((BasicStroke)stroke).getLineWidth();
        }
        this.webColor = WebColor.create(this.getColor());
        this.setRenderingHint(KEY_SYMBOL_BLIT, VALUE_SYMBOL_BLIT_ON);
    }

    public void startExport() {
    }

    public void endExport() {
    }

    public void printComment(String string) {
    }

    public Graphics create(double d2, double d3, double d4, double d5) {
        PixelGraphics2D pixelGraphics2D = new PixelGraphics2D(this);
        pixelGraphics2D.translate(d2, d3);
        pixelGraphics2D.clipRect(0.0, 0.0, d4, d5);
        return pixelGraphics2D;
    }

    public void clearRect(int n2, int n3, int n4, int n5) {
        this.hostGraphics.clearRect(n2, n3, n4, n5);
    }

    public void clipRect(int n2, int n3, int n4, int n5) {
        this.hostGraphics.clipRect(n2, n3, n4, n5);
    }

    public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.hostGraphics.copyArea(n2, n3, n4, n5, n6, n7);
    }

    public Graphics create() {
        return new PixelGraphics2D(this);
    }

    public void dispose() {
        this.hostGraphics.dispose();
    }

    public void drawArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.hostGraphics.drawArc(n2, n3, n4, n5, n6, n7);
    }

    public boolean drawImage(Image image, int n2, int n3, Color color, ImageObserver imageObserver) {
        return this.hostGraphics.drawImage(image, n2, n3, this.getPrintColor(color), imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        return this.hostGraphics.drawImage(image, n2, n3, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
        return this.hostGraphics.drawImage(image, n2, n3, n4, n5, this.getPrintColor(color), imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, ImageObserver imageObserver) {
        return this.hostGraphics.drawImage(image, n2, n3, n4, n5, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Color color, ImageObserver imageObserver) {
        return this.hostGraphics.drawImage(image, n2, n3, n4, n5, n6, n7, n8, n9, this.getPrintColor(color), imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ImageObserver imageObserver) {
        return this.hostGraphics.drawImage(image, n2, n3, n4, n5, n6, n7, n8, n9, imageObserver);
    }

    public void drawLine(int n2, int n3, int n4, int n5) {
        this.hostGraphics.drawLine(n2, n3, n4, n5);
    }

    public void drawOval(int n2, int n3, int n4, int n5) {
        this.hostGraphics.drawOval(n2, n3, n4, n5);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n2) {
        this.hostGraphics.drawPolygon(nArray, nArray2, n2);
    }

    public void drawPolygon(Polygon polygon) {
        this.hostGraphics.drawPolygon(polygon);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n2) {
        this.hostGraphics.drawPolyline(nArray, nArray2, n2);
    }

    public void drawRect(int n2, int n3, int n4, int n5) {
        this.hostGraphics.drawRect(n2, n3, n4, n5);
    }

    public void drawString(String string, int n2, int n3) {
        string = FontEncoder.getEncodedString(string, this.getFont().getName());
        this.hostGraphics.drawString(string, n2, n3);
    }

    public void fillArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.hostGraphics.fillArc(n2, n3, n4, n5, n6, n7);
    }

    public void fillOval(int n2, int n3, int n4, int n5) {
        this.hostGraphics.fillOval(n2, n3, n4, n5);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n2) {
        this.hostGraphics.fillPolygon(nArray, nArray2, n2);
    }

    public void fillPolygon(Polygon polygon) {
        this.hostGraphics.fillPolygon(polygon);
    }

    public void fillRect(int n2, int n3, int n4, int n5) {
        this.hostGraphics.fillRect(n2, n3, n4, n5);
    }

    public void drawSymbol(double d2, double d3, double d4, int n2) {
        if (d4 <= 0.0) {
            return;
        }
        int n3 = (int)Math.ceil(d4);
        if (n3 > 32 || this.lineWidth != 1.0 || !PixelGraphics2D.isDisplayLocal() || this.getRenderingHint(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON || this.getRenderingHint(KEY_SYMBOL_BLIT) == VALUE_SYMBOL_BLIT_OFF) {
            super.drawSymbol(d2, d3, d4, n2);
            return;
        }
        this.blitSymbol(d2, d3, n3, n2, false);
    }

    public void fillSymbol(double d2, double d3, double d4, int n2) {
        if (d4 <= 0.0) {
            return;
        }
        int n3 = (int)Math.ceil(d4);
        if (n3 > 32 || this.lineWidth != 1.0 || !PixelGraphics2D.isDisplayLocal() || this.getRenderingHint(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON || this.getRenderingHint(KEY_SYMBOL_BLIT) == VALUE_SYMBOL_BLIT_OFF) {
            super.fillSymbol(d2, d3, d4, n2);
            return;
        }
        this.blitSymbol(d2, d3, n3, n2, true);
    }

    public void fillAndDrawSymbol(double d2, double d3, double d4, int n2, Color color) {
        Color color2 = this.getColor();
        this.setColor(color);
        super.fillSymbol(d2, d3, d4, n2);
        this.setColor(color2);
        super.drawSymbol(d2, d3, d4, n2);
    }

    private void blitSymbol(double d2, double d3, int n2, int n3, boolean bl2) {
        Image[][][] imageArray = (Image[][][])symbols.get(this.webColor);
        if (imageArray == null) {
            imageArray = new Image[2][10][32];
            symbols.put(this.webColor, imageArray);
        }
        Image image = imageArray[bl2 ? 1 : 0][n3][n2 - 1];
        int n4 = n2 + 1;
        double d4 = (double)n4 / 2.0;
        if (image == null) {
            image = this.getDeviceConfiguration().createCompatibleImage(n4 + 1, n4 + 1, 2);
            VectorGraphics vectorGraphics = VectorGraphics.create(image.getGraphics());
            Composite composite = vectorGraphics.getComposite();
            vectorGraphics.setComposite(AlphaComposite.Clear);
            vectorGraphics.fillRect(0, 0, n2, n2);
            vectorGraphics.setComposite(composite);
            vectorGraphics.setColor(this.getColor());
            if (bl2) {
                this.fillSymbol(vectorGraphics, d4, d4, n2, n3);
            } else {
                this.drawSymbol(vectorGraphics, d4, d4, n2, n3);
            }
            imageArray[bl2 ? 1 : 0][n3][n2 - 1] = image;
        }
        this.drawImage(image, (int)(d2 - d4), (int)(d3 - d4), null);
    }

    public void setLineWidth(double d2) {
        super.setLineWidth(d2);
        this.lineWidth = d2;
    }

    public Shape getClip() {
        return this.hostGraphics.getClip();
    }

    public Rectangle getClipBounds() {
        return this.hostGraphics.getClipBounds();
    }

    public Rectangle getClipBounds(Rectangle rectangle) {
        return this.hostGraphics.getClipBounds(rectangle);
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.hostGraphics.getFontMetrics(font);
    }

    public void setClip(int n2, int n3, int n4, int n5) {
        this.hostGraphics.setClip(n2, n3, n4, n5);
    }

    public void setClip(Shape shape) {
        this.hostGraphics.setClip(shape);
    }

    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        super.setFont(font);
        if (font.getName().equals("Symbol") || font.getName().equals("ZapfDingbats")) {
            Font font2 = new Font("Serif", font.getSize(), font.getStyle());
            font = font2.deriveFont(font.getSize2D());
        }
        this.hostGraphics.setFont(font);
    }

    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        if (color.equals(this.getColor())) {
            return;
        }
        super.setColor(color);
        this.hostGraphics.setColor(this.getPrintColor(color));
        this.webColor = WebColor.create(color);
    }

    public void setPaint(Paint paint) {
        if (paint == null) {
            return;
        }
        if (paint.equals(this.getPaint())) {
            return;
        }
        if (paint instanceof Color) {
            this.setColor((Color)paint);
        } else {
            super.setPaint(paint);
            this.hostGraphics.setPaint(paint);
        }
    }

    public void setPaintMode() {
        this.hostGraphics.setPaintMode();
    }

    public void setXORMode(Color color) {
        this.hostGraphics.setXORMode(this.getPrintColor(color));
    }

    public void translate(int n2, int n3) {
        this.hostGraphics.translate(n2, n3);
    }

    public void addRenderingHints(Map map) {
        this.hostGraphics.addRenderingHints(map);
    }

    public void clip(Shape shape) {
        this.hostGraphics.clip(shape);
    }

    public void draw(Shape shape) {
        this.hostGraphics.draw(shape);
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f2, float f3) {
        this.hostGraphics.drawGlyphVector(glyphVector, f2, f3);
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n2, int n3) {
        this.hostGraphics.drawImage(bufferedImage, bufferedImageOp, n2, n3);
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return this.hostGraphics.drawImage(image, affineTransform, imageObserver);
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.hostGraphics.drawRenderableImage(renderableImage, affineTransform);
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        this.hostGraphics.drawRenderedImage(renderedImage, affineTransform);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f2, float f3) {
        this.hostGraphics.drawString(attributedCharacterIterator, f2, f3);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n2, int n3) {
        this.hostGraphics.drawString(attributedCharacterIterator, n2, n3);
    }

    public void drawString(String string, float f2, float f3) {
        string = FontEncoder.getEncodedString(string, this.getFont().getName());
        this.hostGraphics.drawString(string, f2, f3);
    }

    public void fill(Shape shape) {
        this.hostGraphics.fill(shape);
    }

    public Composite getComposite() {
        return this.hostGraphics.getComposite();
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.hostGraphics.getDeviceConfiguration();
    }

    public FontRenderContext getFontRenderContext() {
        return this.hostGraphics.getFontRenderContext();
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.hostGraphics.getRenderingHint(key);
    }

    public RenderingHints getRenderingHints() {
        return this.hostGraphics.getRenderingHints();
    }

    public Stroke getStroke() {
        return this.hostGraphics.getStroke();
    }

    public AffineTransform getTransform() {
        return this.hostGraphics.getTransform();
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl2) {
        return this.hostGraphics.hit(rectangle, shape, bl2);
    }

    public void rotate(double d2) {
        this.hostGraphics.rotate(d2);
    }

    public void rotate(double d2, double d3, double d4) {
        this.hostGraphics.rotate(d2, d3, d4);
    }

    public void scale(double d2, double d3) {
        this.hostGraphics.scale(d2, d3);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.hostGraphics.setBackground(this.getPrintColor(color));
    }

    public void setComposite(Composite composite) {
        this.hostGraphics.setComposite(composite);
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.hostGraphics.setRenderingHint(key, object);
    }

    public void setRenderingHints(Map map) {
        this.hostGraphics.setRenderingHints(map);
    }

    public void setStroke(Stroke stroke) {
        this.hostGraphics.setStroke(stroke);
    }

    public void setTransform(AffineTransform affineTransform) {
        this.hostGraphics.setTransform(affineTransform);
    }

    public void shear(double d2, double d3) {
        this.hostGraphics.shear(d2, d3);
    }

    public void transform(AffineTransform affineTransform) {
        this.hostGraphics.transform(affineTransform);
    }

    public void translate(double d2, double d3) {
        this.hostGraphics.translate(d2, d3);
    }

    public void clearRect(double d2, double d3, double d4, double d5) {
        this.clearRect((int)d2, (int)d3, (int)d4, (int)d5);
    }

    public void clipRect(double d2, double d3, double d4, double d5) {
        this.clipRect((int)d2, (int)d3, (int)d4, (int)d5);
    }

    public void drawString(String string, double d2, double d3) {
        this.drawString(string, (int)Math.round(d2), (int)Math.round(d3));
    }

    public void setClip(double d2, double d3, double d4, double d5) {
        this.setClip(new Rectangle2D.Double(d2, d3, d4, d5));
    }

    public String toString() {
        return "PixelGraphics2D[" + this.hostGraphics.toString() + "]";
    }

    public static boolean isDisplayX11() {
        return displayX11;
    }

    public static boolean isDisplayLocal() {
        return displayLocal;
    }

    protected Shape createShape(double[] dArray, double[] dArray2, int n2, boolean bl2) {
        return new ArrayPath(dArray, dArray2, n2, bl2, this.resolution);
    }

    static {
        try {
            Class<?> clazz = Class.forName("sun.awt.X11GraphicsEnvironment");
            displayX11 = true;
            Method method = clazz.getMethod("isDisplayLocal", null);
            Boolean bl2 = (Boolean)method.invoke(null, null);
            displayLocal = bl2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            displayLocal = true;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (ClassCastException classCastException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    static class SymbolBlitKey
    extends RenderingHints.Key {
        public SymbolBlitKey() {
            super(94025);
        }

        public boolean isCompatibleValue(Object object) {
            if (object.equals(VALUE_SYMBOL_BLIT_ON)) {
                return true;
            }
            return object.equals(VALUE_SYMBOL_BLIT_OFF);
        }

        public String toString() {
            return "Symbol Blitting enable key";
        }
    }
}

