/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphics2d.font;

import org.freehep.graphics2d.font.CharTable;
import org.freehep.graphics2d.font.Expert;
import org.freehep.graphics2d.font.ISOLatin;
import org.freehep.graphics2d.font.MACLatin;
import org.freehep.graphics2d.font.PDFLatin;
import org.freehep.graphics2d.font.STDLatin;
import org.freehep.graphics2d.font.Symbol;
import org.freehep.graphics2d.font.WINLatin;
import org.freehep.graphics2d.font.Zapfdingbats;

public class Lookup {
    private static Lookup instance;
    private CharTable[] tables = new CharTable[this.ntables];
    private int ntables = 8;

    public static Lookup getInstance() {
        if (instance == null) {
            instance = new Lookup();
        }
        return instance;
    }

    private Lookup() {
        this.tables[0] = new Symbol();
        this.tables[1] = new Expert();
        this.tables[2] = new Zapfdingbats();
        this.tables[3] = new STDLatin();
        this.tables[4] = new MACLatin();
        this.tables[5] = new WINLatin();
        this.tables[6] = new PDFLatin();
        this.tables[7] = new ISOLatin();
    }

    public char toUnicode(String string) {
        for (int i2 = 0; i2 < this.ntables; ++i2) {
            char c2 = this.tables[i2].toUnicode(string);
            if (c2 == '\uffff') continue;
            return c2;
        }
        return '\uffff';
    }

    public String toName(char c2) {
        for (int i2 = 0; i2 < this.ntables; ++i2) {
            String string = this.tables[i2].toName(c2);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public String toName(Character c2) {
        for (int i2 = 0; i2 < this.ntables; ++i2) {
            String string = this.tables[i2].toName(c2);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public CharTable getTable(String string) {
        for (int i2 = 0; i2 < this.ntables; ++i2) {
            String string2 = this.tables[i2].getEncoding() + this.tables[i2].getName();
            if (!string2.equalsIgnoreCase(string)) continue;
            return this.tables[i2];
        }
        return null;
    }

    public int getNumberOfTables() {
        return this.ntables;
    }

    public String[] getTableNames() {
        String[] stringArray = new String[this.ntables];
        for (int i2 = 0; i2 < this.ntables; ++i2) {
            stringArray[i2] = this.tables[i2].getEncoding() + this.tables[i2].getName();
        }
        return stringArray;
    }
}

