package gdi32;

use strict;

require Exporter;

use wine;
use vars qw(@ISA @EXPORT @EXPORT_OK);

@ISA = qw(Exporter);
@EXPORT = qw();
@EXPORT_OK = qw();

my $module_declarations = {
    "AbortDoc" => ["long",  ["long"]],
    "AbortPath" => ["long",  ["long"]],
    "AddFontResourceA" => ["long",  ["str"]],
    "AddFontResourceW" => ["long",  ["wstr"]],
    "AngleArc" => ["long",  ["long", "long", "long", "long", "long", "long"]],
    "AnimatePalette" => ["long",  ["long", "long", "long", "ptr"]],
    "Arc" => ["long",  ["long", "long", "long", "long", "long", "long", "long", "long", "long"]],
    "ArcTo" => ["long",  ["long", "long", "long", "long", "long", "long", "long", "long", "long"]],
    "BeginPath" => ["long",  ["long"]],
    "BitBlt" => ["long",  ["long", "long", "long", "long", "long", "long", "long", "long", "long"]],
    "ChoosePixelFormat" => ["long",  ["long", "ptr"]],
    "Chord" => ["long",  ["long", "long", "long", "long", "long", "long", "long", "long", "long"]],
    "CloseEnhMetaFile" => ["long",  ["long"]],
    "CloseFigure" => ["long",  ["long"]],
    "CloseMetaFile" => ["long",  ["long"]],
    "CloseMetaFile16" => ["long",  ["long"]],
    "CombineRgn" => ["long",  ["long", "long", "long", "long"]],
    "CombineTransform" => ["long",  ["ptr", "ptr", "ptr"]],
    "CopyEnhMetaFileA" => ["long",  ["long", "str"]],
    "CopyMetaFileA" => ["long",  ["long", "str"]],
    "CopyMetaFileW" => ["long",  ["long", "wstr"]],
    "CreateBitmap" => ["long",  ["long", "long", "long", "long", "ptr"]],
    "CreateBitmapIndirect" => ["long",  ["ptr"]],
    "CreateBrushIndirect" => ["long",  ["ptr"]],
    "CreateColorSpaceA" => ["long",  ["ptr"]],
    "CreateColorSpaceW" => ["long",  ["ptr"]],
    "CreateCompatibleBitmap" => ["long",  ["long", "long", "long"]],
    "CreateCompatibleDC" => ["long",  ["long"]],
    "CreateDCA" => ["long",  ["str", "str", "str", "ptr"]],
    "CreateDCW" => ["long",  ["wstr", "wstr", "wstr", "ptr"]],
    "CreateDIBPatternBrush" => ["long",  ["long", "long"]],
    "CreateDIBPatternBrushPt" => ["long",  ["ptr", "long"]],
    "CreateDIBSection" => ["long",  ["long", "ptr", "long", "ptr", "long", "long"]],
    "CreateDIBitmap" => ["long",  ["long", "ptr", "long", "ptr", "ptr", "long"]],
    "CreateDiscardableBitmap" => ["long",  ["long", "long", "long"]],
    "CreateEllipticRgn" => ["long",  ["long", "long", "long", "long"]],
    "CreateEllipticRgnIndirect" => ["long",  ["ptr"]],
    "CreateEnhMetaFileA" => ["long",  ["long", "str", "ptr", "str"]],
    "CreateEnhMetaFileW" => ["long",  ["long", "wstr", "ptr", "wstr"]],
    "CreateFontA" => ["long",  ["long", "long", "long", "long", "long", "long", "long", "long", "long", "long", "long", "long", "long", "str"]],
    "CreateFontIndirectA" => ["long",  ["ptr"]],
    "CreateFontIndirectW" => ["long",  ["ptr"]],
    "CreateFontW" => ["long",  ["long", "long", "long", "long", "long", "long", "long", "long", "long", "long", "long", "long", "long", "wstr"]],
    "CreateHalftonePalette" => ["long",  ["long"]],
    "CreateHatchBrush" => ["long",  ["long", "long"]],
    "CreateICA" => ["long",  ["str", "str", "str", "ptr"]],
    "CreateICW" => ["long",  ["wstr", "wstr", "wstr", "ptr"]],
    "CreateMetaFile16" => ["long",  ["str"]],
    "CreateMetaFileA" => ["long",  ["str"]],
    "CreateMetaFileW" => ["long",  ["wstr"]],
    "CreatePalette" => ["long",  ["ptr"]],
    "CreatePatternBrush" => ["long",  ["long"]],
    "CreatePen" => ["long",  ["long", "long", "long"]],
    "CreatePenIndirect" => ["long",  ["ptr"]],
    "CreatePolyPolygonRgn" => ["long",  ["ptr", "ptr", "long", "long"]],
    "CreatePolygonRgn" => ["long",  ["ptr", "long", "long"]],
    "CreateRectRgn" => ["long",  ["long", "long", "long", "long"]],
    "CreateRectRgnIndirect" => ["long",  ["ptr"]],
    "CreateRoundRectRgn" => ["long",  ["long", "long", "long", "long", "long", "long"]],
    "CreateScalableFontResourceA" => ["long",  ["long", "str", "str", "str"]],
    "CreateScalableFontResourceW" => ["long",  ["long", "wstr", "wstr", "wstr"]],
    "CreateSolidBrush" => ["long",  ["long"]],
    "DPtoLP" => ["long",  ["long", "ptr", "long"]],
    "DeleteColorSpace" => ["long",  ["long"]],
    "DeleteDC" => ["long",  ["long"]],
    "DeleteEnhMetaFile" => ["long",  ["long"]],
    "DeleteMetaFile" => ["long",  ["long"]],
    "DeleteObject" => ["long",  ["long"]],
    "DescribePixelFormat" => ["long",  ["long", "long", "long", "ptr"]],
    "DrawEscape" => ["long",  ["long", "long", "long", "str"]],
    "Ellipse" => ["long",  ["long", "long", "long", "long", "long"]],
    "EndDoc" => ["long",  ["long"]],
    "EndPage" => ["long",  ["long"]],
    "EndPath" => ["long",  ["long"]],
    "EnumEnhMetaFile" => ["long",  ["long", "long", "ptr", "ptr", "ptr"]],
    "EnumFontFamiliesA" => ["long",  ["long", "str", "ptr", "long"]],
    "EnumFontFamiliesExA" => ["long",  ["long", "ptr", "ptr", "long", "long"]],
    "EnumFontFamiliesExW" => ["long",  ["long", "ptr", "ptr", "long", "long"]],
    "EnumFontFamiliesW" => ["long",  ["long", "wstr", "ptr", "long"]],
    "EnumFontsA" => ["long",  ["long", "str", "ptr", "long"]],
    "EnumFontsW" => ["long",  ["long", "wstr", "ptr", "long"]],
    "EnumMetaFile" => ["long",  ["long", "long", "ptr", "long"]],
    "EnumObjects" => ["long",  ["long", "long", "ptr", "long"]],
    "EqualRgn" => ["long",  ["long", "long"]],
    "Escape" => ["long",  ["long", "long", "long", "str", "ptr"]],
    "ExcludeClipRect" => ["long",  ["long", "long", "long", "long", "long"]],
    "ExtCreatePen" => ["long",  ["long", "long", "ptr", "long", "ptr"]],
    "ExtCreateRegion" => ["long",  ["ptr", "long", "ptr"]],
    "ExtEscape" => ["long",  ["long", "long", "long", "str", "long", "str"]],
    "ExtFloodFill" => ["long",  ["long", "long", "long", "long", "long"]],
    "ExtSelectClipRgn" => ["long",  ["long", "long", "long"]],
    "ExtTextOutA" => ["long",  ["long", "long", "long", "long", "ptr", "str", "long", "ptr"]],
    "ExtTextOutW" => ["long",  ["long", "long", "long", "long", "ptr", "wstr", "long", "ptr"]],
    "FillPath" => ["long",  ["long"]],
    "FillRgn" => ["long",  ["long", "long", "long"]],
    "FixBrushOrgEx" => ["long",  ["long", "long", "long", "ptr"]],
    "FlattenPath" => ["long",  ["long"]],
    "FloodFill" => ["long",  ["long", "long", "long", "long"]],
    "FrameRgn" => ["long",  ["long", "long", "long", "long", "long"]],
    "GdiComment" => ["long",  ["long", "long", "ptr"]],
    "GdiFlush" => ["long",  []],
    "GdiGetBatchLimit" => ["long",  []],
    "GdiSetBatchLimit" => ["long",  ["long"]],
    "GetArcDirection" => ["long",  ["long"]],
    "GetAspectRatioFilterEx" => ["long",  ["long", "ptr"]],
    "GetBitmapBits" => ["long",  ["long", "long", "ptr"]],
    "GetBitmapDimensionEx" => ["long",  ["long", "ptr"]],
    "GetBkColor" => ["long",  ["long"]],
    "GetBkMode" => ["long",  ["long"]],
    "GetBoundsRect" => ["long",  ["long", "ptr", "long"]],
    "GetBrushOrgEx" => ["long",  ["long", "ptr"]],
    "GetCharABCWidthsA" => ["long",  ["long", "long", "long", "ptr"]],
    "GetCharABCWidthsFloatA" => ["long",  ["long", "long", "long", "ptr"]],
    "GetCharABCWidthsFloatW" => ["long",  ["long", "long", "long", "ptr"]],
    "GetCharABCWidthsW" => ["long",  ["long", "long", "long", "ptr"]],
    "GetCharWidth32A" => ["long",  ["long", "long", "long", "ptr"]],
    "GetCharWidth32W" => ["long",  ["long", "long", "long", "ptr"]],
    "GetCharWidthA" => ["long",  ["long", "long", "long", "ptr"]],
    "GetCharWidthFloatA" => ["long",  ["long", "long", "long", "ptr"]],
    "GetCharWidthFloatW" => ["long",  ["long", "long", "long", "ptr"]],
    "GetCharWidthW" => ["long",  ["long", "long", "long", "ptr"]],
    "GetCharacterPlacementA" => ["long",  ["long", "str", "long", "long", "ptr", "long"]],
    "GetCharacterPlacementW" => ["long",  ["long", "wstr", "long", "long", "ptr", "long"]],
    "GetClipBox" => ["long",  ["long", "ptr"]],
    "GetClipRgn" => ["long",  ["long", "long"]],
    "GetColorAdjustment" => ["long",  ["long", "ptr"]],
    "GetColorSpace" => ["long",  ["long"]],
    "GetCurrentObject" => ["long",  ["long", "long"]],
    "GetCurrentPositionEx" => ["long",  ["long", "ptr"]],
    "GetDCOrgEx" => ["long",  ["long", "ptr"]],
    "GetDIBColorTable" => ["long",  ["long", "long", "long", "ptr"]],
    "GetDIBits" => ["long",  ["long", "long", "long", "long", "ptr", "ptr", "long"]],
    "GetDeviceCaps" => ["long",  ["long", "long"]],
    "GetDeviceGammaRamp" => ["long",  ["long", "ptr"]],
    "GetEnhMetaFileA" => ["long",  ["str"]],
    "GetEnhMetaFileBits" => ["long",  ["long", "long", "ptr"]],
    "GetEnhMetaFileDescriptionA" => ["long",  ["long", "long", "str"]],
    "GetEnhMetaFileDescriptionW" => ["long",  ["long", "long", "wstr"]],
    "GetEnhMetaFileHeader" => ["long",  ["long", "long", "ptr"]],
    "GetEnhMetaFilePaletteEntries" => ["long",  ["long", "long", "ptr"]],
    "GetEnhMetaFileW" => ["long",  ["wstr"]],
    "GetFontData" => ["long",  ["long", "long", "long", "ptr", "long"]],
    "GetFontLanguageInfo" => ["long",  ["long"]],
    "GetGlyphOutlineA" => ["long",  ["long", "long", "long", "ptr", "long", "ptr", "ptr"]],
    "GetGlyphOutlineW" => ["long",  ["long", "long", "long", "ptr", "long", "ptr", "ptr"]],
    "GetGraphicsMode" => ["long",  ["long"]],
    "GetICMProfileA" => ["long",  ["long", "ptr", "str"]],
    "GetKerningPairsA" => ["long",  ["long", "long", "ptr"]],
    "GetKerningPairsW" => ["long",  ["long", "long", "ptr"]],
    "GetLayout" => ["long",  ["long"]],
    "GetMapMode" => ["long",  ["long"]],
    "GetMetaFileA" => ["long",  ["str"]],
    "GetMetaFileBitsEx" => ["long",  ["long", "long", "ptr"]],
    "GetMetaFileW" => ["long",  ["wstr"]],
    "GetMetaRgn" => ["long",  ["long", "long"]],
    "GetMiterLimit" => ["long",  ["long", "ptr"]],
    "GetNearestColor" => ["long",  ["long", "long"]],
    "GetNearestPaletteIndex" => ["long",  ["long", "long"]],
    "GetObjectA" => ["long",  ["long", "long", "ptr"]],
    "GetObjectType" => ["long",  ["long"]],
    "GetObjectW" => ["long",  ["long", "long", "ptr"]],
    "GetOutlineTextMetricsA" => ["long",  ["long", "long", "ptr"]],
    "GetOutlineTextMetricsW" => ["long",  ["long", "long", "ptr"]],
    "GetPaletteEntries" => ["long",  ["long", "long", "long", "ptr"]],
    "GetPath" => ["long",  ["long", "ptr", "ptr", "long"]],
    "GetPixel" => ["long",  ["long", "long", "long"]],
    "GetPixelFormat" => ["long",  ["long"]],
    "GetPolyFillMode" => ["long",  ["long"]],
    "GetROP2" => ["long",  ["long"]],
    "GetRandomRgn" => ["long",  ["long", "long", "long"]],
    "GetRasterizerCaps" => ["long",  ["ptr", "long"]],
    "GetRegionData" => ["long",  ["long", "long", "ptr"]],
    "GetRelAbs" => ["long",  ["long", "long"]],
    "GetRgnBox" => ["long",  ["long", "ptr"]],
    "GetStockObject" => ["long",  ["long"]],
    "GetStretchBltMode" => ["long",  ["long"]],
    "GetSystemPaletteEntries" => ["long",  ["long", "long", "long", "ptr"]],
    "GetSystemPaletteUse" => ["long",  ["long"]],
    "GetTextAlign" => ["long",  ["long"]],
    "GetTextCharacterExtra" => ["long",  ["long"]],
    "GetTextCharset" => ["long",  ["long"]],
    "GetTextCharsetInfo" => ["long",  ["long", "ptr", "long"]],
    "GetTextColor" => ["long",  ["long"]],
    "GetTextExtentExPointA" => ["long",  ["long", "str", "long", "long", "ptr", "ptr", "ptr"]],
    "GetTextExtentExPointW" => ["long",  ["long", "wstr", "long", "long", "ptr", "ptr", "ptr"]],
    "GetTextExtentPoint32A" => ["long",  ["long", "str", "long", "ptr"]],
    "GetTextExtentPoint32W" => ["long",  ["long", "wstr", "long", "ptr"]],
    "GetTextExtentPointA" => ["long",  ["long", "str", "long", "ptr"]],
    "GetTextExtentPointW" => ["long",  ["long", "wstr", "long", "ptr"]],
    "GetTextFaceA" => ["long",  ["long", "long", "str"]],
    "GetTextFaceW" => ["long",  ["long", "long", "wstr"]],
    "GetTextMetricsA" => ["long",  ["long", "ptr"]],
    "GetTextMetricsW" => ["long",  ["long", "ptr"]],
    "GetViewportExtEx" => ["long",  ["long", "ptr"]],
    "GetViewportOrgEx" => ["long",  ["long", "ptr"]],
    "GetWinMetaFileBits" => ["long",  ["long", "long", "ptr", "long", "long"]],
    "GetWindowExtEx" => ["long",  ["long", "ptr"]],
    "GetWindowOrgEx" => ["long",  ["long", "ptr"]],
    "GetWorldTransform" => ["long",  ["long", "ptr"]],
    "IntersectClipRect" => ["long",  ["long", "long", "long", "long", "long"]],
    "InvertRgn" => ["long",  ["long", "long"]],
    "LPtoDP" => ["long",  ["long", "ptr", "long"]],
    "LineDDA" => ["long",  ["long", "long", "long", "long", "ptr", "long"]],
    "LineTo" => ["long",  ["long", "long", "long"]],
    "MaskBlt" => ["long",  ["long", "long", "long", "long", "long", "long", "long", "long", "long", "long", "long", "long"]],
    "ModifyWorldTransform" => ["long",  ["long", "ptr", "long"]],
    "MoveToEx" => ["long",  ["long", "long", "long", "ptr"]],
    "OffsetClipRgn" => ["long",  ["long", "long", "long"]],
    "OffsetRgn" => ["long",  ["long", "long", "long"]],
    "OffsetViewportOrgEx" => ["long",  ["long", "long", "long", "ptr"]],
    "OffsetWindowOrgEx" => ["long",  ["long", "long", "long", "ptr"]],
    "PaintRgn" => ["long",  ["long", "long"]],
    "PatBlt" => ["long",  ["long", "long", "long", "long", "long", "long"]],
    "PathToRegion" => ["long",  ["long"]],
    "Pie" => ["long",  ["long", "long", "long", "long", "long", "long", "long", "long", "long"]],
    "PlayEnhMetaFile" => ["long",  ["long", "long", "ptr"]],
    "PlayEnhMetaFileRecord" => ["long",  ["long", "ptr", "ptr", "long"]],
    "PlayMetaFile" => ["long",  ["long", "long"]],
    "PlayMetaFileRecord" => ["long",  ["long", "ptr", "ptr", "long"]],
    "PlgBlt" => ["long",  ["long", "ptr", "long", "long", "long", "long", "long", "long", "long", "long"]],
    "PolyBezier" => ["long",  ["long", "ptr", "long"]],
    "PolyBezierTo" => ["long",  ["long", "ptr", "long"]],
    "PolyDraw" => ["long",  ["long", "ptr", "ptr", "long"]],
    "PolyPolygon" => ["long",  ["long", "ptr", "ptr", "long"]],
    "PolyPolyline" => ["long",  ["long", "ptr", "ptr", "long"]],
    "PolyTextOutA" => ["long",  ["long", "ptr", "long"]],
    "PolyTextOutW" => ["long",  ["long", "ptr", "long"]],
    "Polygon" => ["long",  ["long", "ptr", "long"]],
    "Polyline" => ["long",  ["long", "ptr", "long"]],
    "PolylineTo" => ["long",  ["long", "ptr", "long"]],
    "PtInRegion" => ["long",  ["long", "long", "long"]],
    "PtVisible" => ["long",  ["long", "long", "long"]],
    "RealizePalette" => ["long",  ["long"]],
    "RectInRegion" => ["long",  ["long", "ptr"]],
    "RectVisible" => ["long",  ["long", "ptr"]],
    "Rectangle" => ["long",  ["long", "long", "long", "long", "long"]],
    "RemoveFontResourceA" => ["long",  ["str"]],
    "RemoveFontResourceW" => ["long",  ["wstr"]],
    "ResetDCA" => ["long",  ["long", "ptr"]],
    "ResetDCW" => ["long",  ["long", "ptr"]],
    "ResizePalette" => ["long",  ["long", "long"]],
    "RestoreDC" => ["long",  ["long", "long"]],
    "RoundRect" => ["long",  ["long", "long", "long", "long", "long", "long", "long"]],
    "SaveDC" => ["long",  ["long"]],
    "ScaleViewportExtEx" => ["long",  ["long", "long", "long", "long", "long", "ptr"]],
    "ScaleWindowExtEx" => ["long",  ["long", "long", "long", "long", "long", "ptr"]],
    "SelectClipPath" => ["long",  ["long", "long"]],
    "SelectClipRgn" => ["long",  ["long", "long"]],
    "SelectObject" => ["long",  ["long", "long"]],
    "SelectPalette" => ["long",  ["long", "long", "long"]],
    "SetAbortProc" => ["long",  ["long", "ptr"]],
    "SetArcDirection" => ["long",  ["long", "long"]],
    "SetBitmapBits" => ["long",  ["long", "long", "ptr"]],
    "SetBitmapDimensionEx" => ["long",  ["long", "long", "long", "ptr"]],
    "SetBkColor" => ["long",  ["long", "long"]],
    "SetBkMode" => ["long",  ["long", "long"]],
    "SetBoundsRect" => ["long",  ["long", "ptr", "long"]],
    "SetBrushOrgEx" => ["long",  ["long", "long", "long", "ptr"]],
    "SetColorAdjustment" => ["long",  ["long", "ptr"]],
    "SetColorSpace" => ["long",  ["long", "long"]],
    "SetDCHook" => ["long",  ["long", "ptr", "long"]],
    "SetDIBColorTable" => ["long",  ["long", "long", "long", "ptr"]],
    "SetDIBits" => ["long",  ["long", "long", "long", "long", "ptr", "ptr", "long"]],
    "SetDIBitsToDevice" => ["long",  ["long", "long", "long", "long", "long", "long", "long", "long", "long", "ptr", "ptr", "long"]],
    "SetDeviceGammaRamp" => ["long",  ["long", "ptr"]],
    "SetEnhMetaFileBits" => ["long",  ["long", "ptr"]],
    "SetGraphicsMode" => ["long",  ["long", "long"]],
    "SetICMMode" => ["long",  ["long", "long"]],
    "SetLayout" => ["long",  ["long", "long"]],
    "SetMapMode" => ["long",  ["long", "long"]],
    "SetMapperFlags" => ["long",  ["long", "long"]],
    "SetMetaFileBitsEx" => ["long",  ["long", "ptr"]],
    "SetMetaRgn" => ["long",  ["long"]],
    "SetMiterLimit" => ["long",  ["long", "long", "ptr"]],
    "SetObjectOwner" => ["void",  ["long", "long"]],
    "SetPaletteEntries" => ["long",  ["long", "long", "long", "ptr"]],
    "SetPixel" => ["long",  ["long", "long", "long", "long"]],
    "SetPixelFormat" => ["long",  ["long", "long", "ptr"]],
    "SetPixelV" => ["long",  ["long", "long", "long", "long"]],
    "SetPolyFillMode" => ["long",  ["long", "long"]],
    "SetROP2" => ["long",  ["long", "long"]],
    "SetRectRgn" => ["long",  ["long", "long", "long", "long", "long"]],
    "SetRelAbs" => ["long",  ["long", "long"]],
    "SetStretchBltMode" => ["long",  ["long", "long"]],
    "SetSystemPaletteUse" => ["long",  ["long", "long"]],
    "SetTextAlign" => ["long",  ["long", "long"]],
    "SetTextCharacterExtra" => ["long",  ["long", "long"]],
    "SetTextColor" => ["long",  ["long", "long"]],
    "SetTextJustification" => ["long",  ["long", "long", "long"]],
    "SetViewportExtEx" => ["long",  ["long", "long", "long", "ptr"]],
    "SetViewportOrgEx" => ["long",  ["long", "long", "long", "ptr"]],
    "SetWinMetaFileBits" => ["long",  ["long", "ptr", "long", "ptr"]],
    "SetWindowExtEx" => ["long",  ["long", "long", "long", "ptr"]],
    "SetWindowOrgEx" => ["long",  ["long", "long", "long", "ptr"]],
    "SetWorldTransform" => ["long",  ["long", "ptr"]],
    "StartDocA" => ["long",  ["long", "ptr"]],
    "StartDocW" => ["long",  ["long", "ptr"]],
    "StartPage" => ["long",  ["long"]],
    "StretchBlt" => ["long",  ["long", "long", "long", "long", "long", "long", "long", "long", "long", "long", "long"]],
    "StretchDIBits" => ["long",  ["long", "long", "long", "long", "long", "long", "long", "long", "long", "ptr", "ptr", "long", "long"]],
    "StrokeAndFillPath" => ["long",  ["long"]],
    "StrokePath" => ["long",  ["long"]],
    "SwapBuffers" => ["long",  ["long"]],
    "TextOutA" => ["long",  ["long", "long", "long", "str", "long"]],
    "TextOutW" => ["long",  ["long", "long", "long", "wstr", "long"]],
    "TranslateCharsetInfo" => ["long",  ["ptr", "ptr", "long"]],
    "UnrealizeObject" => ["long",  ["long"]],
    "UpdateColors" => ["long",  ["long"]],
    "WidenPath" => ["long",  ["long"]]
};

&wine::declare("gdi32",%$module_declarations);
push @EXPORT, map { "&" . $_; } sort(keys(%$module_declarations));
1;
