# This is a .spec file for creating Redhat Linux 5.2 or 6.0 .rpm and .srpm 
# files for the wipl program package.

Summary: Make statistics on basis of packets seen on a LAN.
Name: wipl
%define version 020601
Version: %{version}
Release: 1
Copyright: GNU
Group: Applications/Networking
Source: http://http://wipl-wrr.sourceforge.net/wipl/wipl-%{version}.tar.gz
BuildRoot: /tmp/wiplroot

%description
The wipl program package is able to maintain and display
statistics based on packets seen by a network card.
		
The program package contains a daemon which maintains the
statistics. For each packet seen by the network card the
daemon executes a small user supplied program. This program 
can update the statistics using information about the 
package. The program must be written in a very simple 
build-in programming language.

The program package also contains several client programs
which are able to retreview or modify the statistics 
maintained by the daemon. One of them is able to display 
tables with values evaluated from user supplied expressions
which can refer to the statistics maintained by the daemon. 
These tables can be written to HTML or XML files allowing
easy publication from web pages.

On the wipl home page an extension is available which makes it
possible for wipl to cooperate with proxyservers such as Squid 
and a socks5 server.

%prep

%setup

%configure

%build
make localstatedir=%{_localstatedir} sysconfdir=%{_sysconfdir}

%install
mkdir -p $RPM_BUILD_ROOT
make install sbindir=$RPM_BUILD_ROOT/%{_sbindir} bindir=$RPM_BUILD_ROOT/%{_bindir} mandir=$RPM_BUILD_ROOT/%{_mandir}
install -d -o 0 -g 0 $RPM_BUILD_ROOT/%{_sysconfdir}/init.d $RPM_BUILD_ROOT/%{_sysconfdir}/logrotate.d
install -o 0 -g 0 support/wipld.conf $RPM_BUILD_ROOT/%{_sysconfdir}/wipld.conf
install -o 0 -g 0 redhat/wipld $RPM_BUILD_ROOT/%{_sysconfdir}/init.d/wipld
install -m 644 -o 0 -g 0 redhat/logrotate $RPM_BUILD_ROOT/%{_sysconfdir}/logrotate.d/wipld

%files
%{_sbindir}/wipld
%{_sbindir}/wiplcInetd
%{_bindir}/wiplc
%{_bindir}/wiplcSimple
%{_bindir}/wiplcExec
%{_sysconfdir}/init.d/wipld
%{_sysconfdir}/logrotate.d/wipld
%{_mandir}/man1/wipl.1
%{_mandir}/man1/wiplc.1
%{_mandir}/man1/wiplcSimple.1
%{_mandir}/man1/wiplcExec.1
%{_mandir}/man5/wipllang.5
%{_mandir}/man8/wipld.8
%{_mandir}/man8/wiplcInetd.8
%config %{_sysconfdir}/wipld.conf
%doc wipl.lsm
%doc ChangeLog
%doc AUTHORS
%doc COPYING
%doc README
%doc NEWS
%doc FAQ
%doc support
%doc wiplJava

%post 
chkconfig --add wipld

%preun
if [ -e /%{_localstatedir}/run/wipld.pid ]; then
  /%{_sysconfdir}/init.d/wipld stop
fi
chkconfig --del wipld
  
%postun
rm -f %{_localstatedir}/log/wipld.*
rm -f %{_localstatedir}/run/wipld.pid
