/* Do not modify this file.                                                   */
/* It is created automatically by the ASN.1 to Wireshark dissector compiler   */
/* .\packet-rnsap.c                                                           */
/* ../../tools/asn2wrs.py -e -F -p rnsap -c rnsap.cnf -s packet-rnsap-template rnsap.asn */

/* Input file: packet-rnsap-template.c */

#line 1 "packet-rnsap-template.c"
/* packet-rnsap.c
 * Routines for dissecting Universal Mobile Telecommunications System (UMTS);
 * UTRAN Iur interface Radio Network Subsystem
 * Application Part (RNSAP) signalling
 * (3GPP TS 25.423 version 6.7.0 Release 6) packet dissection
 * Copyright 2005 - 2006, Anders Broman <anders.broman@ericsson.com>
 *
 * $Id: packet-rnsap.c 18921 2006-08-16 05:58:39Z kukosa $
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ref: 3GPP TS 25.423 version 6.7.0 Release 6
 */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <glib.h>
#include <epan/packet.h>
#include <epan/conversation.h>

#include <stdio.h>
#include <string.h>

#include "packet-ber.h"
#include "packet-per.h"
#include "packet-rnsap.h"
#include "packet-umts_rrc.h"
/*#include "packet-umts_rrc.h"*/

#define PNAME  "UTRAN Iur interface Radio Network Subsystem Application Part"
#define PSNAME "RNSAP"
#define PFNAME "rnsap"

#define SCCP_SSN_RNSAP 143

#define RNSAP_FDD 1
/* Procedure codes */
#define	RNSAP_ID_COMMONTRANSPORTCHANNELRESOURCESINITIALISATION			 0
#define	RNSAP_ID_COMMONTRANSPORTCHANNELRESOURCESRELEASE					 1
#define	RNSAP_ID_COMPRESSEDMODECOMMAND									 2
#define	RNSAP_ID_DOWNLINKPOWERCONTROL									 3
#define	RNSAP_ID_DOWNLINKPOWERTIMESLOTCONTROL							 4
#define	RNSAP_ID_DOWNLINKSIGNALLINGTRANSFER								 5
#define	RNSAP_ID_ERRORINDICATION										 6
#define	RNSAP_ID_DEDICATEDMEASUREMENTFAILURE							 7
#define	RNSAP_ID_DEDICATEDMEASUREMENTINITIATION							 8
#define	RNSAP_ID_DEDICATEDMEASUREMENTREPORTING							 9
#define	RNSAP_ID_DEDICATEDMEASUREMENTTERMINATION						 10
#define	RNSAP_ID_PAGING													 11
#define	RNSAP_ID_PHYSICALCHANNELRECONFIGURATION							 12
#define	RNSAP_ID_PRIVATEMESSAGE											 13
#define	RNSAP_ID_RADIOLINKADDITION										 14
#define	RNSAP_ID_RADIOLINKCONGESTION									 34
#define	RNSAP_ID_RADIOLINKDELETION										 15
#define	RNSAP_ID_RADIOLINKFAILURE										 16
#define	RNSAP_ID_RADIOLINKPREEMPTION									 17
#define	RNSAP_ID_RADIOLINKRESTORATION									 18
#define	RNSAP_ID_RADIOLINKSETUP											 19
#define	RNSAP_ID_RELOCATIONCOMMIT										 20
#define	RNSAP_ID_SYNCHRONISEDRADIOLINKRECONFIGURATIONCANCELLATION		 21
#define	RNSAP_ID_SYNCHRONISEDRADIOLINKRECONFIGURATIONCOMMIT				 22
#define	RNSAP_ID_SYNCHRONISEDRADIOLINKRECONFIGURATIONPREPARATION		 23
#define	RNSAP_ID_UNSYNCHRONISEDRADIOLINKRECONFIGURATION					 24
#define	RNSAP_ID_UPLINKSIGNALLINGTRANSFER								 25
#define	RNSAP_ID_COMMONMEASUREMENTFAILURE								 26
#define	RNSAP_ID_COMMONMEASUREMENTINITIATION							 27
#define	RNSAP_ID_COMMONMEASUREMENTREPORTING								 28
#define	RNSAP_ID_COMMONMEASUREMENTTERMINATION							 29
#define	RNSAP_ID_INFORMATIONEXCHANGEFAILURE								 30
#define	RNSAP_ID_INFORMATIONEXCHANGEINITIATION							 31
#define	RNSAP_ID_INFORMATIONREPORTING									 32
#define	RNSAP_ID_INFORMATIONEXCHANGETERMINATION							 33
#define	RNSAP_ID_RESET													 35
#define	RNSAP_ID_RADIOLINKACTIVATION 									 36
#define	RNSAP_ID_GERANUPLINKSIGNALLINGTRANSFER							 37
#define	RNSAP_ID_RADIOLINKPARAMETERUPDATE								 38
#define	RNSAP_ID_UEMEASUREMENTFAILURE									 39
#define	RNSAP_ID_UEMEASUREMENTINITIATION								 40
#define	RNSAP_ID_UEMEASUREMENTREPORTING									 41
#define	RNSAP_ID_UEMEASUREMENTTERMINATION								 42
#define	RNSAP_ID_IURDEACTIVATETRACE										 43
#define	RNSAP_ID_IURINVOKETRACE											 44
#define	RNSAP_ID_MBMSATTACH												 45
#define	RNSAP_ID_MBMSDETACH												 46
#define	RNSAP_ID_DIRECTINFORMATIONTRANSFER								 48

#define	RNSAP_ID_ALLOWEDQUEUINGTIME														 4
#define	RNSAP_ID_ALLOWED_RATE_INFORMATION												 42
#define	RNSAP_ID_ANTENNACOLOCATIONINDICATOR												 309
#define	RNSAP_ID_BINDINGID																 5
#define	RNSAP_ID_C_ID																	 6
#define	RNSAP_ID_C_RNTI																	 7
#define	RNSAP_ID_CELL_CAPACITY_CLASS_VALUE												 303
#define	RNSAP_ID_CFN																	 8
#define	RNSAP_ID_CN_CS_DOMAINIDENTIFIER													 9
#define	RNSAP_ID_CN_PS_DOMAINIDENTIFIER													 10
#define	RNSAP_ID_CAUSE																	 11
#define	RNSAP_ID_COVERAGEINDICATOR														 310
#define	RNSAP_ID_CRITICALITYDIAGNOSTICS													 20
#define	RNSAP_ID_CONTEXTINFOITEM_RESET													 211
#define	RNSAP_ID_CONTEXTGROUPINFOITEM_RESET												 515
#define	RNSAP_ID_D_RNTI																	 21
#define	RNSAP_ID_D_RNTI_RELEASEINDICATION												 22
#define	RNSAP_ID_DCHS_TO_ADD_FDD														 26
#define	RNSAP_ID_DCHS_TO_ADD_TDD														 27
#define	RNSAP_ID_DCH_DELETELIST_RL_RECONFPREPFDD										 30
#define	RNSAP_ID_DCH_DELETELIST_RL_RECONFPREPTDD										 31
#define	RNSAP_ID_DCH_DELETELIST_RL_RECONFRQSTFDD										 32
#define	RNSAP_ID_DCH_DELETELIST_RL_RECONFRQSTTDD										 33
#define	RNSAP_ID_DCH_FDD_INFORMATION													 34
#define	RNSAP_ID_DCH_TDD_INFORMATION													 35
#define	RNSAP_ID_FDD_DCHS_TO_MODIFY														 39
#define	RNSAP_ID_TDD_DCHS_TO_MODIFY														 40
#define	RNSAP_ID_DCH_INFORMATIONRESPONSE												 43
#define	RNSAP_ID_DCH_RATE_INFORMATIONITEM_RL_CONGESTIND									 38
#define	RNSAP_ID_DL_CCTRCH_INFORMATIONADDITEM_RL_RECONFPREPTDD							 44
#define	RNSAP_ID_DL_CCTRCH_INFORMATIONLISTIE_RL_RECONFREADYTDD							 45
#define	RNSAP_ID_DL_CCTRCH_INFORMATIONDELETEITEM_RL_RECONFRQSTTDD						 46
#define	RNSAP_ID_DL_CCTRCH_INFORMATIONITEM_RL_SETUPRQSTTDD								 47
#define	RNSAP_ID_DL_CCTRCH_INFORMATIONLISTIE_PHYCHRECONFRQSTTDD							 48
#define	RNSAP_ID_DL_CCTRCH_INFORMATIONLISTIE_RL_ADDITIONRSPTDD							 49
#define	RNSAP_ID_DL_CCTRCH_INFORMATIONLISTIE_RL_SETUPRSPTDD								 50
#define	RNSAP_ID_DL_CCTRCH_INFORMATIONADDLIST_RL_RECONFPREPTDD							 51
#define	RNSAP_ID_DL_CCTRCH_INFORMATIONDELETELIST_RL_RECONFRQSTTDD						 52
#define	RNSAP_ID_DL_CCTRCH_INFORMATIONLIST_RL_SETUPRQSTTDD								 53
#define	RNSAP_ID_FDD_DL_CODEINFORMATION													 54
#define	RNSAP_ID_DL_DPCH_INFORMATION_RL_RECONFPREPFDD									 59
#define	RNSAP_ID_DL_DPCH_INFORMATION_RL_SETUPRQSTFDD									 60
#define	RNSAP_ID_DL_DPCH_INFORMATION_RL_RECONFRQSTFDD									 61
#define	RNSAP_ID_DL_DPCH_INFORMATIONITEM_PHYCHRECONFRQSTTDD								 62
#define	RNSAP_ID_DL_DPCH_INFORMATIONITEM_RL_ADDITIONRSPTDD								 63
#define	RNSAP_ID_DL_DPCH_INFORMATIONITEM_RL_SETUPRSPTDD									 64
#define	RNSAP_ID_DL_DPCH_TIMINGADJUSTMENT												 278
#define	RNSAP_ID_DLREFERENCEPOWER														 67
#define	RNSAP_ID_DLREFERENCEPOWERLIST_DL_PC_RQST										 68
#define	RNSAP_ID_DL_REFERENCEPOWERINFORMATION_DL_PC_RQST								 69
#define	RNSAP_ID_DPC_MODE																 12
#define	RNSAP_ID_DRXCYCLELENGTHCOEFFICIENT												 70
#define	RNSAP_ID_DEDICATEDMEASUREMENTOBJECTTYPE_DM_FAIL_IND								 470
#define	RNSAP_ID_DEDICATEDMEASUREMENTOBJECTTYPE_DM_FAIL									 471
#define	RNSAP_ID_DEDICATEDMEASUREMENTOBJECTTYPE_DM_RPRT									 71
#define	RNSAP_ID_DEDICATEDMEASUREMENTOBJECTTYPE_DM_RQST									 72
#define	RNSAP_ID_DEDICATEDMEASUREMENTOBJECTTYPE_DM_RSP									 73
#define	RNSAP_ID_DEDICATEDMEASUREMENTTYPE												 74
#define	RNSAP_ID_FACH_INFOFORUESELECTEDS_CCPCH_CTCH_RESOURCERSPFDD						 82
#define	RNSAP_ID_FACH_INFOFORUESELECTEDS_CCPCH_CTCH_RESOURCERSPTDD						 83
#define	RNSAP_ID_GUARANTEED_RATE_INFORMATION											 41
#define	RNSAP_ID_IMSI																	 84
#define	RNSAP_ID_HCS_PRIO																 311
#define	RNSAP_ID_L3_INFORMATION															 85
#define	RNSAP_ID_ADJUSTMENTPERIOD														 90
#define	RNSAP_ID_MAXADJUSTMENTSTEP														 91
#define	RNSAP_ID_MEASUREMENTFILTERCOEFFICIENT											 92
#define	RNSAP_ID_MESSAGESTRUCTURE														 57
#define	RNSAP_ID_MEASUREMENTID															 93
#define	RNSAP_ID_NEIGHBOURING_GSM_CELLINFORMATION										 13
#define	RNSAP_ID_NEIGHBOURING_UMTS_CELLINFORMATIONITEM									 95
#define	RNSAP_ID_NRT_LOAD_INFORMATION_VALUE												 305
#define	RNSAP_ID_NRT_LOAD_INFORMATION_VALUE_INCRDECRTHRES								 306
#define	RNSAP_ID_PAGINGAREA_PAGINGRQST													 102
#define	RNSAP_ID_FACH_FLOWCONTROLINFORMATION											 103
#define	RNSAP_ID_PARTIALREPORTINGINDICATOR												 472
#define	RNSAP_ID_PERMANENT_NAS_UE_IDENTITY												 17
#define	RNSAP_ID_POWERADJUSTMENTTYPE													 107
#define	RNSAP_ID_RANAP_RELOCATIONINFORMATION											 109
#define	RNSAP_ID_RL_INFORMATION_PHYCHRECONFRQSTFDD										 110
#define	RNSAP_ID_RL_INFORMATION_PHYCHRECONFRQSTTDD										 111
#define	RNSAP_ID_RL_INFORMATION_RL_ADDITIONRQSTFDD										 112
#define	RNSAP_ID_RL_INFORMATION_RL_ADDITIONRQSTTDD										 113
#define	RNSAP_ID_RL_INFORMATION_RL_DELETIONRQST											 114
#define	RNSAP_ID_RL_INFORMATION_RL_FAILUREIND											 115
#define	RNSAP_ID_RL_INFORMATION_RL_RECONFPREPFDD										 116
#define	RNSAP_ID_RL_INFORMATION_RL_RESTOREIND											 117
#define	RNSAP_ID_RL_INFORMATION_RL_SETUPRQSTFDD											 118
#define	RNSAP_ID_RL_INFORMATION_RL_SETUPRQSTTDD											 119
#define	RNSAP_ID_RL_INFORMATIONITEM_RL_CONGESTIND										 55
#define	RNSAP_ID_RL_INFORMATIONITEM_DM_RPRT												 120
#define	RNSAP_ID_RL_INFORMATIONITEM_DM_RQST												 121
#define	RNSAP_ID_RL_INFORMATIONITEM_DM_RSP												 122
#define	RNSAP_ID_RL_INFORMATIONITEM_RL_PREEMPTREQUIREDIND								 2
#define	RNSAP_ID_RL_INFORMATIONITEM_RL_SETUPRQSTFDD										 123
#define	RNSAP_ID_RL_INFORMATIONLIST_RL_CONGESTIND										 56
#define	RNSAP_ID_RL_INFORMATIONLIST_RL_ADDITIONRQSTFDD									 124
#define	RNSAP_ID_RL_INFORMATIONLIST_RL_DELETIONRQST										 125
#define	RNSAP_ID_RL_INFORMATIONLIST_RL_PREEMPTREQUIREDIND								 1
#define	RNSAP_ID_RL_INFORMATIONLIST_RL_RECONFPREPFDD									 126
#define	RNSAP_ID_RL_INFORMATIONRESPONSE_RL_ADDITIONRSPTDD								 127
#define	RNSAP_ID_RL_INFORMATIONRESPONSE_RL_RECONFREADYTDD								 128
#define	RNSAP_ID_RL_INFORMATIONRESPONSE_RL_SETUPRSPTDD									 129
#define	RNSAP_ID_RL_INFORMATIONRESPONSEITEM_RL_ADDITIONRSPFDD							 130
#define	RNSAP_ID_RL_INFORMATIONRESPONSEITEM_RL_RECONFREADYFDD							 131
#define	RNSAP_ID_RL_INFORMATIONRESPONSEITEM_RL_RECONFRSPFDD								 132
#define	RNSAP_ID_RL_INFORMATIONRESPONSEITEM_RL_SETUPRSPFDD								 133
#define	RNSAP_ID_RL_INFORMATIONRESPONSELIST_RL_ADDITIONRSPFDD							 134
#define	RNSAP_ID_RL_INFORMATIONRESPONSELIST_RL_RECONFREADYFDD							 135
#define	RNSAP_ID_RL_INFORMATIONRESPONSELIST_RL_RECONFRSPFDD								 136
#define	RNSAP_ID_RL_INFORMATIONRESPONSE_RL_RECONFRSPTDD									 28
#define	RNSAP_ID_RL_INFORMATIONRESPONSELIST_RL_SETUPRSPFDD								 137
#define	RNSAP_ID_RL_RECONFIGURATIONFAILURE_RL_RECONFFAIL								 141
#define	RNSAP_ID_RL_SET_INFORMATIONITEM_DM_RPRT											 143
#define	RNSAP_ID_RL_SET_INFORMATIONITEM_DM_RQST											 144
#define	RNSAP_ID_RL_SET_INFORMATIONITEM_DM_RSP											 145
#define	RNSAP_ID_RL_SET_INFORMATION_RL_FAILUREIND										 146
#define	RNSAP_ID_RL_SET_INFORMATION_RL_RESTOREIND										 147
#define	RNSAP_ID_RL_SET_SUCCESSFUL_INFORMATIONITEM_DM_FAIL								 473
#define	RNSAP_ID_RL_SET_UNSUCCESSFUL_INFORMATIONITEM_DM_FAIL							 474
#define	RNSAP_ID_RL_SET_UNSUCCESSFUL_INFORMATIONITEM_DM_FAIL_IND						 475
#define	RNSAP_ID_RL_SUCCESSFUL_INFORMATIONITEM_DM_FAIL									 476
#define	RNSAP_ID_RL_UNSUCCESSFUL_INFORMATIONITEM_DM_FAIL								 477
#define	RNSAP_ID_RL_UNSUCCESSFUL_INFORMATIONITEM_DM_FAIL_IND							 478
#define	RNSAP_ID_REPORTCHARACTERISTICS													 152
#define	RNSAP_ID_REPORTING_OBJECT_RL_FAILUREIND											 153
#define	RNSAP_ID_REPORING_OBJECT_RL_RESTOREIND											 154
#define	RNSAP_ID_RT_LOAD_VALUE															 307
#define	RNSAP_ID_RT_LOAD_VALUE_INCRDECRTHRES											 308
#define	RNSAP_ID_S_RNTI																	 155
#define	RNSAP_ID_RESETINDICATOR															 244
#define	RNSAP_ID_RNC_ID																	 245
#define	RNSAP_ID_SAI																	 156
#define	RNSAP_ID_SRNC_ID																 157
#define	RNSAP_ID_SUCCESSFULRL_INFORMATIONRESPONSE_RL_ADDITIONFAILUREFDD					 159
#define	RNSAP_ID_SUCCESSFULRL_INFORMATIONRESPONSE_RL_SETUPFAILUREFDD					 160
#define	RNSAP_ID_TRANSPORTBEARERID														 163
#define	RNSAP_ID_TRANSPORTBEARERREQUESTINDICATOR										 164
#define	RNSAP_ID_TRANSPORTLAYERADDRESS													 165
#define	RNSAP_ID_TYPEOFERROR															 140
#define	RNSAP_ID_UC_ID																	 166
#define	RNSAP_ID_UL_CCTRCH_ADDINFORMATION_RL_RECONFPREPTDD								 167
#define	RNSAP_ID_UL_CCTRCH_INFORMATIONADDLIST_RL_RECONFPREPTDD							 169
#define	RNSAP_ID_UL_CCTRCH_INFORMATIONITEM_RL_SETUPRQSTTDD								 171
#define	RNSAP_ID_UL_CCTRCH_INFORMATIONLIST_RL_SETUPRQSTTDD								 172
#define	RNSAP_ID_UL_CCTRCH_INFORMATIONLISTIE_PHYCHRECONFRQSTTDD							 173
#define	RNSAP_ID_UL_CCTRCH_INFORMATIONLISTIE_RL_ADDITIONRSPTDD							 174
#define	RNSAP_ID_UL_CCTRCH_INFORMATIONLISTIE_RL_RECONFREADYTDD							 175
#define	RNSAP_ID_UL_CCTRCH_INFORMATIONLISTIE_RL_SETUPRSPTDD								 176
#define	RNSAP_ID_UL_DPCH_INFORMATION_RL_RECONFPREPFDD									 177
#define	RNSAP_ID_UL_DPCH_INFORMATION_RL_RECONFRQSTFDD									 178
#define	RNSAP_ID_UL_DPCH_INFORMATION_RL_SETUPRQSTFDD									 179
#define	RNSAP_ID_UL_DPCH_INFORMATIONITEM_PHYCHRECONFRQSTTDD								 180
#define	RNSAP_ID_UL_DPCH_INFORMATIONITEM_RL_ADDITIONRSPTDD								 181
#define	RNSAP_ID_UL_DPCH_INFORMATIONITEM_RL_SETUPRSPTDD									 182
#define	RNSAP_ID_UL_DPCH_INFORMATIONADDLISTIE_RL_RECONFREADYTDD							 183
#define	RNSAP_ID_UL_SIRTARGET															 184
#define	RNSAP_ID_URA_INFORMATION														 185
#define	RNSAP_ID_UNSUCCESSFULRL_INFORMATIONRESPONSE_RL_ADDITIONFAILUREFDD				 188
#define	RNSAP_ID_UNSUCCESSFULRL_INFORMATIONRESPONSE_RL_SETUPFAILUREFDD					 189
#define	RNSAP_ID_UNSUCCESSFULRL_INFORMATIONRESPONSE_RL_SETUPFAILURETDD					 190
#define	RNSAP_ID_ACTIVE_PATTERN_SEQUENCE_INFORMATION									 193
#define	RNSAP_ID_ADJUSTMENTRATIO														 194
#define	RNSAP_ID_CAUSELEVEL_RL_ADDITIONFAILUREFDD										 197
#define	RNSAP_ID_CAUSELEVEL_RL_ADDITIONFAILURETDD										 198
#define	RNSAP_ID_CAUSELEVEL_RL_RECONFFAILURE											 199
#define	RNSAP_ID_CAUSELEVEL_RL_SETUPFAILUREFDD											 200
#define	RNSAP_ID_CAUSELEVEL_RL_SETUPFAILURETDD											 201
#define	RNSAP_ID_DL_CCTRCH_INFORMATIONDELETEITEM_RL_RECONFPREPTDD						 205
#define	RNSAP_ID_DL_CCTRCH_INFORMATIONMODIFYITEM_RL_RECONFPREPTDD						 206
#define	RNSAP_ID_DL_CCTRCH_INFORMATIONMODIFYITEM_RL_RECONFRQSTTDD						 207
#define	RNSAP_ID_DL_CCTRCH_INFORMATIONDELETELIST_RL_RECONFPREPTDD						 208
#define	RNSAP_ID_DL_CCTRCH_INFORMATIONMODIFYLIST_RL_RECONFPREPTDD						 209
#define	RNSAP_ID_DL_CCTRCH_INFORMATIONMODIFYLIST_RL_RECONFRQSTTDD						 210
#define	RNSAP_ID_DL_DPCH_INFORMATIONADDLISTIE_RL_RECONFREADYTDD							 212
#define	RNSAP_ID_DL_DPCH_INFORMATIONDELETELISTIE_RL_RECONFREADYTDD						 213
#define	RNSAP_ID_DL_DPCH_INFORMATIONMODIFYLISTIE_RL_RECONFREADYTDD						 214
#define	RNSAP_ID_DSCHS_TO_ADD_TDD														 215
#define	RNSAP_ID_UNUSED_PROTOCOLIE_RNSAP_ID_216											 216
#define	RNSAP_ID_DSCH_DELETELIST_RL_RECONFPREPTDD										 217
#define	RNSAP_ID_UNUSED_PROTOCOLIE_RNSAP_ID_218											 218
#define	RNSAP_ID_UNUSED_PROTOCOLIE_RNSAP_ID_219											 219
#define	RNSAP_ID_DSCH_INFORMATIONLISTIE_RL_ADDITIONRSPTDD								 220
#define	RNSAP_ID_DSCH_INFORMATIONLISTIES_RL_SETUPRSPTDD									 221
#define	RNSAP_ID_DSCH_TDD_INFORMATION													 222
#define	RNSAP_ID_UNUSED_PROTOCOLIE_RNSAP_ID_223											 223
#define	RNSAP_ID_UNUSED_PROTOCOLIE_RNSAP_ID_226											 226
#define	RNSAP_ID_DSCH_MODIFYLIST_RL_RECONFPREPTDD										 227
#define	RNSAP_ID_UNUSED_PROTOCOLIE_RNSAP_ID_228											 228
#define	RNSAP_ID_UNUSED_PROTOCOLIE_RNSAP_ID_324											 324
#define	RNSAP_ID_UNUSED_PROTOCOLIE_RNSAP_ID_229											 229
#define	RNSAP_ID_DSCHTOBEADDEDORMODIFIEDLIST_RL_RECONFREADYTDD							 230
#define	RNSAP_ID_UNUSED_PROTOCOLIE_RNSAP_ID_29											 29
#define	RNSAP_ID_UNUSED_PROTOCOLIE_RNSAP_ID_225											 225
#define	RNSAP_ID_GA_CELL																 232
#define	RNSAP_ID_GA_CELLADDITIONALSHAPES												 3
#define	RNSAP_ID_UNUSED_PROTOCOLIE_RNSAP_ID_246											 246
#define	RNSAP_ID_TRANSMISSION_GAP_PATTERN_SEQUENCE_INFORMATION							 255
#define	RNSAP_ID_UL_CCTRCH_DELETEINFORMATION_RL_RECONFPREPTDD							 256
#define	RNSAP_ID_UL_CCTRCH_MODIFYINFORMATION_RL_RECONFPREPTDD							 257
#define	RNSAP_ID_UL_CCTRCH_INFORMATIONMODIFYITEM_RL_RECONFRQSTTDD						 258
#define	RNSAP_ID_UL_CCTRCH_INFORMATIONDELETELIST_RL_RECONFPREPTDD						 259
#define	RNSAP_ID_UL_CCTRCH_INFORMATIONMODIFYLIST_RL_RECONFPREPTDD						 260
#define	RNSAP_ID_UL_CCTRCH_INFORMATIONMODIFYLIST_RL_RECONFRQSTTDD						 261
#define	RNSAP_ID_UL_CCTRCH_INFORMATIONDELETEITEM_RL_RECONFRQSTTDD						 262
#define	RNSAP_ID_UL_CCTRCH_INFORMATIONDELETELIST_RL_RECONFRQSTTDD						 263
#define	RNSAP_ID_UL_DPCH_INFORMATIONDELETELISTIE_RL_RECONFREADYTDD						 264
#define	RNSAP_ID_UL_DPCH_INFORMATIONMODIFYLISTIE_RL_RECONFREADYTDD						 265
#define	RNSAP_ID_UNSUCCESSFULRL_INFORMATIONRESPONSE_RL_ADDITIONFAILURETDD				 266
#define	RNSAP_ID_USCHS_TO_ADD															 267
#define	RNSAP_ID_USCH_DELETELIST_RL_RECONFPREPTDD										 268
#define	RNSAP_ID_USCH_INFORMATIONLISTIE_RL_ADDITIONRSPTDD								 269
#define	RNSAP_ID_USCH_INFORMATIONLISTIES_RL_SETUPRSPTDD									 270
#define	RNSAP_ID_USCH_INFORMATION														 271
#define	RNSAP_ID_USCH_MODIFYLIST_RL_RECONFPREPTDD										 272
#define	RNSAP_ID_USCHTOBEADDEDORMODIFIEDLIST_RL_RECONFREADYTDD							 273
#define	RNSAP_ID_DL_PHYSICAL_CHANNEL_INFORMATION_RL_SETUPRQSTTDD						 274
#define	RNSAP_ID_UL_PHYSICAL_CHANNEL_INFORMATION_RL_SETUPRQSTTDD						 275
#define	RNSAP_ID_CLOSEDLOOPMODE1_SUPPORTINDICATOR										 276
#define	RNSAP_ID_UNUSED_PROTOCOLIE_RNSAP_ID_277											 277
#define	RNSAP_ID_STTD_SUPPORTINDICATOR													 279
#define	RNSAP_ID_CFNREPORTINGINDICATOR             										 14
#define	RNSAP_ID_CNORIGINATEDPAGE_PAGINGRQST											 23
#define	RNSAP_ID_INNERLOOPDLPCSTATUS													 24
#define	RNSAP_ID_PROPAGATIONDELAY														 25
#define	RNSAP_ID_RXTIMINGDEVIATIONFORTA													 36
#define	RNSAP_ID_TIMESLOT_ISCP															 37
#define	RNSAP_ID_CCTRCH_INFORMATIONITEM_RL_FAILUREIND									 15
#define	RNSAP_ID_CCTRCH_INFORMATIONITEM_RL_RESTOREIND									 16
#define	RNSAP_ID_COMMONMEASUREMENTACCURACY												 280
#define	RNSAP_ID_COMMONMEASUREMENTOBJECTTYPE_CM_RPRT									 281
#define	RNSAP_ID_COMMONMEASUREMENTOBJECTTYPE_CM_RQST									 282
#define	RNSAP_ID_COMMONMEASUREMENTOBJECTTYPE_CM_RSP										 283
#define	RNSAP_ID_COMMONMEASUREMENTTYPE													 284
#define	RNSAP_ID_CONGESTIONCAUSE 														 18
#define	RNSAP_ID_SFN																	 285
#define	RNSAP_ID_SFNREPORTINGINDICATOR													 286
#define	RNSAP_ID_INFORMATIONEXCHANGEID													 287
#define	RNSAP_ID_INFORMATIONEXCHANGEOBJECTTYPE_INFEX_RPRT								 288
#define	RNSAP_ID_INFORMATIONEXCHANGEOBJECTTYPE_INFEX_RQST								 289
#define	RNSAP_ID_INFORMATIONEXCHANGEOBJECTTYPE_INFEX_RSP								 290
#define	RNSAP_ID_INFORMATIONREPORTCHARACTERISTICS										 291
#define	RNSAP_ID_INFORMATIONTYPE														 292
#define	RNSAP_ID_NEIGHBOURING_LCR_TDD_CELLINFORMATION									 58
#define	RNSAP_ID_DL_TIMESLOT_ISCP_LCR_INFORMATION_RL_SETUPRQSTTDD						 65
#define	RNSAP_ID_RL_LCR_INFORMATIONRESPONSE_RL_SETUPRSPTDD								 66
#define	RNSAP_ID_UL_CCTRCH_LCR_INFORMATIONLISTIE_RL_SETUPRSPTDD							 75
#define	RNSAP_ID_UL_DPCH_LCR_INFORMATIONITEM_RL_SETUPRSPTDD								 76
#define	RNSAP_ID_DL_CCTRCH_LCR_INFORMATIONLISTIE_RL_SETUPRSPTDD							 77
#define	RNSAP_ID_DL_DPCH_LCR_INFORMATIONITEM_RL_SETUPRSPTDD								 78
#define	RNSAP_ID_DSCH_LCR_INFORMATIONLISTIES_RL_SETUPRSPTDD								 79
#define	RNSAP_ID_USCH_LCR_INFORMATIONLISTIES_RL_SETUPRSPTDD								 80
#define	RNSAP_ID_DL_TIMESLOT_ISCP_LCR_INFORMATION_RL_ADDITIONRQSTTDD					 81
#define	RNSAP_ID_RL_LCR_INFORMATIONRESPONSE_RL_ADDITIONRSPTDD							 86
#define	RNSAP_ID_UL_CCTRCH_LCR_INFORMATIONLISTIE_RL_ADDITIONRSPTDD						 87
#define	RNSAP_ID_UL_DPCH_LCR_INFORMATIONITEM_RL_ADDITIONRSPTDD							 88
#define	RNSAP_ID_DL_CCTRCH_LCR_INFORMATIONLISTIE_RL_ADDITIONRSPTDD						 89
#define	RNSAP_ID_DL_DPCH_LCR_INFORMATIONITEM_RL_ADDITIONRSPTDD							 94
#define	RNSAP_ID_DSCH_LCR_INFORMATIONLISTIES_RL_ADDITIONRSPTDD							 96
#define	RNSAP_ID_USCH_LCR_INFORMATIONLISTIES_RL_ADDITIONRSPTDD							 97
#define	RNSAP_ID_UL_DPCH_LCR_INFORMATIONADDLISTIE_RL_RECONFREADYTDD						 98
#define	RNSAP_ID_UL_TIMESLOT_LCR_INFORMATIONMODIFYLIST_RL_RECONFREADYTDD				 100
#define	RNSAP_ID_DL_DPCH_LCR_INFORMATIONADDLISTIE_RL_RECONFREADYTDD						 101
#define	RNSAP_ID_DL_TIMESLOT_LCR_INFORMATIONMODIFYLIST_RL_RECONFREADYTDD				 104
#define	RNSAP_ID_UL_TIMESLOT_LCR_INFORMATIONLIST_PHYCHRECONFRQSTTDD						 105
#define	RNSAP_ID_DL_TIMESLOT_LCR_INFORMATIONLIST_PHYCHRECONFRQSTTDD						 106
#define	RNSAP_ID_TIMESLOT_ISCP_LCR_LIST_DL_PC_RQST_TDD									 138
#define	RNSAP_ID_TSTD_SUPPORT_INDICATOR_RL_SETUPRQSTTDD									 139
#define	RNSAP_ID_RESTRICTIONSTATEINDICATOR												 142
#define	RNSAP_ID_LOAD_VALUE																 233
#define	RNSAP_ID_LOAD_VALUE_INCRDECRTHRES												 234
#define	RNSAP_ID_ONMODIFICATION															 235
#define	RNSAP_ID_RECEIVED_TOTAL_WIDEBAND_POWER_VALUE									 236
#define	RNSAP_ID_RECEIVED_TOTAL_WIDEBAND_POWER_VALUE_INCRDECRTHRES						 237
#define	RNSAP_ID_SFNSFNMEASUREMENTTHRESHOLDINFORMATION									 238
#define	RNSAP_ID_TRANSMITTED_CARRIER_POWER_VALUE										 239
#define	RNSAP_ID_TRANSMITTED_CARRIER_POWER_VALUE_INCRDECRTHRES							 240
#define	RNSAP_ID_TUTRANGPSMEASUREMENTTHRESHOLDINFORMATION								 241
#define	RNSAP_ID_UL_TIMESLOT_ISCP_VALUE													 242
#define	RNSAP_ID_UL_TIMESLOT_ISCP_VALUE_INCRDECRTHRES									 243
#define	RNSAP_ID_RX_TIMING_DEVIATION_VALUE_LCR											 293
#define	RNSAP_ID_DPC_MODE_CHANGE_SUPPORTINDICATOR										 19
#define	RNSAP_ID_UNUSED_PROTOCOLIE_RNSAP_ID_247											 247
#define	RNSAP_ID_UNUSED_PROTOCOLIE_RNSAP_ID_295											 295
#define	RNSAP_ID_PRIMARYCCPCH_RSCP_RL_RECONFPREPTDD										 202
#define	RNSAP_ID_DL_TIMESLOT_ISCP_INFO_RL_RECONFPREPTDD									 203
#define	RNSAP_ID_DL_TIMESLOT_ISCP_LCR_INFORMATION_RL_RECONFPREPTDD						 204
#define	RNSAP_ID_DSCH_RNTI																 249
#define	RNSAP_ID_DL_POWERBALANCING_INFORMATION											 296
#define	RNSAP_ID_DL_POWERBALANCING_ACTIVATIONINDICATOR									 297
#define	RNSAP_ID_DL_POWERBALANCING_UPDATEDINDICATOR										 298
#define	RNSAP_ID_DL_REFERENCEPOWERINFORMATION											 299
#define	RNSAP_ID_ENHANCED_PRIMARYCPICH_ECNO												 224
#define	RNSAP_ID_IPDL_TDD_PARAMETERSLCR													 252
#define	RNSAP_ID_CELLCAPABILITYCONTAINER_FDD											 300
#define	RNSAP_ID_CELLCAPABILITYCONTAINER_TDD											 301
#define	RNSAP_ID_CELLCAPABILITYCONTAINER_TDD_LCR										 302
#define	RNSAP_ID_RL_SPECIFIC_DCH_INFO													 317
#define	RNSAP_ID_RL_RECONFIGURATIONREQUESTFDD_RL_INFORMATIONLIST 						 318
#define	RNSAP_ID_RL_RECONFIGURATIONREQUESTFDD_RL_INFORMATION_IES						 319
#define	RNSAP_ID_RL_RECONFIGURATIONREQUESTTDD_RL_INFORMATION							 321
#define	RNSAP_ID_COMMONTRANSPORTCHANNELRESOURCESINITIALISATIONNOTREQUIRED				 250
#define	RNSAP_ID_DELAYEDACTIVATION 														 312
#define	RNSAP_ID_DELAYEDACTIVATIONLIST_RL_ACTIVATIONCMDFDD								 313
#define	RNSAP_ID_DELAYEDACTIVATIONINFORMATION_RL_ACTIVATIONCMDFDD						 314
#define	RNSAP_ID_DELAYEDACTIVATIONLIST_RL_ACTIVATIONCMDTDD								 315
#define	RNSAP_ID_DELAYEDACTIVATIONINFORMATION_RL_ACTIVATIONCMDTDD						 316
#define	RNSAP_ID_NEIGHBOURINGTDDCELLMEASUREMENTINFORMATIONLCR							 251
#define	RNSAP_ID_UL_SIR_TARGET_CCTRCH_INFORMATIONITEM_RL_SETUPRSPTDD					 150
#define	RNSAP_ID_UL_SIR_TARGET_CCTRCH_LCR_INFORMATIONITEM_RL_SETUPRSPTDD				 151
#define	RNSAP_ID_PRIMCCPCH_RSCP_DL_PC_RQSTTDD											 451
#define	RNSAP_ID_HSDSCH_FDD_INFORMATION													 452
#define	RNSAP_ID_HSDSCH_FDD_INFORMATION_RESPONSE										 453
#define	RNSAP_ID_HSDSCH_FDD_UPDATE_INFORMATION											 466
#define	RNSAP_ID_HSDSCH_INFORMATION_TO_MODIFY											 456
#define	RNSAP_ID_HSDSCHMACDFLOWSPECIFICINFORMATIONLIST_RL_PREEMPTREQUIREDIND			 516
#define	RNSAP_ID_HSDSCHMACDFLOWSPECIFICINFORMATIONITEM_RL_PREEMPTREQUIREDIND			 517
#define	RNSAP_ID_HSDSCH_RNTI															 457
#define	RNSAP_ID_HSDSCH_TDD_INFORMATION													 458
#define	RNSAP_ID_HSDSCH_TDD_INFORMATION_RESPONSE										 459
#define	RNSAP_ID_HSDSCH_TDD_UPDATE_INFORMATION											 467
#define	RNSAP_ID_HSPDSCH_RL_ID															 463
#define	RNSAP_ID_HSDSCH_MACDFLOWS_TO_ADD 												 531
#define	RNSAP_ID_HSDSCH_MACDFLOWS_TO_DELETE												 532
#define	RNSAP_ID_ANGLE_OF_ARRIVAL_VALUE_LCR												 148
#define	RNSAP_ID_TRAFFICCLASS															 158
#define	RNSAP_ID_UNUSED_PROTOCOLIE_RNSAP_ID_248											 248
#define	RNSAP_ID_UNUSED_PROTOCOLIE_RNSAP_ID_253											 253
#define	RNSAP_ID_PDSCH_RL_ID															 323
#define	RNSAP_ID_TIMESLOT_RL_SETUPRSPTDD												 325
#define	RNSAP_ID_GERAN_CELL_CAPABILITY													 468
#define	RNSAP_ID_GERAN_CLASSMARK														 469
#define	RNSAP_ID_DSCH_INITIALWINDOWSIZE													 480
#define	RNSAP_ID_UL_SYNCHRONISATION_PARAMETERS_LCR										 464
#define	RNSAP_ID_SNA_INFORMATION														 479
#define	RNSAP_ID_MACHS_RESETINDICATOR													 465
#define	RNSAP_ID_TDD_DL_DPCH_TIMESLOTFORMATMODIFYITEM_LCR_RL_RECONFREADYTDD				 481
#define	RNSAP_ID_TDD_UL_DPCH_TIMESLOTFORMATMODIFYITEM_LCR_RL_RECONFREADYTDD				 482
#define	RNSAP_ID_TDD_TPC_UPLINKSTEPSIZE_LCR_RL_SETUPRQSTTDD								 483
#define	RNSAP_ID_UL_CCTRCH_INFORMATIONLIST_RL_ADDITIONRQSTTDD							 484
#define	RNSAP_ID_UL_CCTRCH_INFORMATIONITEM_RL_ADDITIONRQSTTDD							 485
#define	RNSAP_ID_DL_CCTRCH_INFORMATIONLIST_RL_ADDITIONRQSTTDD							 486
#define	RNSAP_ID_DL_CCTRCH_INFORMATIONITEM_RL_ADDITIONRQSTTDD							 487
#define	RNSAP_ID_TDD_TPC_UPLINKSTEPSIZE_INFORMATIONADD_LCR_RL_RECONFPREPTDD				 488
#define	RNSAP_ID_TDD_TPC_UPLINKSTEPSIZE_INFORMATIONMODIFY_LCR_RL_RECONFPREPTDD			 489
#define	RNSAP_ID_TDD_TPC_DOWNLINKSTEPSIZE_INFORMATIONADD_RL_RECONFPREPTDD				 490
#define	RNSAP_ID_TDD_TPC_DOWNLINKSTEPSIZE_INFORMATIONMODIFY_RL_RECONFPREPTDD			 491
#define	RNSAP_ID_UL_TIMINGADVANCECTRL_LCR												 492
#define	RNSAP_ID_HSPDSCH_TIMESLOT_INFORMATIONLIST_PHYCHRECONFRQSTTDD					 493
#define	RNSAP_ID_HSPDSCH_TIMESLOT_INFORMATIONLISTLCR_PHYCHRECONFRQSTTDD					 494
#define	RNSAP_ID_HS_SICH_RECEPTION_QUALITY 												 495
#define	RNSAP_ID_HS_SICH_RECEPTION_QUALITY_MEASUREMENT_VALUE 							 496
#define	RNSAP_ID_HSSICH_INFO_DM_RPRT													 497
#define	RNSAP_ID_HSSICH_INFO_DM_RQST													 498
#define	RNSAP_ID_HSSICH_INFO_DM															 499
#define	RNSAP_ID_CCTRCH_MAXIMUM_DL_POWER_RL_SETUPRSPTDD									 500
#define	RNSAP_ID_CCTRCH_MINIMUM_DL_POWER_RL_SETUPRSPTDD									 501
#define	RNSAP_ID_CCTRCH_MAXIMUM_DL_POWER_RL_ADDITIONRSPTDD								 502
#define	RNSAP_ID_CCTRCH_MINIMUM_DL_POWER_RL_ADDITIONRSPTDD								 503
#define	RNSAP_ID_CCTRCH_MAXIMUM_DL_POWER_RL_RECONFREADYTDD								 504
#define	RNSAP_ID_CCTRCH_MINIMUM_DL_POWER_RL_RECONFREADYTDD								 505
#define	RNSAP_ID_MAXIMUM_DL_POWER_TIMESLOTLCR_INFORMATIONMODIFYITEM_RL_RECONFREADYTDD	 506
#define	RNSAP_ID_MINIMUM_DL_POWER_TIMESLOTLCR_INFORMATIONMODIFYITEM_RL_RECONFREADYTDD	 507
#define	RNSAP_ID_DL_CCTRCH_INFORMATIONLIST_RL_RECONFRSPTDD								 508
#define	RNSAP_ID_DL_DPCH_INFORMATIONMODIFYITEM_LCR_RL_RECONFRSPTDD						 509
#define	RNSAP_ID_MAXIMUM_DL_POWER_TIMESLOTLCR_INFORMATIONITEM							 510
#define	RNSAP_ID_MINIMUM_DL_POWER_TIMESLOTLCR_INFORMATIONITEM							 511
#define	RNSAP_ID_TDD_SUPPORT_8PSK														 512
#define	RNSAP_ID_TDD_MAXNRDLPHYSICALCHANNELS											 513
#define	RNSAP_ID_EXTENDEDGSMCELLINDIVIDUALOFFSET										 514
#define	RNSAP_ID_RL_PARAMETERUPDATEINDICATIONFDD_RL_INFORMATIONLIST 					 518
#define	RNSAP_ID_PRIMARY_CPICH_USAGE_FOR_CHANNEL_ESTIMATION								 519
#define	RNSAP_ID_SECONDARY_CPICH_INFORMATION											 520
#define	RNSAP_ID_SECONDARY_CPICH_INFORMATION_CHANGE										 521
#define	RNSAP_ID_UNUSED_PROTOCOLIE_RNSAP_ID_522											 522
#define	RNSAP_ID_UNUSED_PROTOCOLIE_RNSAP_ID_523											 523
#define	RNSAP_ID_RL_PARAMETERUPDATEINDICATIONFDD_RL_INFORMATION_ITEM					 524
#define	RNSAP_ID_PHASE_REFERENCE_UPDATE_INDICATOR										 525
#define	RNSAP_ID_UNIDIRECTIONAL_DCH_INDICATOR											 526
#define	RNSAP_ID_RL_INFORMATION_RL_RECONFPREPTDD										 527
#define	RNSAP_ID_MULTIPLE_RL_INFORMATIONRESPONSE_RL_RECONFREADYTDD						 528
#define	RNSAP_ID_RL_RECONFIGURATIONRESPONSETDD_RL_INFORMATION							 529
#define	RNSAP_ID_SATELLITE_ALMANAC_INFORMATION_EXTITEM									 530
#define	RNSAP_ID_HSDSCH_INFORMATION_TO_MODIFY_UNSYNCHRONISED							 533
#define	RNSAP_ID_TNLQOS																	 534
#define	RNSAP_ID_RTLOADVALUE															 535
#define	RNSAP_ID_NRTLOADINFORMATIONVALUE												 536
#define	RNSAP_ID_CELLPORTIONID															 537
#define	RNSAP_ID_UPPTSINTERFERENCEVALUE													 538
#define	RNSAP_ID_PRIMARYCCPCH_RSCP_DELTA												 539
#define	RNSAP_ID_UEMEASUREMENTTYPE														 540
#define	RNSAP_ID_UEMEASUREMENTTIMESLOTINFOHCR											 541
#define	RNSAP_ID_UEMEASUREMENTTIMESLOTINFOLCR											 542
#define	RNSAP_ID_UEMEASUREMENTREPORTCHARACTERISTICS										 543
#define	RNSAP_ID_UEMEASUREMENTPARAMETERMODALLOW											 544
#define	RNSAP_ID_UEMEASUREMENTVALUEINFORMATION											 545
#define	RNSAP_ID_INTERFACESTOTRACEITEM													 546
#define	RNSAP_ID_LISTOFINTERFACESTOTRACE												 547
#define	RNSAP_ID_TRACEDEPTH																 548
#define	RNSAP_ID_TRACERECORDINGSESSIONREFERENCE											 549
#define	RNSAP_ID_TRACEREFERENCE															 550
#define	RNSAP_ID_UEIDENTITY																 551
#define	RNSAP_ID_NACC_RELATED_DATA														 552
#define	RNSAP_ID_GSM_CELL_INFEX_RQST													 553
#define	RNSAP_ID_MEASUREMENTRECOVERYBEHAVIOR											 554
#define	RNSAP_ID_MEASUREMENTRECOVERYREPORTINGINDICATOR									 555
#define	RNSAP_ID_MEASUREMENTRECOVERYSUPPORTINDICATOR									 556
#define	RNSAP_ID_DL_DPCH_POWER_INFORMATION_RL_RECONFPREPFDD								 557
#define	RNSAP_ID_F_DPCH_INFORMATION_RL_RECONFPREPFDD									 558
#define	RNSAP_ID_F_DPCH_INFORMATION_RL_SETUPRQSTFDD										 559
#define	RNSAP_ID_MBMS_BEARER_SERVICE_LIST												 560
#define	RNSAP_ID_MBMS_BEARER_SERVICE_LIST_INFEX_RSP										 561
#define	RNSAP_ID_ACTIVE_MBMS_BEARER_SERVICEFDD											 562
#define	RNSAP_ID_ACTIVE_MBMS_BEARER_SERVICETDD											 563
#define	RNSAP_ID_OLD_URA_ID																 564
#define	RNSAP_ID_UE_STATE																 568
#define	RNSAP_ID_URA_ID																	 569
#define	RNSAP_ID_HARQ_PREAMBLE_MODE														 571
#define	RNSAP_ID_SYNCHRONISATIONINDICATOR												 572
#define	RNSAP_ID_UL_DPDCHINDICATOREDCH													 573
#define	RNSAP_ID_EDPCH_INFORMATION														 574
#define	RNSAP_ID_RL_SPECIFIC_EDCH_INFORMATION											 575
#define	RNSAP_ID_EDCH_RL_INDICATION														 576
#define	RNSAP_ID_EDCH_FDD_INFORMATION													 577
#define	RNSAP_ID_EDCH_RLSET_ID															 578
#define	RNSAP_ID_SERVING_EDCHRL_ID														 579
#define	RNSAP_ID_EDCH_FDD_DL_CONTROLCHANNELINFORMATION									 580
#define	RNSAP_ID_EDCH_FDD_INFORMATIONRESPONSE											 581
#define	RNSAP_ID_EDCH_MACDFLOWS_TO_ADD													 582
#define	RNSAP_ID_EDCH_FDD_INFORMATION_TO_MODIFY											 583
#define	RNSAP_ID_EDCH_MACDFLOWS_TO_DELETE												 584
#define	RNSAP_ID_EDPCH_INFORMATION_RLRECONFREQUEST_FDD									 585
#define	RNSAP_ID_EDCH_MACDFLOWSPECIFICINFORMATIONLIST_RL_PREEMPTREQUIREDIND				 586
#define	RNSAP_ID_EDCH_MACDFLOWSPECIFICINFORMATIONITEM_RL_PREEMPTREQUIREDIND				 587
#define	RNSAP_ID_EDCH_MACDFLOWSPECIFICINFORMATIONLIST_RL_CONGESTIND  					 588
#define	RNSAP_ID_EDCH_MACDFLOWSPECIFICINFORMATIONITEM_RL_CONGESTIND						 589
#define	RNSAP_ID_MBMS_BEARER_SERVICE_FULL_ADDRESS										 590
#define	RNSAP_ID_INITIAL_DL_DPCH_TIMINGADJUSTMENT										 591
#define	RNSAP_ID_INITIAL_DL_DPCH_TIMINGADJUSTMENT_ALLOWED								 592
#define	RNSAP_ID_USER_PLANE_CONGESTION_FIELDS_INCLUSION									 593
#define	RNSAP_ID_HARQ_PREAMBLE_MODE_ACTIVATION_INDICATOR								 594
#define	RNSAP_ID_MULTIPLE_DEDICATEDMEASUREMENTVALUELIST_TDD_DM_RSP						 595
#define	RNSAP_ID_MULTIPLE_DEDICATEDMEASUREMENTVALUELIST_LCR_TDD_DM_RSP					 596
#define	RNSAP_ID_PROVIDEDINFORMATION													 597
#define	RNSAP_ID_ACTIVE_MBMS_BEARER_SERVICEFDD_PFL										 598
#define	RNSAP_ID_ACTIVE_MBMS_BEARER_SERVICETDD_PFL										 599
#define	RNSAP_ID_FREQUENCYBANDINDICATOR													 600
static dissector_handle_t rnsap_handle=NULL;

/* Initialize the protocol and registered fields */
static int proto_rnsap = -1;

static int hf_rnsap_pdu_length = -1;
static int hf_rnsap_IE_length = -1;
static int hf_rnsap_L3_DL_DCCH_Message_PDU = -1;


/*--- Included file: packet-rnsap-hf.c ---*/
#line 1 "packet-rnsap-hf.c"
static int hf_rnsap_RNSAP_PDU_PDU = -1;           /* RNSAP_PDU */
static int hf_rnsap_initiatingMessage = -1;       /* InitiatingMessage */
static int hf_rnsap_successfulOutcome = -1;       /* SuccessfulOutcome */
static int hf_rnsap_unsuccessfulOutcome = -1;     /* UnsuccessfulOutcome */
static int hf_rnsap_outcome = -1;                 /* Outcome */
static int hf_rnsap_procedureID = -1;             /* ProcedureID */
static int hf_rnsap_criticality = -1;             /* Criticality */
static int hf_rnsap_transactionID = -1;           /* TransactionID */
static int hf_rnsap_initiatingMessageValue = -1;  /* InitiatingMessageValue */
static int hf_rnsap_successfulOutcomeValue = -1;  /* SuccessfulOutcomeValue */
static int hf_rnsap_unsuccessfulOutcomeValue = -1;  /* UnsuccessfulOutcomeValue */
static int hf_rnsap_outcomeValue = -1;            /* OutcomeValue */
static int hf_rnsap_id_commonTransportChannelResourcesInitialisation = -1;  /* CommonTransportChannelResourcesRequest */
static int hf_rnsap_id_commonTransportChannelResourcesRelease = -1;  /* CommonTransportChannelResourcesReleaseRequest */
static int hf_rnsap_id_compressedModeCommand = -1;  /* CompressedModeCommand */
static int hf_rnsap_id_downlinkPowerControl = -1;  /* DL_PowerControlRequest */
static int hf_rnsap_id_downlinkPowerTimeslotControl = -1;  /* DL_PowerTimeslotControlRequest */
static int hf_rnsap_id_downlinkSignallingTransfer = -1;  /* DownlinkSignallingTransferRequest */
static int hf_rnsap_id_errorIndication = -1;      /* ErrorIndication */
static int hf_rnsap_id_dedicatedMeasurementFailure = -1;  /* DedicatedMeasurementFailureIndication */
static int hf_rnsap_id_dedicatedMeasurementInitiation = -1;  /* DedicatedMeasurementInitiationRequest */
static int hf_rnsap_id_dedicatedMeasurementReporting = -1;  /* DedicatedMeasurementReport */
static int hf_rnsap_id_dedicatedMeasurementTermination = -1;  /* DedicatedMeasurementTerminationRequest */
static int hf_rnsap_id_paging = -1;               /* PagingRequest */
static int hf_rnsap_id_physicalChannelReconfiguration = -1;  /* PhysicalChannelReconfigurationRequestTDD */
static int hf_rnsap_id_privateMessage = -1;       /* PrivateMessage */
static int hf_rnsap_id_radioLinkAddition = -1;    /* RadioLinkAdditionRequestFDD */
static int hf_rnsap_id_radioLinkAddition_TDD = -1;  /* RadioLinkAdditionRequestTDD */
static int hf_rnsap_id_radioLinkCongestion = -1;  /* RadioLinkCongestionIndication */
static int hf_rnsap_id_radioLinkDeletion = -1;    /* RadioLinkDeletionRequest */
static int hf_rnsap_id_radioLinkFailure = -1;     /* RadioLinkFailureIndication */
static int hf_rnsap_id_radioLinkPreemption = -1;  /* RadioLinkPreemptionRequiredIndication */
static int hf_rnsap_id_radioLinkRestoration = -1;  /* RadioLinkRestoreIndication */
static int hf_rnsap_id_radioLinkSetup = -1;       /* RadioLinkSetupRequestFDD */
static int hf_rnsap_id_radioLinkSetupTdd = -1;    /* RadioLinkSetupRequestTDD */
static int hf_rnsap_id_relocationCommit = -1;     /* RelocationCommit */
static int hf_rnsap_id_synchronisedRadioLinkReconfigurationCancellation = -1;  /* RadioLinkReconfigurationCancel */
static int hf_rnsap_id_synchronisedRadioLinkReconfigurationCommit = -1;  /* RadioLinkReconfigurationCommit */
static int hf_rnsap_id_synchronisedRadioLinkReconfigurationPreparation = -1;  /* RadioLinkReconfigurationPrepareFDD */
static int hf_rnsap_id_synchronisedRadioLinkReconfigurationPreparation_TDD = -1;  /* RadioLinkReconfigurationReadyTDD */
static int hf_rnsap_id_unSynchronisedRadioLinkReconfiguration = -1;  /* RadioLinkReconfigurationRequestFDD */
static int hf_rnsap_id_unSynchronisedRadioLinkReconfiguration_TDD = -1;  /* RadioLinkReconfigurationRequestTDD */
static int hf_rnsap_id_uplinkSignallingTransfer = -1;  /* UplinkSignallingTransferIndicationFDD */
static int hf_rnsap_id_uplinkSignallingTransfer_TDD = -1;  /* UplinkSignallingTransferIndicationTDD */
static int hf_rnsap_id_commonMeasurementFailure = -1;  /* CommonMeasurementFailureIndication */
static int hf_rnsap_id_commonMeasurementInitiation = -1;  /* CommonMeasurementInitiationRequest */
static int hf_rnsap_id_commonMeasurementReporting = -1;  /* CommonMeasurementReport */
static int hf_rnsap_id_commonMeasurementTermination = -1;  /* CommonMeasurementTerminationRequest */
static int hf_rnsap_id_informationExchangeFailure = -1;  /* InformationExchangeFailureIndication */
static int hf_rnsap_id_informationExchangeInitiation = -1;  /* InformationExchangeInitiationRequest */
static int hf_rnsap_id_informationReporting = -1;  /* InformationReport */
static int hf_rnsap_id_informationExchangeTermination = -1;  /* InformationExchangeTerminationRequest */
static int hf_rnsap_id_reset = -1;                /* ResetRequest */
static int hf_rnsap_id_radioLinkActivation = -1;  /* RadioLinkActivationCommandFDD */
static int hf_rnsap_id_radioLinkActivation_TDD = -1;  /* RadioLinkActivationCommandTDD */
static int hf_rnsap_id_gERANuplinkSignallingTransfer = -1;  /* GERANUplinkSignallingTransferIndication */
static int hf_rnsap_id_radioLinkParameterUpdate = -1;  /* RadioLinkParameterUpdateIndicationFDD */
static int hf_rnsap_id_radioLinkParameterUpdate_TDD = -1;  /* RadioLinkParameterUpdateIndicationTDD */
static int hf_rnsap_id_uEMeasurementFailure = -1;  /* UEMeasurementFailureIndication */
static int hf_rnsap_id_uEMeasurementInitiation = -1;  /* UEMeasurementInitiationRequest */
static int hf_rnsap_id_uEMeasurementReporting = -1;  /* UEMeasurementReport */
static int hf_rnsap_id_uEMeasurementTermination = -1;  /* UEMeasurementTerminationRequest */
static int hf_rnsap_id_iurDeactivateTrace = -1;   /* IurDeactivateTrace */
static int hf_rnsap_id_iurInvokeTrace = -1;       /* IurInvokeTrace */
static int hf_rnsap_id_mBMSAttach = -1;           /* MBMSAttachCommand */
static int hf_rnsap_id_mBMSDetach = -1;           /* MBMSDetachCommand */
static int hf_rnsap_id_directInformationTransfer = -1;  /* DirectInformationTransfer */
static int hf_rnsap_id_commonTransportChannelResourcesInitialisation1 = -1;  /* CommonTransportChannelResourcesResponseFDD */
static int hf_rnsap_id_commonTransportChannelResourcesInitialisation_TDD = -1;  /* CommonTransportChannelResourcesResponseTDD */
static int hf_rnsap_id_dedicatedMeasurementInitiation1 = -1;  /* DedicatedMeasurementInitiationResponse */
static int hf_rnsap_id_physicalChannelReconfiguration1 = -1;  /* PhysicalChannelReconfigurationCommand */
static int hf_rnsap_id_radioLinkAddition1 = -1;   /* RadioLinkAdditionResponseFDD */
static int hf_rnsap_id_radioLinkAddition_TDD1 = -1;  /* RadioLinkAdditionResponseTDD */
static int hf_rnsap_id_radioLinkDeletion1 = -1;   /* RadioLinkDeletionResponse */
static int hf_rnsap_id_radioLinkSetup1 = -1;      /* RadioLinkSetupResponseFDD */
static int hf_rnsap_id_radioLinkSetupTdd1 = -1;   /* RadioLinkSetupResponseTDD */
static int hf_rnsap_id_synchronisedRadioLinkReconfigurationPreparation1 = -1;  /* RadioLinkReconfigurationReadyFDD */
static int hf_rnsap_id_unSynchronisedRadioLinkReconfiguration1 = -1;  /* RadioLinkReconfigurationResponseFDD */
static int hf_rnsap_id_unSynchronisedRadioLinkReconfiguration_TDD1 = -1;  /* RadioLinkReconfigurationResponseTDD */
static int hf_rnsap_id_commonMeasurementInitiation1 = -1;  /* CommonMeasurementInitiationResponse */
static int hf_rnsap_id_informationExchangeInitiation1 = -1;  /* InformationExchangeInitiationResponse */
static int hf_rnsap_id_reset1 = -1;               /* ResetResponse */
static int hf_rnsap_id_uEMeasurementInitiation1 = -1;  /* UEMeasurementInitiationResponse */
static int hf_rnsap_id_commonTransportChannelResourcesInitialisation2 = -1;  /* CommonTransportChannelResourcesFailure */
static int hf_rnsap_id_dedicatedMeasurementInitiation2 = -1;  /* DedicatedMeasurementInitiationFailure */
static int hf_rnsap_id_physicalChannelReconfiguration2 = -1;  /* PhysicalChannelReconfigurationFailure */
static int hf_rnsap_id_radioLinkAddition2 = -1;   /* RadioLinkAdditionFailureFDD */
static int hf_rnsap_id_radioLinkAddition_TDD2 = -1;  /* RadioLinkAdditionFailureTDD */
static int hf_rnsap_id_radioLinkSetup2 = -1;      /* RadioLinkSetupFailureFDD */
static int hf_rnsap_id_radioLinkSetupTdd2 = -1;   /* RadioLinkSetupFailureTDD */
static int hf_rnsap_id_synchronisedRadioLinkReconfigurationPreparation2 = -1;  /* RadioLinkReconfigurationFailure */
static int hf_rnsap_id_unSynchronisedRadioLinkReconfiguration2 = -1;  /* RadioLinkReconfigurationFailure */
static int hf_rnsap_id_unSynchronisedRadioLinkReconfiguration_TDD2 = -1;  /* RadioLinkReconfigurationFailure */
static int hf_rnsap_id_commonMeasurementInitiation2 = -1;  /* CommonMeasurementInitiationFailure */
static int hf_rnsap_id_informationExchangeInitiation2 = -1;  /* InformationExchangeInitiationFailure */
static int hf_rnsap_id_uEMeasurementInitiation2 = -1;  /* UEMeasurementInitiationFailure */
static int hf_rnsap_id_AllowedQueuingTime = -1;   /* AllowedQueuingTime */
static int hf_rnsap_id_Allowed_Rate_Information = -1;  /* Allowed_Rate_Information */
static int hf_rnsap_id_AntennaColocationIndicator = -1;  /* AntennaColocationIndicator */
static int hf_rnsap_id_BindingID = -1;            /* BindingID */
static int hf_rnsap_id_C_ID = -1;                 /* C_ID */
static int hf_rnsap_id_C_RNTI = -1;               /* C_RNTI */
static int hf_rnsap_id_Cell_Capacity_Class_Value = -1;  /* Cell_Capacity_Class_Value */
static int hf_rnsap_id_CFN = -1;                  /* CFN */
static int hf_rnsap_id_CN_CS_DomainIdentifier = -1;  /* CN_CS_DomainIdentifier */
static int hf_rnsap_id_CN_PS_DomainIdentifier = -1;  /* CN_PS_DomainIdentifier */
static int hf_rnsap_id_Cause = -1;                /* Cause */
static int hf_rnsap_id_CoverageIndicator = -1;    /* CoverageIndicator */
static int hf_rnsap_id_CriticalityDiagnostics = -1;  /* CriticalityDiagnostics */
static int hf_rnsap_id_ContextInfoItem_Reset = -1;  /* ContextInfoItem_Reset */
static int hf_rnsap_id_ContextGroupInfoItem_Reset = -1;  /* ContextGroupInfoItem_Reset */
static int hf_rnsap_id_D_RNTI = -1;               /* D_RNTI */
static int hf_rnsap_id_D_RNTI_ReleaseIndication = -1;  /* D_RNTI_ReleaseIndication */
static int hf_rnsap_id_DCHs_to_Add_FDD = -1;      /* DCH_FDD_Information */
static int hf_rnsap_id_DCHs_to_Add_TDD = -1;      /* DCH_TDD_Information */
static int hf_rnsap_id_DCH_DeleteList_RL_ReconfPrepFDD = -1;  /* DCH_DeleteList_RL_ReconfPrepFDD */
static int hf_rnsap_id_DCH_DeleteList_RL_ReconfPrepTDD = -1;  /* DCH_DeleteList_RL_ReconfPrepTDD */
static int hf_rnsap_id_DCH_DeleteList_RL_ReconfRqstFDD = -1;  /* DCH_DeleteList_RL_ReconfRqstFDD */
static int hf_rnsap_id_DCH_DeleteList_RL_ReconfRqstTDD = -1;  /* DCH_DeleteList_RL_ReconfRqstTDD */
static int hf_rnsap_id_DCH_FDD_Information = -1;  /* DCH_FDD_Information */
static int hf_rnsap_id_DCH_TDD_Information = -1;  /* DCH_TDD_Information */
static int hf_rnsap_id_FDD_DCHs_to_Modify = -1;   /* FDD_DCHs_to_Modify */
static int hf_rnsap_id_TDD_DCHs_to_Modify = -1;   /* TDD_DCHs_to_Modify */
static int hf_rnsap_id_DCH_InformationResponse = -1;  /* DCH_InformationResponse */
static int hf_rnsap_id_DCH_Rate_InformationItem_RL_CongestInd = -1;  /* DCH_Rate_InformationItem_RL_CongestInd */
static int hf_rnsap_id_DL_CCTrCH_InformationAddItem_RL_ReconfPrepTDD = -1;  /* DL_CCTrCH_InformationAddItem_RL_ReconfPrepTDD */
static int hf_rnsap_id_DL_CCTrCH_InformationListIE_RL_ReconfReadyTDD = -1;  /* DL_CCTrCHInformationListIE_RL_ReconfReadyTDD */
static int hf_rnsap_id_DL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD = -1;  /* DL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD */
static int hf_rnsap_id_DL_CCTrCH_InformationItem_RL_SetupRqstTDD = -1;  /* DL_CCTrCH_InformationItem_RL_SetupRqstTDD */
static int hf_rnsap_id_DL_CCTrCH_InformationListIE_PhyChReconfRqstTDD = -1;  /* DL_CCTrCH_InformationListIE_PhyChReconfRqstTDD */
static int hf_rnsap_id_DL_CCTrCH_InformationListIE_RL_AdditionRspTDD = -1;  /* DL_CCTrCHInformationListIE_RL_AdditionRspTDD */
static int hf_rnsap_id_DL_CCTrCH_InformationListIE_RL_SetupRspTDD = -1;  /* DL_CCTrCH_InformationItem_RL_SetupRqstTDD */
static int hf_rnsap_id_DL_CCTrCH_InformationAddList_RL_ReconfPrepTDD = -1;  /* DL_CCTrCH_InformationAddList_RL_ReconfPrepTDD */
static int hf_rnsap_id_DL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD = -1;  /* DL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD */
static int hf_rnsap_id_DL_CCTrCH_InformationList_RL_SetupRqstTDD = -1;  /* DL_CCTrCH_InformationList_RL_SetupRqstTDD */
static int hf_rnsap_id_FDD_DL_CodeInformation = -1;  /* FDD_DL_CodeInformation */
static int hf_rnsap_id_DL_DPCH_Information_RL_ReconfPrepFDD = -1;  /* DL_DPCH_Information_RL_ReconfPrepFDD */
static int hf_rnsap_id_DL_DPCH_Information_RL_SetupRqstFDD = -1;  /* DL_DPCH_Information_RL_SetupRqstFDD */
static int hf_rnsap_id_DL_DPCH_Information_RL_ReconfRqstFDD = -1;  /* DL_DPCH_Information_RL_ReconfRqstFDD */
static int hf_rnsap_id_DL_DPCH_InformationItem_PhyChReconfRqstTDD = -1;  /* DL_DPCH_InformationItem_PhyChReconfRqstTDD */
static int hf_rnsap_id_DL_DPCH_InformationItem_RL_AdditionRspTDD = -1;  /* DL_DPCH_InformationItem_RL_AdditionRspTDD */
static int hf_rnsap_id_DL_DPCH_InformationItem_RL_SetupRspTDD = -1;  /* DL_DPCH_InformationItem_RL_SetupRspTDD */
static int hf_rnsap_id_DL_DPCH_TimingAdjustment = -1;  /* DL_DPCH_TimingAdjustment */
static int hf_rnsap_id_DLReferencePower = -1;     /* DL_Power */
static int hf_rnsap_id_DLReferencePowerList_DL_PC_Rqst = -1;  /* DL_ReferencePowerInformationList_DL_PC_Rqst */
static int hf_rnsap_id_DL_ReferencePowerInformation_DL_PC_Rqst = -1;  /* DL_ReferencePowerInformation_DL_PC_Rqst */
static int hf_rnsap_id_DPC_Mode = -1;             /* DPC_Mode */
static int hf_rnsap_id_DRXCycleLengthCoefficient = -1;  /* DRXCycleLengthCoefficient */
static int hf_rnsap_id_DedicatedMeasurementObjectType_DM_Fail_Ind = -1;  /* DedicatedMeasurementObjectType_DM_Fail_Ind */
static int hf_rnsap_id_DedicatedMeasurementObjectType_DM_Fail = -1;  /* DedicatedMeasurementObjectType_DM_Fail */
static int hf_rnsap_id_DedicatedMeasurementObjectType_DM_Rprt = -1;  /* DedicatedMeasurementObjectType_DM_Rprt */
static int hf_rnsap_id_DedicatedMeasurementObjectType_DM_Rqst = -1;  /* DedicatedMeasurementObjectType_DM_Rqst */
static int hf_rnsap_id_DedicatedMeasurementObjectType_DM_Rsp = -1;  /* DedicatedMeasurementObjectType_DM_Rsp */
static int hf_rnsap_id_DedicatedMeasurementType = -1;  /* DedicatedMeasurementType */
static int hf_rnsap_id_FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspFDD = -1;  /* FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspFDD */
static int hf_rnsap_id_FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspTDD = -1;  /* FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspTDD */
static int hf_rnsap_id_Guaranteed_Rate_Information = -1;  /* Guaranteed_Rate_Information */
static int hf_rnsap_id_IMSI = -1;                 /* IMSI */
static int hf_rnsap_id_HCS_Prio = -1;             /* HCS_Prio */
static int hf_rnsap_id_L3_Information = -1;       /* L3_Information */
static int hf_rnsap_id_AdjustmentPeriod = -1;     /* AdjustmentPeriod */
static int hf_rnsap_id_MaxAdjustmentStep = -1;    /* MaxAdjustmentStep */
static int hf_rnsap_id_MeasurementFilterCoefficient = -1;  /* MeasurementFilterCoefficient */
static int hf_rnsap_id_MessageStructure = -1;     /* MessageStructure */
static int hf_rnsap_id_MeasurementID = -1;        /* MeasurementID */
static int hf_rnsap_id_Neighbouring_GSM_CellInformation = -1;  /* Neighbouring_GSM_CellInformation */
static int hf_rnsap_id_Neighbouring_UMTS_CellInformationItem = -1;  /* Neighbouring_UMTS_CellInformationItem */
static int hf_rnsap_id_NRT_Load_Information_Value = -1;  /* NRT_Load_Information_Value */
static int hf_rnsap_id_NRT_Load_Information_Value_IncrDecrThres = -1;  /* NRT_Load_Information_Value_IncrDecrThres */
static int hf_rnsap_id_PagingArea_PagingRqst = -1;  /* PagingArea_PagingRqst */
static int hf_rnsap_id_FACH_FlowControlInformation = -1;  /* FACH_FlowControlInformation */
static int hf_rnsap_id_PartialReportingIndicator = -1;  /* PartialReportingIndicator */
static int hf_rnsap_id_Permanent_NAS_UE_Identity = -1;  /* Permanent_NAS_UE_Identity */
static int hf_rnsap_id_PowerAdjustmentType = -1;  /* PowerAdjustmentType */
static int hf_rnsap_id_RANAP_RelocationInformation = -1;  /* RANAP_RelocationInformation */
static int hf_rnsap_id_RL_Information_PhyChReconfRqstFDD = -1;  /* RL_Information_PhyChReconfRqstFDD */
static int hf_rnsap_id_RL_Information_PhyChReconfRqstTDD = -1;  /* RL_Information_PhyChReconfRqstTDD */
static int hf_rnsap_id_RL_Information_RL_AdditionRqstFDD = -1;  /* RL_Information_RL_AdditionRqstFDD */
static int hf_rnsap_id_RL_Information_RL_AdditionRqstTDD = -1;  /* RL_Information_RL_AdditionRqstTDD */
static int hf_rnsap_id_RL_Information_RL_DeletionRqst = -1;  /* RL_Information_RL_DeletionRqst */
static int hf_rnsap_id_RL_Information_RL_FailureInd = -1;  /* RL_Information_RL_FailureInd */
static int hf_rnsap_id_RL_Information_RL_ReconfPrepFDD = -1;  /* RL_Information_RL_ReconfPrepFDD */
static int hf_rnsap_id_RL_Information_RL_RestoreInd = -1;  /* RL_Information_RL_RestoreInd */
static int hf_rnsap_id_RL_Information_RL_SetupRqstFDD = -1;  /* RL_InformationList_RL_SetupRqstFDD */
static int hf_rnsap_id_RL_Information_RL_SetupRqstTDD = -1;  /* RL_Information_RL_SetupRqstTDD */
static int hf_rnsap_id_RL_InformationItem_RL_CongestInd = -1;  /* RL_InformationItem_RL_CongestInd */
static int hf_rnsap_id_RL_InformationItem_DM_Rprt = -1;  /* RL_InformationItem_DM_Rprt */
static int hf_rnsap_id_RL_InformationItem_DM_Rqst = -1;  /* RL_InformationItem_DM_Rqst */
static int hf_rnsap_id_RL_InformationItem_DM_Rsp = -1;  /* RL_InformationItem_DM_Rsp */
static int hf_rnsap_id_RL_InformationItem_RL_PreemptRequiredInd = -1;  /* RL_InformationItem_RL_PreemptRequiredInd */
static int hf_rnsap_id_RL_InformationItem_RL_SetupRqstFDD = -1;  /* RL_InformationItem_RL_SetupRqstFDD */
static int hf_rnsap_id_RL_InformationList_RL_CongestInd = -1;  /* RL_InformationList_RL_CongestInd */
static int hf_rnsap_id_RL_InformationList_RL_AdditionRqstFDD = -1;  /* RL_InformationList_RL_AdditionRqstFDD */
static int hf_rnsap_id_RL_InformationList_RL_DeletionRqst = -1;  /* RL_InformationList_RL_DeletionRqst */
static int hf_rnsap_id_RL_InformationList_RL_PreemptRequiredInd = -1;  /* RL_InformationList_RL_PreemptRequiredInd */
static int hf_rnsap_id_RL_InformationList_RL_ReconfPrepFDD = -1;  /* RL_InformationList_RL_ReconfPrepFDD */
static int hf_rnsap_id_RL_InformationResponse_RL_AdditionRspTDD = -1;  /* RL_InformationResponse_RL_AdditionRspTDD */
static int hf_rnsap_id_RL_InformationResponse_RL_ReconfReadyTDD = -1;  /* RL_InformationResponse_RL_ReconfReadyTDD */
static int hf_rnsap_id_RL_InformationResponse_RL_SetupRspTDD = -1;  /* RL_InformationResponse_RL_SetupRspTDD */
static int hf_rnsap_id_RL_InformationResponseItem_RL_AdditionRspFDD = -1;  /* RL_InformationResponseItem_RL_AdditionRspFDD */
static int hf_rnsap_id_RL_InformationResponseItem_RL_ReconfReadyFDD = -1;  /* RL_InformationResponseItem_RL_ReconfReadyFDD */
static int hf_rnsap_id_RL_InformationResponseItem_RL_ReconfRspFDD = -1;  /* RL_InformationResponseItem_RL_ReconfRspFDD */
static int hf_rnsap_id_RL_InformationResponseItem_RL_SetupRspFDD = -1;  /* RL_InformationResponseItem_RL_SetupRspFDD */
static int hf_rnsap_id_RL_InformationResponseList_RL_AdditionRspFDD = -1;  /* RL_InformationResponseList_RL_AdditionRspFDD */
static int hf_rnsap_id_RL_InformationResponseList_RL_ReconfReadyFDD = -1;  /* RL_InformationResponseList_RL_ReconfReadyFDD */
static int hf_rnsap_id_RL_InformationResponseList_RL_ReconfRspFDD = -1;  /* RL_InformationResponseList_RL_ReconfRspFDD */
static int hf_rnsap_id_RL_InformationResponse_RL_ReconfRspTDD = -1;  /* RL_InformationResponse_RL_ReconfRspTDD */
static int hf_rnsap_id_RL_InformationResponseList_RL_SetupRspFDD = -1;  /* RL_InformationResponseList_RL_SetupRspFDD */
static int hf_rnsap_id_RL_ReconfigurationFailure_RL_ReconfFail = -1;  /* RL_ReconfigurationFailure_RL_ReconfFail */
static int hf_rnsap_id_RL_Set_InformationItem_DM_Rprt = -1;  /* RL_Set_InformationItem_DM_Rprt */
static int hf_rnsap_id_RL_Set_InformationItem_DM_Rqst = -1;  /* RL_Set_InformationItem_DM_Rqst */
static int hf_rnsap_id_RL_Set_InformationItem_DM_Rsp = -1;  /* RL_Set_InformationItem_DM_Rsp */
static int hf_rnsap_id_RL_Set_Information_RL_FailureInd = -1;  /* RL_Set_Information_RL_FailureInd */
static int hf_rnsap_id_RL_Set_Information_RL_RestoreInd = -1;  /* RL_Set_Information_RL_RestoreInd */
static int hf_rnsap_id_RL_Set_Successful_InformationItem_DM_Fail = -1;  /* RL_Set_Successful_InformationItem_DM_Fail */
static int hf_rnsap_id_RL_Set_Unsuccessful_InformationItem_DM_Fail = -1;  /* RL_Set_Unsuccessful_InformationItem_DM_Fail */
static int hf_rnsap_id_RL_Set_Unsuccessful_InformationItem_DM_Fail_Ind = -1;  /* RL_Set_Unsuccessful_InformationItem_DM_Fail_Ind */
static int hf_rnsap_id_RL_Successful_InformationItem_DM_Fail = -1;  /* RL_Successful_InformationItem_DM_Fail */
static int hf_rnsap_id_RL_Unsuccessful_InformationItem_DM_Fail = -1;  /* RL_Unsuccessful_InformationItem_DM_Fail */
static int hf_rnsap_id_RL_Unsuccessful_InformationItem_DM_Fail_Ind = -1;  /* RL_Unsuccessful_InformationItem_DM_Fail_Ind */
static int hf_rnsap_id_ReportCharacteristics = -1;  /* ReportCharacteristics */
static int hf_rnsap_id_Reporting_Object_RL_FailureInd = -1;  /* Reporting_Object_RL_FailureInd */
static int hf_rnsap_id_Reporing_Object_RL_RestoreInd = -1;  /* Reporting_Object_RL_RestoreInd */
static int hf_rnsap_id_RT_Load_Value = -1;        /* RT_Load_Value */
static int hf_rnsap_id_RT_Load_Value_IncrDecrThres = -1;  /* RT_Load_Value_IncrDecrThres */
static int hf_rnsap_id_S_RNTI = -1;               /* S_RNTI */
static int hf_rnsap_id_ResetIndicator = -1;       /* ResetIndicator */
static int hf_rnsap_id_RNC_ID = -1;               /* RNC_ID */
static int hf_rnsap_id_SAI = -1;                  /* SAI */
static int hf_rnsap_id_SRNC_ID = -1;              /* RNC_ID */
static int hf_rnsap_id_SuccessfulRL_InformationResponse_RL_AdditionFailureFDD = -1;  /* SuccessfulRL_InformationResponse_RL_AdditionFailureFDD */
static int hf_rnsap_id_SuccessfulRL_InformationResponse_RL_SetupFailureFDD = -1;  /* SuccessfulRL_InformationResponse_RL_SetupFailureFDD */
static int hf_rnsap_id_TransportBearerID = -1;    /* TransportBearerID */
static int hf_rnsap_id_TransportBearerRequestIndicator = -1;  /* TransportBearerRequestIndicator */
static int hf_rnsap_id_TransportLayerAddress = -1;  /* TransportLayerAddress */
static int hf_rnsap_id_TypeOfError = -1;          /* TypeOfError */
static int hf_rnsap_id_UC_ID = -1;                /* UC_ID */
static int hf_rnsap_id_UL_CCTrCH_AddInformation_RL_ReconfPrepTDD = -1;  /* UL_CCTrCH_AddInformation_RL_ReconfPrepTDD */
static int hf_rnsap_id_UL_CCTrCH_InformationAddList_RL_ReconfPrepTDD = -1;  /* UL_CCTrCH_InformationAddList_RL_ReconfPrepTDD */
static int hf_rnsap_id_UL_CCTrCH_InformationItem_RL_SetupRqstTDD = -1;  /* UL_CCTrCH_InformationItem_RL_SetupRqstTDD */
static int hf_rnsap_id_UL_CCTrCH_InformationList_RL_SetupRqstTDD = -1;  /* UL_CCTrCH_InformationList_RL_SetupRqstTDD */
static int hf_rnsap_id_UL_CCTrCH_InformationListIE_PhyChReconfRqstTDD = -1;  /* UL_CCTrCH_InformationListIE_PhyChReconfRqstTDD */
static int hf_rnsap_id_UL_CCTrCH_InformationListIE_RL_AdditionRspTDD = -1;  /* UL_CCTrCHInformationListIE_RL_AdditionRspTDD */
static int hf_rnsap_id_UL_CCTrCH_InformationListIE_RL_ReconfReadyTDD = -1;  /* UL_CCTrCHInformationListIE_RL_ReconfReadyTDD */
static int hf_rnsap_id_UL_CCTrCH_InformationListIE_RL_SetupRspTDD = -1;  /* UL_CCTrCHInformationListIE_RL_SetupRspTDD */
static int hf_rnsap_id_UL_DPCH_Information_RL_ReconfPrepFDD = -1;  /* UL_DPCH_Information_RL_ReconfPrepFDD */
static int hf_rnsap_id_UL_DPCH_Information_RL_ReconfRqstFDD = -1;  /* UL_DPCH_Information_RL_ReconfRqstFDD */
static int hf_rnsap_id_UL_DPCH_Information_RL_SetupRqstFDD = -1;  /* UL_DPCH_Information_RL_SetupRqstFDD */
static int hf_rnsap_id_UL_DPCH_InformationItem_PhyChReconfRqstTDD = -1;  /* UL_DPCH_InformationItem_PhyChReconfRqstTDD */
static int hf_rnsap_id_UL_DPCH_InformationItem_RL_AdditionRspTDD = -1;  /* UL_DPCH_InformationItem_RL_AdditionRspTDD */
static int hf_rnsap_id_UL_DPCH_InformationItem_RL_SetupRspTDD = -1;  /* UL_DPCH_InformationItem_RL_SetupRspTDD */
static int hf_rnsap_id_UL_DPCH_InformationAddListIE_RL_ReconfReadyTDD = -1;  /* UL_DPCH_InformationAddListIE_RL_ReconfReadyTDD */
static int hf_rnsap_id_UL_SIRTarget = -1;         /* UL_SIR */
static int hf_rnsap_id_URA_Information = -1;      /* URA_Information */
static int hf_rnsap_id_UnsuccessfulRL_InformationResponse_RL_AdditionFailureFDD = -1;  /* UnsuccessfulRL_InformationResponse_RL_AdditionFailureFDD */
static int hf_rnsap_id_UnsuccessfulRL_InformationResponse_RL_SetupFailureFDD = -1;  /* UnsuccessfulRL_InformationResponse_RL_SetupFailureFDD */
static int hf_rnsap_id_UnsuccessfulRL_InformationResponse_RL_SetupFailureTDD = -1;  /* UnsuccessfulRL_InformationResponse_RL_SetupFailureTDD */
static int hf_rnsap_id_Active_Pattern_Sequence_Information = -1;  /* Active_Pattern_Sequence_Information */
static int hf_rnsap_id_AdjustmentRatio = -1;      /* ScaledAdjustmentRatio */
static int hf_rnsap_id_CauseLevel_RL_AdditionFailureFDD = -1;  /* CauseLevel_RL_AdditionFailureFDD */
static int hf_rnsap_id_CauseLevel_RL_AdditionFailureTDD = -1;  /* CauseLevel_RL_AdditionFailureTDD */
static int hf_rnsap_id_CauseLevel_RL_ReconfFailure = -1;  /* CauseLevel_RL_ReconfFailure */
static int hf_rnsap_id_CauseLevel_RL_SetupFailureFDD = -1;  /* CauseLevel_RL_SetupFailureFDD */
static int hf_rnsap_id_CauseLevel_RL_SetupFailureTDD = -1;  /* CauseLevel_RL_SetupFailureTDD */
static int hf_rnsap_id_DL_CCTrCH_InformationDeleteItem_RL_ReconfPrepTDD = -1;  /* DL_CCTrCH_InformationDeleteItem_RL_ReconfPrepTDD */
static int hf_rnsap_id_DL_CCTrCH_InformationModifyItem_RL_ReconfPrepTDD = -1;  /* DL_CCTrCH_InformationModifyItem_RL_ReconfPrepTDD */
static int hf_rnsap_id_DL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD = -1;  /* DL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD */
static int hf_rnsap_id_DL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD = -1;  /* DL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD */
static int hf_rnsap_id_DL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD = -1;  /* DL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD */
static int hf_rnsap_id_DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD = -1;  /* DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD */
static int hf_rnsap_id_DL_DPCH_InformationAddListIE_RL_ReconfReadyTDD = -1;  /* DL_DPCH_InformationAddListIE_RL_ReconfReadyTDD */
static int hf_rnsap_id_DL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD = -1;  /* DL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD */
static int hf_rnsap_id_DL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD = -1;  /* DL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD */
static int hf_rnsap_id_DSCHs_to_Add_TDD = -1;     /* DSCH_TDD_Information */
static int hf_rnsap_id_DSCH_DeleteList_RL_ReconfPrepTDD = -1;  /* DSCH_DeleteList_RL_ReconfPrepTDD */
static int hf_rnsap_id_DSCH_InformationListIE_RL_AdditionRspTDD = -1;  /* DSCH_InformationListIE_RL_AdditionRspTDD */
static int hf_rnsap_id_DSCH_InformationListIEs_RL_SetupRspTDD = -1;  /* DSCH_InformationListIEs_RL_SetupRspTDD */
static int hf_rnsap_id_DSCH_TDD_Information = -1;  /* DSCH_TDD_Information */
static int hf_rnsap_id_DSCH_ModifyList_RL_ReconfPrepTDD = -1;  /* DSCH_ModifyList_RL_ReconfPrepTDD */
static int hf_rnsap_id_DSCHToBeAddedOrModifiedList_RL_ReconfReadyTDD = -1;  /* DSCHToBeAddedOrModifiedList_RL_ReconfReadyTDD */
static int hf_rnsap_id_GA_Cell = -1;              /* GA_Cell */
static int hf_rnsap_id_GA_CellAdditionalShapes = -1;  /* GA_CellAdditionalShapes */
static int hf_rnsap_id_Transmission_Gap_Pattern_Sequence_Information = -1;  /* Transmission_Gap_Pattern_Sequence_Information */
static int hf_rnsap_id_UL_CCTrCH_DeleteInformation_RL_ReconfPrepTDD = -1;  /* UL_CCTrCH_DeleteInformation_RL_ReconfPrepTDD */
static int hf_rnsap_id_UL_CCTrCH_ModifyInformation_RL_ReconfPrepTDD = -1;  /* UL_CCTrCH_ModifyInformation_RL_ReconfPrepTDD */
static int hf_rnsap_id_UL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD = -1;  /* UL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD */
static int hf_rnsap_id_UL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD = -1;  /* UL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD */
static int hf_rnsap_id_UL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD = -1;  /* UL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD */
static int hf_rnsap_id_UL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD = -1;  /* UL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD */
static int hf_rnsap_id_UL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD = -1;  /* UL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD */
static int hf_rnsap_id_UL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD = -1;  /* UL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD */
static int hf_rnsap_id_UL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD = -1;  /* UL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD */
static int hf_rnsap_id_UL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD = -1;  /* UL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD */
static int hf_rnsap_id_UnsuccessfulRL_InformationResponse_RL_AdditionFailureTDD = -1;  /* UnsuccessfulRL_InformationResponse_RL_AdditionFailureTDD */
static int hf_rnsap_id_USCHs_to_Add = -1;         /* USCH_Information */
static int hf_rnsap_id_USCH_DeleteList_RL_ReconfPrepTDD = -1;  /* USCH_DeleteList_RL_ReconfPrepTDD */
static int hf_rnsap_id_USCH_InformationListIE_RL_AdditionRspTDD = -1;  /* USCH_InformationListIE_RL_AdditionRspTDD */
static int hf_rnsap_id_USCH_InformationListIEs_RL_SetupRspTDD = -1;  /* USCH_InformationListIEs_RL_SetupRspTDD */
static int hf_rnsap_id_USCH_Information = -1;     /* USCH_Information */
static int hf_rnsap_id_USCH_ModifyList_RL_ReconfPrepTDD = -1;  /* USCH_ModifyList_RL_ReconfPrepTDD */
static int hf_rnsap_id_USCHToBeAddedOrModifiedList_RL_ReconfReadyTDD = -1;  /* USCHToBeAddedOrModifiedList_RL_ReconfReadyTDD */
static int hf_rnsap_id_DL_Physical_Channel_Information_RL_SetupRqstTDD = -1;  /* DL_Physical_Channel_Information_RL_SetupRqstTDD */
static int hf_rnsap_id_UL_Physical_Channel_Information_RL_SetupRqstTDD = -1;  /* UL_Physical_Channel_Information_RL_SetupRqstTDD */
static int hf_rnsap_id_ClosedLoopMode1_SupportIndicator = -1;  /* ClosedLoopMode1_SupportIndicator */
static int hf_rnsap_id_STTD_SupportIndicator = -1;  /* STTD_SupportIndicator */
static int hf_rnsap_id_CFNReportingIndicator = -1;  /* FNReportingIndicator */
static int hf_rnsap_id_CNOriginatedPage_PagingRqst = -1;  /* CNOriginatedPage_PagingRqst */
static int hf_rnsap_id_InnerLoopDLPCStatus = -1;  /* InnerLoopDLPCStatus */
static int hf_rnsap_id_PropagationDelay = -1;     /* PropagationDelay */
static int hf_rnsap_id_RxTimingDeviationForTA = -1;  /* RxTimingDeviationForTA */
static int hf_rnsap_id_timeSlot_ISCP = -1;        /* DL_TimeSlot_ISCP_Info */
static int hf_rnsap_id_CCTrCH_InformationItem_RL_FailureInd = -1;  /* CCTrCH_InformationItem_RL_FailureInd */
static int hf_rnsap_id_CCTrCH_InformationItem_RL_RestoreInd = -1;  /* CCTrCH_InformationItem_RL_RestoreInd */
static int hf_rnsap_id_CommonMeasurementAccuracy = -1;  /* CommonMeasurementAccuracy */
static int hf_rnsap_id_CommonMeasurementObjectType_CM_Rprt = -1;  /* CommonMeasurementObjectType_CM_Rprt */
static int hf_rnsap_id_CommonMeasurementObjectType_CM_Rqst = -1;  /* CommonMeasurementObjectType_CM_Rqst */
static int hf_rnsap_id_CommonMeasurementObjectType_CM_Rsp = -1;  /* CommonMeasurementObjectType_CM_Rsp */
static int hf_rnsap_id_CommonMeasurementType = -1;  /* CommonMeasurementType */
static int hf_rnsap_id_CongestionCause = -1;      /* CongestionCause */
static int hf_rnsap_id_SFN = -1;                  /* SFN */
static int hf_rnsap_id_SFNReportingIndicator = -1;  /* FNReportingIndicator */
static int hf_rnsap_id_InformationExchangeID = -1;  /* InformationExchangeID */
static int hf_rnsap_id_InformationExchangeObjectType_InfEx_Rprt = -1;  /* InformationExchangeObjectType_InfEx_Rprt */
static int hf_rnsap_id_InformationExchangeObjectType_InfEx_Rqst = -1;  /* InformationExchangeObjectType_InfEx_Rqst */
static int hf_rnsap_id_InformationExchangeObjectType_InfEx_Rsp = -1;  /* InformationReportCharacteristics */
static int hf_rnsap_id_InformationReportCharacteristics = -1;  /* InformationReportCharacteristics */
static int hf_rnsap_id_InformationType = -1;      /* InformationType */
static int hf_rnsap_id_neighbouring_LCR_TDD_CellInformation = -1;  /* Neighbouring_LCR_TDD_CellInformation */
static int hf_rnsap_id_DL_Timeslot_ISCP_LCR_Information_RL_SetupRqstTDD = -1;  /* DL_TimeSlot_ISCP_LCR_Information */
static int hf_rnsap_id_RL_LCR_InformationResponse_RL_SetupRspTDD = -1;  /* RL_LCR_InformationResponse_RL_SetupRspTDD */
static int hf_rnsap_id_UL_CCTrCH_LCR_InformationListIE_RL_SetupRspTDD = -1;  /* UL_LCR_CCTrCHInformationListIE_RL_SetupRspTDD */
static int hf_rnsap_id_UL_DPCH_LCR_InformationItem_RL_SetupRspTDD = -1;  /* UL_DPCH_LCR_InformationItem_RL_SetupRspTDD */
static int hf_rnsap_id_DL_CCTrCH_LCR_InformationListIE_RL_SetupRspTDD = -1;  /* DL_CCTrCH_LCR_InformationListIE_RL_SetupRspTDD */
static int hf_rnsap_id_DL_DPCH_LCR_InformationItem_RL_SetupRspTDD = -1;  /* DL_DPCH_LCR_InformationItem_RL_SetupRspTDD */
static int hf_rnsap_id_DSCH_LCR_InformationListIEs_RL_SetupRspTDD = -1;  /* DSCH_LCR_InformationListIEs_RL_SetupRspTDD */
static int hf_rnsap_id_USCH_LCR_InformationListIEs_RL_SetupRspTDD = -1;  /* USCH_LCR_InformationListIEs_RL_SetupRspTDD */
static int hf_rnsap_id_DL_Timeslot_ISCP_LCR_Information_RL_AdditionRqstTDD = -1;  /* DL_TimeSlot_ISCP_LCR_Information */
static int hf_rnsap_id_RL_LCR_InformationResponse_RL_AdditionRspTDD = -1;  /* RL_LCR_InformationResponse_RL_AdditionRspTDD */
static int hf_rnsap_id_UL_CCTrCH_LCR_InformationListIE_RL_AdditionRspTDD = -1;  /* UL_CCTrCH_LCR_InformationListIE_RL_AdditionRspTDD */
static int hf_rnsap_id_UL_DPCH_LCR_InformationItem_RL_AdditionRspTDD = -1;  /* UL_DPCH_LCR_InformationItem_RL_AdditionRspTDD */
static int hf_rnsap_id_DL_CCTrCH_LCR_InformationListIE_RL_AdditionRspTDD = -1;  /* DL_CCTrCH_LCR_InformationListIE_RL_AdditionRspTDD */
static int hf_rnsap_id_DL_DPCH_LCR_InformationItem_RL_AdditionRspTDD = -1;  /* DL_DPCH_LCR_InformationItem_RL_AdditionRspTDD */
static int hf_rnsap_id_DSCH_LCR_InformationListIEs_RL_AdditionRspTDD = -1;  /* DSCH_LCR_InformationListIEs_RL_AdditionRspTDD */
static int hf_rnsap_id_USCH_LCR_InformationListIEs_RL_AdditionRspTDD = -1;  /* USCH_LCR_InformationListIEs_RL_AdditionRspTDD */
static int hf_rnsap_id_UL_DPCH_LCR_InformationAddListIE_RL_ReconfReadyTDD = -1;  /* UL_DPCH_LCR_InformationAddList_RL_ReconfReadyTDD */
static int hf_rnsap_id_UL_Timeslot_LCR_InformationModifyList_RL_ReconfReadyTDD = -1;  /* UL_TimeslotLCR_InformationModifyList_RL_ReconfReadyTDD */
static int hf_rnsap_id_DL_DPCH_LCR_InformationAddListIE_RL_ReconfReadyTDD = -1;  /* DL_DPCH_LCR_InformationAddList_RL_ReconfReadyTDD */
static int hf_rnsap_id_DL_Timeslot_LCR_InformationModifyList_RL_ReconfReadyTDD = -1;  /* DL_TimeslotLCR_InformationModifyList_RL_ReconfReadyTDD */
static int hf_rnsap_id_UL_Timeslot_LCR_InformationList_PhyChReconfRqstTDD = -1;  /* UL_TimeslotLCR_InformationList_PhyChReconfRqstTDD */
static int hf_rnsap_id_DL_Timeslot_LCR_InformationList_PhyChReconfRqstTDD = -1;  /* DL_TimeslotLCR_InformationList_PhyChReconfRqstTDD */
static int hf_rnsap_id_timeSlot_ISCP_LCR_List_DL_PC_Rqst_TDD = -1;  /* DL_TimeSlot_ISCP_LCR_Information */
static int hf_rnsap_id_TSTD_Support_Indicator_RL_SetupRqstTDD = -1;  /* TSTD_Support_Indicator */
static int hf_rnsap_id_RestrictionStateIndicator = -1;  /* RestrictionStateIndicator */
static int hf_rnsap_id_Load_Value = -1;           /* Load_Value */
static int hf_rnsap_id_Load_Value_IncrDecrThres = -1;  /* Load_Value_IncrDecrThres */
static int hf_rnsap_id_OnModification = -1;       /* OnModification */
static int hf_rnsap_id_Received_Total_Wideband_Power_Value = -1;  /* Received_Total_Wideband_Power_Value */
static int hf_rnsap_id_Received_Total_Wideband_Power_Value_IncrDecrThres = -1;  /* SFNSFNMeasurementThresholdInformation */
static int hf_rnsap_id_SFNSFNMeasurementThresholdInformation = -1;  /* SFNSFNMeasurementThresholdInformation */
static int hf_rnsap_id_Transmitted_Carrier_Power_Value = -1;  /* Transmitted_Carrier_Power_Value */
static int hf_rnsap_id_Transmitted_Carrier_Power_Value_IncrDecrThres = -1;  /* Transmitted_Carrier_Power_Value_IncrDecrThres */
static int hf_rnsap_id_TUTRANGPSMeasurementThresholdInformation = -1;  /* UL_Timeslot_ISCP_Value */
static int hf_rnsap_id_UL_Timeslot_ISCP_Value = -1;  /* UL_Timeslot_ISCP_Value */
static int hf_rnsap_id_UL_Timeslot_ISCP_Value_IncrDecrThres = -1;  /* UL_Timeslot_ISCP_Value_IncrDecrThres */
static int hf_rnsap_id_Rx_Timing_Deviation_Value_LCR = -1;  /* Rx_Timing_Deviation_Value_LCR */
static int hf_rnsap_id_DPC_Mode_Change_SupportIndicator = -1;  /* DPC_Mode_Change_SupportIndicator */
static int hf_rnsap_id_PrimaryCCPCH_RSCP_RL_ReconfPrepTDD = -1;  /* PrimaryCCPCH_RSCP */
static int hf_rnsap_id_DL_TimeSlot_ISCP_Info_RL_ReconfPrepTDD = -1;  /* DL_TimeSlot_ISCP_Info */
static int hf_rnsap_id_DL_Timeslot_ISCP_LCR_Information_RL_ReconfPrepTDD = -1;  /* DL_TimeSlot_ISCP_LCR_Information */
static int hf_rnsap_id_DSCH_RNTI = -1;            /* DSCH_RNTI */
static int hf_rnsap_id_DL_PowerBalancing_Information = -1;  /* DL_PowerBalancing_Information */
static int hf_rnsap_id_DL_PowerBalancing_ActivationIndicator = -1;  /* DL_PowerBalancing_ActivationIndicator */
static int hf_rnsap_id_DL_PowerBalancing_UpdatedIndicator = -1;  /* DL_PowerBalancing_UpdatedIndicator */
static int hf_rnsap_id_DL_ReferencePowerInformation = -1;  /* DL_ReferencePowerInformation */
static int hf_rnsap_id_Enhanced_PrimaryCPICH_EcNo = -1;  /* Enhanced_PrimaryCPICH_EcNo */
static int hf_rnsap_id_IPDL_TDD_ParametersLCR = -1;  /* IPDL_TDD_ParametersLCR */
static int hf_rnsap_id_CellCapabilityContainer_FDD = -1;  /* CellCapabilityContainer_FDD */
static int hf_rnsap_id_CellCapabilityContainer_TDD = -1;  /* CellCapabilityContainer_TDD */
static int hf_rnsap_id_CellCapabilityContainer_TDD_LCR = -1;  /* CellCapabilityContainer_TDD_LCR */
static int hf_rnsap_id_RL_Specific_DCH_Info = -1;  /* RL_Specific_DCH_Info */
static int hf_rnsap_id_RL_ReconfigurationRequestFDD_RL_InformationList = -1;  /* RL_ReconfigurationRequestFDD_RL_InformationList */
static int hf_rnsap_id_RL_ReconfigurationRequestFDD_RL_Information_IEs = -1;  /* RL_ReconfigurationRequestFDD_RL_Information_IEs */
static int hf_rnsap_id_RL_ReconfigurationRequestTDD_RL_Information = -1;  /* RL_ReconfigurationRequestTDD_RL_Information */
static int hf_rnsap_id_CommonTransportChannelResourcesInitialisationNotRequired = -1;  /* CommonTransportChannelResourcesInitialisationNotRequired */
static int hf_rnsap_id_DelayedActivation = -1;    /* DelayedActivation */
static int hf_rnsap_id_DelayedActivationList_RL_ActivationCmdFDD = -1;  /* DelayedActivationInformationList_RL_ActivationCmdFDD */
static int hf_rnsap_id_DelayedActivationInformation_RL_ActivationCmdFDD = -1;  /* DelayedActivationInformation_RL_ActivationCmdFDD */
static int hf_rnsap_id_DelayedActivationList_RL_ActivationCmdTDD = -1;  /* DelayedActivationInformationList_RL_ActivationCmdTDD */
static int hf_rnsap_id_DelayedActivationInformation_RL_ActivationCmdTDD = -1;  /* DelayedActivationInformation_RL_ActivationCmdTDD */
static int hf_rnsap_id_neighbouringTDDCellMeasurementInformationLCR = -1;  /* NeighbouringTDDCellMeasurementInformationLCR */
static int hf_rnsap_id_UL_SIR_Target_CCTrCH_InformationItem_RL_SetupRspTDD = -1;  /* UL_SIR */
static int hf_rnsap_id_UL_SIR_Target_CCTrCH_LCR_InformationItem_RL_SetupRspTDD = -1;  /* UL_SIR */
static int hf_rnsap_id_PrimCCPCH_RSCP_DL_PC_RqstTDD = -1;  /* PrimaryCCPCH_RSCP */
static int hf_rnsap_id_HSDSCH_FDD_Information = -1;  /* HSDSCH_FDD_Information */
static int hf_rnsap_id_HSDSCH_FDD_Information_Response = -1;  /* HSDSCH_FDD_Information_Response */
static int hf_rnsap_id_HSDSCH_FDD_Update_Information = -1;  /* HSDSCH_FDD_Update_Information */
static int hf_rnsap_id_HSDSCH_Information_to_Modify = -1;  /* HSDSCH_Information_to_Modify */
static int hf_rnsap_id_HSDSCHMacdFlowSpecificInformationList_RL_PreemptRequiredInd = -1;  /* HSDSCHMacdFlowSpecificInformationList_RL_PreemptRequiredInd */
static int hf_rnsap_id_HSDSCHMacdFlowSpecificInformationItem_RL_PreemptRequiredInd = -1;  /* HSDSCHMacdFlowSpecificInformationItem_RL_PreemptRequiredInd */
static int hf_rnsap_id_HSDSCH_RNTI = -1;          /* HSDSCH_RNTI */
static int hf_rnsap_id_HSDSCH_TDD_Information = -1;  /* HSDSCH_TDD_Information */
static int hf_rnsap_id_HSDSCH_TDD_Information_Response = -1;  /* HSDSCH_TDD_Information_Response */
static int hf_rnsap_id_HSDSCH_TDD_Update_Information = -1;  /* HSDSCH_TDD_Update_Information */
static int hf_rnsap_id_HSPDSCH_RL_ID = -1;        /* RL_ID */
static int hf_rnsap_id_HSDSCH_MACdFlows_to_Add = -1;  /* HSDSCH_MACdFlows_Information */
static int hf_rnsap_id_HSDSCH_MACdFlows_to_Delete = -1;  /* HSDSCH_MACdFlows_to_Delete */
static int hf_rnsap_id_Angle_Of_Arrival_Value_LCR = -1;  /* Angle_Of_Arrival_Value_LCR */
static int hf_rnsap_id_TrafficClass = -1;         /* TrafficClass */
static int hf_rnsap_id_PDSCH_RL_ID = -1;          /* RL_ID */
static int hf_rnsap_id_TimeSlot_RL_SetupRspTDD = -1;  /* TimeSlot */
static int hf_rnsap_id_GERAN_Cell_Capability = -1;  /* GERAN_Cell_Capability */
static int hf_rnsap_id_GERAN_Classmark = -1;      /* GERAN_Classmark */
static int hf_rnsap_id_DSCH_InitialWindowSize = -1;  /* DSCH_InitialWindowSize */
static int hf_rnsap_id_UL_Synchronisation_Parameters_LCR = -1;  /* UL_Synchronisation_Parameters_LCR */
static int hf_rnsap_id_SNA_Information = -1;      /* SNA_Information */
static int hf_rnsap_id_MAChs_ResetIndicator = -1;  /* MAChs_ResetIndicator */
static int hf_rnsap_id_TDD_DL_DPCH_TimeSlotFormatModifyItem_LCR_RL_ReconfReadyTDD = -1;  /* TDD_DL_DPCH_TimeSlotFormat_LCR */
static int hf_rnsap_id_TDD_UL_DPCH_TimeSlotFormatModifyItem_LCR_RL_ReconfReadyTDD = -1;  /* TDD_UL_DPCH_TimeSlotFormat_LCR */
static int hf_rnsap_id_TDD_TPC_UplinkStepSize_LCR_RL_SetupRqstTDD = -1;  /* TDD_TPC_UplinkStepSize_LCR */
static int hf_rnsap_id_UL_CCTrCH_InformationList_RL_AdditionRqstTDD = -1;  /* UL_CCTrCH_InformationList_RL_AdditionRqstTDD */
static int hf_rnsap_id_UL_CCTrCH_InformationItem_RL_AdditionRqstTDD = -1;  /* UL_CCTrCH_InformationItem_RL_AdditionRqstTDD */
static int hf_rnsap_id_DL_CCTrCH_InformationList_RL_AdditionRqstTDD = -1;  /* DL_CCTrCH_InformationList_RL_AdditionRqstTDD */
static int hf_rnsap_id_DL_CCTrCH_InformationItem_RL_AdditionRqstTDD = -1;  /* DL_CCTrCH_InformationItem_RL_AdditionRqstTDD */
static int hf_rnsap_id_TDD_TPC_UplinkStepSize_InformationAdd_LCR_RL_ReconfPrepTDD = -1;  /* TDD_TPC_UplinkStepSize_LCR */
static int hf_rnsap_id_TDD_TPC_UplinkStepSize_InformationModify_LCR_RL_ReconfPrepTDD = -1;  /* TDD_TPC_UplinkStepSize_LCR */
static int hf_rnsap_id_TDD_TPC_DownlinkStepSize_InformationAdd_RL_ReconfPrepTDD = -1;  /* TDD_TPC_DownlinkStepSize */
static int hf_rnsap_id_TDD_TPC_DownlinkStepSize_InformationModify_RL_ReconfPrepTDD = -1;  /* TDD_TPC_DownlinkStepSize */
static int hf_rnsap_id_UL_TimingAdvanceCtrl_LCR = -1;  /* UL_TimingAdvanceCtrl_LCR */
static int hf_rnsap_id_HSPDSCH_Timeslot_InformationList_PhyChReconfRqstTDD = -1;  /* HSPDSCH_Timeslot_InformationList_PhyChReconfRqstTDD */
static int hf_rnsap_id_HSPDSCH_Timeslot_InformationListLCR_PhyChReconfRqstTDD = -1;  /* HSPDSCH_Timeslot_InformationListLCR_PhyChReconfRqstTDD */
static int hf_rnsap_id_HS_SICH_Reception_Quality = -1;  /* HS_SICH_Reception_Quality_Value */
static int hf_rnsap_id_HS_SICH_Reception_Quality_Measurement_Value = -1;  /* HS_SICH_Reception_Quality_Measurement_Value */
static int hf_rnsap_id_HSSICH_Info_DM_Rprt = -1;  /* HS_SICH_ID */
static int hf_rnsap_id_HSSICH_Info_DM_Rqst = -1;  /* HSSICH_Info_DM_Rqst */
static int hf_rnsap_id_HSSICH_Info_DM = -1;       /* HS_SICH_ID */
static int hf_rnsap_id_CCTrCH_Maximum_DL_Power_RL_SetupRspTDD = -1;  /* DL_Power */
static int hf_rnsap_id_CCTrCH_Minimum_DL_Power_RL_SetupRspTDD = -1;  /* DL_Power */
static int hf_rnsap_id_CCTrCH_Maximum_DL_Power_RL_AdditionRspTDD = -1;  /* DL_Power */
static int hf_rnsap_id_CCTrCH_Minimum_DL_Power_RL_AdditionRspTDD = -1;  /* DL_Power */
static int hf_rnsap_id_CCTrCH_Maximum_DL_Power_RL_ReconfReadyTDD = -1;  /* DL_Power */
static int hf_rnsap_id_CCTrCH_Minimum_DL_Power_RL_ReconfReadyTDD = -1;  /* DL_Power */
static int hf_rnsap_id_Maximum_DL_Power_TimeslotLCR_InformationModifyItem_RL_ReconfReadyTDD = -1;  /* DL_Power */
static int hf_rnsap_id_Minimum_DL_Power_TimeslotLCR_InformationModifyItem_RL_ReconfReadyTDD = -1;  /* DL_Power */
static int hf_rnsap_id_DL_CCTrCH_InformationList_RL_ReconfRspTDD = -1;  /* DL_CCTrCH_InformationList_RL_ReconfRspTDD */
static int hf_rnsap_id_DL_DPCH_InformationModifyItem_LCR_RL_ReconfRspTDD = -1;  /* DL_DPCH_InformationModifyItem_LCR_RL_ReconfRspTDD */
static int hf_rnsap_id_Maximum_DL_Power_TimeslotLCR_InformationItem = -1;  /* DL_Power */
static int hf_rnsap_id_Minimum_DL_Power_TimeslotLCR_InformationItem = -1;  /* DL_Power */
static int hf_rnsap_id_TDD_Support_8PSK = -1;     /* Support_8PSK */
static int hf_rnsap_id_TDD_maxNrDLPhysicalchannels = -1;  /* MaxNrDLPhysicalchannelsTS */
static int hf_rnsap_id_ExtendedGSMCellIndividualOffset = -1;  /* ExtendedGSMCellIndividualOffset */
static int hf_rnsap_id_RL_ParameterUpdateIndicationFDD_RL_InformationList = -1;  /* RL_ParameterUpdateIndicationFDD_RL_InformationList */
static int hf_rnsap_id_Primary_CPICH_Usage_For_Channel_Estimation = -1;  /* Primary_CPICH_Usage_For_Channel_Estimation */
static int hf_rnsap_id_Secondary_CPICH_Information = -1;  /* Secondary_CPICH_Information */
static int hf_rnsap_id_Secondary_CPICH_Information_Change = -1;  /* Secondary_CPICH_Information_Change */
static int hf_rnsap_id_RL_ParameterUpdateIndicationFDD_RL_Information_Item = -1;  /* RL_ParameterUpdateIndicationFDD_RL_Information_Item */
static int hf_rnsap_id_Phase_Reference_Update_Indicator = -1;  /* Phase_Reference_Update_Indicator */
static int hf_rnsap_id_Unidirectional_DCH_Indicator = -1;  /* Unidirectional_DCH_Indicator */
static int hf_rnsap_id_RL_Information_RL_ReconfPrepTDD = -1;  /* RL_Information_RL_ReconfPrepTDD */
static int hf_rnsap_id_Multiple_RL_InformationResponse_RL_ReconfReadyTDD = -1;  /* Multiple_RL_InformationResponse_RL_ReconfReadyTDD */
static int hf_rnsap_id_RL_ReconfigurationResponseTDD_RL_Information = -1;  /* Multiple_RL_InformationResponse_RL_ReconfRspTDD */
static int hf_rnsap_id_Satellite_Almanac_Information_ExtItem = -1;  /* Satellite_Almanac_Information_ExtItem */
static int hf_rnsap_id_HSDSCH_Information_to_Modify_Unsynchronised = -1;  /* HSDSCH_Information_to_Modify_Unsynchronised */
static int hf_rnsap_id_TnlQos = -1;               /* TnlQos */
static int hf_rnsap_id_RTLoadValue = -1;          /* RTLoadValue */
static int hf_rnsap_id_NRTLoadInformationValue = -1;  /* NRTLoadInformationValue */
static int hf_rnsap_id_CellPortionID = -1;        /* CellPortionID */
static int hf_rnsap_id_UpPTSInterferenceValue = -1;  /* UpPTSInterferenceValue */
static int hf_rnsap_id_PrimaryCCPCH_RSCP_Delta = -1;  /* PrimaryCCPCH_RSCP_Delta */
static int hf_rnsap_id_UEMeasurementType = -1;    /* UEMeasurementType */
static int hf_rnsap_id_UEMeasurementTimeslotInfoHCR = -1;  /* UEMeasurementTimeslotInfoHCR */
static int hf_rnsap_id_UEMeasurementTimeslotInfoLCR = -1;  /* UEMeasurementTimeslotInfoLCR */
static int hf_rnsap_id_UEMeasurementReportCharacteristics = -1;  /* UEMeasurementReportCharacteristics */
static int hf_rnsap_id_UEMeasurementParameterModAllow = -1;  /* UEMeasurementParameterModAllow */
static int hf_rnsap_id_UEMeasurementValueInformation = -1;  /* UEMeasurementValueInformation */
static int hf_rnsap_id_InterfacesToTraceItem = -1;  /* InterfacesToTraceItem */
static int hf_rnsap_id_ListOfInterfacesToTrace = -1;  /* ListOfInterfacesToTrace */
static int hf_rnsap_id_TraceDepth = -1;           /* TraceDepth */
static int hf_rnsap_id_TraceRecordingSessionReference = -1;  /* TraceRecordingSessionReference */
static int hf_rnsap_id_TraceReference = -1;       /* TraceReference */
static int hf_rnsap_id_UEIdentity = -1;           /* UEIdentity */
static int hf_rnsap_id_NACC_Related_Data = -1;    /* NACC_Related_Data */
static int hf_rnsap_id_GSM_Cell_InfEx_Rqst = -1;  /* GSM_Cell_InfEx_Rqst */
static int hf_rnsap_id_MeasurementRecoveryBehavior = -1;  /* MeasurementRecoveryBehavior */
static int hf_rnsap_id_MeasurementRecoveryReportingIndicator = -1;  /* MeasurementRecoveryReportingIndicator */
static int hf_rnsap_id_MeasurementRecoverySupportIndicator = -1;  /* MeasurementRecoverySupportIndicator */
static int hf_rnsap_id_DL_DPCH_Power_Information_RL_ReconfPrepFDD = -1;  /* DL_DPCH_Power_Information_RL_ReconfPrepFDD */
static int hf_rnsap_id_F_DPCH_Information_RL_ReconfPrepFDD = -1;  /* F_DPCH_Information_RL_ReconfPrepFDD */
static int hf_rnsap_id_F_DPCH_Information_RL_SetupRqstFDD = -1;  /* F_DPCH_Information_RL_SetupRqstFDD */
static int hf_rnsap_id_MBMS_Bearer_Service_List = -1;  /* MBMS_Bearer_Service_List */
static int hf_rnsap_id_MBMS_Bearer_Service_List_InfEx_Rsp = -1;  /* MBMS_Bearer_Service_List_InfEx_Rsp */
static int hf_rnsap_id_Active_MBMS_Bearer_ServiceFDD = -1;  /* Active_MBMS_Bearer_Service_ListFDD */
static int hf_rnsap_id_Active_MBMS_Bearer_ServiceTDD = -1;  /* Active_MBMS_Bearer_Service_ListTDD */
static int hf_rnsap_id_Old_URA_ID = -1;           /* URA_ID */
static int hf_rnsap_id_UE_State = -1;             /* UE_State */
static int hf_rnsap_id_URA_ID = -1;               /* URA_ID */
static int hf_rnsap_id_HARQ_Preamble_Mode = -1;   /* HARQ_Preamble_Mode */
static int hf_rnsap_id_SynchronisationIndicator = -1;  /* SynchronisationIndicator */
static int hf_rnsap_id_UL_DPDCHIndicatorEDCH = -1;  /* UL_DPDCHIndicatorEDCH */
static int hf_rnsap_id_EDPCH_Information = -1;    /* EDPCH_Information_FDD */
static int hf_rnsap_id_RL_Specific_EDCH_Information = -1;  /* RL_Specific_EDCH_Information */
static int hf_rnsap_id_EDCH_RL_Indication = -1;   /* EDCH_RL_Indication */
static int hf_rnsap_id_EDCH_FDD_Information = -1;  /* EDCH_FDD_Information */
static int hf_rnsap_id_EDCH_RLSet_Id = -1;        /* RL_Set_ID */
static int hf_rnsap_id_Serving_EDCHRL_Id = -1;    /* EDCH_Serving_RL */
static int hf_rnsap_id_EDCH_FDD_DL_ControlChannelInformation = -1;  /* EDCH_FDD_DL_ControlChannelInformation */
static int hf_rnsap_id_EDCH_FDD_InformationResponse = -1;  /* EDCH_FDD_InformationResponse */
static int hf_rnsap_id_EDCH_MACdFlows_To_Add = -1;  /* RL_Specific_EDCH_Information */
static int hf_rnsap_id_EDCH_FDD_Information_To_Modify = -1;  /* EDCH_FDD_Information_To_Modify */
static int hf_rnsap_id_EDCH_MACdFlows_To_Delete = -1;  /* EDCH_MACdFlows_To_Delete */
static int hf_rnsap_id_EDPCH_Information_RLReconfRequest_FDD = -1;  /* EDPCH_Information_RLReconfRequest_FDD */
static int hf_rnsap_id_EDCH_MacdFlowSpecificInformationList_RL_PreemptRequiredInd = -1;  /* EDCH_MacdFlowSpecificInformationList_RL_PreemptRequiredInd */
static int hf_rnsap_id_EDCH_MacdFlowSpecificInformationItem_RL_PreemptRequiredInd = -1;  /* EDCH_MacdFlowSpecificInformationItem_RL_PreemptRequiredInd */
static int hf_rnsap_id_EDCH_MacdFlowSpecificInformationList_RL_CongestInd = -1;  /* EDCH_MacdFlowSpecificInformationList_RL_CongestInd */
static int hf_rnsap_id_EDCH_MacdFlowSpecificInformationItem_RL_CongestInd = -1;  /* EDCH_MacdFlowSpecificInformationItem_RL_CongestInd */
static int hf_rnsap_id_MBMS_Bearer_Service_Full_Address = -1;  /* MBMS_Bearer_Service_Full_Address */
static int hf_rnsap_id_Initial_DL_DPCH_TimingAdjustment = -1;  /* DL_DPCH_TimingAdjustment */
static int hf_rnsap_id_Initial_DL_DPCH_TimingAdjustment_Allowed = -1;  /* Initial_DL_DPCH_TimingAdjustment_Allowed */
static int hf_rnsap_id_User_Plane_Congestion_Fields_Inclusion = -1;  /* User_Plane_Congestion_Fields_Inclusion */
static int hf_rnsap_id_HARQ_Preamble_Mode_Activation_Indicator = -1;  /* HARQ_Preamble_Mode_Activation_Indicator */
static int hf_rnsap_id_multiple_DedicatedMeasurementValueList_TDD_DM_Rsp = -1;  /* Multiple_DedicatedMeasurementValueList_TDD_DM_Rsp */
static int hf_rnsap_id_multiple_DedicatedMeasurementValueList_LCR_TDD_DM_Rsp = -1;  /* Multiple_DedicatedMeasurementValueList_LCR_TDD_DM_Rsp */
static int hf_rnsap_id_ProvidedInformation = -1;  /* ProvidedInformation */
static int hf_rnsap_id_Active_MBMS_Bearer_ServiceFDD_PFL = -1;  /* Active_MBMS_Bearer_Service_ListTDD_PFL */
static int hf_rnsap_id_Active_MBMS_Bearer_ServiceTDD_PFL = -1;  /* Active_MBMS_Bearer_Service_ListTDD_PFL */
static int hf_rnsap_id_FrequencyBandIndicator = -1;  /* FrequencyBandIndicator */
static int hf_rnsap_protocolIEs = -1;             /* ProtocolIE_Container */
static int hf_rnsap_protocolExtensions = -1;      /* ProtocolExtensionContainer */
static int hf_rnsap_ul_ScramblingCode = -1;       /* UL_ScramblingCode */
static int hf_rnsap_minUL_ChannelisationCodeLength = -1;  /* MinUL_ChannelisationCodeLength */
static int hf_rnsap_maxNrOfUL_DPCHs = -1;         /* MaxNrOfUL_DPCHs */
static int hf_rnsap_ul_PunctureLimit = -1;        /* PunctureLimit */
static int hf_rnsap_ul_TFCS = -1;                 /* TFCS */
static int hf_rnsap_ul_DPCCH_SlotFormat = -1;     /* UL_DPCCH_SlotFormat */
static int hf_rnsap_ul_SIRTarget = -1;            /* UL_SIR */
static int hf_rnsap_diversityMode = -1;           /* DiversityMode */
static int hf_rnsap_not_Used_sSDT_CellIdLength = -1;  /* NULL */
static int hf_rnsap_not_Used_s_FieldLength = -1;  /* NULL */
static int hf_rnsap_iE_Extensions = -1;           /* ProtocolExtensionContainer */
static int hf_rnsap_tFCS = -1;                    /* TFCS */
static int hf_rnsap_dl_DPCH_SlotFormat = -1;      /* DL_DPCH_SlotFormat */
static int hf_rnsap_nrOfDLchannelisationcodes = -1;  /* NrOfDLchannelisationcodes */
static int hf_rnsap_tFCI_SignallingMode = -1;     /* TFCI_SignallingMode */
static int hf_rnsap_tFCI_Presence = -1;           /* TFCI_Presence */
static int hf_rnsap_multiplexingPosition = -1;    /* MultiplexingPosition */
static int hf_rnsap_powerOffsetInformation = -1;  /* PowerOffsetInformation_RL_SetupRqstFDD */
static int hf_rnsap_fdd_dl_TPC_DownlinkStepSize = -1;  /* FDD_TPC_DownlinkStepSize */
static int hf_rnsap_limitedPowerIncrease = -1;    /* LimitedPowerIncrease */
static int hf_rnsap_innerLoopDLPCStatus = -1;     /* InnerLoopDLPCStatus */
static int hf_rnsap_po1_ForTFCI_Bits = -1;        /* PowerOffset */
static int hf_rnsap_po2_ForTPC_Bits = -1;         /* PowerOffset */
static int hf_rnsap_po3_ForPilotBits = -1;        /* PowerOffset */
static int hf_rnsap_RL_InformationList_RL_SetupRqstFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_rL_ID = -1;                   /* RL_ID */
static int hf_rnsap_c_ID = -1;                    /* C_ID */
static int hf_rnsap_firstRLS_indicator = -1;      /* FirstRLS_Indicator */
static int hf_rnsap_frameOffset = -1;             /* FrameOffset */
static int hf_rnsap_chipOffset = -1;              /* ChipOffset */
static int hf_rnsap_propagationDelay = -1;        /* PropagationDelay */
static int hf_rnsap_diversityControlField = -1;   /* DiversityControlField */
static int hf_rnsap_dl_InitialTX_Power = -1;      /* DL_Power */
static int hf_rnsap_primaryCPICH_EcNo = -1;       /* PrimaryCPICH_EcNo */
static int hf_rnsap_not_Used_sSDT_CellID = -1;    /* NULL */
static int hf_rnsap_transmitDiversityIndicator = -1;  /* TransmitDiversityIndicator */
static int hf_rnsap_powerOffsetInformation1 = -1;  /* PowerOffsetInformation_F_DPCH_RL_SetupRqstFDD */
static int hf_rnsap_maxNrTimeslots_UL = -1;       /* MaxNrTimeslots */
static int hf_rnsap_minimumSpreadingFactor_UL = -1;  /* MinimumSpreadingFactor */
static int hf_rnsap_maxNrULPhysicalchannels = -1;  /* MaxNrULPhysicalchannels */
static int hf_rnsap_maxNrTimeslots_DL = -1;       /* MaxNrTimeslots */
static int hf_rnsap_minimumSpreadingFactor_DL = -1;  /* MinimumSpreadingFactor */
static int hf_rnsap_maxNrDLPhysicalchannels = -1;  /* MaxNrDLPhysicalchannels */
static int hf_rnsap_UL_CCTrCH_InformationList_RL_SetupRqstTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_cCTrCH_ID = -1;               /* CCTrCH_ID */
static int hf_rnsap_tFCI_Coding = -1;             /* TFCI_Coding */
static int hf_rnsap_DL_CCTrCH_InformationList_RL_SetupRqstTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_dl_TFCS = -1;                 /* TFCS */
static int hf_rnsap_dl_PunctureLimit = -1;        /* PunctureLimit */
static int hf_rnsap_tdd_TPC_DownlinkStepSize = -1;  /* TDD_TPC_DownlinkStepSize */
static int hf_rnsap_cCTrCH_TPCList = -1;          /* CCTrCH_TPCList_RL_SetupRqstTDD */
static int hf_rnsap_CCTrCH_TPCList_RL_SetupRqstTDD_item = -1;  /* CCTrCH_TPCItem_RL_SetupRqstTDD */
static int hf_rnsap_specialBurstScheduling = -1;  /* SpecialBurstScheduling */
static int hf_rnsap_primaryCCPCH_RSCP = -1;       /* PrimaryCCPCH_RSCP */
static int hf_rnsap_dL_TimeSlot_ISCP = -1;        /* DL_TimeSlot_ISCP_Info */
static int hf_rnsap_RL_InformationResponseList_RL_SetupRspFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_rL_Set_ID = -1;               /* RL_Set_ID */
static int hf_rnsap_uRA_Information = -1;         /* URA_Information */
static int hf_rnsap_sAI = -1;                     /* SAI */
static int hf_rnsap_gA_Cell = -1;                 /* GA_Cell */
static int hf_rnsap_gA_AccessPointPosition = -1;  /* GA_AccessPointPosition */
static int hf_rnsap_received_total_wide_band_power = -1;  /* Received_total_wide_band_power */
static int hf_rnsap_not_Used_secondary_CCPCH_Info = -1;  /* NULL */
static int hf_rnsap_dl_CodeInformation = -1;      /* FDD_DL_CodeInformation */
static int hf_rnsap_diversityIndication = -1;     /* DiversityIndication_RL_SetupRspFDD */
static int hf_rnsap_sSDT_SupportIndicator = -1;   /* SSDT_SupportIndicator */
static int hf_rnsap_maxUL_SIR = -1;               /* UL_SIR */
static int hf_rnsap_minUL_SIR = -1;               /* UL_SIR */
static int hf_rnsap_closedlooptimingadjustmentmode = -1;  /* Closedlooptimingadjustmentmode */
static int hf_rnsap_maximumAllowedULTxPower = -1;  /* MaximumAllowedULTxPower */
static int hf_rnsap_maximumDLTxPower = -1;        /* DL_Power */
static int hf_rnsap_minimumDLTxPower = -1;        /* DL_Power */
static int hf_rnsap_primaryScramblingCode = -1;   /* PrimaryScramblingCode */
static int hf_rnsap_uL_UARFCN = -1;               /* UARFCN */
static int hf_rnsap_dL_UARFCN = -1;               /* UARFCN */
static int hf_rnsap_primaryCPICH_Power = -1;      /* PrimaryCPICH_Power */
static int hf_rnsap_not_Used_dSCHInformationResponse = -1;  /* NULL */
static int hf_rnsap_neighbouring_UMTS_CellInformation = -1;  /* Neighbouring_UMTS_CellInformation */
static int hf_rnsap_neighbouring_GSM_CellInformation = -1;  /* Neighbouring_GSM_CellInformation */
static int hf_rnsap_pC_Preamble = -1;             /* PC_Preamble */
static int hf_rnsap_sRB_Delay = -1;               /* SRB_Delay */
static int hf_rnsap_combining = -1;               /* Combining_RL_SetupRspFDD */
static int hf_rnsap_nonCombiningOrFirstRL = -1;   /* NonCombiningOrFirstRL_RL_SetupRspFDD */
static int hf_rnsap_dCH_InformationResponse = -1;  /* DCH_InformationResponse */
static int hf_rnsap_ul_TimeSlot_ISCP_Info = -1;   /* UL_TimeSlot_ISCP_Info */
static int hf_rnsap_uARFCNforNt = -1;             /* UARFCN */
static int hf_rnsap_cellParameterID = -1;         /* CellParameterID */
static int hf_rnsap_syncCase = -1;                /* SyncCase */
static int hf_rnsap_sCH_TimeSlot = -1;            /* SCH_TimeSlot */
static int hf_rnsap_sCTD_Indicator = -1;          /* SCTD_Indicator */
static int hf_rnsap_pCCPCH_Power = -1;            /* PCCPCH_Power */
static int hf_rnsap_timingAdvanceApplied = -1;    /* TimingAdvanceApplied */
static int hf_rnsap_alphaValue = -1;              /* AlphaValue */
static int hf_rnsap_ul_PhysCH_SF_Variation = -1;  /* UL_PhysCH_SF_Variation */
static int hf_rnsap_synchronisationConfiguration = -1;  /* SynchronisationConfiguration */
static int hf_rnsap_secondary_CCPCH_Info_TDD = -1;  /* Secondary_CCPCH_Info_TDD */
static int hf_rnsap_ul_CCTrCHInformation = -1;    /* UL_CCTrCHInformationList_RL_SetupRspTDD */
static int hf_rnsap_dl_CCTrCHInformation = -1;    /* DL_CCTrCHInformationList_RL_SetupRspTDD */
static int hf_rnsap_dCH_InformationResponse1 = -1;  /* DCH_InformationResponseList_RL_SetupRspTDD */
static int hf_rnsap_dsch_InformationResponse = -1;  /* DSCH_InformationResponse_RL_SetupRspTDD */
static int hf_rnsap_usch_InformationResponse = -1;  /* USCH_InformationResponse_RL_SetupRspTDD */
static int hf_rnsap_UL_CCTrCHInformationListIE_RL_SetupRspTDD_item = -1;  /* UL_CCTrCHInformationItem_RL_SetupRspTDD */
static int hf_rnsap_ul_DPCH_Information = -1;     /* UL_DPCH_InformationList_RL_SetupRspTDD */
static int hf_rnsap_repetitionPeriod = -1;        /* RepetitionPeriod */
static int hf_rnsap_repetitionLength = -1;        /* RepetitionLength */
static int hf_rnsap_tDD_DPCHOffset = -1;          /* TDD_DPCHOffset */
static int hf_rnsap_uL_Timeslot_Information = -1;  /* UL_Timeslot_Information */
static int hf_rnsap_DL_CCTrCHInformationListIE_RL_SetupRspTDD_item = -1;  /* DL_CCTrCHInformationItem_RL_SetupRspTDD */
static int hf_rnsap_dl_DPCH_Information = -1;     /* DL_DPCH_InformationList_RL_SetupRspTDD */
static int hf_rnsap_dL_Timeslot_Information = -1;  /* DL_Timeslot_Information */
static int hf_rnsap_DSCH_InformationListIEs_RL_SetupRspTDD_item = -1;  /* DSCHInformationItem_RL_SetupRspTDD */
static int hf_rnsap_dsch_ID = -1;                 /* DSCH_ID */
static int hf_rnsap_dSCH_FlowControlInformation = -1;  /* DSCH_FlowControlInformation */
static int hf_rnsap_bindingID = -1;               /* BindingID */
static int hf_rnsap_transportLayerAddress = -1;   /* TransportLayerAddress */
static int hf_rnsap_transportFormatManagement = -1;  /* TransportFormatManagement */
static int hf_rnsap_USCH_InformationListIEs_RL_SetupRspTDD_item = -1;  /* USCHInformationItem_RL_SetupRspTDD */
static int hf_rnsap_usch_ID = -1;                 /* USCH_ID */
static int hf_rnsap_ul_TimeSlot_ISCP_LCR_Info = -1;  /* UL_TimeSlot_ISCP_LCR_Info */
static int hf_rnsap_secondary_LCR_CCPCH_Info_TDD = -1;  /* Secondary_LCR_CCPCH_Info_TDD */
static int hf_rnsap_ul_LCR_CCTrCHInformation = -1;  /* UL_LCR_CCTrCHInformationList_RL_SetupRspTDD */
static int hf_rnsap_dl_LCR_CCTrCHInformation = -1;  /* DL_LCR_CCTrCHInformationList_RL_SetupRspTDD */
static int hf_rnsap_dsch_LCR_InformationResponse = -1;  /* DSCH_LCR_InformationResponse_RL_SetupRspTDD */
static int hf_rnsap_usch_LCR_InformationResponse = -1;  /* USCH_LCR_InformationResponse_RL_SetupRspTDD */
static int hf_rnsap_UL_LCR_CCTrCHInformationListIE_RL_SetupRspTDD_item = -1;  /* UL_LCR_CCTrCHInformationItem_RL_SetupRspTDD */
static int hf_rnsap_ul_DPCH_LCR_Information = -1;  /* UL_DPCH_LCR_InformationList_RL_SetupRspTDD */
static int hf_rnsap_uL_TimeslotLCR_Information = -1;  /* UL_TimeslotLCR_Information */
static int hf_rnsap_DL_CCTrCH_LCR_InformationListIE_RL_SetupRspTDD_item = -1;  /* DL_CCTrCH_LCR_InformationItem_RL_SetupRspTDD */
static int hf_rnsap_dl_DPCH_LCR_Information = -1;  /* DL_DPCH_LCR_InformationList_RL_SetupRspTDD */
static int hf_rnsap_dL_Timeslot_LCR_Information = -1;  /* DL_TimeslotLCR_Information */
static int hf_rnsap_tSTD_Indicator = -1;          /* TSTD_Indicator */
static int hf_rnsap_DSCH_LCR_InformationListIEs_RL_SetupRspTDD_item = -1;  /* DSCH_LCR_InformationItem_RL_SetupRspTDD */
static int hf_rnsap_USCH_LCR_InformationListIEs_RL_SetupRspTDD_item = -1;  /* USCH_LCR_InformationItem_RL_SetupRspTDD */
static int hf_rnsap_generalCause = -1;            /* GeneralCauseList_RL_SetupFailureFDD */
static int hf_rnsap_rLSpecificCause = -1;         /* RLSpecificCauseList_RL_SetupFailureFDD */
static int hf_rnsap_cause = -1;                   /* Cause */
static int hf_rnsap_unsuccessful_RL_InformationRespList_RL_SetupFailureFDD = -1;  /* UnsuccessfulRL_InformationResponseList_RL_SetupFailureFDD */
static int hf_rnsap_successful_RL_InformationRespList_RL_SetupFailureFDD = -1;  /* SuccessfulRL_InformationResponseList_RL_SetupFailureFDD */
static int hf_rnsap_UnsuccessfulRL_InformationResponseList_RL_SetupFailureFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_SuccessfulRL_InformationResponseList_RL_SetupFailureFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_diversityIndication1 = -1;    /* DiversityIndication_RL_SetupFailureFDD */
static int hf_rnsap_not_Used_dSCH_InformationResponse_RL_SetupFailureFDD = -1;  /* NULL */
static int hf_rnsap_combining1 = -1;              /* Combining_RL_SetupFailureFDD */
static int hf_rnsap_nonCombiningOrFirstRL1 = -1;  /* NonCombiningOrFirstRL_RL_SetupFailureFDD */
static int hf_rnsap_generalCause1 = -1;           /* GeneralCauseList_RL_SetupFailureTDD */
static int hf_rnsap_rLSpecificCause1 = -1;        /* RLSpecificCauseList_RL_SetupFailureTDD */
static int hf_rnsap_unsuccessful_RL_InformationRespItem_RL_SetupFailureTDD = -1;  /* Unsuccessful_RL_InformationRespItem_RL_SetupFailureTDD */
static int hf_rnsap_RL_InformationList_RL_AdditionRqstFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_dL_TimeSlot_ISCP_Info = -1;   /* DL_TimeSlot_ISCP_Info */
static int hf_rnsap_UL_CCTrCH_InformationList_RL_AdditionRqstTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_uplinkStepSizeLCR = -1;       /* TDD_TPC_UplinkStepSize_LCR */
static int hf_rnsap_DL_CCTrCH_InformationList_RL_AdditionRqstTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_downlinkStepSize = -1;        /* TDD_TPC_DownlinkStepSize */
static int hf_rnsap_RL_InformationResponseList_RL_AdditionRspFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_dl_CodeInformation1 = -1;     /* DL_CodeInformationList_RL_AdditionRspFDD */
static int hf_rnsap_diversityIndication2 = -1;    /* DiversityIndication_RL_AdditionRspFDD */
static int hf_rnsap_combining2 = -1;              /* Combining_RL_AdditionRspFDD */
static int hf_rnsap_nonCombining = -1;            /* NonCombining_RL_AdditionRspFDD */
static int hf_rnsap_ul_CCTrCHInformation1 = -1;   /* UL_CCTrCHInformationList_RL_AdditionRspTDD */
static int hf_rnsap_dl_CCTrCHInformation1 = -1;   /* DL_CCTrCHInformationList_RL_AdditionRspTDD */
static int hf_rnsap_dCH_Information = -1;         /* DCH_Information_RL_AdditionRspTDD */
static int hf_rnsap_dSCH_InformationResponse = -1;  /* DSCH_InformationResponse_RL_AdditionRspTDD */
static int hf_rnsap_uSCH_InformationResponse = -1;  /* USCH_InformationResponse_RL_AdditionRspTDD */
static int hf_rnsap_UL_CCTrCHInformationListIE_RL_AdditionRspTDD_item = -1;  /* UL_CCTrCHInformationItem_RL_AdditionRspTDD */
static int hf_rnsap_ul_DPCH_Information1 = -1;    /* UL_DPCH_InformationList_RL_AdditionRspTDD */
static int hf_rnsap_DL_CCTrCHInformationListIE_RL_AdditionRspTDD_item = -1;  /* DL_CCTrCHInformationItem_RL_AdditionRspTDD */
static int hf_rnsap_dl_DPCH_Information1 = -1;    /* DL_DPCH_InformationList_RL_AdditionRspTDD */
static int hf_rnsap_diversityIndication3 = -1;    /* DiversityIndication_RL_AdditionRspTDD */
static int hf_rnsap_combining3 = -1;              /* Combining_RL_AdditionRspTDD */
static int hf_rnsap_nonCombining1 = -1;           /* NonCombining_RL_AdditionRspTDD */
static int hf_rnsap_DSCH_InformationListIE_RL_AdditionRspTDD_item = -1;  /* DSCHInformationItem_RL_AdditionRspTDD */
static int hf_rnsap_diversityIndication4 = -1;    /* DiversityIndication_RL_AdditionRspTDD2 */
static int hf_rnsap_USCH_InformationListIE_RL_AdditionRspTDD_item = -1;  /* USCHInformationItem_RL_AdditionRspTDD */
static int hf_rnsap_uSCH_ID = -1;                 /* USCH_ID */
static int hf_rnsap_ul_CCTrCH_LCR_Information = -1;  /* UL_CCTrCH_LCR_InformationList_RL_AdditionRspTDD */
static int hf_rnsap_dl_CCTrCH_LCR_Information = -1;  /* DL_CCTrCH_LCR_InformationList_RL_AdditionRspTDD */
static int hf_rnsap_dCH_InformationResponse2 = -1;  /* DCH_InformationResponseList_RL_AdditionRspTDD */
static int hf_rnsap_dsch_LCR_InformationResponse1 = -1;  /* DSCH_LCR_InformationResponse_RL_AdditionRspTDD */
static int hf_rnsap_usch_LCR_InformationResponse1 = -1;  /* USCH_LCR_InformationResponse_RL_AdditionRspTDD */
static int hf_rnsap_UL_CCTrCH_LCR_InformationListIE_RL_AdditionRspTDD_item = -1;  /* UL_CCTrCH_LCR_InformationItem_RL_AdditionRspTDD */
static int hf_rnsap_ul_DPCH_LCR_Information1 = -1;  /* UL_DPCH_LCR_InformationList_RL_AdditionRspTDD */
static int hf_rnsap_DL_CCTrCH_LCR_InformationListIE_RL_AdditionRspTDD_item = -1;  /* DL_CCTrCH_LCR_InformationItem_RL_AdditionRspTDD */
static int hf_rnsap_dl_DPCH_LCR_Information1 = -1;  /* DL_DPCH_LCR_InformationList_RL_AdditionRspTDD */
static int hf_rnsap_dL_TimeslotLCR_Information = -1;  /* DL_TimeslotLCR_Information */
static int hf_rnsap_DSCH_LCR_InformationListIEs_RL_AdditionRspTDD_item = -1;  /* DSCH_LCR_InformationItem_RL_AdditionRspTDD */
static int hf_rnsap_USCH_LCR_InformationListIEs_RL_AdditionRspTDD_item = -1;  /* USCH_LCR_InformationItem_RL_AdditionRspTDD */
static int hf_rnsap_generalCause2 = -1;           /* GeneralCauseList_RL_AdditionFailureFDD */
static int hf_rnsap_rLSpecificCause2 = -1;        /* RLSpecificCauseList_RL_AdditionFailureFDD */
static int hf_rnsap_unsuccessful_RL_InformationRespList_RL_AdditionFailureFDD = -1;  /* UnsuccessfulRL_InformationResponseList_RL_AdditionFailureFDD */
static int hf_rnsap_successful_RL_InformationRespList_RL_AdditionFailureFDD = -1;  /* SuccessfulRL_InformationResponseList_RL_AdditionFailureFDD */
static int hf_rnsap_UnsuccessfulRL_InformationResponseList_RL_AdditionFailureFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_SuccessfulRL_InformationResponseList_RL_AdditionFailureFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_dl_CodeInformation2 = -1;     /* DL_CodeInformationList_RL_AdditionFailureFDD */
static int hf_rnsap_diversityIndication5 = -1;    /* DiversityIndication_RL_AdditionFailureFDD */
static int hf_rnsap_combining4 = -1;              /* Combining_RL_AdditionFailureFDD */
static int hf_rnsap_nonCombining2 = -1;           /* NonCombining_RL_AdditionFailureFDD */
static int hf_rnsap_generalCause3 = -1;           /* GeneralCauseList_RL_AdditionFailureTDD */
static int hf_rnsap_rLSpecificCause3 = -1;        /* RLSpecificCauseList_RL_AdditionFailureTDD */
static int hf_rnsap_unsuccessful_RL_InformationRespItem_RL_AdditionFailureTDD = -1;  /* Unsuccessful_RL_InformationRespItem_RL_AdditionFailureTDD */
static int hf_rnsap_RL_InformationList_RL_DeletionRqst_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_maxNrOfUL_DPDCHs = -1;        /* MaxNrOfUL_DPCHs */
static int hf_rnsap_not_Used_sSDT_CellIDLength = -1;  /* NULL */
static int hf_rnsap_powerOffsetInformation2 = -1;  /* PowerOffsetInformation_RL_ReconfPrepFDD */
static int hf_rnsap_fdd_TPC_DownlinkStepSize = -1;  /* FDD_TPC_DownlinkStepSize */
static int hf_rnsap_pO1_ForTFCI_Bits = -1;        /* PowerOffset */
static int hf_rnsap_pO2_ForTPC_Bits = -1;         /* PowerOffset */
static int hf_rnsap_pO3_ForPilotBits = -1;        /* PowerOffset */
static int hf_rnsap_DCH_DeleteList_RL_ReconfPrepFDD_item = -1;  /* DCH_DeleteItem_RL_ReconfPrepFDD */
static int hf_rnsap_dCH_ID = -1;                  /* DCH_ID */
static int hf_rnsap_RL_InformationList_RL_ReconfPrepFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_not_Used_sSDT_Indication = -1;  /* NULL */
static int hf_rnsap_not_Used_sSDT_CellIdentity = -1;  /* NULL */
static int hf_rnsap_powerOffsetInformation3 = -1;  /* PowerOffsetInformation_F_DPCH_RL_ReconfPrepFDD */
static int hf_rnsap_UL_CCTrCH_InformationAddList_RL_ReconfPrepTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_punctureLimit = -1;           /* PunctureLimit */
static int hf_rnsap_UL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_UL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_DL_CCTrCH_InformationAddList_RL_ReconfPrepTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_cCTrCH_TPCList1 = -1;         /* CCTrCH_TPCAddList_RL_ReconfPrepTDD */
static int hf_rnsap_CCTrCH_TPCAddList_RL_ReconfPrepTDD_item = -1;  /* CCTrCH_TPCAddItem_RL_ReconfPrepTDD */
static int hf_rnsap_DL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_cCTrCH_TPCList2 = -1;         /* CCTrCH_TPCModifyList_RL_ReconfPrepTDD */
static int hf_rnsap_CCTrCH_TPCModifyList_RL_ReconfPrepTDD_item = -1;  /* CCTrCH_TPCModifyItem_RL_ReconfPrepTDD */
static int hf_rnsap_DL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_DCH_DeleteList_RL_ReconfPrepTDD_item = -1;  /* DCH_DeleteItem_RL_ReconfPrepTDD */
static int hf_rnsap_DSCH_ModifyList_RL_ReconfPrepTDD_item = -1;  /* DSCH_ModifyItem_RL_ReconfPrepTDD */
static int hf_rnsap_dSCH_ID = -1;                 /* DSCH_ID */
static int hf_rnsap_dl_ccTrCHID = -1;             /* CCTrCH_ID */
static int hf_rnsap_trChSourceStatisticsDescriptor = -1;  /* TrCH_SrcStatisticsDescr */
static int hf_rnsap_transportFormatSet = -1;      /* TransportFormatSet */
static int hf_rnsap_allocationRetentionPriority = -1;  /* AllocationRetentionPriority */
static int hf_rnsap_schedulingPriorityIndicator = -1;  /* SchedulingPriorityIndicator */
static int hf_rnsap_bLER = -1;                    /* BLER */
static int hf_rnsap_transportBearerRequestIndicator = -1;  /* TransportBearerRequestIndicator */
static int hf_rnsap_DSCH_DeleteList_RL_ReconfPrepTDD_item = -1;  /* DSCH_DeleteItem_RL_ReconfPrepTDD */
static int hf_rnsap_USCH_ModifyList_RL_ReconfPrepTDD_item = -1;  /* USCH_ModifyItem_RL_ReconfPrepTDD */
static int hf_rnsap_ul_ccTrCHID = -1;             /* CCTrCH_ID */
static int hf_rnsap_rb_Info = -1;                 /* RB_Info */
static int hf_rnsap_USCH_DeleteList_RL_ReconfPrepTDD_item = -1;  /* USCH_DeleteItem_RL_ReconfPrepTDD */
static int hf_rnsap_RL_Information_RL_ReconfPrepTDD_item = -1;  /* RL_InformationIE_RL_ReconfPrepTDD */
static int hf_rnsap_rL_Specific_DCH_Info = -1;    /* RL_Specific_DCH_Info */
static int hf_rnsap_RL_InformationResponseList_RL_ReconfReadyFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_max_UL_SIR = -1;              /* UL_SIR */
static int hf_rnsap_min_UL_SIR = -1;              /* UL_SIR */
static int hf_rnsap_dl_CodeInformationList = -1;  /* DL_CodeInformationList_RL_ReconfReadyFDD */
static int hf_rnsap_dCHInformationResponse = -1;  /* DCH_InformationResponseList_RL_ReconfReadyFDD */
static int hf_rnsap_not_Used_dSCHsToBeAddedOrModified = -1;  /* NULL */
static int hf_rnsap_ul_CCTrCH_Information = -1;   /* UL_CCTrCH_InformationList_RL_ReconfReadyTDD */
static int hf_rnsap_dl_CCTrCH_Information = -1;   /* DL_CCTrCH_InformationList_RL_ReconfReadyTDD */
static int hf_rnsap_dCHInformationResponse1 = -1;  /* DCH_InformationResponseList_RL_ReconfReadyTDD */
static int hf_rnsap_dSCHsToBeAddedOrModified = -1;  /* DSCHToBeAddedOrModified_RL_ReconfReadyTDD */
static int hf_rnsap_uSCHsToBeAddedOrModified = -1;  /* USCHToBeAddedOrModified_RL_ReconfReadyTDD */
static int hf_rnsap_UL_CCTrCHInformationListIE_RL_ReconfReadyTDD_item = -1;  /* UL_CCTrCH_InformationItem_RL_ReconfReadyTDD */
static int hf_rnsap_ul_DPCH_AddInformation = -1;  /* UL_DPCH_InformationAddList_RL_ReconfReadyTDD */
static int hf_rnsap_ul_DPCH_ModifyInformation = -1;  /* UL_DPCH_InformationModifyList_RL_ReconfReadyTDD */
static int hf_rnsap_ul_DPCH_DeleteInformation = -1;  /* UL_DPCH_InformationDeleteList_RL_ReconfReadyTDD */
static int hf_rnsap_uL_TimeslotLCR_Info = -1;     /* UL_TimeslotLCR_Information */
static int hf_rnsap_rxTimingDeviationForTA = -1;  /* RxTimingDeviationForTA */
static int hf_rnsap_uL_Timeslot_InformationModifyList_RL_ReconfReadyTDD = -1;  /* UL_Timeslot_InformationModifyList_RL_ReconfReadyTDD */
static int hf_rnsap_UL_TimeslotLCR_InformationModifyList_RL_ReconfReadyTDD_item = -1;  /* UL_TimeslotLCR_InformationModifyItem_RL_ReconfReadyTDD */
static int hf_rnsap_timeSlotLCR = -1;             /* TimeSlotLCR */
static int hf_rnsap_midambleShiftLCR = -1;        /* MidambleShiftLCR */
static int hf_rnsap_tDD_uL_Code_LCR_Information = -1;  /* TDD_UL_Code_LCR_InformationModifyList_RL_ReconfReadyTDD */
static int hf_rnsap_TDD_UL_Code_LCR_InformationModifyList_RL_ReconfReadyTDD_item = -1;  /* TDD_UL_Code_LCR_InformationModifyItem_RL_ReconfReadyTDD */
static int hf_rnsap_dPCH_ID = -1;                 /* DPCH_ID */
static int hf_rnsap_tDD_ChannelisationCodeLCR = -1;  /* TDD_ChannelisationCodeLCR */
static int hf_rnsap_UL_Timeslot_InformationModifyList_RL_ReconfReadyTDD_item = -1;  /* UL_Timeslot_InformationModifyItem_RL_ReconfReadyTDD */
static int hf_rnsap_timeSlot = -1;                /* TimeSlot */
static int hf_rnsap_midambleShiftAndBurstType = -1;  /* MidambleShiftAndBurstType */
static int hf_rnsap_uL_Code_Information = -1;     /* TDD_UL_Code_InformationModifyList_RL_ReconfReadyTDD */
static int hf_rnsap_TDD_UL_Code_InformationModifyList_RL_ReconfReadyTDD_item = -1;  /* TDD_UL_Code_InformationModifyItem_RL_ReconfReadyTDD */
static int hf_rnsap_tDD_ChannelisationCode = -1;  /* TDD_ChannelisationCode */
static int hf_rnsap_UL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD_item = -1;  /* UL_DPCH_InformationDeleteItem_RL_ReconfReadyTDD */
static int hf_rnsap_DL_CCTrCHInformationListIE_RL_ReconfReadyTDD_item = -1;  /* DL_CCTrCH_InformationItem_RL_ReconfReadyTDD */
static int hf_rnsap_dl_DPCH_AddInformation = -1;  /* DL_DPCH_InformationAddList_RL_ReconfReadyTDD */
static int hf_rnsap_dl_DPCH_ModifyInformation = -1;  /* DL_DPCH_InformationModifyList_RL_ReconfReadyTDD */
static int hf_rnsap_dl_DPCH_DeleteInformation = -1;  /* DL_DPCH_InformationDeleteList_RL_ReconfReadyTDD */
static int hf_rnsap_dL_TimeslotLCR_Info = -1;     /* DL_TimeslotLCR_Information */
static int hf_rnsap_dL_Timeslot_InformationModifyList_RL_ReconfReadyTDD = -1;  /* DL_Timeslot_InformationModifyList_RL_ReconfReadyTDD */
static int hf_rnsap_DL_TimeslotLCR_InformationModifyList_RL_ReconfReadyTDD_item = -1;  /* DL_TimeslotLCR_InformationModifyItem_RL_ReconfReadyTDD */
static int hf_rnsap_tDD_dL_Code_LCR_Information = -1;  /* TDD_DL_Code_LCR_InformationModifyList_RL_ReconfReadyTDD */
static int hf_rnsap_TDD_DL_Code_LCR_InformationModifyList_RL_ReconfReadyTDD_item = -1;  /* TDD_DL_Code_LCR_InformationModifyItem_RL_ReconfReadyTDD */
static int hf_rnsap_DL_Timeslot_InformationModifyList_RL_ReconfReadyTDD_item = -1;  /* DL_Timeslot_InformationModifyItem_RL_ReconfReadyTDD */
static int hf_rnsap_dL_Code_Information = -1;     /* TDD_DL_Code_InformationModifyList_RL_ReconfReadyTDD */
static int hf_rnsap_TDD_DL_Code_InformationModifyList_RL_ReconfReadyTDD_item = -1;  /* TDD_DL_Code_InformationModifyItem_RL_ReconfReadyTDD */
static int hf_rnsap_DL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD_item = -1;  /* DL_DPCH_InformationDeleteItem_RL_ReconfReadyTDD */
static int hf_rnsap_DSCHToBeAddedOrModifiedList_RL_ReconfReadyTDD_item = -1;  /* DSCHToBeAddedOrModifiedItem_RL_ReconfReadyTDD */
static int hf_rnsap_USCHToBeAddedOrModifiedList_RL_ReconfReadyTDD_item = -1;  /* USCHToBeAddedOrModifiedItem_RL_ReconfReadyTDD */
static int hf_rnsap_Multiple_RL_InformationResponse_RL_ReconfReadyTDD_item = -1;  /* RL_InformationResponse_RL_ReconfReadyTDD */
static int hf_rnsap_generalCause4 = -1;           /* GeneralCauseList_RL_ReconfFailure */
static int hf_rnsap_rLSpecificCause4 = -1;        /* RLSpecificCauseList_RL_ReconfFailure */
static int hf_rnsap_rL_ReconfigurationFailureList_RL_ReconfFailure = -1;  /* RL_ReconfigurationFailureList_RL_ReconfFailure */
static int hf_rnsap_RL_ReconfigurationFailureList_RL_ReconfFailure_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_DCH_DeleteList_RL_ReconfRqstFDD_item = -1;  /* DCH_DeleteItem_RL_ReconfRqstFDD */
static int hf_rnsap_RL_ReconfigurationRequestFDD_RL_InformationList_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_UL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_UL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_DL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_DCH_DeleteList_RL_ReconfRqstTDD_item = -1;  /* DCH_DeleteItem_RL_ReconfRqstTDD */
static int hf_rnsap_Multiple_RL_ReconfigurationRequestTDD_RL_Information_item = -1;  /* RL_ReconfigurationRequestTDD_RL_Information */
static int hf_rnsap_RL_InformationResponseList_RL_ReconfRspFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_dCHsInformationResponseList = -1;  /* DCH_InformationResponseList_RL_ReconfRspFDD */
static int hf_rnsap_dL_CodeInformationList_RL_ReconfResp = -1;  /* DL_CodeInformationList_RL_ReconfRspFDD */
static int hf_rnsap_dCHsInformationResponseList1 = -1;  /* DCH_InformationResponseList_RL_ReconfRspTDD */
static int hf_rnsap_DL_CCTrCH_InformationList_RL_ReconfRspTDD_item = -1;  /* DL_CCTrCH_InformationItem_RL_ReconfRspTDD */
static int hf_rnsap_dl_DPCH_ModifyInformation_LCR = -1;  /* DL_DPCH_InformationModifyList_LCR_RL_ReconfRspTDD */
static int hf_rnsap_cCTrCH_Maximum_DL_Power = -1;  /* DL_Power */
static int hf_rnsap_cCTrCH_Minimum_DL_Power = -1;  /* DL_Power */
static int hf_rnsap_dL_Timeslot_LCR_InformationModifyList_RL_ReconfRqstTDD = -1;  /* DL_Timeslot_LCR_InformationModifyList_RL_ReconfRspTDD */
static int hf_rnsap_DL_Timeslot_LCR_InformationModifyList_RL_ReconfRspTDD_item = -1;  /* DL_Timeslot_LCR_InformationModifyItem_RL_ReconfRspTDD */
static int hf_rnsap_maxPowerLCR = -1;             /* DL_Power */
static int hf_rnsap_minPowerLCR = -1;             /* DL_Power */
static int hf_rnsap_Multiple_RL_InformationResponse_RL_ReconfRspTDD_item = -1;  /* RL_InformationResponse_RL_ReconfRspTDD */
static int hf_rnsap_rL = -1;                      /* RL_RL_FailureInd */
static int hf_rnsap_rL_Set = -1;                  /* RL_Set_RL_FailureInd */
static int hf_rnsap_cCTrCH = -1;                  /* CCTrCH_RL_FailureInd */
static int hf_rnsap_rL_InformationList_RL_FailureInd = -1;  /* RL_InformationList_RL_FailureInd */
static int hf_rnsap_RL_InformationList_RL_FailureInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_rL_Set_InformationList_RL_FailureInd = -1;  /* RL_Set_InformationList_RL_FailureInd */
static int hf_rnsap_RL_Set_InformationList_RL_FailureInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_cCTrCH_InformationList_RL_FailureInd = -1;  /* CCTrCH_InformationList_RL_FailureInd */
static int hf_rnsap_CCTrCH_InformationList_RL_FailureInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_RL_InformationList_RL_PreemptRequiredInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_HSDSCHMacdFlowSpecificInformationList_RL_PreemptRequiredInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_hSDSCH_MACdFlow_ID = -1;      /* HSDSCH_MACdFlow_ID */
static int hf_rnsap_EDCH_MacdFlowSpecificInformationList_RL_PreemptRequiredInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_eDCH_MACdFlow_ID = -1;        /* EDCH_MACdFlow_ID */
static int hf_rnsap_rL1 = -1;                     /* RL_RL_RestoreInd */
static int hf_rnsap_rL_Set1 = -1;                 /* RL_Set_RL_RestoreInd */
static int hf_rnsap_cCTrCH1 = -1;                 /* CCTrCH_RL_RestoreInd */
static int hf_rnsap_rL_InformationList_RL_RestoreInd = -1;  /* RL_InformationList_RL_RestoreInd */
static int hf_rnsap_RL_InformationList_RL_RestoreInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_rL_Set_InformationList_RL_RestoreInd = -1;  /* RL_Set_InformationList_RL_RestoreInd */
static int hf_rnsap_RL_Set_InformationList_RL_RestoreInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_cCTrCH_InformationList_RL_RestoreInd = -1;  /* CCTrCH_InformationList_RL_RestoreInd */
static int hf_rnsap_CCTrCH_InformationList_RL_RestoreInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_DL_ReferencePowerInformationList_DL_PC_Rqst_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_dl_Reference_Power = -1;      /* DL_Power */
static int hf_rnsap_dl_CodeInformation3 = -1;     /* DL_CodeInformationList_PhyChReconfRqstFDD */
static int hf_rnsap_ul_CCTrCH_Information1 = -1;  /* UL_CCTrCH_InformationList_PhyChReconfRqstTDD */
static int hf_rnsap_dl_CCTrCH_Information1 = -1;  /* DL_CCTrCH_InformationList_PhyChReconfRqstTDD */
static int hf_rnsap_UL_CCTrCH_InformationListIE_PhyChReconfRqstTDD_item = -1;  /* UL_CCTrCH_InformationItem_PhyChReconfRqstTDD */
static int hf_rnsap_ul_DPCH_Information2 = -1;    /* UL_DPCH_InformationList_PhyChReconfRqstTDD */
static int hf_rnsap_uL_Timeslot_InformationList_PhyChReconfRqstTDD = -1;  /* UL_Timeslot_InformationList_PhyChReconfRqstTDD */
static int hf_rnsap_UL_TimeslotLCR_InformationList_PhyChReconfRqstTDD_item = -1;  /* UL_TimeslotLCR_InformationItem_PhyChReconfRqstTDD */
static int hf_rnsap_uL_Code_LCR_Information = -1;  /* TDD_UL_Code_LCR_Information */
static int hf_rnsap_UL_Timeslot_InformationList_PhyChReconfRqstTDD_item = -1;  /* UL_Timeslot_InformationItem_PhyChReconfRqstTDD */
static int hf_rnsap_uL_Code_Information1 = -1;    /* TDD_UL_Code_Information */
static int hf_rnsap_DL_CCTrCH_InformationListIE_PhyChReconfRqstTDD_item = -1;  /* DL_CCTrCH_InformationItem_PhyChReconfRqstTDD */
static int hf_rnsap_dl_DPCH_Information2 = -1;    /* DL_DPCH_InformationList_PhyChReconfRqstTDD */
static int hf_rnsap_dL_Timeslot_InformationList_PhyChReconfRqstTDD = -1;  /* DL_Timeslot_InformationList_PhyChReconfRqstTDD */
static int hf_rnsap_DL_TimeslotLCR_InformationList_PhyChReconfRqstTDD_item = -1;  /* DL_TimeslotLCR_InformationItem_PhyChReconfRqstTDD */
static int hf_rnsap_dL_Code_LCR_Information = -1;  /* TDD_DL_Code_LCR_Information */
static int hf_rnsap_DL_Timeslot_InformationList_PhyChReconfRqstTDD_item = -1;  /* DL_Timeslot_InformationItem_PhyChReconfRqstTDD */
static int hf_rnsap_dL_Code_Information1 = -1;    /* TDD_DL_Code_Information */
static int hf_rnsap_HSPDSCH_Timeslot_InformationList_PhyChReconfRqstTDD_item = -1;  /* HSPDSCH_Timeslot_InformationItem_PhyChReconfRqstTDD */
static int hf_rnsap_timeslot = -1;                /* TimeSlot */
static int hf_rnsap_HSPDSCH_Timeslot_InformationListLCR_PhyChReconfRqstTDD_item = -1;  /* HSPDSCH_Timeslot_InformationItemLCR_PhyChReconfRqstTDD */
static int hf_rnsap_timeslotLCR = -1;             /* TimeSlotLCR */
static int hf_rnsap_RL_InformationList_RL_CongestInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_dCH_Rate_Information = -1;    /* DCH_Rate_Information_RL_CongestInd */
static int hf_rnsap_DCH_Rate_Information_RL_CongestInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_allowed_Rate_Information = -1;  /* Allowed_Rate_Information */
static int hf_rnsap_EDCH_MacdFlowSpecificInformationList_RL_CongestInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_uRA = -1;                     /* URA_PagingRqst */
static int hf_rnsap_cell = -1;                    /* Cell_PagingRqst */
static int hf_rnsap_uRA_ID = -1;                  /* URA_ID */
static int hf_rnsap_pagingCause = -1;             /* PagingCause */
static int hf_rnsap_cNDomainType = -1;            /* CNDomainType */
static int hf_rnsap_pagingRecordType = -1;        /* PagingRecordType */
static int hf_rnsap_rL2 = -1;                     /* RL_DM_Rqst */
static int hf_rnsap_rLS = -1;                     /* RL_Set_DM_Rqst */
static int hf_rnsap_allRL = -1;                   /* All_RL_DM_Rqst */
static int hf_rnsap_allRLS = -1;                  /* All_RL_Set_DM_Rqst */
static int hf_rnsap_rL_InformationList_DM_Rqst = -1;  /* RL_InformationList_DM_Rqst */
static int hf_rnsap_RL_InformationList_DM_Rqst_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_HSSICH_Info_DM_Rqst_item = -1;  /* HS_SICH_ID */
static int hf_rnsap_rL_Set_InformationList_DM_Rqst = -1;  /* RL_Set_InformationList_DM_Rqst */
static int hf_rnsap_RL_Set_InformationList_DM_Rqst_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_rLs = -1;                     /* RL_DM_Rsp */
static int hf_rnsap_rLS1 = -1;                    /* RL_Set_DM_Rsp */
static int hf_rnsap_allRL1 = -1;                  /* RL_DM_Rsp */
static int hf_rnsap_allRLS1 = -1;                 /* RL_Set_DM_Rsp */
static int hf_rnsap_rL_InformationList_DM_Rsp = -1;  /* RL_InformationList_DM_Rsp */
static int hf_rnsap_rL_Set_InformationList_DM_Rsp = -1;  /* RL_Set_InformationList_DM_Rsp */
static int hf_rnsap_RL_InformationList_DM_Rsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_dedicatedMeasurementValue = -1;  /* DedicatedMeasurementValue */
static int hf_rnsap_cFN = -1;                     /* CFN */
static int hf_rnsap_RL_Set_InformationList_DM_Rsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_Multiple_DedicatedMeasurementValueList_TDD_DM_Rsp_item = -1;  /* Multiple_DedicatedMeasurementValueItem_TDD_DM_Rsp */
static int hf_rnsap_Multiple_DedicatedMeasurementValueList_LCR_TDD_DM_Rsp_item = -1;  /* Multiple_DedicatedMeasurementValueItem_LCR_TDD_DM_Rsp */
static int hf_rnsap_rL3 = -1;                     /* RL_DM_Fail */
static int hf_rnsap_rLS2 = -1;                    /* RL_Set_DM_Fail */
static int hf_rnsap_allRL2 = -1;                  /* RL_DM_Fail */
static int hf_rnsap_allRLS2 = -1;                 /* RL_Set_DM_Fail */
static int hf_rnsap_rL_unsuccessful_InformationRespList_DM_Fail = -1;  /* RL_Unsuccessful_InformationRespList_DM_Fail */
static int hf_rnsap_rL_successful_InformationRespList_DM_Fail = -1;  /* RL_Successful_InformationRespList_DM_Fail */
static int hf_rnsap_rL_Set_unsuccessful_InformationRespList_DM_Fail = -1;  /* RL_Set_Unsuccessful_InformationRespList_DM_Fail */
static int hf_rnsap_rL_Set_successful_InformationRespList_DM_Fail = -1;  /* RL_Set_Successful_InformationRespList_DM_Fail */
static int hf_rnsap_RL_Unsuccessful_InformationRespList_DM_Fail_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_individualcause = -1;         /* Cause */
static int hf_rnsap_RL_Successful_InformationRespList_DM_Fail_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_RL_Set_Unsuccessful_InformationRespList_DM_Fail_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_RL_Set_Successful_InformationRespList_DM_Fail_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_rLs1 = -1;                    /* RL_DM_Rprt */
static int hf_rnsap_rLS3 = -1;                    /* RL_Set_DM_Rprt */
static int hf_rnsap_allRL3 = -1;                  /* RL_DM_Rprt */
static int hf_rnsap_allRLS3 = -1;                 /* RL_Set_DM_Rprt */
static int hf_rnsap_rL_InformationList_DM_Rprt = -1;  /* RL_InformationList_DM_Rprt */
static int hf_rnsap_rL_Set_InformationList_DM_Rprt = -1;  /* RL_Set_InformationList_DM_Rprt */
static int hf_rnsap_RL_InformationList_DM_Rprt_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_dedicatedMeasurementValueInformation = -1;  /* DedicatedMeasurementValueInformation */
static int hf_rnsap_RL_Set_InformationList_DM_Rprt_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_rL4 = -1;                     /* RL_DM_Fail_Ind */
static int hf_rnsap_rLS4 = -1;                    /* RL_Set_DM_Fail_Ind */
static int hf_rnsap_allRL4 = -1;                  /* RL_DM_Fail_Ind */
static int hf_rnsap_allRLS4 = -1;                 /* RL_Set_DM_Fail_Ind */
static int hf_rnsap_rL_unsuccessful_InformationRespList_DM_Fail_Ind = -1;  /* RL_Unsuccessful_InformationRespList_DM_Fail_Ind */
static int hf_rnsap_rL_Set_unsuccessful_InformationRespList_DM_Fail_Ind = -1;  /* RL_Set_Unsuccessful_InformationRespList_DM_Fail_Ind */
static int hf_rnsap_RL_Unsuccessful_InformationRespList_DM_Fail_Ind_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_RL_Set_Unsuccessful_InformationRespList_DM_Fail_Ind_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_fACH_FlowControlInformation = -1;  /* FACH_FlowControlInformation_CTCH_ResourceRspFDD */
static int hf_rnsap_fACH_FlowControlInformation1 = -1;  /* FACH_FlowControlInformation_CTCH_ResourceRspTDD */
static int hf_rnsap_cell1 = -1;                   /* Cell_CM_Rqst */
static int hf_rnsap_uC_ID = -1;                   /* UC_ID */
static int hf_rnsap_neighbouringCellMeasurementInformation = -1;  /* NeighbouringCellMeasurementInfo */
static int hf_rnsap_NeighbouringCellMeasurementInfo_item = -1;  /* NeighbouringCellMeasurementInfo_item */
static int hf_rnsap_neighbouringFDDCellMeasurementInformation = -1;  /* NeighbouringFDDCellMeasurementInformation */
static int hf_rnsap_neighbouringTDDCellMeasurementInformation = -1;  /* NeighbouringTDDCellMeasurementInformation */
static int hf_rnsap_extension_neighbouringCellMeasurementInformation = -1;  /* Extension_neighbouringCellMeasurementInformation */
static int hf_rnsap_cell2 = -1;                   /* Cell_CM_Rsp */
static int hf_rnsap_commonMeasurementValue = -1;  /* CommonMeasurementValue */
static int hf_rnsap_cell3 = -1;                   /* Cell_CM_Rprt */
static int hf_rnsap_commonMeasurementValueInformation = -1;  /* CommonMeasurementValueInformation */
static int hf_rnsap_cell4 = -1;                   /* Cell_InfEx_Rqst */
static int hf_rnsap_extension_InformationExchangeObjectType_InfEx_Rqst = -1;  /* Extension_InformationExchangeObjectType_InfEx_Rqst */
static int hf_rnsap_cGI = -1;                     /* CGI */
static int hf_rnsap_cell5 = -1;                   /* Cell_InfEx_Rsp */
static int hf_rnsap_extension_InformationExchangeObjectType_InfEx_Rsp = -1;  /* Extension_InformationExchangeObjectType_InfEx_Rsp */
static int hf_rnsap_requestedDataValue = -1;      /* RequestedDataValue */
static int hf_rnsap_MBMS_Bearer_Service_List_InfEx_Rsp_item = -1;  /* MBMS_Bearer_ServiceItemIEs_InfEx_Rsp */
static int hf_rnsap_tmgi = -1;                    /* TMGI */
static int hf_rnsap_cell6 = -1;                   /* Cell_InfEx_Rprt */
static int hf_rnsap_requestedDataValueInformation = -1;  /* RequestedDataValueInformation */
static int hf_rnsap_context = -1;                 /* ContextList_Reset */
static int hf_rnsap_all_contexts = -1;            /* NULL */
static int hf_rnsap_contextGroup = -1;            /* ContextGroupList_Reset */
static int hf_rnsap_contextInfoList_Reset = -1;   /* ContextInfoList_Reset */
static int hf_rnsap_ContextInfoList_Reset_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_contextType_Reset = -1;       /* ContextType_Reset */
static int hf_rnsap_sRNTI = -1;                   /* S_RNTI */
static int hf_rnsap_dRNTI = -1;                   /* D_RNTI */
static int hf_rnsap_contextGroupInfoList_Reset = -1;  /* ContextGroupInfoList_Reset */
static int hf_rnsap_ContextGroupInfoList_Reset_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_s_RNTI_Group = -1;            /* S_RNTI_Group */
static int hf_rnsap_DelayedActivationInformationList_RL_ActivationCmdFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_delayed_activation_update = -1;  /* DelayedActivationUpdate */
static int hf_rnsap_DelayedActivationInformationList_RL_ActivationCmdTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_RL_ParameterUpdateIndicationFDD_RL_InformationList_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_phase_Reference_Update_Indicator = -1;  /* Phase_Reference_Update_Indicator */
static int hf_rnsap_ListOfInterfacesToTrace_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_interface = -1;               /* T_interface */
static int hf_rnsap_privateIEs = -1;              /* PrivateIE_Container */
static int hf_rnsap_Active_MBMS_Bearer_Service_ListFDD_item = -1;  /* MBMS_Bearer_ServiceItemFDD */
static int hf_rnsap_Active_MBMS_Bearer_Service_ListFDD_PFL_item = -1;  /* MBMS_Bearer_ServiceItemFDD_PFL */
static int hf_rnsap_Active_MBMS_Bearer_Service_ListTDD_item = -1;  /* MBMS_Bearer_ServiceItemTDD */
static int hf_rnsap_Active_MBMS_Bearer_Service_ListTDD_PFL_item = -1;  /* MBMS_Bearer_ServiceItemTDD_PFL */
static int hf_rnsap_cMConfigurationChangeCFN = -1;  /* CFN */
static int hf_rnsap_transmission_Gap_Pattern_Sequence_Status = -1;  /* Transmission_Gap_Pattern_Sequence_Status_List */
static int hf_rnsap_AdditionalPreferredFrequency_item = -1;  /* AdditionalPreferredFrequencyItem */
static int hf_rnsap_correspondingCells = -1;      /* CorrespondingCells */
static int hf_rnsap_AffectedUEInformationForMBMS_item = -1;  /* S_RNTI */
static int hf_rnsap_priorityLevel = -1;           /* PriorityLevel */
static int hf_rnsap_pre_emptionCapability = -1;   /* Pre_emptionCapability */
static int hf_rnsap_pre_emptionVulnerability = -1;  /* Pre_emptionVulnerability */
static int hf_rnsap_allowed_UL_Rate = -1;         /* Allowed_Rate */
static int hf_rnsap_allowed_DL_Rate = -1;         /* Allowed_Rate */
static int hf_rnsap_aOA_LCR = -1;                 /* AOA_LCR */
static int hf_rnsap_aOA_LCR_Accuracy_Class = -1;  /* AOA_LCR_Accuracy_Class */
static int hf_rnsap_badSatelliteInformation = -1;  /* T_badSatelliteInformation */
static int hf_rnsap_badSatelliteInformation_item = -1;  /* T_badSatelliteInformation_item */
static int hf_rnsap_badSAT_ID = -1;               /* SAT_ID */
static int hf_rnsap_nCC = -1;                     /* NCC */
static int hf_rnsap_bCC = -1;                     /* BCC */
static int hf_rnsap_burstStart = -1;              /* INTEGER_0_15 */
static int hf_rnsap_burstLength = -1;             /* INTEGER_10_25 */
static int hf_rnsap_burstFreq = -1;               /* INTEGER_1_16 */
static int hf_rnsap_radioNetwork = -1;            /* CauseRadioNetwork */
static int hf_rnsap_transport = -1;               /* CauseTransport */
static int hf_rnsap_protocol = -1;                /* CauseProtocol */
static int hf_rnsap_misc = -1;                    /* CauseMisc */
static int hf_rnsap_uplinkCellCapacityClassValue = -1;  /* INTEGER_1_100_ */
static int hf_rnsap_downlinkCellCapacityClassValue = -1;  /* INTEGER_1_100_ */
static int hf_rnsap_lAI = -1;                     /* T_lAI */
static int hf_rnsap_pLMN_Identity = -1;           /* PLMN_Identity */
static int hf_rnsap_lAC = -1;                     /* LAC */
static int hf_rnsap_cI = -1;                      /* CI */
static int hf_rnsap_tUTRANGPSMeasurementAccuracyClass = -1;  /* TUTRANGPSAccuracyClass */
static int hf_rnsap_tUTRANGPSMeasurementValueInformation = -1;  /* TUTRANGPSMeasurementValueInformation */
static int hf_rnsap_sFNSFNMeasurementValueInformation = -1;  /* SFNSFNMeasurementValueInformation */
static int hf_rnsap_loadValue = -1;               /* LoadValue */
static int hf_rnsap_transmittedCarrierPowerValue = -1;  /* INTEGER_0_100 */
static int hf_rnsap_receivedTotalWideBandPowerValue = -1;  /* INTEGER_0_621 */
static int hf_rnsap_uplinkTimeslotISCPValue = -1;  /* UL_TimeslotISCP */
static int hf_rnsap_extension_CommonMeasurementValue = -1;  /* Extension_CommonMeasurementValue */
static int hf_rnsap_measurementAvailable = -1;    /* CommonMeasurementAvailable */
static int hf_rnsap_measurementnotAvailable = -1;  /* NULL */
static int hf_rnsap_CorrespondingCells_item = -1;  /* C_ID */
static int hf_rnsap_triggeringMessage = -1;       /* TriggeringMessage */
static int hf_rnsap_procedureCriticality = -1;    /* Criticality */
static int hf_rnsap_iEsCriticalityDiagnostics = -1;  /* CriticalityDiagnostics_IE_List */
static int hf_rnsap_CriticalityDiagnostics_IE_List_item = -1;  /* CriticalityDiagnostics_IE_List_item */
static int hf_rnsap_iECriticality = -1;           /* Criticality */
static int hf_rnsap_iE_ID = -1;                   /* ProtocolIE_ID */
static int hf_rnsap_repetitionNumber = -1;        /* RepetitionNumber0 */
static int hf_rnsap_MessageStructure_item = -1;   /* MessageStructure_item */
static int hf_rnsap_repetitionNumber1 = -1;       /* RepetitionNumber1 */
static int hf_rnsap_rAC = -1;                     /* RAC */
static int hf_rnsap_DCH_FDD_Information_item = -1;  /* DCH_FDD_InformationItem */
static int hf_rnsap_payloadCRC_PresenceIndicator = -1;  /* PayloadCRC_PresenceIndicator */
static int hf_rnsap_ul_FP_Mode = -1;              /* UL_FP_Mode */
static int hf_rnsap_toAWS = -1;                   /* ToAWS */
static int hf_rnsap_toAWE = -1;                   /* ToAWE */
static int hf_rnsap_dCH_SpecificInformationList = -1;  /* DCH_Specific_FDD_InformationList */
static int hf_rnsap_DCH_Specific_FDD_InformationList_item = -1;  /* DCH_Specific_FDD_Item */
static int hf_rnsap_trCH_SrcStatisticsDescr = -1;  /* TrCH_SrcStatisticsDescr */
static int hf_rnsap_ul_transportFormatSet = -1;   /* TransportFormatSet */
static int hf_rnsap_dl_transportFormatSet = -1;   /* TransportFormatSet */
static int hf_rnsap_ul_BLER = -1;                 /* BLER */
static int hf_rnsap_dl_BLER = -1;                 /* BLER */
static int hf_rnsap_frameHandlingPriority = -1;   /* FrameHandlingPriority */
static int hf_rnsap_qE_Selector = -1;             /* QE_Selector */
static int hf_rnsap_dRACControl = -1;             /* DRACControl */
static int hf_rnsap_DCH_InformationResponse_item = -1;  /* DCH_InformationResponseItem */
static int hf_rnsap_DCH_TDD_Information_item = -1;  /* DCH_TDD_InformationItem */
static int hf_rnsap_dCH_SpecificInformationList1 = -1;  /* DCH_Specific_TDD_InformationList */
static int hf_rnsap_DCH_Specific_TDD_InformationList_item = -1;  /* DCH_Specific_TDD_Item */
static int hf_rnsap_ul_cCTrCH_ID = -1;            /* CCTrCH_ID */
static int hf_rnsap_dl_cCTrCH_ID = -1;            /* CCTrCH_ID */
static int hf_rnsap_sIR_Value = -1;               /* SIR_Value */
static int hf_rnsap_sIR_ErrorValue = -1;          /* SIR_Error_Value */
static int hf_rnsap_transmittedCodePowerValue = -1;  /* Transmitted_Code_Power_Value */
static int hf_rnsap_rSCP = -1;                    /* RSCP_Value */
static int hf_rnsap_rxTimingDeviationValue = -1;  /* Rx_Timing_Deviation_Value */
static int hf_rnsap_roundTripTime = -1;           /* Round_Trip_Time_Value */
static int hf_rnsap_extension_DedicatedMeasurementValue = -1;  /* Extension_DedicatedMeasurementValue */
static int hf_rnsap_measurementAvailable1 = -1;   /* DedicatedMeasurementAvailable */
static int hf_rnsap_measurementnotAvailable1 = -1;  /* DedicatedMeasurementnotAvailable */
static int hf_rnsap_dedicatedmeasurementValue = -1;  /* DedicatedMeasurementValue */
static int hf_rnsap_cfn = -1;                     /* CFN */
static int hf_rnsap_separate_indication = -1;     /* NULL */
static int hf_rnsap_activate = -1;                /* Activate_Info */
static int hf_rnsap_deactivate = -1;              /* Deactivate_Info */
static int hf_rnsap_activation_type = -1;         /* Execution_Type */
static int hf_rnsap_initial_dl_tx_power = -1;     /* DL_Power */
static int hf_rnsap_firstRLS_Indicator = -1;      /* FirstRLS_Indicator */
static int hf_rnsap_propagation_delay = -1;       /* PropagationDelay */
static int hf_rnsap_deactivation_type = -1;       /* Execution_Type */
static int hf_rnsap_synchronised = -1;            /* CFN */
static int hf_rnsap_unsynchronised = -1;          /* NULL */
static int hf_rnsap_gPSTOW = -1;                  /* GPSTOW */
static int hf_rnsap_gPS_Status_Health = -1;       /* GPS_Status_Health */
static int hf_rnsap_satellite_DGPSCorrections_Information = -1;  /* T_satellite_DGPSCorrections_Information */
static int hf_rnsap_satellite_DGPSCorrections_Information_item = -1;  /* T_satellite_DGPSCorrections_Information_item */
static int hf_rnsap_sAT_ID = -1;                  /* SAT_ID */
static int hf_rnsap_iode_dgps = -1;               /* BIT_STRING_SIZE_8 */
static int hf_rnsap_uDRE = -1;                    /* UDRE */
static int hf_rnsap_pRC = -1;                     /* PRC */
static int hf_rnsap_range_Correction_Rate = -1;   /* Range_Correction_Rate */
static int hf_rnsap_pRCDeviation = -1;            /* PRCDeviation */
static int hf_rnsap_powerAdjustmentType = -1;     /* PowerAdjustmentType */
static int hf_rnsap_dLReferencePower = -1;        /* DL_Power */
static int hf_rnsap_dLReferencePowerList = -1;    /* DL_ReferencePowerInformationList */
static int hf_rnsap_maxAdjustmentStep = -1;       /* MaxAdjustmentStep */
static int hf_rnsap_adjustmentPeriod = -1;        /* AdjustmentPeriod */
static int hf_rnsap_adjustmentRatio = -1;         /* ScaledAdjustmentRatio */
static int hf_rnsap_DL_ReferencePowerInformationList_item = -1;  /* DL_ReferencePowerInformationItem */
static int hf_rnsap_common_DL_ReferencePowerInformation = -1;  /* DL_Power */
static int hf_rnsap_individual_DL_ReferencePowerInformation = -1;  /* DL_ReferencePowerInformationList */
static int hf_rnsap_DL_Timeslot_Information_item = -1;  /* DL_Timeslot_InformationItem */
static int hf_rnsap_DL_TimeslotLCR_Information_item = -1;  /* DL_TimeslotLCR_InformationItem */
static int hf_rnsap_DL_TimeSlot_ISCP_Info_item = -1;  /* DL_TimeSlot_ISCP_InfoItem */
static int hf_rnsap_dL_TimeslotISCP = -1;         /* DL_TimeslotISCP */
static int hf_rnsap_DL_TimeSlot_ISCP_LCR_Information_item = -1;  /* DL_TimeSlot_ISCP_LCR_InfoItem */
static int hf_rnsap_DSCH_FlowControlInformation_item = -1;  /* DSCH_FlowControlItem */
static int hf_rnsap_dSCH_SchedulingPriority = -1;  /* SchedulingPriorityIndicator */
static int hf_rnsap_mAC_c_sh_SDU_Lengths = -1;    /* MAC_c_sh_SDU_LengthList */
static int hf_rnsap_DSCH_TDD_Information_item = -1;  /* DSCH_TDD_InformationItem */
static int hf_rnsap_eAGCH_ERGCH_EHICH_FDD_ScramblingCode = -1;  /* DL_ScramblingCode */
static int hf_rnsap_eAGCH_ChannelisationCode = -1;  /* FDD_DL_ChannelisationCodeNumber */
static int hf_rnsap_primary_e_RNTI = -1;          /* E_RNTI */
static int hf_rnsap_secondary_e_RNTI = -1;        /* E_RNTI */
static int hf_rnsap_eRGCH_EHICH_ChannelisationCode = -1;  /* FDD_DL_ChannelisationCodeNumber */
static int hf_rnsap_eRGCH_SignatureSequence = -1;  /* ERGCH_SignatureSequence */
static int hf_rnsap_eHICH_SignatureSequence = -1;  /* EHICH_SignatureSequence */
static int hf_rnsap_serving_Grant_Value = -1;     /* E_Serving_Grant_Value */
static int hf_rnsap_primary_Secondary_Grant_Selector = -1;  /* E_Primary_Secondary_Grant_Selector */
static int hf_rnsap_e_RGCH_Release_Indicator = -1;  /* E_RGCH_Release_Indicator */
static int hf_rnsap_eDCH_MACdFlows_Information = -1;  /* EDCH_MACdFlows_Information */
static int hf_rnsap_EDCH_FDD_InformationResponse_item = -1;  /* EDCH_FDD_InformationResponseItem */
static int hf_rnsap_eDCH_MACdFlow_Specific_Information = -1;  /* EDCH_MACdFlow_Specific_InfoToModifyList */
static int hf_rnsap_EDCH_FDD_Update_Information_item = -1;  /* EDCH_FDD_Update_InfoItem */
static int hf_rnsap_eDCH_FDD_DL_ControlChannelInformation = -1;  /* EDCH_FDD_DL_ControlChannelInformation */
static int hf_rnsap_e_DCH_Non_Scheduled_Transmission_Grant = -1;  /* E_DCH_Non_Scheduled_Transmission_Grant_Items */
static int hf_rnsap_e_DCH_Scheduled_Transmission_Grant = -1;  /* NULL */
static int hf_rnsap_E_DCH_LogicalChannelInformation_item = -1;  /* E_DCH_LogicalChannelInformationItem */
static int hf_rnsap_logicalChannelId = -1;        /* LogicalChannelID */
static int hf_rnsap_mACes_GuaranteedBitRate = -1;  /* MACes_Guaranteed_Bitrate */
static int hf_rnsap_eDCH_DDI_Value = -1;          /* EDCH_DDI_Value */
static int hf_rnsap_mACd_PDU_Size_List = -1;      /* E_DCH_MACdPDU_SizeList */
static int hf_rnsap_E_DCH_MACdPDU_SizeList_item = -1;  /* E_DCH_MACdPDU_SizeListItem */
static int hf_rnsap_mACdPDU_Size = -1;            /* MACdPDU_Size */
static int hf_rnsap_E_DCH_LogicalChannelToModify_item = -1;  /* E_DCH_LogicalChannelToModifyItem */
static int hf_rnsap_mACd_PDU_Size_List1 = -1;     /* E_DCH_MACdPDU_SizeToModifyList */
static int hf_rnsap_E_DCH_MACdPDU_SizeToModifyList_item = -1;  /* E_DCH_MACdPDU_SizeListItem */
static int hf_rnsap_E_DCH_LogicalChannelToDelete_item = -1;  /* E_DCH_LogicalChannelToDeleteItem */
static int hf_rnsap_eDCH_MACdFlow_Specific_Information1 = -1;  /* EDCH_MACdFlow_Specific_InfoList */
static int hf_rnsap_EDCH_MACdFlow_Specific_InfoList_item = -1;  /* EDCH_MACdFlow_Specific_InfoItem */
static int hf_rnsap_eDSCH_MACdFlow_ID = -1;       /* EDCH_MACdFlow_ID */
static int hf_rnsap_tnlQoS = -1;                  /* TnlQos */
static int hf_rnsap_maxNr_Retransmissions_EDCH = -1;  /* MaxNr_Retransmissions_EDCH */
static int hf_rnsap_trafficClass = -1;            /* TrafficClass */
static int hf_rnsap_eDCH_HARQ_PO_FDD = -1;        /* E_DCH_HARQ_PO_FDD */
static int hf_rnsap_eDCH_MACdFlow_Multiplexing_List = -1;  /* E_DCH_MACdFlow_Multiplexing_List */
static int hf_rnsap_eDCH_Grant_Type_Information = -1;  /* E_DCH_Grant_Type_Information */
static int hf_rnsap_bundlingModeIndicator = -1;   /* BundlingModeIndicator */
static int hf_rnsap_eDCHLogicalChannelInformation = -1;  /* E_DCH_LogicalChannelInformation */
static int hf_rnsap_EDCH_MACdFlow_Specific_InfoToModifyList_item = -1;  /* EDCH_MACdFlow_Specific_InfoToModifyItem */
static int hf_rnsap_eDCH_LogicalChannelToAdd = -1;  /* E_DCH_LogicalChannelInformation */
static int hf_rnsap_eDCH_LogicalChannelToModify = -1;  /* E_DCH_LogicalChannelToModify */
static int hf_rnsap_eDCH_LogicalChannelToDelete = -1;  /* E_DCH_LogicalChannelToDelete */
static int hf_rnsap_EDCH_MACdFlows_To_Delete_item = -1;  /* EDCH_MACdFlows_To_Delete_Item */
static int hf_rnsap_maxBits_MACe_PDU_non_scheduled = -1;  /* Max_Bits_MACe_PDU_non_scheduled */
static int hf_rnsap_hARQ_Process_Allocation_2ms = -1;  /* HARQ_Process_Allocation_2ms_EDCH */
static int hf_rnsap_maxSet_E_DPDCHs = -1;         /* Max_Set_E_DPDCHs */
static int hf_rnsap_e_TFCS_Information = -1;      /* E_TFCS_Information */
static int hf_rnsap_e_TTI = -1;                   /* E_TTI */
static int hf_rnsap_e_DPCCH_PO = -1;              /* E_DPCCH_PO */
static int hf_rnsap_e_DCH_Serving_RL_in_this_DRNS = -1;  /* EDCH_Serving_RL_in_this_DRNS */
static int hf_rnsap_e_DCH_Serving_RL_not_in_this_DRNS = -1;  /* NULL */
static int hf_rnsap_e_DCH_Serving_RL_Id = -1;     /* RL_ID */
static int hf_rnsap_e_DCH_TFCI_Table_Index = -1;  /* E_DCH_TFCI_Table_Index */
static int hf_rnsap_e_DCH_Min_Set_E_TFCI = -1;    /* E_TFCI */
static int hf_rnsap_reference_E_TFCI_Information = -1;  /* Reference_E_TFCI_Information */
static int hf_rnsap_measurementTreshold = -1;     /* MeasurementThreshold */
static int hf_rnsap_measurementHysteresisTime = -1;  /* MeasurementHysteresisTime */
static int hf_rnsap_measurementIncreaseDecreaseThreshold = -1;  /* MeasurementIncreaseDecreaseThreshold */
static int hf_rnsap_measurementChangeTime = -1;   /* MeasurementChangeTime */
static int hf_rnsap_measurementThreshold1 = -1;   /* MeasurementThreshold */
static int hf_rnsap_measurementThreshold2 = -1;   /* MeasurementThreshold */
static int hf_rnsap_reportPeriodicity = -1;       /* ReportPeriodicity */
static int hf_rnsap_FACH_FlowControlInformation_item = -1;  /* FACH_FlowControlInformationItem */
static int hf_rnsap_fACH_SchedulingPriority = -1;  /* SchedulingPriorityIndicator */
static int hf_rnsap_fACH_InitialWindowSize = -1;  /* FACH_InitialWindowSize */
static int hf_rnsap_FACH_InformationList_item = -1;  /* FACH_InformationItem */
static int hf_rnsap_FACH_PCH_InformationList_item = -1;  /* FACH_PCH_InformationItem */
static int hf_rnsap_FDD_DCHs_to_Modify_item = -1;  /* FDD_DCHs_to_ModifyItem */
static int hf_rnsap_dCH_SpecificInformationList2 = -1;  /* FDD_DCHs_to_ModifySpecificInformationList */
static int hf_rnsap_FDD_DCHs_to_ModifySpecificInformationList_item = -1;  /* FDD_DCHs_to_ModifySpecificItem */
static int hf_rnsap_ul_TransportformatSet = -1;   /* TransportFormatSet */
static int hf_rnsap_dl_TransportformatSet = -1;   /* TransportFormatSet */
static int hf_rnsap_not_Used_dRACControl = -1;    /* NULL */
static int hf_rnsap_FDD_DL_CodeInformation_item = -1;  /* FDD_DL_CodeInformationItem */
static int hf_rnsap_dl_ScramblingCode = -1;       /* DL_ScramblingCode */
static int hf_rnsap_fDD_DL_ChannelisationCodeNumber = -1;  /* FDD_DL_ChannelisationCodeNumber */
static int hf_rnsap_transmission_Gap_Pattern_Sequence_ScramblingCode_Information = -1;  /* Transmission_Gap_Pattern_Sequence_ScramblingCode_Information */
static int hf_rnsap_wT = -1;                      /* INTEGER_1_4 */
static int hf_rnsap_GA_Cell_item = -1;            /* GA_Cell_item */
static int hf_rnsap_cell_GAIgeographicalCoordinate = -1;  /* GeographicalCoordinate */
static int hf_rnsap_pointWithUncertainty = -1;    /* GA_PointWithUnCertainty */
static int hf_rnsap_pointWithUncertaintyEllipse = -1;  /* GA_PointWithUnCertaintyEllipse */
static int hf_rnsap_pointWithAltitude = -1;       /* GA_PointWithAltitude */
static int hf_rnsap_pointWithAltitudeAndUncertaintyEllipsoid = -1;  /* GA_PointWithAltitudeAndUncertaintyEllipsoid */
static int hf_rnsap_ellipsoidArc = -1;            /* GA_EllipsoidArc */
static int hf_rnsap_directionOfAltitude = -1;     /* T_directionOfAltitude */
static int hf_rnsap_altitude = -1;                /* INTEGER_0_32767 */
static int hf_rnsap_geographicalCoordinates = -1;  /* GeographicalCoordinate */
static int hf_rnsap_innerRadius = -1;             /* INTEGER_0_65535 */
static int hf_rnsap_uncertaintyRadius = -1;       /* INTEGER_0_127 */
static int hf_rnsap_offsetAngle = -1;             /* INTEGER_0_179 */
static int hf_rnsap_includedAngle = -1;           /* INTEGER_0_179 */
static int hf_rnsap_confidence = -1;              /* INTEGER_0_127 */
static int hf_rnsap_altitudeAndDirection = -1;    /* GA_AltitudeAndDirection */
static int hf_rnsap_uncertaintyEllipse = -1;      /* GA_UncertaintyEllipse */
static int hf_rnsap_uncertaintyAltitude = -1;     /* INTEGER_0_127 */
static int hf_rnsap_uncertaintySemi_major = -1;   /* INTEGER_0_127 */
static int hf_rnsap_uncertaintySemi_minor = -1;   /* INTEGER_0_127 */
static int hf_rnsap_orientationOfMajorAxis = -1;  /* INTEGER_0_179 */
static int hf_rnsap_uncertaintyCode = -1;         /* INTEGER_0_127 */
static int hf_rnsap_geographicalCoordinate = -1;  /* GeographicalCoordinate */
static int hf_rnsap_latitudeSign = -1;            /* T_latitudeSign */
static int hf_rnsap_latitude = -1;                /* INTEGER_0_8388607 */
static int hf_rnsap_longitude = -1;               /* INTEGER_M8388608_8388607 */
static int hf_rnsap_sI = -1;                      /* GERAN_SystemInfo */
static int hf_rnsap_pSI = -1;                     /* GERAN_SystemInfo */
static int hf_rnsap_GERAN_SystemInfo_item = -1;   /* GERAN_SystemInfo_item */
static int hf_rnsap_gERAN_SI_block = -1;          /* OCTET_STRING_SIZE_1_23 */
static int hf_rnsap_wna_alm = -1;                 /* BIT_STRING_SIZE_8 */
static int hf_rnsap_satellite_Almanac_Information = -1;  /* T_satellite_Almanac_Information */
static int hf_rnsap_satellite_Almanac_Information_item = -1;  /* T_satellite_Almanac_Information_item */
static int hf_rnsap_dATA_ID = -1;                 /* DATA_ID */
static int hf_rnsap_gps_e_alm = -1;               /* BIT_STRING_SIZE_16 */
static int hf_rnsap_gps_toa_alm = -1;             /* BIT_STRING_SIZE_8 */
static int hf_rnsap_gps_delta_I_alm = -1;         /* BIT_STRING_SIZE_16 */
static int hf_rnsap_omegadot_alm = -1;            /* BIT_STRING_SIZE_16 */
static int hf_rnsap_svhealth_alm = -1;            /* BIT_STRING_SIZE_8 */
static int hf_rnsap_gps_a_sqrt_alm = -1;          /* BIT_STRING_SIZE_24 */
static int hf_rnsap_omegazero_alm = -1;           /* BIT_STRING_SIZE_24 */
static int hf_rnsap_m_zero_alm = -1;              /* BIT_STRING_SIZE_24 */
static int hf_rnsap_gps_omega_alm = -1;           /* BIT_STRING_SIZE_24 */
static int hf_rnsap_gps_af_zero_alm = -1;         /* BIT_STRING_SIZE_11 */
static int hf_rnsap_gps_af_one_alm = -1;          /* BIT_STRING_SIZE_11 */
static int hf_rnsap_sVGlobalHealth_alm = -1;      /* BIT_STRING_SIZE_364 */
static int hf_rnsap_Satellite_Almanac_Information_ExtItem_item = -1;  /* Satellite_Almanac_Information_ExtItem_item */
static int hf_rnsap_GPSInformation_item = -1;     /* GPSInformation_item */
static int hf_rnsap_gPSInformationItem = -1;      /* T_gPSInformationItem */
static int hf_rnsap_alpha_zero_ionos = -1;        /* BIT_STRING_SIZE_8 */
static int hf_rnsap_alpha_one_ionos = -1;         /* BIT_STRING_SIZE_8 */
static int hf_rnsap_alpha_two_ionos = -1;         /* BIT_STRING_SIZE_8 */
static int hf_rnsap_alpha_three_ionos = -1;       /* BIT_STRING_SIZE_8 */
static int hf_rnsap_beta_zero_ionos = -1;         /* BIT_STRING_SIZE_8 */
static int hf_rnsap_beta_one_ionos = -1;          /* BIT_STRING_SIZE_8 */
static int hf_rnsap_beta_two_ionos = -1;          /* BIT_STRING_SIZE_8 */
static int hf_rnsap_beta_three_ionos = -1;        /* BIT_STRING_SIZE_8 */
static int hf_rnsap_GPS_NavigationModel_and_TimeRecovery_item = -1;  /* GPS_NavigationModel_and_TimeRecovery_item */
static int hf_rnsap_tx_tow_nav = -1;              /* INTEGER_0_1048575 */
static int hf_rnsap_tlm_message_nav = -1;         /* BIT_STRING_SIZE_14 */
static int hf_rnsap_tlm_revd_c_nav = -1;          /* BIT_STRING_SIZE_2 */
static int hf_rnsap_ho_word_nav = -1;             /* BIT_STRING_SIZE_22 */
static int hf_rnsap_w_n_nav = -1;                 /* BIT_STRING_SIZE_10 */
static int hf_rnsap_ca_or_p_on_l2_nav = -1;       /* BIT_STRING_SIZE_2 */
static int hf_rnsap_user_range_accuracy_index_nav = -1;  /* BIT_STRING_SIZE_4 */
static int hf_rnsap_sv_health_nav = -1;           /* BIT_STRING_SIZE_6 */
static int hf_rnsap_iodc_nav = -1;                /* BIT_STRING_SIZE_10 */
static int hf_rnsap_l2_p_dataflag_nav = -1;       /* BIT_STRING_SIZE_1 */
static int hf_rnsap_sf1_reserved_nav = -1;        /* BIT_STRING_SIZE_87 */
static int hf_rnsap_t_gd_nav = -1;                /* BIT_STRING_SIZE_8 */
static int hf_rnsap_t_oc_nav = -1;                /* BIT_STRING_SIZE_16 */
static int hf_rnsap_a_f_2_nav = -1;               /* BIT_STRING_SIZE_8 */
static int hf_rnsap_a_f_1_nav = -1;               /* BIT_STRING_SIZE_16 */
static int hf_rnsap_a_f_zero_nav = -1;            /* BIT_STRING_SIZE_22 */
static int hf_rnsap_c_rs_nav = -1;                /* BIT_STRING_SIZE_16 */
static int hf_rnsap_delta_n_nav = -1;             /* BIT_STRING_SIZE_16 */
static int hf_rnsap_m_zero_nav = -1;              /* BIT_STRING_SIZE_32 */
static int hf_rnsap_c_uc_nav = -1;                /* BIT_STRING_SIZE_16 */
static int hf_rnsap_gps_e_nav = -1;               /* BIT_STRING_SIZE_32 */
static int hf_rnsap_c_us_nav = -1;                /* BIT_STRING_SIZE_16 */
static int hf_rnsap_a_sqrt_nav = -1;              /* BIT_STRING_SIZE_32 */
static int hf_rnsap_t_oe_nav = -1;                /* BIT_STRING_SIZE_16 */
static int hf_rnsap_fit_interval_flag_nav = -1;   /* BIT_STRING_SIZE_1 */
static int hf_rnsap_aodo_nav = -1;                /* BIT_STRING_SIZE_5 */
static int hf_rnsap_c_ic_nav = -1;                /* BIT_STRING_SIZE_16 */
static int hf_rnsap_omega_zero_nav = -1;          /* BIT_STRING_SIZE_32 */
static int hf_rnsap_c_is_nav = -1;                /* BIT_STRING_SIZE_16 */
static int hf_rnsap_i_zero_nav = -1;              /* BIT_STRING_SIZE_32 */
static int hf_rnsap_c_rc_nav = -1;                /* BIT_STRING_SIZE_16 */
static int hf_rnsap_gps_omega_nav = -1;           /* BIT_STRING_SIZE_32 */
static int hf_rnsap_omegadot_nav = -1;            /* BIT_STRING_SIZE_24 */
static int hf_rnsap_idot_nav = -1;                /* BIT_STRING_SIZE_14 */
static int hf_rnsap_spare_zero_fill = -1;         /* BIT_STRING_SIZE_20 */
static int hf_rnsap_badSatellites = -1;           /* BadSatellites */
static int hf_rnsap_noBadSatellite = -1;          /* NULL */
static int hf_rnsap_a_one_utc = -1;               /* BIT_STRING_SIZE_24 */
static int hf_rnsap_a_zero_utc = -1;              /* BIT_STRING_SIZE_32 */
static int hf_rnsap_t_ot_utc = -1;                /* BIT_STRING_SIZE_8 */
static int hf_rnsap_delta_t_ls_utc = -1;          /* BIT_STRING_SIZE_8 */
static int hf_rnsap_w_n_t_utc = -1;               /* BIT_STRING_SIZE_8 */
static int hf_rnsap_w_n_lsf_utc = -1;             /* BIT_STRING_SIZE_8 */
static int hf_rnsap_dn_utc = -1;                  /* BIT_STRING_SIZE_8 */
static int hf_rnsap_delta_t_lsf_utc = -1;         /* BIT_STRING_SIZE_8 */
static int hf_rnsap_guaranteed_UL_Rate = -1;      /* Guaranteed_Rate */
static int hf_rnsap_guaranteed_DL_Rate = -1;      /* Guaranteed_Rate */
static int hf_rnsap_implicit = -1;                /* HARQ_MemoryPartitioning_Implicit */
static int hf_rnsap_explicit = -1;                /* HARQ_MemoryPartitioning_Explicit */
static int hf_rnsap_number_of_Processes = -1;     /* INTEGER_1_8_ */
static int hf_rnsap_hARQ_MemoryPartitioningList = -1;  /* HARQ_MemoryPartitioningList */
static int hf_rnsap_HARQ_MemoryPartitioningList_item = -1;  /* HARQ_MemoryPartitioningItem */
static int hf_rnsap_process_Memory_Size = -1;     /* T_process_Memory_Size */
static int hf_rnsap_hSDSCH_MACdFlows_Information = -1;  /* HSDSCH_MACdFlows_Information */
static int hf_rnsap_uE_Capabilities_Info = -1;    /* UE_Capabilities_Info */
static int hf_rnsap_mAChs_Reordering_Buffer_Size_for_RLC_UM = -1;  /* MAChsReorderingBufferSize_for_RLC_UM */
static int hf_rnsap_cqiFeedback_CycleK = -1;      /* CQI_Feedback_Cycle */
static int hf_rnsap_cqiRepetitionFactor = -1;     /* CQI_RepetitionFactor */
static int hf_rnsap_ackNackRepetitionFactor = -1;  /* AckNack_RepetitionFactor */
static int hf_rnsap_cqiPowerOffset = -1;          /* CQI_Power_Offset */
static int hf_rnsap_ackPowerOffset = -1;          /* Ack_Power_Offset */
static int hf_rnsap_nackPowerOffset = -1;         /* Nack_Power_Offset */
static int hf_rnsap_hsscch_PowerOffset = -1;      /* HSSCCH_PowerOffset */
static int hf_rnsap_hSDSCH_MACdFlow_Specific_InfoList_Response = -1;  /* HSDSCH_MACdFlow_Specific_InfoList_Response */
static int hf_rnsap_hSSCCH_Specific_InfoList_Response = -1;  /* HSSCCH_FDD_Specific_InfoList_Response */
static int hf_rnsap_hSPDSCH_and_HSSCCH_ScramblingCode = -1;  /* DL_ScramblingCode */
static int hf_rnsap_measurement_Power_Offset = -1;  /* Measurement_Power_Offset */
static int hf_rnsap_hARQ_MemoryPartitioning = -1;  /* HARQ_MemoryPartitioning */
static int hf_rnsap_hSDSCH_MACdFlow_Specific_InfoList_to_Modify = -1;  /* HSDSCH_MACdFlow_Specific_InfoList_to_Modify */
static int hf_rnsap_priorityQueue_Info_to_Modify = -1;  /* PriorityQueue_InfoList_to_Modify */
static int hf_rnsap_hSSCCH_CodeChangeGrant = -1;  /* HSSCCH_Code_Change_Grant */
static int hf_rnsap_tDDAckNackPowerOffset = -1;   /* TDD_AckNack_Power_Offset */
static int hf_rnsap_priorityQueueInfotoModifyUnsynchronised = -1;  /* PriorityQueue_InfoList_to_Modify_Unsynchronised */
static int hf_rnsap_HSDSCH_MACdFlow_Specific_InfoList_item = -1;  /* HSDSCH_MACdFlow_Specific_InfoItem */
static int hf_rnsap_HSDSCH_MACdFlow_Specific_InfoList_Response_item = -1;  /* HSDSCH_MACdFlow_Specific_InfoItem_Response */
static int hf_rnsap_hSDSCH_Initial_Capacity_Allocation = -1;  /* HSDSCH_Initial_Capacity_Allocation */
static int hf_rnsap_HSDSCH_MACdFlow_Specific_InfoList_to_Modify_item = -1;  /* HSDSCH_MACdFlow_Specific_InfoItem_to_Modify */
static int hf_rnsap_hSDSCH_MACdFlow_Specific_Info = -1;  /* HSDSCH_MACdFlow_Specific_InfoList */
static int hf_rnsap_priorityQueue_Info = -1;      /* PriorityQueue_InfoList */
static int hf_rnsap_HSDSCH_MACdFlows_to_Delete_item = -1;  /* HSDSCH_MACdFlows_to_Delete_Item */
static int hf_rnsap_hsDSCH_MACdFlow_ID = -1;      /* HSDSCH_MACdFlow_ID */
static int hf_rnsap_HSDSCH_Initial_Capacity_Allocation_item = -1;  /* HSDSCH_Initial_Capacity_AllocationItem */
static int hf_rnsap_maximum_MACdPDU_Size = -1;    /* MACdPDU_Size */
static int hf_rnsap_hSDSCH_InitialWindowSize = -1;  /* HSDSCH_InitialWindowSize */
static int hf_rnsap_tDD_AckNack_Power_Offset = -1;  /* TDD_AckNack_Power_Offset */
static int hf_rnsap_hSSCCH_TDD_Specific_InfoList_Response = -1;  /* HSSCCH_TDD_Specific_InfoList_Response */
static int hf_rnsap_hSSCCH_TDD_Specific_InfoList_Response_LCR = -1;  /* HSSCCH_TDD_Specific_InfoList_Response_LCR */
static int hf_rnsap_hSPDSCH_TDD_Specific_InfoList_Response = -1;  /* HSPDSCH_TDD_Specific_InfoList_Response */
static int hf_rnsap_hSPDSCH_TDD_Specific_InfoList_Response_LCR = -1;  /* HSPDSCH_TDD_Specific_InfoList_Response_LCR */
static int hf_rnsap_HSPDSCH_TDD_Specific_InfoList_Response_item = -1;  /* HSPDSCH_TDD_Specific_InfoItem_Response */
static int hf_rnsap_HSPDSCH_TDD_Specific_InfoList_Response_LCR_item = -1;  /* HSPDSCH_TDD_Specific_InfoItem_Response_LCR */
static int hf_rnsap_HSSCCH_FDD_Specific_InfoList_Response_item = -1;  /* HSSCCH_FDD_Specific_InfoItem_Response */
static int hf_rnsap_code_Number = -1;             /* INTEGER_0_127 */
static int hf_rnsap_HSSCCH_TDD_Specific_InfoList_Response_item = -1;  /* HSSCCH_TDD_Specific_InfoItem_Response */
static int hf_rnsap_hSSICH_Info = -1;             /* HSSICH_Info */
static int hf_rnsap_HSSCCH_TDD_Specific_InfoList_Response_LCR_item = -1;  /* HSSCCH_TDD_Specific_InfoItem_Response_LCR */
static int hf_rnsap_first_TDD_ChannelisationCode = -1;  /* TDD_ChannelisationCode */
static int hf_rnsap_second_TDD_ChannelisationCode = -1;  /* TDD_ChannelisationCode */
static int hf_rnsap_hSSICH_InfoLCR = -1;          /* HSSICH_InfoLCR */
static int hf_rnsap_hsSICH_ID = -1;               /* HS_SICH_ID */
static int hf_rnsap_failed_HS_SICH = -1;          /* HS_SICH_failed */
static int hf_rnsap_missed_HS_SICH = -1;          /* HS_SICH_missed */
static int hf_rnsap_total_HS_SICH = -1;           /* HS_SICH_total */
static int hf_rnsap_hsSCCHCodeChangeIndicator = -1;  /* HSSCCH_CodeChangeIndicator */
static int hf_rnsap_onDemand = -1;                /* NULL */
static int hf_rnsap_periodic = -1;                /* PeriodicInformation */
static int hf_rnsap_onModification = -1;          /* OnModificationInformation */
static int hf_rnsap_min = -1;                     /* INTEGER_1_60_ */
static int hf_rnsap_hour = -1;                    /* INTEGER_1_24_ */
static int hf_rnsap_dGPSThreshold = -1;           /* DGPSThreshold */
static int hf_rnsap_informationTypeItem = -1;     /* T_informationTypeItem */
static int hf_rnsap_gPSInformation = -1;          /* GPSInformation */
static int hf_rnsap_iPDL_FDD_Parameters = -1;     /* IPDL_FDD_Parameters */
static int hf_rnsap_iPDL_TDD_Parameters = -1;     /* IPDL_TDD_Parameters */
static int hf_rnsap_extension_IPDLParameters = -1;  /* Extension_IPDLParameters */
static int hf_rnsap_iPSpacingFDD = -1;            /* IPSpacingFDD */
static int hf_rnsap_iPLength = -1;                /* IPLength */
static int hf_rnsap_iPOffset = -1;                /* IPOffset */
static int hf_rnsap_seed = -1;                    /* Seed */
static int hf_rnsap_burstModeParameters = -1;     /* BurstModeParameters */
static int hf_rnsap_iPSpacingTDD = -1;            /* IPSpacingTDD */
static int hf_rnsap_iPStart = -1;                 /* IPStart */
static int hf_rnsap_iPSlot = -1;                  /* IPSlot */
static int hf_rnsap_iP_P_CCPCH = -1;              /* IP_P_CCPCH */
static int hf_rnsap_iPSub = -1;                   /* IPSub */
static int hf_rnsap_uplinkLoadValue = -1;         /* INTEGER_0_100 */
static int hf_rnsap_downlinkLoadValue = -1;       /* INTEGER_0_100 */
static int hf_rnsap_MAC_c_sh_SDU_LengthList_item = -1;  /* MAC_c_sh_SDU_Length */
static int hf_rnsap_MACdPDU_Size_IndexList_item = -1;  /* MACdPDU_Size_IndexItem */
static int hf_rnsap_sID = -1;                     /* SID */
static int hf_rnsap_MACdPDU_Size_IndexList_to_Modify_item = -1;  /* MACdPDU_Size_IndexItem_to_Modify */
static int hf_rnsap_accessPointName = -1;         /* AccessPointName */
static int hf_rnsap_iPMulticastAddress = -1;      /* IPMulticastAddress */
static int hf_rnsap_MBMS_Bearer_Service_List_item = -1;  /* TMGI */
static int hf_rnsap_transmissionMode = -1;        /* TransmissionMode */
static int hf_rnsap_preferredFrequencyLayer = -1;  /* UARFCN */
static int hf_rnsap_tMGI = -1;                    /* TMGI */
static int hf_rnsap_pTM_Cell_List = -1;           /* PTMCellList */
static int hf_rnsap_pTP_Cell_List = -1;           /* PTPCellList */
static int hf_rnsap_not_Provided_Cell_List = -1;  /* NotProvidedCellList */
static int hf_rnsap_affectedUEInformationForMBMS = -1;  /* AffectedUEInformationForMBMS */
static int hf_rnsap_preferredFrequencyLayerInfo = -1;  /* PreferredFrequencyLayerInfo */
static int hf_rnsap_sir = -1;                     /* SIR_Value_IncrDecrThres */
static int hf_rnsap_sir_error = -1;               /* SIR_Error_Value_IncrDecrThres */
static int hf_rnsap_transmitted_code_power = -1;  /* Transmitted_Code_Power_Value_IncrDecrThres */
static int hf_rnsap_rscp = -1;                    /* RSCP_Value_IncrDecrThres */
static int hf_rnsap_round_trip_time = -1;         /* Round_Trip_Time_IncrDecrThres */
static int hf_rnsap_extension_MeasurementIncreaseDecreaseThreshold = -1;  /* Extension_MeasurementIncreaseDecreaseThreshold */
static int hf_rnsap_sir1 = -1;                    /* SIR_Value */
static int hf_rnsap_sir_error1 = -1;              /* SIR_Error_Value */
static int hf_rnsap_transmitted_code_power1 = -1;  /* Transmitted_Code_Power_Value */
static int hf_rnsap_rscp1 = -1;                   /* RSCP_Value */
static int hf_rnsap_rx_timing_deviation = -1;     /* Rx_Timing_Deviation_Value */
static int hf_rnsap_round_trip_time1 = -1;        /* Round_Trip_Time_Value */
static int hf_rnsap_extension_MeasurementThreshold = -1;  /* Extension_MeasurementThreshold */
static int hf_rnsap_type1 = -1;                   /* T_type1 */
static int hf_rnsap_midambleConfigurationBurstType1And3 = -1;  /* MidambleConfigurationBurstType1And3 */
static int hf_rnsap_midambleAllocationMode = -1;  /* T_midambleAllocationMode */
static int hf_rnsap_defaultMidamble = -1;         /* NULL */
static int hf_rnsap_commonMidamble = -1;          /* NULL */
static int hf_rnsap_ueSpecificMidamble = -1;      /* MidambleShiftLong */
static int hf_rnsap_type2 = -1;                   /* T_type2 */
static int hf_rnsap_midambleConfigurationBurstType2 = -1;  /* MidambleConfigurationBurstType2 */
static int hf_rnsap_midambleAllocationMode1 = -1;  /* T_midambleAllocationMode1 */
static int hf_rnsap_ueSpecificMidamble1 = -1;     /* MidambleShiftShort */
static int hf_rnsap_type3 = -1;                   /* T_type3 */
static int hf_rnsap_midambleAllocationMode2 = -1;  /* T_midambleAllocationMode2 */
static int hf_rnsap_midambleAllocationMode3 = -1;  /* MidambleAllocationMode */
static int hf_rnsap_midambleShift = -1;           /* MidambleShiftLong */
static int hf_rnsap_midambleConfigurationLCR = -1;  /* MidambleConfigurationLCR */
static int hf_rnsap_addPriorityQueue = -1;        /* PriorityQueue_InfoItem_to_Add */
static int hf_rnsap_modifyPriorityQueue = -1;     /* PriorityQueue_InfoItem_to_Modify */
static int hf_rnsap_deletePriorityQueue = -1;     /* PriorityQueue_Id */
static int hf_rnsap_gERAN_SI_Type = -1;           /* GERAN_SI_Type */
static int hf_rnsap_Neighbouring_UMTS_CellInformation_item = -1;  /* ProtocolIE_Single_Container */
static int hf_rnsap_rNC_ID = -1;                  /* RNC_ID */
static int hf_rnsap_cN_PS_DomainIdentifier = -1;  /* CN_PS_DomainIdentifier */
static int hf_rnsap_cN_CS_DomainIdentifier = -1;  /* CN_CS_DomainIdentifier */
static int hf_rnsap_neighbouring_FDD_CellInformation = -1;  /* Neighbouring_FDD_CellInformation */
static int hf_rnsap_neighbouring_TDD_CellInformation = -1;  /* Neighbouring_TDD_CellInformation */
static int hf_rnsap_Neighbouring_FDD_CellInformation_item = -1;  /* Neighbouring_FDD_CellInformationItem */
static int hf_rnsap_uARFCNforNu = -1;             /* UARFCN */
static int hf_rnsap_uARFCNforNd = -1;             /* UARFCN */
static int hf_rnsap_cellIndividualOffset = -1;    /* CellIndividualOffset */
static int hf_rnsap_txDiversityIndicator = -1;    /* TxDiversityIndicator */
static int hf_rnsap_sTTD_SupportIndicator = -1;   /* STTD_SupportIndicator */
static int hf_rnsap_closedLoopMode1_SupportIndicator = -1;  /* ClosedLoopMode1_SupportIndicator */
static int hf_rnsap_not_used_closedLoopMode2_SupportIndicator = -1;  /* NULL */
static int hf_rnsap_uARFCN = -1;                  /* UARFCN */
static int hf_rnsap_Neighbouring_GSM_CellInformationIEs_item = -1;  /* Neighbouring_GSM_CellInformationItem */
static int hf_rnsap_bSIC = -1;                    /* BSIC */
static int hf_rnsap_band_Indicator = -1;          /* Band_Indicator */
static int hf_rnsap_bCCH_ARFCN = -1;              /* BCCH_ARFCN */
static int hf_rnsap_Neighbouring_TDD_CellInformation_item = -1;  /* Neighbouring_TDD_CellInformationItem */
static int hf_rnsap_dPCHConstantValue = -1;       /* DPCHConstantValue */
static int hf_rnsap_Neighbouring_LCR_TDD_CellInformation_item = -1;  /* Neighbouring_LCR_TDD_CellInformationItem */
static int hf_rnsap_restrictionStateIndicator = -1;  /* RestrictionStateIndicator */
static int hf_rnsap_NotProvidedCellList_item = -1;  /* MBMSChannelTypeCellList */
static int hf_rnsap_uplinkNRTLoadInformationValue = -1;  /* INTEGER_0_3 */
static int hf_rnsap_downlinkNRTLoadInformationValue = -1;  /* INTEGER_0_3 */
static int hf_rnsap_measurementThreshold = -1;    /* MeasurementThreshold */
static int hf_rnsap_informationThreshold = -1;    /* InformationThreshold */
static int hf_rnsap_PCH_InformationList_item = -1;  /* PCH_InformationItem */
static int hf_rnsap_informationReportPeriodicity = -1;  /* InformationReportPeriodicity */
static int hf_rnsap_imsi = -1;                    /* IMSI */
static int hf_rnsap_defaultPreferredFrequency = -1;  /* UARFCN */
static int hf_rnsap_additionalPreferredFrequency = -1;  /* AdditionalPreferredFrequency */
static int hf_rnsap_PriorityQueue_InfoList_item = -1;  /* PriorityQueue_InfoItem */
static int hf_rnsap_priorityQueue_Id = -1;        /* PriorityQueue_Id */
static int hf_rnsap_associatedHSDSCH_MACdFlow = -1;  /* HSDSCH_MACdFlow_ID */
static int hf_rnsap_t1 = -1;                      /* T1 */
static int hf_rnsap_discardTimer = -1;            /* DiscardTimer */
static int hf_rnsap_mAC_hsWindowSize = -1;        /* MAC_hsWindowSize */
static int hf_rnsap_mAChsGuaranteedBitRate = -1;  /* MAChsGuaranteedBitRate */
static int hf_rnsap_mACdPDU_Size_Index = -1;      /* MACdPDU_Size_IndexList */
static int hf_rnsap_rLC_Mode = -1;                /* RLC_Mode */
static int hf_rnsap_PriorityQueue_InfoList_to_Modify_item = -1;  /* ModifyPriorityQueue */
static int hf_rnsap_mACdPDU_Size_Index_to_Modify = -1;  /* MACdPDU_Size_IndexList_to_Modify */
static int hf_rnsap_PriorityQueue_InfoList_to_Modify_Unsynchronised_item = -1;  /* PriorityQueue_InfoItem_to_Modify_Unsynchronised */
static int hf_rnsap_priorityQueueId = -1;         /* PriorityQueue_Id */
static int hf_rnsap_mBMSChannelTypeInfo = -1;     /* MBMSChannelTypeInfo */
static int hf_rnsap_mBMSPreferredFreqLayerInfo = -1;  /* MBMSPreferredFreqLayerInfo */
static int hf_rnsap_PTMCellList_item = -1;        /* MBMSChannelTypeCellList */
static int hf_rnsap_PTPCellList_item = -1;        /* MBMSChannelTypeCellList */
static int hf_rnsap_RB_Info_item = -1;            /* RB_Identity */
static int hf_rnsap_Reference_E_TFCI_Information_item = -1;  /* Reference_E_TFCI_Information_Item */
static int hf_rnsap_reference_E_TFCI = -1;        /* E_TFCI */
static int hf_rnsap_reference_E_TFCI_PO = -1;     /* Reference_E_TFCI_PO */
static int hf_rnsap_periodic1 = -1;               /* Periodic */
static int hf_rnsap_eventA = -1;                  /* EventA */
static int hf_rnsap_eventB = -1;                  /* EventB */
static int hf_rnsap_eventC = -1;                  /* EventC */
static int hf_rnsap_eventD = -1;                  /* EventD */
static int hf_rnsap_eventE = -1;                  /* EventE */
static int hf_rnsap_eventF = -1;                  /* EventF */
static int hf_rnsap_extension_ReportCharacteristics = -1;  /* Extension_ReportCharacteristics */
static int hf_rnsap_ten_msec = -1;                /* INTEGER_1_6000_ */
static int hf_rnsap_gA_AccessPointPositionwithAltitude = -1;  /* GA_AccessPointPositionwithOptionalAltitude */
static int hf_rnsap_iPDLParameters = -1;          /* IPDLParameters */
static int hf_rnsap_dGPSCorrections = -1;         /* DGPSCorrections */
static int hf_rnsap_gPS_NavigationModel_and_TimeRecovery = -1;  /* GPS_NavigationModel_and_TimeRecovery */
static int hf_rnsap_gPS_Ionospheric_Model = -1;   /* GPS_Ionospheric_Model */
static int hf_rnsap_gPS_UTC_Model = -1;           /* GPS_UTC_Model */
static int hf_rnsap_gPS_Almanac = -1;             /* GPS_Almanac */
static int hf_rnsap_gPS_RealTime_Integrity = -1;  /* GPS_RealTime_Integrity */
static int hf_rnsap_gPS_RX_POS = -1;              /* GPS_RX_POS */
static int hf_rnsap_sFNSFN_GA_AccessPointPosition = -1;  /* GA_AccessPointPositionwithOptionalAltitude */
static int hf_rnsap_informationAvailable = -1;    /* InformationAvailable */
static int hf_rnsap_informationNotAvailable = -1;  /* InformationNotAvailable */
static int hf_rnsap_RL_Specific_DCH_Info_item = -1;  /* RL_Specific_DCH_Info_Item */
static int hf_rnsap_dCH_id = -1;                  /* DCH_ID */
static int hf_rnsap_RL_Specific_EDCH_Information_item = -1;  /* RL_Specific_EDCH_InfoItem */
static int hf_rnsap_uplinkRTLoadValue = -1;       /* INTEGER_0_100 */
static int hf_rnsap_downlinkRTLoadValue = -1;     /* INTEGER_0_100 */
static int hf_rnsap_sAC = -1;                     /* SAC */
static int hf_rnsap_secondary_CCPCH_TDD_InformationList = -1;  /* Secondary_CCPCH_TDD_InformationList */
static int hf_rnsap_fACH_InformationList = -1;    /* FACH_InformationList */
static int hf_rnsap_pCH_InformationList = -1;     /* PCH_InformationList */
static int hf_rnsap_new_secondary_CPICH = -1;     /* Secondary_CPICH_Information */
static int hf_rnsap_secondary_CPICH_shall_not_be_used = -1;  /* NULL */
static int hf_rnsap_secondary_LCR_CCPCH_TDD_InformationList = -1;  /* Secondary_LCR_CCPCH_TDD_InformationList */
static int hf_rnsap_Secondary_CCPCH_TDD_InformationList_item = -1;  /* Secondary_CCPCH_TDD_InformationItem */
static int hf_rnsap_secondary_CCPCH_TDD_Code_Information = -1;  /* Secondary_CCPCH_TDD_Code_Information */
static int hf_rnsap_tDD_PhysicalChannelOffset = -1;  /* TDD_PhysicalChannelOffset */
static int hf_rnsap_Secondary_LCR_CCPCH_TDD_InformationList_item = -1;  /* Secondary_LCR_CCPCH_TDD_InformationItem */
static int hf_rnsap_secondary_LCR_CCPCH_TDD_Code_Information = -1;  /* Secondary_LCR_CCPCH_TDD_Code_Information */
static int hf_rnsap_Secondary_CCPCH_TDD_Code_Information_item = -1;  /* Secondary_CCPCH_TDD_Code_InformationItem */
static int hf_rnsap_Secondary_LCR_CCPCH_TDD_Code_Information_item = -1;  /* Secondary_LCR_CCPCH_TDD_Code_InformationItem */
static int hf_rnsap_s_CCPCH_TimeSlotFormat_LCR = -1;  /* TDD_DL_DPCH_TimeSlotFormat_LCR */
static int hf_rnsap_sFNSFNChangeLimit = -1;       /* SFNSFNChangeLimit */
static int hf_rnsap_predictedSFNSFNDeviationLimit = -1;  /* PredictedSFNSFNDeviationLimit */
static int hf_rnsap_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation = -1;  /* T_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation */
static int hf_rnsap_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item = -1;  /* T_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item */
static int hf_rnsap_sFNSFNValue = -1;             /* SFNSFNValue */
static int hf_rnsap_sFNSFNQuality = -1;           /* SFNSFNQuality */
static int hf_rnsap_sFNSFNDriftRate = -1;         /* SFNSFNDriftRate */
static int hf_rnsap_sFNSFNDriftRateQuality = -1;  /* SFNSFNDriftRateQuality */
static int hf_rnsap_sFNSFNTimeStampInformation = -1;  /* SFNSFNTimeStampInformation */
static int hf_rnsap_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation = -1;  /* T_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation */
static int hf_rnsap_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item = -1;  /* T_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item */
static int hf_rnsap_sFNSFNTimeStamp_FDD = -1;     /* SFN */
static int hf_rnsap_sFNSFNTimeStamp_TDD = -1;     /* SFNSFNTimeStamp_TDD */
static int hf_rnsap_sFN = -1;                     /* SFN */
static int hf_rnsap_sFNSFN_FDD = -1;              /* SFNSFN_FDD */
static int hf_rnsap_sFNSFN_TDD = -1;              /* SFNSFN_TDD */
static int hf_rnsap_listOfSNAs = -1;              /* ListOfSNAs */
static int hf_rnsap_ListOfSNAs_item = -1;         /* SNACode */
static int hf_rnsap_sRNTI_BitMaskIndex = -1;      /* T_sRNTI_BitMaskIndex */
static int hf_rnsap_n_INSYNC_IND = -1;            /* INTEGER_1_256 */
static int hf_rnsap_n_OUTSYNC_IND = -1;           /* INTEGER_1_256 */
static int hf_rnsap_t_RLFAILURE = -1;             /* INTEGER_0_255 */
static int hf_rnsap_maxSYNC_UL_transmissions = -1;  /* T_maxSYNC_UL_transmissions */
static int hf_rnsap_powerRampStep = -1;           /* INTEGER_0_3_ */
static int hf_rnsap_modulation = -1;              /* Modulation */
static int hf_rnsap_TDD_DCHs_to_Modify_item = -1;  /* TDD_DCHs_to_ModifyItem */
static int hf_rnsap_dCH_SpecificInformationList3 = -1;  /* TDD_DCHs_to_ModifySpecificInformationList */
static int hf_rnsap_TDD_DCHs_to_ModifySpecificInformationList_item = -1;  /* TDD_DCHs_to_ModifySpecificItem */
static int hf_rnsap_ul_CCTrCH_ID = -1;            /* CCTrCH_ID */
static int hf_rnsap_dl_CCTrCH_ID = -1;            /* CCTrCH_ID */
static int hf_rnsap_TDD_DL_Code_Information_item = -1;  /* TDD_DL_Code_InformationItem */
static int hf_rnsap_TDD_DL_Code_LCR_Information_item = -1;  /* TDD_DL_Code_LCR_InformationItem */
static int hf_rnsap_tdd_ChannelisationCodeLCR = -1;  /* TDD_ChannelisationCodeLCR */
static int hf_rnsap_tdd_DL_DPCH_TimeSlotFormat_LCR = -1;  /* TDD_DL_DPCH_TimeSlotFormat_LCR */
static int hf_rnsap_qPSK = -1;                    /* QPSK_DL_DPCH_TimeSlotFormatTDD_LCR */
static int hf_rnsap_eightPSK = -1;                /* EightPSK_DL_DPCH_TimeSlotFormatTDD_LCR */
static int hf_rnsap_initialOffset = -1;           /* INTEGER_0_255 */
static int hf_rnsap_noinitialOffset = -1;         /* INTEGER_0_63 */
static int hf_rnsap_TDD_UL_Code_Information_item = -1;  /* TDD_UL_Code_InformationItem */
static int hf_rnsap_TDD_UL_Code_LCR_Information_item = -1;  /* TDD_UL_Code_LCR_InformationItem */
static int hf_rnsap_tdd_UL_DPCH_TimeSlotFormat_LCR = -1;  /* TDD_UL_DPCH_TimeSlotFormat_LCR */
static int hf_rnsap_qPSK1 = -1;                   /* QPSK_UL_DPCH_TimeSlotFormatTDD_LCR */
static int hf_rnsap_eightPSK1 = -1;               /* EightPSK_UL_DPCH_TimeSlotFormatTDD_LCR */
static int hf_rnsap_plmn_id = -1;                 /* PLMN_Identity */
static int hf_rnsap_service_id = -1;              /* Service_ID */
static int hf_rnsap_dsField = -1;                 /* DsField */
static int hf_rnsap_genericTrafficCategory = -1;  /* GenericTrafficCategory */
static int hf_rnsap_Transmission_Gap_Pattern_Sequence_Information_item = -1;  /* Transmission_Gap_Pattern_Sequence_Information_item */
static int hf_rnsap_tGPSID = -1;                  /* TGPSID */
static int hf_rnsap_tGSN = -1;                    /* TGSN */
static int hf_rnsap_tGL1 = -1;                    /* GapLength */
static int hf_rnsap_tGL2 = -1;                    /* GapLength */
static int hf_rnsap_tGD = -1;                     /* TGD */
static int hf_rnsap_tGPL1 = -1;                   /* GapDuration */
static int hf_rnsap_not_to_be_used_1 = -1;        /* GapDuration */
static int hf_rnsap_uL_DL_mode = -1;              /* UL_DL_mode */
static int hf_rnsap_downlink_Compressed_Mode_Method = -1;  /* Downlink_Compressed_Mode_Method */
static int hf_rnsap_uplink_Compressed_Mode_Method = -1;  /* Uplink_Compressed_Mode_Method */
static int hf_rnsap_dL_FrameType = -1;            /* DL_FrameType */
static int hf_rnsap_delta_SIR1 = -1;              /* DeltaSIR */
static int hf_rnsap_delta_SIR_after1 = -1;        /* DeltaSIR */
static int hf_rnsap_delta_SIR2 = -1;              /* DeltaSIR */
static int hf_rnsap_delta_SIR_after2 = -1;        /* DeltaSIR */
static int hf_rnsap_Transmission_Gap_Pattern_Sequence_Status_List_item = -1;  /* Transmission_Gap_Pattern_Sequence_Status_List_item */
static int hf_rnsap_tGPRC = -1;                   /* TGPRC */
static int hf_rnsap_tGCFN = -1;                   /* CFN */
static int hf_rnsap_ms_part = -1;                 /* INTEGER_0_16383 */
static int hf_rnsap_ls_part = -1;                 /* INTEGER_0_4294967295 */
static int hf_rnsap_tUTRANGPSChangeLimit = -1;    /* TUTRANGPSChangeLimit */
static int hf_rnsap_predictedTUTRANGPSDeviationLimit = -1;  /* PredictedTUTRANGPSDeviationLimit */
static int hf_rnsap_tUTRANGPS = -1;               /* TUTRANGPS */
static int hf_rnsap_tUTRANGPSQuality = -1;        /* TUTRANGPSQuality */
static int hf_rnsap_tUTRANGPSDriftRate = -1;      /* TUTRANGPSDriftRate */
static int hf_rnsap_tUTRANGPSDriftRateQuality = -1;  /* TUTRANGPSDriftRateQuality */
static int hf_rnsap_iEe_Extensions = -1;          /* ProtocolExtensionContainer */
static int hf_rnsap_signalledGainFactors = -1;    /* T_signalledGainFactors */
static int hf_rnsap_betaC = -1;                   /* BetaCD */
static int hf_rnsap_betaD = -1;                   /* BetaCD */
static int hf_rnsap_refTFCNumber = -1;            /* RefTFCNumber */
static int hf_rnsap_tFCSvalues = -1;              /* T_tFCSvalues */
static int hf_rnsap_no_Split_in_TFCI = -1;        /* TFCS_TFCSList */
static int hf_rnsap_not_Used_split_in_TFCI = -1;  /* NULL */
static int hf_rnsap_TFCS_TFCSList_item = -1;      /* TFCS_TFCSList_item */
static int hf_rnsap_cTFC = -1;                    /* TFCS_CTFC */
static int hf_rnsap_tFC_Beta = -1;                /* TransportFormatCombination_Beta */
static int hf_rnsap_ctfc2bit = -1;                /* INTEGER_0_3 */
static int hf_rnsap_ctfc4bit = -1;                /* INTEGER_0_15 */
static int hf_rnsap_ctfc6bit = -1;                /* INTEGER_0_63 */
static int hf_rnsap_ctfc8bit = -1;                /* INTEGER_0_255 */
static int hf_rnsap_ctfc12bit = -1;               /* INTEGER_0_4095 */
static int hf_rnsap_ctfc16bit = -1;               /* INTEGER_0_65535 */
static int hf_rnsap_ctfcmaxbit = -1;              /* INTEGER_0_16777215 */
static int hf_rnsap_dynamicParts = -1;            /* TransportFormatSet_DynamicPartList */
static int hf_rnsap_semi_staticPart = -1;         /* TransportFormatSet_Semi_staticPart */
static int hf_rnsap_TransportFormatSet_DynamicPartList_item = -1;  /* TransportFormatSet_DynamicPartList_item */
static int hf_rnsap_nrOfTransportBlocks = -1;     /* NrOfTransportBlocks */
static int hf_rnsap_transportBlockSize = -1;      /* TransportBlockSize */
static int hf_rnsap_mode = -1;                    /* TransportFormatSet_ModeDP */
static int hf_rnsap_tdd = -1;                     /* TDD_TransportFormatSet_ModeDP */
static int hf_rnsap_notApplicable = -1;           /* NULL */
static int hf_rnsap_transmissionTimeIntervalInformation = -1;  /* TransmissionTimeIntervalInformation */
static int hf_rnsap_TransmissionTimeIntervalInformation_item = -1;  /* TransmissionTimeIntervalInformation_item */
static int hf_rnsap_transmissionTimeInterval = -1;  /* TransmissionTimeIntervalDynamic */
static int hf_rnsap_transmissionTime = -1;        /* TransmissionTimeIntervalSemiStatic */
static int hf_rnsap_channelCoding = -1;           /* ChannelCodingType */
static int hf_rnsap_codingRate = -1;              /* CodingRate */
static int hf_rnsap_rateMatcingAttribute = -1;    /* RateMatchingAttribute */
static int hf_rnsap_cRC_Size = -1;                /* CRC_Size */
static int hf_rnsap_mode1 = -1;                   /* TransportFormatSet_ModeSSP */
static int hf_rnsap_tdd1 = -1;                    /* SecondInterleavingMode */
static int hf_rnsap_hSDSCH_Physical_Layer_Category = -1;  /* INTEGER_1_64_ */
static int hf_rnsap_imei = -1;                    /* IMEI */
static int hf_rnsap_imeisv = -1;                  /* IMEISV */
static int hf_rnsap_periodic2 = -1;               /* UEMeasurementReportCharacteristicsPeriodic */
static int hf_rnsap_event1h = -1;                 /* UEMeasurementReportCharacteristicsEvent1h */
static int hf_rnsap_event1i = -1;                 /* UEMeasurementReportCharacteristicsEvent1i */
static int hf_rnsap_event6a = -1;                 /* UEMeasurementReportCharacteristicsEvent6a */
static int hf_rnsap_event6b = -1;                 /* UEMeasurementReportCharacteristicsEvent6b */
static int hf_rnsap_event6c = -1;                 /* UEMeasurementReportCharacteristicsEvent6c */
static int hf_rnsap_event6d = -1;                 /* UEMeasurementReportCharacteristicsEvent6d */
static int hf_rnsap_extension_ReportCharacteristics1 = -1;  /* UEMeasurementReportCharacteristics_Extension */
static int hf_rnsap_uEMeasurementTreshold = -1;   /* UEMeasurementThreshold */
static int hf_rnsap_uEMeasurementTimeToTrigger = -1;  /* UEMeasurementTimeToTrigger */
static int hf_rnsap_uEMeasurementHysteresisTime = -1;  /* UEMeasurementHysteresisTime */
static int hf_rnsap_amountofReporting = -1;       /* UEMeasurementReportCharacteristicsPeriodicAmountofReporting */
static int hf_rnsap_reportingInterval = -1;       /* UEMeasurementReportCharacteristicsPeriodicReportingInterval */
static int hf_rnsap_timeslotISCP = -1;            /* UEMeasurementThresholdDLTimeslotISCP */
static int hf_rnsap_uETransmitPower = -1;         /* UEMeasurementThresholdUETransmitPower */
static int hf_rnsap_extension_UEMeasurementThreshold = -1;  /* UEMeasurementThreshold_Extension */
static int hf_rnsap_UEMeasurementTimeslotInfoHCR_item = -1;  /* UEMeasurementTimeslotInfoHCR_IEs */
static int hf_rnsap_burstType = -1;               /* UEMeasurementTimeslotInfoHCRBurstType */
static int hf_rnsap_UEMeasurementTimeslotInfoLCR_item = -1;  /* UEMeasurementTimeslotInfoLCR_IEs */
static int hf_rnsap_timeSlot1 = -1;               /* TimeSlotLCR */
static int hf_rnsap_uE_Transmitted_Power = -1;    /* UE_MeasurementValue_UE_Transmitted_Power */
static int hf_rnsap_primary_CCPCH_RSCP = -1;      /* UE_MeasurementValue_Primary_CCPCH_RSCP */
static int hf_rnsap_dL_Timeslot_ISCP = -1;        /* UE_MeasurementValue_DL_Timeslot_ISCP */
static int hf_rnsap_extension_UEMeasurementValue = -1;  /* UEMeasurementValue_Extension */
static int hf_rnsap_uEMeasurementTransmittedPowerListHCR = -1;  /* UEMeasurementValueTransmittedPowerListHCR */
static int hf_rnsap_uEMeasurementTransmittedPowerListLCR = -1;  /* UEMeasurementValueTransmittedPowerListLCR */
static int hf_rnsap_UEMeasurementValueTransmittedPowerListHCR_item = -1;  /* UEMeasurementValueTransmittedPowerListHCR_IEs */
static int hf_rnsap_uETransmitPower1 = -1;        /* INTEGER_0_104 */
static int hf_rnsap_UEMeasurementValueTransmittedPowerListLCR_item = -1;  /* UEMeasurementValueTransmittedPowerListLCR_IEs */
static int hf_rnsap_primaryCCPCH_RSCP_Delta = -1;  /* PrimaryCCPCH_RSCP_Delta */
static int hf_rnsap_uEMeasurementTimeslotISCPListHCR = -1;  /* UEMeasurementValueTimeslotISCPListHCR */
static int hf_rnsap_uEMeasurementTimeslotISCPListLCR = -1;  /* UEMeasurementValueTimeslotISCPListLCR */
static int hf_rnsap_UEMeasurementValueTimeslotISCPListHCR_item = -1;  /* UEMeasurementValueTimeslotISCPListHCR_IEs */
static int hf_rnsap_UEMeasurementValueTimeslotISCPListLCR_item = -1;  /* UEMeasurementValueTimeslotISCPListLCR_IEs */
static int hf_rnsap_measurementAvailable2 = -1;   /* UEMeasurementValueInformationAvailable */
static int hf_rnsap_measurementnotAvailable2 = -1;  /* UEMeasurementValueInformationnotAvailable */
static int hf_rnsap_uEmeasurementValue = -1;      /* UEMeasurementValue */
static int hf_rnsap_cell_fach_pch = -1;           /* Cell_Fach_Pch_State */
static int hf_rnsap_ura_pch = -1;                 /* Ura_Pch_State */
static int hf_rnsap_d_RNTI = -1;                  /* D_RNTI */
static int hf_rnsap_srnc_id = -1;                 /* RNC_ID */
static int hf_rnsap_ura_id = -1;                  /* URA_ID */
static int hf_rnsap_UL_Timeslot_Information_item = -1;  /* UL_Timeslot_InformationItem */
static int hf_rnsap_UL_TimeslotLCR_Information_item = -1;  /* UL_TimeslotLCR_InformationItem */
static int hf_rnsap_uL_Code_LCR_InformationList = -1;  /* TDD_UL_Code_LCR_Information */
static int hf_rnsap_UL_TimeSlot_ISCP_Info_item = -1;  /* UL_TimeSlot_ISCP_InfoItem */
static int hf_rnsap_uL_TimeslotISCP = -1;         /* UL_TimeslotISCP */
static int hf_rnsap_UL_TimeSlot_ISCP_LCR_Info_item = -1;  /* UL_TimeSlot_ISCP_LCR_InfoItem */
static int hf_rnsap_iSCP = -1;                    /* UL_Timeslot_ISCP_Value */
static int hf_rnsap_sync_UL_codes_bitmap = -1;    /* BIT_STRING_SIZE_8 */
static int hf_rnsap_fPACH_info = -1;              /* FPACH_Information */
static int hf_rnsap_prxUpPCHdes = -1;             /* INTEGER_M120_M58_ */
static int hf_rnsap_syncUL_procParameter = -1;    /* SYNC_UL_ProcParameters */
static int hf_rnsap_mMax = -1;                    /* INTEGER_1_32 */
static int hf_rnsap_ul_ScramblingCodeNumber = -1;  /* UL_ScramblingCodeNumber */
static int hf_rnsap_ul_ScramblingCodeLength = -1;  /* UL_ScramblingCodeLength */
static int hf_rnsap_uL_Synchronisation_StepSize = -1;  /* UL_Synchronisation_StepSize */
static int hf_rnsap_uL_Synchronisation_Frequency = -1;  /* UL_Synchronisation_Frequency */
static int hf_rnsap_multipleURAsIndicator = -1;   /* MultipleURAsIndicator */
static int hf_rnsap_rNCsWithCellsInTheAccessedURA_List = -1;  /* RNCsWithCellsInTheAccessedURA_List */
static int hf_rnsap_RNCsWithCellsInTheAccessedURA_List_item = -1;  /* RNCsWithCellsInTheAccessedURA_Item */
static int hf_rnsap_USCH_Information_item = -1;   /* USCH_InformationItem */
static int hf_rnsap_local = -1;                   /* INTEGER_0_65535 */
static int hf_rnsap_global = -1;                  /* OBJECT_IDENTIFIER */
static int hf_rnsap_procedureCode = -1;           /* ProcedureCode */
static int hf_rnsap_ddMode = -1;                  /* T_ddMode */
static int hf_rnsap_shortTransActionId = -1;      /* INTEGER_0_127 */
static int hf_rnsap_longTransActionId = -1;       /* INTEGER_0_32767 */
static int hf_rnsap_ProtocolIE_Container_item = -1;  /* ProtocolIE_Field */
static int hf_rnsap_id = -1;                      /* ProtocolIE_ID */
static int hf_rnsap_value = -1;                   /* ProtocolIEValue */
static int hf_rnsap_ProtocolIE_ContainerPair_item = -1;  /* ProtocolIE_FieldPair */
static int hf_rnsap_firstCriticality = -1;        /* Criticality */
static int hf_rnsap_firstValue = -1;              /* FirstValue */
static int hf_rnsap_secondCriticality = -1;       /* Criticality */
static int hf_rnsap_secondValue = -1;             /* SecondValue */
static int hf_rnsap_ProtocolIE_ContainerList_item = -1;  /* ProtocolIE_Container */
static int hf_rnsap_ProtocolIE_ContainerPairList_item = -1;  /* ProtocolIE_ContainerPair */
static int hf_rnsap_ProtocolExtensionContainer_item = -1;  /* ProtocolExtensionField */
static int hf_rnsap_extensionValue = -1;          /* Extension */
static int hf_rnsap_PrivateIE_Container_item = -1;  /* PrivateIE_Field */
static int hf_rnsap_privateIEid = -1;             /* PrivateIE_ID */
static int hf_rnsap_privateIEvalue = -1;          /* PrivateIEvalue */

/*--- End of included file: packet-rnsap-hf.c ---*/
#line 562 "packet-rnsap-template.c"

/* Initialize the subtree pointers */
static int ett_rnsap = -1;
static int ett_rnsap_initiatingMessageValue = -1;
static int ett_rnsap_ProtocolIEValueValue = -1;
static int ett_rnsap_SuccessfulOutcomeValue = -1;
static int ett_rnsap_UnsuccessfulOutcomeValue = -1;


/*--- Included file: packet-rnsap-ett.c ---*/
#line 1 "packet-rnsap-ett.c"
static gint ett_rnsap_RNSAP_PDU = -1;
static gint ett_rnsap_InitiatingMessage = -1;
static gint ett_rnsap_SuccessfulOutcome = -1;
static gint ett_rnsap_UnsuccessfulOutcome = -1;
static gint ett_rnsap_Outcome = -1;
static gint ett_rnsap_DummyInitiatingValue = -1;
static gint ett_rnsap_DummySuccessfulOutcomeValue = -1;
static gint ett_rnsap_DummyUnSuccessfulOutcomeValue = -1;
static gint ett_rnsap_DummyProtocolIE = -1;
static gint ett_rnsap_RadioLinkSetupRequestFDD = -1;
static gint ett_rnsap_UL_DPCH_Information_RL_SetupRqstFDD = -1;
static gint ett_rnsap_DL_DPCH_Information_RL_SetupRqstFDD = -1;
static gint ett_rnsap_PowerOffsetInformation_RL_SetupRqstFDD = -1;
static gint ett_rnsap_RL_InformationList_RL_SetupRqstFDD = -1;
static gint ett_rnsap_RL_InformationItem_RL_SetupRqstFDD = -1;
static gint ett_rnsap_F_DPCH_Information_RL_SetupRqstFDD = -1;
static gint ett_rnsap_PowerOffsetInformation_F_DPCH_RL_SetupRqstFDD = -1;
static gint ett_rnsap_RadioLinkSetupRequestTDD = -1;
static gint ett_rnsap_UL_Physical_Channel_Information_RL_SetupRqstTDD = -1;
static gint ett_rnsap_DL_Physical_Channel_Information_RL_SetupRqstTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationList_RL_SetupRqstTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationItem_RL_SetupRqstTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationList_RL_SetupRqstTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationItem_RL_SetupRqstTDD = -1;
static gint ett_rnsap_CCTrCH_TPCList_RL_SetupRqstTDD = -1;
static gint ett_rnsap_CCTrCH_TPCItem_RL_SetupRqstTDD = -1;
static gint ett_rnsap_RL_Information_RL_SetupRqstTDD = -1;
static gint ett_rnsap_RadioLinkSetupResponseFDD = -1;
static gint ett_rnsap_RL_InformationResponseList_RL_SetupRspFDD = -1;
static gint ett_rnsap_RL_InformationResponseItem_RL_SetupRspFDD = -1;
static gint ett_rnsap_DiversityIndication_RL_SetupRspFDD = -1;
static gint ett_rnsap_Combining_RL_SetupRspFDD = -1;
static gint ett_rnsap_NonCombiningOrFirstRL_RL_SetupRspFDD = -1;
static gint ett_rnsap_RadioLinkSetupResponseTDD = -1;
static gint ett_rnsap_RL_InformationResponse_RL_SetupRspTDD = -1;
static gint ett_rnsap_UL_CCTrCHInformationListIE_RL_SetupRspTDD = -1;
static gint ett_rnsap_UL_CCTrCHInformationItem_RL_SetupRspTDD = -1;
static gint ett_rnsap_UL_DPCH_InformationItem_RL_SetupRspTDD = -1;
static gint ett_rnsap_DL_CCTrCHInformationListIE_RL_SetupRspTDD = -1;
static gint ett_rnsap_DL_CCTrCHInformationItem_RL_SetupRspTDD = -1;
static gint ett_rnsap_DL_DPCH_InformationItem_RL_SetupRspTDD = -1;
static gint ett_rnsap_DSCH_InformationListIEs_RL_SetupRspTDD = -1;
static gint ett_rnsap_DSCHInformationItem_RL_SetupRspTDD = -1;
static gint ett_rnsap_USCH_InformationListIEs_RL_SetupRspTDD = -1;
static gint ett_rnsap_USCHInformationItem_RL_SetupRspTDD = -1;
static gint ett_rnsap_RL_LCR_InformationResponse_RL_SetupRspTDD = -1;
static gint ett_rnsap_UL_LCR_CCTrCHInformationListIE_RL_SetupRspTDD = -1;
static gint ett_rnsap_UL_LCR_CCTrCHInformationItem_RL_SetupRspTDD = -1;
static gint ett_rnsap_UL_DPCH_LCR_InformationItem_RL_SetupRspTDD = -1;
static gint ett_rnsap_DL_CCTrCH_LCR_InformationListIE_RL_SetupRspTDD = -1;
static gint ett_rnsap_DL_CCTrCH_LCR_InformationItem_RL_SetupRspTDD = -1;
static gint ett_rnsap_DL_DPCH_LCR_InformationItem_RL_SetupRspTDD = -1;
static gint ett_rnsap_DSCH_LCR_InformationListIEs_RL_SetupRspTDD = -1;
static gint ett_rnsap_DSCH_LCR_InformationItem_RL_SetupRspTDD = -1;
static gint ett_rnsap_USCH_LCR_InformationListIEs_RL_SetupRspTDD = -1;
static gint ett_rnsap_USCH_LCR_InformationItem_RL_SetupRspTDD = -1;
static gint ett_rnsap_RadioLinkSetupFailureFDD = -1;
static gint ett_rnsap_CauseLevel_RL_SetupFailureFDD = -1;
static gint ett_rnsap_GeneralCauseList_RL_SetupFailureFDD = -1;
static gint ett_rnsap_RLSpecificCauseList_RL_SetupFailureFDD = -1;
static gint ett_rnsap_UnsuccessfulRL_InformationResponseList_RL_SetupFailureFDD = -1;
static gint ett_rnsap_UnsuccessfulRL_InformationResponse_RL_SetupFailureFDD = -1;
static gint ett_rnsap_SuccessfulRL_InformationResponseList_RL_SetupFailureFDD = -1;
static gint ett_rnsap_SuccessfulRL_InformationResponse_RL_SetupFailureFDD = -1;
static gint ett_rnsap_DiversityIndication_RL_SetupFailureFDD = -1;
static gint ett_rnsap_Combining_RL_SetupFailureFDD = -1;
static gint ett_rnsap_NonCombiningOrFirstRL_RL_SetupFailureFDD = -1;
static gint ett_rnsap_RadioLinkSetupFailureTDD = -1;
static gint ett_rnsap_CauseLevel_RL_SetupFailureTDD = -1;
static gint ett_rnsap_GeneralCauseList_RL_SetupFailureTDD = -1;
static gint ett_rnsap_RLSpecificCauseList_RL_SetupFailureTDD = -1;
static gint ett_rnsap_UnsuccessfulRL_InformationResponse_RL_SetupFailureTDD = -1;
static gint ett_rnsap_RadioLinkAdditionRequestFDD = -1;
static gint ett_rnsap_RL_InformationList_RL_AdditionRqstFDD = -1;
static gint ett_rnsap_RL_Information_RL_AdditionRqstFDD = -1;
static gint ett_rnsap_RadioLinkAdditionRequestTDD = -1;
static gint ett_rnsap_RL_Information_RL_AdditionRqstTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationList_RL_AdditionRqstTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationItem_RL_AdditionRqstTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationList_RL_AdditionRqstTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationItem_RL_AdditionRqstTDD = -1;
static gint ett_rnsap_RadioLinkAdditionResponseFDD = -1;
static gint ett_rnsap_RL_InformationResponseList_RL_AdditionRspFDD = -1;
static gint ett_rnsap_RL_InformationResponseItem_RL_AdditionRspFDD = -1;
static gint ett_rnsap_DiversityIndication_RL_AdditionRspFDD = -1;
static gint ett_rnsap_Combining_RL_AdditionRspFDD = -1;
static gint ett_rnsap_NonCombining_RL_AdditionRspFDD = -1;
static gint ett_rnsap_RadioLinkAdditionResponseTDD = -1;
static gint ett_rnsap_RL_InformationResponse_RL_AdditionRspTDD = -1;
static gint ett_rnsap_UL_CCTrCHInformationListIE_RL_AdditionRspTDD = -1;
static gint ett_rnsap_UL_CCTrCHInformationItem_RL_AdditionRspTDD = -1;
static gint ett_rnsap_UL_DPCH_InformationItem_RL_AdditionRspTDD = -1;
static gint ett_rnsap_DL_CCTrCHInformationListIE_RL_AdditionRspTDD = -1;
static gint ett_rnsap_DL_CCTrCHInformationItem_RL_AdditionRspTDD = -1;
static gint ett_rnsap_DL_DPCH_InformationItem_RL_AdditionRspTDD = -1;
static gint ett_rnsap_DCH_Information_RL_AdditionRspTDD = -1;
static gint ett_rnsap_DiversityIndication_RL_AdditionRspTDD = -1;
static gint ett_rnsap_Combining_RL_AdditionRspTDD = -1;
static gint ett_rnsap_NonCombining_RL_AdditionRspTDD = -1;
static gint ett_rnsap_DSCH_InformationListIE_RL_AdditionRspTDD = -1;
static gint ett_rnsap_DSCHInformationItem_RL_AdditionRspTDD = -1;
static gint ett_rnsap_DiversityIndication_RL_AdditionRspTDD2 = -1;
static gint ett_rnsap_USCH_InformationListIE_RL_AdditionRspTDD = -1;
static gint ett_rnsap_USCHInformationItem_RL_AdditionRspTDD = -1;
static gint ett_rnsap_RL_LCR_InformationResponse_RL_AdditionRspTDD = -1;
static gint ett_rnsap_UL_CCTrCH_LCR_InformationListIE_RL_AdditionRspTDD = -1;
static gint ett_rnsap_UL_CCTrCH_LCR_InformationItem_RL_AdditionRspTDD = -1;
static gint ett_rnsap_UL_DPCH_LCR_InformationItem_RL_AdditionRspTDD = -1;
static gint ett_rnsap_DL_CCTrCH_LCR_InformationListIE_RL_AdditionRspTDD = -1;
static gint ett_rnsap_DL_CCTrCH_LCR_InformationItem_RL_AdditionRspTDD = -1;
static gint ett_rnsap_DL_DPCH_LCR_InformationItem_RL_AdditionRspTDD = -1;
static gint ett_rnsap_DSCH_LCR_InformationListIEs_RL_AdditionRspTDD = -1;
static gint ett_rnsap_DSCH_LCR_InformationItem_RL_AdditionRspTDD = -1;
static gint ett_rnsap_USCH_LCR_InformationListIEs_RL_AdditionRspTDD = -1;
static gint ett_rnsap_USCH_LCR_InformationItem_RL_AdditionRspTDD = -1;
static gint ett_rnsap_RadioLinkAdditionFailureFDD = -1;
static gint ett_rnsap_CauseLevel_RL_AdditionFailureFDD = -1;
static gint ett_rnsap_GeneralCauseList_RL_AdditionFailureFDD = -1;
static gint ett_rnsap_RLSpecificCauseList_RL_AdditionFailureFDD = -1;
static gint ett_rnsap_UnsuccessfulRL_InformationResponseList_RL_AdditionFailureFDD = -1;
static gint ett_rnsap_UnsuccessfulRL_InformationResponse_RL_AdditionFailureFDD = -1;
static gint ett_rnsap_SuccessfulRL_InformationResponseList_RL_AdditionFailureFDD = -1;
static gint ett_rnsap_SuccessfulRL_InformationResponse_RL_AdditionFailureFDD = -1;
static gint ett_rnsap_DiversityIndication_RL_AdditionFailureFDD = -1;
static gint ett_rnsap_Combining_RL_AdditionFailureFDD = -1;
static gint ett_rnsap_NonCombining_RL_AdditionFailureFDD = -1;
static gint ett_rnsap_RadioLinkAdditionFailureTDD = -1;
static gint ett_rnsap_CauseLevel_RL_AdditionFailureTDD = -1;
static gint ett_rnsap_GeneralCauseList_RL_AdditionFailureTDD = -1;
static gint ett_rnsap_RLSpecificCauseList_RL_AdditionFailureTDD = -1;
static gint ett_rnsap_UnsuccessfulRL_InformationResponse_RL_AdditionFailureTDD = -1;
static gint ett_rnsap_RadioLinkDeletionRequest = -1;
static gint ett_rnsap_RL_InformationList_RL_DeletionRqst = -1;
static gint ett_rnsap_RL_Information_RL_DeletionRqst = -1;
static gint ett_rnsap_RadioLinkDeletionResponse = -1;
static gint ett_rnsap_RadioLinkReconfigurationPrepareFDD = -1;
static gint ett_rnsap_UL_DPCH_Information_RL_ReconfPrepFDD = -1;
static gint ett_rnsap_DL_DPCH_Information_RL_ReconfPrepFDD = -1;
static gint ett_rnsap_DL_DPCH_Power_Information_RL_ReconfPrepFDD = -1;
static gint ett_rnsap_PowerOffsetInformation_RL_ReconfPrepFDD = -1;
static gint ett_rnsap_DCH_DeleteList_RL_ReconfPrepFDD = -1;
static gint ett_rnsap_DCH_DeleteItem_RL_ReconfPrepFDD = -1;
static gint ett_rnsap_RL_InformationList_RL_ReconfPrepFDD = -1;
static gint ett_rnsap_RL_Information_RL_ReconfPrepFDD = -1;
static gint ett_rnsap_F_DPCH_Information_RL_ReconfPrepFDD = -1;
static gint ett_rnsap_PowerOffsetInformation_F_DPCH_RL_ReconfPrepFDD = -1;
static gint ett_rnsap_RadioLinkReconfigurationPrepareTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationAddList_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_UL_CCTrCH_AddInformation_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_UL_CCTrCH_ModifyInformation_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_UL_CCTrCH_DeleteInformation_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationAddList_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationAddItem_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_CCTrCH_TPCAddList_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_CCTrCH_TPCAddItem_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationModifyItem_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_CCTrCH_TPCModifyList_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_CCTrCH_TPCModifyItem_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationDeleteItem_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_DCH_DeleteList_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_DCH_DeleteItem_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_DSCH_ModifyList_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_DSCH_ModifyItem_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_DSCH_DeleteList_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_DSCH_DeleteItem_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_USCH_ModifyList_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_USCH_ModifyItem_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_USCH_DeleteList_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_USCH_DeleteItem_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_RL_Information_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_RL_InformationIE_RL_ReconfPrepTDD = -1;
static gint ett_rnsap_RadioLinkReconfigurationReadyFDD = -1;
static gint ett_rnsap_RL_InformationResponseList_RL_ReconfReadyFDD = -1;
static gint ett_rnsap_RL_InformationResponseItem_RL_ReconfReadyFDD = -1;
static gint ett_rnsap_RadioLinkReconfigurationReadyTDD = -1;
static gint ett_rnsap_RL_InformationResponse_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_UL_CCTrCHInformationListIE_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_UL_DPCH_LCR_InformationAddList_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_UL_DPCH_InformationAddListIE_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_UL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_UL_TimeslotLCR_InformationModifyList_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_UL_TimeslotLCR_InformationModifyItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_TDD_UL_Code_LCR_InformationModifyList_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_TDD_UL_Code_LCR_InformationModifyItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_UL_Timeslot_InformationModifyList_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_UL_Timeslot_InformationModifyItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_TDD_UL_Code_InformationModifyList_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_TDD_UL_Code_InformationModifyItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_UL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_UL_DPCH_InformationDeleteItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DL_CCTrCHInformationListIE_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DL_DPCH_LCR_InformationAddList_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DL_DPCH_InformationAddListIE_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DL_TimeslotLCR_InformationModifyList_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DL_TimeslotLCR_InformationModifyItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_TDD_DL_Code_LCR_InformationModifyList_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_TDD_DL_Code_LCR_InformationModifyItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DL_Timeslot_InformationModifyList_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DL_Timeslot_InformationModifyItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_TDD_DL_Code_InformationModifyList_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_TDD_DL_Code_InformationModifyItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DL_DPCH_InformationDeleteItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DSCHToBeAddedOrModifiedList_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_DSCHToBeAddedOrModifiedItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_USCHToBeAddedOrModifiedList_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_USCHToBeAddedOrModifiedItem_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_Multiple_RL_InformationResponse_RL_ReconfReadyTDD = -1;
static gint ett_rnsap_RadioLinkReconfigurationCommit = -1;
static gint ett_rnsap_RadioLinkReconfigurationFailure = -1;
static gint ett_rnsap_CauseLevel_RL_ReconfFailure = -1;
static gint ett_rnsap_GeneralCauseList_RL_ReconfFailure = -1;
static gint ett_rnsap_RLSpecificCauseList_RL_ReconfFailure = -1;
static gint ett_rnsap_RL_ReconfigurationFailureList_RL_ReconfFailure = -1;
static gint ett_rnsap_RL_ReconfigurationFailure_RL_ReconfFail = -1;
static gint ett_rnsap_RadioLinkReconfigurationCancel = -1;
static gint ett_rnsap_RadioLinkReconfigurationRequestFDD = -1;
static gint ett_rnsap_UL_DPCH_Information_RL_ReconfRqstFDD = -1;
static gint ett_rnsap_DL_DPCH_Information_RL_ReconfRqstFDD = -1;
static gint ett_rnsap_DCH_DeleteList_RL_ReconfRqstFDD = -1;
static gint ett_rnsap_DCH_DeleteItem_RL_ReconfRqstFDD = -1;
static gint ett_rnsap_RL_ReconfigurationRequestFDD_RL_InformationList = -1;
static gint ett_rnsap_RL_ReconfigurationRequestFDD_RL_Information_IEs = -1;
static gint ett_rnsap_RadioLinkReconfigurationRequestTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD = -1;
static gint ett_rnsap_DCH_DeleteList_RL_ReconfRqstTDD = -1;
static gint ett_rnsap_DCH_DeleteItem_RL_ReconfRqstTDD = -1;
static gint ett_rnsap_Multiple_RL_ReconfigurationRequestTDD_RL_Information = -1;
static gint ett_rnsap_RL_ReconfigurationRequestTDD_RL_Information = -1;
static gint ett_rnsap_RadioLinkReconfigurationResponseFDD = -1;
static gint ett_rnsap_RL_InformationResponseList_RL_ReconfRspFDD = -1;
static gint ett_rnsap_RL_InformationResponseItem_RL_ReconfRspFDD = -1;
static gint ett_rnsap_RadioLinkReconfigurationResponseTDD = -1;
static gint ett_rnsap_RL_InformationResponse_RL_ReconfRspTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationList_RL_ReconfRspTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationItem_RL_ReconfRspTDD = -1;
static gint ett_rnsap_DL_DPCH_InformationModifyItem_LCR_RL_ReconfRspTDD = -1;
static gint ett_rnsap_DL_Timeslot_LCR_InformationModifyList_RL_ReconfRspTDD = -1;
static gint ett_rnsap_DL_Timeslot_LCR_InformationModifyItem_RL_ReconfRspTDD = -1;
static gint ett_rnsap_Multiple_RL_InformationResponse_RL_ReconfRspTDD = -1;
static gint ett_rnsap_RadioLinkFailureIndication = -1;
static gint ett_rnsap_Reporting_Object_RL_FailureInd = -1;
static gint ett_rnsap_RL_RL_FailureInd = -1;
static gint ett_rnsap_RL_InformationList_RL_FailureInd = -1;
static gint ett_rnsap_RL_Information_RL_FailureInd = -1;
static gint ett_rnsap_RL_Set_RL_FailureInd = -1;
static gint ett_rnsap_RL_Set_InformationList_RL_FailureInd = -1;
static gint ett_rnsap_RL_Set_Information_RL_FailureInd = -1;
static gint ett_rnsap_CCTrCH_RL_FailureInd = -1;
static gint ett_rnsap_CCTrCH_InformationList_RL_FailureInd = -1;
static gint ett_rnsap_CCTrCH_InformationItem_RL_FailureInd = -1;
static gint ett_rnsap_RadioLinkPreemptionRequiredIndication = -1;
static gint ett_rnsap_RL_InformationList_RL_PreemptRequiredInd = -1;
static gint ett_rnsap_RL_InformationItem_RL_PreemptRequiredInd = -1;
static gint ett_rnsap_HSDSCHMacdFlowSpecificInformationList_RL_PreemptRequiredInd = -1;
static gint ett_rnsap_HSDSCHMacdFlowSpecificInformationItem_RL_PreemptRequiredInd = -1;
static gint ett_rnsap_EDCH_MacdFlowSpecificInformationList_RL_PreemptRequiredInd = -1;
static gint ett_rnsap_EDCH_MacdFlowSpecificInformationItem_RL_PreemptRequiredInd = -1;
static gint ett_rnsap_RadioLinkRestoreIndication = -1;
static gint ett_rnsap_Reporting_Object_RL_RestoreInd = -1;
static gint ett_rnsap_RL_RL_RestoreInd = -1;
static gint ett_rnsap_RL_InformationList_RL_RestoreInd = -1;
static gint ett_rnsap_RL_Information_RL_RestoreInd = -1;
static gint ett_rnsap_RL_Set_RL_RestoreInd = -1;
static gint ett_rnsap_RL_Set_InformationList_RL_RestoreInd = -1;
static gint ett_rnsap_RL_Set_Information_RL_RestoreInd = -1;
static gint ett_rnsap_CCTrCH_RL_RestoreInd = -1;
static gint ett_rnsap_CCTrCH_InformationList_RL_RestoreInd = -1;
static gint ett_rnsap_CCTrCH_InformationItem_RL_RestoreInd = -1;
static gint ett_rnsap_DL_PowerControlRequest = -1;
static gint ett_rnsap_DL_ReferencePowerInformationList_DL_PC_Rqst = -1;
static gint ett_rnsap_DL_ReferencePowerInformation_DL_PC_Rqst = -1;
static gint ett_rnsap_DL_PowerTimeslotControlRequest = -1;
static gint ett_rnsap_PhysicalChannelReconfigurationRequestFDD = -1;
static gint ett_rnsap_RL_Information_PhyChReconfRqstFDD = -1;
static gint ett_rnsap_PhysicalChannelReconfigurationRequestTDD = -1;
static gint ett_rnsap_RL_Information_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationListIE_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_UL_CCTrCH_InformationItem_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_UL_DPCH_InformationItem_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_UL_TimeslotLCR_InformationList_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_UL_TimeslotLCR_InformationItem_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_UL_Timeslot_InformationList_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_UL_Timeslot_InformationItem_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationListIE_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_DL_CCTrCH_InformationItem_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_DL_DPCH_InformationItem_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_DL_TimeslotLCR_InformationList_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_DL_TimeslotLCR_InformationItem_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_DL_Timeslot_InformationList_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_DL_Timeslot_InformationItem_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_HSPDSCH_Timeslot_InformationList_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_HSPDSCH_Timeslot_InformationItem_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_HSPDSCH_Timeslot_InformationListLCR_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_HSPDSCH_Timeslot_InformationItemLCR_PhyChReconfRqstTDD = -1;
static gint ett_rnsap_PhysicalChannelReconfigurationCommand = -1;
static gint ett_rnsap_PhysicalChannelReconfigurationFailure = -1;
static gint ett_rnsap_RadioLinkCongestionIndication = -1;
static gint ett_rnsap_RL_InformationList_RL_CongestInd = -1;
static gint ett_rnsap_RL_InformationItem_RL_CongestInd = -1;
static gint ett_rnsap_DCH_Rate_Information_RL_CongestInd = -1;
static gint ett_rnsap_DCH_Rate_InformationItem_RL_CongestInd = -1;
static gint ett_rnsap_EDCH_MacdFlowSpecificInformationList_RL_CongestInd = -1;
static gint ett_rnsap_EDCH_MacdFlowSpecificInformationItem_RL_CongestInd = -1;
static gint ett_rnsap_UplinkSignallingTransferIndicationFDD = -1;
static gint ett_rnsap_UplinkSignallingTransferIndicationTDD = -1;
static gint ett_rnsap_DownlinkSignallingTransferRequest = -1;
static gint ett_rnsap_RelocationCommit = -1;
static gint ett_rnsap_PagingRequest = -1;
static gint ett_rnsap_PagingArea_PagingRqst = -1;
static gint ett_rnsap_URA_PagingRqst = -1;
static gint ett_rnsap_Cell_PagingRqst = -1;
static gint ett_rnsap_CNOriginatedPage_PagingRqst = -1;
static gint ett_rnsap_DedicatedMeasurementInitiationRequest = -1;
static gint ett_rnsap_DedicatedMeasurementObjectType_DM_Rqst = -1;
static gint ett_rnsap_RL_DM_Rqst = -1;
static gint ett_rnsap_RL_InformationList_DM_Rqst = -1;
static gint ett_rnsap_RL_InformationItem_DM_Rqst = -1;
static gint ett_rnsap_HSSICH_Info_DM_Rqst = -1;
static gint ett_rnsap_RL_Set_DM_Rqst = -1;
static gint ett_rnsap_RL_Set_InformationList_DM_Rqst = -1;
static gint ett_rnsap_RL_Set_InformationItem_DM_Rqst = -1;
static gint ett_rnsap_DedicatedMeasurementInitiationResponse = -1;
static gint ett_rnsap_DedicatedMeasurementObjectType_DM_Rsp = -1;
static gint ett_rnsap_RL_DM_Rsp = -1;
static gint ett_rnsap_RL_Set_DM_Rsp = -1;
static gint ett_rnsap_RL_InformationList_DM_Rsp = -1;
static gint ett_rnsap_RL_InformationItem_DM_Rsp = -1;
static gint ett_rnsap_RL_Set_InformationList_DM_Rsp = -1;
static gint ett_rnsap_RL_Set_InformationItem_DM_Rsp = -1;
static gint ett_rnsap_Multiple_DedicatedMeasurementValueList_TDD_DM_Rsp = -1;
static gint ett_rnsap_Multiple_DedicatedMeasurementValueItem_TDD_DM_Rsp = -1;
static gint ett_rnsap_Multiple_DedicatedMeasurementValueList_LCR_TDD_DM_Rsp = -1;
static gint ett_rnsap_Multiple_DedicatedMeasurementValueItem_LCR_TDD_DM_Rsp = -1;
static gint ett_rnsap_DedicatedMeasurementInitiationFailure = -1;
static gint ett_rnsap_DedicatedMeasurementObjectType_DM_Fail = -1;
static gint ett_rnsap_RL_DM_Fail = -1;
static gint ett_rnsap_RL_Set_DM_Fail = -1;
static gint ett_rnsap_RL_Unsuccessful_InformationRespList_DM_Fail = -1;
static gint ett_rnsap_RL_Unsuccessful_InformationItem_DM_Fail = -1;
static gint ett_rnsap_RL_Successful_InformationRespList_DM_Fail = -1;
static gint ett_rnsap_RL_Successful_InformationItem_DM_Fail = -1;
static gint ett_rnsap_RL_Set_Unsuccessful_InformationRespList_DM_Fail = -1;
static gint ett_rnsap_RL_Set_Unsuccessful_InformationItem_DM_Fail = -1;
static gint ett_rnsap_RL_Set_Successful_InformationRespList_DM_Fail = -1;
static gint ett_rnsap_RL_Set_Successful_InformationItem_DM_Fail = -1;
static gint ett_rnsap_DedicatedMeasurementReport = -1;
static gint ett_rnsap_DedicatedMeasurementObjectType_DM_Rprt = -1;
static gint ett_rnsap_RL_DM_Rprt = -1;
static gint ett_rnsap_RL_Set_DM_Rprt = -1;
static gint ett_rnsap_RL_InformationList_DM_Rprt = -1;
static gint ett_rnsap_RL_InformationItem_DM_Rprt = -1;
static gint ett_rnsap_RL_Set_InformationList_DM_Rprt = -1;
static gint ett_rnsap_RL_Set_InformationItem_DM_Rprt = -1;
static gint ett_rnsap_DedicatedMeasurementTerminationRequest = -1;
static gint ett_rnsap_DedicatedMeasurementFailureIndication = -1;
static gint ett_rnsap_DedicatedMeasurementObjectType_DM_Fail_Ind = -1;
static gint ett_rnsap_RL_DM_Fail_Ind = -1;
static gint ett_rnsap_RL_Set_DM_Fail_Ind = -1;
static gint ett_rnsap_RL_Unsuccessful_InformationRespList_DM_Fail_Ind = -1;
static gint ett_rnsap_RL_Unsuccessful_InformationItem_DM_Fail_Ind = -1;
static gint ett_rnsap_RL_Set_Unsuccessful_InformationRespList_DM_Fail_Ind = -1;
static gint ett_rnsap_RL_Set_Unsuccessful_InformationItem_DM_Fail_Ind = -1;
static gint ett_rnsap_CommonTransportChannelResourcesReleaseRequest = -1;
static gint ett_rnsap_CommonTransportChannelResourcesRequest = -1;
static gint ett_rnsap_CommonTransportChannelResourcesResponseFDD = -1;
static gint ett_rnsap_FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspFDD = -1;
static gint ett_rnsap_CommonTransportChannelResourcesResponseTDD = -1;
static gint ett_rnsap_FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspTDD = -1;
static gint ett_rnsap_CommonTransportChannelResourcesFailure = -1;
static gint ett_rnsap_CompressedModeCommand = -1;
static gint ett_rnsap_ErrorIndication = -1;
static gint ett_rnsap_CommonMeasurementInitiationRequest = -1;
static gint ett_rnsap_CommonMeasurementObjectType_CM_Rqst = -1;
static gint ett_rnsap_Cell_CM_Rqst = -1;
static gint ett_rnsap_NeighbouringCellMeasurementInfo = -1;
static gint ett_rnsap_NeighbouringCellMeasurementInfo_item = -1;
static gint ett_rnsap_CommonMeasurementInitiationResponse = -1;
static gint ett_rnsap_CommonMeasurementObjectType_CM_Rsp = -1;
static gint ett_rnsap_Cell_CM_Rsp = -1;
static gint ett_rnsap_CommonMeasurementInitiationFailure = -1;
static gint ett_rnsap_CommonMeasurementReport = -1;
static gint ett_rnsap_CommonMeasurementObjectType_CM_Rprt = -1;
static gint ett_rnsap_Cell_CM_Rprt = -1;
static gint ett_rnsap_CommonMeasurementTerminationRequest = -1;
static gint ett_rnsap_CommonMeasurementFailureIndication = -1;
static gint ett_rnsap_InformationExchangeInitiationRequest = -1;
static gint ett_rnsap_InformationExchangeObjectType_InfEx_Rqst = -1;
static gint ett_rnsap_Cell_InfEx_Rqst = -1;
static gint ett_rnsap_GSM_Cell_InfEx_Rqst = -1;
static gint ett_rnsap_InformationExchangeInitiationResponse = -1;
static gint ett_rnsap_InformationExchangeObjectType_InfEx_Rsp = -1;
static gint ett_rnsap_Cell_InfEx_Rsp = -1;
static gint ett_rnsap_MBMS_Bearer_Service_List_InfEx_Rsp = -1;
static gint ett_rnsap_MBMS_Bearer_ServiceItemIEs_InfEx_Rsp = -1;
static gint ett_rnsap_InformationExchangeInitiationFailure = -1;
static gint ett_rnsap_InformationReport = -1;
static gint ett_rnsap_InformationExchangeObjectType_InfEx_Rprt = -1;
static gint ett_rnsap_Cell_InfEx_Rprt = -1;
static gint ett_rnsap_InformationExchangeTerminationRequest = -1;
static gint ett_rnsap_InformationExchangeFailureIndication = -1;
static gint ett_rnsap_ResetRequest = -1;
static gint ett_rnsap_ResetIndicator = -1;
static gint ett_rnsap_ContextList_Reset = -1;
static gint ett_rnsap_ContextInfoList_Reset = -1;
static gint ett_rnsap_ContextInfoItem_Reset = -1;
static gint ett_rnsap_ContextType_Reset = -1;
static gint ett_rnsap_ContextGroupList_Reset = -1;
static gint ett_rnsap_ContextGroupInfoList_Reset = -1;
static gint ett_rnsap_ContextGroupInfoItem_Reset = -1;
static gint ett_rnsap_ResetResponse = -1;
static gint ett_rnsap_RadioLinkActivationCommandFDD = -1;
static gint ett_rnsap_DelayedActivationInformationList_RL_ActivationCmdFDD = -1;
static gint ett_rnsap_DelayedActivationInformation_RL_ActivationCmdFDD = -1;
static gint ett_rnsap_RadioLinkActivationCommandTDD = -1;
static gint ett_rnsap_DelayedActivationInformationList_RL_ActivationCmdTDD = -1;
static gint ett_rnsap_DelayedActivationInformation_RL_ActivationCmdTDD = -1;
static gint ett_rnsap_GERANUplinkSignallingTransferIndication = -1;
static gint ett_rnsap_RadioLinkParameterUpdateIndicationFDD = -1;
static gint ett_rnsap_RL_ParameterUpdateIndicationFDD_RL_InformationList = -1;
static gint ett_rnsap_RL_ParameterUpdateIndicationFDD_RL_Information_Item = -1;
static gint ett_rnsap_RadioLinkParameterUpdateIndicationTDD = -1;
static gint ett_rnsap_UEMeasurementInitiationRequest = -1;
static gint ett_rnsap_UEMeasurementInitiationResponse = -1;
static gint ett_rnsap_UEMeasurementInitiationFailure = -1;
static gint ett_rnsap_UEMeasurementReport = -1;
static gint ett_rnsap_UEMeasurementTerminationRequest = -1;
static gint ett_rnsap_UEMeasurementFailureIndication = -1;
static gint ett_rnsap_IurInvokeTrace = -1;
static gint ett_rnsap_ListOfInterfacesToTrace = -1;
static gint ett_rnsap_InterfacesToTraceItem = -1;
static gint ett_rnsap_IurDeactivateTrace = -1;
static gint ett_rnsap_MBMSAttachCommand = -1;
static gint ett_rnsap_MBMSDetachCommand = -1;
static gint ett_rnsap_DirectInformationTransfer = -1;
static gint ett_rnsap_PrivateMessage = -1;
static gint ett_rnsap_Active_MBMS_Bearer_Service_ListFDD = -1;
static gint ett_rnsap_Active_MBMS_Bearer_Service_ListFDD_PFL = -1;
static gint ett_rnsap_Active_MBMS_Bearer_Service_ListTDD = -1;
static gint ett_rnsap_Active_MBMS_Bearer_Service_ListTDD_PFL = -1;
static gint ett_rnsap_Active_Pattern_Sequence_Information = -1;
static gint ett_rnsap_AdditionalPreferredFrequency = -1;
static gint ett_rnsap_AdditionalPreferredFrequencyItem = -1;
static gint ett_rnsap_AffectedUEInformationForMBMS = -1;
static gint ett_rnsap_AllocationRetentionPriority = -1;
static gint ett_rnsap_Allowed_Rate_Information = -1;
static gint ett_rnsap_Angle_Of_Arrival_Value_LCR = -1;
static gint ett_rnsap_BadSatellites = -1;
static gint ett_rnsap_T_badSatelliteInformation = -1;
static gint ett_rnsap_T_badSatelliteInformation_item = -1;
static gint ett_rnsap_BSIC = -1;
static gint ett_rnsap_BurstModeParameters = -1;
static gint ett_rnsap_Cause = -1;
static gint ett_rnsap_Cell_Capacity_Class_Value = -1;
static gint ett_rnsap_CGI = -1;
static gint ett_rnsap_T_lAI = -1;
static gint ett_rnsap_CommonMeasurementAccuracy = -1;
static gint ett_rnsap_CommonMeasurementValue = -1;
static gint ett_rnsap_CommonMeasurementValueInformation = -1;
static gint ett_rnsap_CommonMeasurementAvailable = -1;
static gint ett_rnsap_CorrespondingCells = -1;
static gint ett_rnsap_CriticalityDiagnostics = -1;
static gint ett_rnsap_CriticalityDiagnostics_IE_List = -1;
static gint ett_rnsap_CriticalityDiagnostics_IE_List_item = -1;
static gint ett_rnsap_MessageStructure = -1;
static gint ett_rnsap_MessageStructure_item = -1;
static gint ett_rnsap_CN_CS_DomainIdentifier = -1;
static gint ett_rnsap_CN_PS_DomainIdentifier = -1;
static gint ett_rnsap_DCH_FDD_Information = -1;
static gint ett_rnsap_DCH_FDD_InformationItem = -1;
static gint ett_rnsap_DCH_Specific_FDD_InformationList = -1;
static gint ett_rnsap_DCH_Specific_FDD_Item = -1;
static gint ett_rnsap_DCH_InformationResponse = -1;
static gint ett_rnsap_DCH_InformationResponseItem = -1;
static gint ett_rnsap_DCH_TDD_Information = -1;
static gint ett_rnsap_DCH_TDD_InformationItem = -1;
static gint ett_rnsap_DCH_Specific_TDD_InformationList = -1;
static gint ett_rnsap_DCH_Specific_TDD_Item = -1;
static gint ett_rnsap_DedicatedMeasurementValue = -1;
static gint ett_rnsap_DedicatedMeasurementValueInformation = -1;
static gint ett_rnsap_DedicatedMeasurementAvailable = -1;
static gint ett_rnsap_DelayedActivation = -1;
static gint ett_rnsap_DelayedActivationUpdate = -1;
static gint ett_rnsap_Activate_Info = -1;
static gint ett_rnsap_Deactivate_Info = -1;
static gint ett_rnsap_Execution_Type = -1;
static gint ett_rnsap_DGPSCorrections = -1;
static gint ett_rnsap_T_satellite_DGPSCorrections_Information = -1;
static gint ett_rnsap_T_satellite_DGPSCorrections_Information_item = -1;
static gint ett_rnsap_DGPSThreshold = -1;
static gint ett_rnsap_DL_PowerBalancing_Information = -1;
static gint ett_rnsap_DL_ReferencePowerInformationList = -1;
static gint ett_rnsap_DL_ReferencePowerInformationItem = -1;
static gint ett_rnsap_DL_ReferencePowerInformation = -1;
static gint ett_rnsap_DL_Timeslot_Information = -1;
static gint ett_rnsap_DL_Timeslot_InformationItem = -1;
static gint ett_rnsap_DL_TimeslotLCR_Information = -1;
static gint ett_rnsap_DL_TimeslotLCR_InformationItem = -1;
static gint ett_rnsap_DL_TimeSlot_ISCP_Info = -1;
static gint ett_rnsap_DL_TimeSlot_ISCP_InfoItem = -1;
static gint ett_rnsap_DL_TimeSlot_ISCP_LCR_Information = -1;
static gint ett_rnsap_DL_TimeSlot_ISCP_LCR_InfoItem = -1;
static gint ett_rnsap_DSCH_FlowControlInformation = -1;
static gint ett_rnsap_DSCH_FlowControlItem = -1;
static gint ett_rnsap_DSCH_TDD_Information = -1;
static gint ett_rnsap_DSCH_TDD_InformationItem = -1;
static gint ett_rnsap_EDCH_FDD_DL_ControlChannelInformation = -1;
static gint ett_rnsap_EDCH_FDD_Information = -1;
static gint ett_rnsap_EDCH_FDD_InformationResponse = -1;
static gint ett_rnsap_EDCH_FDD_InformationResponseItem = -1;
static gint ett_rnsap_EDCH_FDD_Information_To_Modify = -1;
static gint ett_rnsap_EDCH_FDD_Update_Information = -1;
static gint ett_rnsap_EDCH_FDD_Update_InfoItem = -1;
static gint ett_rnsap_E_DCH_Grant_Type_Information = -1;
static gint ett_rnsap_E_DCH_LogicalChannelInformation = -1;
static gint ett_rnsap_E_DCH_LogicalChannelInformationItem = -1;
static gint ett_rnsap_E_DCH_MACdPDU_SizeList = -1;
static gint ett_rnsap_E_DCH_MACdPDU_SizeListItem = -1;
static gint ett_rnsap_E_DCH_LogicalChannelToModify = -1;
static gint ett_rnsap_E_DCH_LogicalChannelToModifyItem = -1;
static gint ett_rnsap_E_DCH_MACdPDU_SizeToModifyList = -1;
static gint ett_rnsap_E_DCH_LogicalChannelToDelete = -1;
static gint ett_rnsap_E_DCH_LogicalChannelToDeleteItem = -1;
static gint ett_rnsap_EDCH_MACdFlows_Information = -1;
static gint ett_rnsap_EDCH_MACdFlow_Specific_InfoList = -1;
static gint ett_rnsap_EDCH_MACdFlow_Specific_InfoItem = -1;
static gint ett_rnsap_EDCH_MACdFlow_Specific_InfoToModifyList = -1;
static gint ett_rnsap_EDCH_MACdFlow_Specific_InfoToModifyItem = -1;
static gint ett_rnsap_EDCH_MACdFlows_To_Delete = -1;
static gint ett_rnsap_EDCH_MACdFlows_To_Delete_Item = -1;
static gint ett_rnsap_E_DCH_Non_Scheduled_Transmission_Grant_Items = -1;
static gint ett_rnsap_EDPCH_Information_FDD = -1;
static gint ett_rnsap_EDPCH_Information_RLReconfPrepare_FDD = -1;
static gint ett_rnsap_EDPCH_Information_RLReconfRequest_FDD = -1;
static gint ett_rnsap_EDCH_Serving_RL = -1;
static gint ett_rnsap_EDCH_Serving_RL_in_this_DRNS = -1;
static gint ett_rnsap_E_TFCS_Information = -1;
static gint ett_rnsap_EventA = -1;
static gint ett_rnsap_EventB = -1;
static gint ett_rnsap_EventC = -1;
static gint ett_rnsap_EventD = -1;
static gint ett_rnsap_EventE = -1;
static gint ett_rnsap_EventF = -1;
static gint ett_rnsap_FACH_FlowControlInformation = -1;
static gint ett_rnsap_FACH_FlowControlInformationItem = -1;
static gint ett_rnsap_FACH_InformationList = -1;
static gint ett_rnsap_FACH_InformationItem = -1;
static gint ett_rnsap_FACH_PCH_InformationList = -1;
static gint ett_rnsap_FACH_PCH_InformationItem = -1;
static gint ett_rnsap_FDD_DCHs_to_Modify = -1;
static gint ett_rnsap_FDD_DCHs_to_ModifyItem = -1;
static gint ett_rnsap_FDD_DCHs_to_ModifySpecificInformationList = -1;
static gint ett_rnsap_FDD_DCHs_to_ModifySpecificItem = -1;
static gint ett_rnsap_FDD_DL_CodeInformation = -1;
static gint ett_rnsap_FDD_DL_CodeInformationItem = -1;
static gint ett_rnsap_FPACH_Information = -1;
static gint ett_rnsap_GA_Cell = -1;
static gint ett_rnsap_GA_Cell_item = -1;
static gint ett_rnsap_GA_CellAdditionalShapes = -1;
static gint ett_rnsap_GA_AltitudeAndDirection = -1;
static gint ett_rnsap_GA_EllipsoidArc = -1;
static gint ett_rnsap_GA_PointWithAltitude = -1;
static gint ett_rnsap_GA_PointWithAltitudeAndUncertaintyEllipsoid = -1;
static gint ett_rnsap_GA_PointWithUnCertaintyEllipse = -1;
static gint ett_rnsap_GA_UncertaintyEllipse = -1;
static gint ett_rnsap_GA_PointWithUnCertainty = -1;
static gint ett_rnsap_GA_AccessPointPosition = -1;
static gint ett_rnsap_GeographicalCoordinate = -1;
static gint ett_rnsap_GERAN_SI_Type = -1;
static gint ett_rnsap_GERAN_SystemInfo = -1;
static gint ett_rnsap_GERAN_SystemInfo_item = -1;
static gint ett_rnsap_GPS_Almanac = -1;
static gint ett_rnsap_T_satellite_Almanac_Information = -1;
static gint ett_rnsap_T_satellite_Almanac_Information_item = -1;
static gint ett_rnsap_Satellite_Almanac_Information_ExtItem = -1;
static gint ett_rnsap_Satellite_Almanac_Information_ExtItem_item = -1;
static gint ett_rnsap_GPSInformation = -1;
static gint ett_rnsap_GPSInformation_item = -1;
static gint ett_rnsap_GPS_Ionospheric_Model = -1;
static gint ett_rnsap_GPS_NavigationModel_and_TimeRecovery = -1;
static gint ett_rnsap_GPS_NavigationModel_and_TimeRecovery_item = -1;
static gint ett_rnsap_GPS_RealTime_Integrity = -1;
static gint ett_rnsap_GPS_RX_POS = -1;
static gint ett_rnsap_GPS_UTC_Model = -1;
static gint ett_rnsap_Guaranteed_Rate_Information = -1;
static gint ett_rnsap_HARQ_MemoryPartitioning = -1;
static gint ett_rnsap_HARQ_MemoryPartitioning_Implicit = -1;
static gint ett_rnsap_HARQ_MemoryPartitioning_Explicit = -1;
static gint ett_rnsap_HARQ_MemoryPartitioningList = -1;
static gint ett_rnsap_HARQ_MemoryPartitioningItem = -1;
static gint ett_rnsap_HSDSCH_FDD_Information = -1;
static gint ett_rnsap_HSDSCH_FDD_Information_Response = -1;
static gint ett_rnsap_HSDSCH_Information_to_Modify = -1;
static gint ett_rnsap_HSDSCH_Information_to_Modify_Unsynchronised = -1;
static gint ett_rnsap_HSDSCH_MACdFlow_Specific_InfoList = -1;
static gint ett_rnsap_HSDSCH_MACdFlow_Specific_InfoItem = -1;
static gint ett_rnsap_HSDSCH_MACdFlow_Specific_InfoList_Response = -1;
static gint ett_rnsap_HSDSCH_MACdFlow_Specific_InfoItem_Response = -1;
static gint ett_rnsap_HSDSCH_MACdFlow_Specific_InfoList_to_Modify = -1;
static gint ett_rnsap_HSDSCH_MACdFlow_Specific_InfoItem_to_Modify = -1;
static gint ett_rnsap_HSDSCH_MACdFlows_Information = -1;
static gint ett_rnsap_HSDSCH_MACdFlows_to_Delete = -1;
static gint ett_rnsap_HSDSCH_MACdFlows_to_Delete_Item = -1;
static gint ett_rnsap_HSDSCH_Initial_Capacity_Allocation = -1;
static gint ett_rnsap_HSDSCH_Initial_Capacity_AllocationItem = -1;
static gint ett_rnsap_HSDSCH_TDD_Information = -1;
static gint ett_rnsap_HSDSCH_TDD_Information_Response = -1;
static gint ett_rnsap_HSPDSCH_TDD_Specific_InfoList_Response = -1;
static gint ett_rnsap_HSPDSCH_TDD_Specific_InfoItem_Response = -1;
static gint ett_rnsap_HSPDSCH_TDD_Specific_InfoList_Response_LCR = -1;
static gint ett_rnsap_HSPDSCH_TDD_Specific_InfoItem_Response_LCR = -1;
static gint ett_rnsap_HSSCCH_FDD_Specific_InfoList_Response = -1;
static gint ett_rnsap_HSSCCH_FDD_Specific_InfoItem_Response = -1;
static gint ett_rnsap_HSSCCH_TDD_Specific_InfoList_Response = -1;
static gint ett_rnsap_HSSCCH_TDD_Specific_InfoItem_Response = -1;
static gint ett_rnsap_HSSCCH_TDD_Specific_InfoList_Response_LCR = -1;
static gint ett_rnsap_HSSCCH_TDD_Specific_InfoItem_Response_LCR = -1;
static gint ett_rnsap_HSSICH_Info = -1;
static gint ett_rnsap_HSSICH_InfoLCR = -1;
static gint ett_rnsap_HS_SICH_Reception_Quality_Value = -1;
static gint ett_rnsap_HSDSCH_FDD_Update_Information = -1;
static gint ett_rnsap_HSDSCH_TDD_Update_Information = -1;
static gint ett_rnsap_InformationAvailable = -1;
static gint ett_rnsap_InformationReportCharacteristics = -1;
static gint ett_rnsap_InformationReportPeriodicity = -1;
static gint ett_rnsap_InformationThreshold = -1;
static gint ett_rnsap_InformationType = -1;
static gint ett_rnsap_IPDLParameters = -1;
static gint ett_rnsap_IPDL_FDD_Parameters = -1;
static gint ett_rnsap_IPDL_TDD_Parameters = -1;
static gint ett_rnsap_IPDL_TDD_ParametersLCR = -1;
static gint ett_rnsap_LoadValue = -1;
static gint ett_rnsap_MAC_c_sh_SDU_LengthList = -1;
static gint ett_rnsap_MACdPDU_Size_IndexList = -1;
static gint ett_rnsap_MACdPDU_Size_IndexItem = -1;
static gint ett_rnsap_MACdPDU_Size_IndexList_to_Modify = -1;
static gint ett_rnsap_MACdPDU_Size_IndexItem_to_Modify = -1;
static gint ett_rnsap_MBMS_Bearer_Service_Full_Address = -1;
static gint ett_rnsap_MBMS_Bearer_Service_List = -1;
static gint ett_rnsap_MBMS_Bearer_ServiceItemFDD = -1;
static gint ett_rnsap_MBMS_Bearer_ServiceItemFDD_PFL = -1;
static gint ett_rnsap_MBMS_Bearer_ServiceItemTDD = -1;
static gint ett_rnsap_MBMS_Bearer_ServiceItemTDD_PFL = -1;
static gint ett_rnsap_MBMSChannelTypeInfo = -1;
static gint ett_rnsap_MBMSChannelTypeCellList = -1;
static gint ett_rnsap_MBMSPreferredFreqLayerInfo = -1;
static gint ett_rnsap_MeasurementIncreaseDecreaseThreshold = -1;
static gint ett_rnsap_MeasurementThreshold = -1;
static gint ett_rnsap_MidambleShiftAndBurstType = -1;
static gint ett_rnsap_T_type1 = -1;
static gint ett_rnsap_T_midambleAllocationMode = -1;
static gint ett_rnsap_T_type2 = -1;
static gint ett_rnsap_T_midambleAllocationMode1 = -1;
static gint ett_rnsap_T_type3 = -1;
static gint ett_rnsap_T_midambleAllocationMode2 = -1;
static gint ett_rnsap_MidambleShiftLCR = -1;
static gint ett_rnsap_ModifyPriorityQueue = -1;
static gint ett_rnsap_NACC_Related_Data = -1;
static gint ett_rnsap_Neighbouring_UMTS_CellInformation = -1;
static gint ett_rnsap_Neighbouring_UMTS_CellInformationItem = -1;
static gint ett_rnsap_Neighbouring_FDD_CellInformation = -1;
static gint ett_rnsap_Neighbouring_FDD_CellInformationItem = -1;
static gint ett_rnsap_NeighbouringFDDCellMeasurementInformation = -1;
static gint ett_rnsap_Neighbouring_GSM_CellInformationIEs = -1;
static gint ett_rnsap_Neighbouring_GSM_CellInformationItem = -1;
static gint ett_rnsap_Neighbouring_TDD_CellInformation = -1;
static gint ett_rnsap_Neighbouring_TDD_CellInformationItem = -1;
static gint ett_rnsap_NeighbouringTDDCellMeasurementInformation = -1;
static gint ett_rnsap_NeighbouringTDDCellMeasurementInformationLCR = -1;
static gint ett_rnsap_Neighbouring_LCR_TDD_CellInformation = -1;
static gint ett_rnsap_Neighbouring_LCR_TDD_CellInformationItem = -1;
static gint ett_rnsap_NotProvidedCellList = -1;
static gint ett_rnsap_NRTLoadInformationValue = -1;
static gint ett_rnsap_OnModification = -1;
static gint ett_rnsap_OnModificationInformation = -1;
static gint ett_rnsap_PCH_InformationList = -1;
static gint ett_rnsap_PCH_InformationItem = -1;
static gint ett_rnsap_Periodic = -1;
static gint ett_rnsap_PeriodicInformation = -1;
static gint ett_rnsap_Permanent_NAS_UE_Identity = -1;
static gint ett_rnsap_PreferredFrequencyLayerInfo = -1;
static gint ett_rnsap_PriorityQueue_InfoList = -1;
static gint ett_rnsap_PriorityQueue_InfoItem = -1;
static gint ett_rnsap_PriorityQueue_InfoList_to_Modify = -1;
static gint ett_rnsap_PriorityQueue_InfoItem_to_Add = -1;
static gint ett_rnsap_PriorityQueue_InfoItem_to_Modify = -1;
static gint ett_rnsap_PriorityQueue_InfoList_to_Modify_Unsynchronised = -1;
static gint ett_rnsap_PriorityQueue_InfoItem_to_Modify_Unsynchronised = -1;
static gint ett_rnsap_ProvidedInformation = -1;
static gint ett_rnsap_PTMCellList = -1;
static gint ett_rnsap_PTPCellList = -1;
static gint ett_rnsap_RB_Info = -1;
static gint ett_rnsap_Reference_E_TFCI_Information = -1;
static gint ett_rnsap_Reference_E_TFCI_Information_Item = -1;
static gint ett_rnsap_ReportCharacteristics = -1;
static gint ett_rnsap_ReportPeriodicity = -1;
static gint ett_rnsap_RequestedDataValue = -1;
static gint ett_rnsap_RequestedDataValueInformation = -1;
static gint ett_rnsap_RL_Specific_DCH_Info = -1;
static gint ett_rnsap_RL_Specific_DCH_Info_Item = -1;
static gint ett_rnsap_RL_Specific_EDCH_Information = -1;
static gint ett_rnsap_RL_Specific_EDCH_InfoItem = -1;
static gint ett_rnsap_RTLoadValue = -1;
static gint ett_rnsap_SAI = -1;
static gint ett_rnsap_Secondary_CCPCH_Info_TDD = -1;
static gint ett_rnsap_Secondary_CPICH_Information = -1;
static gint ett_rnsap_Secondary_CPICH_Information_Change = -1;
static gint ett_rnsap_Secondary_LCR_CCPCH_Info_TDD = -1;
static gint ett_rnsap_Secondary_CCPCH_TDD_InformationList = -1;
static gint ett_rnsap_Secondary_CCPCH_TDD_InformationItem = -1;
static gint ett_rnsap_Secondary_LCR_CCPCH_TDD_InformationList = -1;
static gint ett_rnsap_Secondary_LCR_CCPCH_TDD_InformationItem = -1;
static gint ett_rnsap_Secondary_CCPCH_TDD_Code_Information = -1;
static gint ett_rnsap_Secondary_CCPCH_TDD_Code_InformationItem = -1;
static gint ett_rnsap_Secondary_LCR_CCPCH_TDD_Code_Information = -1;
static gint ett_rnsap_Secondary_LCR_CCPCH_TDD_Code_InformationItem = -1;
static gint ett_rnsap_GA_AccessPointPositionwithOptionalAltitude = -1;
static gint ett_rnsap_SFNSFNMeasurementThresholdInformation = -1;
static gint ett_rnsap_SFNSFNMeasurementValueInformation = -1;
static gint ett_rnsap_T_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation = -1;
static gint ett_rnsap_T_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item = -1;
static gint ett_rnsap_T_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation = -1;
static gint ett_rnsap_T_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item = -1;
static gint ett_rnsap_SFNSFNTimeStampInformation = -1;
static gint ett_rnsap_SFNSFNTimeStamp_TDD = -1;
static gint ett_rnsap_SFNSFNValue = -1;
static gint ett_rnsap_SNA_Information = -1;
static gint ett_rnsap_ListOfSNAs = -1;
static gint ett_rnsap_S_RNTI_Group = -1;
static gint ett_rnsap_SynchronisationConfiguration = -1;
static gint ett_rnsap_SYNC_UL_ProcParameters = -1;
static gint ett_rnsap_TDD_ChannelisationCodeLCR = -1;
static gint ett_rnsap_TDD_DCHs_to_Modify = -1;
static gint ett_rnsap_TDD_DCHs_to_ModifyItem = -1;
static gint ett_rnsap_TDD_DCHs_to_ModifySpecificInformationList = -1;
static gint ett_rnsap_TDD_DCHs_to_ModifySpecificItem = -1;
static gint ett_rnsap_TDD_DL_Code_Information = -1;
static gint ett_rnsap_TDD_DL_Code_InformationItem = -1;
static gint ett_rnsap_TDD_DL_Code_LCR_Information = -1;
static gint ett_rnsap_TDD_DL_Code_LCR_InformationItem = -1;
static gint ett_rnsap_TDD_DL_DPCH_TimeSlotFormat_LCR = -1;
static gint ett_rnsap_TDD_DPCHOffset = -1;
static gint ett_rnsap_TDD_UL_Code_Information = -1;
static gint ett_rnsap_TDD_UL_Code_InformationItem = -1;
static gint ett_rnsap_TDD_UL_Code_LCR_Information = -1;
static gint ett_rnsap_TDD_UL_Code_LCR_InformationItem = -1;
static gint ett_rnsap_TDD_UL_DPCH_TimeSlotFormat_LCR = -1;
static gint ett_rnsap_TMGI = -1;
static gint ett_rnsap_TnlQos = -1;
static gint ett_rnsap_Transmission_Gap_Pattern_Sequence_Information = -1;
static gint ett_rnsap_Transmission_Gap_Pattern_Sequence_Information_item = -1;
static gint ett_rnsap_Transmission_Gap_Pattern_Sequence_Status_List = -1;
static gint ett_rnsap_Transmission_Gap_Pattern_Sequence_Status_List_item = -1;
static gint ett_rnsap_TUTRANGPS = -1;
static gint ett_rnsap_TUTRANGPSMeasurementThresholdInformation = -1;
static gint ett_rnsap_TUTRANGPSMeasurementValueInformation = -1;
static gint ett_rnsap_TransportFormatCombination_Beta = -1;
static gint ett_rnsap_T_signalledGainFactors = -1;
static gint ett_rnsap_TFCS = -1;
static gint ett_rnsap_T_tFCSvalues = -1;
static gint ett_rnsap_TFCS_TFCSList = -1;
static gint ett_rnsap_TFCS_TFCSList_item = -1;
static gint ett_rnsap_TFCS_CTFC = -1;
static gint ett_rnsap_TransportFormatSet = -1;
static gint ett_rnsap_TransportFormatSet_DynamicPartList = -1;
static gint ett_rnsap_TransportFormatSet_DynamicPartList_item = -1;
static gint ett_rnsap_TransportFormatSet_ModeDP = -1;
static gint ett_rnsap_TDD_TransportFormatSet_ModeDP = -1;
static gint ett_rnsap_TransmissionTimeIntervalInformation = -1;
static gint ett_rnsap_TransmissionTimeIntervalInformation_item = -1;
static gint ett_rnsap_TransportFormatSet_Semi_staticPart = -1;
static gint ett_rnsap_TransportFormatSet_ModeSSP = -1;
static gint ett_rnsap_UE_Capabilities_Info = -1;
static gint ett_rnsap_UEIdentity = -1;
static gint ett_rnsap_UEMeasurementReportCharacteristics = -1;
static gint ett_rnsap_UEMeasurementReportCharacteristicsEvent1h = -1;
static gint ett_rnsap_UEMeasurementReportCharacteristicsEvent1i = -1;
static gint ett_rnsap_UEMeasurementReportCharacteristicsEvent6a = -1;
static gint ett_rnsap_UEMeasurementReportCharacteristicsEvent6b = -1;
static gint ett_rnsap_UEMeasurementReportCharacteristicsEvent6c = -1;
static gint ett_rnsap_UEMeasurementReportCharacteristicsEvent6d = -1;
static gint ett_rnsap_UEMeasurementReportCharacteristicsPeriodic = -1;
static gint ett_rnsap_UEMeasurementThreshold = -1;
static gint ett_rnsap_UEMeasurementTimeslotInfoHCR = -1;
static gint ett_rnsap_UEMeasurementTimeslotInfoHCR_IEs = -1;
static gint ett_rnsap_UEMeasurementTimeslotInfoLCR = -1;
static gint ett_rnsap_UEMeasurementTimeslotInfoLCR_IEs = -1;
static gint ett_rnsap_UEMeasurementValue = -1;
static gint ett_rnsap_UE_MeasurementValue_UE_Transmitted_Power = -1;
static gint ett_rnsap_UEMeasurementValueTransmittedPowerListHCR = -1;
static gint ett_rnsap_UEMeasurementValueTransmittedPowerListHCR_IEs = -1;
static gint ett_rnsap_UEMeasurementValueTransmittedPowerListLCR = -1;
static gint ett_rnsap_UEMeasurementValueTransmittedPowerListLCR_IEs = -1;
static gint ett_rnsap_UE_MeasurementValue_Primary_CCPCH_RSCP = -1;
static gint ett_rnsap_UE_MeasurementValue_DL_Timeslot_ISCP = -1;
static gint ett_rnsap_UEMeasurementValueTimeslotISCPListHCR = -1;
static gint ett_rnsap_UEMeasurementValueTimeslotISCPListHCR_IEs = -1;
static gint ett_rnsap_UEMeasurementValueTimeslotISCPListLCR = -1;
static gint ett_rnsap_UEMeasurementValueTimeslotISCPListLCR_IEs = -1;
static gint ett_rnsap_UEMeasurementValueInformation = -1;
static gint ett_rnsap_UEMeasurementValueInformationAvailable = -1;
static gint ett_rnsap_UE_State = -1;
static gint ett_rnsap_Cell_Fach_Pch_State = -1;
static gint ett_rnsap_Ura_Pch_State = -1;
static gint ett_rnsap_UL_Timeslot_Information = -1;
static gint ett_rnsap_UL_Timeslot_InformationItem = -1;
static gint ett_rnsap_UL_TimeslotLCR_Information = -1;
static gint ett_rnsap_UL_TimeslotLCR_InformationItem = -1;
static gint ett_rnsap_UL_TimeSlot_ISCP_Info = -1;
static gint ett_rnsap_UL_TimeSlot_ISCP_InfoItem = -1;
static gint ett_rnsap_UL_TimeSlot_ISCP_LCR_Info = -1;
static gint ett_rnsap_UL_TimeSlot_ISCP_LCR_InfoItem = -1;
static gint ett_rnsap_UL_TimingAdvanceCtrl_LCR = -1;
static gint ett_rnsap_UC_ID = -1;
static gint ett_rnsap_UL_ScramblingCode = -1;
static gint ett_rnsap_UL_Synchronisation_Parameters_LCR = -1;
static gint ett_rnsap_URA_Information = -1;
static gint ett_rnsap_RNCsWithCellsInTheAccessedURA_List = -1;
static gint ett_rnsap_RNCsWithCellsInTheAccessedURA_Item = -1;
static gint ett_rnsap_USCH_Information = -1;
static gint ett_rnsap_USCH_InformationItem = -1;
static gint ett_rnsap_PrivateIE_ID = -1;
static gint ett_rnsap_ProcedureID = -1;
static gint ett_rnsap_TransactionID = -1;
static gint ett_rnsap_ProtocolIE_Container = -1;
static gint ett_rnsap_ProtocolIE_Field = -1;
static gint ett_rnsap_ProtocolIE_ContainerPair = -1;
static gint ett_rnsap_ProtocolIE_FieldPair = -1;
static gint ett_rnsap_ProtocolIE_ContainerList = -1;
static gint ett_rnsap_ProtocolIE_ContainerPairList = -1;
static gint ett_rnsap_ProtocolExtensionContainer = -1;
static gint ett_rnsap_ProtocolExtensionField = -1;
static gint ett_rnsap_PrivateIE_Container = -1;
static gint ett_rnsap_PrivateIE_Field = -1;

/*--- End of included file: packet-rnsap-ett.c ---*/
#line 571 "packet-rnsap-template.c"

/* Global variables */
static proto_tree *top_tree;
static guint32 ProcedureCode;
static guint32 ProtocolIE_ID;
static guint32 ddMode;

#define BYTE_ALIGN_OFFSET(offset)		\
	if(offset&0x07){			\
		offset=(offset&0xfffffff8)+8;	\
	}
#define RNSAP_FDD 1
/* Prodedure ID:s */

/* Protocol IE:s */



static int dissect_rnsap_InitiatingMessageValueValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree);
static int dissect_rnsap_SuccessfulOutcomeValueValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree);
static int dissect_rnsap_UnsuccessfulOutcomeValueValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree);
static int dissect_rnsap_ProtocolIEValueValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree);

/*--- Included file: packet-rnsap-fn.c ---*/
#line 1 "packet-rnsap-fn.c"
/*--- Fields for imported types ---*/



static const value_string rnsap_ProcedureCode_vals[] = {
  {   0, "id-commonTransportChannelResourcesInitialisation" },
  {   1, "id-commonTransportChannelResourcesRelease" },
  {   2, "id-compressedModeCommand" },
  {   3, "id-downlinkPowerControl" },
  {   4, "id-downlinkPowerTimeslotControl" },
  {   5, "id-downlinkSignallingTransfer" },
  {   6, "id-errorIndication" },
  {   7, "id-dedicatedMeasurementFailure" },
  {   8, "id-dedicatedMeasurementInitiation" },
  {   9, "id-dedicatedMeasurementReporting" },
  {  10, "id-dedicatedMeasurementTermination" },
  {  11, "id-paging" },
  {  12, "id-physicalChannelReconfiguration" },
  {  13, "id-privateMessage" },
  {  14, "id-radioLinkAddition" },
  {  34, "id-radioLinkCongestion" },
  {  15, "id-radioLinkDeletion" },
  {  16, "id-radioLinkFailure" },
  {  17, "id-radioLinkPreemption" },
  {  18, "id-radioLinkRestoration" },
  {  19, "id-radioLinkSetup" },
  {  20, "id-relocationCommit" },
  {  21, "id-synchronisedRadioLinkReconfigurationCancellation" },
  {  22, "id-synchronisedRadioLinkReconfigurationCommit" },
  {  23, "id-synchronisedRadioLinkReconfigurationPreparation" },
  {  24, "id-unSynchronisedRadioLinkReconfiguration" },
  {  25, "id-uplinkSignallingTransfer" },
  {  26, "id-commonMeasurementFailure" },
  {  27, "id-commonMeasurementInitiation" },
  {  28, "id-commonMeasurementReporting" },
  {  29, "id-commonMeasurementTermination" },
  {  30, "id-informationExchangeFailure" },
  {  31, "id-informationExchangeInitiation" },
  {  32, "id-informationReporting" },
  {  33, "id-informationExchangeTermination" },
  {  35, "id-reset" },
  {  36, "id-radioLinkActivation" },
  {  37, "id-gERANuplinkSignallingTransfer" },
  {  38, "id-radioLinkParameterUpdate" },
  {  39, "id-uEMeasurementFailure" },
  {  40, "id-uEMeasurementInitiation" },
  {  41, "id-uEMeasurementReporting" },
  {  42, "id-uEMeasurementTermination" },
  {  43, "id-iurDeactivateTrace" },
  {  44, "id-iurInvokeTrace" },
  {  45, "id-mBMSAttach" },
  {  46, "id-mBMSDetach" },
  {  48, "id-directInformationTransfer" },
  { 0, NULL }
};


static int
dissect_rnsap_ProcedureCode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 255U, &ProcedureCode, FALSE);

#line 18 "rnsap.cnf"
	if (check_col(actx->pinfo->cinfo, COL_INFO))
       col_add_fstr(actx->pinfo->cinfo, COL_INFO, "%s ",
                   val_to_str(ProcedureCode, rnsap_ProcedureCode_vals,
                              "unknown message"));

  return offset;
}
static int dissect_procedureCode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProcedureCode(tvb, offset, actx, tree, hf_rnsap_procedureCode);
}


static const value_string rnsap_T_ddMode_vals[] = {
  {   0, "tdd" },
  {   1, "fdd" },
  {   2, "common" },
  { 0, NULL }
};


static int
dissect_rnsap_T_ddMode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, &ddMode, TRUE, 0, NULL);

  return offset;
}
static int dissect_ddMode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_T_ddMode(tvb, offset, actx, tree, hf_rnsap_ddMode);
}


static const per_sequence_t ProcedureID_sequence[] = {
  { &hf_rnsap_procedureCode , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProcedureCode },
  { &hf_rnsap_ddMode        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_T_ddMode },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_ProcedureID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_ProcedureID, ProcedureID_sequence);

  return offset;
}
static int dissect_procedureID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProcedureID(tvb, offset, actx, tree, hf_rnsap_procedureID);
}


static const value_string rnsap_Criticality_vals[] = {
  {   0, "reject" },
  {   1, "ignore" },
  {   2, "notify" },
  { 0, NULL }
};


static int
dissect_rnsap_Criticality(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_criticality(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Criticality(tvb, offset, actx, tree, hf_rnsap_criticality);
}
static int dissect_procedureCriticality(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Criticality(tvb, offset, actx, tree, hf_rnsap_procedureCriticality);
}
static int dissect_iECriticality(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Criticality(tvb, offset, actx, tree, hf_rnsap_iECriticality);
}
static int dissect_firstCriticality(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Criticality(tvb, offset, actx, tree, hf_rnsap_firstCriticality);
}
static int dissect_secondCriticality(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Criticality(tvb, offset, actx, tree, hf_rnsap_secondCriticality);
}



static int
dissect_rnsap_INTEGER_0_127(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 127U, NULL, FALSE);

  return offset;
}
static int dissect_uncertaintyRadius(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_127(tvb, offset, actx, tree, hf_rnsap_uncertaintyRadius);
}
static int dissect_confidence(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_127(tvb, offset, actx, tree, hf_rnsap_confidence);
}
static int dissect_uncertaintyAltitude(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_127(tvb, offset, actx, tree, hf_rnsap_uncertaintyAltitude);
}
static int dissect_uncertaintySemi_major(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_127(tvb, offset, actx, tree, hf_rnsap_uncertaintySemi_major);
}
static int dissect_uncertaintySemi_minor(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_127(tvb, offset, actx, tree, hf_rnsap_uncertaintySemi_minor);
}
static int dissect_uncertaintyCode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_127(tvb, offset, actx, tree, hf_rnsap_uncertaintyCode);
}
static int dissect_code_Number(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_127(tvb, offset, actx, tree, hf_rnsap_code_Number);
}
static int dissect_shortTransActionId(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_127(tvb, offset, actx, tree, hf_rnsap_shortTransActionId);
}



static int
dissect_rnsap_INTEGER_0_32767(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 32767U, NULL, FALSE);

  return offset;
}
static int dissect_altitude(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_32767(tvb, offset, actx, tree, hf_rnsap_altitude);
}
static int dissect_longTransActionId(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_32767(tvb, offset, actx, tree, hf_rnsap_longTransActionId);
}


static const value_string rnsap_TransactionID_vals[] = {
  {   0, "shortTransActionId" },
  {   1, "longTransActionId" },
  { 0, NULL }
};

static const per_choice_t TransactionID_choice[] = {
  {   0, &hf_rnsap_shortTransActionId, ASN1_NO_EXTENSIONS     , dissect_rnsap_INTEGER_0_127 },
  {   1, &hf_rnsap_longTransActionId, ASN1_NO_EXTENSIONS     , dissect_rnsap_INTEGER_0_32767 },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_TransactionID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_TransactionID, TransactionID_choice,
                                 NULL);

  return offset;
}
static int dissect_transactionID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TransactionID(tvb, offset, actx, tree, hf_rnsap_transactionID);
}



static int
dissect_rnsap_InitiatingMessageValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
#line 35 "rnsap.cnf"

	offset = dissect_rnsap_InitiatingMessageValueValue(tvb, offset, actx, tree);



  return offset;
}
static int dissect_initiatingMessageValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_InitiatingMessageValue(tvb, offset, actx, tree, hf_rnsap_initiatingMessageValue);
}


static const per_sequence_t InitiatingMessage_sequence[] = {
  { &hf_rnsap_procedureID   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProcedureID },
  { &hf_rnsap_criticality   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Criticality },
  { &hf_rnsap_transactionID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_TransactionID },
  { &hf_rnsap_initiatingMessageValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_InitiatingMessageValue },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_InitiatingMessage(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_InitiatingMessage, InitiatingMessage_sequence);

  return offset;
}
static int dissect_initiatingMessage(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_InitiatingMessage(tvb, offset, actx, tree, hf_rnsap_initiatingMessage);
}



static int
dissect_rnsap_SuccessfulOutcomeValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
#line 39 "rnsap.cnf"

	offset = dissect_rnsap_SuccessfulOutcomeValueValue(tvb, offset, actx, tree);



  return offset;
}
static int dissect_successfulOutcomeValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_SuccessfulOutcomeValue(tvb, offset, actx, tree, hf_rnsap_successfulOutcomeValue);
}


static const per_sequence_t SuccessfulOutcome_sequence[] = {
  { &hf_rnsap_procedureID   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProcedureID },
  { &hf_rnsap_criticality   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Criticality },
  { &hf_rnsap_transactionID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_TransactionID },
  { &hf_rnsap_successfulOutcomeValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_SuccessfulOutcomeValue },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_SuccessfulOutcome(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_SuccessfulOutcome, SuccessfulOutcome_sequence);

  return offset;
}
static int dissect_successfulOutcome(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_SuccessfulOutcome(tvb, offset, actx, tree, hf_rnsap_successfulOutcome);
}



static int
dissect_rnsap_UnsuccessfulOutcomeValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
#line 51 "rnsap.cnf"

	offset = dissect_rnsap_UnsuccessfulOutcomeValueValue(tvb, offset, actx, tree);



  return offset;
}
static int dissect_unsuccessfulOutcomeValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UnsuccessfulOutcomeValue(tvb, offset, actx, tree, hf_rnsap_unsuccessfulOutcomeValue);
}


static const per_sequence_t UnsuccessfulOutcome_sequence[] = {
  { &hf_rnsap_procedureID   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProcedureID },
  { &hf_rnsap_criticality   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Criticality },
  { &hf_rnsap_transactionID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_TransactionID },
  { &hf_rnsap_unsuccessfulOutcomeValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_UnsuccessfulOutcomeValue },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UnsuccessfulOutcome(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UnsuccessfulOutcome, UnsuccessfulOutcome_sequence);

  return offset;
}
static int dissect_unsuccessfulOutcome(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UnsuccessfulOutcome(tvb, offset, actx, tree, hf_rnsap_unsuccessfulOutcome);
}



static int
dissect_rnsap_OutcomeValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
#line 43 "rnsap.cnf"
	/* FIX ME */
	guint length;

	offset = dissect_per_length_determinant(tvb, offset, actx, tree, hf_rnsap_pdu_length, &length);
	offset = offset + length;
	BYTE_ALIGN_OFFSET(offset)



  return offset;
}
static int dissect_outcomeValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_OutcomeValue(tvb, offset, actx, tree, hf_rnsap_outcomeValue);
}


static const per_sequence_t Outcome_sequence[] = {
  { &hf_rnsap_procedureID   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProcedureID },
  { &hf_rnsap_criticality   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Criticality },
  { &hf_rnsap_transactionID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_TransactionID },
  { &hf_rnsap_outcomeValue  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_OutcomeValue },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Outcome(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Outcome, Outcome_sequence);

  return offset;
}
static int dissect_outcome(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Outcome(tvb, offset, actx, tree, hf_rnsap_outcome);
}


static const value_string rnsap_RNSAP_PDU_vals[] = {
  {   0, "initiatingMessage" },
  {   1, "successfulOutcome" },
  {   2, "unsuccessfulOutcome" },
  {   3, "outcome" },
  { 0, NULL }
};

static const per_choice_t RNSAP_PDU_choice[] = {
  {   0, &hf_rnsap_initiatingMessage, ASN1_EXTENSION_ROOT    , dissect_rnsap_InitiatingMessage },
  {   1, &hf_rnsap_successfulOutcome, ASN1_EXTENSION_ROOT    , dissect_rnsap_SuccessfulOutcome },
  {   2, &hf_rnsap_unsuccessfulOutcome, ASN1_EXTENSION_ROOT    , dissect_rnsap_UnsuccessfulOutcome },
  {   3, &hf_rnsap_outcome       , ASN1_EXTENSION_ROOT    , dissect_rnsap_Outcome },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_RNSAP_PDU(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_RNSAP_PDU, RNSAP_PDU_choice,
                                 NULL);

  return offset;
}


static const value_string rnsap_ProtocolIE_ID_vals[] = {
  {   4, "id-AllowedQueuingTime" },
  {  42, "id-Allowed-Rate-Information" },
  { 309, "id-AntennaColocationIndicator" },
  {   5, "id-BindingID" },
  {   6, "id-C-ID" },
  {   7, "id-C-RNTI" },
  { 303, "id-Cell-Capacity-Class-Value" },
  {   8, "id-CFN" },
  {   9, "id-CN-CS-DomainIdentifier" },
  {  10, "id-CN-PS-DomainIdentifier" },
  {  11, "id-Cause" },
  { 310, "id-CoverageIndicator" },
  {  20, "id-CriticalityDiagnostics" },
  { 211, "id-ContextInfoItem-Reset" },
  { 515, "id-ContextGroupInfoItem-Reset" },
  {  21, "id-D-RNTI" },
  {  22, "id-D-RNTI-ReleaseIndication" },
  {  26, "id-DCHs-to-Add-FDD" },
  {  27, "id-DCHs-to-Add-TDD" },
  {  30, "id-DCH-DeleteList-RL-ReconfPrepFDD" },
  {  31, "id-DCH-DeleteList-RL-ReconfPrepTDD" },
  {  32, "id-DCH-DeleteList-RL-ReconfRqstFDD" },
  {  33, "id-DCH-DeleteList-RL-ReconfRqstTDD" },
  {  34, "id-DCH-FDD-Information" },
  {  35, "id-DCH-TDD-Information" },
  {  39, "id-FDD-DCHs-to-Modify" },
  {  40, "id-TDD-DCHs-to-Modify" },
  {  43, "id-DCH-InformationResponse" },
  {  38, "id-DCH-Rate-InformationItem-RL-CongestInd" },
  {  44, "id-DL-CCTrCH-InformationAddItem-RL-ReconfPrepTDD" },
  {  45, "id-DL-CCTrCH-InformationListIE-RL-ReconfReadyTDD" },
  {  46, "id-DL-CCTrCH-InformationDeleteItem-RL-ReconfRqstTDD" },
  {  47, "id-DL-CCTrCH-InformationItem-RL-SetupRqstTDD" },
  {  48, "id-DL-CCTrCH-InformationListIE-PhyChReconfRqstTDD" },
  {  49, "id-DL-CCTrCH-InformationListIE-RL-AdditionRspTDD" },
  {  50, "id-DL-CCTrCH-InformationListIE-RL-SetupRspTDD" },
  {  51, "id-DL-CCTrCH-InformationAddList-RL-ReconfPrepTDD" },
  {  52, "id-DL-CCTrCH-InformationDeleteList-RL-ReconfRqstTDD" },
  {  53, "id-DL-CCTrCH-InformationList-RL-SetupRqstTDD" },
  {  54, "id-FDD-DL-CodeInformation" },
  {  59, "id-DL-DPCH-Information-RL-ReconfPrepFDD" },
  {  60, "id-DL-DPCH-Information-RL-SetupRqstFDD" },
  {  61, "id-DL-DPCH-Information-RL-ReconfRqstFDD" },
  {  62, "id-DL-DPCH-InformationItem-PhyChReconfRqstTDD" },
  {  63, "id-DL-DPCH-InformationItem-RL-AdditionRspTDD" },
  {  64, "id-DL-DPCH-InformationItem-RL-SetupRspTDD" },
  { 278, "id-DL-DPCH-TimingAdjustment" },
  {  67, "id-DLReferencePower" },
  {  68, "id-DLReferencePowerList-DL-PC-Rqst" },
  {  69, "id-DL-ReferencePowerInformation-DL-PC-Rqst" },
  {  12, "id-DPC-Mode" },
  {  70, "id-DRXCycleLengthCoefficient" },
  { 470, "id-DedicatedMeasurementObjectType-DM-Fail-Ind" },
  { 471, "id-DedicatedMeasurementObjectType-DM-Fail" },
  {  71, "id-DedicatedMeasurementObjectType-DM-Rprt" },
  {  72, "id-DedicatedMeasurementObjectType-DM-Rqst" },
  {  73, "id-DedicatedMeasurementObjectType-DM-Rsp" },
  {  74, "id-DedicatedMeasurementType" },
  {  82, "id-FACH-InfoForUESelectedS-CCPCH-CTCH-ResourceRspFDD" },
  {  83, "id-FACH-InfoForUESelectedS-CCPCH-CTCH-ResourceRspTDD" },
  {  41, "id-Guaranteed-Rate-Information" },
  {  84, "id-IMSI" },
  { 311, "id-HCS-Prio" },
  {  85, "id-L3-Information" },
  {  90, "id-AdjustmentPeriod" },
  {  91, "id-MaxAdjustmentStep" },
  {  92, "id-MeasurementFilterCoefficient" },
  {  57, "id-MessageStructure" },
  {  93, "id-MeasurementID" },
  {  13, "id-Neighbouring-GSM-CellInformation" },
  {  95, "id-Neighbouring-UMTS-CellInformationItem" },
  { 305, "id-NRT-Load-Information-Value" },
  { 306, "id-NRT-Load-Information-Value-IncrDecrThres" },
  { 102, "id-PagingArea-PagingRqst" },
  { 103, "id-FACH-FlowControlInformation" },
  { 472, "id-PartialReportingIndicator" },
  {  17, "id-Permanent-NAS-UE-Identity" },
  { 107, "id-PowerAdjustmentType" },
  { 109, "id-RANAP-RelocationInformation" },
  { 110, "id-RL-Information-PhyChReconfRqstFDD" },
  { 111, "id-RL-Information-PhyChReconfRqstTDD" },
  { 112, "id-RL-Information-RL-AdditionRqstFDD" },
  { 113, "id-RL-Information-RL-AdditionRqstTDD" },
  { 114, "id-RL-Information-RL-DeletionRqst" },
  { 115, "id-RL-Information-RL-FailureInd" },
  { 116, "id-RL-Information-RL-ReconfPrepFDD" },
  { 117, "id-RL-Information-RL-RestoreInd" },
  { 118, "id-RL-Information-RL-SetupRqstFDD" },
  { 119, "id-RL-Information-RL-SetupRqstTDD" },
  {  55, "id-RL-InformationItem-RL-CongestInd" },
  { 120, "id-RL-InformationItem-DM-Rprt" },
  { 121, "id-RL-InformationItem-DM-Rqst" },
  { 122, "id-RL-InformationItem-DM-Rsp" },
  {   2, "id-RL-InformationItem-RL-PreemptRequiredInd" },
  { 123, "id-RL-InformationItem-RL-SetupRqstFDD" },
  {  56, "id-RL-InformationList-RL-CongestInd" },
  { 124, "id-RL-InformationList-RL-AdditionRqstFDD" },
  { 125, "id-RL-InformationList-RL-DeletionRqst" },
  {   1, "id-RL-InformationList-RL-PreemptRequiredInd" },
  { 126, "id-RL-InformationList-RL-ReconfPrepFDD" },
  { 127, "id-RL-InformationResponse-RL-AdditionRspTDD" },
  { 128, "id-RL-InformationResponse-RL-ReconfReadyTDD" },
  { 129, "id-RL-InformationResponse-RL-SetupRspTDD" },
  { 130, "id-RL-InformationResponseItem-RL-AdditionRspFDD" },
  { 131, "id-RL-InformationResponseItem-RL-ReconfReadyFDD" },
  { 132, "id-RL-InformationResponseItem-RL-ReconfRspFDD" },
  { 133, "id-RL-InformationResponseItem-RL-SetupRspFDD" },
  { 134, "id-RL-InformationResponseList-RL-AdditionRspFDD" },
  { 135, "id-RL-InformationResponseList-RL-ReconfReadyFDD" },
  { 136, "id-RL-InformationResponseList-RL-ReconfRspFDD" },
  {  28, "id-RL-InformationResponse-RL-ReconfRspTDD" },
  { 137, "id-RL-InformationResponseList-RL-SetupRspFDD" },
  { 141, "id-RL-ReconfigurationFailure-RL-ReconfFail" },
  { 143, "id-RL-Set-InformationItem-DM-Rprt" },
  { 144, "id-RL-Set-InformationItem-DM-Rqst" },
  { 145, "id-RL-Set-InformationItem-DM-Rsp" },
  { 146, "id-RL-Set-Information-RL-FailureInd" },
  { 147, "id-RL-Set-Information-RL-RestoreInd" },
  { 473, "id-RL-Set-Successful-InformationItem-DM-Fail" },
  { 474, "id-RL-Set-Unsuccessful-InformationItem-DM-Fail" },
  { 475, "id-RL-Set-Unsuccessful-InformationItem-DM-Fail-Ind" },
  { 476, "id-RL-Successful-InformationItem-DM-Fail" },
  { 477, "id-RL-Unsuccessful-InformationItem-DM-Fail" },
  { 478, "id-RL-Unsuccessful-InformationItem-DM-Fail-Ind" },
  { 152, "id-ReportCharacteristics" },
  { 153, "id-Reporting-Object-RL-FailureInd" },
  { 154, "id-Reporing-Object-RL-RestoreInd" },
  { 307, "id-RT-Load-Value" },
  { 308, "id-RT-Load-Value-IncrDecrThres" },
  { 155, "id-S-RNTI" },
  { 244, "id-ResetIndicator" },
  { 245, "id-RNC-ID" },
  { 156, "id-SAI" },
  { 157, "id-SRNC-ID" },
  { 159, "id-SuccessfulRL-InformationResponse-RL-AdditionFailureFDD" },
  { 160, "id-SuccessfulRL-InformationResponse-RL-SetupFailureFDD" },
  { 163, "id-TransportBearerID" },
  { 164, "id-TransportBearerRequestIndicator" },
  { 165, "id-TransportLayerAddress" },
  { 140, "id-TypeOfError" },
  { 166, "id-UC-ID" },
  { 167, "id-UL-CCTrCH-AddInformation-RL-ReconfPrepTDD" },
  { 169, "id-UL-CCTrCH-InformationAddList-RL-ReconfPrepTDD" },
  { 171, "id-UL-CCTrCH-InformationItem-RL-SetupRqstTDD" },
  { 172, "id-UL-CCTrCH-InformationList-RL-SetupRqstTDD" },
  { 173, "id-UL-CCTrCH-InformationListIE-PhyChReconfRqstTDD" },
  { 174, "id-UL-CCTrCH-InformationListIE-RL-AdditionRspTDD" },
  { 175, "id-UL-CCTrCH-InformationListIE-RL-ReconfReadyTDD" },
  { 176, "id-UL-CCTrCH-InformationListIE-RL-SetupRspTDD" },
  { 177, "id-UL-DPCH-Information-RL-ReconfPrepFDD" },
  { 178, "id-UL-DPCH-Information-RL-ReconfRqstFDD" },
  { 179, "id-UL-DPCH-Information-RL-SetupRqstFDD" },
  { 180, "id-UL-DPCH-InformationItem-PhyChReconfRqstTDD" },
  { 181, "id-UL-DPCH-InformationItem-RL-AdditionRspTDD" },
  { 182, "id-UL-DPCH-InformationItem-RL-SetupRspTDD" },
  { 183, "id-UL-DPCH-InformationAddListIE-RL-ReconfReadyTDD" },
  { 184, "id-UL-SIRTarget" },
  { 185, "id-URA-Information" },
  { 188, "id-UnsuccessfulRL-InformationResponse-RL-AdditionFailureFDD" },
  { 189, "id-UnsuccessfulRL-InformationResponse-RL-SetupFailureFDD" },
  { 190, "id-UnsuccessfulRL-InformationResponse-RL-SetupFailureTDD" },
  { 193, "id-Active-Pattern-Sequence-Information" },
  { 194, "id-AdjustmentRatio" },
  { 197, "id-CauseLevel-RL-AdditionFailureFDD" },
  { 198, "id-CauseLevel-RL-AdditionFailureTDD" },
  { 199, "id-CauseLevel-RL-ReconfFailure" },
  { 200, "id-CauseLevel-RL-SetupFailureFDD" },
  { 201, "id-CauseLevel-RL-SetupFailureTDD" },
  { 205, "id-DL-CCTrCH-InformationDeleteItem-RL-ReconfPrepTDD" },
  { 206, "id-DL-CCTrCH-InformationModifyItem-RL-ReconfPrepTDD" },
  { 207, "id-DL-CCTrCH-InformationModifyItem-RL-ReconfRqstTDD" },
  { 208, "id-DL-CCTrCH-InformationDeleteList-RL-ReconfPrepTDD" },
  { 209, "id-DL-CCTrCH-InformationModifyList-RL-ReconfPrepTDD" },
  { 210, "id-DL-CCTrCH-InformationModifyList-RL-ReconfRqstTDD" },
  { 212, "id-DL-DPCH-InformationAddListIE-RL-ReconfReadyTDD" },
  { 213, "id-DL-DPCH-InformationDeleteListIE-RL-ReconfReadyTDD" },
  { 214, "id-DL-DPCH-InformationModifyListIE-RL-ReconfReadyTDD" },
  { 215, "id-DSCHs-to-Add-TDD" },
  { 216, "id-Unused-ProtocolIE-ID-216" },
  { 217, "id-DSCH-DeleteList-RL-ReconfPrepTDD" },
  { 218, "id-Unused-ProtocolIE-ID-218" },
  { 219, "id-Unused-ProtocolIE-ID-219" },
  { 220, "id-DSCH-InformationListIE-RL-AdditionRspTDD" },
  { 221, "id-DSCH-InformationListIEs-RL-SetupRspTDD" },
  { 222, "id-DSCH-TDD-Information" },
  { 223, "id-Unused-ProtocolIE-ID-223" },
  { 226, "id-Unused-ProtocolIE-ID-226" },
  { 227, "id-DSCH-ModifyList-RL-ReconfPrepTDD" },
  { 228, "id-Unused-ProtocolIE-ID-228" },
  { 324, "id-Unused-ProtocolIE-ID-324" },
  { 229, "id-Unused-ProtocolIE-ID-229" },
  { 230, "id-DSCHToBeAddedOrModifiedList-RL-ReconfReadyTDD" },
  {  29, "id-Unused-ProtocolIE-ID-29" },
  { 225, "id-Unused-ProtocolIE-ID-225" },
  { 232, "id-GA-Cell" },
  {   3, "id-GA-CellAdditionalShapes" },
  { 246, "id-Unused-ProtocolIE-ID-246" },
  { 255, "id-Transmission-Gap-Pattern-Sequence-Information" },
  { 256, "id-UL-CCTrCH-DeleteInformation-RL-ReconfPrepTDD" },
  { 257, "id-UL-CCTrCH-ModifyInformation-RL-ReconfPrepTDD" },
  { 258, "id-UL-CCTrCH-InformationModifyItem-RL-ReconfRqstTDD" },
  { 259, "id-UL-CCTrCH-InformationDeleteList-RL-ReconfPrepTDD" },
  { 260, "id-UL-CCTrCH-InformationModifyList-RL-ReconfPrepTDD" },
  { 261, "id-UL-CCTrCH-InformationModifyList-RL-ReconfRqstTDD" },
  { 262, "id-UL-CCTrCH-InformationDeleteItem-RL-ReconfRqstTDD" },
  { 263, "id-UL-CCTrCH-InformationDeleteList-RL-ReconfRqstTDD" },
  { 264, "id-UL-DPCH-InformationDeleteListIE-RL-ReconfReadyTDD" },
  { 265, "id-UL-DPCH-InformationModifyListIE-RL-ReconfReadyTDD" },
  { 266, "id-UnsuccessfulRL-InformationResponse-RL-AdditionFailureTDD" },
  { 267, "id-USCHs-to-Add" },
  { 268, "id-USCH-DeleteList-RL-ReconfPrepTDD" },
  { 269, "id-USCH-InformationListIE-RL-AdditionRspTDD" },
  { 270, "id-USCH-InformationListIEs-RL-SetupRspTDD" },
  { 271, "id-USCH-Information" },
  { 272, "id-USCH-ModifyList-RL-ReconfPrepTDD" },
  { 273, "id-USCHToBeAddedOrModifiedList-RL-ReconfReadyTDD" },
  { 274, "id-DL-Physical-Channel-Information-RL-SetupRqstTDD" },
  { 275, "id-UL-Physical-Channel-Information-RL-SetupRqstTDD" },
  { 276, "id-ClosedLoopMode1-SupportIndicator" },
  { 277, "id-Unused-ProtocolIE-ID-277" },
  { 279, "id-STTD-SupportIndicator" },
  {  14, "id-CFNReportingIndicator" },
  {  23, "id-CNOriginatedPage-PagingRqst" },
  {  24, "id-InnerLoopDLPCStatus" },
  {  25, "id-PropagationDelay" },
  {  36, "id-RxTimingDeviationForTA" },
  {  37, "id-timeSlot-ISCP" },
  {  15, "id-CCTrCH-InformationItem-RL-FailureInd" },
  {  16, "id-CCTrCH-InformationItem-RL-RestoreInd" },
  { 280, "id-CommonMeasurementAccuracy" },
  { 281, "id-CommonMeasurementObjectType-CM-Rprt" },
  { 282, "id-CommonMeasurementObjectType-CM-Rqst" },
  { 283, "id-CommonMeasurementObjectType-CM-Rsp" },
  { 284, "id-CommonMeasurementType" },
  {  18, "id-CongestionCause" },
  { 285, "id-SFN" },
  { 286, "id-SFNReportingIndicator" },
  { 287, "id-InformationExchangeID" },
  { 288, "id-InformationExchangeObjectType-InfEx-Rprt" },
  { 289, "id-InformationExchangeObjectType-InfEx-Rqst" },
  { 290, "id-InformationExchangeObjectType-InfEx-Rsp" },
  { 291, "id-InformationReportCharacteristics" },
  { 292, "id-InformationType" },
  {  58, "id-neighbouring-LCR-TDD-CellInformation" },
  {  65, "id-DL-Timeslot-ISCP-LCR-Information-RL-SetupRqstTDD" },
  {  66, "id-RL-LCR-InformationResponse-RL-SetupRspTDD" },
  {  75, "id-UL-CCTrCH-LCR-InformationListIE-RL-SetupRspTDD" },
  {  76, "id-UL-DPCH-LCR-InformationItem-RL-SetupRspTDD" },
  {  77, "id-DL-CCTrCH-LCR-InformationListIE-RL-SetupRspTDD" },
  {  78, "id-DL-DPCH-LCR-InformationItem-RL-SetupRspTDD" },
  {  79, "id-DSCH-LCR-InformationListIEs-RL-SetupRspTDD" },
  {  80, "id-USCH-LCR-InformationListIEs-RL-SetupRspTDD" },
  {  81, "id-DL-Timeslot-ISCP-LCR-Information-RL-AdditionRqstTDD" },
  {  86, "id-RL-LCR-InformationResponse-RL-AdditionRspTDD" },
  {  87, "id-UL-CCTrCH-LCR-InformationListIE-RL-AdditionRspTDD" },
  {  88, "id-UL-DPCH-LCR-InformationItem-RL-AdditionRspTDD" },
  {  89, "id-DL-CCTrCH-LCR-InformationListIE-RL-AdditionRspTDD" },
  {  94, "id-DL-DPCH-LCR-InformationItem-RL-AdditionRspTDD" },
  {  96, "id-DSCH-LCR-InformationListIEs-RL-AdditionRspTDD" },
  {  97, "id-USCH-LCR-InformationListIEs-RL-AdditionRspTDD" },
  {  98, "id-UL-DPCH-LCR-InformationAddListIE-RL-ReconfReadyTDD" },
  { 100, "id-UL-Timeslot-LCR-InformationModifyList-RL-ReconfReadyTDD" },
  { 101, "id-DL-DPCH-LCR-InformationAddListIE-RL-ReconfReadyTDD" },
  { 104, "id-DL-Timeslot-LCR-InformationModifyList-RL-ReconfReadyTDD" },
  { 105, "id-UL-Timeslot-LCR-InformationList-PhyChReconfRqstTDD" },
  { 106, "id-DL-Timeslot-LCR-InformationList-PhyChReconfRqstTDD" },
  { 138, "id-timeSlot-ISCP-LCR-List-DL-PC-Rqst-TDD" },
  { 139, "id-TSTD-Support-Indicator-RL-SetupRqstTDD" },
  { 142, "id-RestrictionStateIndicator" },
  { 233, "id-Load-Value" },
  { 234, "id-Load-Value-IncrDecrThres" },
  { 235, "id-OnModification" },
  { 236, "id-Received-Total-Wideband-Power-Value" },
  { 237, "id-Received-Total-Wideband-Power-Value-IncrDecrThres" },
  { 238, "id-SFNSFNMeasurementThresholdInformation" },
  { 239, "id-Transmitted-Carrier-Power-Value" },
  { 240, "id-Transmitted-Carrier-Power-Value-IncrDecrThres" },
  { 241, "id-TUTRANGPSMeasurementThresholdInformation" },
  { 242, "id-UL-Timeslot-ISCP-Value" },
  { 243, "id-UL-Timeslot-ISCP-Value-IncrDecrThres" },
  { 293, "id-Rx-Timing-Deviation-Value-LCR" },
  {  19, "id-DPC-Mode-Change-SupportIndicator" },
  { 247, "id-Unused-ProtocolIE-ID-247" },
  { 295, "id-Unused-ProtocolIE-ID-295" },
  { 202, "id-PrimaryCCPCH-RSCP-RL-ReconfPrepTDD" },
  { 203, "id-DL-TimeSlot-ISCP-Info-RL-ReconfPrepTDD" },
  { 204, "id-DL-Timeslot-ISCP-LCR-Information-RL-ReconfPrepTDD" },
  { 249, "id-DSCH-RNTI" },
  { 296, "id-DL-PowerBalancing-Information" },
  { 297, "id-DL-PowerBalancing-ActivationIndicator" },
  { 298, "id-DL-PowerBalancing-UpdatedIndicator" },
  { 299, "id-DL-ReferencePowerInformation" },
  { 224, "id-Enhanced-PrimaryCPICH-EcNo" },
  { 252, "id-IPDL-TDD-ParametersLCR" },
  { 300, "id-CellCapabilityContainer-FDD" },
  { 301, "id-CellCapabilityContainer-TDD" },
  { 302, "id-CellCapabilityContainer-TDD-LCR" },
  { 317, "id-RL-Specific-DCH-Info" },
  { 318, "id-RL-ReconfigurationRequestFDD-RL-InformationList" },
  { 319, "id-RL-ReconfigurationRequestFDD-RL-Information-IEs" },
  { 321, "id-RL-ReconfigurationRequestTDD-RL-Information" },
  { 250, "id-CommonTransportChannelResourcesInitialisationNotRequired" },
  { 312, "id-DelayedActivation" },
  { 313, "id-DelayedActivationList-RL-ActivationCmdFDD" },
  { 314, "id-DelayedActivationInformation-RL-ActivationCmdFDD" },
  { 315, "id-DelayedActivationList-RL-ActivationCmdTDD" },
  { 316, "id-DelayedActivationInformation-RL-ActivationCmdTDD" },
  { 251, "id-neighbouringTDDCellMeasurementInformationLCR" },
  { 150, "id-UL-SIR-Target-CCTrCH-InformationItem-RL-SetupRspTDD" },
  { 151, "id-UL-SIR-Target-CCTrCH-LCR-InformationItem-RL-SetupRspTDD" },
  { 451, "id-PrimCCPCH-RSCP-DL-PC-RqstTDD" },
  { 452, "id-HSDSCH-FDD-Information" },
  { 453, "id-HSDSCH-FDD-Information-Response" },
  { 466, "id-HSDSCH-FDD-Update-Information" },
  { 456, "id-HSDSCH-Information-to-Modify" },
  { 516, "id-HSDSCHMacdFlowSpecificInformationList-RL-PreemptRequiredInd" },
  { 517, "id-HSDSCHMacdFlowSpecificInformationItem-RL-PreemptRequiredInd" },
  { 457, "id-HSDSCH-RNTI" },
  { 458, "id-HSDSCH-TDD-Information" },
  { 459, "id-HSDSCH-TDD-Information-Response" },
  { 467, "id-HSDSCH-TDD-Update-Information" },
  { 463, "id-HSPDSCH-RL-ID" },
  { 531, "id-HSDSCH-MACdFlows-to-Add" },
  { 532, "id-HSDSCH-MACdFlows-to-Delete" },
  { 148, "id-Angle-Of-Arrival-Value-LCR" },
  { 158, "id-TrafficClass" },
  { 248, "id-Unused-ProtocolIE-ID-248" },
  { 253, "id-Unused-ProtocolIE-ID-253" },
  { 323, "id-PDSCH-RL-ID" },
  { 325, "id-TimeSlot-RL-SetupRspTDD" },
  { 468, "id-GERAN-Cell-Capability" },
  { 469, "id-GERAN-Classmark" },
  { 480, "id-DSCH-InitialWindowSize" },
  { 464, "id-UL-Synchronisation-Parameters-LCR" },
  { 479, "id-SNA-Information" },
  { 465, "id-MAChs-ResetIndicator" },
  { 481, "id-TDD-DL-DPCH-TimeSlotFormatModifyItem-LCR-RL-ReconfReadyTDD" },
  { 482, "id-TDD-UL-DPCH-TimeSlotFormatModifyItem-LCR-RL-ReconfReadyTDD" },
  { 483, "id-TDD-TPC-UplinkStepSize-LCR-RL-SetupRqstTDD" },
  { 484, "id-UL-CCTrCH-InformationList-RL-AdditionRqstTDD" },
  { 485, "id-UL-CCTrCH-InformationItem-RL-AdditionRqstTDD" },
  { 486, "id-DL-CCTrCH-InformationList-RL-AdditionRqstTDD" },
  { 487, "id-DL-CCTrCH-InformationItem-RL-AdditionRqstTDD" },
  { 488, "id-TDD-TPC-UplinkStepSize-InformationAdd-LCR-RL-ReconfPrepTDD" },
  { 489, "id-TDD-TPC-UplinkStepSize-InformationModify-LCR-RL-ReconfPrepTDD" },
  { 490, "id-TDD-TPC-DownlinkStepSize-InformationAdd-RL-ReconfPrepTDD" },
  { 491, "id-TDD-TPC-DownlinkStepSize-InformationModify-RL-ReconfPrepTDD" },
  { 492, "id-UL-TimingAdvanceCtrl-LCR" },
  { 493, "id-HSPDSCH-Timeslot-InformationList-PhyChReconfRqstTDD" },
  { 494, "id-HSPDSCH-Timeslot-InformationListLCR-PhyChReconfRqstTDD" },
  { 495, "id-HS-SICH-Reception-Quality" },
  { 496, "id-HS-SICH-Reception-Quality-Measurement-Value" },
  { 497, "id-HSSICH-Info-DM-Rprt" },
  { 498, "id-HSSICH-Info-DM-Rqst" },
  { 499, "id-HSSICH-Info-DM" },
  { 500, "id-CCTrCH-Maximum-DL-Power-RL-SetupRspTDD" },
  { 501, "id-CCTrCH-Minimum-DL-Power-RL-SetupRspTDD" },
  { 502, "id-CCTrCH-Maximum-DL-Power-RL-AdditionRspTDD" },
  { 503, "id-CCTrCH-Minimum-DL-Power-RL-AdditionRspTDD" },
  { 504, "id-CCTrCH-Maximum-DL-Power-RL-ReconfReadyTDD" },
  { 505, "id-CCTrCH-Minimum-DL-Power-RL-ReconfReadyTDD" },
  { 506, "id-Maximum-DL-Power-TimeslotLCR-InformationModifyItem-RL-ReconfReadyTDD" },
  { 507, "id-Minimum-DL-Power-TimeslotLCR-InformationModifyItem-RL-ReconfReadyTDD" },
  { 508, "id-DL-CCTrCH-InformationList-RL-ReconfRspTDD" },
  { 509, "id-DL-DPCH-InformationModifyItem-LCR-RL-ReconfRspTDD" },
  { 510, "id-Maximum-DL-Power-TimeslotLCR-InformationItem" },
  { 511, "id-Minimum-DL-Power-TimeslotLCR-InformationItem" },
  { 512, "id-TDD-Support-8PSK" },
  { 513, "id-TDD-maxNrDLPhysicalchannels" },
  { 514, "id-ExtendedGSMCellIndividualOffset" },
  { 518, "id-RL-ParameterUpdateIndicationFDD-RL-InformationList" },
  { 519, "id-Primary-CPICH-Usage-For-Channel-Estimation" },
  { 520, "id-Secondary-CPICH-Information" },
  { 521, "id-Secondary-CPICH-Information-Change" },
  { 522, "id-Unused-ProtocolIE-ID-522" },
  { 523, "id-Unused-ProtocolIE-ID-523" },
  { 524, "id-RL-ParameterUpdateIndicationFDD-RL-Information-Item" },
  { 525, "id-Phase-Reference-Update-Indicator" },
  { 526, "id-Unidirectional-DCH-Indicator" },
  { 527, "id-RL-Information-RL-ReconfPrepTDD" },
  { 528, "id-Multiple-RL-InformationResponse-RL-ReconfReadyTDD" },
  { 529, "id-RL-ReconfigurationResponseTDD-RL-Information" },
  { 530, "id-Satellite-Almanac-Information-ExtItem" },
  { 533, "id-HSDSCH-Information-to-Modify-Unsynchronised" },
  { 534, "id-TnlQos" },
  { 535, "id-RTLoadValue" },
  { 536, "id-NRTLoadInformationValue" },
  { 537, "id-CellPortionID" },
  { 538, "id-UpPTSInterferenceValue" },
  { 539, "id-PrimaryCCPCH-RSCP-Delta" },
  { 540, "id-UEMeasurementType" },
  { 541, "id-UEMeasurementTimeslotInfoHCR" },
  { 542, "id-UEMeasurementTimeslotInfoLCR" },
  { 543, "id-UEMeasurementReportCharacteristics" },
  { 544, "id-UEMeasurementParameterModAllow" },
  { 545, "id-UEMeasurementValueInformation" },
  { 546, "id-InterfacesToTraceItem" },
  { 547, "id-ListOfInterfacesToTrace" },
  { 548, "id-TraceDepth" },
  { 549, "id-TraceRecordingSessionReference" },
  { 550, "id-TraceReference" },
  { 551, "id-UEIdentity" },
  { 552, "id-NACC-Related-Data" },
  { 553, "id-GSM-Cell-InfEx-Rqst" },
  { 554, "id-MeasurementRecoveryBehavior" },
  { 555, "id-MeasurementRecoveryReportingIndicator" },
  { 556, "id-MeasurementRecoverySupportIndicator" },
  { 557, "id-DL-DPCH-Power-Information-RL-ReconfPrepFDD" },
  { 558, "id-F-DPCH-Information-RL-ReconfPrepFDD" },
  { 559, "id-F-DPCH-Information-RL-SetupRqstFDD" },
  { 560, "id-MBMS-Bearer-Service-List" },
  { 561, "id-MBMS-Bearer-Service-List-InfEx-Rsp" },
  { 562, "id-Active-MBMS-Bearer-ServiceFDD" },
  { 563, "id-Active-MBMS-Bearer-ServiceTDD" },
  { 564, "id-Old-URA-ID" },
  { 568, "id-UE-State" },
  { 569, "id-URA-ID" },
  { 571, "id-HARQ-Preamble-Mode" },
  { 572, "id-SynchronisationIndicator" },
  { 573, "id-UL-DPDCHIndicatorEDCH" },
  { 574, "id-EDPCH-Information" },
  { 575, "id-RL-Specific-EDCH-Information" },
  { 576, "id-EDCH-RL-Indication" },
  { 577, "id-EDCH-FDD-Information" },
  { 578, "id-EDCH-RLSet-Id" },
  { 579, "id-Serving-EDCHRL-Id" },
  { 580, "id-EDCH-FDD-DL-ControlChannelInformation" },
  { 581, "id-EDCH-FDD-InformationResponse" },
  { 582, "id-EDCH-MACdFlows-To-Add" },
  { 583, "id-EDCH-FDD-Information-To-Modify" },
  { 584, "id-EDCH-MACdFlows-To-Delete" },
  { 585, "id-EDPCH-Information-RLReconfRequest-FDD" },
  { 586, "id-EDCH-MacdFlowSpecificInformationList-RL-PreemptRequiredInd" },
  { 587, "id-EDCH-MacdFlowSpecificInformationItem-RL-PreemptRequiredInd" },
  { 588, "id-EDCH-MacdFlowSpecificInformationList-RL-CongestInd" },
  { 589, "id-EDCH-MacdFlowSpecificInformationItem-RL-CongestInd" },
  { 590, "id-MBMS-Bearer-Service-Full-Address" },
  { 591, "id-Initial-DL-DPCH-TimingAdjustment" },
  { 592, "id-Initial-DL-DPCH-TimingAdjustment-Allowed" },
  { 593, "id-User-Plane-Congestion-Fields-Inclusion" },
  { 594, "id-HARQ-Preamble-Mode-Activation-Indicator" },
  { 595, "id-multiple-DedicatedMeasurementValueList-TDD-DM-Rsp" },
  { 596, "id-multiple-DedicatedMeasurementValueList-LCR-TDD-DM-Rsp" },
  { 597, "id-ProvidedInformation" },
  { 598, "id-Active-MBMS-Bearer-ServiceFDD-PFL" },
  { 599, "id-Active-MBMS-Bearer-ServiceTDD-PFL" },
  { 600, "id-FrequencyBandIndicator" },
  { 0, NULL }
};


static int
dissect_rnsap_ProtocolIE_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 65535U, &ProtocolIE_ID, FALSE);

  return offset;
}
static int dissect_iE_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_ID(tvb, offset, actx, tree, hf_rnsap_iE_ID);
}
static int dissect_id(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_ID(tvb, offset, actx, tree, hf_rnsap_id);
}



static int
dissect_rnsap_ProtocolIEValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
#line 55 "rnsap.cnf"

	offset = dissect_rnsap_ProtocolIEValueValue(tvb, offset, actx, tree);



  return offset;
}
static int dissect_value(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIEValue(tvb, offset, actx, tree, hf_rnsap_value);
}


static const per_sequence_t ProtocolIE_Field_sequence[] = {
  { &hf_rnsap_id            , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_ID },
  { &hf_rnsap_criticality   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Criticality },
  { &hf_rnsap_value         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIEValue },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_ProtocolIE_Field(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_ProtocolIE_Field, ProtocolIE_Field_sequence);

  return offset;
}
static int dissect_ProtocolIE_Container_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Field(tvb, offset, actx, tree, hf_rnsap_ProtocolIE_Container_item);
}


static const per_sequence_t ProtocolIE_Container_sequence_of[1] = {
  { &hf_rnsap_ProtocolIE_Container_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Field },
};

static int
dissect_rnsap_ProtocolIE_Container(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_ProtocolIE_Container, ProtocolIE_Container_sequence_of,
                                                  0, 65535);

  return offset;
}
static int dissect_protocolIEs(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Container(tvb, offset, actx, tree, hf_rnsap_protocolIEs);
}
static int dissect_ProtocolIE_ContainerList_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Container(tvb, offset, actx, tree, hf_rnsap_ProtocolIE_ContainerList_item);
}



static int
dissect_rnsap_Extension(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
#line 31 "rnsap.cnf"

	offset = dissect_rnsap_ProtocolIEValueValue(tvb, offset, actx, tree);



  return offset;
}
static int dissect_extensionValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Extension(tvb, offset, actx, tree, hf_rnsap_extensionValue);
}


static const per_sequence_t ProtocolExtensionField_sequence[] = {
  { &hf_rnsap_id            , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_ID },
  { &hf_rnsap_criticality   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Criticality },
  { &hf_rnsap_extensionValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Extension },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_ProtocolExtensionField(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_ProtocolExtensionField, ProtocolExtensionField_sequence);

  return offset;
}
static int dissect_ProtocolExtensionContainer_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolExtensionField(tvb, offset, actx, tree, hf_rnsap_ProtocolExtensionContainer_item);
}


static const per_sequence_t ProtocolExtensionContainer_sequence_of[1] = {
  { &hf_rnsap_ProtocolExtensionContainer_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolExtensionField },
};

static int
dissect_rnsap_ProtocolExtensionContainer(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_ProtocolExtensionContainer, ProtocolExtensionContainer_sequence_of,
                                                  1, 65535);

  return offset;
}
static int dissect_protocolExtensions(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolExtensionContainer(tvb, offset, actx, tree, hf_rnsap_protocolExtensions);
}
static int dissect_iE_Extensions(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolExtensionContainer(tvb, offset, actx, tree, hf_rnsap_iE_Extensions);
}
static int dissect_iEe_Extensions(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolExtensionContainer(tvb, offset, actx, tree, hf_rnsap_iEe_Extensions);
}


static const per_sequence_t CommonTransportChannelResourcesRequest_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CommonTransportChannelResourcesRequest(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CommonTransportChannelResourcesRequest, CommonTransportChannelResourcesRequest_sequence);

  return offset;
}
static int dissect_id_commonTransportChannelResourcesInitialisation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CommonTransportChannelResourcesRequest(tvb, offset, actx, tree, hf_rnsap_id_commonTransportChannelResourcesInitialisation);
}


static const per_sequence_t CommonTransportChannelResourcesReleaseRequest_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CommonTransportChannelResourcesReleaseRequest(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CommonTransportChannelResourcesReleaseRequest, CommonTransportChannelResourcesReleaseRequest_sequence);

  return offset;
}
static int dissect_id_commonTransportChannelResourcesRelease(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CommonTransportChannelResourcesReleaseRequest(tvb, offset, actx, tree, hf_rnsap_id_commonTransportChannelResourcesRelease);
}


static const per_sequence_t CompressedModeCommand_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CompressedModeCommand(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CompressedModeCommand, CompressedModeCommand_sequence);

  return offset;
}
static int dissect_id_compressedModeCommand(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CompressedModeCommand(tvb, offset, actx, tree, hf_rnsap_id_compressedModeCommand);
}


static const per_sequence_t DL_PowerControlRequest_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_PowerControlRequest(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_PowerControlRequest, DL_PowerControlRequest_sequence);

  return offset;
}
static int dissect_id_downlinkPowerControl(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_PowerControlRequest(tvb, offset, actx, tree, hf_rnsap_id_downlinkPowerControl);
}


static const per_sequence_t DL_PowerTimeslotControlRequest_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_PowerTimeslotControlRequest(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_PowerTimeslotControlRequest, DL_PowerTimeslotControlRequest_sequence);

  return offset;
}
static int dissect_id_downlinkPowerTimeslotControl(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_PowerTimeslotControlRequest(tvb, offset, actx, tree, hf_rnsap_id_downlinkPowerTimeslotControl);
}


static const per_sequence_t DownlinkSignallingTransferRequest_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DownlinkSignallingTransferRequest(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DownlinkSignallingTransferRequest, DownlinkSignallingTransferRequest_sequence);

  return offset;
}
static int dissect_id_downlinkSignallingTransfer(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DownlinkSignallingTransferRequest(tvb, offset, actx, tree, hf_rnsap_id_downlinkSignallingTransfer);
}


static const per_sequence_t ErrorIndication_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_ErrorIndication(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_ErrorIndication, ErrorIndication_sequence);

  return offset;
}
static int dissect_id_errorIndication(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ErrorIndication(tvb, offset, actx, tree, hf_rnsap_id_errorIndication);
}


static const per_sequence_t DedicatedMeasurementFailureIndication_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DedicatedMeasurementFailureIndication(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DedicatedMeasurementFailureIndication, DedicatedMeasurementFailureIndication_sequence);

  return offset;
}
static int dissect_id_dedicatedMeasurementFailure(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DedicatedMeasurementFailureIndication(tvb, offset, actx, tree, hf_rnsap_id_dedicatedMeasurementFailure);
}


static const per_sequence_t DedicatedMeasurementInitiationRequest_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DedicatedMeasurementInitiationRequest(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DedicatedMeasurementInitiationRequest, DedicatedMeasurementInitiationRequest_sequence);

  return offset;
}
static int dissect_id_dedicatedMeasurementInitiation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DedicatedMeasurementInitiationRequest(tvb, offset, actx, tree, hf_rnsap_id_dedicatedMeasurementInitiation);
}


static const per_sequence_t DedicatedMeasurementReport_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DedicatedMeasurementReport(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DedicatedMeasurementReport, DedicatedMeasurementReport_sequence);

  return offset;
}
static int dissect_id_dedicatedMeasurementReporting(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DedicatedMeasurementReport(tvb, offset, actx, tree, hf_rnsap_id_dedicatedMeasurementReporting);
}


static const per_sequence_t DedicatedMeasurementTerminationRequest_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DedicatedMeasurementTerminationRequest(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DedicatedMeasurementTerminationRequest, DedicatedMeasurementTerminationRequest_sequence);

  return offset;
}
static int dissect_id_dedicatedMeasurementTermination(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DedicatedMeasurementTerminationRequest(tvb, offset, actx, tree, hf_rnsap_id_dedicatedMeasurementTermination);
}


static const per_sequence_t PagingRequest_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_PagingRequest(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_PagingRequest, PagingRequest_sequence);

  return offset;
}
static int dissect_id_paging(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PagingRequest(tvb, offset, actx, tree, hf_rnsap_id_paging);
}


static const per_sequence_t PhysicalChannelReconfigurationRequestTDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_PhysicalChannelReconfigurationRequestTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_PhysicalChannelReconfigurationRequestTDD, PhysicalChannelReconfigurationRequestTDD_sequence);

  return offset;
}
static int dissect_id_physicalChannelReconfiguration(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PhysicalChannelReconfigurationRequestTDD(tvb, offset, actx, tree, hf_rnsap_id_physicalChannelReconfiguration);
}



static int
dissect_rnsap_INTEGER_0_65535(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 65535U, NULL, FALSE);

  return offset;
}
static int dissect_innerRadius(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_65535(tvb, offset, actx, tree, hf_rnsap_innerRadius);
}
static int dissect_ctfc16bit(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_65535(tvb, offset, actx, tree, hf_rnsap_ctfc16bit);
}
static int dissect_local(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_65535(tvb, offset, actx, tree, hf_rnsap_local);
}



static int
dissect_rnsap_OBJECT_IDENTIFIER(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_object_identifier(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}
static int dissect_global(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_OBJECT_IDENTIFIER(tvb, offset, actx, tree, hf_rnsap_global);
}


static const value_string rnsap_PrivateIE_ID_vals[] = {
  {   0, "local" },
  {   1, "global" },
  { 0, NULL }
};

static const per_choice_t PrivateIE_ID_choice[] = {
  {   0, &hf_rnsap_local         , ASN1_NO_EXTENSIONS     , dissect_rnsap_INTEGER_0_65535 },
  {   1, &hf_rnsap_global        , ASN1_NO_EXTENSIONS     , dissect_rnsap_OBJECT_IDENTIFIER },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_PrivateIE_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_PrivateIE_ID, PrivateIE_ID_choice,
                                 NULL);

  return offset;
}
static int dissect_privateIEid(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PrivateIE_ID(tvb, offset, actx, tree, hf_rnsap_privateIEid);
}



static int
dissect_rnsap_PrivateIEvalue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
#line 76 "rnsap.cnf"
	/* FIX ME */
	guint length;

	offset = dissect_per_length_determinant(tvb, offset, actx, tree, hf_rnsap_IE_length, &length);
	offset = offset + length;
	BYTE_ALIGN_OFFSET(offset)



  return offset;
}
static int dissect_privateIEvalue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PrivateIEvalue(tvb, offset, actx, tree, hf_rnsap_privateIEvalue);
}


static const per_sequence_t PrivateIE_Field_sequence[] = {
  { &hf_rnsap_privateIEid   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_PrivateIE_ID },
  { &hf_rnsap_criticality   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Criticality },
  { &hf_rnsap_privateIEvalue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_PrivateIEvalue },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_PrivateIE_Field(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_PrivateIE_Field, PrivateIE_Field_sequence);

  return offset;
}
static int dissect_PrivateIE_Container_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PrivateIE_Field(tvb, offset, actx, tree, hf_rnsap_PrivateIE_Container_item);
}


static const per_sequence_t PrivateIE_Container_sequence_of[1] = {
  { &hf_rnsap_PrivateIE_Container_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_PrivateIE_Field },
};

static int
dissect_rnsap_PrivateIE_Container(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_PrivateIE_Container, PrivateIE_Container_sequence_of,
                                                  1, 65535);

  return offset;
}
static int dissect_privateIEs(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PrivateIE_Container(tvb, offset, actx, tree, hf_rnsap_privateIEs);
}


static const per_sequence_t PrivateMessage_sequence[] = {
  { &hf_rnsap_privateIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PrivateIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_PrivateMessage(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_PrivateMessage, PrivateMessage_sequence);

  return offset;
}
static int dissect_id_privateMessage(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PrivateMessage(tvb, offset, actx, tree, hf_rnsap_id_privateMessage);
}


static const per_sequence_t RadioLinkAdditionRequestFDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkAdditionRequestFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkAdditionRequestFDD, RadioLinkAdditionRequestFDD_sequence);

  return offset;
}
static int dissect_id_radioLinkAddition(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkAdditionRequestFDD(tvb, offset, actx, tree, hf_rnsap_id_radioLinkAddition);
}


static const per_sequence_t RadioLinkAdditionRequestTDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkAdditionRequestTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkAdditionRequestTDD, RadioLinkAdditionRequestTDD_sequence);

  return offset;
}
static int dissect_id_radioLinkAddition_TDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkAdditionRequestTDD(tvb, offset, actx, tree, hf_rnsap_id_radioLinkAddition_TDD);
}


static const per_sequence_t RadioLinkCongestionIndication_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkCongestionIndication(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkCongestionIndication, RadioLinkCongestionIndication_sequence);

  return offset;
}
static int dissect_id_radioLinkCongestion(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkCongestionIndication(tvb, offset, actx, tree, hf_rnsap_id_radioLinkCongestion);
}


static const per_sequence_t RadioLinkDeletionRequest_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkDeletionRequest(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkDeletionRequest, RadioLinkDeletionRequest_sequence);

  return offset;
}
static int dissect_id_radioLinkDeletion(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkDeletionRequest(tvb, offset, actx, tree, hf_rnsap_id_radioLinkDeletion);
}


static const per_sequence_t RadioLinkFailureIndication_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkFailureIndication(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkFailureIndication, RadioLinkFailureIndication_sequence);

  return offset;
}
static int dissect_id_radioLinkFailure(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkFailureIndication(tvb, offset, actx, tree, hf_rnsap_id_radioLinkFailure);
}


static const per_sequence_t RadioLinkPreemptionRequiredIndication_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkPreemptionRequiredIndication(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkPreemptionRequiredIndication, RadioLinkPreemptionRequiredIndication_sequence);

  return offset;
}
static int dissect_id_radioLinkPreemption(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkPreemptionRequiredIndication(tvb, offset, actx, tree, hf_rnsap_id_radioLinkPreemption);
}


static const per_sequence_t RadioLinkRestoreIndication_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkRestoreIndication(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkRestoreIndication, RadioLinkRestoreIndication_sequence);

  return offset;
}
static int dissect_id_radioLinkRestoration(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkRestoreIndication(tvb, offset, actx, tree, hf_rnsap_id_radioLinkRestoration);
}


static const per_sequence_t RadioLinkSetupRequestFDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkSetupRequestFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkSetupRequestFDD, RadioLinkSetupRequestFDD_sequence);

  return offset;
}
static int dissect_id_radioLinkSetup(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkSetupRequestFDD(tvb, offset, actx, tree, hf_rnsap_id_radioLinkSetup);
}


static const per_sequence_t RadioLinkSetupRequestTDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkSetupRequestTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkSetupRequestTDD, RadioLinkSetupRequestTDD_sequence);

  return offset;
}
static int dissect_id_radioLinkSetupTdd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkSetupRequestTDD(tvb, offset, actx, tree, hf_rnsap_id_radioLinkSetupTdd);
}


static const per_sequence_t RelocationCommit_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RelocationCommit(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RelocationCommit, RelocationCommit_sequence);

  return offset;
}
static int dissect_id_relocationCommit(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RelocationCommit(tvb, offset, actx, tree, hf_rnsap_id_relocationCommit);
}


static const per_sequence_t RadioLinkReconfigurationCancel_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkReconfigurationCancel(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkReconfigurationCancel, RadioLinkReconfigurationCancel_sequence);

  return offset;
}
static int dissect_id_synchronisedRadioLinkReconfigurationCancellation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkReconfigurationCancel(tvb, offset, actx, tree, hf_rnsap_id_synchronisedRadioLinkReconfigurationCancellation);
}


static const per_sequence_t RadioLinkReconfigurationCommit_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkReconfigurationCommit(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkReconfigurationCommit, RadioLinkReconfigurationCommit_sequence);

  return offset;
}
static int dissect_id_synchronisedRadioLinkReconfigurationCommit(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkReconfigurationCommit(tvb, offset, actx, tree, hf_rnsap_id_synchronisedRadioLinkReconfigurationCommit);
}


static const per_sequence_t RadioLinkReconfigurationPrepareFDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkReconfigurationPrepareFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkReconfigurationPrepareFDD, RadioLinkReconfigurationPrepareFDD_sequence);

  return offset;
}
static int dissect_id_synchronisedRadioLinkReconfigurationPreparation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkReconfigurationPrepareFDD(tvb, offset, actx, tree, hf_rnsap_id_synchronisedRadioLinkReconfigurationPreparation);
}


static const per_sequence_t RadioLinkReconfigurationReadyTDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkReconfigurationReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkReconfigurationReadyTDD, RadioLinkReconfigurationReadyTDD_sequence);

  return offset;
}
static int dissect_id_synchronisedRadioLinkReconfigurationPreparation_TDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkReconfigurationReadyTDD(tvb, offset, actx, tree, hf_rnsap_id_synchronisedRadioLinkReconfigurationPreparation_TDD);
}


static const per_sequence_t RadioLinkReconfigurationRequestFDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkReconfigurationRequestFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkReconfigurationRequestFDD, RadioLinkReconfigurationRequestFDD_sequence);

  return offset;
}
static int dissect_id_unSynchronisedRadioLinkReconfiguration(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkReconfigurationRequestFDD(tvb, offset, actx, tree, hf_rnsap_id_unSynchronisedRadioLinkReconfiguration);
}


static const per_sequence_t RadioLinkReconfigurationRequestTDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkReconfigurationRequestTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkReconfigurationRequestTDD, RadioLinkReconfigurationRequestTDD_sequence);

  return offset;
}
static int dissect_id_unSynchronisedRadioLinkReconfiguration_TDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkReconfigurationRequestTDD(tvb, offset, actx, tree, hf_rnsap_id_unSynchronisedRadioLinkReconfiguration_TDD);
}


static const per_sequence_t UplinkSignallingTransferIndicationFDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UplinkSignallingTransferIndicationFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UplinkSignallingTransferIndicationFDD, UplinkSignallingTransferIndicationFDD_sequence);

  return offset;
}
static int dissect_id_uplinkSignallingTransfer(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UplinkSignallingTransferIndicationFDD(tvb, offset, actx, tree, hf_rnsap_id_uplinkSignallingTransfer);
}


static const per_sequence_t UplinkSignallingTransferIndicationTDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UplinkSignallingTransferIndicationTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UplinkSignallingTransferIndicationTDD, UplinkSignallingTransferIndicationTDD_sequence);

  return offset;
}
static int dissect_id_uplinkSignallingTransfer_TDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UplinkSignallingTransferIndicationTDD(tvb, offset, actx, tree, hf_rnsap_id_uplinkSignallingTransfer_TDD);
}


static const per_sequence_t CommonMeasurementFailureIndication_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CommonMeasurementFailureIndication(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CommonMeasurementFailureIndication, CommonMeasurementFailureIndication_sequence);

  return offset;
}
static int dissect_id_commonMeasurementFailure(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CommonMeasurementFailureIndication(tvb, offset, actx, tree, hf_rnsap_id_commonMeasurementFailure);
}


static const per_sequence_t CommonMeasurementInitiationRequest_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CommonMeasurementInitiationRequest(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CommonMeasurementInitiationRequest, CommonMeasurementInitiationRequest_sequence);

  return offset;
}
static int dissect_id_commonMeasurementInitiation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CommonMeasurementInitiationRequest(tvb, offset, actx, tree, hf_rnsap_id_commonMeasurementInitiation);
}


static const per_sequence_t CommonMeasurementReport_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CommonMeasurementReport(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CommonMeasurementReport, CommonMeasurementReport_sequence);

  return offset;
}
static int dissect_id_commonMeasurementReporting(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CommonMeasurementReport(tvb, offset, actx, tree, hf_rnsap_id_commonMeasurementReporting);
}


static const per_sequence_t CommonMeasurementTerminationRequest_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CommonMeasurementTerminationRequest(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CommonMeasurementTerminationRequest, CommonMeasurementTerminationRequest_sequence);

  return offset;
}
static int dissect_id_commonMeasurementTermination(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CommonMeasurementTerminationRequest(tvb, offset, actx, tree, hf_rnsap_id_commonMeasurementTermination);
}


static const per_sequence_t InformationExchangeFailureIndication_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_InformationExchangeFailureIndication(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_InformationExchangeFailureIndication, InformationExchangeFailureIndication_sequence);

  return offset;
}
static int dissect_id_informationExchangeFailure(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_InformationExchangeFailureIndication(tvb, offset, actx, tree, hf_rnsap_id_informationExchangeFailure);
}


static const per_sequence_t InformationExchangeInitiationRequest_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_InformationExchangeInitiationRequest(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_InformationExchangeInitiationRequest, InformationExchangeInitiationRequest_sequence);

  return offset;
}
static int dissect_id_informationExchangeInitiation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_InformationExchangeInitiationRequest(tvb, offset, actx, tree, hf_rnsap_id_informationExchangeInitiation);
}


static const per_sequence_t InformationReport_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_InformationReport(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_InformationReport, InformationReport_sequence);

  return offset;
}
static int dissect_id_informationReporting(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_InformationReport(tvb, offset, actx, tree, hf_rnsap_id_informationReporting);
}


static const per_sequence_t InformationExchangeTerminationRequest_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_InformationExchangeTerminationRequest(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_InformationExchangeTerminationRequest, InformationExchangeTerminationRequest_sequence);

  return offset;
}
static int dissect_id_informationExchangeTermination(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_InformationExchangeTerminationRequest(tvb, offset, actx, tree, hf_rnsap_id_informationExchangeTermination);
}


static const per_sequence_t ResetRequest_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_ResetRequest(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_ResetRequest, ResetRequest_sequence);

  return offset;
}
static int dissect_id_reset(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ResetRequest(tvb, offset, actx, tree, hf_rnsap_id_reset);
}


static const per_sequence_t RadioLinkActivationCommandFDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkActivationCommandFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkActivationCommandFDD, RadioLinkActivationCommandFDD_sequence);

  return offset;
}
static int dissect_id_radioLinkActivation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkActivationCommandFDD(tvb, offset, actx, tree, hf_rnsap_id_radioLinkActivation);
}


static const per_sequence_t RadioLinkActivationCommandTDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkActivationCommandTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkActivationCommandTDD, RadioLinkActivationCommandTDD_sequence);

  return offset;
}
static int dissect_id_radioLinkActivation_TDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkActivationCommandTDD(tvb, offset, actx, tree, hf_rnsap_id_radioLinkActivation_TDD);
}


static const per_sequence_t GERANUplinkSignallingTransferIndication_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GERANUplinkSignallingTransferIndication(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GERANUplinkSignallingTransferIndication, GERANUplinkSignallingTransferIndication_sequence);

  return offset;
}
static int dissect_id_gERANuplinkSignallingTransfer(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_GERANUplinkSignallingTransferIndication(tvb, offset, actx, tree, hf_rnsap_id_gERANuplinkSignallingTransfer);
}


static const per_sequence_t RadioLinkParameterUpdateIndicationFDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkParameterUpdateIndicationFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkParameterUpdateIndicationFDD, RadioLinkParameterUpdateIndicationFDD_sequence);

  return offset;
}
static int dissect_id_radioLinkParameterUpdate(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkParameterUpdateIndicationFDD(tvb, offset, actx, tree, hf_rnsap_id_radioLinkParameterUpdate);
}


static const per_sequence_t RadioLinkParameterUpdateIndicationTDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkParameterUpdateIndicationTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkParameterUpdateIndicationTDD, RadioLinkParameterUpdateIndicationTDD_sequence);

  return offset;
}
static int dissect_id_radioLinkParameterUpdate_TDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkParameterUpdateIndicationTDD(tvb, offset, actx, tree, hf_rnsap_id_radioLinkParameterUpdate_TDD);
}


static const per_sequence_t UEMeasurementFailureIndication_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UEMeasurementFailureIndication(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UEMeasurementFailureIndication, UEMeasurementFailureIndication_sequence);

  return offset;
}
static int dissect_id_uEMeasurementFailure(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UEMeasurementFailureIndication(tvb, offset, actx, tree, hf_rnsap_id_uEMeasurementFailure);
}


static const per_sequence_t UEMeasurementInitiationRequest_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UEMeasurementInitiationRequest(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UEMeasurementInitiationRequest, UEMeasurementInitiationRequest_sequence);

  return offset;
}
static int dissect_id_uEMeasurementInitiation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UEMeasurementInitiationRequest(tvb, offset, actx, tree, hf_rnsap_id_uEMeasurementInitiation);
}


static const per_sequence_t UEMeasurementReport_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UEMeasurementReport(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UEMeasurementReport, UEMeasurementReport_sequence);

  return offset;
}
static int dissect_id_uEMeasurementReporting(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UEMeasurementReport(tvb, offset, actx, tree, hf_rnsap_id_uEMeasurementReporting);
}


static const per_sequence_t UEMeasurementTerminationRequest_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UEMeasurementTerminationRequest(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UEMeasurementTerminationRequest, UEMeasurementTerminationRequest_sequence);

  return offset;
}
static int dissect_id_uEMeasurementTermination(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UEMeasurementTerminationRequest(tvb, offset, actx, tree, hf_rnsap_id_uEMeasurementTermination);
}


static const per_sequence_t IurDeactivateTrace_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_IurDeactivateTrace(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_IurDeactivateTrace, IurDeactivateTrace_sequence);

  return offset;
}
static int dissect_id_iurDeactivateTrace(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_IurDeactivateTrace(tvb, offset, actx, tree, hf_rnsap_id_iurDeactivateTrace);
}


static const per_sequence_t IurInvokeTrace_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_IurInvokeTrace(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_IurInvokeTrace, IurInvokeTrace_sequence);

  return offset;
}
static int dissect_id_iurInvokeTrace(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_IurInvokeTrace(tvb, offset, actx, tree, hf_rnsap_id_iurInvokeTrace);
}


static const per_sequence_t MBMSAttachCommand_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_MBMSAttachCommand(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_MBMSAttachCommand, MBMSAttachCommand_sequence);

  return offset;
}
static int dissect_id_mBMSAttach(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MBMSAttachCommand(tvb, offset, actx, tree, hf_rnsap_id_mBMSAttach);
}


static const per_sequence_t MBMSDetachCommand_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_MBMSDetachCommand(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_MBMSDetachCommand, MBMSDetachCommand_sequence);

  return offset;
}
static int dissect_id_mBMSDetach(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MBMSDetachCommand(tvb, offset, actx, tree, hf_rnsap_id_mBMSDetach);
}


static const per_sequence_t DirectInformationTransfer_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DirectInformationTransfer(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DirectInformationTransfer, DirectInformationTransfer_sequence);

  return offset;
}
static int dissect_id_directInformationTransfer(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DirectInformationTransfer(tvb, offset, actx, tree, hf_rnsap_id_directInformationTransfer);
}


static const value_string rnsap_DummyInitiatingValue_vals[] = {
  {   0, "id-commonTransportChannelResourcesInitialisation" },
  {   1, "id-commonTransportChannelResourcesRelease" },
  {   2, "id-compressedModeCommand" },
  {   3, "id-downlinkPowerControl" },
  {   4, "id-downlinkPowerTimeslotControl" },
  {   5, "id-downlinkSignallingTransfer" },
  {   6, "id-errorIndication" },
  {   7, "id-dedicatedMeasurementFailure" },
  {   8, "id-dedicatedMeasurementInitiation" },
  {   9, "id-dedicatedMeasurementReporting" },
  {  10, "id-dedicatedMeasurementTermination" },
  {  11, "id-paging" },
  {  12, "id-physicalChannelReconfiguration" },
  {  13, "id-privateMessage" },
  {  14, "id-radioLinkAddition" },
  {  15, "id-radioLinkAddition-TDD" },
  {  16, "id-radioLinkCongestion" },
  {  17, "id-radioLinkDeletion" },
  {  18, "id-radioLinkFailure" },
  {  19, "id-radioLinkPreemption" },
  {  20, "id-radioLinkRestoration" },
  {  21, "id-radioLinkSetup" },
  {  22, "id-radioLinkSetupTdd" },
  {  23, "id-relocationCommit" },
  {  24, "id-synchronisedRadioLinkReconfigurationCancellation" },
  {  25, "id-synchronisedRadioLinkReconfigurationCommit" },
  {  26, "id-synchronisedRadioLinkReconfigurationPreparation" },
  {  27, "id-synchronisedRadioLinkReconfigurationPreparation-TDD" },
  {  28, "id-unSynchronisedRadioLinkReconfiguration" },
  {  29, "id-unSynchronisedRadioLinkReconfiguration-TDD" },
  {  30, "id-uplinkSignallingTransfer" },
  {  31, "id-uplinkSignallingTransfer-TDD" },
  {  32, "id-commonMeasurementFailure" },
  {  33, "id-commonMeasurementInitiation" },
  {  34, "id-commonMeasurementReporting" },
  {  35, "id-commonMeasurementTermination" },
  {  36, "id-informationExchangeFailure" },
  {  37, "id-informationExchangeInitiation" },
  {  38, "id-informationReporting" },
  {  39, "id-informationExchangeTermination" },
  {  40, "id-reset" },
  {  41, "id-radioLinkActivation" },
  {  42, "id-radioLinkActivation-TDD" },
  {  43, "id-gERANuplinkSignallingTransfer" },
  {  44, "id-radioLinkParameterUpdate" },
  {  45, "id-radioLinkParameterUpdate-TDD" },
  {  46, "id-uEMeasurementFailure" },
  {  47, "id-uEMeasurementInitiation" },
  {  48, "id-uEMeasurementReporting" },
  {  49, "id-uEMeasurementTermination" },
  {  50, "id-iurDeactivateTrace" },
  {  51, "id-iurInvokeTrace" },
  {  52, "id-mBMSAttach" },
  {  53, "id-mBMSDetach" },
  {  54, "id-directInformationTransfer" },
  { 0, NULL }
};

static const per_choice_t DummyInitiatingValue_choice[] = {
  {   0, &hf_rnsap_id_commonTransportChannelResourcesInitialisation, ASN1_EXTENSION_ROOT    , dissect_rnsap_CommonTransportChannelResourcesRequest },
  {   1, &hf_rnsap_id_commonTransportChannelResourcesRelease, ASN1_EXTENSION_ROOT    , dissect_rnsap_CommonTransportChannelResourcesReleaseRequest },
  {   2, &hf_rnsap_id_compressedModeCommand, ASN1_EXTENSION_ROOT    , dissect_rnsap_CompressedModeCommand },
  {   3, &hf_rnsap_id_downlinkPowerControl, ASN1_EXTENSION_ROOT    , dissect_rnsap_DL_PowerControlRequest },
  {   4, &hf_rnsap_id_downlinkPowerTimeslotControl, ASN1_EXTENSION_ROOT    , dissect_rnsap_DL_PowerTimeslotControlRequest },
  {   5, &hf_rnsap_id_downlinkSignallingTransfer, ASN1_EXTENSION_ROOT    , dissect_rnsap_DownlinkSignallingTransferRequest },
  {   6, &hf_rnsap_id_errorIndication, ASN1_EXTENSION_ROOT    , dissect_rnsap_ErrorIndication },
  {   7, &hf_rnsap_id_dedicatedMeasurementFailure, ASN1_EXTENSION_ROOT    , dissect_rnsap_DedicatedMeasurementFailureIndication },
  {   8, &hf_rnsap_id_dedicatedMeasurementInitiation, ASN1_EXTENSION_ROOT    , dissect_rnsap_DedicatedMeasurementInitiationRequest },
  {   9, &hf_rnsap_id_dedicatedMeasurementReporting, ASN1_EXTENSION_ROOT    , dissect_rnsap_DedicatedMeasurementReport },
  {  10, &hf_rnsap_id_dedicatedMeasurementTermination, ASN1_EXTENSION_ROOT    , dissect_rnsap_DedicatedMeasurementTerminationRequest },
  {  11, &hf_rnsap_id_paging     , ASN1_EXTENSION_ROOT    , dissect_rnsap_PagingRequest },
  {  12, &hf_rnsap_id_physicalChannelReconfiguration, ASN1_EXTENSION_ROOT    , dissect_rnsap_PhysicalChannelReconfigurationRequestTDD },
  {  13, &hf_rnsap_id_privateMessage, ASN1_EXTENSION_ROOT    , dissect_rnsap_PrivateMessage },
  {  14, &hf_rnsap_id_radioLinkAddition, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkAdditionRequestFDD },
  {  15, &hf_rnsap_id_radioLinkAddition_TDD, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkAdditionRequestTDD },
  {  16, &hf_rnsap_id_radioLinkCongestion, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkCongestionIndication },
  {  17, &hf_rnsap_id_radioLinkDeletion, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkDeletionRequest },
  {  18, &hf_rnsap_id_radioLinkFailure, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkFailureIndication },
  {  19, &hf_rnsap_id_radioLinkPreemption, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkPreemptionRequiredIndication },
  {  20, &hf_rnsap_id_radioLinkRestoration, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkRestoreIndication },
  {  21, &hf_rnsap_id_radioLinkSetup, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkSetupRequestFDD },
  {  22, &hf_rnsap_id_radioLinkSetupTdd, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkSetupRequestTDD },
  {  23, &hf_rnsap_id_relocationCommit, ASN1_EXTENSION_ROOT    , dissect_rnsap_RelocationCommit },
  {  24, &hf_rnsap_id_synchronisedRadioLinkReconfigurationCancellation, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkReconfigurationCancel },
  {  25, &hf_rnsap_id_synchronisedRadioLinkReconfigurationCommit, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkReconfigurationCommit },
  {  26, &hf_rnsap_id_synchronisedRadioLinkReconfigurationPreparation, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkReconfigurationPrepareFDD },
  {  27, &hf_rnsap_id_synchronisedRadioLinkReconfigurationPreparation_TDD, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkReconfigurationReadyTDD },
  {  28, &hf_rnsap_id_unSynchronisedRadioLinkReconfiguration, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkReconfigurationRequestFDD },
  {  29, &hf_rnsap_id_unSynchronisedRadioLinkReconfiguration_TDD, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkReconfigurationRequestTDD },
  {  30, &hf_rnsap_id_uplinkSignallingTransfer, ASN1_EXTENSION_ROOT    , dissect_rnsap_UplinkSignallingTransferIndicationFDD },
  {  31, &hf_rnsap_id_uplinkSignallingTransfer_TDD, ASN1_EXTENSION_ROOT    , dissect_rnsap_UplinkSignallingTransferIndicationTDD },
  {  32, &hf_rnsap_id_commonMeasurementFailure, ASN1_EXTENSION_ROOT    , dissect_rnsap_CommonMeasurementFailureIndication },
  {  33, &hf_rnsap_id_commonMeasurementInitiation, ASN1_EXTENSION_ROOT    , dissect_rnsap_CommonMeasurementInitiationRequest },
  {  34, &hf_rnsap_id_commonMeasurementReporting, ASN1_EXTENSION_ROOT    , dissect_rnsap_CommonMeasurementReport },
  {  35, &hf_rnsap_id_commonMeasurementTermination, ASN1_EXTENSION_ROOT    , dissect_rnsap_CommonMeasurementTerminationRequest },
  {  36, &hf_rnsap_id_informationExchangeFailure, ASN1_EXTENSION_ROOT    , dissect_rnsap_InformationExchangeFailureIndication },
  {  37, &hf_rnsap_id_informationExchangeInitiation, ASN1_EXTENSION_ROOT    , dissect_rnsap_InformationExchangeInitiationRequest },
  {  38, &hf_rnsap_id_informationReporting, ASN1_EXTENSION_ROOT    , dissect_rnsap_InformationReport },
  {  39, &hf_rnsap_id_informationExchangeTermination, ASN1_EXTENSION_ROOT    , dissect_rnsap_InformationExchangeTerminationRequest },
  {  40, &hf_rnsap_id_reset      , ASN1_EXTENSION_ROOT    , dissect_rnsap_ResetRequest },
  {  41, &hf_rnsap_id_radioLinkActivation, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkActivationCommandFDD },
  {  42, &hf_rnsap_id_radioLinkActivation_TDD, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkActivationCommandTDD },
  {  43, &hf_rnsap_id_gERANuplinkSignallingTransfer, ASN1_EXTENSION_ROOT    , dissect_rnsap_GERANUplinkSignallingTransferIndication },
  {  44, &hf_rnsap_id_radioLinkParameterUpdate, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkParameterUpdateIndicationFDD },
  {  45, &hf_rnsap_id_radioLinkParameterUpdate_TDD, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkParameterUpdateIndicationTDD },
  {  46, &hf_rnsap_id_uEMeasurementFailure, ASN1_EXTENSION_ROOT    , dissect_rnsap_UEMeasurementFailureIndication },
  {  47, &hf_rnsap_id_uEMeasurementInitiation, ASN1_EXTENSION_ROOT    , dissect_rnsap_UEMeasurementInitiationRequest },
  {  48, &hf_rnsap_id_uEMeasurementReporting, ASN1_EXTENSION_ROOT    , dissect_rnsap_UEMeasurementReport },
  {  49, &hf_rnsap_id_uEMeasurementTermination, ASN1_EXTENSION_ROOT    , dissect_rnsap_UEMeasurementTerminationRequest },
  {  50, &hf_rnsap_id_iurDeactivateTrace, ASN1_EXTENSION_ROOT    , dissect_rnsap_IurDeactivateTrace },
  {  51, &hf_rnsap_id_iurInvokeTrace, ASN1_EXTENSION_ROOT    , dissect_rnsap_IurInvokeTrace },
  {  52, &hf_rnsap_id_mBMSAttach , ASN1_EXTENSION_ROOT    , dissect_rnsap_MBMSAttachCommand },
  {  53, &hf_rnsap_id_mBMSDetach , ASN1_EXTENSION_ROOT    , dissect_rnsap_MBMSDetachCommand },
  {  54, &hf_rnsap_id_directInformationTransfer, ASN1_EXTENSION_ROOT    , dissect_rnsap_DirectInformationTransfer },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_DummyInitiatingValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_DummyInitiatingValue, DummyInitiatingValue_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CommonTransportChannelResourcesResponseFDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CommonTransportChannelResourcesResponseFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CommonTransportChannelResourcesResponseFDD, CommonTransportChannelResourcesResponseFDD_sequence);

  return offset;
}
static int dissect_id_commonTransportChannelResourcesInitialisation1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CommonTransportChannelResourcesResponseFDD(tvb, offset, actx, tree, hf_rnsap_id_commonTransportChannelResourcesInitialisation1);
}


static const per_sequence_t CommonTransportChannelResourcesResponseTDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CommonTransportChannelResourcesResponseTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CommonTransportChannelResourcesResponseTDD, CommonTransportChannelResourcesResponseTDD_sequence);

  return offset;
}
static int dissect_id_commonTransportChannelResourcesInitialisation_TDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CommonTransportChannelResourcesResponseTDD(tvb, offset, actx, tree, hf_rnsap_id_commonTransportChannelResourcesInitialisation_TDD);
}


static const per_sequence_t DedicatedMeasurementInitiationResponse_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DedicatedMeasurementInitiationResponse(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DedicatedMeasurementInitiationResponse, DedicatedMeasurementInitiationResponse_sequence);

  return offset;
}
static int dissect_id_dedicatedMeasurementInitiation1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DedicatedMeasurementInitiationResponse(tvb, offset, actx, tree, hf_rnsap_id_dedicatedMeasurementInitiation1);
}


static const per_sequence_t PhysicalChannelReconfigurationCommand_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_PhysicalChannelReconfigurationCommand(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_PhysicalChannelReconfigurationCommand, PhysicalChannelReconfigurationCommand_sequence);

  return offset;
}
static int dissect_id_physicalChannelReconfiguration1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PhysicalChannelReconfigurationCommand(tvb, offset, actx, tree, hf_rnsap_id_physicalChannelReconfiguration1);
}


static const per_sequence_t RadioLinkAdditionResponseFDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkAdditionResponseFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkAdditionResponseFDD, RadioLinkAdditionResponseFDD_sequence);

  return offset;
}
static int dissect_id_radioLinkAddition1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkAdditionResponseFDD(tvb, offset, actx, tree, hf_rnsap_id_radioLinkAddition1);
}


static const per_sequence_t RadioLinkAdditionResponseTDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkAdditionResponseTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkAdditionResponseTDD, RadioLinkAdditionResponseTDD_sequence);

  return offset;
}
static int dissect_id_radioLinkAddition_TDD1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkAdditionResponseTDD(tvb, offset, actx, tree, hf_rnsap_id_radioLinkAddition_TDD1);
}


static const per_sequence_t RadioLinkDeletionResponse_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkDeletionResponse(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkDeletionResponse, RadioLinkDeletionResponse_sequence);

  return offset;
}
static int dissect_id_radioLinkDeletion1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkDeletionResponse(tvb, offset, actx, tree, hf_rnsap_id_radioLinkDeletion1);
}


static const per_sequence_t RadioLinkSetupResponseFDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkSetupResponseFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkSetupResponseFDD, RadioLinkSetupResponseFDD_sequence);

  return offset;
}
static int dissect_id_radioLinkSetup1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkSetupResponseFDD(tvb, offset, actx, tree, hf_rnsap_id_radioLinkSetup1);
}


static const per_sequence_t RadioLinkSetupResponseTDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkSetupResponseTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkSetupResponseTDD, RadioLinkSetupResponseTDD_sequence);

  return offset;
}
static int dissect_id_radioLinkSetupTdd1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkSetupResponseTDD(tvb, offset, actx, tree, hf_rnsap_id_radioLinkSetupTdd1);
}


static const per_sequence_t RadioLinkReconfigurationReadyFDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkReconfigurationReadyFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkReconfigurationReadyFDD, RadioLinkReconfigurationReadyFDD_sequence);

  return offset;
}
static int dissect_id_synchronisedRadioLinkReconfigurationPreparation1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkReconfigurationReadyFDD(tvb, offset, actx, tree, hf_rnsap_id_synchronisedRadioLinkReconfigurationPreparation1);
}


static const per_sequence_t RadioLinkReconfigurationResponseFDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkReconfigurationResponseFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkReconfigurationResponseFDD, RadioLinkReconfigurationResponseFDD_sequence);

  return offset;
}
static int dissect_id_unSynchronisedRadioLinkReconfiguration1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkReconfigurationResponseFDD(tvb, offset, actx, tree, hf_rnsap_id_unSynchronisedRadioLinkReconfiguration1);
}


static const per_sequence_t RadioLinkReconfigurationResponseTDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkReconfigurationResponseTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkReconfigurationResponseTDD, RadioLinkReconfigurationResponseTDD_sequence);

  return offset;
}
static int dissect_id_unSynchronisedRadioLinkReconfiguration_TDD1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkReconfigurationResponseTDD(tvb, offset, actx, tree, hf_rnsap_id_unSynchronisedRadioLinkReconfiguration_TDD1);
}


static const per_sequence_t CommonMeasurementInitiationResponse_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CommonMeasurementInitiationResponse(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CommonMeasurementInitiationResponse, CommonMeasurementInitiationResponse_sequence);

  return offset;
}
static int dissect_id_commonMeasurementInitiation1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CommonMeasurementInitiationResponse(tvb, offset, actx, tree, hf_rnsap_id_commonMeasurementInitiation1);
}


static const per_sequence_t InformationExchangeInitiationResponse_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_InformationExchangeInitiationResponse(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_InformationExchangeInitiationResponse, InformationExchangeInitiationResponse_sequence);

  return offset;
}
static int dissect_id_informationExchangeInitiation1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_InformationExchangeInitiationResponse(tvb, offset, actx, tree, hf_rnsap_id_informationExchangeInitiation1);
}


static const per_sequence_t ResetResponse_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_ResetResponse(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_ResetResponse, ResetResponse_sequence);

  return offset;
}
static int dissect_id_reset1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ResetResponse(tvb, offset, actx, tree, hf_rnsap_id_reset1);
}


static const per_sequence_t UEMeasurementInitiationResponse_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UEMeasurementInitiationResponse(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UEMeasurementInitiationResponse, UEMeasurementInitiationResponse_sequence);

  return offset;
}
static int dissect_id_uEMeasurementInitiation1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UEMeasurementInitiationResponse(tvb, offset, actx, tree, hf_rnsap_id_uEMeasurementInitiation1);
}


static const value_string rnsap_DummySuccessfulOutcomeValue_vals[] = {
  {   0, "id-commonTransportChannelResourcesInitialisation" },
  {   1, "id-commonTransportChannelResourcesInitialisation-TDD" },
  {   2, "id-dedicatedMeasurementInitiation" },
  {   3, "id-physicalChannelReconfiguration" },
  {   4, "id-radioLinkAddition" },
  {   5, "id-radioLinkAddition-TDD" },
  {   6, "id-radioLinkDeletion" },
  {   7, "id-radioLinkSetup" },
  {   8, "id-radioLinkSetupTdd" },
  {   9, "id-synchronisedRadioLinkReconfigurationPreparation" },
  {  10, "id-synchronisedRadioLinkReconfigurationPreparation-TDD" },
  {  11, "id-unSynchronisedRadioLinkReconfiguration" },
  {  12, "id-unSynchronisedRadioLinkReconfiguration-TDD" },
  {  13, "id-commonMeasurementInitiation" },
  {  14, "id-informationExchangeInitiation" },
  {  15, "id-reset" },
  {  16, "id-uEMeasurementInitiation" },
  { 0, NULL }
};

static const per_choice_t DummySuccessfulOutcomeValue_choice[] = {
  {   0, &hf_rnsap_id_commonTransportChannelResourcesInitialisation1, ASN1_EXTENSION_ROOT    , dissect_rnsap_CommonTransportChannelResourcesResponseFDD },
  {   1, &hf_rnsap_id_commonTransportChannelResourcesInitialisation_TDD, ASN1_EXTENSION_ROOT    , dissect_rnsap_CommonTransportChannelResourcesResponseTDD },
  {   2, &hf_rnsap_id_dedicatedMeasurementInitiation1, ASN1_EXTENSION_ROOT    , dissect_rnsap_DedicatedMeasurementInitiationResponse },
  {   3, &hf_rnsap_id_physicalChannelReconfiguration1, ASN1_EXTENSION_ROOT    , dissect_rnsap_PhysicalChannelReconfigurationCommand },
  {   4, &hf_rnsap_id_radioLinkAddition1, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkAdditionResponseFDD },
  {   5, &hf_rnsap_id_radioLinkAddition_TDD1, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkAdditionResponseTDD },
  {   6, &hf_rnsap_id_radioLinkDeletion1, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkDeletionResponse },
  {   7, &hf_rnsap_id_radioLinkSetup1, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkSetupResponseFDD },
  {   8, &hf_rnsap_id_radioLinkSetupTdd1, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkSetupResponseTDD },
  {   9, &hf_rnsap_id_synchronisedRadioLinkReconfigurationPreparation1, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkReconfigurationReadyFDD },
  {  10, &hf_rnsap_id_synchronisedRadioLinkReconfigurationPreparation_TDD, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkReconfigurationReadyTDD },
  {  11, &hf_rnsap_id_unSynchronisedRadioLinkReconfiguration1, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkReconfigurationResponseFDD },
  {  12, &hf_rnsap_id_unSynchronisedRadioLinkReconfiguration_TDD1, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkReconfigurationResponseTDD },
  {  13, &hf_rnsap_id_commonMeasurementInitiation1, ASN1_EXTENSION_ROOT    , dissect_rnsap_CommonMeasurementInitiationResponse },
  {  14, &hf_rnsap_id_informationExchangeInitiation1, ASN1_EXTENSION_ROOT    , dissect_rnsap_InformationExchangeInitiationResponse },
  {  15, &hf_rnsap_id_reset1     , ASN1_EXTENSION_ROOT    , dissect_rnsap_ResetResponse },
  {  16, &hf_rnsap_id_uEMeasurementInitiation1, ASN1_EXTENSION_ROOT    , dissect_rnsap_UEMeasurementInitiationResponse },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_DummySuccessfulOutcomeValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_DummySuccessfulOutcomeValue, DummySuccessfulOutcomeValue_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CommonTransportChannelResourcesFailure_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CommonTransportChannelResourcesFailure(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CommonTransportChannelResourcesFailure, CommonTransportChannelResourcesFailure_sequence);

  return offset;
}
static int dissect_id_commonTransportChannelResourcesInitialisation2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CommonTransportChannelResourcesFailure(tvb, offset, actx, tree, hf_rnsap_id_commonTransportChannelResourcesInitialisation2);
}


static const per_sequence_t DedicatedMeasurementInitiationFailure_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DedicatedMeasurementInitiationFailure(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DedicatedMeasurementInitiationFailure, DedicatedMeasurementInitiationFailure_sequence);

  return offset;
}
static int dissect_id_dedicatedMeasurementInitiation2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DedicatedMeasurementInitiationFailure(tvb, offset, actx, tree, hf_rnsap_id_dedicatedMeasurementInitiation2);
}


static const per_sequence_t PhysicalChannelReconfigurationFailure_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_PhysicalChannelReconfigurationFailure(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_PhysicalChannelReconfigurationFailure, PhysicalChannelReconfigurationFailure_sequence);

  return offset;
}
static int dissect_id_physicalChannelReconfiguration2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PhysicalChannelReconfigurationFailure(tvb, offset, actx, tree, hf_rnsap_id_physicalChannelReconfiguration2);
}


static const per_sequence_t RadioLinkAdditionFailureFDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkAdditionFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkAdditionFailureFDD, RadioLinkAdditionFailureFDD_sequence);

  return offset;
}
static int dissect_id_radioLinkAddition2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkAdditionFailureFDD(tvb, offset, actx, tree, hf_rnsap_id_radioLinkAddition2);
}


static const per_sequence_t RadioLinkAdditionFailureTDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkAdditionFailureTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkAdditionFailureTDD, RadioLinkAdditionFailureTDD_sequence);

  return offset;
}
static int dissect_id_radioLinkAddition_TDD2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkAdditionFailureTDD(tvb, offset, actx, tree, hf_rnsap_id_radioLinkAddition_TDD2);
}


static const per_sequence_t RadioLinkSetupFailureFDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkSetupFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkSetupFailureFDD, RadioLinkSetupFailureFDD_sequence);

  return offset;
}
static int dissect_id_radioLinkSetup2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkSetupFailureFDD(tvb, offset, actx, tree, hf_rnsap_id_radioLinkSetup2);
}


static const per_sequence_t RadioLinkSetupFailureTDD_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkSetupFailureTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkSetupFailureTDD, RadioLinkSetupFailureTDD_sequence);

  return offset;
}
static int dissect_id_radioLinkSetupTdd2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkSetupFailureTDD(tvb, offset, actx, tree, hf_rnsap_id_radioLinkSetupTdd2);
}


static const per_sequence_t RadioLinkReconfigurationFailure_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RadioLinkReconfigurationFailure(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RadioLinkReconfigurationFailure, RadioLinkReconfigurationFailure_sequence);

  return offset;
}
static int dissect_id_synchronisedRadioLinkReconfigurationPreparation2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkReconfigurationFailure(tvb, offset, actx, tree, hf_rnsap_id_synchronisedRadioLinkReconfigurationPreparation2);
}
static int dissect_id_unSynchronisedRadioLinkReconfiguration2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkReconfigurationFailure(tvb, offset, actx, tree, hf_rnsap_id_unSynchronisedRadioLinkReconfiguration2);
}
static int dissect_id_unSynchronisedRadioLinkReconfiguration_TDD2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RadioLinkReconfigurationFailure(tvb, offset, actx, tree, hf_rnsap_id_unSynchronisedRadioLinkReconfiguration_TDD2);
}


static const per_sequence_t CommonMeasurementInitiationFailure_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CommonMeasurementInitiationFailure(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CommonMeasurementInitiationFailure, CommonMeasurementInitiationFailure_sequence);

  return offset;
}
static int dissect_id_commonMeasurementInitiation2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CommonMeasurementInitiationFailure(tvb, offset, actx, tree, hf_rnsap_id_commonMeasurementInitiation2);
}


static const per_sequence_t InformationExchangeInitiationFailure_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_InformationExchangeInitiationFailure(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_InformationExchangeInitiationFailure, InformationExchangeInitiationFailure_sequence);

  return offset;
}
static int dissect_id_informationExchangeInitiation2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_InformationExchangeInitiationFailure(tvb, offset, actx, tree, hf_rnsap_id_informationExchangeInitiation2);
}


static const per_sequence_t UEMeasurementInitiationFailure_sequence[] = {
  { &hf_rnsap_protocolIEs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Container },
  { &hf_rnsap_protocolExtensions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UEMeasurementInitiationFailure(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UEMeasurementInitiationFailure, UEMeasurementInitiationFailure_sequence);

  return offset;
}
static int dissect_id_uEMeasurementInitiation2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UEMeasurementInitiationFailure(tvb, offset, actx, tree, hf_rnsap_id_uEMeasurementInitiation2);
}


static const value_string rnsap_DummyUnSuccessfulOutcomeValue_vals[] = {
  {   0, "id-commonTransportChannelResourcesInitialisation" },
  {   1, "id-dedicatedMeasurementInitiation" },
  {   2, "id-physicalChannelReconfiguration" },
  {   3, "id-radioLinkAddition" },
  {   4, "id-radioLinkAddition-TDD" },
  {   5, "id-radioLinkSetup" },
  {   6, "id-radioLinkSetupTdd" },
  {   7, "id-synchronisedRadioLinkReconfigurationPreparation" },
  {   8, "id-unSynchronisedRadioLinkReconfiguration" },
  {   9, "id-unSynchronisedRadioLinkReconfiguration-TDD" },
  {  10, "id-commonMeasurementInitiation" },
  {  11, "id-informationExchangeInitiation" },
  {  12, "id-uEMeasurementInitiation" },
  { 0, NULL }
};

static const per_choice_t DummyUnSuccessfulOutcomeValue_choice[] = {
  {   0, &hf_rnsap_id_commonTransportChannelResourcesInitialisation2, ASN1_EXTENSION_ROOT    , dissect_rnsap_CommonTransportChannelResourcesFailure },
  {   1, &hf_rnsap_id_dedicatedMeasurementInitiation2, ASN1_EXTENSION_ROOT    , dissect_rnsap_DedicatedMeasurementInitiationFailure },
  {   2, &hf_rnsap_id_physicalChannelReconfiguration2, ASN1_EXTENSION_ROOT    , dissect_rnsap_PhysicalChannelReconfigurationFailure },
  {   3, &hf_rnsap_id_radioLinkAddition2, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkAdditionFailureFDD },
  {   4, &hf_rnsap_id_radioLinkAddition_TDD2, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkAdditionFailureTDD },
  {   5, &hf_rnsap_id_radioLinkSetup2, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkSetupFailureFDD },
  {   6, &hf_rnsap_id_radioLinkSetupTdd2, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkSetupFailureTDD },
  {   7, &hf_rnsap_id_synchronisedRadioLinkReconfigurationPreparation2, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkReconfigurationFailure },
  {   8, &hf_rnsap_id_unSynchronisedRadioLinkReconfiguration2, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkReconfigurationFailure },
  {   9, &hf_rnsap_id_unSynchronisedRadioLinkReconfiguration_TDD2, ASN1_EXTENSION_ROOT    , dissect_rnsap_RadioLinkReconfigurationFailure },
  {  10, &hf_rnsap_id_commonMeasurementInitiation2, ASN1_EXTENSION_ROOT    , dissect_rnsap_CommonMeasurementInitiationFailure },
  {  11, &hf_rnsap_id_informationExchangeInitiation2, ASN1_EXTENSION_ROOT    , dissect_rnsap_InformationExchangeInitiationFailure },
  {  12, &hf_rnsap_id_uEMeasurementInitiation2, ASN1_EXTENSION_ROOT    , dissect_rnsap_UEMeasurementInitiationFailure },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_DummyUnSuccessfulOutcomeValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_DummyUnSuccessfulOutcomeValue, DummyUnSuccessfulOutcomeValue_choice,
                                 NULL);

  return offset;
}



static int
dissect_rnsap_AllowedQueuingTime(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              1U, 60U, NULL, FALSE);

  return offset;
}
static int dissect_id_AllowedQueuingTime(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_AllowedQueuingTime(tvb, offset, actx, tree, hf_rnsap_id_AllowedQueuingTime);
}



static int
dissect_rnsap_Allowed_Rate(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              1U, 32U, NULL, FALSE);

  return offset;
}
static int dissect_allowed_UL_Rate(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Allowed_Rate(tvb, offset, actx, tree, hf_rnsap_allowed_UL_Rate);
}
static int dissect_allowed_DL_Rate(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Allowed_Rate(tvb, offset, actx, tree, hf_rnsap_allowed_DL_Rate);
}


static const per_sequence_t Allowed_Rate_Information_sequence[] = {
  { &hf_rnsap_allowed_UL_Rate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Allowed_Rate },
  { &hf_rnsap_allowed_DL_Rate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Allowed_Rate },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Allowed_Rate_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Allowed_Rate_Information, Allowed_Rate_Information_sequence);

  return offset;
}
static int dissect_id_Allowed_Rate_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Allowed_Rate_Information(tvb, offset, actx, tree, hf_rnsap_id_Allowed_Rate_Information);
}
static int dissect_allowed_Rate_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Allowed_Rate_Information(tvb, offset, actx, tree, hf_rnsap_allowed_Rate_Information);
}


static const value_string rnsap_AntennaColocationIndicator_vals[] = {
  {   0, "co-located" },
  { 0, NULL }
};


static int
dissect_rnsap_AntennaColocationIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_id_AntennaColocationIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_AntennaColocationIndicator(tvb, offset, actx, tree, hf_rnsap_id_AntennaColocationIndicator);
}



static int
dissect_rnsap_BindingID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 4, NULL);

  return offset;
}
static int dissect_id_BindingID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_BindingID(tvb, offset, actx, tree, hf_rnsap_id_BindingID);
}
static int dissect_bindingID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_BindingID(tvb, offset, actx, tree, hf_rnsap_bindingID);
}



static int
dissect_rnsap_C_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 65535U, NULL, FALSE);

  return offset;
}
static int dissect_id_C_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_C_ID(tvb, offset, actx, tree, hf_rnsap_id_C_ID);
}
static int dissect_c_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_C_ID(tvb, offset, actx, tree, hf_rnsap_c_ID);
}
static int dissect_CorrespondingCells_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_C_ID(tvb, offset, actx, tree, hf_rnsap_CorrespondingCells_item);
}



static int
dissect_rnsap_C_RNTI(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 65535U, NULL, FALSE);

  return offset;
}
static int dissect_id_C_RNTI(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_C_RNTI(tvb, offset, actx, tree, hf_rnsap_id_C_RNTI);
}



static int
dissect_rnsap_INTEGER_1_100_(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              1U, 100U, NULL, TRUE);

  return offset;
}
static int dissect_uplinkCellCapacityClassValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_1_100_(tvb, offset, actx, tree, hf_rnsap_uplinkCellCapacityClassValue);
}
static int dissect_downlinkCellCapacityClassValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_1_100_(tvb, offset, actx, tree, hf_rnsap_downlinkCellCapacityClassValue);
}


static const per_sequence_t Cell_Capacity_Class_Value_sequence[] = {
  { &hf_rnsap_uplinkCellCapacityClassValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_1_100_ },
  { &hf_rnsap_downlinkCellCapacityClassValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_1_100_ },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Cell_Capacity_Class_Value(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Cell_Capacity_Class_Value, Cell_Capacity_Class_Value_sequence);

  return offset;
}
static int dissect_id_Cell_Capacity_Class_Value(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Cell_Capacity_Class_Value(tvb, offset, actx, tree, hf_rnsap_id_Cell_Capacity_Class_Value);
}



static int
dissect_rnsap_CFN(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 255U, NULL, FALSE);

  return offset;
}
static int dissect_id_CFN(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CFN(tvb, offset, actx, tree, hf_rnsap_id_CFN);
}
static int dissect_cFN(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CFN(tvb, offset, actx, tree, hf_rnsap_cFN);
}
static int dissect_cMConfigurationChangeCFN(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CFN(tvb, offset, actx, tree, hf_rnsap_cMConfigurationChangeCFN);
}
static int dissect_cfn(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CFN(tvb, offset, actx, tree, hf_rnsap_cfn);
}
static int dissect_synchronised(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CFN(tvb, offset, actx, tree, hf_rnsap_synchronised);
}
static int dissect_tGCFN(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CFN(tvb, offset, actx, tree, hf_rnsap_tGCFN);
}



static int
dissect_rnsap_PLMN_Identity(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       3, 3, NULL);

  return offset;
}
static int dissect_pLMN_Identity(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PLMN_Identity(tvb, offset, actx, tree, hf_rnsap_pLMN_Identity);
}
static int dissect_plmn_id(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PLMN_Identity(tvb, offset, actx, tree, hf_rnsap_plmn_id);
}



static int
dissect_rnsap_LAC(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       2, 2, NULL);

  return offset;
}
static int dissect_lAC(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_LAC(tvb, offset, actx, tree, hf_rnsap_lAC);
}


static const per_sequence_t CN_CS_DomainIdentifier_sequence[] = {
  { &hf_rnsap_pLMN_Identity , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_PLMN_Identity },
  { &hf_rnsap_lAC           , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_LAC },
  { &hf_rnsap_iE_Extensions , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CN_CS_DomainIdentifier(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CN_CS_DomainIdentifier, CN_CS_DomainIdentifier_sequence);

  return offset;
}
static int dissect_id_CN_CS_DomainIdentifier(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CN_CS_DomainIdentifier(tvb, offset, actx, tree, hf_rnsap_id_CN_CS_DomainIdentifier);
}
static int dissect_cN_CS_DomainIdentifier(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CN_CS_DomainIdentifier(tvb, offset, actx, tree, hf_rnsap_cN_CS_DomainIdentifier);
}



static int
dissect_rnsap_RAC(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 1, NULL);

  return offset;
}
static int dissect_rAC(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RAC(tvb, offset, actx, tree, hf_rnsap_rAC);
}


static const per_sequence_t CN_PS_DomainIdentifier_sequence[] = {
  { &hf_rnsap_pLMN_Identity , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_PLMN_Identity },
  { &hf_rnsap_lAC           , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_LAC },
  { &hf_rnsap_rAC           , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_RAC },
  { &hf_rnsap_iE_Extensions , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CN_PS_DomainIdentifier(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CN_PS_DomainIdentifier, CN_PS_DomainIdentifier_sequence);

  return offset;
}
static int dissect_id_CN_PS_DomainIdentifier(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CN_PS_DomainIdentifier(tvb, offset, actx, tree, hf_rnsap_id_CN_PS_DomainIdentifier);
}
static int dissect_cN_PS_DomainIdentifier(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CN_PS_DomainIdentifier(tvb, offset, actx, tree, hf_rnsap_cN_PS_DomainIdentifier);
}


static const value_string rnsap_CauseRadioNetwork_vals[] = {
  {   0, "unknown-C-ID" },
  {   1, "cell-not-available" },
  {   2, "power-level-not-supported" },
  {   3, "ul-scrambling-code-already-in-use" },
  {   4, "dl-radio-resources-not-available" },
  {   5, "ul-radio-resources-not-available" },
  {   6, "measurement-not-supported-for-the-object" },
  {   7, "combining-resources-not-available" },
  {   8, "combining-not-supported" },
  {   9, "reconfiguration-not-allowed" },
  {  10, "requested-configuration-not-supported" },
  {  11, "synchronisation-failure" },
  {  12, "requested-tx-diversity-mode-not-supported" },
  {  13, "measurement-temporaily-not-available" },
  {  14, "unspecified" },
  {  15, "invalid-CM-settings" },
  {  16, "reconfiguration-CFN-not-elapsed" },
  {  17, "number-of-DL-codes-not-supported" },
  {  18, "dedicated-transport-channel-type-not-supported" },
  {  19, "dl-shared-channel-type-not-supported" },
  {  20, "ul-shared-channel-type-not-supported" },
  {  21, "common-transport-channel-type-not-supported" },
  {  22, "ul-spreading-factor-not-supported" },
  {  23, "dl-spreading-factor-not-supported" },
  {  24, "cm-not-supported" },
  {  25, "transaction-not-supported-by-destination-node-b" },
  {  26, "rl-already-activated-or-alocated" },
  {  27, "number-of-UL-codes-not-supported" },
  {  28, "cell-reserved-for-operator-use" },
  {  29, "dpc-mode-change-not-supported" },
  {  30, "information-temporarily-not-available" },
  {  31, "information-provision-not-supported-for-the-object" },
  {  32, "power-balancing-status-not-compatible" },
  {  33, "delayed-activation-not-supported" },
  {  34, "rl-timing-adjustment-not-supported" },
  {  35, "unknown-RNTI" },
  {  36, "measurement-repetition-rate-not-compatible" },
  {  37, "ue-not-capable-of-support" },
  {  38, "f-dpch-not-supported" },
  { 0, NULL }
};


static int
dissect_rnsap_CauseRadioNetwork(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     27, NULL, TRUE, 12, NULL);

  return offset;
}
static int dissect_radioNetwork(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CauseRadioNetwork(tvb, offset, actx, tree, hf_rnsap_radioNetwork);
}


static const value_string rnsap_CauseTransport_vals[] = {
  {   0, "transport-resource-unavailable" },
  {   1, "unspecified" },
  { 0, NULL }
};


static int
dissect_rnsap_CauseTransport(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_transport(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CauseTransport(tvb, offset, actx, tree, hf_rnsap_transport);
}


static const value_string rnsap_CauseProtocol_vals[] = {
  {   0, "transfer-syntax-error" },
  {   1, "abstract-syntax-error-reject" },
  {   2, "abstract-syntax-error-ignore-and-notify" },
  {   3, "message-not-compatible-with-receiver-state" },
  {   4, "semantic-error" },
  {   5, "unspecified" },
  {   6, "abstract-syntax-error-falsely-constructed-message" },
  { 0, NULL }
};


static int
dissect_rnsap_CauseProtocol(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_protocol(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CauseProtocol(tvb, offset, actx, tree, hf_rnsap_protocol);
}


static const value_string rnsap_CauseMisc_vals[] = {
  {   0, "control-processing-overload" },
  {   1, "hardware-failure" },
  {   2, "om-intervention" },
  {   3, "not-enough-user-plane-processing-resources" },
  {   4, "unspecified" },
  { 0, NULL }
};


static int
dissect_rnsap_CauseMisc(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_misc(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CauseMisc(tvb, offset, actx, tree, hf_rnsap_misc);
}


static const value_string rnsap_Cause_vals[] = {
  {   0, "radioNetwork" },
  {   1, "transport" },
  {   2, "protocol" },
  {   3, "misc" },
  { 0, NULL }
};

static const per_choice_t Cause_choice[] = {
  {   0, &hf_rnsap_radioNetwork  , ASN1_EXTENSION_ROOT    , dissect_rnsap_CauseRadioNetwork },
  {   1, &hf_rnsap_transport     , ASN1_EXTENSION_ROOT    , dissect_rnsap_CauseTransport },
  {   2, &hf_rnsap_protocol      , ASN1_EXTENSION_ROOT    , dissect_rnsap_CauseProtocol },
  {   3, &hf_rnsap_misc          , ASN1_EXTENSION_ROOT    , dissect_rnsap_CauseMisc },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_Cause(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_Cause, Cause_choice,
                                 NULL);

  return offset;
}
static int dissect_id_Cause(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Cause(tvb, offset, actx, tree, hf_rnsap_id_Cause);
}
static int dissect_cause(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Cause(tvb, offset, actx, tree, hf_rnsap_cause);
}
static int dissect_individualcause(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Cause(tvb, offset, actx, tree, hf_rnsap_individualcause);
}


static const value_string rnsap_CoverageIndicator_vals[] = {
  {   0, "overlap" },
  {   1, "covers" },
  {   2, "containedIn" },
  { 0, NULL }
};


static int
dissect_rnsap_CoverageIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_id_CoverageIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CoverageIndicator(tvb, offset, actx, tree, hf_rnsap_id_CoverageIndicator);
}


static const value_string rnsap_TriggeringMessage_vals[] = {
  {   0, "initiating-message" },
  {   1, "successful-outcome" },
  {   2, "unsuccessful-outcome" },
  {   3, "outcome" },
  { 0, NULL }
};


static int
dissect_rnsap_TriggeringMessage(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_triggeringMessage(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TriggeringMessage(tvb, offset, actx, tree, hf_rnsap_triggeringMessage);
}



static int
dissect_rnsap_RepetitionNumber0(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 255U, NULL, FALSE);

  return offset;
}
static int dissect_repetitionNumber(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RepetitionNumber0(tvb, offset, actx, tree, hf_rnsap_repetitionNumber);
}


static const per_sequence_t CriticalityDiagnostics_IE_List_item_sequence[] = {
  { &hf_rnsap_iECriticality , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Criticality },
  { &hf_rnsap_iE_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_ID },
  { &hf_rnsap_repetitionNumber, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_RepetitionNumber0 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CriticalityDiagnostics_IE_List_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CriticalityDiagnostics_IE_List_item, CriticalityDiagnostics_IE_List_item_sequence);

  return offset;
}
static int dissect_CriticalityDiagnostics_IE_List_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CriticalityDiagnostics_IE_List_item(tvb, offset, actx, tree, hf_rnsap_CriticalityDiagnostics_IE_List_item);
}


static const per_sequence_t CriticalityDiagnostics_IE_List_sequence_of[1] = {
  { &hf_rnsap_CriticalityDiagnostics_IE_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_CriticalityDiagnostics_IE_List_item },
};

static int
dissect_rnsap_CriticalityDiagnostics_IE_List(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_CriticalityDiagnostics_IE_List, CriticalityDiagnostics_IE_List_sequence_of,
                                                  1, 256);

  return offset;
}
static int dissect_iEsCriticalityDiagnostics(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CriticalityDiagnostics_IE_List(tvb, offset, actx, tree, hf_rnsap_iEsCriticalityDiagnostics);
}


static const per_sequence_t CriticalityDiagnostics_sequence[] = {
  { &hf_rnsap_procedureID   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProcedureID },
  { &hf_rnsap_triggeringMessage, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TriggeringMessage },
  { &hf_rnsap_procedureCriticality, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Criticality },
  { &hf_rnsap_transactionID , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransactionID },
  { &hf_rnsap_iEsCriticalityDiagnostics, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CriticalityDiagnostics_IE_List },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CriticalityDiagnostics(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CriticalityDiagnostics, CriticalityDiagnostics_sequence);

  return offset;
}
static int dissect_id_CriticalityDiagnostics(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CriticalityDiagnostics(tvb, offset, actx, tree, hf_rnsap_id_CriticalityDiagnostics);
}



static int
dissect_rnsap_S_RNTI(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 1048575U, NULL, FALSE);

  return offset;
}
static int dissect_id_S_RNTI(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_S_RNTI(tvb, offset, actx, tree, hf_rnsap_id_S_RNTI);
}
static int dissect_sRNTI(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_S_RNTI(tvb, offset, actx, tree, hf_rnsap_sRNTI);
}
static int dissect_AffectedUEInformationForMBMS_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_S_RNTI(tvb, offset, actx, tree, hf_rnsap_AffectedUEInformationForMBMS_item);
}



static int
dissect_rnsap_D_RNTI(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 1048575U, NULL, FALSE);

  return offset;
}
static int dissect_id_D_RNTI(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_D_RNTI(tvb, offset, actx, tree, hf_rnsap_id_D_RNTI);
}
static int dissect_dRNTI(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_D_RNTI(tvb, offset, actx, tree, hf_rnsap_dRNTI);
}
static int dissect_d_RNTI(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_D_RNTI(tvb, offset, actx, tree, hf_rnsap_d_RNTI);
}


static const value_string rnsap_ContextType_Reset_vals[] = {
  {   0, "sRNTI" },
  {   1, "dRNTI" },
  { 0, NULL }
};

static const per_choice_t ContextType_Reset_choice[] = {
  {   0, &hf_rnsap_sRNTI         , ASN1_EXTENSION_ROOT    , dissect_rnsap_S_RNTI },
  {   1, &hf_rnsap_dRNTI         , ASN1_EXTENSION_ROOT    , dissect_rnsap_D_RNTI },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_ContextType_Reset(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_ContextType_Reset, ContextType_Reset_choice,
                                 NULL);

  return offset;
}
static int dissect_contextType_Reset(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ContextType_Reset(tvb, offset, actx, tree, hf_rnsap_contextType_Reset);
}


static const per_sequence_t ContextInfoItem_Reset_sequence[] = {
  { &hf_rnsap_contextType_Reset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ContextType_Reset },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_ContextInfoItem_Reset(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_ContextInfoItem_Reset, ContextInfoItem_Reset_sequence);

  return offset;
}
static int dissect_id_ContextInfoItem_Reset(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ContextInfoItem_Reset(tvb, offset, actx, tree, hf_rnsap_id_ContextInfoItem_Reset);
}


static const value_string rnsap_T_sRNTI_BitMaskIndex_vals[] = {
  {   0, "b1" },
  {   1, "b2" },
  {   2, "b3" },
  {   3, "b4" },
  {   4, "b5" },
  {   5, "b6" },
  {   6, "b7" },
  {   7, "b8" },
  {   8, "b9" },
  {   9, "b10" },
  {  10, "b11" },
  {  11, "b12" },
  {  12, "b13" },
  {  13, "b14" },
  {  14, "b15" },
  {  15, "b16" },
  {  16, "b17" },
  {  17, "b18" },
  {  18, "b19" },
  { 0, NULL }
};


static int
dissect_rnsap_T_sRNTI_BitMaskIndex(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     19, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_sRNTI_BitMaskIndex(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_T_sRNTI_BitMaskIndex(tvb, offset, actx, tree, hf_rnsap_sRNTI_BitMaskIndex);
}


static const per_sequence_t S_RNTI_Group_sequence[] = {
  { &hf_rnsap_sRNTI         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_S_RNTI },
  { &hf_rnsap_sRNTI_BitMaskIndex, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_T_sRNTI_BitMaskIndex },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_S_RNTI_Group(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_S_RNTI_Group, S_RNTI_Group_sequence);

  return offset;
}
static int dissect_s_RNTI_Group(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_S_RNTI_Group(tvb, offset, actx, tree, hf_rnsap_s_RNTI_Group);
}


static const per_sequence_t ContextGroupInfoItem_Reset_sequence[] = {
  { &hf_rnsap_s_RNTI_Group  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_S_RNTI_Group },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_ContextGroupInfoItem_Reset(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_ContextGroupInfoItem_Reset, ContextGroupInfoItem_Reset_sequence);

  return offset;
}
static int dissect_id_ContextGroupInfoItem_Reset(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ContextGroupInfoItem_Reset(tvb, offset, actx, tree, hf_rnsap_id_ContextGroupInfoItem_Reset);
}


static const value_string rnsap_D_RNTI_ReleaseIndication_vals[] = {
  {   0, "release-D-RNTI" },
  {   1, "not-release-D-RNTI" },
  { 0, NULL }
};


static int
dissect_rnsap_D_RNTI_ReleaseIndication(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_id_D_RNTI_ReleaseIndication(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_D_RNTI_ReleaseIndication(tvb, offset, actx, tree, hf_rnsap_id_D_RNTI_ReleaseIndication);
}


static const value_string rnsap_PayloadCRC_PresenceIndicator_vals[] = {
  {   0, "crc-included" },
  {   1, "crc-not-included" },
  { 0, NULL }
};


static int
dissect_rnsap_PayloadCRC_PresenceIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_payloadCRC_PresenceIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PayloadCRC_PresenceIndicator(tvb, offset, actx, tree, hf_rnsap_payloadCRC_PresenceIndicator);
}


static const value_string rnsap_UL_FP_Mode_vals[] = {
  {   0, "normal" },
  {   1, "silent" },
  { 0, NULL }
};


static int
dissect_rnsap_UL_FP_Mode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_ul_FP_Mode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_FP_Mode(tvb, offset, actx, tree, hf_rnsap_ul_FP_Mode);
}



static int
dissect_rnsap_ToAWS(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 1279U, NULL, FALSE);

  return offset;
}
static int dissect_toAWS(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ToAWS(tvb, offset, actx, tree, hf_rnsap_toAWS);
}



static int
dissect_rnsap_ToAWE(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 2559U, NULL, FALSE);

  return offset;
}
static int dissect_toAWE(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ToAWE(tvb, offset, actx, tree, hf_rnsap_toAWE);
}



static int
dissect_rnsap_DCH_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 255U, NULL, FALSE);

  return offset;
}
static int dissect_dCH_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_ID(tvb, offset, actx, tree, hf_rnsap_dCH_ID);
}
static int dissect_dCH_id(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_ID(tvb, offset, actx, tree, hf_rnsap_dCH_id);
}


static const value_string rnsap_TrCH_SrcStatisticsDescr_vals[] = {
  {   0, "speech" },
  {   1, "rRC" },
  {   2, "unknown" },
  { 0, NULL }
};


static int
dissect_rnsap_TrCH_SrcStatisticsDescr(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_trChSourceStatisticsDescriptor(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TrCH_SrcStatisticsDescr(tvb, offset, actx, tree, hf_rnsap_trChSourceStatisticsDescriptor);
}
static int dissect_trCH_SrcStatisticsDescr(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TrCH_SrcStatisticsDescr(tvb, offset, actx, tree, hf_rnsap_trCH_SrcStatisticsDescr);
}



static int
dissect_rnsap_NrOfTransportBlocks(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 512U, NULL, FALSE);

  return offset;
}
static int dissect_nrOfTransportBlocks(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NrOfTransportBlocks(tvb, offset, actx, tree, hf_rnsap_nrOfTransportBlocks);
}



static int
dissect_rnsap_TransportBlockSize(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 5000U, NULL, FALSE);

  return offset;
}
static int dissect_transportBlockSize(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TransportBlockSize(tvb, offset, actx, tree, hf_rnsap_transportBlockSize);
}


static const value_string rnsap_TransmissionTimeIntervalDynamic_vals[] = {
  {   0, "msec-10" },
  {   1, "msec-20" },
  {   2, "msec-40" },
  {   3, "msec-80" },
  { 0, NULL }
};


static int
dissect_rnsap_TransmissionTimeIntervalDynamic(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_transmissionTimeInterval(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TransmissionTimeIntervalDynamic(tvb, offset, actx, tree, hf_rnsap_transmissionTimeInterval);
}


static const per_sequence_t TransmissionTimeIntervalInformation_item_sequence[] = {
  { &hf_rnsap_transmissionTimeInterval, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransmissionTimeIntervalDynamic },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TransmissionTimeIntervalInformation_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TransmissionTimeIntervalInformation_item, TransmissionTimeIntervalInformation_item_sequence);

  return offset;
}
static int dissect_TransmissionTimeIntervalInformation_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TransmissionTimeIntervalInformation_item(tvb, offset, actx, tree, hf_rnsap_TransmissionTimeIntervalInformation_item);
}


static const per_sequence_t TransmissionTimeIntervalInformation_sequence_of[1] = {
  { &hf_rnsap_TransmissionTimeIntervalInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_TransmissionTimeIntervalInformation_item },
};

static int
dissect_rnsap_TransmissionTimeIntervalInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_TransmissionTimeIntervalInformation, TransmissionTimeIntervalInformation_sequence_of,
                                                  1, 4);

  return offset;
}
static int dissect_transmissionTimeIntervalInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TransmissionTimeIntervalInformation(tvb, offset, actx, tree, hf_rnsap_transmissionTimeIntervalInformation);
}


static const per_sequence_t TDD_TransportFormatSet_ModeDP_sequence[] = {
  { &hf_rnsap_transmissionTimeIntervalInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransmissionTimeIntervalInformation },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TDD_TransportFormatSet_ModeDP(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TDD_TransportFormatSet_ModeDP, TDD_TransportFormatSet_ModeDP_sequence);

  return offset;
}
static int dissect_tdd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TDD_TransportFormatSet_ModeDP(tvb, offset, actx, tree, hf_rnsap_tdd);
}



static int
dissect_rnsap_NULL(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_not_Used_sSDT_CellIdLength(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NULL(tvb, offset, actx, tree, hf_rnsap_not_Used_sSDT_CellIdLength);
}
static int dissect_not_Used_s_FieldLength(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NULL(tvb, offset, actx, tree, hf_rnsap_not_Used_s_FieldLength);
}
static int dissect_not_Used_sSDT_CellID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NULL(tvb, offset, actx, tree, hf_rnsap_not_Used_sSDT_CellID);
}
static int dissect_not_Used_secondary_CCPCH_Info(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NULL(tvb, offset, actx, tree, hf_rnsap_not_Used_secondary_CCPCH_Info);
}
static int dissect_not_Used_dSCHInformationResponse(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NULL(tvb, offset, actx, tree, hf_rnsap_not_Used_dSCHInformationResponse);
}
static int dissect_not_Used_dSCH_InformationResponse_RL_SetupFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NULL(tvb, offset, actx, tree, hf_rnsap_not_Used_dSCH_InformationResponse_RL_SetupFailureFDD);
}
static int dissect_not_Used_sSDT_CellIDLength(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NULL(tvb, offset, actx, tree, hf_rnsap_not_Used_sSDT_CellIDLength);
}
static int dissect_not_Used_sSDT_Indication(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NULL(tvb, offset, actx, tree, hf_rnsap_not_Used_sSDT_Indication);
}
static int dissect_not_Used_sSDT_CellIdentity(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NULL(tvb, offset, actx, tree, hf_rnsap_not_Used_sSDT_CellIdentity);
}
static int dissect_not_Used_dSCHsToBeAddedOrModified(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NULL(tvb, offset, actx, tree, hf_rnsap_not_Used_dSCHsToBeAddedOrModified);
}
static int dissect_all_contexts(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NULL(tvb, offset, actx, tree, hf_rnsap_all_contexts);
}
static int dissect_measurementnotAvailable(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NULL(tvb, offset, actx, tree, hf_rnsap_measurementnotAvailable);
}
static int dissect_separate_indication(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NULL(tvb, offset, actx, tree, hf_rnsap_separate_indication);
}
static int dissect_unsynchronised(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NULL(tvb, offset, actx, tree, hf_rnsap_unsynchronised);
}
static int dissect_e_DCH_Scheduled_Transmission_Grant(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NULL(tvb, offset, actx, tree, hf_rnsap_e_DCH_Scheduled_Transmission_Grant);
}
static int dissect_e_DCH_Serving_RL_not_in_this_DRNS(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NULL(tvb, offset, actx, tree, hf_rnsap_e_DCH_Serving_RL_not_in_this_DRNS);
}
static int dissect_not_Used_dRACControl(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NULL(tvb, offset, actx, tree, hf_rnsap_not_Used_dRACControl);
}
static int dissect_noBadSatellite(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NULL(tvb, offset, actx, tree, hf_rnsap_noBadSatellite);
}
static int dissect_onDemand(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NULL(tvb, offset, actx, tree, hf_rnsap_onDemand);
}
static int dissect_defaultMidamble(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NULL(tvb, offset, actx, tree, hf_rnsap_defaultMidamble);
}
static int dissect_commonMidamble(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NULL(tvb, offset, actx, tree, hf_rnsap_commonMidamble);
}
static int dissect_not_used_closedLoopMode2_SupportIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NULL(tvb, offset, actx, tree, hf_rnsap_not_used_closedLoopMode2_SupportIndicator);
}
static int dissect_secondary_CPICH_shall_not_be_used(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NULL(tvb, offset, actx, tree, hf_rnsap_secondary_CPICH_shall_not_be_used);
}
static int dissect_not_Used_split_in_TFCI(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NULL(tvb, offset, actx, tree, hf_rnsap_not_Used_split_in_TFCI);
}
static int dissect_notApplicable(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NULL(tvb, offset, actx, tree, hf_rnsap_notApplicable);
}


static const value_string rnsap_TransportFormatSet_ModeDP_vals[] = {
  {   0, "tdd" },
  {   1, "notApplicable" },
  { 0, NULL }
};

static const per_choice_t TransportFormatSet_ModeDP_choice[] = {
  {   0, &hf_rnsap_tdd           , ASN1_EXTENSION_ROOT    , dissect_rnsap_TDD_TransportFormatSet_ModeDP },
  {   1, &hf_rnsap_notApplicable , ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_TransportFormatSet_ModeDP(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_TransportFormatSet_ModeDP, TransportFormatSet_ModeDP_choice,
                                 NULL);

  return offset;
}
static int dissect_mode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TransportFormatSet_ModeDP(tvb, offset, actx, tree, hf_rnsap_mode);
}


static const per_sequence_t TransportFormatSet_DynamicPartList_item_sequence[] = {
  { &hf_rnsap_nrOfTransportBlocks, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_NrOfTransportBlocks },
  { &hf_rnsap_transportBlockSize, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportBlockSize },
  { &hf_rnsap_mode          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatSet_ModeDP },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TransportFormatSet_DynamicPartList_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TransportFormatSet_DynamicPartList_item, TransportFormatSet_DynamicPartList_item_sequence);

  return offset;
}
static int dissect_TransportFormatSet_DynamicPartList_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TransportFormatSet_DynamicPartList_item(tvb, offset, actx, tree, hf_rnsap_TransportFormatSet_DynamicPartList_item);
}


static const per_sequence_t TransportFormatSet_DynamicPartList_sequence_of[1] = {
  { &hf_rnsap_TransportFormatSet_DynamicPartList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatSet_DynamicPartList_item },
};

static int
dissect_rnsap_TransportFormatSet_DynamicPartList(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_TransportFormatSet_DynamicPartList, TransportFormatSet_DynamicPartList_sequence_of,
                                                  1, 32);

  return offset;
}
static int dissect_dynamicParts(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TransportFormatSet_DynamicPartList(tvb, offset, actx, tree, hf_rnsap_dynamicParts);
}


static const value_string rnsap_TransmissionTimeIntervalSemiStatic_vals[] = {
  {   0, "msec-10" },
  {   1, "msec-20" },
  {   2, "msec-40" },
  {   3, "msec-80" },
  {   4, "dynamic" },
  { 0, NULL }
};


static int
dissect_rnsap_TransmissionTimeIntervalSemiStatic(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_transmissionTime(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TransmissionTimeIntervalSemiStatic(tvb, offset, actx, tree, hf_rnsap_transmissionTime);
}


static const value_string rnsap_ChannelCodingType_vals[] = {
  {   0, "no-codingTDD" },
  {   1, "convolutional-coding" },
  {   2, "turbo-coding" },
  { 0, NULL }
};


static int
dissect_rnsap_ChannelCodingType(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_channelCoding(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ChannelCodingType(tvb, offset, actx, tree, hf_rnsap_channelCoding);
}


static const value_string rnsap_CodingRate_vals[] = {
  {   0, "half" },
  {   1, "third" },
  { 0, NULL }
};


static int
dissect_rnsap_CodingRate(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_codingRate(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CodingRate(tvb, offset, actx, tree, hf_rnsap_codingRate);
}



static int
dissect_rnsap_RateMatchingAttribute(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              1U, 256U, NULL, FALSE);

  return offset;
}
static int dissect_rateMatcingAttribute(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RateMatchingAttribute(tvb, offset, actx, tree, hf_rnsap_rateMatcingAttribute);
}


static const value_string rnsap_CRC_Size_vals[] = {
  {   0, "v0" },
  {   1, "v8" },
  {   2, "v12" },
  {   3, "v16" },
  {   4, "v24" },
  { 0, NULL }
};


static int
dissect_rnsap_CRC_Size(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_cRC_Size(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CRC_Size(tvb, offset, actx, tree, hf_rnsap_cRC_Size);
}


static const value_string rnsap_SecondInterleavingMode_vals[] = {
  {   0, "frame-related" },
  {   1, "timeslot-related" },
  { 0, NULL }
};


static int
dissect_rnsap_SecondInterleavingMode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_tdd1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_SecondInterleavingMode(tvb, offset, actx, tree, hf_rnsap_tdd1);
}


static const value_string rnsap_TransportFormatSet_ModeSSP_vals[] = {
  {   0, "tdd" },
  {   1, "notApplicable" },
  { 0, NULL }
};

static const per_choice_t TransportFormatSet_ModeSSP_choice[] = {
  {   0, &hf_rnsap_tdd1          , ASN1_EXTENSION_ROOT    , dissect_rnsap_SecondInterleavingMode },
  {   1, &hf_rnsap_notApplicable , ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_TransportFormatSet_ModeSSP(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_TransportFormatSet_ModeSSP, TransportFormatSet_ModeSSP_choice,
                                 NULL);

  return offset;
}
static int dissect_mode1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TransportFormatSet_ModeSSP(tvb, offset, actx, tree, hf_rnsap_mode1);
}


static const per_sequence_t TransportFormatSet_Semi_staticPart_sequence[] = {
  { &hf_rnsap_transmissionTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransmissionTimeIntervalSemiStatic },
  { &hf_rnsap_channelCoding , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ChannelCodingType },
  { &hf_rnsap_codingRate    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CodingRate },
  { &hf_rnsap_rateMatcingAttribute, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RateMatchingAttribute },
  { &hf_rnsap_cRC_Size      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CRC_Size },
  { &hf_rnsap_mode1         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatSet_ModeSSP },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TransportFormatSet_Semi_staticPart(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TransportFormatSet_Semi_staticPart, TransportFormatSet_Semi_staticPart_sequence);

  return offset;
}
static int dissect_semi_staticPart(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TransportFormatSet_Semi_staticPart(tvb, offset, actx, tree, hf_rnsap_semi_staticPart);
}


static const per_sequence_t TransportFormatSet_sequence[] = {
  { &hf_rnsap_dynamicParts  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatSet_DynamicPartList },
  { &hf_rnsap_semi_staticPart, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatSet_Semi_staticPart },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TransportFormatSet(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TransportFormatSet, TransportFormatSet_sequence);

  return offset;
}
static int dissect_transportFormatSet(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TransportFormatSet(tvb, offset, actx, tree, hf_rnsap_transportFormatSet);
}
static int dissect_ul_transportFormatSet(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TransportFormatSet(tvb, offset, actx, tree, hf_rnsap_ul_transportFormatSet);
}
static int dissect_dl_transportFormatSet(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TransportFormatSet(tvb, offset, actx, tree, hf_rnsap_dl_transportFormatSet);
}
static int dissect_ul_TransportformatSet(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TransportFormatSet(tvb, offset, actx, tree, hf_rnsap_ul_TransportformatSet);
}
static int dissect_dl_TransportformatSet(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TransportFormatSet(tvb, offset, actx, tree, hf_rnsap_dl_TransportformatSet);
}



static int
dissect_rnsap_BLER(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              -63, 0U, NULL, FALSE);

  return offset;
}
static int dissect_bLER(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_BLER(tvb, offset, actx, tree, hf_rnsap_bLER);
}
static int dissect_ul_BLER(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_BLER(tvb, offset, actx, tree, hf_rnsap_ul_BLER);
}
static int dissect_dl_BLER(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_BLER(tvb, offset, actx, tree, hf_rnsap_dl_BLER);
}



static int
dissect_rnsap_PriorityLevel(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 15U, NULL, FALSE);

  return offset;
}
static int dissect_priorityLevel(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PriorityLevel(tvb, offset, actx, tree, hf_rnsap_priorityLevel);
}


static const value_string rnsap_Pre_emptionCapability_vals[] = {
  {   0, "shall-not-trigger-pre-emption" },
  {   1, "may-trigger-pre-emption" },
  { 0, NULL }
};


static int
dissect_rnsap_Pre_emptionCapability(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_pre_emptionCapability(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Pre_emptionCapability(tvb, offset, actx, tree, hf_rnsap_pre_emptionCapability);
}


static const value_string rnsap_Pre_emptionVulnerability_vals[] = {
  {   0, "not-pre-emptable" },
  {   1, "pre-emptable" },
  { 0, NULL }
};


static int
dissect_rnsap_Pre_emptionVulnerability(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_pre_emptionVulnerability(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Pre_emptionVulnerability(tvb, offset, actx, tree, hf_rnsap_pre_emptionVulnerability);
}


static const per_sequence_t AllocationRetentionPriority_sequence[] = {
  { &hf_rnsap_priorityLevel , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PriorityLevel },
  { &hf_rnsap_pre_emptionCapability, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Pre_emptionCapability },
  { &hf_rnsap_pre_emptionVulnerability, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Pre_emptionVulnerability },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_AllocationRetentionPriority(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_AllocationRetentionPriority, AllocationRetentionPriority_sequence);

  return offset;
}
static int dissect_allocationRetentionPriority(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_AllocationRetentionPriority(tvb, offset, actx, tree, hf_rnsap_allocationRetentionPriority);
}


static const value_string rnsap_FrameHandlingPriority_vals[] = {
  {   0, "lowest" },
  {  15, "highest" },
  { 0, NULL }
};


static int
dissect_rnsap_FrameHandlingPriority(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 15U, NULL, FALSE);

  return offset;
}
static int dissect_frameHandlingPriority(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_FrameHandlingPriority(tvb, offset, actx, tree, hf_rnsap_frameHandlingPriority);
}


static const value_string rnsap_QE_Selector_vals[] = {
  {   0, "selected" },
  {   1, "non-selected" },
  { 0, NULL }
};


static int
dissect_rnsap_QE_Selector(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_qE_Selector(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_QE_Selector(tvb, offset, actx, tree, hf_rnsap_qE_Selector);
}


static const value_string rnsap_DRACControl_vals[] = {
  {   0, "not-Used-requested" },
  {   1, "not-requested" },
  { 0, NULL }
};


static int
dissect_rnsap_DRACControl(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_dRACControl(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DRACControl(tvb, offset, actx, tree, hf_rnsap_dRACControl);
}


static const per_sequence_t DCH_Specific_FDD_Item_sequence[] = {
  { &hf_rnsap_dCH_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_ID },
  { &hf_rnsap_trCH_SrcStatisticsDescr, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TrCH_SrcStatisticsDescr },
  { &hf_rnsap_ul_transportFormatSet, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatSet },
  { &hf_rnsap_dl_transportFormatSet, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatSet },
  { &hf_rnsap_ul_BLER       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BLER },
  { &hf_rnsap_dl_BLER       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BLER },
  { &hf_rnsap_allocationRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_AllocationRetentionPriority },
  { &hf_rnsap_frameHandlingPriority, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_FrameHandlingPriority },
  { &hf_rnsap_qE_Selector   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_QE_Selector },
  { &hf_rnsap_dRACControl   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DRACControl },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DCH_Specific_FDD_Item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DCH_Specific_FDD_Item, DCH_Specific_FDD_Item_sequence);

  return offset;
}
static int dissect_DCH_Specific_FDD_InformationList_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_Specific_FDD_Item(tvb, offset, actx, tree, hf_rnsap_DCH_Specific_FDD_InformationList_item);
}


static const per_sequence_t DCH_Specific_FDD_InformationList_sequence_of[1] = {
  { &hf_rnsap_DCH_Specific_FDD_InformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_Specific_FDD_Item },
};

static int
dissect_rnsap_DCH_Specific_FDD_InformationList(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DCH_Specific_FDD_InformationList, DCH_Specific_FDD_InformationList_sequence_of,
                                                  1, 128);

  return offset;
}
static int dissect_dCH_SpecificInformationList(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_Specific_FDD_InformationList(tvb, offset, actx, tree, hf_rnsap_dCH_SpecificInformationList);
}


static const per_sequence_t DCH_FDD_InformationItem_sequence[] = {
  { &hf_rnsap_payloadCRC_PresenceIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PayloadCRC_PresenceIndicator },
  { &hf_rnsap_ul_FP_Mode    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_FP_Mode },
  { &hf_rnsap_toAWS         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ToAWS },
  { &hf_rnsap_toAWE         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ToAWE },
  { &hf_rnsap_dCH_SpecificInformationList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_Specific_FDD_InformationList },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DCH_FDD_InformationItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DCH_FDD_InformationItem, DCH_FDD_InformationItem_sequence);

  return offset;
}
static int dissect_DCH_FDD_Information_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_FDD_InformationItem(tvb, offset, actx, tree, hf_rnsap_DCH_FDD_Information_item);
}


static const per_sequence_t DCH_FDD_Information_sequence_of[1] = {
  { &hf_rnsap_DCH_FDD_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_FDD_InformationItem },
};

static int
dissect_rnsap_DCH_FDD_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DCH_FDD_Information, DCH_FDD_Information_sequence_of,
                                                  1, 128);

  return offset;
}
static int dissect_id_DCHs_to_Add_FDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_FDD_Information(tvb, offset, actx, tree, hf_rnsap_id_DCHs_to_Add_FDD);
}
static int dissect_id_DCH_FDD_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_FDD_Information(tvb, offset, actx, tree, hf_rnsap_id_DCH_FDD_Information);
}



static int
dissect_rnsap_CCTrCH_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 15U, NULL, FALSE);

  return offset;
}
static int dissect_cCTrCH_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CCTrCH_ID(tvb, offset, actx, tree, hf_rnsap_cCTrCH_ID);
}
static int dissect_dl_ccTrCHID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CCTrCH_ID(tvb, offset, actx, tree, hf_rnsap_dl_ccTrCHID);
}
static int dissect_ul_ccTrCHID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CCTrCH_ID(tvb, offset, actx, tree, hf_rnsap_ul_ccTrCHID);
}
static int dissect_ul_cCTrCH_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CCTrCH_ID(tvb, offset, actx, tree, hf_rnsap_ul_cCTrCH_ID);
}
static int dissect_dl_cCTrCH_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CCTrCH_ID(tvb, offset, actx, tree, hf_rnsap_dl_cCTrCH_ID);
}
static int dissect_ul_CCTrCH_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CCTrCH_ID(tvb, offset, actx, tree, hf_rnsap_ul_CCTrCH_ID);
}
static int dissect_dl_CCTrCH_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CCTrCH_ID(tvb, offset, actx, tree, hf_rnsap_dl_CCTrCH_ID);
}


static const per_sequence_t DCH_Specific_TDD_Item_sequence[] = {
  { &hf_rnsap_dCH_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_ID },
  { &hf_rnsap_ul_cCTrCH_ID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_dl_cCTrCH_ID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_trCH_SrcStatisticsDescr, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TrCH_SrcStatisticsDescr },
  { &hf_rnsap_ul_transportFormatSet, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatSet },
  { &hf_rnsap_dl_transportFormatSet, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatSet },
  { &hf_rnsap_ul_BLER       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BLER },
  { &hf_rnsap_dl_BLER       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BLER },
  { &hf_rnsap_allocationRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_AllocationRetentionPriority },
  { &hf_rnsap_frameHandlingPriority, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_FrameHandlingPriority },
  { &hf_rnsap_qE_Selector   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_QE_Selector },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DCH_Specific_TDD_Item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DCH_Specific_TDD_Item, DCH_Specific_TDD_Item_sequence);

  return offset;
}
static int dissect_DCH_Specific_TDD_InformationList_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_Specific_TDD_Item(tvb, offset, actx, tree, hf_rnsap_DCH_Specific_TDD_InformationList_item);
}


static const per_sequence_t DCH_Specific_TDD_InformationList_sequence_of[1] = {
  { &hf_rnsap_DCH_Specific_TDD_InformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_Specific_TDD_Item },
};

static int
dissect_rnsap_DCH_Specific_TDD_InformationList(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DCH_Specific_TDD_InformationList, DCH_Specific_TDD_InformationList_sequence_of,
                                                  1, 128);

  return offset;
}
static int dissect_dCH_SpecificInformationList1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_Specific_TDD_InformationList(tvb, offset, actx, tree, hf_rnsap_dCH_SpecificInformationList1);
}


static const per_sequence_t DCH_TDD_InformationItem_sequence[] = {
  { &hf_rnsap_payloadCRC_PresenceIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PayloadCRC_PresenceIndicator },
  { &hf_rnsap_ul_FP_Mode    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_FP_Mode },
  { &hf_rnsap_toAWS         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ToAWS },
  { &hf_rnsap_toAWE         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ToAWE },
  { &hf_rnsap_dCH_SpecificInformationList1, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_Specific_TDD_InformationList },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DCH_TDD_InformationItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DCH_TDD_InformationItem, DCH_TDD_InformationItem_sequence);

  return offset;
}
static int dissect_DCH_TDD_Information_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_TDD_InformationItem(tvb, offset, actx, tree, hf_rnsap_DCH_TDD_Information_item);
}


static const per_sequence_t DCH_TDD_Information_sequence_of[1] = {
  { &hf_rnsap_DCH_TDD_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_TDD_InformationItem },
};

static int
dissect_rnsap_DCH_TDD_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DCH_TDD_Information, DCH_TDD_Information_sequence_of,
                                                  1, 128);

  return offset;
}
static int dissect_id_DCHs_to_Add_TDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_TDD_Information(tvb, offset, actx, tree, hf_rnsap_id_DCHs_to_Add_TDD);
}
static int dissect_id_DCH_TDD_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_TDD_Information(tvb, offset, actx, tree, hf_rnsap_id_DCH_TDD_Information);
}


static const per_sequence_t DCH_DeleteItem_RL_ReconfPrepFDD_sequence[] = {
  { &hf_rnsap_dCH_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DCH_DeleteItem_RL_ReconfPrepFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DCH_DeleteItem_RL_ReconfPrepFDD, DCH_DeleteItem_RL_ReconfPrepFDD_sequence);

  return offset;
}
static int dissect_DCH_DeleteList_RL_ReconfPrepFDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_DeleteItem_RL_ReconfPrepFDD(tvb, offset, actx, tree, hf_rnsap_DCH_DeleteList_RL_ReconfPrepFDD_item);
}


static const per_sequence_t DCH_DeleteList_RL_ReconfPrepFDD_sequence_of[1] = {
  { &hf_rnsap_DCH_DeleteList_RL_ReconfPrepFDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_DeleteItem_RL_ReconfPrepFDD },
};

static int
dissect_rnsap_DCH_DeleteList_RL_ReconfPrepFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DCH_DeleteList_RL_ReconfPrepFDD, DCH_DeleteList_RL_ReconfPrepFDD_sequence_of,
                                                  0, 128);

  return offset;
}
static int dissect_id_DCH_DeleteList_RL_ReconfPrepFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_DeleteList_RL_ReconfPrepFDD(tvb, offset, actx, tree, hf_rnsap_id_DCH_DeleteList_RL_ReconfPrepFDD);
}


static const per_sequence_t DCH_DeleteItem_RL_ReconfPrepTDD_sequence[] = {
  { &hf_rnsap_dCH_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DCH_DeleteItem_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DCH_DeleteItem_RL_ReconfPrepTDD, DCH_DeleteItem_RL_ReconfPrepTDD_sequence);

  return offset;
}
static int dissect_DCH_DeleteList_RL_ReconfPrepTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_DeleteItem_RL_ReconfPrepTDD(tvb, offset, actx, tree, hf_rnsap_DCH_DeleteList_RL_ReconfPrepTDD_item);
}


static const per_sequence_t DCH_DeleteList_RL_ReconfPrepTDD_sequence_of[1] = {
  { &hf_rnsap_DCH_DeleteList_RL_ReconfPrepTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_DeleteItem_RL_ReconfPrepTDD },
};

static int
dissect_rnsap_DCH_DeleteList_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DCH_DeleteList_RL_ReconfPrepTDD, DCH_DeleteList_RL_ReconfPrepTDD_sequence_of,
                                                  0, 128);

  return offset;
}
static int dissect_id_DCH_DeleteList_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_DeleteList_RL_ReconfPrepTDD(tvb, offset, actx, tree, hf_rnsap_id_DCH_DeleteList_RL_ReconfPrepTDD);
}


static const per_sequence_t DCH_DeleteItem_RL_ReconfRqstFDD_sequence[] = {
  { &hf_rnsap_dCH_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DCH_DeleteItem_RL_ReconfRqstFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DCH_DeleteItem_RL_ReconfRqstFDD, DCH_DeleteItem_RL_ReconfRqstFDD_sequence);

  return offset;
}
static int dissect_DCH_DeleteList_RL_ReconfRqstFDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_DeleteItem_RL_ReconfRqstFDD(tvb, offset, actx, tree, hf_rnsap_DCH_DeleteList_RL_ReconfRqstFDD_item);
}


static const per_sequence_t DCH_DeleteList_RL_ReconfRqstFDD_sequence_of[1] = {
  { &hf_rnsap_DCH_DeleteList_RL_ReconfRqstFDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_DeleteItem_RL_ReconfRqstFDD },
};

static int
dissect_rnsap_DCH_DeleteList_RL_ReconfRqstFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DCH_DeleteList_RL_ReconfRqstFDD, DCH_DeleteList_RL_ReconfRqstFDD_sequence_of,
                                                  0, 128);

  return offset;
}
static int dissect_id_DCH_DeleteList_RL_ReconfRqstFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_DeleteList_RL_ReconfRqstFDD(tvb, offset, actx, tree, hf_rnsap_id_DCH_DeleteList_RL_ReconfRqstFDD);
}


static const per_sequence_t DCH_DeleteItem_RL_ReconfRqstTDD_sequence[] = {
  { &hf_rnsap_dCH_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DCH_DeleteItem_RL_ReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DCH_DeleteItem_RL_ReconfRqstTDD, DCH_DeleteItem_RL_ReconfRqstTDD_sequence);

  return offset;
}
static int dissect_DCH_DeleteList_RL_ReconfRqstTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_DeleteItem_RL_ReconfRqstTDD(tvb, offset, actx, tree, hf_rnsap_DCH_DeleteList_RL_ReconfRqstTDD_item);
}


static const per_sequence_t DCH_DeleteList_RL_ReconfRqstTDD_sequence_of[1] = {
  { &hf_rnsap_DCH_DeleteList_RL_ReconfRqstTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_DeleteItem_RL_ReconfRqstTDD },
};

static int
dissect_rnsap_DCH_DeleteList_RL_ReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DCH_DeleteList_RL_ReconfRqstTDD, DCH_DeleteList_RL_ReconfRqstTDD_sequence_of,
                                                  0, 128);

  return offset;
}
static int dissect_id_DCH_DeleteList_RL_ReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_DeleteList_RL_ReconfRqstTDD(tvb, offset, actx, tree, hf_rnsap_id_DCH_DeleteList_RL_ReconfRqstTDD);
}


static const value_string rnsap_TransportBearerRequestIndicator_vals[] = {
  {   0, "bearer-requested" },
  {   1, "bearer-not-requested" },
  { 0, NULL }
};


static int
dissect_rnsap_TransportBearerRequestIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_id_TransportBearerRequestIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TransportBearerRequestIndicator(tvb, offset, actx, tree, hf_rnsap_id_TransportBearerRequestIndicator);
}
static int dissect_transportBearerRequestIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TransportBearerRequestIndicator(tvb, offset, actx, tree, hf_rnsap_transportBearerRequestIndicator);
}


static const per_sequence_t FDD_DCHs_to_ModifySpecificItem_sequence[] = {
  { &hf_rnsap_dCH_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_ID },
  { &hf_rnsap_ul_TransportformatSet, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportFormatSet },
  { &hf_rnsap_dl_TransportformatSet, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportFormatSet },
  { &hf_rnsap_allocationRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_AllocationRetentionPriority },
  { &hf_rnsap_frameHandlingPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_FrameHandlingPriority },
  { &hf_rnsap_not_Used_dRACControl, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_NULL },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_FDD_DCHs_to_ModifySpecificItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_FDD_DCHs_to_ModifySpecificItem, FDD_DCHs_to_ModifySpecificItem_sequence);

  return offset;
}
static int dissect_FDD_DCHs_to_ModifySpecificInformationList_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_FDD_DCHs_to_ModifySpecificItem(tvb, offset, actx, tree, hf_rnsap_FDD_DCHs_to_ModifySpecificInformationList_item);
}


static const per_sequence_t FDD_DCHs_to_ModifySpecificInformationList_sequence_of[1] = {
  { &hf_rnsap_FDD_DCHs_to_ModifySpecificInformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_FDD_DCHs_to_ModifySpecificItem },
};

static int
dissect_rnsap_FDD_DCHs_to_ModifySpecificInformationList(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_FDD_DCHs_to_ModifySpecificInformationList, FDD_DCHs_to_ModifySpecificInformationList_sequence_of,
                                                  1, 128);

  return offset;
}
static int dissect_dCH_SpecificInformationList2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_FDD_DCHs_to_ModifySpecificInformationList(tvb, offset, actx, tree, hf_rnsap_dCH_SpecificInformationList2);
}


static const per_sequence_t FDD_DCHs_to_ModifyItem_sequence[] = {
  { &hf_rnsap_ul_FP_Mode    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UL_FP_Mode },
  { &hf_rnsap_toAWS         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ToAWS },
  { &hf_rnsap_toAWE         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ToAWE },
  { &hf_rnsap_transportBearerRequestIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportBearerRequestIndicator },
  { &hf_rnsap_dCH_SpecificInformationList2, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_FDD_DCHs_to_ModifySpecificInformationList },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_FDD_DCHs_to_ModifyItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_FDD_DCHs_to_ModifyItem, FDD_DCHs_to_ModifyItem_sequence);

  return offset;
}
static int dissect_FDD_DCHs_to_Modify_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_FDD_DCHs_to_ModifyItem(tvb, offset, actx, tree, hf_rnsap_FDD_DCHs_to_Modify_item);
}


static const per_sequence_t FDD_DCHs_to_Modify_sequence_of[1] = {
  { &hf_rnsap_FDD_DCHs_to_Modify_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_FDD_DCHs_to_ModifyItem },
};

static int
dissect_rnsap_FDD_DCHs_to_Modify(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_FDD_DCHs_to_Modify, FDD_DCHs_to_Modify_sequence_of,
                                                  1, 128);

  return offset;
}
static int dissect_id_FDD_DCHs_to_Modify(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_FDD_DCHs_to_Modify(tvb, offset, actx, tree, hf_rnsap_id_FDD_DCHs_to_Modify);
}


static const per_sequence_t TDD_DCHs_to_ModifySpecificItem_sequence[] = {
  { &hf_rnsap_dCH_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_ID },
  { &hf_rnsap_ul_CCTrCH_ID  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_dl_CCTrCH_ID  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_ul_TransportformatSet, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportFormatSet },
  { &hf_rnsap_dl_TransportformatSet, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportFormatSet },
  { &hf_rnsap_allocationRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_AllocationRetentionPriority },
  { &hf_rnsap_frameHandlingPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_FrameHandlingPriority },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TDD_DCHs_to_ModifySpecificItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TDD_DCHs_to_ModifySpecificItem, TDD_DCHs_to_ModifySpecificItem_sequence);

  return offset;
}
static int dissect_TDD_DCHs_to_ModifySpecificInformationList_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TDD_DCHs_to_ModifySpecificItem(tvb, offset, actx, tree, hf_rnsap_TDD_DCHs_to_ModifySpecificInformationList_item);
}


static const per_sequence_t TDD_DCHs_to_ModifySpecificInformationList_sequence_of[1] = {
  { &hf_rnsap_TDD_DCHs_to_ModifySpecificInformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_DCHs_to_ModifySpecificItem },
};

static int
dissect_rnsap_TDD_DCHs_to_ModifySpecificInformationList(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_TDD_DCHs_to_ModifySpecificInformationList, TDD_DCHs_to_ModifySpecificInformationList_sequence_of,
                                                  1, 128);

  return offset;
}
static int dissect_dCH_SpecificInformationList3(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TDD_DCHs_to_ModifySpecificInformationList(tvb, offset, actx, tree, hf_rnsap_dCH_SpecificInformationList3);
}


static const per_sequence_t TDD_DCHs_to_ModifyItem_sequence[] = {
  { &hf_rnsap_ul_FP_Mode    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UL_FP_Mode },
  { &hf_rnsap_toAWS         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ToAWS },
  { &hf_rnsap_toAWE         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ToAWE },
  { &hf_rnsap_transportBearerRequestIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportBearerRequestIndicator },
  { &hf_rnsap_dCH_SpecificInformationList3, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_DCHs_to_ModifySpecificInformationList },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TDD_DCHs_to_ModifyItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TDD_DCHs_to_ModifyItem, TDD_DCHs_to_ModifyItem_sequence);

  return offset;
}
static int dissect_TDD_DCHs_to_Modify_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TDD_DCHs_to_ModifyItem(tvb, offset, actx, tree, hf_rnsap_TDD_DCHs_to_Modify_item);
}


static const per_sequence_t TDD_DCHs_to_Modify_sequence_of[1] = {
  { &hf_rnsap_TDD_DCHs_to_Modify_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_DCHs_to_ModifyItem },
};

static int
dissect_rnsap_TDD_DCHs_to_Modify(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_TDD_DCHs_to_Modify, TDD_DCHs_to_Modify_sequence_of,
                                                  1, 128);

  return offset;
}
static int dissect_id_TDD_DCHs_to_Modify(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TDD_DCHs_to_Modify(tvb, offset, actx, tree, hf_rnsap_id_TDD_DCHs_to_Modify);
}



static int
dissect_rnsap_TransportLayerAddress(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 160, TRUE, NULL);

  return offset;
}
static int dissect_id_TransportLayerAddress(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TransportLayerAddress(tvb, offset, actx, tree, hf_rnsap_id_TransportLayerAddress);
}
static int dissect_transportLayerAddress(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TransportLayerAddress(tvb, offset, actx, tree, hf_rnsap_transportLayerAddress);
}


static const per_sequence_t DCH_InformationResponseItem_sequence[] = {
  { &hf_rnsap_dCH_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_ID },
  { &hf_rnsap_bindingID     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BindingID },
  { &hf_rnsap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportLayerAddress },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DCH_InformationResponseItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DCH_InformationResponseItem, DCH_InformationResponseItem_sequence);

  return offset;
}
static int dissect_DCH_InformationResponse_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_InformationResponseItem(tvb, offset, actx, tree, hf_rnsap_DCH_InformationResponse_item);
}


static const per_sequence_t DCH_InformationResponse_sequence_of[1] = {
  { &hf_rnsap_DCH_InformationResponse_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_InformationResponseItem },
};

static int
dissect_rnsap_DCH_InformationResponse(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DCH_InformationResponse, DCH_InformationResponse_sequence_of,
                                                  1, 128);

  return offset;
}
static int dissect_id_DCH_InformationResponse(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_InformationResponse(tvb, offset, actx, tree, hf_rnsap_id_DCH_InformationResponse);
}
static int dissect_dCH_InformationResponse(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_InformationResponse(tvb, offset, actx, tree, hf_rnsap_dCH_InformationResponse);
}


static const per_sequence_t DCH_Rate_InformationItem_RL_CongestInd_sequence[] = {
  { &hf_rnsap_dCH_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_ID },
  { &hf_rnsap_allowed_Rate_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Allowed_Rate_Information },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DCH_Rate_InformationItem_RL_CongestInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DCH_Rate_InformationItem_RL_CongestInd, DCH_Rate_InformationItem_RL_CongestInd_sequence);

  return offset;
}
static int dissect_id_DCH_Rate_InformationItem_RL_CongestInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_Rate_InformationItem_RL_CongestInd(tvb, offset, actx, tree, hf_rnsap_id_DCH_Rate_InformationItem_RL_CongestInd);
}



static int
dissect_rnsap_INTEGER_0_3(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 3U, NULL, FALSE);

  return offset;
}
static int dissect_uplinkNRTLoadInformationValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_3(tvb, offset, actx, tree, hf_rnsap_uplinkNRTLoadInformationValue);
}
static int dissect_downlinkNRTLoadInformationValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_3(tvb, offset, actx, tree, hf_rnsap_downlinkNRTLoadInformationValue);
}
static int dissect_ctfc2bit(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_3(tvb, offset, actx, tree, hf_rnsap_ctfc2bit);
}



static int
dissect_rnsap_INTEGER_0_15(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 15U, NULL, FALSE);

  return offset;
}
static int dissect_burstStart(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_15(tvb, offset, actx, tree, hf_rnsap_burstStart);
}
static int dissect_ctfc4bit(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_15(tvb, offset, actx, tree, hf_rnsap_ctfc4bit);
}



static int
dissect_rnsap_INTEGER_0_63(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 63U, NULL, FALSE);

  return offset;
}
static int dissect_noinitialOffset(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_63(tvb, offset, actx, tree, hf_rnsap_noinitialOffset);
}
static int dissect_ctfc6bit(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_63(tvb, offset, actx, tree, hf_rnsap_ctfc6bit);
}



static int
dissect_rnsap_INTEGER_0_255(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 255U, NULL, FALSE);

  return offset;
}
static int dissect_t_RLFAILURE(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_255(tvb, offset, actx, tree, hf_rnsap_t_RLFAILURE);
}
static int dissect_initialOffset(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_255(tvb, offset, actx, tree, hf_rnsap_initialOffset);
}
static int dissect_ctfc8bit(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_255(tvb, offset, actx, tree, hf_rnsap_ctfc8bit);
}



static int
dissect_rnsap_INTEGER_0_4095(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 4095U, NULL, FALSE);

  return offset;
}
static int dissect_ctfc12bit(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_4095(tvb, offset, actx, tree, hf_rnsap_ctfc12bit);
}



static int
dissect_rnsap_INTEGER_0_16777215(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 16777215U, NULL, FALSE);

  return offset;
}
static int dissect_ctfcmaxbit(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_16777215(tvb, offset, actx, tree, hf_rnsap_ctfcmaxbit);
}


static const value_string rnsap_TFCS_CTFC_vals[] = {
  {   0, "ctfc2bit" },
  {   1, "ctfc4bit" },
  {   2, "ctfc6bit" },
  {   3, "ctfc8bit" },
  {   4, "ctfc12bit" },
  {   5, "ctfc16bit" },
  {   6, "ctfcmaxbit" },
  { 0, NULL }
};

static const per_choice_t TFCS_CTFC_choice[] = {
  {   0, &hf_rnsap_ctfc2bit      , ASN1_NO_EXTENSIONS     , dissect_rnsap_INTEGER_0_3 },
  {   1, &hf_rnsap_ctfc4bit      , ASN1_NO_EXTENSIONS     , dissect_rnsap_INTEGER_0_15 },
  {   2, &hf_rnsap_ctfc6bit      , ASN1_NO_EXTENSIONS     , dissect_rnsap_INTEGER_0_63 },
  {   3, &hf_rnsap_ctfc8bit      , ASN1_NO_EXTENSIONS     , dissect_rnsap_INTEGER_0_255 },
  {   4, &hf_rnsap_ctfc12bit     , ASN1_NO_EXTENSIONS     , dissect_rnsap_INTEGER_0_4095 },
  {   5, &hf_rnsap_ctfc16bit     , ASN1_NO_EXTENSIONS     , dissect_rnsap_INTEGER_0_65535 },
  {   6, &hf_rnsap_ctfcmaxbit    , ASN1_NO_EXTENSIONS     , dissect_rnsap_INTEGER_0_16777215 },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_TFCS_CTFC(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_TFCS_CTFC, TFCS_CTFC_choice,
                                 NULL);

  return offset;
}
static int dissect_cTFC(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TFCS_CTFC(tvb, offset, actx, tree, hf_rnsap_cTFC);
}



static int
dissect_rnsap_BetaCD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 15U, NULL, FALSE);

  return offset;
}
static int dissect_betaC(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_BetaCD(tvb, offset, actx, tree, hf_rnsap_betaC);
}
static int dissect_betaD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_BetaCD(tvb, offset, actx, tree, hf_rnsap_betaD);
}



static int
dissect_rnsap_RefTFCNumber(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 15U, NULL, FALSE);

  return offset;
}
static int dissect_refTFCNumber(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RefTFCNumber(tvb, offset, actx, tree, hf_rnsap_refTFCNumber);
}


static const per_sequence_t T_signalledGainFactors_sequence[] = {
  { &hf_rnsap_betaC         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BetaCD },
  { &hf_rnsap_betaD         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BetaCD },
  { &hf_rnsap_refTFCNumber  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_RefTFCNumber },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_T_signalledGainFactors(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_T_signalledGainFactors, T_signalledGainFactors_sequence);

  return offset;
}
static int dissect_signalledGainFactors(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_T_signalledGainFactors(tvb, offset, actx, tree, hf_rnsap_signalledGainFactors);
}


static const value_string rnsap_TransportFormatCombination_Beta_vals[] = {
  {   0, "signalledGainFactors" },
  {   1, "refTFCNumber" },
  { 0, NULL }
};

static const per_choice_t TransportFormatCombination_Beta_choice[] = {
  {   0, &hf_rnsap_signalledGainFactors, ASN1_EXTENSION_ROOT    , dissect_rnsap_T_signalledGainFactors },
  {   1, &hf_rnsap_refTFCNumber  , ASN1_EXTENSION_ROOT    , dissect_rnsap_RefTFCNumber },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_TransportFormatCombination_Beta(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_TransportFormatCombination_Beta, TransportFormatCombination_Beta_choice,
                                 NULL);

  return offset;
}
static int dissect_tFC_Beta(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TransportFormatCombination_Beta(tvb, offset, actx, tree, hf_rnsap_tFC_Beta);
}


static const per_sequence_t TFCS_TFCSList_item_sequence[] = {
  { &hf_rnsap_cTFC          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCS_CTFC },
  { &hf_rnsap_tFC_Beta      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportFormatCombination_Beta },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TFCS_TFCSList_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TFCS_TFCSList_item, TFCS_TFCSList_item_sequence);

  return offset;
}
static int dissect_TFCS_TFCSList_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TFCS_TFCSList_item(tvb, offset, actx, tree, hf_rnsap_TFCS_TFCSList_item);
}


static const per_sequence_t TFCS_TFCSList_sequence_of[1] = {
  { &hf_rnsap_TFCS_TFCSList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCS_TFCSList_item },
};

static int
dissect_rnsap_TFCS_TFCSList(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_TFCS_TFCSList, TFCS_TFCSList_sequence_of,
                                                  1, 1024);

  return offset;
}
static int dissect_no_Split_in_TFCI(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TFCS_TFCSList(tvb, offset, actx, tree, hf_rnsap_no_Split_in_TFCI);
}


static const value_string rnsap_T_tFCSvalues_vals[] = {
  {   0, "no-Split-in-TFCI" },
  {   1, "not-Used-split-in-TFCI" },
  { 0, NULL }
};

static const per_choice_t T_tFCSvalues_choice[] = {
  {   0, &hf_rnsap_no_Split_in_TFCI, ASN1_EXTENSION_ROOT    , dissect_rnsap_TFCS_TFCSList },
  {   1, &hf_rnsap_not_Used_split_in_TFCI, ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_T_tFCSvalues(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_T_tFCSvalues, T_tFCSvalues_choice,
                                 NULL);

  return offset;
}
static int dissect_tFCSvalues(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_T_tFCSvalues(tvb, offset, actx, tree, hf_rnsap_tFCSvalues);
}


static const per_sequence_t TFCS_sequence[] = {
  { &hf_rnsap_tFCSvalues    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_T_tFCSvalues },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TFCS(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TFCS, TFCS_sequence);

  return offset;
}
static int dissect_ul_TFCS(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TFCS(tvb, offset, actx, tree, hf_rnsap_ul_TFCS);
}
static int dissect_tFCS(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TFCS(tvb, offset, actx, tree, hf_rnsap_tFCS);
}
static int dissect_dl_TFCS(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TFCS(tvb, offset, actx, tree, hf_rnsap_dl_TFCS);
}


static const value_string rnsap_TFCI_Coding_vals[] = {
  {   0, "v4" },
  {   1, "v8" },
  {   2, "v16" },
  {   3, "v32" },
  { 0, NULL }
};


static int
dissect_rnsap_TFCI_Coding(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_tFCI_Coding(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TFCI_Coding(tvb, offset, actx, tree, hf_rnsap_tFCI_Coding);
}



static int
dissect_rnsap_PunctureLimit(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 15U, NULL, FALSE);

  return offset;
}
static int dissect_ul_PunctureLimit(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PunctureLimit(tvb, offset, actx, tree, hf_rnsap_ul_PunctureLimit);
}
static int dissect_dl_PunctureLimit(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PunctureLimit(tvb, offset, actx, tree, hf_rnsap_dl_PunctureLimit);
}
static int dissect_punctureLimit(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PunctureLimit(tvb, offset, actx, tree, hf_rnsap_punctureLimit);
}


static const per_sequence_t CCTrCH_TPCAddItem_RL_ReconfPrepTDD_sequence[] = {
  { &hf_rnsap_cCTrCH_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CCTrCH_TPCAddItem_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CCTrCH_TPCAddItem_RL_ReconfPrepTDD, CCTrCH_TPCAddItem_RL_ReconfPrepTDD_sequence);

  return offset;
}
static int dissect_CCTrCH_TPCAddList_RL_ReconfPrepTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CCTrCH_TPCAddItem_RL_ReconfPrepTDD(tvb, offset, actx, tree, hf_rnsap_CCTrCH_TPCAddList_RL_ReconfPrepTDD_item);
}


static const per_sequence_t CCTrCH_TPCAddList_RL_ReconfPrepTDD_sequence_of[1] = {
  { &hf_rnsap_CCTrCH_TPCAddList_RL_ReconfPrepTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_TPCAddItem_RL_ReconfPrepTDD },
};

static int
dissect_rnsap_CCTrCH_TPCAddList_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_CCTrCH_TPCAddList_RL_ReconfPrepTDD, CCTrCH_TPCAddList_RL_ReconfPrepTDD_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_cCTrCH_TPCList1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CCTrCH_TPCAddList_RL_ReconfPrepTDD(tvb, offset, actx, tree, hf_rnsap_cCTrCH_TPCList1);
}


static const per_sequence_t DL_CCTrCH_InformationAddItem_RL_ReconfPrepTDD_sequence[] = {
  { &hf_rnsap_cCTrCH_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_tFCS          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCS },
  { &hf_rnsap_tFCI_Coding   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCI_Coding },
  { &hf_rnsap_punctureLimit , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PunctureLimit },
  { &hf_rnsap_cCTrCH_TPCList1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CCTrCH_TPCAddList_RL_ReconfPrepTDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_CCTrCH_InformationAddItem_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_CCTrCH_InformationAddItem_RL_ReconfPrepTDD, DL_CCTrCH_InformationAddItem_RL_ReconfPrepTDD_sequence);

  return offset;
}
static int dissect_id_DL_CCTrCH_InformationAddItem_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CCTrCH_InformationAddItem_RL_ReconfPrepTDD(tvb, offset, actx, tree, hf_rnsap_id_DL_CCTrCH_InformationAddItem_RL_ReconfPrepTDD);
}



static int
dissect_rnsap_ProtocolIE_Single_Container(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Field(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_RL_InformationList_RL_SetupRqstFDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_InformationList_RL_SetupRqstFDD_item);
}
static int dissect_UL_CCTrCH_InformationList_RL_SetupRqstTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_UL_CCTrCH_InformationList_RL_SetupRqstTDD_item);
}
static int dissect_DL_CCTrCH_InformationList_RL_SetupRqstTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_DL_CCTrCH_InformationList_RL_SetupRqstTDD_item);
}
static int dissect_RL_InformationResponseList_RL_SetupRspFDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_InformationResponseList_RL_SetupRspFDD_item);
}
static int dissect_UnsuccessfulRL_InformationResponseList_RL_SetupFailureFDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_UnsuccessfulRL_InformationResponseList_RL_SetupFailureFDD_item);
}
static int dissect_SuccessfulRL_InformationResponseList_RL_SetupFailureFDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_SuccessfulRL_InformationResponseList_RL_SetupFailureFDD_item);
}
static int dissect_RL_InformationList_RL_AdditionRqstFDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_InformationList_RL_AdditionRqstFDD_item);
}
static int dissect_UL_CCTrCH_InformationList_RL_AdditionRqstTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_UL_CCTrCH_InformationList_RL_AdditionRqstTDD_item);
}
static int dissect_DL_CCTrCH_InformationList_RL_AdditionRqstTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_DL_CCTrCH_InformationList_RL_AdditionRqstTDD_item);
}
static int dissect_RL_InformationResponseList_RL_AdditionRspFDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_InformationResponseList_RL_AdditionRspFDD_item);
}
static int dissect_UnsuccessfulRL_InformationResponseList_RL_AdditionFailureFDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_UnsuccessfulRL_InformationResponseList_RL_AdditionFailureFDD_item);
}
static int dissect_SuccessfulRL_InformationResponseList_RL_AdditionFailureFDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_SuccessfulRL_InformationResponseList_RL_AdditionFailureFDD_item);
}
static int dissect_RL_InformationList_RL_DeletionRqst_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_InformationList_RL_DeletionRqst_item);
}
static int dissect_RL_InformationList_RL_ReconfPrepFDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_InformationList_RL_ReconfPrepFDD_item);
}
static int dissect_UL_CCTrCH_InformationAddList_RL_ReconfPrepTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_UL_CCTrCH_InformationAddList_RL_ReconfPrepTDD_item);
}
static int dissect_UL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_UL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD_item);
}
static int dissect_UL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_UL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD_item);
}
static int dissect_DL_CCTrCH_InformationAddList_RL_ReconfPrepTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_DL_CCTrCH_InformationAddList_RL_ReconfPrepTDD_item);
}
static int dissect_DL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_DL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD_item);
}
static int dissect_DL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_DL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD_item);
}
static int dissect_RL_InformationResponseList_RL_ReconfReadyFDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_InformationResponseList_RL_ReconfReadyFDD_item);
}
static int dissect_RL_ReconfigurationFailureList_RL_ReconfFailure_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_ReconfigurationFailureList_RL_ReconfFailure_item);
}
static int dissect_RL_ReconfigurationRequestFDD_RL_InformationList_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_ReconfigurationRequestFDD_RL_InformationList_item);
}
static int dissect_UL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_UL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD_item);
}
static int dissect_UL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_UL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD_item);
}
static int dissect_DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD_item);
}
static int dissect_DL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_DL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD_item);
}
static int dissect_RL_InformationResponseList_RL_ReconfRspFDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_InformationResponseList_RL_ReconfRspFDD_item);
}
static int dissect_RL_InformationList_RL_FailureInd_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_InformationList_RL_FailureInd_item);
}
static int dissect_RL_Set_InformationList_RL_FailureInd_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_Set_InformationList_RL_FailureInd_item);
}
static int dissect_CCTrCH_InformationList_RL_FailureInd_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_CCTrCH_InformationList_RL_FailureInd_item);
}
static int dissect_RL_InformationList_RL_PreemptRequiredInd_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_InformationList_RL_PreemptRequiredInd_item);
}
static int dissect_HSDSCHMacdFlowSpecificInformationList_RL_PreemptRequiredInd_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_HSDSCHMacdFlowSpecificInformationList_RL_PreemptRequiredInd_item);
}
static int dissect_EDCH_MacdFlowSpecificInformationList_RL_PreemptRequiredInd_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_EDCH_MacdFlowSpecificInformationList_RL_PreemptRequiredInd_item);
}
static int dissect_RL_InformationList_RL_RestoreInd_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_InformationList_RL_RestoreInd_item);
}
static int dissect_RL_Set_InformationList_RL_RestoreInd_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_Set_InformationList_RL_RestoreInd_item);
}
static int dissect_CCTrCH_InformationList_RL_RestoreInd_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_CCTrCH_InformationList_RL_RestoreInd_item);
}
static int dissect_DL_ReferencePowerInformationList_DL_PC_Rqst_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_DL_ReferencePowerInformationList_DL_PC_Rqst_item);
}
static int dissect_RL_InformationList_RL_CongestInd_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_InformationList_RL_CongestInd_item);
}
static int dissect_DCH_Rate_Information_RL_CongestInd_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_DCH_Rate_Information_RL_CongestInd_item);
}
static int dissect_EDCH_MacdFlowSpecificInformationList_RL_CongestInd_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_EDCH_MacdFlowSpecificInformationList_RL_CongestInd_item);
}
static int dissect_RL_InformationList_DM_Rqst_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_InformationList_DM_Rqst_item);
}
static int dissect_RL_Set_InformationList_DM_Rqst_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_Set_InformationList_DM_Rqst_item);
}
static int dissect_RL_InformationList_DM_Rsp_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_InformationList_DM_Rsp_item);
}
static int dissect_RL_Set_InformationList_DM_Rsp_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_Set_InformationList_DM_Rsp_item);
}
static int dissect_RL_Unsuccessful_InformationRespList_DM_Fail_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_Unsuccessful_InformationRespList_DM_Fail_item);
}
static int dissect_RL_Successful_InformationRespList_DM_Fail_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_Successful_InformationRespList_DM_Fail_item);
}
static int dissect_RL_Set_Unsuccessful_InformationRespList_DM_Fail_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_Set_Unsuccessful_InformationRespList_DM_Fail_item);
}
static int dissect_RL_Set_Successful_InformationRespList_DM_Fail_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_Set_Successful_InformationRespList_DM_Fail_item);
}
static int dissect_RL_InformationList_DM_Rprt_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_InformationList_DM_Rprt_item);
}
static int dissect_RL_Set_InformationList_DM_Rprt_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_Set_InformationList_DM_Rprt_item);
}
static int dissect_RL_Unsuccessful_InformationRespList_DM_Fail_Ind_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_Unsuccessful_InformationRespList_DM_Fail_Ind_item);
}
static int dissect_RL_Set_Unsuccessful_InformationRespList_DM_Fail_Ind_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_Set_Unsuccessful_InformationRespList_DM_Fail_Ind_item);
}
static int dissect_ContextInfoList_Reset_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_ContextInfoList_Reset_item);
}
static int dissect_ContextGroupInfoList_Reset_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_ContextGroupInfoList_Reset_item);
}
static int dissect_DelayedActivationInformationList_RL_ActivationCmdFDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_DelayedActivationInformationList_RL_ActivationCmdFDD_item);
}
static int dissect_DelayedActivationInformationList_RL_ActivationCmdTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_DelayedActivationInformationList_RL_ActivationCmdTDD_item);
}
static int dissect_RL_ParameterUpdateIndicationFDD_RL_InformationList_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_RL_ParameterUpdateIndicationFDD_RL_InformationList_item);
}
static int dissect_ListOfInterfacesToTrace_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_ListOfInterfacesToTrace_item);
}
static int dissect_Neighbouring_UMTS_CellInformation_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_rnsap_Neighbouring_UMTS_CellInformation_item);
}



static int
dissect_rnsap_DL_DPCH_InformationAddList_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_dl_DPCH_AddInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_DPCH_InformationAddList_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_dl_DPCH_AddInformation);
}



static int
dissect_rnsap_DL_DPCH_InformationModifyList_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_dl_DPCH_ModifyInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_DPCH_InformationModifyList_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_dl_DPCH_ModifyInformation);
}



static int
dissect_rnsap_DL_DPCH_InformationDeleteList_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_dl_DPCH_DeleteInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_DPCH_InformationDeleteList_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_dl_DPCH_DeleteInformation);
}


static const per_sequence_t DL_CCTrCH_InformationItem_RL_ReconfReadyTDD_sequence[] = {
  { &hf_rnsap_cCTrCH_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_dl_DPCH_AddInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_DPCH_InformationAddList_RL_ReconfReadyTDD },
  { &hf_rnsap_dl_DPCH_ModifyInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_DPCH_InformationModifyList_RL_ReconfReadyTDD },
  { &hf_rnsap_dl_DPCH_DeleteInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_DPCH_InformationDeleteList_RL_ReconfReadyTDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_CCTrCH_InformationItem_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_CCTrCH_InformationItem_RL_ReconfReadyTDD, DL_CCTrCH_InformationItem_RL_ReconfReadyTDD_sequence);

  return offset;
}
static int dissect_DL_CCTrCHInformationListIE_RL_ReconfReadyTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CCTrCH_InformationItem_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_DL_CCTrCHInformationListIE_RL_ReconfReadyTDD_item);
}


static const per_sequence_t DL_CCTrCHInformationListIE_RL_ReconfReadyTDD_sequence_of[1] = {
  { &hf_rnsap_DL_CCTrCHInformationListIE_RL_ReconfReadyTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_CCTrCH_InformationItem_RL_ReconfReadyTDD },
};

static int
dissect_rnsap_DL_CCTrCHInformationListIE_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DL_CCTrCHInformationListIE_RL_ReconfReadyTDD, DL_CCTrCHInformationListIE_RL_ReconfReadyTDD_sequence_of,
                                                  0, 16);

  return offset;
}
static int dissect_id_DL_CCTrCH_InformationListIE_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CCTrCHInformationListIE_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_id_DL_CCTrCH_InformationListIE_RL_ReconfReadyTDD);
}


static const per_sequence_t DL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD_sequence[] = {
  { &hf_rnsap_cCTrCH_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD, DL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD_sequence);

  return offset;
}
static int dissect_id_DL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD(tvb, offset, actx, tree, hf_rnsap_id_DL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD);
}


static const value_string rnsap_TDD_TPC_DownlinkStepSize_vals[] = {
  {   0, "step-size1" },
  {   1, "step-size2" },
  {   2, "step-size3" },
  { 0, NULL }
};


static int
dissect_rnsap_TDD_TPC_DownlinkStepSize(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_id_TDD_TPC_DownlinkStepSize_InformationAdd_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TDD_TPC_DownlinkStepSize(tvb, offset, actx, tree, hf_rnsap_id_TDD_TPC_DownlinkStepSize_InformationAdd_RL_ReconfPrepTDD);
}
static int dissect_id_TDD_TPC_DownlinkStepSize_InformationModify_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TDD_TPC_DownlinkStepSize(tvb, offset, actx, tree, hf_rnsap_id_TDD_TPC_DownlinkStepSize_InformationModify_RL_ReconfPrepTDD);
}
static int dissect_tdd_TPC_DownlinkStepSize(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TDD_TPC_DownlinkStepSize(tvb, offset, actx, tree, hf_rnsap_tdd_TPC_DownlinkStepSize);
}
static int dissect_downlinkStepSize(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TDD_TPC_DownlinkStepSize(tvb, offset, actx, tree, hf_rnsap_downlinkStepSize);
}


static const per_sequence_t CCTrCH_TPCItem_RL_SetupRqstTDD_sequence[] = {
  { &hf_rnsap_cCTrCH_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CCTrCH_TPCItem_RL_SetupRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CCTrCH_TPCItem_RL_SetupRqstTDD, CCTrCH_TPCItem_RL_SetupRqstTDD_sequence);

  return offset;
}
static int dissect_CCTrCH_TPCList_RL_SetupRqstTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CCTrCH_TPCItem_RL_SetupRqstTDD(tvb, offset, actx, tree, hf_rnsap_CCTrCH_TPCList_RL_SetupRqstTDD_item);
}


static const per_sequence_t CCTrCH_TPCList_RL_SetupRqstTDD_sequence_of[1] = {
  { &hf_rnsap_CCTrCH_TPCList_RL_SetupRqstTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_TPCItem_RL_SetupRqstTDD },
};

static int
dissect_rnsap_CCTrCH_TPCList_RL_SetupRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_CCTrCH_TPCList_RL_SetupRqstTDD, CCTrCH_TPCList_RL_SetupRqstTDD_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_cCTrCH_TPCList(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CCTrCH_TPCList_RL_SetupRqstTDD(tvb, offset, actx, tree, hf_rnsap_cCTrCH_TPCList);
}


static const per_sequence_t DL_CCTrCH_InformationItem_RL_SetupRqstTDD_sequence[] = {
  { &hf_rnsap_cCTrCH_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_dl_TFCS       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCS },
  { &hf_rnsap_tFCI_Coding   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCI_Coding },
  { &hf_rnsap_dl_PunctureLimit, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PunctureLimit },
  { &hf_rnsap_tdd_TPC_DownlinkStepSize, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_TPC_DownlinkStepSize },
  { &hf_rnsap_cCTrCH_TPCList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CCTrCH_TPCList_RL_SetupRqstTDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_CCTrCH_InformationItem_RL_SetupRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_CCTrCH_InformationItem_RL_SetupRqstTDD, DL_CCTrCH_InformationItem_RL_SetupRqstTDD_sequence);

  return offset;
}
static int dissect_id_DL_CCTrCH_InformationItem_RL_SetupRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CCTrCH_InformationItem_RL_SetupRqstTDD(tvb, offset, actx, tree, hf_rnsap_id_DL_CCTrCH_InformationItem_RL_SetupRqstTDD);
}
static int dissect_id_DL_CCTrCH_InformationListIE_RL_SetupRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CCTrCH_InformationItem_RL_SetupRqstTDD(tvb, offset, actx, tree, hf_rnsap_id_DL_CCTrCH_InformationListIE_RL_SetupRspTDD);
}



static int
dissect_rnsap_DL_DPCH_InformationList_PhyChReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_dl_DPCH_Information2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_DPCH_InformationList_PhyChReconfRqstTDD(tvb, offset, actx, tree, hf_rnsap_dl_DPCH_Information2);
}


static const per_sequence_t DL_CCTrCH_InformationItem_PhyChReconfRqstTDD_sequence[] = {
  { &hf_rnsap_cCTrCH_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_dl_DPCH_Information2, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_DPCH_InformationList_PhyChReconfRqstTDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_CCTrCH_InformationItem_PhyChReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_CCTrCH_InformationItem_PhyChReconfRqstTDD, DL_CCTrCH_InformationItem_PhyChReconfRqstTDD_sequence);

  return offset;
}
static int dissect_DL_CCTrCH_InformationListIE_PhyChReconfRqstTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CCTrCH_InformationItem_PhyChReconfRqstTDD(tvb, offset, actx, tree, hf_rnsap_DL_CCTrCH_InformationListIE_PhyChReconfRqstTDD_item);
}


static const per_sequence_t DL_CCTrCH_InformationListIE_PhyChReconfRqstTDD_sequence_of[1] = {
  { &hf_rnsap_DL_CCTrCH_InformationListIE_PhyChReconfRqstTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_CCTrCH_InformationItem_PhyChReconfRqstTDD },
};

static int
dissect_rnsap_DL_CCTrCH_InformationListIE_PhyChReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DL_CCTrCH_InformationListIE_PhyChReconfRqstTDD, DL_CCTrCH_InformationListIE_PhyChReconfRqstTDD_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_id_DL_CCTrCH_InformationListIE_PhyChReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CCTrCH_InformationListIE_PhyChReconfRqstTDD(tvb, offset, actx, tree, hf_rnsap_id_DL_CCTrCH_InformationListIE_PhyChReconfRqstTDD);
}



static int
dissect_rnsap_DL_DPCH_InformationList_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_dl_DPCH_Information1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_DPCH_InformationList_RL_AdditionRspTDD(tvb, offset, actx, tree, hf_rnsap_dl_DPCH_Information1);
}


static const per_sequence_t DL_CCTrCHInformationItem_RL_AdditionRspTDD_sequence[] = {
  { &hf_rnsap_cCTrCH_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_dl_DPCH_Information1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_DPCH_InformationList_RL_AdditionRspTDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_CCTrCHInformationItem_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_CCTrCHInformationItem_RL_AdditionRspTDD, DL_CCTrCHInformationItem_RL_AdditionRspTDD_sequence);

  return offset;
}
static int dissect_DL_CCTrCHInformationListIE_RL_AdditionRspTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CCTrCHInformationItem_RL_AdditionRspTDD(tvb, offset, actx, tree, hf_rnsap_DL_CCTrCHInformationListIE_RL_AdditionRspTDD_item);
}


static const per_sequence_t DL_CCTrCHInformationListIE_RL_AdditionRspTDD_sequence_of[1] = {
  { &hf_rnsap_DL_CCTrCHInformationListIE_RL_AdditionRspTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_CCTrCHInformationItem_RL_AdditionRspTDD },
};

static int
dissect_rnsap_DL_CCTrCHInformationListIE_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DL_CCTrCHInformationListIE_RL_AdditionRspTDD, DL_CCTrCHInformationListIE_RL_AdditionRspTDD_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_id_DL_CCTrCH_InformationListIE_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CCTrCHInformationListIE_RL_AdditionRspTDD(tvb, offset, actx, tree, hf_rnsap_id_DL_CCTrCH_InformationListIE_RL_AdditionRspTDD);
}


static const per_sequence_t DL_CCTrCH_InformationAddList_RL_ReconfPrepTDD_sequence_of[1] = {
  { &hf_rnsap_DL_CCTrCH_InformationAddList_RL_ReconfPrepTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_DL_CCTrCH_InformationAddList_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DL_CCTrCH_InformationAddList_RL_ReconfPrepTDD, DL_CCTrCH_InformationAddList_RL_ReconfPrepTDD_sequence_of,
                                                  0, 16);

  return offset;
}
static int dissect_id_DL_CCTrCH_InformationAddList_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CCTrCH_InformationAddList_RL_ReconfPrepTDD(tvb, offset, actx, tree, hf_rnsap_id_DL_CCTrCH_InformationAddList_RL_ReconfPrepTDD);
}


static const per_sequence_t DL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD_sequence_of[1] = {
  { &hf_rnsap_DL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_DL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD, DL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD_sequence_of,
                                                  0, 16);

  return offset;
}
static int dissect_id_DL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD(tvb, offset, actx, tree, hf_rnsap_id_DL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD);
}


static const per_sequence_t DL_CCTrCH_InformationList_RL_SetupRqstTDD_sequence_of[1] = {
  { &hf_rnsap_DL_CCTrCH_InformationList_RL_SetupRqstTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_DL_CCTrCH_InformationList_RL_SetupRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DL_CCTrCH_InformationList_RL_SetupRqstTDD, DL_CCTrCH_InformationList_RL_SetupRqstTDD_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_id_DL_CCTrCH_InformationList_RL_SetupRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CCTrCH_InformationList_RL_SetupRqstTDD(tvb, offset, actx, tree, hf_rnsap_id_DL_CCTrCH_InformationList_RL_SetupRqstTDD);
}



static int
dissect_rnsap_DL_ScramblingCode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 15U, NULL, FALSE);

  return offset;
}
static int dissect_eAGCH_ERGCH_EHICH_FDD_ScramblingCode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_ScramblingCode(tvb, offset, actx, tree, hf_rnsap_eAGCH_ERGCH_EHICH_FDD_ScramblingCode);
}
static int dissect_dl_ScramblingCode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_ScramblingCode(tvb, offset, actx, tree, hf_rnsap_dl_ScramblingCode);
}
static int dissect_hSPDSCH_and_HSSCCH_ScramblingCode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_ScramblingCode(tvb, offset, actx, tree, hf_rnsap_hSPDSCH_and_HSSCCH_ScramblingCode);
}



static int
dissect_rnsap_FDD_DL_ChannelisationCodeNumber(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 511U, NULL, FALSE);

  return offset;
}
static int dissect_eAGCH_ChannelisationCode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_FDD_DL_ChannelisationCodeNumber(tvb, offset, actx, tree, hf_rnsap_eAGCH_ChannelisationCode);
}
static int dissect_eRGCH_EHICH_ChannelisationCode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_FDD_DL_ChannelisationCodeNumber(tvb, offset, actx, tree, hf_rnsap_eRGCH_EHICH_ChannelisationCode);
}
static int dissect_fDD_DL_ChannelisationCodeNumber(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_FDD_DL_ChannelisationCodeNumber(tvb, offset, actx, tree, hf_rnsap_fDD_DL_ChannelisationCodeNumber);
}


static const value_string rnsap_Transmission_Gap_Pattern_Sequence_ScramblingCode_Information_vals[] = {
  {   0, "code-change" },
  {   1, "nocode-change" },
  { 0, NULL }
};


static int
dissect_rnsap_Transmission_Gap_Pattern_Sequence_ScramblingCode_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_transmission_Gap_Pattern_Sequence_ScramblingCode_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Transmission_Gap_Pattern_Sequence_ScramblingCode_Information(tvb, offset, actx, tree, hf_rnsap_transmission_Gap_Pattern_Sequence_ScramblingCode_Information);
}


static const per_sequence_t FDD_DL_CodeInformationItem_sequence[] = {
  { &hf_rnsap_dl_ScramblingCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_ScramblingCode },
  { &hf_rnsap_fDD_DL_ChannelisationCodeNumber, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_FDD_DL_ChannelisationCodeNumber },
  { &hf_rnsap_transmission_Gap_Pattern_Sequence_ScramblingCode_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Transmission_Gap_Pattern_Sequence_ScramblingCode_Information },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_FDD_DL_CodeInformationItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_FDD_DL_CodeInformationItem, FDD_DL_CodeInformationItem_sequence);

  return offset;
}
static int dissect_FDD_DL_CodeInformation_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_FDD_DL_CodeInformationItem(tvb, offset, actx, tree, hf_rnsap_FDD_DL_CodeInformation_item);
}


static const per_sequence_t FDD_DL_CodeInformation_sequence_of[1] = {
  { &hf_rnsap_FDD_DL_CodeInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_FDD_DL_CodeInformationItem },
};

static int
dissect_rnsap_FDD_DL_CodeInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_FDD_DL_CodeInformation, FDD_DL_CodeInformation_sequence_of,
                                                  1, 8);

  return offset;
}
static int dissect_id_FDD_DL_CodeInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_FDD_DL_CodeInformation(tvb, offset, actx, tree, hf_rnsap_id_FDD_DL_CodeInformation);
}
static int dissect_dl_CodeInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_FDD_DL_CodeInformation(tvb, offset, actx, tree, hf_rnsap_dl_CodeInformation);
}



static int
dissect_rnsap_DL_DPCH_SlotFormat(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 16U, NULL, TRUE);

  return offset;
}
static int dissect_dl_DPCH_SlotFormat(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_DPCH_SlotFormat(tvb, offset, actx, tree, hf_rnsap_dl_DPCH_SlotFormat);
}



static int
dissect_rnsap_NrOfDLchannelisationcodes(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              1U, 8U, NULL, FALSE);

  return offset;
}
static int dissect_nrOfDLchannelisationcodes(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NrOfDLchannelisationcodes(tvb, offset, actx, tree, hf_rnsap_nrOfDLchannelisationcodes);
}


static const value_string rnsap_TFCI_SignallingMode_vals[] = {
  {   0, "normal" },
  {   1, "not-Used-split" },
  { 0, NULL }
};


static int
dissect_rnsap_TFCI_SignallingMode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_tFCI_SignallingMode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TFCI_SignallingMode(tvb, offset, actx, tree, hf_rnsap_tFCI_SignallingMode);
}


static const value_string rnsap_TFCI_Presence_vals[] = {
  {   0, "present" },
  {   1, "not-present" },
  { 0, NULL }
};


static int
dissect_rnsap_TFCI_Presence(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_tFCI_Presence(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TFCI_Presence(tvb, offset, actx, tree, hf_rnsap_tFCI_Presence);
}


static const value_string rnsap_MultiplexingPosition_vals[] = {
  {   0, "fixed" },
  {   1, "flexible" },
  { 0, NULL }
};


static int
dissect_rnsap_MultiplexingPosition(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_multiplexingPosition(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MultiplexingPosition(tvb, offset, actx, tree, hf_rnsap_multiplexingPosition);
}


static const value_string rnsap_LimitedPowerIncrease_vals[] = {
  {   0, "used" },
  {   1, "not-used" },
  { 0, NULL }
};


static int
dissect_rnsap_LimitedPowerIncrease(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_limitedPowerIncrease(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_LimitedPowerIncrease(tvb, offset, actx, tree, hf_rnsap_limitedPowerIncrease);
}


static const per_sequence_t DL_DPCH_Information_RL_ReconfPrepFDD_sequence[] = {
  { &hf_rnsap_tFCS          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TFCS },
  { &hf_rnsap_dl_DPCH_SlotFormat, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_DPCH_SlotFormat },
  { &hf_rnsap_nrOfDLchannelisationcodes, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_NrOfDLchannelisationcodes },
  { &hf_rnsap_tFCI_SignallingMode, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TFCI_SignallingMode },
  { &hf_rnsap_tFCI_Presence , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TFCI_Presence },
  { &hf_rnsap_multiplexingPosition, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MultiplexingPosition },
  { &hf_rnsap_limitedPowerIncrease, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_LimitedPowerIncrease },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_DPCH_Information_RL_ReconfPrepFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_DPCH_Information_RL_ReconfPrepFDD, DL_DPCH_Information_RL_ReconfPrepFDD_sequence);

  return offset;
}
static int dissect_id_DL_DPCH_Information_RL_ReconfPrepFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_DPCH_Information_RL_ReconfPrepFDD(tvb, offset, actx, tree, hf_rnsap_id_DL_DPCH_Information_RL_ReconfPrepFDD);
}



static int
dissect_rnsap_PowerOffset(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 24U, NULL, FALSE);

  return offset;
}
static int dissect_po1_ForTFCI_Bits(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PowerOffset(tvb, offset, actx, tree, hf_rnsap_po1_ForTFCI_Bits);
}
static int dissect_po2_ForTPC_Bits(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PowerOffset(tvb, offset, actx, tree, hf_rnsap_po2_ForTPC_Bits);
}
static int dissect_po3_ForPilotBits(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PowerOffset(tvb, offset, actx, tree, hf_rnsap_po3_ForPilotBits);
}
static int dissect_pO1_ForTFCI_Bits(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PowerOffset(tvb, offset, actx, tree, hf_rnsap_pO1_ForTFCI_Bits);
}
static int dissect_pO2_ForTPC_Bits(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PowerOffset(tvb, offset, actx, tree, hf_rnsap_pO2_ForTPC_Bits);
}
static int dissect_pO3_ForPilotBits(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PowerOffset(tvb, offset, actx, tree, hf_rnsap_pO3_ForPilotBits);
}


static const per_sequence_t PowerOffsetInformation_RL_SetupRqstFDD_sequence[] = {
  { &hf_rnsap_po1_ForTFCI_Bits, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PowerOffset },
  { &hf_rnsap_po2_ForTPC_Bits, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PowerOffset },
  { &hf_rnsap_po3_ForPilotBits, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PowerOffset },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_PowerOffsetInformation_RL_SetupRqstFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_PowerOffsetInformation_RL_SetupRqstFDD, PowerOffsetInformation_RL_SetupRqstFDD_sequence);

  return offset;
}
static int dissect_powerOffsetInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PowerOffsetInformation_RL_SetupRqstFDD(tvb, offset, actx, tree, hf_rnsap_powerOffsetInformation);
}


static const value_string rnsap_FDD_TPC_DownlinkStepSize_vals[] = {
  {   0, "step-size0-5" },
  {   1, "step-size1" },
  {   2, "step-size1-5" },
  {   3, "step-size2" },
  { 0, NULL }
};


static int
dissect_rnsap_FDD_TPC_DownlinkStepSize(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_fdd_dl_TPC_DownlinkStepSize(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_FDD_TPC_DownlinkStepSize(tvb, offset, actx, tree, hf_rnsap_fdd_dl_TPC_DownlinkStepSize);
}
static int dissect_fdd_TPC_DownlinkStepSize(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_FDD_TPC_DownlinkStepSize(tvb, offset, actx, tree, hf_rnsap_fdd_TPC_DownlinkStepSize);
}


static const value_string rnsap_InnerLoopDLPCStatus_vals[] = {
  {   0, "active" },
  {   1, "inactive" },
  { 0, NULL }
};


static int
dissect_rnsap_InnerLoopDLPCStatus(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_id_InnerLoopDLPCStatus(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_InnerLoopDLPCStatus(tvb, offset, actx, tree, hf_rnsap_id_InnerLoopDLPCStatus);
}
static int dissect_innerLoopDLPCStatus(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_InnerLoopDLPCStatus(tvb, offset, actx, tree, hf_rnsap_innerLoopDLPCStatus);
}


static const per_sequence_t DL_DPCH_Information_RL_SetupRqstFDD_sequence[] = {
  { &hf_rnsap_tFCS          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCS },
  { &hf_rnsap_dl_DPCH_SlotFormat, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_DPCH_SlotFormat },
  { &hf_rnsap_nrOfDLchannelisationcodes, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_NrOfDLchannelisationcodes },
  { &hf_rnsap_tFCI_SignallingMode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCI_SignallingMode },
  { &hf_rnsap_tFCI_Presence , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TFCI_Presence },
  { &hf_rnsap_multiplexingPosition, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MultiplexingPosition },
  { &hf_rnsap_powerOffsetInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PowerOffsetInformation_RL_SetupRqstFDD },
  { &hf_rnsap_fdd_dl_TPC_DownlinkStepSize, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_FDD_TPC_DownlinkStepSize },
  { &hf_rnsap_limitedPowerIncrease, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_LimitedPowerIncrease },
  { &hf_rnsap_innerLoopDLPCStatus, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_InnerLoopDLPCStatus },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_DPCH_Information_RL_SetupRqstFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_DPCH_Information_RL_SetupRqstFDD, DL_DPCH_Information_RL_SetupRqstFDD_sequence);

  return offset;
}
static int dissect_id_DL_DPCH_Information_RL_SetupRqstFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_DPCH_Information_RL_SetupRqstFDD(tvb, offset, actx, tree, hf_rnsap_id_DL_DPCH_Information_RL_SetupRqstFDD);
}


static const per_sequence_t DL_DPCH_Information_RL_ReconfRqstFDD_sequence[] = {
  { &hf_rnsap_tFCS          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TFCS },
  { &hf_rnsap_tFCI_SignallingMode, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TFCI_SignallingMode },
  { &hf_rnsap_limitedPowerIncrease, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_LimitedPowerIncrease },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_DPCH_Information_RL_ReconfRqstFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_DPCH_Information_RL_ReconfRqstFDD, DL_DPCH_Information_RL_ReconfRqstFDD_sequence);

  return offset;
}
static int dissect_id_DL_DPCH_Information_RL_ReconfRqstFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_DPCH_Information_RL_ReconfRqstFDD(tvb, offset, actx, tree, hf_rnsap_id_DL_DPCH_Information_RL_ReconfRqstFDD);
}


static const value_string rnsap_RepetitionPeriod_vals[] = {
  {   0, "v1" },
  {   1, "v2" },
  {   2, "v4" },
  {   3, "v8" },
  {   4, "v16" },
  {   5, "v32" },
  {   6, "v64" },
  { 0, NULL }
};


static int
dissect_rnsap_RepetitionPeriod(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_repetitionPeriod(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RepetitionPeriod(tvb, offset, actx, tree, hf_rnsap_repetitionPeriod);
}



static int
dissect_rnsap_RepetitionLength(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              1U, 63U, NULL, FALSE);

  return offset;
}
static int dissect_repetitionLength(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RepetitionLength(tvb, offset, actx, tree, hf_rnsap_repetitionLength);
}


static const value_string rnsap_TDD_DPCHOffset_vals[] = {
  {   0, "initialOffset" },
  {   1, "noinitialOffset" },
  { 0, NULL }
};

static const per_choice_t TDD_DPCHOffset_choice[] = {
  {   0, &hf_rnsap_initialOffset , ASN1_NO_EXTENSIONS     , dissect_rnsap_INTEGER_0_255 },
  {   1, &hf_rnsap_noinitialOffset, ASN1_NO_EXTENSIONS     , dissect_rnsap_INTEGER_0_63 },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_TDD_DPCHOffset(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_TDD_DPCHOffset, TDD_DPCHOffset_choice,
                                 NULL);

  return offset;
}
static int dissect_tDD_DPCHOffset(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TDD_DPCHOffset(tvb, offset, actx, tree, hf_rnsap_tDD_DPCHOffset);
}



static int
dissect_rnsap_TimeSlot(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 14U, NULL, FALSE);

  return offset;
}
static int dissect_id_TimeSlot_RL_SetupRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TimeSlot(tvb, offset, actx, tree, hf_rnsap_id_TimeSlot_RL_SetupRspTDD);
}
static int dissect_timeSlot(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TimeSlot(tvb, offset, actx, tree, hf_rnsap_timeSlot);
}
static int dissect_timeslot(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TimeSlot(tvb, offset, actx, tree, hf_rnsap_timeslot);
}


static const value_string rnsap_MidambleConfigurationBurstType1And3_vals[] = {
  {   0, "v4" },
  {   1, "v8" },
  {   2, "v16" },
  { 0, NULL }
};


static int
dissect_rnsap_MidambleConfigurationBurstType1And3(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_midambleConfigurationBurstType1And3(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MidambleConfigurationBurstType1And3(tvb, offset, actx, tree, hf_rnsap_midambleConfigurationBurstType1And3);
}



static int
dissect_rnsap_MidambleShiftLong(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 15U, NULL, FALSE);

  return offset;
}
static int dissect_ueSpecificMidamble(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MidambleShiftLong(tvb, offset, actx, tree, hf_rnsap_ueSpecificMidamble);
}
static int dissect_midambleShift(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MidambleShiftLong(tvb, offset, actx, tree, hf_rnsap_midambleShift);
}


static const value_string rnsap_T_midambleAllocationMode_vals[] = {
  {   0, "defaultMidamble" },
  {   1, "commonMidamble" },
  {   2, "ueSpecificMidamble" },
  { 0, NULL }
};

static const per_choice_t T_midambleAllocationMode_choice[] = {
  {   0, &hf_rnsap_defaultMidamble, ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  {   1, &hf_rnsap_commonMidamble, ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  {   2, &hf_rnsap_ueSpecificMidamble, ASN1_EXTENSION_ROOT    , dissect_rnsap_MidambleShiftLong },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_T_midambleAllocationMode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_T_midambleAllocationMode, T_midambleAllocationMode_choice,
                                 NULL);

  return offset;
}
static int dissect_midambleAllocationMode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_T_midambleAllocationMode(tvb, offset, actx, tree, hf_rnsap_midambleAllocationMode);
}


static const per_sequence_t T_type1_sequence[] = {
  { &hf_rnsap_midambleConfigurationBurstType1And3, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleConfigurationBurstType1And3 },
  { &hf_rnsap_midambleAllocationMode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_T_midambleAllocationMode },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_T_type1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_T_type1, T_type1_sequence);

  return offset;
}
static int dissect_type1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_T_type1(tvb, offset, actx, tree, hf_rnsap_type1);
}


static const value_string rnsap_MidambleConfigurationBurstType2_vals[] = {
  {   0, "v3" },
  {   1, "v6" },
  { 0, NULL }
};


static int
dissect_rnsap_MidambleConfigurationBurstType2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_midambleConfigurationBurstType2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MidambleConfigurationBurstType2(tvb, offset, actx, tree, hf_rnsap_midambleConfigurationBurstType2);
}



static int
dissect_rnsap_MidambleShiftShort(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 5U, NULL, FALSE);

  return offset;
}
static int dissect_ueSpecificMidamble1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MidambleShiftShort(tvb, offset, actx, tree, hf_rnsap_ueSpecificMidamble1);
}


static const value_string rnsap_T_midambleAllocationMode1_vals[] = {
  {   0, "defaultMidamble" },
  {   1, "commonMidamble" },
  {   2, "ueSpecificMidamble" },
  { 0, NULL }
};

static const per_choice_t T_midambleAllocationMode1_choice[] = {
  {   0, &hf_rnsap_defaultMidamble, ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  {   1, &hf_rnsap_commonMidamble, ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  {   2, &hf_rnsap_ueSpecificMidamble1, ASN1_EXTENSION_ROOT    , dissect_rnsap_MidambleShiftShort },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_T_midambleAllocationMode1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_T_midambleAllocationMode1, T_midambleAllocationMode1_choice,
                                 NULL);

  return offset;
}
static int dissect_midambleAllocationMode1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_T_midambleAllocationMode1(tvb, offset, actx, tree, hf_rnsap_midambleAllocationMode1);
}


static const per_sequence_t T_type2_sequence[] = {
  { &hf_rnsap_midambleConfigurationBurstType2, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleConfigurationBurstType2 },
  { &hf_rnsap_midambleAllocationMode1, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_T_midambleAllocationMode1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_T_type2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_T_type2, T_type2_sequence);

  return offset;
}
static int dissect_type2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_T_type2(tvb, offset, actx, tree, hf_rnsap_type2);
}


static const value_string rnsap_T_midambleAllocationMode2_vals[] = {
  {   0, "defaultMidamble" },
  {   1, "ueSpecificMidamble" },
  { 0, NULL }
};

static const per_choice_t T_midambleAllocationMode2_choice[] = {
  {   0, &hf_rnsap_defaultMidamble, ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  {   1, &hf_rnsap_ueSpecificMidamble, ASN1_EXTENSION_ROOT    , dissect_rnsap_MidambleShiftLong },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_T_midambleAllocationMode2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_T_midambleAllocationMode2, T_midambleAllocationMode2_choice,
                                 NULL);

  return offset;
}
static int dissect_midambleAllocationMode2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_T_midambleAllocationMode2(tvb, offset, actx, tree, hf_rnsap_midambleAllocationMode2);
}


static const per_sequence_t T_type3_sequence[] = {
  { &hf_rnsap_midambleConfigurationBurstType1And3, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleConfigurationBurstType1And3 },
  { &hf_rnsap_midambleAllocationMode2, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_T_midambleAllocationMode2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_T_type3(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_T_type3, T_type3_sequence);

  return offset;
}
static int dissect_type3(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_T_type3(tvb, offset, actx, tree, hf_rnsap_type3);
}


static const value_string rnsap_MidambleShiftAndBurstType_vals[] = {
  {   0, "type1" },
  {   1, "type2" },
  {   2, "type3" },
  { 0, NULL }
};

static const per_choice_t MidambleShiftAndBurstType_choice[] = {
  {   0, &hf_rnsap_type1         , ASN1_EXTENSION_ROOT    , dissect_rnsap_T_type1 },
  {   1, &hf_rnsap_type2         , ASN1_EXTENSION_ROOT    , dissect_rnsap_T_type2 },
  {   2, &hf_rnsap_type3         , ASN1_EXTENSION_ROOT    , dissect_rnsap_T_type3 },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_MidambleShiftAndBurstType(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_MidambleShiftAndBurstType, MidambleShiftAndBurstType_choice,
                                 NULL);

  return offset;
}
static int dissect_midambleShiftAndBurstType(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MidambleShiftAndBurstType(tvb, offset, actx, tree, hf_rnsap_midambleShiftAndBurstType);
}



static int
dissect_rnsap_DPCH_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 239U, NULL, FALSE);

  return offset;
}
static int dissect_dPCH_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DPCH_ID(tvb, offset, actx, tree, hf_rnsap_dPCH_ID);
}


static const value_string rnsap_TDD_ChannelisationCode_vals[] = {
  {   0, "chCode1div1" },
  {   1, "chCode2div1" },
  {   2, "chCode2div2" },
  {   3, "chCode4div1" },
  {   4, "chCode4div2" },
  {   5, "chCode4div3" },
  {   6, "chCode4div4" },
  {   7, "chCode8div1" },
  {   8, "chCode8div2" },
  {   9, "chCode8div3" },
  {  10, "chCode8div4" },
  {  11, "chCode8div5" },
  {  12, "chCode8div6" },
  {  13, "chCode8div7" },
  {  14, "chCode8div8" },
  {  15, "chCode16div1" },
  {  16, "chCode16div2" },
  {  17, "chCode16div3" },
  {  18, "chCode16div4" },
  {  19, "chCode16div5" },
  {  20, "chCode16div6" },
  {  21, "chCode16div7" },
  {  22, "chCode16div8" },
  {  23, "chCode16div9" },
  {  24, "chCode16div10" },
  {  25, "chCode16div11" },
  {  26, "chCode16div12" },
  {  27, "chCode16div13" },
  {  28, "chCode16div14" },
  {  29, "chCode16div15" },
  {  30, "chCode16div16" },
  { 0, NULL }
};


static int
dissect_rnsap_TDD_ChannelisationCode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     31, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_tDD_ChannelisationCode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TDD_ChannelisationCode(tvb, offset, actx, tree, hf_rnsap_tDD_ChannelisationCode);
}
static int dissect_first_TDD_ChannelisationCode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TDD_ChannelisationCode(tvb, offset, actx, tree, hf_rnsap_first_TDD_ChannelisationCode);
}
static int dissect_second_TDD_ChannelisationCode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TDD_ChannelisationCode(tvb, offset, actx, tree, hf_rnsap_second_TDD_ChannelisationCode);
}


static const per_sequence_t TDD_DL_Code_InformationItem_sequence[] = {
  { &hf_rnsap_dPCH_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DPCH_ID },
  { &hf_rnsap_tDD_ChannelisationCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCode },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TDD_DL_Code_InformationItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TDD_DL_Code_InformationItem, TDD_DL_Code_InformationItem_sequence);

  return offset;
}
static int dissect_TDD_DL_Code_Information_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TDD_DL_Code_InformationItem(tvb, offset, actx, tree, hf_rnsap_TDD_DL_Code_Information_item);
}


static const per_sequence_t TDD_DL_Code_Information_sequence_of[1] = {
  { &hf_rnsap_TDD_DL_Code_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_DL_Code_InformationItem },
};

static int
dissect_rnsap_TDD_DL_Code_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_TDD_DL_Code_Information, TDD_DL_Code_Information_sequence_of,
                                                  1, 240);

  return offset;
}
static int dissect_dL_Code_Information1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TDD_DL_Code_Information(tvb, offset, actx, tree, hf_rnsap_dL_Code_Information1);
}


static const per_sequence_t DL_Timeslot_InformationItem_PhyChReconfRqstTDD_sequence[] = {
  { &hf_rnsap_timeSlot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlot },
  { &hf_rnsap_midambleShiftAndBurstType, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MidambleShiftAndBurstType },
  { &hf_rnsap_tFCI_Presence , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TFCI_Presence },
  { &hf_rnsap_dL_Code_Information1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TDD_DL_Code_Information },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_Timeslot_InformationItem_PhyChReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_Timeslot_InformationItem_PhyChReconfRqstTDD, DL_Timeslot_InformationItem_PhyChReconfRqstTDD_sequence);

  return offset;
}
static int dissect_DL_Timeslot_InformationList_PhyChReconfRqstTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Timeslot_InformationItem_PhyChReconfRqstTDD(tvb, offset, actx, tree, hf_rnsap_DL_Timeslot_InformationList_PhyChReconfRqstTDD_item);
}


static const per_sequence_t DL_Timeslot_InformationList_PhyChReconfRqstTDD_sequence_of[1] = {
  { &hf_rnsap_DL_Timeslot_InformationList_PhyChReconfRqstTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_Timeslot_InformationItem_PhyChReconfRqstTDD },
};

static int
dissect_rnsap_DL_Timeslot_InformationList_PhyChReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DL_Timeslot_InformationList_PhyChReconfRqstTDD, DL_Timeslot_InformationList_PhyChReconfRqstTDD_sequence_of,
                                                  1, 15);

  return offset;
}
static int dissect_dL_Timeslot_InformationList_PhyChReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Timeslot_InformationList_PhyChReconfRqstTDD(tvb, offset, actx, tree, hf_rnsap_dL_Timeslot_InformationList_PhyChReconfRqstTDD);
}


static const per_sequence_t DL_DPCH_InformationItem_PhyChReconfRqstTDD_sequence[] = {
  { &hf_rnsap_repetitionPeriod, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_RepetitionPeriod },
  { &hf_rnsap_repetitionLength, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_RepetitionLength },
  { &hf_rnsap_tDD_DPCHOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TDD_DPCHOffset },
  { &hf_rnsap_dL_Timeslot_InformationList_PhyChReconfRqstTDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_Timeslot_InformationList_PhyChReconfRqstTDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_DPCH_InformationItem_PhyChReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_DPCH_InformationItem_PhyChReconfRqstTDD, DL_DPCH_InformationItem_PhyChReconfRqstTDD_sequence);

  return offset;
}
static int dissect_id_DL_DPCH_InformationItem_PhyChReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_DPCH_InformationItem_PhyChReconfRqstTDD(tvb, offset, actx, tree, hf_rnsap_id_DL_DPCH_InformationItem_PhyChReconfRqstTDD);
}


static const per_sequence_t DL_Timeslot_InformationItem_sequence[] = {
  { &hf_rnsap_timeSlot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlot },
  { &hf_rnsap_midambleShiftAndBurstType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleShiftAndBurstType },
  { &hf_rnsap_tFCI_Presence , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCI_Presence },
  { &hf_rnsap_dL_Code_Information1, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_DL_Code_Information },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_Timeslot_InformationItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_Timeslot_InformationItem, DL_Timeslot_InformationItem_sequence);

  return offset;
}
static int dissect_DL_Timeslot_Information_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Timeslot_InformationItem(tvb, offset, actx, tree, hf_rnsap_DL_Timeslot_Information_item);
}


static const per_sequence_t DL_Timeslot_Information_sequence_of[1] = {
  { &hf_rnsap_DL_Timeslot_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_Timeslot_InformationItem },
};

static int
dissect_rnsap_DL_Timeslot_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DL_Timeslot_Information, DL_Timeslot_Information_sequence_of,
                                                  1, 15);

  return offset;
}
static int dissect_dL_Timeslot_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Timeslot_Information(tvb, offset, actx, tree, hf_rnsap_dL_Timeslot_Information);
}


static const per_sequence_t DL_DPCH_InformationItem_RL_AdditionRspTDD_sequence[] = {
  { &hf_rnsap_repetitionPeriod, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RepetitionPeriod },
  { &hf_rnsap_repetitionLength, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RepetitionLength },
  { &hf_rnsap_tDD_DPCHOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_DPCHOffset },
  { &hf_rnsap_dL_Timeslot_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_Timeslot_Information },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_DPCH_InformationItem_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_DPCH_InformationItem_RL_AdditionRspTDD, DL_DPCH_InformationItem_RL_AdditionRspTDD_sequence);

  return offset;
}
static int dissect_id_DL_DPCH_InformationItem_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_DPCH_InformationItem_RL_AdditionRspTDD(tvb, offset, actx, tree, hf_rnsap_id_DL_DPCH_InformationItem_RL_AdditionRspTDD);
}


static const per_sequence_t DL_DPCH_InformationItem_RL_SetupRspTDD_sequence[] = {
  { &hf_rnsap_repetitionPeriod, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RepetitionPeriod },
  { &hf_rnsap_repetitionLength, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RepetitionLength },
  { &hf_rnsap_tDD_DPCHOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_DPCHOffset },
  { &hf_rnsap_dL_Timeslot_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_Timeslot_Information },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_DPCH_InformationItem_RL_SetupRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_DPCH_InformationItem_RL_SetupRspTDD, DL_DPCH_InformationItem_RL_SetupRspTDD_sequence);

  return offset;
}
static int dissect_id_DL_DPCH_InformationItem_RL_SetupRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_DPCH_InformationItem_RL_SetupRspTDD(tvb, offset, actx, tree, hf_rnsap_id_DL_DPCH_InformationItem_RL_SetupRspTDD);
}


static const value_string rnsap_DL_DPCH_TimingAdjustment_vals[] = {
  {   0, "timing-advance" },
  {   1, "timing-delay" },
  { 0, NULL }
};


static int
dissect_rnsap_DL_DPCH_TimingAdjustment(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_id_DL_DPCH_TimingAdjustment(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_DPCH_TimingAdjustment(tvb, offset, actx, tree, hf_rnsap_id_DL_DPCH_TimingAdjustment);
}
static int dissect_id_Initial_DL_DPCH_TimingAdjustment(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_DPCH_TimingAdjustment(tvb, offset, actx, tree, hf_rnsap_id_Initial_DL_DPCH_TimingAdjustment);
}



static int
dissect_rnsap_DL_Power(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              -350, 150U, NULL, FALSE);

  return offset;
}
static int dissect_id_DLReferencePower(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Power(tvb, offset, actx, tree, hf_rnsap_id_DLReferencePower);
}
static int dissect_id_CCTrCH_Maximum_DL_Power_RL_SetupRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Power(tvb, offset, actx, tree, hf_rnsap_id_CCTrCH_Maximum_DL_Power_RL_SetupRspTDD);
}
static int dissect_id_CCTrCH_Minimum_DL_Power_RL_SetupRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Power(tvb, offset, actx, tree, hf_rnsap_id_CCTrCH_Minimum_DL_Power_RL_SetupRspTDD);
}
static int dissect_id_CCTrCH_Maximum_DL_Power_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Power(tvb, offset, actx, tree, hf_rnsap_id_CCTrCH_Maximum_DL_Power_RL_AdditionRspTDD);
}
static int dissect_id_CCTrCH_Minimum_DL_Power_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Power(tvb, offset, actx, tree, hf_rnsap_id_CCTrCH_Minimum_DL_Power_RL_AdditionRspTDD);
}
static int dissect_id_CCTrCH_Maximum_DL_Power_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Power(tvb, offset, actx, tree, hf_rnsap_id_CCTrCH_Maximum_DL_Power_RL_ReconfReadyTDD);
}
static int dissect_id_CCTrCH_Minimum_DL_Power_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Power(tvb, offset, actx, tree, hf_rnsap_id_CCTrCH_Minimum_DL_Power_RL_ReconfReadyTDD);
}
static int dissect_id_Maximum_DL_Power_TimeslotLCR_InformationModifyItem_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Power(tvb, offset, actx, tree, hf_rnsap_id_Maximum_DL_Power_TimeslotLCR_InformationModifyItem_RL_ReconfReadyTDD);
}
static int dissect_id_Minimum_DL_Power_TimeslotLCR_InformationModifyItem_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Power(tvb, offset, actx, tree, hf_rnsap_id_Minimum_DL_Power_TimeslotLCR_InformationModifyItem_RL_ReconfReadyTDD);
}
static int dissect_id_Maximum_DL_Power_TimeslotLCR_InformationItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Power(tvb, offset, actx, tree, hf_rnsap_id_Maximum_DL_Power_TimeslotLCR_InformationItem);
}
static int dissect_id_Minimum_DL_Power_TimeslotLCR_InformationItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Power(tvb, offset, actx, tree, hf_rnsap_id_Minimum_DL_Power_TimeslotLCR_InformationItem);
}
static int dissect_dl_InitialTX_Power(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Power(tvb, offset, actx, tree, hf_rnsap_dl_InitialTX_Power);
}
static int dissect_maximumDLTxPower(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Power(tvb, offset, actx, tree, hf_rnsap_maximumDLTxPower);
}
static int dissect_minimumDLTxPower(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Power(tvb, offset, actx, tree, hf_rnsap_minimumDLTxPower);
}
static int dissect_cCTrCH_Maximum_DL_Power(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Power(tvb, offset, actx, tree, hf_rnsap_cCTrCH_Maximum_DL_Power);
}
static int dissect_cCTrCH_Minimum_DL_Power(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Power(tvb, offset, actx, tree, hf_rnsap_cCTrCH_Minimum_DL_Power);
}
static int dissect_maxPowerLCR(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Power(tvb, offset, actx, tree, hf_rnsap_maxPowerLCR);
}
static int dissect_minPowerLCR(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Power(tvb, offset, actx, tree, hf_rnsap_minPowerLCR);
}
static int dissect_dl_Reference_Power(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Power(tvb, offset, actx, tree, hf_rnsap_dl_Reference_Power);
}
static int dissect_initial_dl_tx_power(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Power(tvb, offset, actx, tree, hf_rnsap_initial_dl_tx_power);
}
static int dissect_dLReferencePower(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Power(tvb, offset, actx, tree, hf_rnsap_dLReferencePower);
}
static int dissect_common_DL_ReferencePowerInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Power(tvb, offset, actx, tree, hf_rnsap_common_DL_ReferencePowerInformation);
}


static const per_sequence_t DL_ReferencePowerInformationList_DL_PC_Rqst_sequence_of[1] = {
  { &hf_rnsap_DL_ReferencePowerInformationList_DL_PC_Rqst_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_DL_ReferencePowerInformationList_DL_PC_Rqst(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DL_ReferencePowerInformationList_DL_PC_Rqst, DL_ReferencePowerInformationList_DL_PC_Rqst_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_id_DLReferencePowerList_DL_PC_Rqst(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_ReferencePowerInformationList_DL_PC_Rqst(tvb, offset, actx, tree, hf_rnsap_id_DLReferencePowerList_DL_PC_Rqst);
}



static int
dissect_rnsap_RL_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 31U, NULL, FALSE);

  return offset;
}
static int dissect_id_HSPDSCH_RL_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_ID(tvb, offset, actx, tree, hf_rnsap_id_HSPDSCH_RL_ID);
}
static int dissect_id_PDSCH_RL_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_ID(tvb, offset, actx, tree, hf_rnsap_id_PDSCH_RL_ID);
}
static int dissect_rL_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_ID(tvb, offset, actx, tree, hf_rnsap_rL_ID);
}
static int dissect_e_DCH_Serving_RL_Id(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_ID(tvb, offset, actx, tree, hf_rnsap_e_DCH_Serving_RL_Id);
}


static const per_sequence_t DL_ReferencePowerInformation_DL_PC_Rqst_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_dl_Reference_Power, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_Power },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_ReferencePowerInformation_DL_PC_Rqst(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_ReferencePowerInformation_DL_PC_Rqst, DL_ReferencePowerInformation_DL_PC_Rqst_sequence);

  return offset;
}
static int dissect_id_DL_ReferencePowerInformation_DL_PC_Rqst(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_ReferencePowerInformation_DL_PC_Rqst(tvb, offset, actx, tree, hf_rnsap_id_DL_ReferencePowerInformation_DL_PC_Rqst);
}


static const value_string rnsap_DPC_Mode_vals[] = {
  {   0, "mode0" },
  {   1, "mode1" },
  { 0, NULL }
};


static int
dissect_rnsap_DPC_Mode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_id_DPC_Mode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DPC_Mode(tvb, offset, actx, tree, hf_rnsap_id_DPC_Mode);
}



static int
dissect_rnsap_DRXCycleLengthCoefficient(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              3U, 9U, NULL, FALSE);

  return offset;
}
static int dissect_id_DRXCycleLengthCoefficient(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DRXCycleLengthCoefficient(tvb, offset, actx, tree, hf_rnsap_id_DRXCycleLengthCoefficient);
}


static const per_sequence_t RL_Unsuccessful_InformationRespList_DM_Fail_Ind_sequence_of[1] = {
  { &hf_rnsap_RL_Unsuccessful_InformationRespList_DM_Fail_Ind_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_RL_Unsuccessful_InformationRespList_DM_Fail_Ind(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_Unsuccessful_InformationRespList_DM_Fail_Ind, RL_Unsuccessful_InformationRespList_DM_Fail_Ind_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_rL_unsuccessful_InformationRespList_DM_Fail_Ind(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Unsuccessful_InformationRespList_DM_Fail_Ind(tvb, offset, actx, tree, hf_rnsap_rL_unsuccessful_InformationRespList_DM_Fail_Ind);
}


static const per_sequence_t RL_DM_Fail_Ind_sequence[] = {
  { &hf_rnsap_rL_unsuccessful_InformationRespList_DM_Fail_Ind, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_Unsuccessful_InformationRespList_DM_Fail_Ind },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_DM_Fail_Ind(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_DM_Fail_Ind, RL_DM_Fail_Ind_sequence);

  return offset;
}
static int dissect_rL4(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_DM_Fail_Ind(tvb, offset, actx, tree, hf_rnsap_rL4);
}
static int dissect_allRL4(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_DM_Fail_Ind(tvb, offset, actx, tree, hf_rnsap_allRL4);
}


static const per_sequence_t RL_Set_Unsuccessful_InformationRespList_DM_Fail_Ind_sequence_of[1] = {
  { &hf_rnsap_RL_Set_Unsuccessful_InformationRespList_DM_Fail_Ind_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_RL_Set_Unsuccessful_InformationRespList_DM_Fail_Ind(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_Set_Unsuccessful_InformationRespList_DM_Fail_Ind, RL_Set_Unsuccessful_InformationRespList_DM_Fail_Ind_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_rL_Set_unsuccessful_InformationRespList_DM_Fail_Ind(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_Unsuccessful_InformationRespList_DM_Fail_Ind(tvb, offset, actx, tree, hf_rnsap_rL_Set_unsuccessful_InformationRespList_DM_Fail_Ind);
}


static const per_sequence_t RL_Set_DM_Fail_Ind_sequence[] = {
  { &hf_rnsap_rL_Set_unsuccessful_InformationRespList_DM_Fail_Ind, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_Set_Unsuccessful_InformationRespList_DM_Fail_Ind },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Set_DM_Fail_Ind(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Set_DM_Fail_Ind, RL_Set_DM_Fail_Ind_sequence);

  return offset;
}
static int dissect_rLS4(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_DM_Fail_Ind(tvb, offset, actx, tree, hf_rnsap_rLS4);
}
static int dissect_allRLS4(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_DM_Fail_Ind(tvb, offset, actx, tree, hf_rnsap_allRLS4);
}


static const value_string rnsap_DedicatedMeasurementObjectType_DM_Fail_Ind_vals[] = {
  {   0, "rL" },
  {   1, "rLS" },
  {   2, "allRL" },
  {   3, "allRLS" },
  { 0, NULL }
};

static const per_choice_t DedicatedMeasurementObjectType_DM_Fail_Ind_choice[] = {
  {   0, &hf_rnsap_rL4           , ASN1_EXTENSION_ROOT    , dissect_rnsap_RL_DM_Fail_Ind },
  {   1, &hf_rnsap_rLS4          , ASN1_EXTENSION_ROOT    , dissect_rnsap_RL_Set_DM_Fail_Ind },
  {   2, &hf_rnsap_allRL4        , ASN1_EXTENSION_ROOT    , dissect_rnsap_RL_DM_Fail_Ind },
  {   3, &hf_rnsap_allRLS4       , ASN1_EXTENSION_ROOT    , dissect_rnsap_RL_Set_DM_Fail_Ind },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_DedicatedMeasurementObjectType_DM_Fail_Ind(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_DedicatedMeasurementObjectType_DM_Fail_Ind, DedicatedMeasurementObjectType_DM_Fail_Ind_choice,
                                 NULL);

  return offset;
}
static int dissect_id_DedicatedMeasurementObjectType_DM_Fail_Ind(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DedicatedMeasurementObjectType_DM_Fail_Ind(tvb, offset, actx, tree, hf_rnsap_id_DedicatedMeasurementObjectType_DM_Fail_Ind);
}


static const per_sequence_t RL_Unsuccessful_InformationRespList_DM_Fail_sequence_of[1] = {
  { &hf_rnsap_RL_Unsuccessful_InformationRespList_DM_Fail_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_RL_Unsuccessful_InformationRespList_DM_Fail(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_Unsuccessful_InformationRespList_DM_Fail, RL_Unsuccessful_InformationRespList_DM_Fail_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_rL_unsuccessful_InformationRespList_DM_Fail(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Unsuccessful_InformationRespList_DM_Fail(tvb, offset, actx, tree, hf_rnsap_rL_unsuccessful_InformationRespList_DM_Fail);
}


static const per_sequence_t RL_Successful_InformationRespList_DM_Fail_sequence_of[1] = {
  { &hf_rnsap_RL_Successful_InformationRespList_DM_Fail_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_RL_Successful_InformationRespList_DM_Fail(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_Successful_InformationRespList_DM_Fail, RL_Successful_InformationRespList_DM_Fail_sequence_of,
                                                  1, 15);

  return offset;
}
static int dissect_rL_successful_InformationRespList_DM_Fail(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Successful_InformationRespList_DM_Fail(tvb, offset, actx, tree, hf_rnsap_rL_successful_InformationRespList_DM_Fail);
}


static const per_sequence_t RL_DM_Fail_sequence[] = {
  { &hf_rnsap_rL_unsuccessful_InformationRespList_DM_Fail, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_Unsuccessful_InformationRespList_DM_Fail },
  { &hf_rnsap_rL_successful_InformationRespList_DM_Fail, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_RL_Successful_InformationRespList_DM_Fail },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_DM_Fail(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_DM_Fail, RL_DM_Fail_sequence);

  return offset;
}
static int dissect_rL3(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_DM_Fail(tvb, offset, actx, tree, hf_rnsap_rL3);
}
static int dissect_allRL2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_DM_Fail(tvb, offset, actx, tree, hf_rnsap_allRL2);
}


static const per_sequence_t RL_Set_Unsuccessful_InformationRespList_DM_Fail_sequence_of[1] = {
  { &hf_rnsap_RL_Set_Unsuccessful_InformationRespList_DM_Fail_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_RL_Set_Unsuccessful_InformationRespList_DM_Fail(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_Set_Unsuccessful_InformationRespList_DM_Fail, RL_Set_Unsuccessful_InformationRespList_DM_Fail_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_rL_Set_unsuccessful_InformationRespList_DM_Fail(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_Unsuccessful_InformationRespList_DM_Fail(tvb, offset, actx, tree, hf_rnsap_rL_Set_unsuccessful_InformationRespList_DM_Fail);
}


static const per_sequence_t RL_Set_Successful_InformationRespList_DM_Fail_sequence_of[1] = {
  { &hf_rnsap_RL_Set_Successful_InformationRespList_DM_Fail_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_RL_Set_Successful_InformationRespList_DM_Fail(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_Set_Successful_InformationRespList_DM_Fail, RL_Set_Successful_InformationRespList_DM_Fail_sequence_of,
                                                  1, 15);

  return offset;
}
static int dissect_rL_Set_successful_InformationRespList_DM_Fail(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_Successful_InformationRespList_DM_Fail(tvb, offset, actx, tree, hf_rnsap_rL_Set_successful_InformationRespList_DM_Fail);
}


static const per_sequence_t RL_Set_DM_Fail_sequence[] = {
  { &hf_rnsap_rL_Set_unsuccessful_InformationRespList_DM_Fail, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_Set_Unsuccessful_InformationRespList_DM_Fail },
  { &hf_rnsap_rL_Set_successful_InformationRespList_DM_Fail, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_RL_Set_Successful_InformationRespList_DM_Fail },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Set_DM_Fail(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Set_DM_Fail, RL_Set_DM_Fail_sequence);

  return offset;
}
static int dissect_rLS2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_DM_Fail(tvb, offset, actx, tree, hf_rnsap_rLS2);
}
static int dissect_allRLS2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_DM_Fail(tvb, offset, actx, tree, hf_rnsap_allRLS2);
}


static const value_string rnsap_DedicatedMeasurementObjectType_DM_Fail_vals[] = {
  {   0, "rL" },
  {   1, "rLS" },
  {   2, "allRL" },
  {   3, "allRLS" },
  { 0, NULL }
};

static const per_choice_t DedicatedMeasurementObjectType_DM_Fail_choice[] = {
  {   0, &hf_rnsap_rL3           , ASN1_EXTENSION_ROOT    , dissect_rnsap_RL_DM_Fail },
  {   1, &hf_rnsap_rLS2          , ASN1_EXTENSION_ROOT    , dissect_rnsap_RL_Set_DM_Fail },
  {   2, &hf_rnsap_allRL2        , ASN1_EXTENSION_ROOT    , dissect_rnsap_RL_DM_Fail },
  {   3, &hf_rnsap_allRLS2       , ASN1_EXTENSION_ROOT    , dissect_rnsap_RL_Set_DM_Fail },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_DedicatedMeasurementObjectType_DM_Fail(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_DedicatedMeasurementObjectType_DM_Fail, DedicatedMeasurementObjectType_DM_Fail_choice,
                                 NULL);

  return offset;
}
static int dissect_id_DedicatedMeasurementObjectType_DM_Fail(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DedicatedMeasurementObjectType_DM_Fail(tvb, offset, actx, tree, hf_rnsap_id_DedicatedMeasurementObjectType_DM_Fail);
}


static const per_sequence_t RL_InformationList_DM_Rprt_sequence_of[1] = {
  { &hf_rnsap_RL_InformationList_DM_Rprt_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_RL_InformationList_DM_Rprt(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_InformationList_DM_Rprt, RL_InformationList_DM_Rprt_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_rL_InformationList_DM_Rprt(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationList_DM_Rprt(tvb, offset, actx, tree, hf_rnsap_rL_InformationList_DM_Rprt);
}


static const per_sequence_t RL_DM_Rprt_sequence[] = {
  { &hf_rnsap_rL_InformationList_DM_Rprt, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_InformationList_DM_Rprt },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_DM_Rprt(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_DM_Rprt, RL_DM_Rprt_sequence);

  return offset;
}
static int dissect_rLs1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_DM_Rprt(tvb, offset, actx, tree, hf_rnsap_rLs1);
}
static int dissect_allRL3(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_DM_Rprt(tvb, offset, actx, tree, hf_rnsap_allRL3);
}


static const per_sequence_t RL_Set_InformationList_DM_Rprt_sequence_of[1] = {
  { &hf_rnsap_RL_Set_InformationList_DM_Rprt_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_RL_Set_InformationList_DM_Rprt(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_Set_InformationList_DM_Rprt, RL_Set_InformationList_DM_Rprt_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_rL_Set_InformationList_DM_Rprt(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_InformationList_DM_Rprt(tvb, offset, actx, tree, hf_rnsap_rL_Set_InformationList_DM_Rprt);
}


static const per_sequence_t RL_Set_DM_Rprt_sequence[] = {
  { &hf_rnsap_rL_Set_InformationList_DM_Rprt, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_Set_InformationList_DM_Rprt },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Set_DM_Rprt(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Set_DM_Rprt, RL_Set_DM_Rprt_sequence);

  return offset;
}
static int dissect_rLS3(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_DM_Rprt(tvb, offset, actx, tree, hf_rnsap_rLS3);
}
static int dissect_allRLS3(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_DM_Rprt(tvb, offset, actx, tree, hf_rnsap_allRLS3);
}


static const value_string rnsap_DedicatedMeasurementObjectType_DM_Rprt_vals[] = {
  {   0, "rLs" },
  {   1, "rLS" },
  {   2, "allRL" },
  {   3, "allRLS" },
  { 0, NULL }
};

static const per_choice_t DedicatedMeasurementObjectType_DM_Rprt_choice[] = {
  {   0, &hf_rnsap_rLs1          , ASN1_EXTENSION_ROOT    , dissect_rnsap_RL_DM_Rprt },
  {   1, &hf_rnsap_rLS3          , ASN1_EXTENSION_ROOT    , dissect_rnsap_RL_Set_DM_Rprt },
  {   2, &hf_rnsap_allRL3        , ASN1_EXTENSION_ROOT    , dissect_rnsap_RL_DM_Rprt },
  {   3, &hf_rnsap_allRLS3       , ASN1_EXTENSION_ROOT    , dissect_rnsap_RL_Set_DM_Rprt },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_DedicatedMeasurementObjectType_DM_Rprt(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_DedicatedMeasurementObjectType_DM_Rprt, DedicatedMeasurementObjectType_DM_Rprt_choice,
                                 NULL);

  return offset;
}
static int dissect_id_DedicatedMeasurementObjectType_DM_Rprt(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DedicatedMeasurementObjectType_DM_Rprt(tvb, offset, actx, tree, hf_rnsap_id_DedicatedMeasurementObjectType_DM_Rprt);
}


static const per_sequence_t RL_InformationList_DM_Rqst_sequence_of[1] = {
  { &hf_rnsap_RL_InformationList_DM_Rqst_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_RL_InformationList_DM_Rqst(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_InformationList_DM_Rqst, RL_InformationList_DM_Rqst_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_rL_InformationList_DM_Rqst(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationList_DM_Rqst(tvb, offset, actx, tree, hf_rnsap_rL_InformationList_DM_Rqst);
}


static const per_sequence_t RL_DM_Rqst_sequence[] = {
  { &hf_rnsap_rL_InformationList_DM_Rqst, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_InformationList_DM_Rqst },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_DM_Rqst(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_DM_Rqst, RL_DM_Rqst_sequence);

  return offset;
}
static int dissect_rL2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_DM_Rqst(tvb, offset, actx, tree, hf_rnsap_rL2);
}


static const per_sequence_t RL_Set_InformationList_DM_Rqst_sequence_of[1] = {
  { &hf_rnsap_RL_Set_InformationList_DM_Rqst_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_RL_Set_InformationList_DM_Rqst(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_Set_InformationList_DM_Rqst, RL_Set_InformationList_DM_Rqst_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_rL_Set_InformationList_DM_Rqst(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_InformationList_DM_Rqst(tvb, offset, actx, tree, hf_rnsap_rL_Set_InformationList_DM_Rqst);
}


static const per_sequence_t RL_Set_DM_Rqst_sequence[] = {
  { &hf_rnsap_rL_Set_InformationList_DM_Rqst, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_Set_InformationList_DM_Rqst },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Set_DM_Rqst(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Set_DM_Rqst, RL_Set_DM_Rqst_sequence);

  return offset;
}
static int dissect_rLS(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_DM_Rqst(tvb, offset, actx, tree, hf_rnsap_rLS);
}



static int
dissect_rnsap_All_RL_DM_Rqst(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_allRL(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_All_RL_DM_Rqst(tvb, offset, actx, tree, hf_rnsap_allRL);
}



static int
dissect_rnsap_All_RL_Set_DM_Rqst(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_allRLS(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_All_RL_Set_DM_Rqst(tvb, offset, actx, tree, hf_rnsap_allRLS);
}


static const value_string rnsap_DedicatedMeasurementObjectType_DM_Rqst_vals[] = {
  {   0, "rL" },
  {   1, "rLS" },
  {   2, "allRL" },
  {   3, "allRLS" },
  { 0, NULL }
};

static const per_choice_t DedicatedMeasurementObjectType_DM_Rqst_choice[] = {
  {   0, &hf_rnsap_rL2           , ASN1_EXTENSION_ROOT    , dissect_rnsap_RL_DM_Rqst },
  {   1, &hf_rnsap_rLS           , ASN1_EXTENSION_ROOT    , dissect_rnsap_RL_Set_DM_Rqst },
  {   2, &hf_rnsap_allRL         , ASN1_EXTENSION_ROOT    , dissect_rnsap_All_RL_DM_Rqst },
  {   3, &hf_rnsap_allRLS        , ASN1_EXTENSION_ROOT    , dissect_rnsap_All_RL_Set_DM_Rqst },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_DedicatedMeasurementObjectType_DM_Rqst(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_DedicatedMeasurementObjectType_DM_Rqst, DedicatedMeasurementObjectType_DM_Rqst_choice,
                                 NULL);

  return offset;
}
static int dissect_id_DedicatedMeasurementObjectType_DM_Rqst(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DedicatedMeasurementObjectType_DM_Rqst(tvb, offset, actx, tree, hf_rnsap_id_DedicatedMeasurementObjectType_DM_Rqst);
}


static const per_sequence_t RL_InformationList_DM_Rsp_sequence_of[1] = {
  { &hf_rnsap_RL_InformationList_DM_Rsp_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_RL_InformationList_DM_Rsp(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_InformationList_DM_Rsp, RL_InformationList_DM_Rsp_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_rL_InformationList_DM_Rsp(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationList_DM_Rsp(tvb, offset, actx, tree, hf_rnsap_rL_InformationList_DM_Rsp);
}


static const per_sequence_t RL_DM_Rsp_sequence[] = {
  { &hf_rnsap_rL_InformationList_DM_Rsp, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_InformationList_DM_Rsp },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_DM_Rsp(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_DM_Rsp, RL_DM_Rsp_sequence);

  return offset;
}
static int dissect_rLs(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_DM_Rsp(tvb, offset, actx, tree, hf_rnsap_rLs);
}
static int dissect_allRL1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_DM_Rsp(tvb, offset, actx, tree, hf_rnsap_allRL1);
}


static const per_sequence_t RL_Set_InformationList_DM_Rsp_sequence_of[1] = {
  { &hf_rnsap_RL_Set_InformationList_DM_Rsp_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_RL_Set_InformationList_DM_Rsp(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_Set_InformationList_DM_Rsp, RL_Set_InformationList_DM_Rsp_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_rL_Set_InformationList_DM_Rsp(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_InformationList_DM_Rsp(tvb, offset, actx, tree, hf_rnsap_rL_Set_InformationList_DM_Rsp);
}


static const per_sequence_t RL_Set_DM_Rsp_sequence[] = {
  { &hf_rnsap_rL_Set_InformationList_DM_Rsp, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_Set_InformationList_DM_Rsp },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Set_DM_Rsp(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Set_DM_Rsp, RL_Set_DM_Rsp_sequence);

  return offset;
}
static int dissect_rLS1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_DM_Rsp(tvb, offset, actx, tree, hf_rnsap_rLS1);
}
static int dissect_allRLS1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_DM_Rsp(tvb, offset, actx, tree, hf_rnsap_allRLS1);
}


static const value_string rnsap_DedicatedMeasurementObjectType_DM_Rsp_vals[] = {
  {   0, "rLs" },
  {   1, "rLS" },
  {   2, "allRL" },
  {   3, "allRLS" },
  { 0, NULL }
};

static const per_choice_t DedicatedMeasurementObjectType_DM_Rsp_choice[] = {
  {   0, &hf_rnsap_rLs           , ASN1_EXTENSION_ROOT    , dissect_rnsap_RL_DM_Rsp },
  {   1, &hf_rnsap_rLS1          , ASN1_EXTENSION_ROOT    , dissect_rnsap_RL_Set_DM_Rsp },
  {   2, &hf_rnsap_allRL1        , ASN1_EXTENSION_ROOT    , dissect_rnsap_RL_DM_Rsp },
  {   3, &hf_rnsap_allRLS1       , ASN1_EXTENSION_ROOT    , dissect_rnsap_RL_Set_DM_Rsp },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_DedicatedMeasurementObjectType_DM_Rsp(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_DedicatedMeasurementObjectType_DM_Rsp, DedicatedMeasurementObjectType_DM_Rsp_choice,
                                 NULL);

  return offset;
}
static int dissect_id_DedicatedMeasurementObjectType_DM_Rsp(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DedicatedMeasurementObjectType_DM_Rsp(tvb, offset, actx, tree, hf_rnsap_id_DedicatedMeasurementObjectType_DM_Rsp);
}


static const value_string rnsap_DedicatedMeasurementType_vals[] = {
  {   0, "sir" },
  {   1, "sir-error" },
  {   2, "transmitted-code-power" },
  {   3, "rSCP" },
  {   4, "rx-timing-deviation" },
  {   5, "round-trip-time" },
  {   6, "rx-timing-deviation-LCR" },
  {   7, "angle-Of-Arrival-LCR" },
  {   8, "hs-sich-quality" },
  { 0, NULL }
};


static int
dissect_rnsap_DedicatedMeasurementType(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, TRUE, 3, NULL);

  return offset;
}
static int dissect_id_DedicatedMeasurementType(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DedicatedMeasurementType(tvb, offset, actx, tree, hf_rnsap_id_DedicatedMeasurementType);
}



static int
dissect_rnsap_FACH_FlowControlInformation_CTCH_ResourceRspFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_fACH_FlowControlInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_FACH_FlowControlInformation_CTCH_ResourceRspFDD(tvb, offset, actx, tree, hf_rnsap_fACH_FlowControlInformation);
}


static const per_sequence_t FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspFDD_sequence[] = {
  { &hf_rnsap_fACH_FlowControlInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_FACH_FlowControlInformation_CTCH_ResourceRspFDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspFDD, FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspFDD_sequence);

  return offset;
}
static int dissect_id_FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspFDD(tvb, offset, actx, tree, hf_rnsap_id_FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspFDD);
}



static int
dissect_rnsap_FACH_FlowControlInformation_CTCH_ResourceRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_fACH_FlowControlInformation1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_FACH_FlowControlInformation_CTCH_ResourceRspTDD(tvb, offset, actx, tree, hf_rnsap_fACH_FlowControlInformation1);
}


static const per_sequence_t FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspTDD_sequence[] = {
  { &hf_rnsap_fACH_FlowControlInformation1, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_FACH_FlowControlInformation_CTCH_ResourceRspTDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspTDD, FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspTDD_sequence);

  return offset;
}
static int dissect_id_FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspTDD(tvb, offset, actx, tree, hf_rnsap_id_FACH_InfoForUESelectedS_CCPCH_CTCH_ResourceRspTDD);
}



static int
dissect_rnsap_Guaranteed_Rate(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              1U, 32U, NULL, FALSE);

  return offset;
}
static int dissect_guaranteed_UL_Rate(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Guaranteed_Rate(tvb, offset, actx, tree, hf_rnsap_guaranteed_UL_Rate);
}
static int dissect_guaranteed_DL_Rate(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Guaranteed_Rate(tvb, offset, actx, tree, hf_rnsap_guaranteed_DL_Rate);
}


static const per_sequence_t Guaranteed_Rate_Information_sequence[] = {
  { &hf_rnsap_guaranteed_UL_Rate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Guaranteed_Rate },
  { &hf_rnsap_guaranteed_DL_Rate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Guaranteed_Rate },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Guaranteed_Rate_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Guaranteed_Rate_Information, Guaranteed_Rate_Information_sequence);

  return offset;
}
static int dissect_id_Guaranteed_Rate_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Guaranteed_Rate_Information(tvb, offset, actx, tree, hf_rnsap_id_Guaranteed_Rate_Information);
}



static int
dissect_rnsap_IMSI(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       3, 8, NULL);

  return offset;
}
static int dissect_id_IMSI(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_IMSI(tvb, offset, actx, tree, hf_rnsap_id_IMSI);
}
static int dissect_imsi(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_IMSI(tvb, offset, actx, tree, hf_rnsap_imsi);
}



static int
dissect_rnsap_HCS_Prio(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 7U, NULL, FALSE);

  return offset;
}
static int dissect_id_HCS_Prio(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_HCS_Prio(tvb, offset, actx, tree, hf_rnsap_id_HCS_Prio);
}



static int
dissect_rnsap_L3_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
#line 84 "rnsap.cnf"

	tvbuff_t *parameter_tvb;

  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);


	if (!parameter_tvb)
		return offset;

	switch (ProcedureCode){

	case RNSAP_ID_DOWNLINKSIGNALLINGTRANSFER:
		actx->encoding =FALSE;
		dissect_umts_rrc_DL_DCCH_Message(parameter_tvb, 0,  actx, tree, hf_rnsap_L3_DL_DCCH_Message_PDU);
		actx->encoding =TRUE;
		break;
	case RNSAP_ID_UPLINKSIGNALLINGTRANSFER:
	default:
		break;
	}



  return offset;
}
static int dissect_id_L3_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_L3_Information(tvb, offset, actx, tree, hf_rnsap_id_L3_Information);
}



static int
dissect_rnsap_AdjustmentPeriod(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              1U, 256U, NULL, FALSE);

  return offset;
}
static int dissect_id_AdjustmentPeriod(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_AdjustmentPeriod(tvb, offset, actx, tree, hf_rnsap_id_AdjustmentPeriod);
}
static int dissect_adjustmentPeriod(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_AdjustmentPeriod(tvb, offset, actx, tree, hf_rnsap_adjustmentPeriod);
}



static int
dissect_rnsap_MaxAdjustmentStep(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              1U, 10U, NULL, FALSE);

  return offset;
}
static int dissect_id_MaxAdjustmentStep(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MaxAdjustmentStep(tvb, offset, actx, tree, hf_rnsap_id_MaxAdjustmentStep);
}
static int dissect_maxAdjustmentStep(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MaxAdjustmentStep(tvb, offset, actx, tree, hf_rnsap_maxAdjustmentStep);
}


static const value_string rnsap_MeasurementFilterCoefficient_vals[] = {
  {   0, "k0" },
  {   1, "k1" },
  {   2, "k2" },
  {   3, "k3" },
  {   4, "k4" },
  {   5, "k5" },
  {   6, "k6" },
  {   7, "k7" },
  {   8, "k8" },
  {   9, "k9" },
  {  10, "k11" },
  {  11, "k13" },
  {  12, "k15" },
  {  13, "k17" },
  {  14, "k19" },
  { 0, NULL }
};


static int
dissect_rnsap_MeasurementFilterCoefficient(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     15, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_id_MeasurementFilterCoefficient(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MeasurementFilterCoefficient(tvb, offset, actx, tree, hf_rnsap_id_MeasurementFilterCoefficient);
}



static int
dissect_rnsap_RepetitionNumber1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              1U, 256U, NULL, FALSE);

  return offset;
}
static int dissect_repetitionNumber1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RepetitionNumber1(tvb, offset, actx, tree, hf_rnsap_repetitionNumber1);
}


static const per_sequence_t MessageStructure_item_sequence[] = {
  { &hf_rnsap_iE_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_ID },
  { &hf_rnsap_repetitionNumber1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_RepetitionNumber1 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_MessageStructure_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_MessageStructure_item, MessageStructure_item_sequence);

  return offset;
}
static int dissect_MessageStructure_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MessageStructure_item(tvb, offset, actx, tree, hf_rnsap_MessageStructure_item);
}


static const per_sequence_t MessageStructure_sequence_of[1] = {
  { &hf_rnsap_MessageStructure_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_MessageStructure_item },
};

static int
dissect_rnsap_MessageStructure(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_MessageStructure, MessageStructure_sequence_of,
                                                  1, 256);

  return offset;
}
static int dissect_id_MessageStructure(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MessageStructure(tvb, offset, actx, tree, hf_rnsap_id_MessageStructure);
}



static int
dissect_rnsap_MeasurementID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 1048575U, NULL, FALSE);

  return offset;
}
static int dissect_id_MeasurementID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MeasurementID(tvb, offset, actx, tree, hf_rnsap_id_MeasurementID);
}



static int
dissect_rnsap_Neighbouring_GSM_CellInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_id_Neighbouring_GSM_CellInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Neighbouring_GSM_CellInformation(tvb, offset, actx, tree, hf_rnsap_id_Neighbouring_GSM_CellInformation);
}
static int dissect_neighbouring_GSM_CellInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Neighbouring_GSM_CellInformation(tvb, offset, actx, tree, hf_rnsap_neighbouring_GSM_CellInformation);
}



static int
dissect_rnsap_RNC_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 4095U, NULL, FALSE);

  return offset;
}
static int dissect_id_RNC_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RNC_ID(tvb, offset, actx, tree, hf_rnsap_id_RNC_ID);
}
static int dissect_id_SRNC_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RNC_ID(tvb, offset, actx, tree, hf_rnsap_id_SRNC_ID);
}
static int dissect_rNC_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RNC_ID(tvb, offset, actx, tree, hf_rnsap_rNC_ID);
}
static int dissect_srnc_id(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RNC_ID(tvb, offset, actx, tree, hf_rnsap_srnc_id);
}



static int
dissect_rnsap_UARFCN(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 16383U, NULL, TRUE);

  return offset;
}
static int dissect_uL_UARFCN(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UARFCN(tvb, offset, actx, tree, hf_rnsap_uL_UARFCN);
}
static int dissect_dL_UARFCN(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UARFCN(tvb, offset, actx, tree, hf_rnsap_dL_UARFCN);
}
static int dissect_uARFCNforNt(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UARFCN(tvb, offset, actx, tree, hf_rnsap_uARFCNforNt);
}
static int dissect_preferredFrequencyLayer(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UARFCN(tvb, offset, actx, tree, hf_rnsap_preferredFrequencyLayer);
}
static int dissect_uARFCNforNu(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UARFCN(tvb, offset, actx, tree, hf_rnsap_uARFCNforNu);
}
static int dissect_uARFCNforNd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UARFCN(tvb, offset, actx, tree, hf_rnsap_uARFCNforNd);
}
static int dissect_uARFCN(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UARFCN(tvb, offset, actx, tree, hf_rnsap_uARFCN);
}
static int dissect_defaultPreferredFrequency(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UARFCN(tvb, offset, actx, tree, hf_rnsap_defaultPreferredFrequency);
}



static int
dissect_rnsap_FrameOffset(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 255U, NULL, FALSE);

  return offset;
}
static int dissect_frameOffset(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_FrameOffset(tvb, offset, actx, tree, hf_rnsap_frameOffset);
}



static int
dissect_rnsap_PrimaryScramblingCode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 511U, NULL, FALSE);

  return offset;
}
static int dissect_primaryScramblingCode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PrimaryScramblingCode(tvb, offset, actx, tree, hf_rnsap_primaryScramblingCode);
}



static int
dissect_rnsap_PrimaryCPICH_Power(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              -100, 500U, NULL, FALSE);

  return offset;
}
static int dissect_primaryCPICH_Power(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PrimaryCPICH_Power(tvb, offset, actx, tree, hf_rnsap_primaryCPICH_Power);
}



static int
dissect_rnsap_CellIndividualOffset(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              -20, 20U, NULL, FALSE);

  return offset;
}
static int dissect_cellIndividualOffset(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CellIndividualOffset(tvb, offset, actx, tree, hf_rnsap_cellIndividualOffset);
}


static const value_string rnsap_TxDiversityIndicator_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_rnsap_TxDiversityIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_txDiversityIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TxDiversityIndicator(tvb, offset, actx, tree, hf_rnsap_txDiversityIndicator);
}


static const value_string rnsap_STTD_SupportIndicator_vals[] = {
  {   0, "sTTD-Supported" },
  {   1, "sTTD-not-Supported" },
  { 0, NULL }
};


static int
dissect_rnsap_STTD_SupportIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_id_STTD_SupportIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_STTD_SupportIndicator(tvb, offset, actx, tree, hf_rnsap_id_STTD_SupportIndicator);
}
static int dissect_sTTD_SupportIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_STTD_SupportIndicator(tvb, offset, actx, tree, hf_rnsap_sTTD_SupportIndicator);
}


static const value_string rnsap_ClosedLoopMode1_SupportIndicator_vals[] = {
  {   0, "closedLoop-Mode1-Supported" },
  {   1, "closedLoop-Mode1-not-Supported" },
  { 0, NULL }
};


static int
dissect_rnsap_ClosedLoopMode1_SupportIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_id_ClosedLoopMode1_SupportIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ClosedLoopMode1_SupportIndicator(tvb, offset, actx, tree, hf_rnsap_id_ClosedLoopMode1_SupportIndicator);
}
static int dissect_closedLoopMode1_SupportIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ClosedLoopMode1_SupportIndicator(tvb, offset, actx, tree, hf_rnsap_closedLoopMode1_SupportIndicator);
}


static const per_sequence_t Neighbouring_FDD_CellInformationItem_sequence[] = {
  { &hf_rnsap_c_ID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_C_ID },
  { &hf_rnsap_uARFCNforNu   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UARFCN },
  { &hf_rnsap_uARFCNforNd   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UARFCN },
  { &hf_rnsap_frameOffset   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_FrameOffset },
  { &hf_rnsap_primaryScramblingCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PrimaryScramblingCode },
  { &hf_rnsap_primaryCPICH_Power, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_PrimaryCPICH_Power },
  { &hf_rnsap_cellIndividualOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CellIndividualOffset },
  { &hf_rnsap_txDiversityIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TxDiversityIndicator },
  { &hf_rnsap_sTTD_SupportIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_STTD_SupportIndicator },
  { &hf_rnsap_closedLoopMode1_SupportIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ClosedLoopMode1_SupportIndicator },
  { &hf_rnsap_not_used_closedLoopMode2_SupportIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_NULL },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Neighbouring_FDD_CellInformationItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Neighbouring_FDD_CellInformationItem, Neighbouring_FDD_CellInformationItem_sequence);

  return offset;
}
static int dissect_Neighbouring_FDD_CellInformation_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Neighbouring_FDD_CellInformationItem(tvb, offset, actx, tree, hf_rnsap_Neighbouring_FDD_CellInformation_item);
}


static const per_sequence_t Neighbouring_FDD_CellInformation_sequence_of[1] = {
  { &hf_rnsap_Neighbouring_FDD_CellInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Neighbouring_FDD_CellInformationItem },
};

static int
dissect_rnsap_Neighbouring_FDD_CellInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Neighbouring_FDD_CellInformation, Neighbouring_FDD_CellInformation_sequence_of,
                                                  1, 256);

  return offset;
}
static int dissect_neighbouring_FDD_CellInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Neighbouring_FDD_CellInformation(tvb, offset, actx, tree, hf_rnsap_neighbouring_FDD_CellInformation);
}



static int
dissect_rnsap_CellParameterID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 127U, NULL, TRUE);

  return offset;
}
static int dissect_cellParameterID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CellParameterID(tvb, offset, actx, tree, hf_rnsap_cellParameterID);
}



static int
dissect_rnsap_SyncCase(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              1U, 2U, NULL, TRUE);

  return offset;
}
static int dissect_syncCase(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_SyncCase(tvb, offset, actx, tree, hf_rnsap_syncCase);
}



static int
dissect_rnsap_SCH_TimeSlot(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 6U, NULL, FALSE);

  return offset;
}
static int dissect_sCH_TimeSlot(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_SCH_TimeSlot(tvb, offset, actx, tree, hf_rnsap_sCH_TimeSlot);
}


static const value_string rnsap_SCTD_Indicator_vals[] = {
  {   0, "active" },
  {   1, "inactive" },
  { 0, NULL }
};


static int
dissect_rnsap_SCTD_Indicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_sCTD_Indicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_SCTD_Indicator(tvb, offset, actx, tree, hf_rnsap_sCTD_Indicator);
}



static int
dissect_rnsap_DPCHConstantValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              -10, 10U, NULL, FALSE);

  return offset;
}
static int dissect_dPCHConstantValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DPCHConstantValue(tvb, offset, actx, tree, hf_rnsap_dPCHConstantValue);
}



static int
dissect_rnsap_PCCPCH_Power(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              -150, 400U, NULL, TRUE);

  return offset;
}
static int dissect_pCCPCH_Power(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PCCPCH_Power(tvb, offset, actx, tree, hf_rnsap_pCCPCH_Power);
}


static const per_sequence_t Neighbouring_TDD_CellInformationItem_sequence[] = {
  { &hf_rnsap_c_ID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_C_ID },
  { &hf_rnsap_uARFCNforNt   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UARFCN },
  { &hf_rnsap_frameOffset   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_FrameOffset },
  { &hf_rnsap_cellParameterID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CellParameterID },
  { &hf_rnsap_syncCase      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SyncCase },
  { &hf_rnsap_timeSlot      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TimeSlot },
  { &hf_rnsap_sCH_TimeSlot  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_SCH_TimeSlot },
  { &hf_rnsap_sCTD_Indicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SCTD_Indicator },
  { &hf_rnsap_cellIndividualOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CellIndividualOffset },
  { &hf_rnsap_dPCHConstantValue, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DPCHConstantValue },
  { &hf_rnsap_pCCPCH_Power  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_PCCPCH_Power },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Neighbouring_TDD_CellInformationItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Neighbouring_TDD_CellInformationItem, Neighbouring_TDD_CellInformationItem_sequence);

  return offset;
}
static int dissect_Neighbouring_TDD_CellInformation_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Neighbouring_TDD_CellInformationItem(tvb, offset, actx, tree, hf_rnsap_Neighbouring_TDD_CellInformation_item);
}


static const per_sequence_t Neighbouring_TDD_CellInformation_sequence_of[1] = {
  { &hf_rnsap_Neighbouring_TDD_CellInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Neighbouring_TDD_CellInformationItem },
};

static int
dissect_rnsap_Neighbouring_TDD_CellInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Neighbouring_TDD_CellInformation, Neighbouring_TDD_CellInformation_sequence_of,
                                                  1, 256);

  return offset;
}
static int dissect_neighbouring_TDD_CellInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Neighbouring_TDD_CellInformation(tvb, offset, actx, tree, hf_rnsap_neighbouring_TDD_CellInformation);
}


static const per_sequence_t Neighbouring_UMTS_CellInformationItem_sequence[] = {
  { &hf_rnsap_rNC_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RNC_ID },
  { &hf_rnsap_cN_PS_DomainIdentifier, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CN_PS_DomainIdentifier },
  { &hf_rnsap_cN_CS_DomainIdentifier, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CN_CS_DomainIdentifier },
  { &hf_rnsap_neighbouring_FDD_CellInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Neighbouring_FDD_CellInformation },
  { &hf_rnsap_neighbouring_TDD_CellInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Neighbouring_TDD_CellInformation },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Neighbouring_UMTS_CellInformationItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Neighbouring_UMTS_CellInformationItem, Neighbouring_UMTS_CellInformationItem_sequence);

  return offset;
}
static int dissect_id_Neighbouring_UMTS_CellInformationItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Neighbouring_UMTS_CellInformationItem(tvb, offset, actx, tree, hf_rnsap_id_Neighbouring_UMTS_CellInformationItem);
}



static int
dissect_rnsap_NRT_Load_Information_Value(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 3U, NULL, FALSE);

  return offset;
}
static int dissect_id_NRT_Load_Information_Value(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NRT_Load_Information_Value(tvb, offset, actx, tree, hf_rnsap_id_NRT_Load_Information_Value);
}



static int
dissect_rnsap_NRT_Load_Information_Value_IncrDecrThres(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 3U, NULL, FALSE);

  return offset;
}
static int dissect_id_NRT_Load_Information_Value_IncrDecrThres(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NRT_Load_Information_Value_IncrDecrThres(tvb, offset, actx, tree, hf_rnsap_id_NRT_Load_Information_Value_IncrDecrThres);
}



static int
dissect_rnsap_URA_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 65535U, NULL, FALSE);

  return offset;
}
static int dissect_id_Old_URA_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_URA_ID(tvb, offset, actx, tree, hf_rnsap_id_Old_URA_ID);
}
static int dissect_id_URA_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_URA_ID(tvb, offset, actx, tree, hf_rnsap_id_URA_ID);
}
static int dissect_uRA_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_URA_ID(tvb, offset, actx, tree, hf_rnsap_uRA_ID);
}
static int dissect_ura_id(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_URA_ID(tvb, offset, actx, tree, hf_rnsap_ura_id);
}


static const per_sequence_t URA_PagingRqst_sequence[] = {
  { &hf_rnsap_uRA_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_URA_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_URA_PagingRqst(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_URA_PagingRqst, URA_PagingRqst_sequence);

  return offset;
}
static int dissect_uRA(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_URA_PagingRqst(tvb, offset, actx, tree, hf_rnsap_uRA);
}


static const per_sequence_t Cell_PagingRqst_sequence[] = {
  { &hf_rnsap_c_ID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_C_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Cell_PagingRqst(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Cell_PagingRqst, Cell_PagingRqst_sequence);

  return offset;
}
static int dissect_cell(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Cell_PagingRqst(tvb, offset, actx, tree, hf_rnsap_cell);
}


static const value_string rnsap_PagingArea_PagingRqst_vals[] = {
  {   0, "uRA" },
  {   1, "cell" },
  { 0, NULL }
};

static const per_choice_t PagingArea_PagingRqst_choice[] = {
  {   0, &hf_rnsap_uRA           , ASN1_EXTENSION_ROOT    , dissect_rnsap_URA_PagingRqst },
  {   1, &hf_rnsap_cell          , ASN1_EXTENSION_ROOT    , dissect_rnsap_Cell_PagingRqst },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_PagingArea_PagingRqst(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_PagingArea_PagingRqst, PagingArea_PagingRqst_choice,
                                 NULL);

  return offset;
}
static int dissect_id_PagingArea_PagingRqst(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PagingArea_PagingRqst(tvb, offset, actx, tree, hf_rnsap_id_PagingArea_PagingRqst);
}


static const value_string rnsap_SchedulingPriorityIndicator_vals[] = {
  {   0, "lowest" },
  {  15, "highest" },
  { 0, NULL }
};


static int
dissect_rnsap_SchedulingPriorityIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 15U, NULL, FALSE);

  return offset;
}
static int dissect_schedulingPriorityIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_SchedulingPriorityIndicator(tvb, offset, actx, tree, hf_rnsap_schedulingPriorityIndicator);
}
static int dissect_dSCH_SchedulingPriority(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_SchedulingPriorityIndicator(tvb, offset, actx, tree, hf_rnsap_dSCH_SchedulingPriority);
}
static int dissect_fACH_SchedulingPriority(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_SchedulingPriorityIndicator(tvb, offset, actx, tree, hf_rnsap_fACH_SchedulingPriority);
}



static int
dissect_rnsap_MAC_c_sh_SDU_Length(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              1U, 5000U, NULL, FALSE);

  return offset;
}
static int dissect_MAC_c_sh_SDU_LengthList_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MAC_c_sh_SDU_Length(tvb, offset, actx, tree, hf_rnsap_MAC_c_sh_SDU_LengthList_item);
}


static const per_sequence_t MAC_c_sh_SDU_LengthList_sequence_of[1] = {
  { &hf_rnsap_MAC_c_sh_SDU_LengthList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_MAC_c_sh_SDU_Length },
};

static int
dissect_rnsap_MAC_c_sh_SDU_LengthList(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_MAC_c_sh_SDU_LengthList, MAC_c_sh_SDU_LengthList_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_mAC_c_sh_SDU_Lengths(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MAC_c_sh_SDU_LengthList(tvb, offset, actx, tree, hf_rnsap_mAC_c_sh_SDU_Lengths);
}


static const value_string rnsap_FACH_InitialWindowSize_vals[] = {
  { 255, "unlimited" },
  { 0, NULL }
};


static int
dissect_rnsap_FACH_InitialWindowSize(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 255U, NULL, FALSE);

  return offset;
}
static int dissect_fACH_InitialWindowSize(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_FACH_InitialWindowSize(tvb, offset, actx, tree, hf_rnsap_fACH_InitialWindowSize);
}


static const per_sequence_t FACH_FlowControlInformationItem_sequence[] = {
  { &hf_rnsap_fACH_SchedulingPriority, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SchedulingPriorityIndicator },
  { &hf_rnsap_mAC_c_sh_SDU_Lengths, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MAC_c_sh_SDU_LengthList },
  { &hf_rnsap_fACH_InitialWindowSize, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_FACH_InitialWindowSize },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_FACH_FlowControlInformationItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_FACH_FlowControlInformationItem, FACH_FlowControlInformationItem_sequence);

  return offset;
}
static int dissect_FACH_FlowControlInformation_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_FACH_FlowControlInformationItem(tvb, offset, actx, tree, hf_rnsap_FACH_FlowControlInformation_item);
}


static const per_sequence_t FACH_FlowControlInformation_sequence_of[1] = {
  { &hf_rnsap_FACH_FlowControlInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_FACH_FlowControlInformationItem },
};

static int
dissect_rnsap_FACH_FlowControlInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_FACH_FlowControlInformation, FACH_FlowControlInformation_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_id_FACH_FlowControlInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_FACH_FlowControlInformation(tvb, offset, actx, tree, hf_rnsap_id_FACH_FlowControlInformation);
}


static const value_string rnsap_PartialReportingIndicator_vals[] = {
  {   0, "partial-reporting-allowed" },
  { 0, NULL }
};


static int
dissect_rnsap_PartialReportingIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_id_PartialReportingIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PartialReportingIndicator(tvb, offset, actx, tree, hf_rnsap_id_PartialReportingIndicator);
}


static const value_string rnsap_Permanent_NAS_UE_Identity_vals[] = {
  {   0, "imsi" },
  { 0, NULL }
};

static const per_choice_t Permanent_NAS_UE_Identity_choice[] = {
  {   0, &hf_rnsap_imsi          , ASN1_EXTENSION_ROOT    , dissect_rnsap_IMSI },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_Permanent_NAS_UE_Identity(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_Permanent_NAS_UE_Identity, Permanent_NAS_UE_Identity_choice,
                                 NULL);

  return offset;
}
static int dissect_id_Permanent_NAS_UE_Identity(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Permanent_NAS_UE_Identity(tvb, offset, actx, tree, hf_rnsap_id_Permanent_NAS_UE_Identity);
}


static const value_string rnsap_PowerAdjustmentType_vals[] = {
  {   0, "none" },
  {   1, "common" },
  {   2, "individual" },
  { 0, NULL }
};


static int
dissect_rnsap_PowerAdjustmentType(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_id_PowerAdjustmentType(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PowerAdjustmentType(tvb, offset, actx, tree, hf_rnsap_id_PowerAdjustmentType);
}
static int dissect_powerAdjustmentType(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PowerAdjustmentType(tvb, offset, actx, tree, hf_rnsap_powerAdjustmentType);
}



static int
dissect_rnsap_RANAP_RelocationInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     NO_BOUND, NO_BOUND, FALSE, NULL);

  return offset;
}
static int dissect_id_RANAP_RelocationInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RANAP_RelocationInformation(tvb, offset, actx, tree, hf_rnsap_id_RANAP_RelocationInformation);
}



static int
dissect_rnsap_DL_CodeInformationList_PhyChReconfRqstFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_dl_CodeInformation3(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CodeInformationList_PhyChReconfRqstFDD(tvb, offset, actx, tree, hf_rnsap_dl_CodeInformation3);
}


static const per_sequence_t RL_Information_PhyChReconfRqstFDD_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_dl_CodeInformation3, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_CodeInformationList_PhyChReconfRqstFDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Information_PhyChReconfRqstFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Information_PhyChReconfRqstFDD, RL_Information_PhyChReconfRqstFDD_sequence);

  return offset;
}
static int dissect_id_RL_Information_PhyChReconfRqstFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Information_PhyChReconfRqstFDD(tvb, offset, actx, tree, hf_rnsap_id_RL_Information_PhyChReconfRqstFDD);
}



static int
dissect_rnsap_UL_CCTrCH_InformationList_PhyChReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_ul_CCTrCH_Information1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_CCTrCH_InformationList_PhyChReconfRqstTDD(tvb, offset, actx, tree, hf_rnsap_ul_CCTrCH_Information1);
}



static int
dissect_rnsap_DL_CCTrCH_InformationList_PhyChReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_dl_CCTrCH_Information1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CCTrCH_InformationList_PhyChReconfRqstTDD(tvb, offset, actx, tree, hf_rnsap_dl_CCTrCH_Information1);
}


static const per_sequence_t RL_Information_PhyChReconfRqstTDD_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_ul_CCTrCH_Information1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UL_CCTrCH_InformationList_PhyChReconfRqstTDD },
  { &hf_rnsap_dl_CCTrCH_Information1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_CCTrCH_InformationList_PhyChReconfRqstTDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Information_PhyChReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Information_PhyChReconfRqstTDD, RL_Information_PhyChReconfRqstTDD_sequence);

  return offset;
}
static int dissect_id_RL_Information_PhyChReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Information_PhyChReconfRqstTDD(tvb, offset, actx, tree, hf_rnsap_id_RL_Information_PhyChReconfRqstTDD);
}



static int
dissect_rnsap_ChipOffset(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 38399U, NULL, FALSE);

  return offset;
}
static int dissect_chipOffset(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ChipOffset(tvb, offset, actx, tree, hf_rnsap_chipOffset);
}


static const value_string rnsap_DiversityControlField_vals[] = {
  {   0, "may" },
  {   1, "must" },
  {   2, "must-not" },
  { 0, NULL }
};


static int
dissect_rnsap_DiversityControlField(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_diversityControlField(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DiversityControlField(tvb, offset, actx, tree, hf_rnsap_diversityControlField);
}



static int
dissect_rnsap_PrimaryCPICH_EcNo(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              -30, 30U, NULL, FALSE);

  return offset;
}
static int dissect_primaryCPICH_EcNo(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PrimaryCPICH_EcNo(tvb, offset, actx, tree, hf_rnsap_primaryCPICH_EcNo);
}


static const value_string rnsap_TransmitDiversityIndicator_vals[] = {
  {   0, "active" },
  {   1, "inactive" },
  { 0, NULL }
};


static int
dissect_rnsap_TransmitDiversityIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_transmitDiversityIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TransmitDiversityIndicator(tvb, offset, actx, tree, hf_rnsap_transmitDiversityIndicator);
}


static const per_sequence_t RL_Information_RL_AdditionRqstFDD_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_c_ID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_C_ID },
  { &hf_rnsap_frameOffset   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_FrameOffset },
  { &hf_rnsap_chipOffset    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ChipOffset },
  { &hf_rnsap_diversityControlField, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DiversityControlField },
  { &hf_rnsap_primaryCPICH_EcNo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_PrimaryCPICH_EcNo },
  { &hf_rnsap_not_Used_sSDT_CellID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_NULL },
  { &hf_rnsap_transmitDiversityIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransmitDiversityIndicator },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Information_RL_AdditionRqstFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Information_RL_AdditionRqstFDD, RL_Information_RL_AdditionRqstFDD_sequence);

  return offset;
}
static int dissect_id_RL_Information_RL_AdditionRqstFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Information_RL_AdditionRqstFDD(tvb, offset, actx, tree, hf_rnsap_id_RL_Information_RL_AdditionRqstFDD);
}



static int
dissect_rnsap_PrimaryCCPCH_RSCP(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 91U, NULL, FALSE);

  return offset;
}
static int dissect_id_PrimaryCCPCH_RSCP_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PrimaryCCPCH_RSCP(tvb, offset, actx, tree, hf_rnsap_id_PrimaryCCPCH_RSCP_RL_ReconfPrepTDD);
}
static int dissect_id_PrimCCPCH_RSCP_DL_PC_RqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PrimaryCCPCH_RSCP(tvb, offset, actx, tree, hf_rnsap_id_PrimCCPCH_RSCP_DL_PC_RqstTDD);
}
static int dissect_primaryCCPCH_RSCP(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PrimaryCCPCH_RSCP(tvb, offset, actx, tree, hf_rnsap_primaryCCPCH_RSCP);
}



static int
dissect_rnsap_DL_TimeslotISCP(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 91U, NULL, FALSE);

  return offset;
}
static int dissect_dL_TimeslotISCP(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_TimeslotISCP(tvb, offset, actx, tree, hf_rnsap_dL_TimeslotISCP);
}


static const per_sequence_t DL_TimeSlot_ISCP_InfoItem_sequence[] = {
  { &hf_rnsap_timeSlot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlot },
  { &hf_rnsap_dL_TimeslotISCP, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_TimeslotISCP },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_TimeSlot_ISCP_InfoItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_TimeSlot_ISCP_InfoItem, DL_TimeSlot_ISCP_InfoItem_sequence);

  return offset;
}
static int dissect_DL_TimeSlot_ISCP_Info_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_TimeSlot_ISCP_InfoItem(tvb, offset, actx, tree, hf_rnsap_DL_TimeSlot_ISCP_Info_item);
}


static const per_sequence_t DL_TimeSlot_ISCP_Info_sequence_of[1] = {
  { &hf_rnsap_DL_TimeSlot_ISCP_Info_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_TimeSlot_ISCP_InfoItem },
};

static int
dissect_rnsap_DL_TimeSlot_ISCP_Info(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DL_TimeSlot_ISCP_Info, DL_TimeSlot_ISCP_Info_sequence_of,
                                                  1, 15);

  return offset;
}
static int dissect_id_timeSlot_ISCP(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_TimeSlot_ISCP_Info(tvb, offset, actx, tree, hf_rnsap_id_timeSlot_ISCP);
}
static int dissect_id_DL_TimeSlot_ISCP_Info_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_TimeSlot_ISCP_Info(tvb, offset, actx, tree, hf_rnsap_id_DL_TimeSlot_ISCP_Info_RL_ReconfPrepTDD);
}
static int dissect_dL_TimeSlot_ISCP(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_TimeSlot_ISCP_Info(tvb, offset, actx, tree, hf_rnsap_dL_TimeSlot_ISCP);
}
static int dissect_dL_TimeSlot_ISCP_Info(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_TimeSlot_ISCP_Info(tvb, offset, actx, tree, hf_rnsap_dL_TimeSlot_ISCP_Info);
}


static const per_sequence_t RL_Information_RL_AdditionRqstTDD_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_c_ID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_C_ID },
  { &hf_rnsap_frameOffset   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_FrameOffset },
  { &hf_rnsap_diversityControlField, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DiversityControlField },
  { &hf_rnsap_primaryCCPCH_RSCP, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_PrimaryCCPCH_RSCP },
  { &hf_rnsap_dL_TimeSlot_ISCP_Info, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_TimeSlot_ISCP_Info },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Information_RL_AdditionRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Information_RL_AdditionRqstTDD, RL_Information_RL_AdditionRqstTDD_sequence);

  return offset;
}
static int dissect_id_RL_Information_RL_AdditionRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Information_RL_AdditionRqstTDD(tvb, offset, actx, tree, hf_rnsap_id_RL_Information_RL_AdditionRqstTDD);
}


static const per_sequence_t RL_Information_RL_DeletionRqst_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Information_RL_DeletionRqst(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Information_RL_DeletionRqst, RL_Information_RL_DeletionRqst_sequence);

  return offset;
}
static int dissect_id_RL_Information_RL_DeletionRqst(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Information_RL_DeletionRqst(tvb, offset, actx, tree, hf_rnsap_id_RL_Information_RL_DeletionRqst);
}


static const per_sequence_t RL_Information_RL_FailureInd_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_cause         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Cause },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Information_RL_FailureInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Information_RL_FailureInd, RL_Information_RL_FailureInd_sequence);

  return offset;
}
static int dissect_id_RL_Information_RL_FailureInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Information_RL_FailureInd(tvb, offset, actx, tree, hf_rnsap_id_RL_Information_RL_FailureInd);
}


static const per_sequence_t RL_Information_RL_ReconfPrepFDD_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_not_Used_sSDT_Indication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_NULL },
  { &hf_rnsap_not_Used_sSDT_CellIdentity, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_NULL },
  { &hf_rnsap_transmitDiversityIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransmitDiversityIndicator },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Information_RL_ReconfPrepFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Information_RL_ReconfPrepFDD, RL_Information_RL_ReconfPrepFDD_sequence);

  return offset;
}
static int dissect_id_RL_Information_RL_ReconfPrepFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Information_RL_ReconfPrepFDD(tvb, offset, actx, tree, hf_rnsap_id_RL_Information_RL_ReconfPrepFDD);
}


static const per_sequence_t RL_Information_RL_RestoreInd_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Information_RL_RestoreInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Information_RL_RestoreInd, RL_Information_RL_RestoreInd_sequence);

  return offset;
}
static int dissect_id_RL_Information_RL_RestoreInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Information_RL_RestoreInd(tvb, offset, actx, tree, hf_rnsap_id_RL_Information_RL_RestoreInd);
}


static const per_sequence_t RL_InformationList_RL_SetupRqstFDD_sequence_of[1] = {
  { &hf_rnsap_RL_InformationList_RL_SetupRqstFDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_RL_InformationList_RL_SetupRqstFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_InformationList_RL_SetupRqstFDD, RL_InformationList_RL_SetupRqstFDD_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_id_RL_Information_RL_SetupRqstFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationList_RL_SetupRqstFDD(tvb, offset, actx, tree, hf_rnsap_id_RL_Information_RL_SetupRqstFDD);
}



static int
dissect_rnsap_SpecialBurstScheduling(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              1U, 256U, NULL, FALSE);

  return offset;
}
static int dissect_specialBurstScheduling(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_SpecialBurstScheduling(tvb, offset, actx, tree, hf_rnsap_specialBurstScheduling);
}


static const per_sequence_t RL_Information_RL_SetupRqstTDD_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_c_ID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_C_ID },
  { &hf_rnsap_frameOffset   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_FrameOffset },
  { &hf_rnsap_specialBurstScheduling, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SpecialBurstScheduling },
  { &hf_rnsap_primaryCCPCH_RSCP, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_PrimaryCCPCH_RSCP },
  { &hf_rnsap_dL_TimeSlot_ISCP, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_TimeSlot_ISCP_Info },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Information_RL_SetupRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Information_RL_SetupRqstTDD, RL_Information_RL_SetupRqstTDD_sequence);

  return offset;
}
static int dissect_id_RL_Information_RL_SetupRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Information_RL_SetupRqstTDD(tvb, offset, actx, tree, hf_rnsap_id_RL_Information_RL_SetupRqstTDD);
}


static const per_sequence_t DCH_Rate_Information_RL_CongestInd_sequence_of[1] = {
  { &hf_rnsap_DCH_Rate_Information_RL_CongestInd_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_DCH_Rate_Information_RL_CongestInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DCH_Rate_Information_RL_CongestInd, DCH_Rate_Information_RL_CongestInd_sequence_of,
                                                  1, 128);

  return offset;
}
static int dissect_dCH_Rate_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_Rate_Information_RL_CongestInd(tvb, offset, actx, tree, hf_rnsap_dCH_Rate_Information);
}


static const per_sequence_t RL_InformationItem_RL_CongestInd_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_dCH_Rate_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_Rate_Information_RL_CongestInd },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_InformationItem_RL_CongestInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_InformationItem_RL_CongestInd, RL_InformationItem_RL_CongestInd_sequence);

  return offset;
}
static int dissect_id_RL_InformationItem_RL_CongestInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationItem_RL_CongestInd(tvb, offset, actx, tree, hf_rnsap_id_RL_InformationItem_RL_CongestInd);
}



static int
dissect_rnsap_SIR_Value(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 63U, NULL, FALSE);

  return offset;
}
static int dissect_sIR_Value(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_SIR_Value(tvb, offset, actx, tree, hf_rnsap_sIR_Value);
}
static int dissect_sir1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_SIR_Value(tvb, offset, actx, tree, hf_rnsap_sir1);
}



static int
dissect_rnsap_SIR_Error_Value(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 125U, NULL, FALSE);

  return offset;
}
static int dissect_sIR_ErrorValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_SIR_Error_Value(tvb, offset, actx, tree, hf_rnsap_sIR_ErrorValue);
}
static int dissect_sir_error1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_SIR_Error_Value(tvb, offset, actx, tree, hf_rnsap_sir_error1);
}



static int
dissect_rnsap_Transmitted_Code_Power_Value(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 127U, NULL, FALSE);

  return offset;
}
static int dissect_transmittedCodePowerValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Transmitted_Code_Power_Value(tvb, offset, actx, tree, hf_rnsap_transmittedCodePowerValue);
}
static int dissect_transmitted_code_power1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Transmitted_Code_Power_Value(tvb, offset, actx, tree, hf_rnsap_transmitted_code_power1);
}



static int
dissect_rnsap_RSCP_Value(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 127U, NULL, FALSE);

  return offset;
}
static int dissect_rSCP(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RSCP_Value(tvb, offset, actx, tree, hf_rnsap_rSCP);
}
static int dissect_rscp1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RSCP_Value(tvb, offset, actx, tree, hf_rnsap_rscp1);
}



static int
dissect_rnsap_Rx_Timing_Deviation_Value(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 8191U, NULL, FALSE);

  return offset;
}
static int dissect_rxTimingDeviationValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Rx_Timing_Deviation_Value(tvb, offset, actx, tree, hf_rnsap_rxTimingDeviationValue);
}
static int dissect_rx_timing_deviation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Rx_Timing_Deviation_Value(tvb, offset, actx, tree, hf_rnsap_rx_timing_deviation);
}



static int
dissect_rnsap_Round_Trip_Time_Value(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 32767U, NULL, FALSE);

  return offset;
}
static int dissect_roundTripTime(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Round_Trip_Time_Value(tvb, offset, actx, tree, hf_rnsap_roundTripTime);
}
static int dissect_round_trip_time1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Round_Trip_Time_Value(tvb, offset, actx, tree, hf_rnsap_round_trip_time1);
}



static int
dissect_rnsap_Extension_DedicatedMeasurementValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_extension_DedicatedMeasurementValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Extension_DedicatedMeasurementValue(tvb, offset, actx, tree, hf_rnsap_extension_DedicatedMeasurementValue);
}


static const value_string rnsap_DedicatedMeasurementValue_vals[] = {
  {   0, "sIR-Value" },
  {   1, "sIR-ErrorValue" },
  {   2, "transmittedCodePowerValue" },
  {   3, "rSCP" },
  {   4, "rxTimingDeviationValue" },
  {   5, "roundTripTime" },
  {   6, "extension-DedicatedMeasurementValue" },
  { 0, NULL }
};

static const per_choice_t DedicatedMeasurementValue_choice[] = {
  {   0, &hf_rnsap_sIR_Value     , ASN1_EXTENSION_ROOT    , dissect_rnsap_SIR_Value },
  {   1, &hf_rnsap_sIR_ErrorValue, ASN1_EXTENSION_ROOT    , dissect_rnsap_SIR_Error_Value },
  {   2, &hf_rnsap_transmittedCodePowerValue, ASN1_EXTENSION_ROOT    , dissect_rnsap_Transmitted_Code_Power_Value },
  {   3, &hf_rnsap_rSCP          , ASN1_EXTENSION_ROOT    , dissect_rnsap_RSCP_Value },
  {   4, &hf_rnsap_rxTimingDeviationValue, ASN1_EXTENSION_ROOT    , dissect_rnsap_Rx_Timing_Deviation_Value },
  {   5, &hf_rnsap_roundTripTime , ASN1_EXTENSION_ROOT    , dissect_rnsap_Round_Trip_Time_Value },
  {   6, &hf_rnsap_extension_DedicatedMeasurementValue, ASN1_NOT_EXTENSION_ROOT, dissect_rnsap_Extension_DedicatedMeasurementValue },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_DedicatedMeasurementValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_DedicatedMeasurementValue, DedicatedMeasurementValue_choice,
                                 NULL);

  return offset;
}
static int dissect_dedicatedMeasurementValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DedicatedMeasurementValue(tvb, offset, actx, tree, hf_rnsap_dedicatedMeasurementValue);
}
static int dissect_dedicatedmeasurementValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DedicatedMeasurementValue(tvb, offset, actx, tree, hf_rnsap_dedicatedmeasurementValue);
}


static const per_sequence_t DedicatedMeasurementAvailable_sequence[] = {
  { &hf_rnsap_dedicatedmeasurementValue, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DedicatedMeasurementValue },
  { &hf_rnsap_cFN           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CFN },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DedicatedMeasurementAvailable(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DedicatedMeasurementAvailable, DedicatedMeasurementAvailable_sequence);

  return offset;
}
static int dissect_measurementAvailable1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DedicatedMeasurementAvailable(tvb, offset, actx, tree, hf_rnsap_measurementAvailable1);
}



static int
dissect_rnsap_DedicatedMeasurementnotAvailable(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_measurementnotAvailable1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DedicatedMeasurementnotAvailable(tvb, offset, actx, tree, hf_rnsap_measurementnotAvailable1);
}


static const value_string rnsap_DedicatedMeasurementValueInformation_vals[] = {
  {   0, "measurementAvailable" },
  {   1, "measurementnotAvailable" },
  { 0, NULL }
};

static const per_choice_t DedicatedMeasurementValueInformation_choice[] = {
  {   0, &hf_rnsap_measurementAvailable1, ASN1_NO_EXTENSIONS     , dissect_rnsap_DedicatedMeasurementAvailable },
  {   1, &hf_rnsap_measurementnotAvailable1, ASN1_NO_EXTENSIONS     , dissect_rnsap_DedicatedMeasurementnotAvailable },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_DedicatedMeasurementValueInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_DedicatedMeasurementValueInformation, DedicatedMeasurementValueInformation_choice,
                                 NULL);

  return offset;
}
static int dissect_dedicatedMeasurementValueInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DedicatedMeasurementValueInformation(tvb, offset, actx, tree, hf_rnsap_dedicatedMeasurementValueInformation);
}


static const per_sequence_t RL_InformationItem_DM_Rprt_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_dPCH_ID       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DPCH_ID },
  { &hf_rnsap_dedicatedMeasurementValueInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DedicatedMeasurementValueInformation },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_InformationItem_DM_Rprt(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_InformationItem_DM_Rprt, RL_InformationItem_DM_Rprt_sequence);

  return offset;
}
static int dissect_id_RL_InformationItem_DM_Rprt(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationItem_DM_Rprt(tvb, offset, actx, tree, hf_rnsap_id_RL_InformationItem_DM_Rprt);
}


static const per_sequence_t RL_InformationItem_DM_Rqst_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_dPCH_ID       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DPCH_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_InformationItem_DM_Rqst(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_InformationItem_DM_Rqst, RL_InformationItem_DM_Rqst_sequence);

  return offset;
}
static int dissect_id_RL_InformationItem_DM_Rqst(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationItem_DM_Rqst(tvb, offset, actx, tree, hf_rnsap_id_RL_InformationItem_DM_Rqst);
}


static const per_sequence_t RL_InformationItem_DM_Rsp_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_dPCH_ID       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DPCH_ID },
  { &hf_rnsap_dedicatedMeasurementValue, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DedicatedMeasurementValue },
  { &hf_rnsap_cFN           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CFN },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_InformationItem_DM_Rsp(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_InformationItem_DM_Rsp, RL_InformationItem_DM_Rsp_sequence);

  return offset;
}
static int dissect_id_RL_InformationItem_DM_Rsp(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationItem_DM_Rsp(tvb, offset, actx, tree, hf_rnsap_id_RL_InformationItem_DM_Rsp);
}


static const per_sequence_t RL_InformationItem_RL_PreemptRequiredInd_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_InformationItem_RL_PreemptRequiredInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_InformationItem_RL_PreemptRequiredInd, RL_InformationItem_RL_PreemptRequiredInd_sequence);

  return offset;
}
static int dissect_id_RL_InformationItem_RL_PreemptRequiredInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationItem_RL_PreemptRequiredInd(tvb, offset, actx, tree, hf_rnsap_id_RL_InformationItem_RL_PreemptRequiredInd);
}


static const value_string rnsap_FirstRLS_Indicator_vals[] = {
  {   0, "first-RLS" },
  {   1, "not-first-RLS" },
  { 0, NULL }
};


static int
dissect_rnsap_FirstRLS_Indicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_firstRLS_indicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_FirstRLS_Indicator(tvb, offset, actx, tree, hf_rnsap_firstRLS_indicator);
}
static int dissect_firstRLS_Indicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_FirstRLS_Indicator(tvb, offset, actx, tree, hf_rnsap_firstRLS_Indicator);
}



static int
dissect_rnsap_PropagationDelay(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 255U, NULL, FALSE);

  return offset;
}
static int dissect_id_PropagationDelay(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PropagationDelay(tvb, offset, actx, tree, hf_rnsap_id_PropagationDelay);
}
static int dissect_propagationDelay(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PropagationDelay(tvb, offset, actx, tree, hf_rnsap_propagationDelay);
}
static int dissect_propagation_delay(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PropagationDelay(tvb, offset, actx, tree, hf_rnsap_propagation_delay);
}


static const per_sequence_t RL_InformationItem_RL_SetupRqstFDD_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_c_ID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_C_ID },
  { &hf_rnsap_firstRLS_indicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_FirstRLS_Indicator },
  { &hf_rnsap_frameOffset   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_FrameOffset },
  { &hf_rnsap_chipOffset    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ChipOffset },
  { &hf_rnsap_propagationDelay, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_PropagationDelay },
  { &hf_rnsap_diversityControlField, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DiversityControlField },
  { &hf_rnsap_dl_InitialTX_Power, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_Power },
  { &hf_rnsap_primaryCPICH_EcNo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_PrimaryCPICH_EcNo },
  { &hf_rnsap_not_Used_sSDT_CellID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_NULL },
  { &hf_rnsap_transmitDiversityIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransmitDiversityIndicator },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_InformationItem_RL_SetupRqstFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_InformationItem_RL_SetupRqstFDD, RL_InformationItem_RL_SetupRqstFDD_sequence);

  return offset;
}
static int dissect_id_RL_InformationItem_RL_SetupRqstFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationItem_RL_SetupRqstFDD(tvb, offset, actx, tree, hf_rnsap_id_RL_InformationItem_RL_SetupRqstFDD);
}


static const per_sequence_t RL_InformationList_RL_CongestInd_sequence_of[1] = {
  { &hf_rnsap_RL_InformationList_RL_CongestInd_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_RL_InformationList_RL_CongestInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_InformationList_RL_CongestInd, RL_InformationList_RL_CongestInd_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_id_RL_InformationList_RL_CongestInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationList_RL_CongestInd(tvb, offset, actx, tree, hf_rnsap_id_RL_InformationList_RL_CongestInd);
}


static const per_sequence_t RL_InformationList_RL_AdditionRqstFDD_sequence_of[1] = {
  { &hf_rnsap_RL_InformationList_RL_AdditionRqstFDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_RL_InformationList_RL_AdditionRqstFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_InformationList_RL_AdditionRqstFDD, RL_InformationList_RL_AdditionRqstFDD_sequence_of,
                                                  1, 15);

  return offset;
}
static int dissect_id_RL_InformationList_RL_AdditionRqstFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationList_RL_AdditionRqstFDD(tvb, offset, actx, tree, hf_rnsap_id_RL_InformationList_RL_AdditionRqstFDD);
}


static const per_sequence_t RL_InformationList_RL_DeletionRqst_sequence_of[1] = {
  { &hf_rnsap_RL_InformationList_RL_DeletionRqst_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_RL_InformationList_RL_DeletionRqst(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_InformationList_RL_DeletionRqst, RL_InformationList_RL_DeletionRqst_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_id_RL_InformationList_RL_DeletionRqst(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationList_RL_DeletionRqst(tvb, offset, actx, tree, hf_rnsap_id_RL_InformationList_RL_DeletionRqst);
}


static const per_sequence_t RL_InformationList_RL_PreemptRequiredInd_sequence_of[1] = {
  { &hf_rnsap_RL_InformationList_RL_PreemptRequiredInd_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_RL_InformationList_RL_PreemptRequiredInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_InformationList_RL_PreemptRequiredInd, RL_InformationList_RL_PreemptRequiredInd_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_id_RL_InformationList_RL_PreemptRequiredInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationList_RL_PreemptRequiredInd(tvb, offset, actx, tree, hf_rnsap_id_RL_InformationList_RL_PreemptRequiredInd);
}


static const per_sequence_t RL_InformationList_RL_ReconfPrepFDD_sequence_of[1] = {
  { &hf_rnsap_RL_InformationList_RL_ReconfPrepFDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_RL_InformationList_RL_ReconfPrepFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_InformationList_RL_ReconfPrepFDD, RL_InformationList_RL_ReconfPrepFDD_sequence_of,
                                                  0, 16);

  return offset;
}
static int dissect_id_RL_InformationList_RL_ReconfPrepFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationList_RL_ReconfPrepFDD(tvb, offset, actx, tree, hf_rnsap_id_RL_InformationList_RL_ReconfPrepFDD);
}


static const value_string rnsap_MultipleURAsIndicator_vals[] = {
  {   0, "multiple-URAs-exist" },
  {   1, "single-URA-exists" },
  { 0, NULL }
};


static int
dissect_rnsap_MultipleURAsIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_multipleURAsIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MultipleURAsIndicator(tvb, offset, actx, tree, hf_rnsap_multipleURAsIndicator);
}


static const per_sequence_t RNCsWithCellsInTheAccessedURA_Item_sequence[] = {
  { &hf_rnsap_rNC_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RNC_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RNCsWithCellsInTheAccessedURA_Item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RNCsWithCellsInTheAccessedURA_Item, RNCsWithCellsInTheAccessedURA_Item_sequence);

  return offset;
}
static int dissect_RNCsWithCellsInTheAccessedURA_List_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RNCsWithCellsInTheAccessedURA_Item(tvb, offset, actx, tree, hf_rnsap_RNCsWithCellsInTheAccessedURA_List_item);
}


static const per_sequence_t RNCsWithCellsInTheAccessedURA_List_sequence_of[1] = {
  { &hf_rnsap_RNCsWithCellsInTheAccessedURA_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_RNCsWithCellsInTheAccessedURA_Item },
};

static int
dissect_rnsap_RNCsWithCellsInTheAccessedURA_List(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RNCsWithCellsInTheAccessedURA_List, RNCsWithCellsInTheAccessedURA_List_sequence_of,
                                                  1, 15);

  return offset;
}
static int dissect_rNCsWithCellsInTheAccessedURA_List(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RNCsWithCellsInTheAccessedURA_List(tvb, offset, actx, tree, hf_rnsap_rNCsWithCellsInTheAccessedURA_List);
}


static const per_sequence_t URA_Information_sequence[] = {
  { &hf_rnsap_uRA_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_URA_ID },
  { &hf_rnsap_multipleURAsIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MultipleURAsIndicator },
  { &hf_rnsap_rNCsWithCellsInTheAccessedURA_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_RNCsWithCellsInTheAccessedURA_List },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_URA_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_URA_Information, URA_Information_sequence);

  return offset;
}
static int dissect_id_URA_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_URA_Information(tvb, offset, actx, tree, hf_rnsap_id_URA_Information);
}
static int dissect_uRA_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_URA_Information(tvb, offset, actx, tree, hf_rnsap_uRA_Information);
}



static int
dissect_rnsap_SAC(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       2, 2, NULL);

  return offset;
}
static int dissect_sAC(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_SAC(tvb, offset, actx, tree, hf_rnsap_sAC);
}


static const per_sequence_t SAI_sequence[] = {
  { &hf_rnsap_pLMN_Identity , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_PLMN_Identity },
  { &hf_rnsap_lAC           , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_LAC },
  { &hf_rnsap_sAC           , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_SAC },
  { &hf_rnsap_iE_Extensions , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_SAI(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_SAI, SAI_sequence);

  return offset;
}
static int dissect_id_SAI(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_SAI(tvb, offset, actx, tree, hf_rnsap_id_SAI);
}
static int dissect_sAI(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_SAI(tvb, offset, actx, tree, hf_rnsap_sAI);
}


static const value_string rnsap_T_latitudeSign_vals[] = {
  {   0, "north" },
  {   1, "south" },
  { 0, NULL }
};


static int
dissect_rnsap_T_latitudeSign(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_latitudeSign(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_T_latitudeSign(tvb, offset, actx, tree, hf_rnsap_latitudeSign);
}



static int
dissect_rnsap_INTEGER_0_8388607(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 8388607U, NULL, FALSE);

  return offset;
}
static int dissect_latitude(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_8388607(tvb, offset, actx, tree, hf_rnsap_latitude);
}



static int
dissect_rnsap_INTEGER_M8388608_8388607(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              -8388608, 8388607U, NULL, FALSE);

  return offset;
}
static int dissect_longitude(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_M8388608_8388607(tvb, offset, actx, tree, hf_rnsap_longitude);
}


static const per_sequence_t GeographicalCoordinate_sequence[] = {
  { &hf_rnsap_latitudeSign  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_T_latitudeSign },
  { &hf_rnsap_latitude      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_8388607 },
  { &hf_rnsap_longitude     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_M8388608_8388607 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GeographicalCoordinate(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GeographicalCoordinate, GeographicalCoordinate_sequence);

  return offset;
}
static int dissect_cell_GAIgeographicalCoordinate(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_GeographicalCoordinate(tvb, offset, actx, tree, hf_rnsap_cell_GAIgeographicalCoordinate);
}
static int dissect_geographicalCoordinates(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_GeographicalCoordinate(tvb, offset, actx, tree, hf_rnsap_geographicalCoordinates);
}
static int dissect_geographicalCoordinate(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_GeographicalCoordinate(tvb, offset, actx, tree, hf_rnsap_geographicalCoordinate);
}


static const per_sequence_t GA_Cell_item_sequence[] = {
  { &hf_rnsap_cell_GAIgeographicalCoordinate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GeographicalCoordinate },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GA_Cell_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GA_Cell_item, GA_Cell_item_sequence);

  return offset;
}
static int dissect_GA_Cell_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_GA_Cell_item(tvb, offset, actx, tree, hf_rnsap_GA_Cell_item);
}


static const per_sequence_t GA_Cell_sequence_of[1] = {
  { &hf_rnsap_GA_Cell_item  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_GA_Cell_item },
};

static int
dissect_rnsap_GA_Cell(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_GA_Cell, GA_Cell_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_id_GA_Cell(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_GA_Cell(tvb, offset, actx, tree, hf_rnsap_id_GA_Cell);
}
static int dissect_gA_Cell(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_GA_Cell(tvb, offset, actx, tree, hf_rnsap_gA_Cell);
}


static const per_sequence_t GA_AccessPointPosition_sequence[] = {
  { &hf_rnsap_geographicalCoordinate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GeographicalCoordinate },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GA_AccessPointPosition(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GA_AccessPointPosition, GA_AccessPointPosition_sequence);

  return offset;
}
static int dissect_gA_AccessPointPosition(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_GA_AccessPointPosition(tvb, offset, actx, tree, hf_rnsap_gA_AccessPointPosition);
}



static int
dissect_rnsap_UL_TimeslotISCP(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 127U, NULL, FALSE);

  return offset;
}
static int dissect_uplinkTimeslotISCPValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_TimeslotISCP(tvb, offset, actx, tree, hf_rnsap_uplinkTimeslotISCPValue);
}
static int dissect_uL_TimeslotISCP(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_TimeslotISCP(tvb, offset, actx, tree, hf_rnsap_uL_TimeslotISCP);
}


static const per_sequence_t UL_TimeSlot_ISCP_InfoItem_sequence[] = {
  { &hf_rnsap_timeSlot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlot },
  { &hf_rnsap_uL_TimeslotISCP, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_TimeslotISCP },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UL_TimeSlot_ISCP_InfoItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UL_TimeSlot_ISCP_InfoItem, UL_TimeSlot_ISCP_InfoItem_sequence);

  return offset;
}
static int dissect_UL_TimeSlot_ISCP_Info_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_TimeSlot_ISCP_InfoItem(tvb, offset, actx, tree, hf_rnsap_UL_TimeSlot_ISCP_Info_item);
}


static const per_sequence_t UL_TimeSlot_ISCP_Info_sequence_of[1] = {
  { &hf_rnsap_UL_TimeSlot_ISCP_Info_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_TimeSlot_ISCP_InfoItem },
};

static int
dissect_rnsap_UL_TimeSlot_ISCP_Info(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_UL_TimeSlot_ISCP_Info, UL_TimeSlot_ISCP_Info_sequence_of,
                                                  1, 15);

  return offset;
}
static int dissect_ul_TimeSlot_ISCP_Info(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_TimeSlot_ISCP_Info(tvb, offset, actx, tree, hf_rnsap_ul_TimeSlot_ISCP_Info);
}



static int
dissect_rnsap_UL_SIR(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              -82, 173U, NULL, FALSE);

  return offset;
}
static int dissect_id_UL_SIRTarget(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_SIR(tvb, offset, actx, tree, hf_rnsap_id_UL_SIRTarget);
}
static int dissect_id_UL_SIR_Target_CCTrCH_InformationItem_RL_SetupRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_SIR(tvb, offset, actx, tree, hf_rnsap_id_UL_SIR_Target_CCTrCH_InformationItem_RL_SetupRspTDD);
}
static int dissect_id_UL_SIR_Target_CCTrCH_LCR_InformationItem_RL_SetupRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_SIR(tvb, offset, actx, tree, hf_rnsap_id_UL_SIR_Target_CCTrCH_LCR_InformationItem_RL_SetupRspTDD);
}
static int dissect_ul_SIRTarget(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_SIR(tvb, offset, actx, tree, hf_rnsap_ul_SIRTarget);
}
static int dissect_maxUL_SIR(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_SIR(tvb, offset, actx, tree, hf_rnsap_maxUL_SIR);
}
static int dissect_minUL_SIR(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_SIR(tvb, offset, actx, tree, hf_rnsap_minUL_SIR);
}
static int dissect_max_UL_SIR(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_SIR(tvb, offset, actx, tree, hf_rnsap_max_UL_SIR);
}
static int dissect_min_UL_SIR(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_SIR(tvb, offset, actx, tree, hf_rnsap_min_UL_SIR);
}



static int
dissect_rnsap_MaximumAllowedULTxPower(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              -50, 33U, NULL, FALSE);

  return offset;
}
static int dissect_maximumAllowedULTxPower(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MaximumAllowedULTxPower(tvb, offset, actx, tree, hf_rnsap_maximumAllowedULTxPower);
}


static const value_string rnsap_TimingAdvanceApplied_vals[] = {
  {   0, "yes" },
  {   1, "no" },
  { 0, NULL }
};


static int
dissect_rnsap_TimingAdvanceApplied(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_timingAdvanceApplied(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TimingAdvanceApplied(tvb, offset, actx, tree, hf_rnsap_timingAdvanceApplied);
}



static int
dissect_rnsap_AlphaValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 8U, NULL, FALSE);

  return offset;
}
static int dissect_alphaValue(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_AlphaValue(tvb, offset, actx, tree, hf_rnsap_alphaValue);
}


static const value_string rnsap_UL_PhysCH_SF_Variation_vals[] = {
  {   0, "sf-variation-supported" },
  {   1, "sf-variation-not-supported" },
  { 0, NULL }
};


static int
dissect_rnsap_UL_PhysCH_SF_Variation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_ul_PhysCH_SF_Variation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_PhysCH_SF_Variation(tvb, offset, actx, tree, hf_rnsap_ul_PhysCH_SF_Variation);
}



static int
dissect_rnsap_INTEGER_1_256(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              1U, 256U, NULL, FALSE);

  return offset;
}
static int dissect_n_INSYNC_IND(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_1_256(tvb, offset, actx, tree, hf_rnsap_n_INSYNC_IND);
}
static int dissect_n_OUTSYNC_IND(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_1_256(tvb, offset, actx, tree, hf_rnsap_n_OUTSYNC_IND);
}


static const per_sequence_t SynchronisationConfiguration_sequence[] = {
  { &hf_rnsap_n_INSYNC_IND  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_1_256 },
  { &hf_rnsap_n_OUTSYNC_IND , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_1_256 },
  { &hf_rnsap_t_RLFAILURE   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_255 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_SynchronisationConfiguration(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_SynchronisationConfiguration, SynchronisationConfiguration_sequence);

  return offset;
}
static int dissect_synchronisationConfiguration(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_SynchronisationConfiguration(tvb, offset, actx, tree, hf_rnsap_synchronisationConfiguration);
}


static const per_sequence_t Secondary_CCPCH_TDD_Code_InformationItem_sequence[] = {
  { &hf_rnsap_tDD_ChannelisationCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCode },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Secondary_CCPCH_TDD_Code_InformationItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Secondary_CCPCH_TDD_Code_InformationItem, Secondary_CCPCH_TDD_Code_InformationItem_sequence);

  return offset;
}
static int dissect_Secondary_CCPCH_TDD_Code_Information_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Secondary_CCPCH_TDD_Code_InformationItem(tvb, offset, actx, tree, hf_rnsap_Secondary_CCPCH_TDD_Code_Information_item);
}


static const per_sequence_t Secondary_CCPCH_TDD_Code_Information_sequence_of[1] = {
  { &hf_rnsap_Secondary_CCPCH_TDD_Code_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Secondary_CCPCH_TDD_Code_InformationItem },
};

static int
dissect_rnsap_Secondary_CCPCH_TDD_Code_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Secondary_CCPCH_TDD_Code_Information, Secondary_CCPCH_TDD_Code_Information_sequence_of,
                                                  1, 8);

  return offset;
}
static int dissect_secondary_CCPCH_TDD_Code_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Secondary_CCPCH_TDD_Code_Information(tvb, offset, actx, tree, hf_rnsap_secondary_CCPCH_TDD_Code_Information);
}



static int
dissect_rnsap_TDD_PhysicalChannelOffset(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 63U, NULL, FALSE);

  return offset;
}
static int dissect_tDD_PhysicalChannelOffset(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TDD_PhysicalChannelOffset(tvb, offset, actx, tree, hf_rnsap_tDD_PhysicalChannelOffset);
}


static const per_sequence_t Secondary_CCPCH_TDD_InformationItem_sequence[] = {
  { &hf_rnsap_timeSlot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlot },
  { &hf_rnsap_midambleShiftAndBurstType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleShiftAndBurstType },
  { &hf_rnsap_tFCI_Presence , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCI_Presence },
  { &hf_rnsap_secondary_CCPCH_TDD_Code_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Secondary_CCPCH_TDD_Code_Information },
  { &hf_rnsap_tDD_PhysicalChannelOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_PhysicalChannelOffset },
  { &hf_rnsap_repetitionLength, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RepetitionLength },
  { &hf_rnsap_repetitionPeriod, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RepetitionPeriod },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Secondary_CCPCH_TDD_InformationItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Secondary_CCPCH_TDD_InformationItem, Secondary_CCPCH_TDD_InformationItem_sequence);

  return offset;
}
static int dissect_Secondary_CCPCH_TDD_InformationList_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Secondary_CCPCH_TDD_InformationItem(tvb, offset, actx, tree, hf_rnsap_Secondary_CCPCH_TDD_InformationList_item);
}


static const per_sequence_t Secondary_CCPCH_TDD_InformationList_sequence_of[1] = {
  { &hf_rnsap_Secondary_CCPCH_TDD_InformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Secondary_CCPCH_TDD_InformationItem },
};

static int
dissect_rnsap_Secondary_CCPCH_TDD_InformationList(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Secondary_CCPCH_TDD_InformationList, Secondary_CCPCH_TDD_InformationList_sequence_of,
                                                  0, 8);

  return offset;
}
static int dissect_secondary_CCPCH_TDD_InformationList(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Secondary_CCPCH_TDD_InformationList(tvb, offset, actx, tree, hf_rnsap_secondary_CCPCH_TDD_InformationList);
}


static const per_sequence_t FACH_InformationItem_sequence[] = {
  { &hf_rnsap_transportFormatSet, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatSet },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_FACH_InformationItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_FACH_InformationItem, FACH_InformationItem_sequence);

  return offset;
}
static int dissect_FACH_InformationList_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_FACH_InformationItem(tvb, offset, actx, tree, hf_rnsap_FACH_InformationList_item);
}


static const per_sequence_t FACH_InformationList_sequence_of[1] = {
  { &hf_rnsap_FACH_InformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_FACH_InformationItem },
};

static int
dissect_rnsap_FACH_InformationList(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_FACH_InformationList, FACH_InformationList_sequence_of,
                                                  0, 8);

  return offset;
}
static int dissect_fACH_InformationList(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_FACH_InformationList(tvb, offset, actx, tree, hf_rnsap_fACH_InformationList);
}


static const per_sequence_t PCH_InformationItem_sequence[] = {
  { &hf_rnsap_transportFormatSet, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatSet },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_PCH_InformationItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_PCH_InformationItem, PCH_InformationItem_sequence);

  return offset;
}
static int dissect_PCH_InformationList_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PCH_InformationItem(tvb, offset, actx, tree, hf_rnsap_PCH_InformationList_item);
}


static const per_sequence_t PCH_InformationList_sequence_of[1] = {
  { &hf_rnsap_PCH_InformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_PCH_InformationItem },
};

static int
dissect_rnsap_PCH_InformationList(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_PCH_InformationList, PCH_InformationList_sequence_of,
                                                  0, 1);

  return offset;
}
static int dissect_pCH_InformationList(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PCH_InformationList(tvb, offset, actx, tree, hf_rnsap_pCH_InformationList);
}


static const per_sequence_t Secondary_CCPCH_Info_TDD_sequence[] = {
  { &hf_rnsap_dl_TFCS       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCS },
  { &hf_rnsap_tFCI_Coding   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCI_Coding },
  { &hf_rnsap_secondary_CCPCH_TDD_InformationList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Secondary_CCPCH_TDD_InformationList },
  { &hf_rnsap_fACH_InformationList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_FACH_InformationList },
  { &hf_rnsap_pCH_InformationList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PCH_InformationList },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Secondary_CCPCH_Info_TDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Secondary_CCPCH_Info_TDD, Secondary_CCPCH_Info_TDD_sequence);

  return offset;
}
static int dissect_secondary_CCPCH_Info_TDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Secondary_CCPCH_Info_TDD(tvb, offset, actx, tree, hf_rnsap_secondary_CCPCH_Info_TDD);
}



static int
dissect_rnsap_UL_CCTrCHInformationList_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_ul_CCTrCHInformation1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_CCTrCHInformationList_RL_AdditionRspTDD(tvb, offset, actx, tree, hf_rnsap_ul_CCTrCHInformation1);
}



static int
dissect_rnsap_DL_CCTrCHInformationList_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_dl_CCTrCHInformation1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CCTrCHInformationList_RL_AdditionRspTDD(tvb, offset, actx, tree, hf_rnsap_dl_CCTrCHInformation1);
}


static const per_sequence_t Combining_RL_AdditionRspTDD_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Combining_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Combining_RL_AdditionRspTDD, Combining_RL_AdditionRspTDD_sequence);

  return offset;
}
static int dissect_combining3(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Combining_RL_AdditionRspTDD(tvb, offset, actx, tree, hf_rnsap_combining3);
}


static const per_sequence_t NonCombining_RL_AdditionRspTDD_sequence[] = {
  { &hf_rnsap_dCH_InformationResponse, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_InformationResponse },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_NonCombining_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_NonCombining_RL_AdditionRspTDD, NonCombining_RL_AdditionRspTDD_sequence);

  return offset;
}
static int dissect_nonCombining1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NonCombining_RL_AdditionRspTDD(tvb, offset, actx, tree, hf_rnsap_nonCombining1);
}


static const value_string rnsap_DiversityIndication_RL_AdditionRspTDD_vals[] = {
  {   0, "combining" },
  {   1, "nonCombining" },
  { 0, NULL }
};

static const per_choice_t DiversityIndication_RL_AdditionRspTDD_choice[] = {
  {   0, &hf_rnsap_combining3    , ASN1_NO_EXTENSIONS     , dissect_rnsap_Combining_RL_AdditionRspTDD },
  {   1, &hf_rnsap_nonCombining1 , ASN1_NO_EXTENSIONS     , dissect_rnsap_NonCombining_RL_AdditionRspTDD },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_DiversityIndication_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_DiversityIndication_RL_AdditionRspTDD, DiversityIndication_RL_AdditionRspTDD_choice,
                                 NULL);

  return offset;
}
static int dissect_diversityIndication3(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DiversityIndication_RL_AdditionRspTDD(tvb, offset, actx, tree, hf_rnsap_diversityIndication3);
}


static const per_sequence_t DCH_Information_RL_AdditionRspTDD_sequence[] = {
  { &hf_rnsap_diversityIndication3, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DiversityIndication_RL_AdditionRspTDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DCH_Information_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DCH_Information_RL_AdditionRspTDD, DCH_Information_RL_AdditionRspTDD_sequence);

  return offset;
}
static int dissect_dCH_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_Information_RL_AdditionRspTDD(tvb, offset, actx, tree, hf_rnsap_dCH_Information);
}



static int
dissect_rnsap_DSCH_InformationResponse_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_dSCH_InformationResponse(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DSCH_InformationResponse_RL_AdditionRspTDD(tvb, offset, actx, tree, hf_rnsap_dSCH_InformationResponse);
}



static int
dissect_rnsap_USCH_InformationResponse_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_uSCH_InformationResponse(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_USCH_InformationResponse_RL_AdditionRspTDD(tvb, offset, actx, tree, hf_rnsap_uSCH_InformationResponse);
}


static const per_sequence_t Neighbouring_UMTS_CellInformation_sequence_of[1] = {
  { &hf_rnsap_Neighbouring_UMTS_CellInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_Neighbouring_UMTS_CellInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Neighbouring_UMTS_CellInformation, Neighbouring_UMTS_CellInformation_sequence_of,
                                                  1, 10);

  return offset;
}
static int dissect_neighbouring_UMTS_CellInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Neighbouring_UMTS_CellInformation(tvb, offset, actx, tree, hf_rnsap_neighbouring_UMTS_CellInformation);
}


static const per_sequence_t RL_InformationResponse_RL_AdditionRspTDD_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_uRA_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_URA_Information },
  { &hf_rnsap_sAI           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SAI },
  { &hf_rnsap_gA_Cell       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GA_Cell },
  { &hf_rnsap_gA_AccessPointPosition, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GA_AccessPointPosition },
  { &hf_rnsap_ul_TimeSlot_ISCP_Info, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_TimeSlot_ISCP_Info },
  { &hf_rnsap_minUL_SIR     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_SIR },
  { &hf_rnsap_maxUL_SIR     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_SIR },
  { &hf_rnsap_maximumAllowedULTxPower, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MaximumAllowedULTxPower },
  { &hf_rnsap_maximumDLTxPower, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_Power },
  { &hf_rnsap_minimumDLTxPower, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_Power },
  { &hf_rnsap_pCCPCH_Power  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PCCPCH_Power },
  { &hf_rnsap_timingAdvanceApplied, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimingAdvanceApplied },
  { &hf_rnsap_alphaValue    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_AlphaValue },
  { &hf_rnsap_ul_PhysCH_SF_Variation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_PhysCH_SF_Variation },
  { &hf_rnsap_synchronisationConfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SynchronisationConfiguration },
  { &hf_rnsap_secondary_CCPCH_Info_TDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Secondary_CCPCH_Info_TDD },
  { &hf_rnsap_ul_CCTrCHInformation1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UL_CCTrCHInformationList_RL_AdditionRspTDD },
  { &hf_rnsap_dl_CCTrCHInformation1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_CCTrCHInformationList_RL_AdditionRspTDD },
  { &hf_rnsap_dCH_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DCH_Information_RL_AdditionRspTDD },
  { &hf_rnsap_dSCH_InformationResponse, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DSCH_InformationResponse_RL_AdditionRspTDD },
  { &hf_rnsap_uSCH_InformationResponse, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_USCH_InformationResponse_RL_AdditionRspTDD },
  { &hf_rnsap_neighbouring_UMTS_CellInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Neighbouring_UMTS_CellInformation },
  { &hf_rnsap_neighbouring_GSM_CellInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Neighbouring_GSM_CellInformation },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_InformationResponse_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_InformationResponse_RL_AdditionRspTDD, RL_InformationResponse_RL_AdditionRspTDD_sequence);

  return offset;
}
static int dissect_id_RL_InformationResponse_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationResponse_RL_AdditionRspTDD(tvb, offset, actx, tree, hf_rnsap_id_RL_InformationResponse_RL_AdditionRspTDD);
}



static int
dissect_rnsap_UL_CCTrCH_InformationList_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_ul_CCTrCH_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_CCTrCH_InformationList_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_ul_CCTrCH_Information);
}



static int
dissect_rnsap_DL_CCTrCH_InformationList_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_dl_CCTrCH_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CCTrCH_InformationList_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_dl_CCTrCH_Information);
}



static int
dissect_rnsap_DCH_InformationResponseList_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_dCHInformationResponse1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_InformationResponseList_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_dCHInformationResponse1);
}



static int
dissect_rnsap_DSCHToBeAddedOrModified_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_dSCHsToBeAddedOrModified(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DSCHToBeAddedOrModified_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_dSCHsToBeAddedOrModified);
}



static int
dissect_rnsap_USCHToBeAddedOrModified_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_uSCHsToBeAddedOrModified(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_USCHToBeAddedOrModified_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_uSCHsToBeAddedOrModified);
}


static const per_sequence_t RL_InformationResponse_RL_ReconfReadyTDD_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_max_UL_SIR    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UL_SIR },
  { &hf_rnsap_min_UL_SIR    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UL_SIR },
  { &hf_rnsap_maximumDLTxPower, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_Power },
  { &hf_rnsap_minimumDLTxPower, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_Power },
  { &hf_rnsap_secondary_CCPCH_Info_TDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Secondary_CCPCH_Info_TDD },
  { &hf_rnsap_ul_CCTrCH_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UL_CCTrCH_InformationList_RL_ReconfReadyTDD },
  { &hf_rnsap_dl_CCTrCH_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_CCTrCH_InformationList_RL_ReconfReadyTDD },
  { &hf_rnsap_dCHInformationResponse1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DCH_InformationResponseList_RL_ReconfReadyTDD },
  { &hf_rnsap_dSCHsToBeAddedOrModified, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DSCHToBeAddedOrModified_RL_ReconfReadyTDD },
  { &hf_rnsap_uSCHsToBeAddedOrModified, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_USCHToBeAddedOrModified_RL_ReconfReadyTDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_InformationResponse_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_InformationResponse_RL_ReconfReadyTDD, RL_InformationResponse_RL_ReconfReadyTDD_sequence);

  return offset;
}
static int dissect_id_RL_InformationResponse_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationResponse_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_id_RL_InformationResponse_RL_ReconfReadyTDD);
}
static int dissect_Multiple_RL_InformationResponse_RL_ReconfReadyTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationResponse_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_Multiple_RL_InformationResponse_RL_ReconfReadyTDD_item);
}



static int
dissect_rnsap_UL_CCTrCHInformationList_RL_SetupRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_ul_CCTrCHInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_CCTrCHInformationList_RL_SetupRspTDD(tvb, offset, actx, tree, hf_rnsap_ul_CCTrCHInformation);
}



static int
dissect_rnsap_DL_CCTrCHInformationList_RL_SetupRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_dl_CCTrCHInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CCTrCHInformationList_RL_SetupRspTDD(tvb, offset, actx, tree, hf_rnsap_dl_CCTrCHInformation);
}



static int
dissect_rnsap_DCH_InformationResponseList_RL_SetupRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_dCH_InformationResponse1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_InformationResponseList_RL_SetupRspTDD(tvb, offset, actx, tree, hf_rnsap_dCH_InformationResponse1);
}



static int
dissect_rnsap_DSCH_InformationResponse_RL_SetupRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_dsch_InformationResponse(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DSCH_InformationResponse_RL_SetupRspTDD(tvb, offset, actx, tree, hf_rnsap_dsch_InformationResponse);
}



static int
dissect_rnsap_USCH_InformationResponse_RL_SetupRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_usch_InformationResponse(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_USCH_InformationResponse_RL_SetupRspTDD(tvb, offset, actx, tree, hf_rnsap_usch_InformationResponse);
}


static const per_sequence_t RL_InformationResponse_RL_SetupRspTDD_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_uRA_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_URA_Information },
  { &hf_rnsap_sAI           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SAI },
  { &hf_rnsap_gA_Cell       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GA_Cell },
  { &hf_rnsap_gA_AccessPointPosition, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GA_AccessPointPosition },
  { &hf_rnsap_ul_TimeSlot_ISCP_Info, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_TimeSlot_ISCP_Info },
  { &hf_rnsap_maxUL_SIR     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_SIR },
  { &hf_rnsap_minUL_SIR     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_SIR },
  { &hf_rnsap_maximumAllowedULTxPower, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MaximumAllowedULTxPower },
  { &hf_rnsap_maximumDLTxPower, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_Power },
  { &hf_rnsap_minimumDLTxPower, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_Power },
  { &hf_rnsap_uARFCNforNt   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UARFCN },
  { &hf_rnsap_cellParameterID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CellParameterID },
  { &hf_rnsap_syncCase      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_SyncCase },
  { &hf_rnsap_sCH_TimeSlot  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_SCH_TimeSlot },
  { &hf_rnsap_sCTD_Indicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_SCTD_Indicator },
  { &hf_rnsap_pCCPCH_Power  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PCCPCH_Power },
  { &hf_rnsap_timingAdvanceApplied, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimingAdvanceApplied },
  { &hf_rnsap_alphaValue    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_AlphaValue },
  { &hf_rnsap_ul_PhysCH_SF_Variation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_PhysCH_SF_Variation },
  { &hf_rnsap_synchronisationConfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SynchronisationConfiguration },
  { &hf_rnsap_secondary_CCPCH_Info_TDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Secondary_CCPCH_Info_TDD },
  { &hf_rnsap_ul_CCTrCHInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UL_CCTrCHInformationList_RL_SetupRspTDD },
  { &hf_rnsap_dl_CCTrCHInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_CCTrCHInformationList_RL_SetupRspTDD },
  { &hf_rnsap_dCH_InformationResponse1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DCH_InformationResponseList_RL_SetupRspTDD },
  { &hf_rnsap_dsch_InformationResponse, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DSCH_InformationResponse_RL_SetupRspTDD },
  { &hf_rnsap_usch_InformationResponse, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_USCH_InformationResponse_RL_SetupRspTDD },
  { &hf_rnsap_neighbouring_UMTS_CellInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Neighbouring_UMTS_CellInformation },
  { &hf_rnsap_neighbouring_GSM_CellInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Neighbouring_GSM_CellInformation },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_InformationResponse_RL_SetupRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_InformationResponse_RL_SetupRspTDD, RL_InformationResponse_RL_SetupRspTDD_sequence);

  return offset;
}
static int dissect_id_RL_InformationResponse_RL_SetupRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationResponse_RL_SetupRspTDD(tvb, offset, actx, tree, hf_rnsap_id_RL_InformationResponse_RL_SetupRspTDD);
}



static int
dissect_rnsap_RL_Set_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 31U, NULL, FALSE);

  return offset;
}
static int dissect_id_EDCH_RLSet_Id(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_ID(tvb, offset, actx, tree, hf_rnsap_id_EDCH_RLSet_Id);
}
static int dissect_rL_Set_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_ID(tvb, offset, actx, tree, hf_rnsap_rL_Set_ID);
}



static int
dissect_rnsap_Received_total_wide_band_power(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 621U, NULL, FALSE);

  return offset;
}
static int dissect_received_total_wide_band_power(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Received_total_wide_band_power(tvb, offset, actx, tree, hf_rnsap_received_total_wide_band_power);
}



static int
dissect_rnsap_DL_CodeInformationList_RL_AdditionRspFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_dl_CodeInformation1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CodeInformationList_RL_AdditionRspFDD(tvb, offset, actx, tree, hf_rnsap_dl_CodeInformation1);
}


static const per_sequence_t Combining_RL_AdditionRspFDD_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Combining_RL_AdditionRspFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Combining_RL_AdditionRspFDD, Combining_RL_AdditionRspFDD_sequence);

  return offset;
}
static int dissect_combining2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Combining_RL_AdditionRspFDD(tvb, offset, actx, tree, hf_rnsap_combining2);
}


static const per_sequence_t NonCombining_RL_AdditionRspFDD_sequence[] = {
  { &hf_rnsap_dCH_InformationResponse, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_InformationResponse },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_NonCombining_RL_AdditionRspFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_NonCombining_RL_AdditionRspFDD, NonCombining_RL_AdditionRspFDD_sequence);

  return offset;
}
static int dissect_nonCombining(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NonCombining_RL_AdditionRspFDD(tvb, offset, actx, tree, hf_rnsap_nonCombining);
}


static const value_string rnsap_DiversityIndication_RL_AdditionRspFDD_vals[] = {
  {   0, "combining" },
  {   1, "nonCombining" },
  { 0, NULL }
};

static const per_choice_t DiversityIndication_RL_AdditionRspFDD_choice[] = {
  {   0, &hf_rnsap_combining2    , ASN1_NO_EXTENSIONS     , dissect_rnsap_Combining_RL_AdditionRspFDD },
  {   1, &hf_rnsap_nonCombining  , ASN1_NO_EXTENSIONS     , dissect_rnsap_NonCombining_RL_AdditionRspFDD },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_DiversityIndication_RL_AdditionRspFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_DiversityIndication_RL_AdditionRspFDD, DiversityIndication_RL_AdditionRspFDD_choice,
                                 NULL);

  return offset;
}
static int dissect_diversityIndication2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DiversityIndication_RL_AdditionRspFDD(tvb, offset, actx, tree, hf_rnsap_diversityIndication2);
}


static const value_string rnsap_SSDT_SupportIndicator_vals[] = {
  {   0, "not-Used-sSDT-supported" },
  {   1, "sSDT-not-supported" },
  { 0, NULL }
};


static int
dissect_rnsap_SSDT_SupportIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_sSDT_SupportIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_SSDT_SupportIndicator(tvb, offset, actx, tree, hf_rnsap_sSDT_SupportIndicator);
}


static const value_string rnsap_Closedlooptimingadjustmentmode_vals[] = {
  {   0, "adj-1-slot" },
  {   1, "adj-2-slot" },
  { 0, NULL }
};


static int
dissect_rnsap_Closedlooptimingadjustmentmode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_closedlooptimingadjustmentmode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Closedlooptimingadjustmentmode(tvb, offset, actx, tree, hf_rnsap_closedlooptimingadjustmentmode);
}



static int
dissect_rnsap_PC_Preamble(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 7U, NULL, TRUE);

  return offset;
}
static int dissect_pC_Preamble(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_PC_Preamble(tvb, offset, actx, tree, hf_rnsap_pC_Preamble);
}



static int
dissect_rnsap_SRB_Delay(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 7U, NULL, TRUE);

  return offset;
}
static int dissect_sRB_Delay(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_SRB_Delay(tvb, offset, actx, tree, hf_rnsap_sRB_Delay);
}


static const per_sequence_t RL_InformationResponseItem_RL_AdditionRspFDD_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_rL_Set_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_Set_ID },
  { &hf_rnsap_uRA_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_URA_Information },
  { &hf_rnsap_sAI           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SAI },
  { &hf_rnsap_gA_Cell       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GA_Cell },
  { &hf_rnsap_gA_AccessPointPosition, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GA_AccessPointPosition },
  { &hf_rnsap_received_total_wide_band_power, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Received_total_wide_band_power },
  { &hf_rnsap_not_Used_secondary_CCPCH_Info, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_NULL },
  { &hf_rnsap_dl_CodeInformation1, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_CodeInformationList_RL_AdditionRspFDD },
  { &hf_rnsap_diversityIndication2, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DiversityIndication_RL_AdditionRspFDD },
  { &hf_rnsap_sSDT_SupportIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SSDT_SupportIndicator },
  { &hf_rnsap_minUL_SIR     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_SIR },
  { &hf_rnsap_maxUL_SIR     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_SIR },
  { &hf_rnsap_closedlooptimingadjustmentmode, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Closedlooptimingadjustmentmode },
  { &hf_rnsap_maximumAllowedULTxPower, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MaximumAllowedULTxPower },
  { &hf_rnsap_maximumDLTxPower, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_Power },
  { &hf_rnsap_minimumDLTxPower, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_Power },
  { &hf_rnsap_neighbouring_UMTS_CellInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Neighbouring_UMTS_CellInformation },
  { &hf_rnsap_neighbouring_GSM_CellInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Neighbouring_GSM_CellInformation },
  { &hf_rnsap_pC_Preamble   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PC_Preamble },
  { &hf_rnsap_sRB_Delay     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SRB_Delay },
  { &hf_rnsap_primaryCPICH_Power, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PrimaryCPICH_Power },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_InformationResponseItem_RL_AdditionRspFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_InformationResponseItem_RL_AdditionRspFDD, RL_InformationResponseItem_RL_AdditionRspFDD_sequence);

  return offset;
}
static int dissect_id_RL_InformationResponseItem_RL_AdditionRspFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationResponseItem_RL_AdditionRspFDD(tvb, offset, actx, tree, hf_rnsap_id_RL_InformationResponseItem_RL_AdditionRspFDD);
}



static int
dissect_rnsap_DL_CodeInformationList_RL_ReconfReadyFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_dl_CodeInformationList(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CodeInformationList_RL_ReconfReadyFDD(tvb, offset, actx, tree, hf_rnsap_dl_CodeInformationList);
}



static int
dissect_rnsap_DCH_InformationResponseList_RL_ReconfReadyFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_dCHInformationResponse(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_InformationResponseList_RL_ReconfReadyFDD(tvb, offset, actx, tree, hf_rnsap_dCHInformationResponse);
}


static const per_sequence_t RL_InformationResponseItem_RL_ReconfReadyFDD_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_max_UL_SIR    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UL_SIR },
  { &hf_rnsap_min_UL_SIR    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UL_SIR },
  { &hf_rnsap_maximumDLTxPower, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_Power },
  { &hf_rnsap_minimumDLTxPower, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_Power },
  { &hf_rnsap_not_Used_secondary_CCPCH_Info, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_NULL },
  { &hf_rnsap_dl_CodeInformationList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_CodeInformationList_RL_ReconfReadyFDD },
  { &hf_rnsap_dCHInformationResponse, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DCH_InformationResponseList_RL_ReconfReadyFDD },
  { &hf_rnsap_not_Used_dSCHsToBeAddedOrModified, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_NULL },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_InformationResponseItem_RL_ReconfReadyFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_InformationResponseItem_RL_ReconfReadyFDD, RL_InformationResponseItem_RL_ReconfReadyFDD_sequence);

  return offset;
}
static int dissect_id_RL_InformationResponseItem_RL_ReconfReadyFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationResponseItem_RL_ReconfReadyFDD(tvb, offset, actx, tree, hf_rnsap_id_RL_InformationResponseItem_RL_ReconfReadyFDD);
}



static int
dissect_rnsap_DCH_InformationResponseList_RL_ReconfRspFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_dCHsInformationResponseList(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_InformationResponseList_RL_ReconfRspFDD(tvb, offset, actx, tree, hf_rnsap_dCHsInformationResponseList);
}



static int
dissect_rnsap_DL_CodeInformationList_RL_ReconfRspFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_dL_CodeInformationList_RL_ReconfResp(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CodeInformationList_RL_ReconfRspFDD(tvb, offset, actx, tree, hf_rnsap_dL_CodeInformationList_RL_ReconfResp);
}


static const per_sequence_t RL_InformationResponseItem_RL_ReconfRspFDD_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_max_UL_SIR    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UL_SIR },
  { &hf_rnsap_min_UL_SIR    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UL_SIR },
  { &hf_rnsap_maximumDLTxPower, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_Power },
  { &hf_rnsap_minimumDLTxPower, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_Power },
  { &hf_rnsap_not_Used_secondary_CCPCH_Info, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_NULL },
  { &hf_rnsap_dCHsInformationResponseList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DCH_InformationResponseList_RL_ReconfRspFDD },
  { &hf_rnsap_dL_CodeInformationList_RL_ReconfResp, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_CodeInformationList_RL_ReconfRspFDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_InformationResponseItem_RL_ReconfRspFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_InformationResponseItem_RL_ReconfRspFDD, RL_InformationResponseItem_RL_ReconfRspFDD_sequence);

  return offset;
}
static int dissect_id_RL_InformationResponseItem_RL_ReconfRspFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationResponseItem_RL_ReconfRspFDD(tvb, offset, actx, tree, hf_rnsap_id_RL_InformationResponseItem_RL_ReconfRspFDD);
}


static const per_sequence_t Combining_RL_SetupRspFDD_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Combining_RL_SetupRspFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Combining_RL_SetupRspFDD, Combining_RL_SetupRspFDD_sequence);

  return offset;
}
static int dissect_combining(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Combining_RL_SetupRspFDD(tvb, offset, actx, tree, hf_rnsap_combining);
}


static const per_sequence_t NonCombiningOrFirstRL_RL_SetupRspFDD_sequence[] = {
  { &hf_rnsap_dCH_InformationResponse, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_InformationResponse },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_NonCombiningOrFirstRL_RL_SetupRspFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_NonCombiningOrFirstRL_RL_SetupRspFDD, NonCombiningOrFirstRL_RL_SetupRspFDD_sequence);

  return offset;
}
static int dissect_nonCombiningOrFirstRL(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NonCombiningOrFirstRL_RL_SetupRspFDD(tvb, offset, actx, tree, hf_rnsap_nonCombiningOrFirstRL);
}


static const value_string rnsap_DiversityIndication_RL_SetupRspFDD_vals[] = {
  {   0, "combining" },
  {   1, "nonCombiningOrFirstRL" },
  { 0, NULL }
};

static const per_choice_t DiversityIndication_RL_SetupRspFDD_choice[] = {
  {   0, &hf_rnsap_combining     , ASN1_NO_EXTENSIONS     , dissect_rnsap_Combining_RL_SetupRspFDD },
  {   1, &hf_rnsap_nonCombiningOrFirstRL, ASN1_NO_EXTENSIONS     , dissect_rnsap_NonCombiningOrFirstRL_RL_SetupRspFDD },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_DiversityIndication_RL_SetupRspFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_DiversityIndication_RL_SetupRspFDD, DiversityIndication_RL_SetupRspFDD_choice,
                                 NULL);

  return offset;
}
static int dissect_diversityIndication(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DiversityIndication_RL_SetupRspFDD(tvb, offset, actx, tree, hf_rnsap_diversityIndication);
}


static const per_sequence_t RL_InformationResponseItem_RL_SetupRspFDD_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_rL_Set_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_Set_ID },
  { &hf_rnsap_uRA_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_URA_Information },
  { &hf_rnsap_sAI           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SAI },
  { &hf_rnsap_gA_Cell       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GA_Cell },
  { &hf_rnsap_gA_AccessPointPosition, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GA_AccessPointPosition },
  { &hf_rnsap_received_total_wide_band_power, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Received_total_wide_band_power },
  { &hf_rnsap_not_Used_secondary_CCPCH_Info, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_NULL },
  { &hf_rnsap_dl_CodeInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_FDD_DL_CodeInformation },
  { &hf_rnsap_diversityIndication, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DiversityIndication_RL_SetupRspFDD },
  { &hf_rnsap_sSDT_SupportIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SSDT_SupportIndicator },
  { &hf_rnsap_maxUL_SIR     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_SIR },
  { &hf_rnsap_minUL_SIR     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_SIR },
  { &hf_rnsap_closedlooptimingadjustmentmode, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Closedlooptimingadjustmentmode },
  { &hf_rnsap_maximumAllowedULTxPower, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MaximumAllowedULTxPower },
  { &hf_rnsap_maximumDLTxPower, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_Power },
  { &hf_rnsap_minimumDLTxPower, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_Power },
  { &hf_rnsap_primaryScramblingCode, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_PrimaryScramblingCode },
  { &hf_rnsap_uL_UARFCN     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UARFCN },
  { &hf_rnsap_dL_UARFCN     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UARFCN },
  { &hf_rnsap_primaryCPICH_Power, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PrimaryCPICH_Power },
  { &hf_rnsap_not_Used_dSCHInformationResponse, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_NULL },
  { &hf_rnsap_neighbouring_UMTS_CellInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Neighbouring_UMTS_CellInformation },
  { &hf_rnsap_neighbouring_GSM_CellInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Neighbouring_GSM_CellInformation },
  { &hf_rnsap_pC_Preamble   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PC_Preamble },
  { &hf_rnsap_sRB_Delay     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SRB_Delay },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_InformationResponseItem_RL_SetupRspFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_InformationResponseItem_RL_SetupRspFDD, RL_InformationResponseItem_RL_SetupRspFDD_sequence);

  return offset;
}
static int dissect_id_RL_InformationResponseItem_RL_SetupRspFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationResponseItem_RL_SetupRspFDD(tvb, offset, actx, tree, hf_rnsap_id_RL_InformationResponseItem_RL_SetupRspFDD);
}


static const per_sequence_t RL_InformationResponseList_RL_AdditionRspFDD_sequence_of[1] = {
  { &hf_rnsap_RL_InformationResponseList_RL_AdditionRspFDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_RL_InformationResponseList_RL_AdditionRspFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_InformationResponseList_RL_AdditionRspFDD, RL_InformationResponseList_RL_AdditionRspFDD_sequence_of,
                                                  1, 15);

  return offset;
}
static int dissect_id_RL_InformationResponseList_RL_AdditionRspFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationResponseList_RL_AdditionRspFDD(tvb, offset, actx, tree, hf_rnsap_id_RL_InformationResponseList_RL_AdditionRspFDD);
}


static const per_sequence_t RL_InformationResponseList_RL_ReconfReadyFDD_sequence_of[1] = {
  { &hf_rnsap_RL_InformationResponseList_RL_ReconfReadyFDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_RL_InformationResponseList_RL_ReconfReadyFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_InformationResponseList_RL_ReconfReadyFDD, RL_InformationResponseList_RL_ReconfReadyFDD_sequence_of,
                                                  0, 16);

  return offset;
}
static int dissect_id_RL_InformationResponseList_RL_ReconfReadyFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationResponseList_RL_ReconfReadyFDD(tvb, offset, actx, tree, hf_rnsap_id_RL_InformationResponseList_RL_ReconfReadyFDD);
}


static const per_sequence_t RL_InformationResponseList_RL_ReconfRspFDD_sequence_of[1] = {
  { &hf_rnsap_RL_InformationResponseList_RL_ReconfRspFDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_RL_InformationResponseList_RL_ReconfRspFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_InformationResponseList_RL_ReconfRspFDD, RL_InformationResponseList_RL_ReconfRspFDD_sequence_of,
                                                  0, 16);

  return offset;
}
static int dissect_id_RL_InformationResponseList_RL_ReconfRspFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationResponseList_RL_ReconfRspFDD(tvb, offset, actx, tree, hf_rnsap_id_RL_InformationResponseList_RL_ReconfRspFDD);
}



static int
dissect_rnsap_DCH_InformationResponseList_RL_ReconfRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_dCHsInformationResponseList1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DCH_InformationResponseList_RL_ReconfRspTDD(tvb, offset, actx, tree, hf_rnsap_dCHsInformationResponseList1);
}


static const per_sequence_t RL_InformationResponse_RL_ReconfRspTDD_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_max_UL_SIR    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UL_SIR },
  { &hf_rnsap_min_UL_SIR    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UL_SIR },
  { &hf_rnsap_maximumDLTxPower, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_Power },
  { &hf_rnsap_minimumDLTxPower, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_Power },
  { &hf_rnsap_dCHsInformationResponseList1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DCH_InformationResponseList_RL_ReconfRspTDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_InformationResponse_RL_ReconfRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_InformationResponse_RL_ReconfRspTDD, RL_InformationResponse_RL_ReconfRspTDD_sequence);

  return offset;
}
static int dissect_id_RL_InformationResponse_RL_ReconfRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationResponse_RL_ReconfRspTDD(tvb, offset, actx, tree, hf_rnsap_id_RL_InformationResponse_RL_ReconfRspTDD);
}
static int dissect_Multiple_RL_InformationResponse_RL_ReconfRspTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationResponse_RL_ReconfRspTDD(tvb, offset, actx, tree, hf_rnsap_Multiple_RL_InformationResponse_RL_ReconfRspTDD_item);
}


static const per_sequence_t RL_InformationResponseList_RL_SetupRspFDD_sequence_of[1] = {
  { &hf_rnsap_RL_InformationResponseList_RL_SetupRspFDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_RL_InformationResponseList_RL_SetupRspFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_InformationResponseList_RL_SetupRspFDD, RL_InformationResponseList_RL_SetupRspFDD_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_id_RL_InformationResponseList_RL_SetupRspFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationResponseList_RL_SetupRspFDD(tvb, offset, actx, tree, hf_rnsap_id_RL_InformationResponseList_RL_SetupRspFDD);
}


static const per_sequence_t RL_ReconfigurationFailure_RL_ReconfFail_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_cause         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Cause },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_ReconfigurationFailure_RL_ReconfFail(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_ReconfigurationFailure_RL_ReconfFail, RL_ReconfigurationFailure_RL_ReconfFail_sequence);

  return offset;
}
static int dissect_id_RL_ReconfigurationFailure_RL_ReconfFail(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_ReconfigurationFailure_RL_ReconfFail(tvb, offset, actx, tree, hf_rnsap_id_RL_ReconfigurationFailure_RL_ReconfFail);
}


static const per_sequence_t RL_Set_InformationItem_DM_Rprt_sequence[] = {
  { &hf_rnsap_rL_Set_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_Set_ID },
  { &hf_rnsap_dedicatedMeasurementValueInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DedicatedMeasurementValueInformation },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Set_InformationItem_DM_Rprt(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Set_InformationItem_DM_Rprt, RL_Set_InformationItem_DM_Rprt_sequence);

  return offset;
}
static int dissect_id_RL_Set_InformationItem_DM_Rprt(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_InformationItem_DM_Rprt(tvb, offset, actx, tree, hf_rnsap_id_RL_Set_InformationItem_DM_Rprt);
}


static const per_sequence_t RL_Set_InformationItem_DM_Rqst_sequence[] = {
  { &hf_rnsap_rL_Set_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_Set_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Set_InformationItem_DM_Rqst(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Set_InformationItem_DM_Rqst, RL_Set_InformationItem_DM_Rqst_sequence);

  return offset;
}
static int dissect_id_RL_Set_InformationItem_DM_Rqst(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_InformationItem_DM_Rqst(tvb, offset, actx, tree, hf_rnsap_id_RL_Set_InformationItem_DM_Rqst);
}


static const per_sequence_t RL_Set_InformationItem_DM_Rsp_sequence[] = {
  { &hf_rnsap_rL_Set_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_Set_ID },
  { &hf_rnsap_dedicatedMeasurementValue, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DedicatedMeasurementValue },
  { &hf_rnsap_cFN           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CFN },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Set_InformationItem_DM_Rsp(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Set_InformationItem_DM_Rsp, RL_Set_InformationItem_DM_Rsp_sequence);

  return offset;
}
static int dissect_id_RL_Set_InformationItem_DM_Rsp(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_InformationItem_DM_Rsp(tvb, offset, actx, tree, hf_rnsap_id_RL_Set_InformationItem_DM_Rsp);
}


static const per_sequence_t RL_Set_Information_RL_FailureInd_sequence[] = {
  { &hf_rnsap_rL_Set_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_Set_ID },
  { &hf_rnsap_cause         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Cause },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Set_Information_RL_FailureInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Set_Information_RL_FailureInd, RL_Set_Information_RL_FailureInd_sequence);

  return offset;
}
static int dissect_id_RL_Set_Information_RL_FailureInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_Information_RL_FailureInd(tvb, offset, actx, tree, hf_rnsap_id_RL_Set_Information_RL_FailureInd);
}


static const per_sequence_t RL_Set_Information_RL_RestoreInd_sequence[] = {
  { &hf_rnsap_rL_Set_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_Set_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Set_Information_RL_RestoreInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Set_Information_RL_RestoreInd, RL_Set_Information_RL_RestoreInd_sequence);

  return offset;
}
static int dissect_id_RL_Set_Information_RL_RestoreInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_Information_RL_RestoreInd(tvb, offset, actx, tree, hf_rnsap_id_RL_Set_Information_RL_RestoreInd);
}


static const per_sequence_t RL_Set_Successful_InformationItem_DM_Fail_sequence[] = {
  { &hf_rnsap_rL_Set_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_Set_ID },
  { &hf_rnsap_dedicatedMeasurementValue, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DedicatedMeasurementValue },
  { &hf_rnsap_cFN           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CFN },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Set_Successful_InformationItem_DM_Fail(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Set_Successful_InformationItem_DM_Fail, RL_Set_Successful_InformationItem_DM_Fail_sequence);

  return offset;
}
static int dissect_id_RL_Set_Successful_InformationItem_DM_Fail(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_Successful_InformationItem_DM_Fail(tvb, offset, actx, tree, hf_rnsap_id_RL_Set_Successful_InformationItem_DM_Fail);
}


static const per_sequence_t RL_Set_Unsuccessful_InformationItem_DM_Fail_sequence[] = {
  { &hf_rnsap_rL_Set_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_Set_ID },
  { &hf_rnsap_individualcause, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Cause },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Set_Unsuccessful_InformationItem_DM_Fail(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Set_Unsuccessful_InformationItem_DM_Fail, RL_Set_Unsuccessful_InformationItem_DM_Fail_sequence);

  return offset;
}
static int dissect_id_RL_Set_Unsuccessful_InformationItem_DM_Fail(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_Unsuccessful_InformationItem_DM_Fail(tvb, offset, actx, tree, hf_rnsap_id_RL_Set_Unsuccessful_InformationItem_DM_Fail);
}


static const per_sequence_t RL_Set_Unsuccessful_InformationItem_DM_Fail_Ind_sequence[] = {
  { &hf_rnsap_rL_Set_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_Set_ID },
  { &hf_rnsap_individualcause, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Cause },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Set_Unsuccessful_InformationItem_DM_Fail_Ind(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Set_Unsuccessful_InformationItem_DM_Fail_Ind, RL_Set_Unsuccessful_InformationItem_DM_Fail_Ind_sequence);

  return offset;
}
static int dissect_id_RL_Set_Unsuccessful_InformationItem_DM_Fail_Ind(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_Unsuccessful_InformationItem_DM_Fail_Ind(tvb, offset, actx, tree, hf_rnsap_id_RL_Set_Unsuccessful_InformationItem_DM_Fail_Ind);
}


static const per_sequence_t RL_Successful_InformationItem_DM_Fail_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_dPCH_ID       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DPCH_ID },
  { &hf_rnsap_dedicatedMeasurementValue, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DedicatedMeasurementValue },
  { &hf_rnsap_cFN           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CFN },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Successful_InformationItem_DM_Fail(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Successful_InformationItem_DM_Fail, RL_Successful_InformationItem_DM_Fail_sequence);

  return offset;
}
static int dissect_id_RL_Successful_InformationItem_DM_Fail(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Successful_InformationItem_DM_Fail(tvb, offset, actx, tree, hf_rnsap_id_RL_Successful_InformationItem_DM_Fail);
}


static const per_sequence_t RL_Unsuccessful_InformationItem_DM_Fail_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_individualcause, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Cause },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Unsuccessful_InformationItem_DM_Fail(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Unsuccessful_InformationItem_DM_Fail, RL_Unsuccessful_InformationItem_DM_Fail_sequence);

  return offset;
}
static int dissect_id_RL_Unsuccessful_InformationItem_DM_Fail(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Unsuccessful_InformationItem_DM_Fail(tvb, offset, actx, tree, hf_rnsap_id_RL_Unsuccessful_InformationItem_DM_Fail);
}


static const per_sequence_t RL_Unsuccessful_InformationItem_DM_Fail_Ind_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_individualcause, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Cause },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Unsuccessful_InformationItem_DM_Fail_Ind(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Unsuccessful_InformationItem_DM_Fail_Ind, RL_Unsuccessful_InformationItem_DM_Fail_Ind_sequence);

  return offset;
}
static int dissect_id_RL_Unsuccessful_InformationItem_DM_Fail_Ind(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Unsuccessful_InformationItem_DM_Fail_Ind(tvb, offset, actx, tree, hf_rnsap_id_RL_Unsuccessful_InformationItem_DM_Fail_Ind);
}



static int
dissect_rnsap_INTEGER_1_6000_(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              1U, 6000U, NULL, TRUE);

  return offset;
}
static int dissect_ten_msec(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_1_6000_(tvb, offset, actx, tree, hf_rnsap_ten_msec);
}



static int
dissect_rnsap_INTEGER_1_60_(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              1U, 60U, NULL, TRUE);

  return offset;
}
static int dissect_min(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_1_60_(tvb, offset, actx, tree, hf_rnsap_min);
}


static const value_string rnsap_ReportPeriodicity_vals[] = {
  {   0, "ten-msec" },
  {   1, "min" },
  { 0, NULL }
};

static const per_choice_t ReportPeriodicity_choice[] = {
  {   0, &hf_rnsap_ten_msec      , ASN1_EXTENSION_ROOT    , dissect_rnsap_INTEGER_1_6000_ },
  {   1, &hf_rnsap_min           , ASN1_EXTENSION_ROOT    , dissect_rnsap_INTEGER_1_60_ },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_ReportPeriodicity(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_ReportPeriodicity, ReportPeriodicity_choice,
                                 NULL);

  return offset;
}
static int dissect_reportPeriodicity(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ReportPeriodicity(tvb, offset, actx, tree, hf_rnsap_reportPeriodicity);
}


static const per_sequence_t Periodic_sequence[] = {
  { &hf_rnsap_reportPeriodicity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ReportPeriodicity },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Periodic(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Periodic, Periodic_sequence);

  return offset;
}
static int dissect_periodic1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Periodic(tvb, offset, actx, tree, hf_rnsap_periodic1);
}



static int
dissect_rnsap_Extension_MeasurementThreshold(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_extension_MeasurementThreshold(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Extension_MeasurementThreshold(tvb, offset, actx, tree, hf_rnsap_extension_MeasurementThreshold);
}


static const value_string rnsap_MeasurementThreshold_vals[] = {
  {   0, "sir" },
  {   1, "sir-error" },
  {   2, "transmitted-code-power" },
  {   3, "rscp" },
  {   4, "rx-timing-deviation" },
  {   5, "round-trip-time" },
  {   6, "extension-MeasurementThreshold" },
  { 0, NULL }
};

static const per_choice_t MeasurementThreshold_choice[] = {
  {   0, &hf_rnsap_sir1          , ASN1_EXTENSION_ROOT    , dissect_rnsap_SIR_Value },
  {   1, &hf_rnsap_sir_error1    , ASN1_EXTENSION_ROOT    , dissect_rnsap_SIR_Error_Value },
  {   2, &hf_rnsap_transmitted_code_power1, ASN1_EXTENSION_ROOT    , dissect_rnsap_Transmitted_Code_Power_Value },
  {   3, &hf_rnsap_rscp1         , ASN1_EXTENSION_ROOT    , dissect_rnsap_RSCP_Value },
  {   4, &hf_rnsap_rx_timing_deviation, ASN1_EXTENSION_ROOT    , dissect_rnsap_Rx_Timing_Deviation_Value },
  {   5, &hf_rnsap_round_trip_time1, ASN1_EXTENSION_ROOT    , dissect_rnsap_Round_Trip_Time_Value },
  {   6, &hf_rnsap_extension_MeasurementThreshold, ASN1_NOT_EXTENSION_ROOT, dissect_rnsap_Extension_MeasurementThreshold },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_MeasurementThreshold(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_MeasurementThreshold, MeasurementThreshold_choice,
                                 NULL);

  return offset;
}
static int dissect_measurementTreshold(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MeasurementThreshold(tvb, offset, actx, tree, hf_rnsap_measurementTreshold);
}
static int dissect_measurementThreshold1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MeasurementThreshold(tvb, offset, actx, tree, hf_rnsap_measurementThreshold1);
}
static int dissect_measurementThreshold2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MeasurementThreshold(tvb, offset, actx, tree, hf_rnsap_measurementThreshold2);
}
static int dissect_measurementThreshold(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MeasurementThreshold(tvb, offset, actx, tree, hf_rnsap_measurementThreshold);
}



static int
dissect_rnsap_MeasurementHysteresisTime(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              1U, 6000U, NULL, TRUE);

  return offset;
}
static int dissect_measurementHysteresisTime(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MeasurementHysteresisTime(tvb, offset, actx, tree, hf_rnsap_measurementHysteresisTime);
}


static const per_sequence_t EventA_sequence[] = {
  { &hf_rnsap_measurementTreshold, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MeasurementThreshold },
  { &hf_rnsap_measurementHysteresisTime, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MeasurementHysteresisTime },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_EventA(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_EventA, EventA_sequence);

  return offset;
}
static int dissect_eventA(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_EventA(tvb, offset, actx, tree, hf_rnsap_eventA);
}


static const per_sequence_t EventB_sequence[] = {
  { &hf_rnsap_measurementTreshold, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MeasurementThreshold },
  { &hf_rnsap_measurementHysteresisTime, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MeasurementHysteresisTime },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_EventB(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_EventB, EventB_sequence);

  return offset;
}
static int dissect_eventB(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_EventB(tvb, offset, actx, tree, hf_rnsap_eventB);
}



static int
dissect_rnsap_SIR_Value_IncrDecrThres(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 62U, NULL, FALSE);

  return offset;
}
static int dissect_sir(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_SIR_Value_IncrDecrThres(tvb, offset, actx, tree, hf_rnsap_sir);
}



static int
dissect_rnsap_SIR_Error_Value_IncrDecrThres(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 124U, NULL, FALSE);

  return offset;
}
static int dissect_sir_error(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_SIR_Error_Value_IncrDecrThres(tvb, offset, actx, tree, hf_rnsap_sir_error);
}



static int
dissect_rnsap_Transmitted_Code_Power_Value_IncrDecrThres(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 112U, NULL, TRUE);

  return offset;
}
static int dissect_transmitted_code_power(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Transmitted_Code_Power_Value_IncrDecrThres(tvb, offset, actx, tree, hf_rnsap_transmitted_code_power);
}



static int
dissect_rnsap_RSCP_Value_IncrDecrThres(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 126U, NULL, FALSE);

  return offset;
}
static int dissect_rscp(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RSCP_Value_IncrDecrThres(tvb, offset, actx, tree, hf_rnsap_rscp);
}



static int
dissect_rnsap_Round_Trip_Time_IncrDecrThres(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 32766U, NULL, FALSE);

  return offset;
}
static int dissect_round_trip_time(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Round_Trip_Time_IncrDecrThres(tvb, offset, actx, tree, hf_rnsap_round_trip_time);
}



static int
dissect_rnsap_Extension_MeasurementIncreaseDecreaseThreshold(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_extension_MeasurementIncreaseDecreaseThreshold(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Extension_MeasurementIncreaseDecreaseThreshold(tvb, offset, actx, tree, hf_rnsap_extension_MeasurementIncreaseDecreaseThreshold);
}


static const value_string rnsap_MeasurementIncreaseDecreaseThreshold_vals[] = {
  {   0, "sir" },
  {   1, "sir-error" },
  {   2, "transmitted-code-power" },
  {   3, "rscp" },
  {   4, "round-trip-time" },
  {   5, "extension-MeasurementIncreaseDecreaseThreshold" },
  { 0, NULL }
};

static const per_choice_t MeasurementIncreaseDecreaseThreshold_choice[] = {
  {   0, &hf_rnsap_sir           , ASN1_EXTENSION_ROOT    , dissect_rnsap_SIR_Value_IncrDecrThres },
  {   1, &hf_rnsap_sir_error     , ASN1_EXTENSION_ROOT    , dissect_rnsap_SIR_Error_Value_IncrDecrThres },
  {   2, &hf_rnsap_transmitted_code_power, ASN1_EXTENSION_ROOT    , dissect_rnsap_Transmitted_Code_Power_Value_IncrDecrThres },
  {   3, &hf_rnsap_rscp          , ASN1_EXTENSION_ROOT    , dissect_rnsap_RSCP_Value_IncrDecrThres },
  {   4, &hf_rnsap_round_trip_time, ASN1_EXTENSION_ROOT    , dissect_rnsap_Round_Trip_Time_IncrDecrThres },
  {   5, &hf_rnsap_extension_MeasurementIncreaseDecreaseThreshold, ASN1_NOT_EXTENSION_ROOT, dissect_rnsap_Extension_MeasurementIncreaseDecreaseThreshold },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_MeasurementIncreaseDecreaseThreshold(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_MeasurementIncreaseDecreaseThreshold, MeasurementIncreaseDecreaseThreshold_choice,
                                 NULL);

  return offset;
}
static int dissect_measurementIncreaseDecreaseThreshold(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MeasurementIncreaseDecreaseThreshold(tvb, offset, actx, tree, hf_rnsap_measurementIncreaseDecreaseThreshold);
}



static int
dissect_rnsap_MeasurementChangeTime(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              1U, 6000U, NULL, TRUE);

  return offset;
}
static int dissect_measurementChangeTime(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MeasurementChangeTime(tvb, offset, actx, tree, hf_rnsap_measurementChangeTime);
}


static const per_sequence_t EventC_sequence[] = {
  { &hf_rnsap_measurementIncreaseDecreaseThreshold, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MeasurementIncreaseDecreaseThreshold },
  { &hf_rnsap_measurementChangeTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MeasurementChangeTime },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_EventC(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_EventC, EventC_sequence);

  return offset;
}
static int dissect_eventC(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_EventC(tvb, offset, actx, tree, hf_rnsap_eventC);
}


static const per_sequence_t EventD_sequence[] = {
  { &hf_rnsap_measurementIncreaseDecreaseThreshold, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MeasurementIncreaseDecreaseThreshold },
  { &hf_rnsap_measurementChangeTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MeasurementChangeTime },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_EventD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_EventD, EventD_sequence);

  return offset;
}
static int dissect_eventD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_EventD(tvb, offset, actx, tree, hf_rnsap_eventD);
}


static const per_sequence_t EventE_sequence[] = {
  { &hf_rnsap_measurementThreshold1, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MeasurementThreshold },
  { &hf_rnsap_measurementThreshold2, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MeasurementThreshold },
  { &hf_rnsap_measurementHysteresisTime, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MeasurementHysteresisTime },
  { &hf_rnsap_reportPeriodicity, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ReportPeriodicity },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_EventE(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_EventE, EventE_sequence);

  return offset;
}
static int dissect_eventE(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_EventE(tvb, offset, actx, tree, hf_rnsap_eventE);
}


static const per_sequence_t EventF_sequence[] = {
  { &hf_rnsap_measurementThreshold1, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MeasurementThreshold },
  { &hf_rnsap_measurementThreshold2, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MeasurementThreshold },
  { &hf_rnsap_measurementHysteresisTime, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MeasurementHysteresisTime },
  { &hf_rnsap_reportPeriodicity, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ReportPeriodicity },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_EventF(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_EventF, EventF_sequence);

  return offset;
}
static int dissect_eventF(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_EventF(tvb, offset, actx, tree, hf_rnsap_eventF);
}



static int
dissect_rnsap_Extension_ReportCharacteristics(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_extension_ReportCharacteristics(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Extension_ReportCharacteristics(tvb, offset, actx, tree, hf_rnsap_extension_ReportCharacteristics);
}


static const value_string rnsap_ReportCharacteristics_vals[] = {
  {   0, "onDemand" },
  {   1, "periodic" },
  {   2, "eventA" },
  {   3, "eventB" },
  {   4, "eventC" },
  {   5, "eventD" },
  {   6, "eventE" },
  {   7, "eventF" },
  {   8, "extension-ReportCharacteristics" },
  { 0, NULL }
};

static const per_choice_t ReportCharacteristics_choice[] = {
  {   0, &hf_rnsap_onDemand      , ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  {   1, &hf_rnsap_periodic1     , ASN1_EXTENSION_ROOT    , dissect_rnsap_Periodic },
  {   2, &hf_rnsap_eventA        , ASN1_EXTENSION_ROOT    , dissect_rnsap_EventA },
  {   3, &hf_rnsap_eventB        , ASN1_EXTENSION_ROOT    , dissect_rnsap_EventB },
  {   4, &hf_rnsap_eventC        , ASN1_EXTENSION_ROOT    , dissect_rnsap_EventC },
  {   5, &hf_rnsap_eventD        , ASN1_EXTENSION_ROOT    , dissect_rnsap_EventD },
  {   6, &hf_rnsap_eventE        , ASN1_EXTENSION_ROOT    , dissect_rnsap_EventE },
  {   7, &hf_rnsap_eventF        , ASN1_EXTENSION_ROOT    , dissect_rnsap_EventF },
  {   8, &hf_rnsap_extension_ReportCharacteristics, ASN1_NOT_EXTENSION_ROOT, dissect_rnsap_Extension_ReportCharacteristics },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_ReportCharacteristics(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_ReportCharacteristics, ReportCharacteristics_choice,
                                 NULL);

  return offset;
}
static int dissect_id_ReportCharacteristics(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ReportCharacteristics(tvb, offset, actx, tree, hf_rnsap_id_ReportCharacteristics);
}


static const per_sequence_t RL_InformationList_RL_FailureInd_sequence_of[1] = {
  { &hf_rnsap_RL_InformationList_RL_FailureInd_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_RL_InformationList_RL_FailureInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_InformationList_RL_FailureInd, RL_InformationList_RL_FailureInd_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_rL_InformationList_RL_FailureInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationList_RL_FailureInd(tvb, offset, actx, tree, hf_rnsap_rL_InformationList_RL_FailureInd);
}


static const per_sequence_t RL_RL_FailureInd_sequence[] = {
  { &hf_rnsap_rL_InformationList_RL_FailureInd, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_InformationList_RL_FailureInd },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_RL_FailureInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_RL_FailureInd, RL_RL_FailureInd_sequence);

  return offset;
}
static int dissect_rL(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_RL_FailureInd(tvb, offset, actx, tree, hf_rnsap_rL);
}


static const per_sequence_t RL_Set_InformationList_RL_FailureInd_sequence_of[1] = {
  { &hf_rnsap_RL_Set_InformationList_RL_FailureInd_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_RL_Set_InformationList_RL_FailureInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_Set_InformationList_RL_FailureInd, RL_Set_InformationList_RL_FailureInd_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_rL_Set_InformationList_RL_FailureInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_InformationList_RL_FailureInd(tvb, offset, actx, tree, hf_rnsap_rL_Set_InformationList_RL_FailureInd);
}


static const per_sequence_t RL_Set_RL_FailureInd_sequence[] = {
  { &hf_rnsap_rL_Set_InformationList_RL_FailureInd, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_Set_InformationList_RL_FailureInd },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Set_RL_FailureInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Set_RL_FailureInd, RL_Set_RL_FailureInd_sequence);

  return offset;
}
static int dissect_rL_Set(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_RL_FailureInd(tvb, offset, actx, tree, hf_rnsap_rL_Set);
}


static const per_sequence_t CCTrCH_InformationList_RL_FailureInd_sequence_of[1] = {
  { &hf_rnsap_CCTrCH_InformationList_RL_FailureInd_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_CCTrCH_InformationList_RL_FailureInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_CCTrCH_InformationList_RL_FailureInd, CCTrCH_InformationList_RL_FailureInd_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_cCTrCH_InformationList_RL_FailureInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CCTrCH_InformationList_RL_FailureInd(tvb, offset, actx, tree, hf_rnsap_cCTrCH_InformationList_RL_FailureInd);
}


static const per_sequence_t CCTrCH_RL_FailureInd_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_cCTrCH_InformationList_RL_FailureInd, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_InformationList_RL_FailureInd },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CCTrCH_RL_FailureInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CCTrCH_RL_FailureInd, CCTrCH_RL_FailureInd_sequence);

  return offset;
}
static int dissect_cCTrCH(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CCTrCH_RL_FailureInd(tvb, offset, actx, tree, hf_rnsap_cCTrCH);
}


static const value_string rnsap_Reporting_Object_RL_FailureInd_vals[] = {
  {   0, "rL" },
  {   1, "rL-Set" },
  {   2, "cCTrCH" },
  { 0, NULL }
};

static const per_choice_t Reporting_Object_RL_FailureInd_choice[] = {
  {   0, &hf_rnsap_rL            , ASN1_EXTENSION_ROOT    , dissect_rnsap_RL_RL_FailureInd },
  {   1, &hf_rnsap_rL_Set        , ASN1_EXTENSION_ROOT    , dissect_rnsap_RL_Set_RL_FailureInd },
  {   2, &hf_rnsap_cCTrCH        , ASN1_NOT_EXTENSION_ROOT, dissect_rnsap_CCTrCH_RL_FailureInd },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_Reporting_Object_RL_FailureInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_Reporting_Object_RL_FailureInd, Reporting_Object_RL_FailureInd_choice,
                                 NULL);

  return offset;
}
static int dissect_id_Reporting_Object_RL_FailureInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Reporting_Object_RL_FailureInd(tvb, offset, actx, tree, hf_rnsap_id_Reporting_Object_RL_FailureInd);
}


static const per_sequence_t RL_InformationList_RL_RestoreInd_sequence_of[1] = {
  { &hf_rnsap_RL_InformationList_RL_RestoreInd_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_RL_InformationList_RL_RestoreInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_InformationList_RL_RestoreInd, RL_InformationList_RL_RestoreInd_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_rL_InformationList_RL_RestoreInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_InformationList_RL_RestoreInd(tvb, offset, actx, tree, hf_rnsap_rL_InformationList_RL_RestoreInd);
}


static const per_sequence_t RL_RL_RestoreInd_sequence[] = {
  { &hf_rnsap_rL_InformationList_RL_RestoreInd, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_InformationList_RL_RestoreInd },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_RL_RestoreInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_RL_RestoreInd, RL_RL_RestoreInd_sequence);

  return offset;
}
static int dissect_rL1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_RL_RestoreInd(tvb, offset, actx, tree, hf_rnsap_rL1);
}


static const per_sequence_t RL_Set_InformationList_RL_RestoreInd_sequence_of[1] = {
  { &hf_rnsap_RL_Set_InformationList_RL_RestoreInd_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_RL_Set_InformationList_RL_RestoreInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_Set_InformationList_RL_RestoreInd, RL_Set_InformationList_RL_RestoreInd_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_rL_Set_InformationList_RL_RestoreInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_InformationList_RL_RestoreInd(tvb, offset, actx, tree, hf_rnsap_rL_Set_InformationList_RL_RestoreInd);
}


static const per_sequence_t RL_Set_RL_RestoreInd_sequence[] = {
  { &hf_rnsap_rL_Set_InformationList_RL_RestoreInd, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_Set_InformationList_RL_RestoreInd },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RL_Set_RL_RestoreInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RL_Set_RL_RestoreInd, RL_Set_RL_RestoreInd_sequence);

  return offset;
}
static int dissect_rL_Set1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_Set_RL_RestoreInd(tvb, offset, actx, tree, hf_rnsap_rL_Set1);
}


static const per_sequence_t CCTrCH_InformationList_RL_RestoreInd_sequence_of[1] = {
  { &hf_rnsap_CCTrCH_InformationList_RL_RestoreInd_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_CCTrCH_InformationList_RL_RestoreInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_CCTrCH_InformationList_RL_RestoreInd, CCTrCH_InformationList_RL_RestoreInd_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_cCTrCH_InformationList_RL_RestoreInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CCTrCH_InformationList_RL_RestoreInd(tvb, offset, actx, tree, hf_rnsap_cCTrCH_InformationList_RL_RestoreInd);
}


static const per_sequence_t CCTrCH_RL_RestoreInd_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_cCTrCH_InformationList_RL_RestoreInd, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_InformationList_RL_RestoreInd },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CCTrCH_RL_RestoreInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CCTrCH_RL_RestoreInd, CCTrCH_RL_RestoreInd_sequence);

  return offset;
}
static int dissect_cCTrCH1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CCTrCH_RL_RestoreInd(tvb, offset, actx, tree, hf_rnsap_cCTrCH1);
}


static const value_string rnsap_Reporting_Object_RL_RestoreInd_vals[] = {
  {   0, "rL" },
  {   1, "rL-Set" },
  {   2, "cCTrCH" },
  { 0, NULL }
};

static const per_choice_t Reporting_Object_RL_RestoreInd_choice[] = {
  {   0, &hf_rnsap_rL1           , ASN1_EXTENSION_ROOT    , dissect_rnsap_RL_RL_RestoreInd },
  {   1, &hf_rnsap_rL_Set1       , ASN1_EXTENSION_ROOT    , dissect_rnsap_RL_Set_RL_RestoreInd },
  {   2, &hf_rnsap_cCTrCH1       , ASN1_NOT_EXTENSION_ROOT, dissect_rnsap_CCTrCH_RL_RestoreInd },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_Reporting_Object_RL_RestoreInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_Reporting_Object_RL_RestoreInd, Reporting_Object_RL_RestoreInd_choice,
                                 NULL);

  return offset;
}
static int dissect_id_Reporing_Object_RL_RestoreInd(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Reporting_Object_RL_RestoreInd(tvb, offset, actx, tree, hf_rnsap_id_Reporing_Object_RL_RestoreInd);
}



static int
dissect_rnsap_RT_Load_Value(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 100U, NULL, FALSE);

  return offset;
}
static int dissect_id_RT_Load_Value(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RT_Load_Value(tvb, offset, actx, tree, hf_rnsap_id_RT_Load_Value);
}



static int
dissect_rnsap_RT_Load_Value_IncrDecrThres(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 100U, NULL, FALSE);

  return offset;
}
static int dissect_id_RT_Load_Value_IncrDecrThres(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RT_Load_Value_IncrDecrThres(tvb, offset, actx, tree, hf_rnsap_id_RT_Load_Value_IncrDecrThres);
}


static const per_sequence_t ContextInfoList_Reset_sequence_of[1] = {
  { &hf_rnsap_ContextInfoList_Reset_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_ContextInfoList_Reset(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_ContextInfoList_Reset, ContextInfoList_Reset_sequence_of,
                                                  1, 250);

  return offset;
}
static int dissect_contextInfoList_Reset(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ContextInfoList_Reset(tvb, offset, actx, tree, hf_rnsap_contextInfoList_Reset);
}


static const per_sequence_t ContextList_Reset_sequence[] = {
  { &hf_rnsap_contextInfoList_Reset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ContextInfoList_Reset },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_ContextList_Reset(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_ContextList_Reset, ContextList_Reset_sequence);

  return offset;
}
static int dissect_context(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ContextList_Reset(tvb, offset, actx, tree, hf_rnsap_context);
}


static const per_sequence_t ContextGroupInfoList_Reset_sequence_of[1] = {
  { &hf_rnsap_ContextGroupInfoList_Reset_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_ContextGroupInfoList_Reset(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_ContextGroupInfoList_Reset, ContextGroupInfoList_Reset_sequence_of,
                                                  1, 32);

  return offset;
}
static int dissect_contextGroupInfoList_Reset(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ContextGroupInfoList_Reset(tvb, offset, actx, tree, hf_rnsap_contextGroupInfoList_Reset);
}


static const per_sequence_t ContextGroupList_Reset_sequence[] = {
  { &hf_rnsap_contextGroupInfoList_Reset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_ContextGroupInfoList_Reset },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_ContextGroupList_Reset(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_ContextGroupList_Reset, ContextGroupList_Reset_sequence);

  return offset;
}
static int dissect_contextGroup(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ContextGroupList_Reset(tvb, offset, actx, tree, hf_rnsap_contextGroup);
}


static const value_string rnsap_ResetIndicator_vals[] = {
  {   0, "context" },
  {   1, "all-contexts" },
  {   2, "contextGroup" },
  { 0, NULL }
};

static const per_choice_t ResetIndicator_choice[] = {
  {   0, &hf_rnsap_context       , ASN1_EXTENSION_ROOT    , dissect_rnsap_ContextList_Reset },
  {   1, &hf_rnsap_all_contexts  , ASN1_EXTENSION_ROOT    , dissect_rnsap_NULL },
  {   2, &hf_rnsap_contextGroup  , ASN1_NOT_EXTENSION_ROOT, dissect_rnsap_ContextGroupList_Reset },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_ResetIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_ResetIndicator, ResetIndicator_choice,
                                 NULL);

  return offset;
}
static int dissect_id_ResetIndicator(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ResetIndicator(tvb, offset, actx, tree, hf_rnsap_id_ResetIndicator);
}



static int
dissect_rnsap_DL_CodeInformationList_RL_AdditionFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_dl_CodeInformation2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CodeInformationList_RL_AdditionFailureFDD(tvb, offset, actx, tree, hf_rnsap_dl_CodeInformation2);
}


static const per_sequence_t Combining_RL_AdditionFailureFDD_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Combining_RL_AdditionFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Combining_RL_AdditionFailureFDD, Combining_RL_AdditionFailureFDD_sequence);

  return offset;
}
static int dissect_combining4(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Combining_RL_AdditionFailureFDD(tvb, offset, actx, tree, hf_rnsap_combining4);
}


static const per_sequence_t NonCombining_RL_AdditionFailureFDD_sequence[] = {
  { &hf_rnsap_dCH_InformationResponse, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_InformationResponse },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_NonCombining_RL_AdditionFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_NonCombining_RL_AdditionFailureFDD, NonCombining_RL_AdditionFailureFDD_sequence);

  return offset;
}
static int dissect_nonCombining2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NonCombining_RL_AdditionFailureFDD(tvb, offset, actx, tree, hf_rnsap_nonCombining2);
}


static const value_string rnsap_DiversityIndication_RL_AdditionFailureFDD_vals[] = {
  {   0, "combining" },
  {   1, "nonCombining" },
  { 0, NULL }
};

static const per_choice_t DiversityIndication_RL_AdditionFailureFDD_choice[] = {
  {   0, &hf_rnsap_combining4    , ASN1_NO_EXTENSIONS     , dissect_rnsap_Combining_RL_AdditionFailureFDD },
  {   1, &hf_rnsap_nonCombining2 , ASN1_NO_EXTENSIONS     , dissect_rnsap_NonCombining_RL_AdditionFailureFDD },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_DiversityIndication_RL_AdditionFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_DiversityIndication_RL_AdditionFailureFDD, DiversityIndication_RL_AdditionFailureFDD_choice,
                                 NULL);

  return offset;
}
static int dissect_diversityIndication5(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DiversityIndication_RL_AdditionFailureFDD(tvb, offset, actx, tree, hf_rnsap_diversityIndication5);
}


static const per_sequence_t SuccessfulRL_InformationResponse_RL_AdditionFailureFDD_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_rL_Set_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_Set_ID },
  { &hf_rnsap_uRA_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_URA_Information },
  { &hf_rnsap_sAI           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SAI },
  { &hf_rnsap_gA_Cell       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GA_Cell },
  { &hf_rnsap_gA_AccessPointPosition, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GA_AccessPointPosition },
  { &hf_rnsap_received_total_wide_band_power, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Received_total_wide_band_power },
  { &hf_rnsap_not_Used_secondary_CCPCH_Info, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_NULL },
  { &hf_rnsap_dl_CodeInformation2, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_CodeInformationList_RL_AdditionFailureFDD },
  { &hf_rnsap_diversityIndication5, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DiversityIndication_RL_AdditionFailureFDD },
  { &hf_rnsap_sSDT_SupportIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SSDT_SupportIndicator },
  { &hf_rnsap_minUL_SIR     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_SIR },
  { &hf_rnsap_maxUL_SIR     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_SIR },
  { &hf_rnsap_closedlooptimingadjustmentmode, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Closedlooptimingadjustmentmode },
  { &hf_rnsap_maximumAllowedULTxPower, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MaximumAllowedULTxPower },
  { &hf_rnsap_maximumDLTxPower, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_Power },
  { &hf_rnsap_minimumDLTxPower, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_Power },
  { &hf_rnsap_neighbouring_UMTS_CellInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Neighbouring_UMTS_CellInformation },
  { &hf_rnsap_neighbouring_GSM_CellInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Neighbouring_GSM_CellInformation },
  { &hf_rnsap_primaryCPICH_Power, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PrimaryCPICH_Power },
  { &hf_rnsap_pC_Preamble   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PC_Preamble },
  { &hf_rnsap_sRB_Delay     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SRB_Delay },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_SuccessfulRL_InformationResponse_RL_AdditionFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_SuccessfulRL_InformationResponse_RL_AdditionFailureFDD, SuccessfulRL_InformationResponse_RL_AdditionFailureFDD_sequence);

  return offset;
}
static int dissect_id_SuccessfulRL_InformationResponse_RL_AdditionFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_SuccessfulRL_InformationResponse_RL_AdditionFailureFDD(tvb, offset, actx, tree, hf_rnsap_id_SuccessfulRL_InformationResponse_RL_AdditionFailureFDD);
}


static const per_sequence_t Combining_RL_SetupFailureFDD_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Combining_RL_SetupFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Combining_RL_SetupFailureFDD, Combining_RL_SetupFailureFDD_sequence);

  return offset;
}
static int dissect_combining1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Combining_RL_SetupFailureFDD(tvb, offset, actx, tree, hf_rnsap_combining1);
}


static const per_sequence_t NonCombiningOrFirstRL_RL_SetupFailureFDD_sequence[] = {
  { &hf_rnsap_dCH_InformationResponse, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DCH_InformationResponse },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_NonCombiningOrFirstRL_RL_SetupFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_NonCombiningOrFirstRL_RL_SetupFailureFDD, NonCombiningOrFirstRL_RL_SetupFailureFDD_sequence);

  return offset;
}
static int dissect_nonCombiningOrFirstRL1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_NonCombiningOrFirstRL_RL_SetupFailureFDD(tvb, offset, actx, tree, hf_rnsap_nonCombiningOrFirstRL1);
}


static const value_string rnsap_DiversityIndication_RL_SetupFailureFDD_vals[] = {
  {   0, "combining" },
  {   1, "nonCombiningOrFirstRL" },
  { 0, NULL }
};

static const per_choice_t DiversityIndication_RL_SetupFailureFDD_choice[] = {
  {   0, &hf_rnsap_combining1    , ASN1_NO_EXTENSIONS     , dissect_rnsap_Combining_RL_SetupFailureFDD },
  {   1, &hf_rnsap_nonCombiningOrFirstRL1, ASN1_NO_EXTENSIONS     , dissect_rnsap_NonCombiningOrFirstRL_RL_SetupFailureFDD },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_DiversityIndication_RL_SetupFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_DiversityIndication_RL_SetupFailureFDD, DiversityIndication_RL_SetupFailureFDD_choice,
                                 NULL);

  return offset;
}
static int dissect_diversityIndication1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DiversityIndication_RL_SetupFailureFDD(tvb, offset, actx, tree, hf_rnsap_diversityIndication1);
}


static const per_sequence_t SuccessfulRL_InformationResponse_RL_SetupFailureFDD_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_rL_Set_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_Set_ID },
  { &hf_rnsap_uRA_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_URA_Information },
  { &hf_rnsap_sAI           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SAI },
  { &hf_rnsap_gA_Cell       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GA_Cell },
  { &hf_rnsap_gA_AccessPointPosition, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GA_AccessPointPosition },
  { &hf_rnsap_received_total_wide_band_power, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Received_total_wide_band_power },
  { &hf_rnsap_not_Used_secondary_CCPCH_Info, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_NULL },
  { &hf_rnsap_dl_CodeInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_FDD_DL_CodeInformation },
  { &hf_rnsap_diversityIndication1, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DiversityIndication_RL_SetupFailureFDD },
  { &hf_rnsap_sSDT_SupportIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SSDT_SupportIndicator },
  { &hf_rnsap_maxUL_SIR     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_SIR },
  { &hf_rnsap_minUL_SIR     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_SIR },
  { &hf_rnsap_closedlooptimingadjustmentmode, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Closedlooptimingadjustmentmode },
  { &hf_rnsap_maximumAllowedULTxPower, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MaximumAllowedULTxPower },
  { &hf_rnsap_maximumDLTxPower, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_Power },
  { &hf_rnsap_minimumDLTxPower, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_Power },
  { &hf_rnsap_primaryCPICH_Power, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PrimaryCPICH_Power },
  { &hf_rnsap_primaryScramblingCode, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_PrimaryScramblingCode },
  { &hf_rnsap_uL_UARFCN     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UARFCN },
  { &hf_rnsap_dL_UARFCN     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UARFCN },
  { &hf_rnsap_not_Used_dSCH_InformationResponse_RL_SetupFailureFDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_NULL },
  { &hf_rnsap_neighbouring_UMTS_CellInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Neighbouring_UMTS_CellInformation },
  { &hf_rnsap_neighbouring_GSM_CellInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Neighbouring_GSM_CellInformation },
  { &hf_rnsap_pC_Preamble   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PC_Preamble },
  { &hf_rnsap_sRB_Delay     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SRB_Delay },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_SuccessfulRL_InformationResponse_RL_SetupFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_SuccessfulRL_InformationResponse_RL_SetupFailureFDD, SuccessfulRL_InformationResponse_RL_SetupFailureFDD_sequence);

  return offset;
}
static int dissect_id_SuccessfulRL_InformationResponse_RL_SetupFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_SuccessfulRL_InformationResponse_RL_SetupFailureFDD(tvb, offset, actx, tree, hf_rnsap_id_SuccessfulRL_InformationResponse_RL_SetupFailureFDD);
}



static int
dissect_rnsap_TransportBearerID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 4095U, NULL, FALSE);

  return offset;
}
static int dissect_id_TransportBearerID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TransportBearerID(tvb, offset, actx, tree, hf_rnsap_id_TransportBearerID);
}


static const value_string rnsap_TypeOfError_vals[] = {
  {   0, "not-understood" },
  {   1, "missing" },
  { 0, NULL }
};


static int
dissect_rnsap_TypeOfError(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_id_TypeOfError(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TypeOfError(tvb, offset, actx, tree, hf_rnsap_id_TypeOfError);
}


static const per_sequence_t UC_ID_sequence[] = {
  { &hf_rnsap_rNC_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RNC_ID },
  { &hf_rnsap_c_ID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_C_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UC_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UC_ID, UC_ID_sequence);

  return offset;
}
static int dissect_id_UC_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UC_ID(tvb, offset, actx, tree, hf_rnsap_id_UC_ID);
}
static int dissect_uC_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UC_ID(tvb, offset, actx, tree, hf_rnsap_uC_ID);
}


static const per_sequence_t UL_CCTrCH_AddInformation_RL_ReconfPrepTDD_sequence[] = {
  { &hf_rnsap_cCTrCH_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_tFCS          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCS },
  { &hf_rnsap_tFCI_Coding   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCI_Coding },
  { &hf_rnsap_punctureLimit , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PunctureLimit },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UL_CCTrCH_AddInformation_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UL_CCTrCH_AddInformation_RL_ReconfPrepTDD, UL_CCTrCH_AddInformation_RL_ReconfPrepTDD_sequence);

  return offset;
}
static int dissect_id_UL_CCTrCH_AddInformation_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_CCTrCH_AddInformation_RL_ReconfPrepTDD(tvb, offset, actx, tree, hf_rnsap_id_UL_CCTrCH_AddInformation_RL_ReconfPrepTDD);
}


static const per_sequence_t UL_CCTrCH_InformationAddList_RL_ReconfPrepTDD_sequence_of[1] = {
  { &hf_rnsap_UL_CCTrCH_InformationAddList_RL_ReconfPrepTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_UL_CCTrCH_InformationAddList_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_UL_CCTrCH_InformationAddList_RL_ReconfPrepTDD, UL_CCTrCH_InformationAddList_RL_ReconfPrepTDD_sequence_of,
                                                  0, 16);

  return offset;
}
static int dissect_id_UL_CCTrCH_InformationAddList_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_CCTrCH_InformationAddList_RL_ReconfPrepTDD(tvb, offset, actx, tree, hf_rnsap_id_UL_CCTrCH_InformationAddList_RL_ReconfPrepTDD);
}


static const per_sequence_t UL_CCTrCH_InformationItem_RL_SetupRqstTDD_sequence[] = {
  { &hf_rnsap_cCTrCH_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_ul_TFCS       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCS },
  { &hf_rnsap_tFCI_Coding   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCI_Coding },
  { &hf_rnsap_ul_PunctureLimit, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PunctureLimit },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UL_CCTrCH_InformationItem_RL_SetupRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UL_CCTrCH_InformationItem_RL_SetupRqstTDD, UL_CCTrCH_InformationItem_RL_SetupRqstTDD_sequence);

  return offset;
}
static int dissect_id_UL_CCTrCH_InformationItem_RL_SetupRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_CCTrCH_InformationItem_RL_SetupRqstTDD(tvb, offset, actx, tree, hf_rnsap_id_UL_CCTrCH_InformationItem_RL_SetupRqstTDD);
}


static const per_sequence_t UL_CCTrCH_InformationList_RL_SetupRqstTDD_sequence_of[1] = {
  { &hf_rnsap_UL_CCTrCH_InformationList_RL_SetupRqstTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_UL_CCTrCH_InformationList_RL_SetupRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_UL_CCTrCH_InformationList_RL_SetupRqstTDD, UL_CCTrCH_InformationList_RL_SetupRqstTDD_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_id_UL_CCTrCH_InformationList_RL_SetupRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_CCTrCH_InformationList_RL_SetupRqstTDD(tvb, offset, actx, tree, hf_rnsap_id_UL_CCTrCH_InformationList_RL_SetupRqstTDD);
}



static int
dissect_rnsap_UL_DPCH_InformationList_PhyChReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_ul_DPCH_Information2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_DPCH_InformationList_PhyChReconfRqstTDD(tvb, offset, actx, tree, hf_rnsap_ul_DPCH_Information2);
}


static const per_sequence_t UL_CCTrCH_InformationItem_PhyChReconfRqstTDD_sequence[] = {
  { &hf_rnsap_cCTrCH_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_ul_DPCH_Information2, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_DPCH_InformationList_PhyChReconfRqstTDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UL_CCTrCH_InformationItem_PhyChReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UL_CCTrCH_InformationItem_PhyChReconfRqstTDD, UL_CCTrCH_InformationItem_PhyChReconfRqstTDD_sequence);

  return offset;
}
static int dissect_UL_CCTrCH_InformationListIE_PhyChReconfRqstTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_CCTrCH_InformationItem_PhyChReconfRqstTDD(tvb, offset, actx, tree, hf_rnsap_UL_CCTrCH_InformationListIE_PhyChReconfRqstTDD_item);
}


static const per_sequence_t UL_CCTrCH_InformationListIE_PhyChReconfRqstTDD_sequence_of[1] = {
  { &hf_rnsap_UL_CCTrCH_InformationListIE_PhyChReconfRqstTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_CCTrCH_InformationItem_PhyChReconfRqstTDD },
};

static int
dissect_rnsap_UL_CCTrCH_InformationListIE_PhyChReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_UL_CCTrCH_InformationListIE_PhyChReconfRqstTDD, UL_CCTrCH_InformationListIE_PhyChReconfRqstTDD_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_id_UL_CCTrCH_InformationListIE_PhyChReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_CCTrCH_InformationListIE_PhyChReconfRqstTDD(tvb, offset, actx, tree, hf_rnsap_id_UL_CCTrCH_InformationListIE_PhyChReconfRqstTDD);
}



static int
dissect_rnsap_UL_DPCH_InformationList_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_ul_DPCH_Information1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_DPCH_InformationList_RL_AdditionRspTDD(tvb, offset, actx, tree, hf_rnsap_ul_DPCH_Information1);
}


static const per_sequence_t UL_CCTrCHInformationItem_RL_AdditionRspTDD_sequence[] = {
  { &hf_rnsap_cCTrCH_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_ul_DPCH_Information1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UL_DPCH_InformationList_RL_AdditionRspTDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UL_CCTrCHInformationItem_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UL_CCTrCHInformationItem_RL_AdditionRspTDD, UL_CCTrCHInformationItem_RL_AdditionRspTDD_sequence);

  return offset;
}
static int dissect_UL_CCTrCHInformationListIE_RL_AdditionRspTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_CCTrCHInformationItem_RL_AdditionRspTDD(tvb, offset, actx, tree, hf_rnsap_UL_CCTrCHInformationListIE_RL_AdditionRspTDD_item);
}


static const per_sequence_t UL_CCTrCHInformationListIE_RL_AdditionRspTDD_sequence_of[1] = {
  { &hf_rnsap_UL_CCTrCHInformationListIE_RL_AdditionRspTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_CCTrCHInformationItem_RL_AdditionRspTDD },
};

static int
dissect_rnsap_UL_CCTrCHInformationListIE_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_UL_CCTrCHInformationListIE_RL_AdditionRspTDD, UL_CCTrCHInformationListIE_RL_AdditionRspTDD_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_id_UL_CCTrCH_InformationListIE_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_CCTrCHInformationListIE_RL_AdditionRspTDD(tvb, offset, actx, tree, hf_rnsap_id_UL_CCTrCH_InformationListIE_RL_AdditionRspTDD);
}



static int
dissect_rnsap_UL_DPCH_InformationAddList_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_ul_DPCH_AddInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_DPCH_InformationAddList_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_ul_DPCH_AddInformation);
}



static int
dissect_rnsap_UL_DPCH_InformationModifyList_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_ul_DPCH_ModifyInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_DPCH_InformationModifyList_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_ul_DPCH_ModifyInformation);
}



static int
dissect_rnsap_UL_DPCH_InformationDeleteList_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_ul_DPCH_DeleteInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_DPCH_InformationDeleteList_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_ul_DPCH_DeleteInformation);
}


static const per_sequence_t UL_CCTrCH_InformationItem_RL_ReconfReadyTDD_sequence[] = {
  { &hf_rnsap_cCTrCH_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_ul_DPCH_AddInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UL_DPCH_InformationAddList_RL_ReconfReadyTDD },
  { &hf_rnsap_ul_DPCH_ModifyInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UL_DPCH_InformationModifyList_RL_ReconfReadyTDD },
  { &hf_rnsap_ul_DPCH_DeleteInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UL_DPCH_InformationDeleteList_RL_ReconfReadyTDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UL_CCTrCH_InformationItem_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UL_CCTrCH_InformationItem_RL_ReconfReadyTDD, UL_CCTrCH_InformationItem_RL_ReconfReadyTDD_sequence);

  return offset;
}
static int dissect_UL_CCTrCHInformationListIE_RL_ReconfReadyTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_CCTrCH_InformationItem_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_UL_CCTrCHInformationListIE_RL_ReconfReadyTDD_item);
}


static const per_sequence_t UL_CCTrCHInformationListIE_RL_ReconfReadyTDD_sequence_of[1] = {
  { &hf_rnsap_UL_CCTrCHInformationListIE_RL_ReconfReadyTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_CCTrCH_InformationItem_RL_ReconfReadyTDD },
};

static int
dissect_rnsap_UL_CCTrCHInformationListIE_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_UL_CCTrCHInformationListIE_RL_ReconfReadyTDD, UL_CCTrCHInformationListIE_RL_ReconfReadyTDD_sequence_of,
                                                  0, 16);

  return offset;
}
static int dissect_id_UL_CCTrCH_InformationListIE_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_CCTrCHInformationListIE_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_id_UL_CCTrCH_InformationListIE_RL_ReconfReadyTDD);
}



static int
dissect_rnsap_UL_DPCH_InformationList_RL_SetupRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_ul_DPCH_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_DPCH_InformationList_RL_SetupRspTDD(tvb, offset, actx, tree, hf_rnsap_ul_DPCH_Information);
}


static const per_sequence_t UL_CCTrCHInformationItem_RL_SetupRspTDD_sequence[] = {
  { &hf_rnsap_cCTrCH_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_ul_DPCH_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UL_DPCH_InformationList_RL_SetupRspTDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UL_CCTrCHInformationItem_RL_SetupRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UL_CCTrCHInformationItem_RL_SetupRspTDD, UL_CCTrCHInformationItem_RL_SetupRspTDD_sequence);

  return offset;
}
static int dissect_UL_CCTrCHInformationListIE_RL_SetupRspTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_CCTrCHInformationItem_RL_SetupRspTDD(tvb, offset, actx, tree, hf_rnsap_UL_CCTrCHInformationListIE_RL_SetupRspTDD_item);
}


static const per_sequence_t UL_CCTrCHInformationListIE_RL_SetupRspTDD_sequence_of[1] = {
  { &hf_rnsap_UL_CCTrCHInformationListIE_RL_SetupRspTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_CCTrCHInformationItem_RL_SetupRspTDD },
};

static int
dissect_rnsap_UL_CCTrCHInformationListIE_RL_SetupRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_UL_CCTrCHInformationListIE_RL_SetupRspTDD, UL_CCTrCHInformationListIE_RL_SetupRspTDD_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_id_UL_CCTrCH_InformationListIE_RL_SetupRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_CCTrCHInformationListIE_RL_SetupRspTDD(tvb, offset, actx, tree, hf_rnsap_id_UL_CCTrCH_InformationListIE_RL_SetupRspTDD);
}



static int
dissect_rnsap_UL_ScramblingCodeNumber(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 16777215U, NULL, FALSE);

  return offset;
}
static int dissect_ul_ScramblingCodeNumber(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_ScramblingCodeNumber(tvb, offset, actx, tree, hf_rnsap_ul_ScramblingCodeNumber);
}


static const value_string rnsap_UL_ScramblingCodeLength_vals[] = {
  {   0, "short" },
  {   1, "long" },
  { 0, NULL }
};


static int
dissect_rnsap_UL_ScramblingCodeLength(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_ul_ScramblingCodeLength(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_ScramblingCodeLength(tvb, offset, actx, tree, hf_rnsap_ul_ScramblingCodeLength);
}


static const per_sequence_t UL_ScramblingCode_sequence[] = {
  { &hf_rnsap_ul_ScramblingCodeNumber, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_ScramblingCodeNumber },
  { &hf_rnsap_ul_ScramblingCodeLength, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_ScramblingCodeLength },
  { &hf_rnsap_iE_Extensions , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UL_ScramblingCode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UL_ScramblingCode, UL_ScramblingCode_sequence);

  return offset;
}
static int dissect_ul_ScramblingCode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_ScramblingCode(tvb, offset, actx, tree, hf_rnsap_ul_ScramblingCode);
}


static const value_string rnsap_MinUL_ChannelisationCodeLength_vals[] = {
  {   0, "v4" },
  {   1, "v8" },
  {   2, "v16" },
  {   3, "v32" },
  {   4, "v64" },
  {   5, "v128" },
  {   6, "v256" },
  { 0, NULL }
};


static int
dissect_rnsap_MinUL_ChannelisationCodeLength(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_minUL_ChannelisationCodeLength(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MinUL_ChannelisationCodeLength(tvb, offset, actx, tree, hf_rnsap_minUL_ChannelisationCodeLength);
}



static int
dissect_rnsap_MaxNrOfUL_DPCHs(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              1U, 6U, NULL, FALSE);

  return offset;
}
static int dissect_maxNrOfUL_DPCHs(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MaxNrOfUL_DPCHs(tvb, offset, actx, tree, hf_rnsap_maxNrOfUL_DPCHs);
}
static int dissect_maxNrOfUL_DPDCHs(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_MaxNrOfUL_DPCHs(tvb, offset, actx, tree, hf_rnsap_maxNrOfUL_DPDCHs);
}



static int
dissect_rnsap_UL_DPCCH_SlotFormat(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 5U, NULL, TRUE);

  return offset;
}
static int dissect_ul_DPCCH_SlotFormat(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_DPCCH_SlotFormat(tvb, offset, actx, tree, hf_rnsap_ul_DPCCH_SlotFormat);
}


static const value_string rnsap_DiversityMode_vals[] = {
  {   0, "none" },
  {   1, "sTTD" },
  {   2, "closedLoopMode1" },
  {   3, "not-used-closedLoopMode2" },
  { 0, NULL }
};


static int
dissect_rnsap_DiversityMode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_diversityMode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DiversityMode(tvb, offset, actx, tree, hf_rnsap_diversityMode);
}


static const per_sequence_t UL_DPCH_Information_RL_ReconfPrepFDD_sequence[] = {
  { &hf_rnsap_ul_ScramblingCode, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UL_ScramblingCode },
  { &hf_rnsap_ul_SIRTarget  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UL_SIR },
  { &hf_rnsap_minUL_ChannelisationCodeLength, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MinUL_ChannelisationCodeLength },
  { &hf_rnsap_maxNrOfUL_DPDCHs, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MaxNrOfUL_DPCHs },
  { &hf_rnsap_ul_PunctureLimit, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_PunctureLimit },
  { &hf_rnsap_tFCS          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TFCS },
  { &hf_rnsap_ul_DPCCH_SlotFormat, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UL_DPCCH_SlotFormat },
  { &hf_rnsap_diversityMode , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DiversityMode },
  { &hf_rnsap_not_Used_sSDT_CellIDLength, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_NULL },
  { &hf_rnsap_not_Used_s_FieldLength, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_NULL },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UL_DPCH_Information_RL_ReconfPrepFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UL_DPCH_Information_RL_ReconfPrepFDD, UL_DPCH_Information_RL_ReconfPrepFDD_sequence);

  return offset;
}
static int dissect_id_UL_DPCH_Information_RL_ReconfPrepFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_DPCH_Information_RL_ReconfPrepFDD(tvb, offset, actx, tree, hf_rnsap_id_UL_DPCH_Information_RL_ReconfPrepFDD);
}


static const per_sequence_t UL_DPCH_Information_RL_ReconfRqstFDD_sequence[] = {
  { &hf_rnsap_tFCS          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TFCS },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UL_DPCH_Information_RL_ReconfRqstFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UL_DPCH_Information_RL_ReconfRqstFDD, UL_DPCH_Information_RL_ReconfRqstFDD_sequence);

  return offset;
}
static int dissect_id_UL_DPCH_Information_RL_ReconfRqstFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_DPCH_Information_RL_ReconfRqstFDD(tvb, offset, actx, tree, hf_rnsap_id_UL_DPCH_Information_RL_ReconfRqstFDD);
}


static const per_sequence_t UL_DPCH_Information_RL_SetupRqstFDD_sequence[] = {
  { &hf_rnsap_ul_ScramblingCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_ScramblingCode },
  { &hf_rnsap_minUL_ChannelisationCodeLength, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MinUL_ChannelisationCodeLength },
  { &hf_rnsap_maxNrOfUL_DPCHs, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MaxNrOfUL_DPCHs },
  { &hf_rnsap_ul_PunctureLimit, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_PunctureLimit },
  { &hf_rnsap_ul_TFCS       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCS },
  { &hf_rnsap_ul_DPCCH_SlotFormat, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_DPCCH_SlotFormat },
  { &hf_rnsap_ul_SIRTarget  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UL_SIR },
  { &hf_rnsap_diversityMode , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DiversityMode },
  { &hf_rnsap_not_Used_sSDT_CellIdLength, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_NULL },
  { &hf_rnsap_not_Used_s_FieldLength, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_NULL },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UL_DPCH_Information_RL_SetupRqstFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UL_DPCH_Information_RL_SetupRqstFDD, UL_DPCH_Information_RL_SetupRqstFDD_sequence);

  return offset;
}
static int dissect_id_UL_DPCH_Information_RL_SetupRqstFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_DPCH_Information_RL_SetupRqstFDD(tvb, offset, actx, tree, hf_rnsap_id_UL_DPCH_Information_RL_SetupRqstFDD);
}


static const per_sequence_t TDD_UL_Code_InformationItem_sequence[] = {
  { &hf_rnsap_dPCH_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DPCH_ID },
  { &hf_rnsap_tDD_ChannelisationCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_ChannelisationCode },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TDD_UL_Code_InformationItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TDD_UL_Code_InformationItem, TDD_UL_Code_InformationItem_sequence);

  return offset;
}
static int dissect_TDD_UL_Code_Information_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TDD_UL_Code_InformationItem(tvb, offset, actx, tree, hf_rnsap_TDD_UL_Code_Information_item);
}


static const per_sequence_t TDD_UL_Code_Information_sequence_of[1] = {
  { &hf_rnsap_TDD_UL_Code_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_UL_Code_InformationItem },
};

static int
dissect_rnsap_TDD_UL_Code_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_TDD_UL_Code_Information, TDD_UL_Code_Information_sequence_of,
                                                  1, 240);

  return offset;
}
static int dissect_uL_Code_Information1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TDD_UL_Code_Information(tvb, offset, actx, tree, hf_rnsap_uL_Code_Information1);
}


static const per_sequence_t UL_Timeslot_InformationItem_PhyChReconfRqstTDD_sequence[] = {
  { &hf_rnsap_timeSlot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlot },
  { &hf_rnsap_midambleShiftAndBurstType, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MidambleShiftAndBurstType },
  { &hf_rnsap_tFCI_Presence , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TFCI_Presence },
  { &hf_rnsap_uL_Code_Information1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TDD_UL_Code_Information },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UL_Timeslot_InformationItem_PhyChReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UL_Timeslot_InformationItem_PhyChReconfRqstTDD, UL_Timeslot_InformationItem_PhyChReconfRqstTDD_sequence);

  return offset;
}
static int dissect_UL_Timeslot_InformationList_PhyChReconfRqstTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_Timeslot_InformationItem_PhyChReconfRqstTDD(tvb, offset, actx, tree, hf_rnsap_UL_Timeslot_InformationList_PhyChReconfRqstTDD_item);
}


static const per_sequence_t UL_Timeslot_InformationList_PhyChReconfRqstTDD_sequence_of[1] = {
  { &hf_rnsap_UL_Timeslot_InformationList_PhyChReconfRqstTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_Timeslot_InformationItem_PhyChReconfRqstTDD },
};

static int
dissect_rnsap_UL_Timeslot_InformationList_PhyChReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_UL_Timeslot_InformationList_PhyChReconfRqstTDD, UL_Timeslot_InformationList_PhyChReconfRqstTDD_sequence_of,
                                                  1, 15);

  return offset;
}
static int dissect_uL_Timeslot_InformationList_PhyChReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_Timeslot_InformationList_PhyChReconfRqstTDD(tvb, offset, actx, tree, hf_rnsap_uL_Timeslot_InformationList_PhyChReconfRqstTDD);
}


static const per_sequence_t UL_DPCH_InformationItem_PhyChReconfRqstTDD_sequence[] = {
  { &hf_rnsap_repetitionPeriod, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_RepetitionPeriod },
  { &hf_rnsap_repetitionLength, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_RepetitionLength },
  { &hf_rnsap_tDD_DPCHOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TDD_DPCHOffset },
  { &hf_rnsap_uL_Timeslot_InformationList_PhyChReconfRqstTDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UL_Timeslot_InformationList_PhyChReconfRqstTDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UL_DPCH_InformationItem_PhyChReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UL_DPCH_InformationItem_PhyChReconfRqstTDD, UL_DPCH_InformationItem_PhyChReconfRqstTDD_sequence);

  return offset;
}
static int dissect_id_UL_DPCH_InformationItem_PhyChReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_DPCH_InformationItem_PhyChReconfRqstTDD(tvb, offset, actx, tree, hf_rnsap_id_UL_DPCH_InformationItem_PhyChReconfRqstTDD);
}


static const per_sequence_t UL_Timeslot_InformationItem_sequence[] = {
  { &hf_rnsap_timeSlot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlot },
  { &hf_rnsap_midambleShiftAndBurstType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MidambleShiftAndBurstType },
  { &hf_rnsap_tFCI_Presence , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TFCI_Presence },
  { &hf_rnsap_uL_Code_Information1, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_UL_Code_Information },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UL_Timeslot_InformationItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UL_Timeslot_InformationItem, UL_Timeslot_InformationItem_sequence);

  return offset;
}
static int dissect_UL_Timeslot_Information_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_Timeslot_InformationItem(tvb, offset, actx, tree, hf_rnsap_UL_Timeslot_Information_item);
}


static const per_sequence_t UL_Timeslot_Information_sequence_of[1] = {
  { &hf_rnsap_UL_Timeslot_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_Timeslot_InformationItem },
};

static int
dissect_rnsap_UL_Timeslot_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_UL_Timeslot_Information, UL_Timeslot_Information_sequence_of,
                                                  1, 15);

  return offset;
}
static int dissect_uL_Timeslot_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_Timeslot_Information(tvb, offset, actx, tree, hf_rnsap_uL_Timeslot_Information);
}


static const per_sequence_t UL_DPCH_InformationItem_RL_AdditionRspTDD_sequence[] = {
  { &hf_rnsap_repetitionPeriod, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RepetitionPeriod },
  { &hf_rnsap_repetitionLength, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RepetitionLength },
  { &hf_rnsap_tDD_DPCHOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_DPCHOffset },
  { &hf_rnsap_uL_Timeslot_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_Timeslot_Information },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UL_DPCH_InformationItem_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UL_DPCH_InformationItem_RL_AdditionRspTDD, UL_DPCH_InformationItem_RL_AdditionRspTDD_sequence);

  return offset;
}
static int dissect_id_UL_DPCH_InformationItem_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_DPCH_InformationItem_RL_AdditionRspTDD(tvb, offset, actx, tree, hf_rnsap_id_UL_DPCH_InformationItem_RL_AdditionRspTDD);
}


static const per_sequence_t UL_DPCH_InformationItem_RL_SetupRspTDD_sequence[] = {
  { &hf_rnsap_repetitionPeriod, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RepetitionPeriod },
  { &hf_rnsap_repetitionLength, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RepetitionLength },
  { &hf_rnsap_tDD_DPCHOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_DPCHOffset },
  { &hf_rnsap_uL_Timeslot_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_Timeslot_Information },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UL_DPCH_InformationItem_RL_SetupRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UL_DPCH_InformationItem_RL_SetupRspTDD, UL_DPCH_InformationItem_RL_SetupRspTDD_sequence);

  return offset;
}
static int dissect_id_UL_DPCH_InformationItem_RL_SetupRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_DPCH_InformationItem_RL_SetupRspTDD(tvb, offset, actx, tree, hf_rnsap_id_UL_DPCH_InformationItem_RL_SetupRspTDD);
}



static int
dissect_rnsap_RxTimingDeviationForTA(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 127U, NULL, FALSE);

  return offset;
}
static int dissect_id_RxTimingDeviationForTA(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RxTimingDeviationForTA(tvb, offset, actx, tree, hf_rnsap_id_RxTimingDeviationForTA);
}
static int dissect_rxTimingDeviationForTA(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RxTimingDeviationForTA(tvb, offset, actx, tree, hf_rnsap_rxTimingDeviationForTA);
}


static const per_sequence_t UL_DPCH_InformationAddListIE_RL_ReconfReadyTDD_sequence[] = {
  { &hf_rnsap_repetitionPeriod, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RepetitionPeriod },
  { &hf_rnsap_repetitionLength, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RepetitionLength },
  { &hf_rnsap_tDD_DPCHOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_DPCHOffset },
  { &hf_rnsap_rxTimingDeviationForTA, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_RxTimingDeviationForTA },
  { &hf_rnsap_uL_Timeslot_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_Timeslot_Information },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UL_DPCH_InformationAddListIE_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UL_DPCH_InformationAddListIE_RL_ReconfReadyTDD, UL_DPCH_InformationAddListIE_RL_ReconfReadyTDD_sequence);

  return offset;
}
static int dissect_id_UL_DPCH_InformationAddListIE_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_DPCH_InformationAddListIE_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_id_UL_DPCH_InformationAddListIE_RL_ReconfReadyTDD);
}


static const per_sequence_t UnsuccessfulRL_InformationResponse_RL_AdditionFailureFDD_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_cause         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Cause },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UnsuccessfulRL_InformationResponse_RL_AdditionFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UnsuccessfulRL_InformationResponse_RL_AdditionFailureFDD, UnsuccessfulRL_InformationResponse_RL_AdditionFailureFDD_sequence);

  return offset;
}
static int dissect_id_UnsuccessfulRL_InformationResponse_RL_AdditionFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UnsuccessfulRL_InformationResponse_RL_AdditionFailureFDD(tvb, offset, actx, tree, hf_rnsap_id_UnsuccessfulRL_InformationResponse_RL_AdditionFailureFDD);
}


static const per_sequence_t UnsuccessfulRL_InformationResponse_RL_SetupFailureFDD_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_cause         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Cause },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UnsuccessfulRL_InformationResponse_RL_SetupFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UnsuccessfulRL_InformationResponse_RL_SetupFailureFDD, UnsuccessfulRL_InformationResponse_RL_SetupFailureFDD_sequence);

  return offset;
}
static int dissect_id_UnsuccessfulRL_InformationResponse_RL_SetupFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UnsuccessfulRL_InformationResponse_RL_SetupFailureFDD(tvb, offset, actx, tree, hf_rnsap_id_UnsuccessfulRL_InformationResponse_RL_SetupFailureFDD);
}


static const per_sequence_t UnsuccessfulRL_InformationResponse_RL_SetupFailureTDD_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_cause         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Cause },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UnsuccessfulRL_InformationResponse_RL_SetupFailureTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UnsuccessfulRL_InformationResponse_RL_SetupFailureTDD, UnsuccessfulRL_InformationResponse_RL_SetupFailureTDD_sequence);

  return offset;
}
static int dissect_id_UnsuccessfulRL_InformationResponse_RL_SetupFailureTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UnsuccessfulRL_InformationResponse_RL_SetupFailureTDD(tvb, offset, actx, tree, hf_rnsap_id_UnsuccessfulRL_InformationResponse_RL_SetupFailureTDD);
}



static int
dissect_rnsap_TGPSID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              1U, 6U, NULL, FALSE);

  return offset;
}
static int dissect_tGPSID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TGPSID(tvb, offset, actx, tree, hf_rnsap_tGPSID);
}



static int
dissect_rnsap_TGPRC(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 511U, NULL, FALSE);

  return offset;
}
static int dissect_tGPRC(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TGPRC(tvb, offset, actx, tree, hf_rnsap_tGPRC);
}


static const per_sequence_t Transmission_Gap_Pattern_Sequence_Status_List_item_sequence[] = {
  { &hf_rnsap_tGPSID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TGPSID },
  { &hf_rnsap_tGPRC         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TGPRC },
  { &hf_rnsap_tGCFN         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CFN },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Transmission_Gap_Pattern_Sequence_Status_List_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Transmission_Gap_Pattern_Sequence_Status_List_item, Transmission_Gap_Pattern_Sequence_Status_List_item_sequence);

  return offset;
}
static int dissect_Transmission_Gap_Pattern_Sequence_Status_List_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Transmission_Gap_Pattern_Sequence_Status_List_item(tvb, offset, actx, tree, hf_rnsap_Transmission_Gap_Pattern_Sequence_Status_List_item);
}


static const per_sequence_t Transmission_Gap_Pattern_Sequence_Status_List_sequence_of[1] = {
  { &hf_rnsap_Transmission_Gap_Pattern_Sequence_Status_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Transmission_Gap_Pattern_Sequence_Status_List_item },
};

static int
dissect_rnsap_Transmission_Gap_Pattern_Sequence_Status_List(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Transmission_Gap_Pattern_Sequence_Status_List, Transmission_Gap_Pattern_Sequence_Status_List_sequence_of,
                                                  0, 6);

  return offset;
}
static int dissect_transmission_Gap_Pattern_Sequence_Status(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Transmission_Gap_Pattern_Sequence_Status_List(tvb, offset, actx, tree, hf_rnsap_transmission_Gap_Pattern_Sequence_Status);
}


static const per_sequence_t Active_Pattern_Sequence_Information_sequence[] = {
  { &hf_rnsap_cMConfigurationChangeCFN, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CFN },
  { &hf_rnsap_transmission_Gap_Pattern_Sequence_Status, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Transmission_Gap_Pattern_Sequence_Status_List },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Active_Pattern_Sequence_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Active_Pattern_Sequence_Information, Active_Pattern_Sequence_Information_sequence);

  return offset;
}
static int dissect_id_Active_Pattern_Sequence_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Active_Pattern_Sequence_Information(tvb, offset, actx, tree, hf_rnsap_id_Active_Pattern_Sequence_Information);
}



static int
dissect_rnsap_ScaledAdjustmentRatio(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 100U, NULL, FALSE);

  return offset;
}
static int dissect_id_AdjustmentRatio(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ScaledAdjustmentRatio(tvb, offset, actx, tree, hf_rnsap_id_AdjustmentRatio);
}
static int dissect_adjustmentRatio(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_ScaledAdjustmentRatio(tvb, offset, actx, tree, hf_rnsap_adjustmentRatio);
}


static const per_sequence_t GeneralCauseList_RL_AdditionFailureFDD_sequence[] = {
  { &hf_rnsap_cause         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Cause },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GeneralCauseList_RL_AdditionFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GeneralCauseList_RL_AdditionFailureFDD, GeneralCauseList_RL_AdditionFailureFDD_sequence);

  return offset;
}
static int dissect_generalCause2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_GeneralCauseList_RL_AdditionFailureFDD(tvb, offset, actx, tree, hf_rnsap_generalCause2);
}


static const per_sequence_t UnsuccessfulRL_InformationResponseList_RL_AdditionFailureFDD_sequence_of[1] = {
  { &hf_rnsap_UnsuccessfulRL_InformationResponseList_RL_AdditionFailureFDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_UnsuccessfulRL_InformationResponseList_RL_AdditionFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_UnsuccessfulRL_InformationResponseList_RL_AdditionFailureFDD, UnsuccessfulRL_InformationResponseList_RL_AdditionFailureFDD_sequence_of,
                                                  1, 15);

  return offset;
}
static int dissect_unsuccessful_RL_InformationRespList_RL_AdditionFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UnsuccessfulRL_InformationResponseList_RL_AdditionFailureFDD(tvb, offset, actx, tree, hf_rnsap_unsuccessful_RL_InformationRespList_RL_AdditionFailureFDD);
}


static const per_sequence_t SuccessfulRL_InformationResponseList_RL_AdditionFailureFDD_sequence_of[1] = {
  { &hf_rnsap_SuccessfulRL_InformationResponseList_RL_AdditionFailureFDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_SuccessfulRL_InformationResponseList_RL_AdditionFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_SuccessfulRL_InformationResponseList_RL_AdditionFailureFDD, SuccessfulRL_InformationResponseList_RL_AdditionFailureFDD_sequence_of,
                                                  0, 14);

  return offset;
}
static int dissect_successful_RL_InformationRespList_RL_AdditionFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_SuccessfulRL_InformationResponseList_RL_AdditionFailureFDD(tvb, offset, actx, tree, hf_rnsap_successful_RL_InformationRespList_RL_AdditionFailureFDD);
}


static const per_sequence_t RLSpecificCauseList_RL_AdditionFailureFDD_sequence[] = {
  { &hf_rnsap_unsuccessful_RL_InformationRespList_RL_AdditionFailureFDD, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UnsuccessfulRL_InformationResponseList_RL_AdditionFailureFDD },
  { &hf_rnsap_successful_RL_InformationRespList_RL_AdditionFailureFDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_SuccessfulRL_InformationResponseList_RL_AdditionFailureFDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RLSpecificCauseList_RL_AdditionFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RLSpecificCauseList_RL_AdditionFailureFDD, RLSpecificCauseList_RL_AdditionFailureFDD_sequence);

  return offset;
}
static int dissect_rLSpecificCause2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RLSpecificCauseList_RL_AdditionFailureFDD(tvb, offset, actx, tree, hf_rnsap_rLSpecificCause2);
}


static const value_string rnsap_CauseLevel_RL_AdditionFailureFDD_vals[] = {
  {   0, "generalCause" },
  {   1, "rLSpecificCause" },
  { 0, NULL }
};

static const per_choice_t CauseLevel_RL_AdditionFailureFDD_choice[] = {
  {   0, &hf_rnsap_generalCause2 , ASN1_EXTENSION_ROOT    , dissect_rnsap_GeneralCauseList_RL_AdditionFailureFDD },
  {   1, &hf_rnsap_rLSpecificCause2, ASN1_EXTENSION_ROOT    , dissect_rnsap_RLSpecificCauseList_RL_AdditionFailureFDD },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_CauseLevel_RL_AdditionFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_CauseLevel_RL_AdditionFailureFDD, CauseLevel_RL_AdditionFailureFDD_choice,
                                 NULL);

  return offset;
}
static int dissect_id_CauseLevel_RL_AdditionFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CauseLevel_RL_AdditionFailureFDD(tvb, offset, actx, tree, hf_rnsap_id_CauseLevel_RL_AdditionFailureFDD);
}


static const per_sequence_t GeneralCauseList_RL_AdditionFailureTDD_sequence[] = {
  { &hf_rnsap_cause         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Cause },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GeneralCauseList_RL_AdditionFailureTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GeneralCauseList_RL_AdditionFailureTDD, GeneralCauseList_RL_AdditionFailureTDD_sequence);

  return offset;
}
static int dissect_generalCause3(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_GeneralCauseList_RL_AdditionFailureTDD(tvb, offset, actx, tree, hf_rnsap_generalCause3);
}



static int
dissect_rnsap_Unsuccessful_RL_InformationRespItem_RL_AdditionFailureTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_unsuccessful_RL_InformationRespItem_RL_AdditionFailureTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Unsuccessful_RL_InformationRespItem_RL_AdditionFailureTDD(tvb, offset, actx, tree, hf_rnsap_unsuccessful_RL_InformationRespItem_RL_AdditionFailureTDD);
}


static const per_sequence_t RLSpecificCauseList_RL_AdditionFailureTDD_sequence[] = {
  { &hf_rnsap_unsuccessful_RL_InformationRespItem_RL_AdditionFailureTDD, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Unsuccessful_RL_InformationRespItem_RL_AdditionFailureTDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RLSpecificCauseList_RL_AdditionFailureTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RLSpecificCauseList_RL_AdditionFailureTDD, RLSpecificCauseList_RL_AdditionFailureTDD_sequence);

  return offset;
}
static int dissect_rLSpecificCause3(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RLSpecificCauseList_RL_AdditionFailureTDD(tvb, offset, actx, tree, hf_rnsap_rLSpecificCause3);
}


static const value_string rnsap_CauseLevel_RL_AdditionFailureTDD_vals[] = {
  {   0, "generalCause" },
  {   1, "rLSpecificCause" },
  { 0, NULL }
};

static const per_choice_t CauseLevel_RL_AdditionFailureTDD_choice[] = {
  {   0, &hf_rnsap_generalCause3 , ASN1_EXTENSION_ROOT    , dissect_rnsap_GeneralCauseList_RL_AdditionFailureTDD },
  {   1, &hf_rnsap_rLSpecificCause3, ASN1_EXTENSION_ROOT    , dissect_rnsap_RLSpecificCauseList_RL_AdditionFailureTDD },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_CauseLevel_RL_AdditionFailureTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_CauseLevel_RL_AdditionFailureTDD, CauseLevel_RL_AdditionFailureTDD_choice,
                                 NULL);

  return offset;
}
static int dissect_id_CauseLevel_RL_AdditionFailureTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CauseLevel_RL_AdditionFailureTDD(tvb, offset, actx, tree, hf_rnsap_id_CauseLevel_RL_AdditionFailureTDD);
}


static const per_sequence_t GeneralCauseList_RL_ReconfFailure_sequence[] = {
  { &hf_rnsap_cause         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Cause },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GeneralCauseList_RL_ReconfFailure(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GeneralCauseList_RL_ReconfFailure, GeneralCauseList_RL_ReconfFailure_sequence);

  return offset;
}
static int dissect_generalCause4(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_GeneralCauseList_RL_ReconfFailure(tvb, offset, actx, tree, hf_rnsap_generalCause4);
}


static const per_sequence_t RL_ReconfigurationFailureList_RL_ReconfFailure_sequence_of[1] = {
  { &hf_rnsap_RL_ReconfigurationFailureList_RL_ReconfFailure_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_RL_ReconfigurationFailureList_RL_ReconfFailure(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RL_ReconfigurationFailureList_RL_ReconfFailure, RL_ReconfigurationFailureList_RL_ReconfFailure_sequence_of,
                                                  0, 16);

  return offset;
}
static int dissect_rL_ReconfigurationFailureList_RL_ReconfFailure(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RL_ReconfigurationFailureList_RL_ReconfFailure(tvb, offset, actx, tree, hf_rnsap_rL_ReconfigurationFailureList_RL_ReconfFailure);
}


static const per_sequence_t RLSpecificCauseList_RL_ReconfFailure_sequence[] = {
  { &hf_rnsap_rL_ReconfigurationFailureList_RL_ReconfFailure, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_RL_ReconfigurationFailureList_RL_ReconfFailure },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RLSpecificCauseList_RL_ReconfFailure(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RLSpecificCauseList_RL_ReconfFailure, RLSpecificCauseList_RL_ReconfFailure_sequence);

  return offset;
}
static int dissect_rLSpecificCause4(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RLSpecificCauseList_RL_ReconfFailure(tvb, offset, actx, tree, hf_rnsap_rLSpecificCause4);
}


static const value_string rnsap_CauseLevel_RL_ReconfFailure_vals[] = {
  {   0, "generalCause" },
  {   1, "rLSpecificCause" },
  { 0, NULL }
};

static const per_choice_t CauseLevel_RL_ReconfFailure_choice[] = {
  {   0, &hf_rnsap_generalCause4 , ASN1_EXTENSION_ROOT    , dissect_rnsap_GeneralCauseList_RL_ReconfFailure },
  {   1, &hf_rnsap_rLSpecificCause4, ASN1_EXTENSION_ROOT    , dissect_rnsap_RLSpecificCauseList_RL_ReconfFailure },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_CauseLevel_RL_ReconfFailure(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_CauseLevel_RL_ReconfFailure, CauseLevel_RL_ReconfFailure_choice,
                                 NULL);

  return offset;
}
static int dissect_id_CauseLevel_RL_ReconfFailure(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CauseLevel_RL_ReconfFailure(tvb, offset, actx, tree, hf_rnsap_id_CauseLevel_RL_ReconfFailure);
}


static const per_sequence_t GeneralCauseList_RL_SetupFailureFDD_sequence[] = {
  { &hf_rnsap_cause         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Cause },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GeneralCauseList_RL_SetupFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GeneralCauseList_RL_SetupFailureFDD, GeneralCauseList_RL_SetupFailureFDD_sequence);

  return offset;
}
static int dissect_generalCause(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_GeneralCauseList_RL_SetupFailureFDD(tvb, offset, actx, tree, hf_rnsap_generalCause);
}


static const per_sequence_t UnsuccessfulRL_InformationResponseList_RL_SetupFailureFDD_sequence_of[1] = {
  { &hf_rnsap_UnsuccessfulRL_InformationResponseList_RL_SetupFailureFDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_UnsuccessfulRL_InformationResponseList_RL_SetupFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_UnsuccessfulRL_InformationResponseList_RL_SetupFailureFDD, UnsuccessfulRL_InformationResponseList_RL_SetupFailureFDD_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_unsuccessful_RL_InformationRespList_RL_SetupFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UnsuccessfulRL_InformationResponseList_RL_SetupFailureFDD(tvb, offset, actx, tree, hf_rnsap_unsuccessful_RL_InformationRespList_RL_SetupFailureFDD);
}


static const per_sequence_t SuccessfulRL_InformationResponseList_RL_SetupFailureFDD_sequence_of[1] = {
  { &hf_rnsap_SuccessfulRL_InformationResponseList_RL_SetupFailureFDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_SuccessfulRL_InformationResponseList_RL_SetupFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_SuccessfulRL_InformationResponseList_RL_SetupFailureFDD, SuccessfulRL_InformationResponseList_RL_SetupFailureFDD_sequence_of,
                                                  0, 15);

  return offset;
}
static int dissect_successful_RL_InformationRespList_RL_SetupFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_SuccessfulRL_InformationResponseList_RL_SetupFailureFDD(tvb, offset, actx, tree, hf_rnsap_successful_RL_InformationRespList_RL_SetupFailureFDD);
}


static const per_sequence_t RLSpecificCauseList_RL_SetupFailureFDD_sequence[] = {
  { &hf_rnsap_unsuccessful_RL_InformationRespList_RL_SetupFailureFDD, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UnsuccessfulRL_InformationResponseList_RL_SetupFailureFDD },
  { &hf_rnsap_successful_RL_InformationRespList_RL_SetupFailureFDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_SuccessfulRL_InformationResponseList_RL_SetupFailureFDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RLSpecificCauseList_RL_SetupFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RLSpecificCauseList_RL_SetupFailureFDD, RLSpecificCauseList_RL_SetupFailureFDD_sequence);

  return offset;
}
static int dissect_rLSpecificCause(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RLSpecificCauseList_RL_SetupFailureFDD(tvb, offset, actx, tree, hf_rnsap_rLSpecificCause);
}


static const value_string rnsap_CauseLevel_RL_SetupFailureFDD_vals[] = {
  {   0, "generalCause" },
  {   1, "rLSpecificCause" },
  { 0, NULL }
};

static const per_choice_t CauseLevel_RL_SetupFailureFDD_choice[] = {
  {   0, &hf_rnsap_generalCause  , ASN1_EXTENSION_ROOT    , dissect_rnsap_GeneralCauseList_RL_SetupFailureFDD },
  {   1, &hf_rnsap_rLSpecificCause, ASN1_EXTENSION_ROOT    , dissect_rnsap_RLSpecificCauseList_RL_SetupFailureFDD },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_CauseLevel_RL_SetupFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_CauseLevel_RL_SetupFailureFDD, CauseLevel_RL_SetupFailureFDD_choice,
                                 NULL);

  return offset;
}
static int dissect_id_CauseLevel_RL_SetupFailureFDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CauseLevel_RL_SetupFailureFDD(tvb, offset, actx, tree, hf_rnsap_id_CauseLevel_RL_SetupFailureFDD);
}


static const per_sequence_t GeneralCauseList_RL_SetupFailureTDD_sequence[] = {
  { &hf_rnsap_cause         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Cause },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GeneralCauseList_RL_SetupFailureTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GeneralCauseList_RL_SetupFailureTDD, GeneralCauseList_RL_SetupFailureTDD_sequence);

  return offset;
}
static int dissect_generalCause1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_GeneralCauseList_RL_SetupFailureTDD(tvb, offset, actx, tree, hf_rnsap_generalCause1);
}



static int
dissect_rnsap_Unsuccessful_RL_InformationRespItem_RL_SetupFailureTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_rnsap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}
static int dissect_unsuccessful_RL_InformationRespItem_RL_SetupFailureTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Unsuccessful_RL_InformationRespItem_RL_SetupFailureTDD(tvb, offset, actx, tree, hf_rnsap_unsuccessful_RL_InformationRespItem_RL_SetupFailureTDD);
}


static const per_sequence_t RLSpecificCauseList_RL_SetupFailureTDD_sequence[] = {
  { &hf_rnsap_unsuccessful_RL_InformationRespItem_RL_SetupFailureTDD, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Unsuccessful_RL_InformationRespItem_RL_SetupFailureTDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_RLSpecificCauseList_RL_SetupFailureTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_RLSpecificCauseList_RL_SetupFailureTDD, RLSpecificCauseList_RL_SetupFailureTDD_sequence);

  return offset;
}
static int dissect_rLSpecificCause1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RLSpecificCauseList_RL_SetupFailureTDD(tvb, offset, actx, tree, hf_rnsap_rLSpecificCause1);
}


static const value_string rnsap_CauseLevel_RL_SetupFailureTDD_vals[] = {
  {   0, "generalCause" },
  {   1, "rLSpecificCause" },
  { 0, NULL }
};

static const per_choice_t CauseLevel_RL_SetupFailureTDD_choice[] = {
  {   0, &hf_rnsap_generalCause1 , ASN1_EXTENSION_ROOT    , dissect_rnsap_GeneralCauseList_RL_SetupFailureTDD },
  {   1, &hf_rnsap_rLSpecificCause1, ASN1_EXTENSION_ROOT    , dissect_rnsap_RLSpecificCauseList_RL_SetupFailureTDD },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_CauseLevel_RL_SetupFailureTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_CauseLevel_RL_SetupFailureTDD, CauseLevel_RL_SetupFailureTDD_choice,
                                 NULL);

  return offset;
}
static int dissect_id_CauseLevel_RL_SetupFailureTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CauseLevel_RL_SetupFailureTDD(tvb, offset, actx, tree, hf_rnsap_id_CauseLevel_RL_SetupFailureTDD);
}


static const per_sequence_t DL_CCTrCH_InformationDeleteItem_RL_ReconfPrepTDD_sequence[] = {
  { &hf_rnsap_cCTrCH_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_CCTrCH_InformationDeleteItem_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_CCTrCH_InformationDeleteItem_RL_ReconfPrepTDD, DL_CCTrCH_InformationDeleteItem_RL_ReconfPrepTDD_sequence);

  return offset;
}
static int dissect_id_DL_CCTrCH_InformationDeleteItem_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CCTrCH_InformationDeleteItem_RL_ReconfPrepTDD(tvb, offset, actx, tree, hf_rnsap_id_DL_CCTrCH_InformationDeleteItem_RL_ReconfPrepTDD);
}


static const per_sequence_t CCTrCH_TPCModifyItem_RL_ReconfPrepTDD_sequence[] = {
  { &hf_rnsap_cCTrCH_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_CCTrCH_TPCModifyItem_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_CCTrCH_TPCModifyItem_RL_ReconfPrepTDD, CCTrCH_TPCModifyItem_RL_ReconfPrepTDD_sequence);

  return offset;
}
static int dissect_CCTrCH_TPCModifyList_RL_ReconfPrepTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CCTrCH_TPCModifyItem_RL_ReconfPrepTDD(tvb, offset, actx, tree, hf_rnsap_CCTrCH_TPCModifyList_RL_ReconfPrepTDD_item);
}


static const per_sequence_t CCTrCH_TPCModifyList_RL_ReconfPrepTDD_sequence_of[1] = {
  { &hf_rnsap_CCTrCH_TPCModifyList_RL_ReconfPrepTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_TPCModifyItem_RL_ReconfPrepTDD },
};

static int
dissect_rnsap_CCTrCH_TPCModifyList_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_CCTrCH_TPCModifyList_RL_ReconfPrepTDD, CCTrCH_TPCModifyList_RL_ReconfPrepTDD_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_cCTrCH_TPCList2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_CCTrCH_TPCModifyList_RL_ReconfPrepTDD(tvb, offset, actx, tree, hf_rnsap_cCTrCH_TPCList2);
}


static const per_sequence_t DL_CCTrCH_InformationModifyItem_RL_ReconfPrepTDD_sequence[] = {
  { &hf_rnsap_cCTrCH_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_tFCS          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TFCS },
  { &hf_rnsap_tFCI_Coding   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TFCI_Coding },
  { &hf_rnsap_punctureLimit , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_PunctureLimit },
  { &hf_rnsap_cCTrCH_TPCList2, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CCTrCH_TPCModifyList_RL_ReconfPrepTDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_CCTrCH_InformationModifyItem_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_CCTrCH_InformationModifyItem_RL_ReconfPrepTDD, DL_CCTrCH_InformationModifyItem_RL_ReconfPrepTDD_sequence);

  return offset;
}
static int dissect_id_DL_CCTrCH_InformationModifyItem_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CCTrCH_InformationModifyItem_RL_ReconfPrepTDD(tvb, offset, actx, tree, hf_rnsap_id_DL_CCTrCH_InformationModifyItem_RL_ReconfPrepTDD);
}


static const per_sequence_t DL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD_sequence[] = {
  { &hf_rnsap_cCTrCH_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_tFCS          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TFCS },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD, DL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD_sequence);

  return offset;
}
static int dissect_id_DL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD(tvb, offset, actx, tree, hf_rnsap_id_DL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD);
}


static const per_sequence_t DL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD_sequence_of[1] = {
  { &hf_rnsap_DL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_DL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD, DL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD_sequence_of,
                                                  0, 16);

  return offset;
}
static int dissect_id_DL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD(tvb, offset, actx, tree, hf_rnsap_id_DL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD);
}


static const per_sequence_t DL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD_sequence_of[1] = {
  { &hf_rnsap_DL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_DL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD, DL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD_sequence_of,
                                                  0, 16);

  return offset;
}
static int dissect_id_DL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD(tvb, offset, actx, tree, hf_rnsap_id_DL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD);
}


static const per_sequence_t DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD_sequence_of[1] = {
  { &hf_rnsap_DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD, DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD_sequence_of,
                                                  0, 16);

  return offset;
}
static int dissect_id_DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD(tvb, offset, actx, tree, hf_rnsap_id_DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD);
}


static const per_sequence_t DL_DPCH_InformationAddListIE_RL_ReconfReadyTDD_sequence[] = {
  { &hf_rnsap_repetitionPeriod, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RepetitionPeriod },
  { &hf_rnsap_repetitionLength, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RepetitionLength },
  { &hf_rnsap_tDD_DPCHOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_DPCHOffset },
  { &hf_rnsap_dL_Timeslot_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_Timeslot_Information },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_DPCH_InformationAddListIE_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_DPCH_InformationAddListIE_RL_ReconfReadyTDD, DL_DPCH_InformationAddListIE_RL_ReconfReadyTDD_sequence);

  return offset;
}
static int dissect_id_DL_DPCH_InformationAddListIE_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_DPCH_InformationAddListIE_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_id_DL_DPCH_InformationAddListIE_RL_ReconfReadyTDD);
}


static const per_sequence_t DL_DPCH_InformationDeleteItem_RL_ReconfReadyTDD_sequence[] = {
  { &hf_rnsap_dPCH_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DPCH_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_DPCH_InformationDeleteItem_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_DPCH_InformationDeleteItem_RL_ReconfReadyTDD, DL_DPCH_InformationDeleteItem_RL_ReconfReadyTDD_sequence);

  return offset;
}
static int dissect_DL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_DPCH_InformationDeleteItem_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_DL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD_item);
}


static const per_sequence_t DL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD_sequence_of[1] = {
  { &hf_rnsap_DL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_DPCH_InformationDeleteItem_RL_ReconfReadyTDD },
};

static int
dissect_rnsap_DL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD, DL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD_sequence_of,
                                                  0, 240);

  return offset;
}
static int dissect_id_DL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_id_DL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD);
}


static const per_sequence_t TDD_DL_Code_InformationModifyItem_RL_ReconfReadyTDD_sequence[] = {
  { &hf_rnsap_dPCH_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DPCH_ID },
  { &hf_rnsap_tDD_ChannelisationCode, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TDD_ChannelisationCode },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TDD_DL_Code_InformationModifyItem_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TDD_DL_Code_InformationModifyItem_RL_ReconfReadyTDD, TDD_DL_Code_InformationModifyItem_RL_ReconfReadyTDD_sequence);

  return offset;
}
static int dissect_TDD_DL_Code_InformationModifyList_RL_ReconfReadyTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TDD_DL_Code_InformationModifyItem_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_TDD_DL_Code_InformationModifyList_RL_ReconfReadyTDD_item);
}


static const per_sequence_t TDD_DL_Code_InformationModifyList_RL_ReconfReadyTDD_sequence_of[1] = {
  { &hf_rnsap_TDD_DL_Code_InformationModifyList_RL_ReconfReadyTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_DL_Code_InformationModifyItem_RL_ReconfReadyTDD },
};

static int
dissect_rnsap_TDD_DL_Code_InformationModifyList_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_TDD_DL_Code_InformationModifyList_RL_ReconfReadyTDD, TDD_DL_Code_InformationModifyList_RL_ReconfReadyTDD_sequence_of,
                                                  1, 240);

  return offset;
}
static int dissect_dL_Code_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TDD_DL_Code_InformationModifyList_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_dL_Code_Information);
}


static const per_sequence_t DL_Timeslot_InformationModifyItem_RL_ReconfReadyTDD_sequence[] = {
  { &hf_rnsap_timeSlot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlot },
  { &hf_rnsap_midambleShiftAndBurstType, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MidambleShiftAndBurstType },
  { &hf_rnsap_tFCI_Presence , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TFCI_Presence },
  { &hf_rnsap_dL_Code_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TDD_DL_Code_InformationModifyList_RL_ReconfReadyTDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_Timeslot_InformationModifyItem_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_Timeslot_InformationModifyItem_RL_ReconfReadyTDD, DL_Timeslot_InformationModifyItem_RL_ReconfReadyTDD_sequence);

  return offset;
}
static int dissect_DL_Timeslot_InformationModifyList_RL_ReconfReadyTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Timeslot_InformationModifyItem_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_DL_Timeslot_InformationModifyList_RL_ReconfReadyTDD_item);
}


static const per_sequence_t DL_Timeslot_InformationModifyList_RL_ReconfReadyTDD_sequence_of[1] = {
  { &hf_rnsap_DL_Timeslot_InformationModifyList_RL_ReconfReadyTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_Timeslot_InformationModifyItem_RL_ReconfReadyTDD },
};

static int
dissect_rnsap_DL_Timeslot_InformationModifyList_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DL_Timeslot_InformationModifyList_RL_ReconfReadyTDD, DL_Timeslot_InformationModifyList_RL_ReconfReadyTDD_sequence_of,
                                                  1, 15);

  return offset;
}
static int dissect_dL_Timeslot_InformationModifyList_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_Timeslot_InformationModifyList_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_dL_Timeslot_InformationModifyList_RL_ReconfReadyTDD);
}


static const per_sequence_t DL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD_sequence[] = {
  { &hf_rnsap_repetitionPeriod, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_RepetitionPeriod },
  { &hf_rnsap_repetitionLength, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_RepetitionLength },
  { &hf_rnsap_tDD_DPCHOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TDD_DPCHOffset },
  { &hf_rnsap_dL_Timeslot_InformationModifyList_RL_ReconfReadyTDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DL_Timeslot_InformationModifyList_RL_ReconfReadyTDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD, DL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD_sequence);

  return offset;
}
static int dissect_id_DL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_id_DL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD);
}



static int
dissect_rnsap_DSCH_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 255U, NULL, FALSE);

  return offset;
}
static int dissect_dsch_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DSCH_ID(tvb, offset, actx, tree, hf_rnsap_dsch_ID);
}
static int dissect_dSCH_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DSCH_ID(tvb, offset, actx, tree, hf_rnsap_dSCH_ID);
}


static const per_sequence_t DSCH_TDD_InformationItem_sequence[] = {
  { &hf_rnsap_dSCH_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DSCH_ID },
  { &hf_rnsap_dl_ccTrCHID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_trChSourceStatisticsDescriptor, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TrCH_SrcStatisticsDescr },
  { &hf_rnsap_transportFormatSet, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatSet },
  { &hf_rnsap_allocationRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_AllocationRetentionPriority },
  { &hf_rnsap_schedulingPriorityIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SchedulingPriorityIndicator },
  { &hf_rnsap_bLER          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_BLER },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DSCH_TDD_InformationItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DSCH_TDD_InformationItem, DSCH_TDD_InformationItem_sequence);

  return offset;
}
static int dissect_DSCH_TDD_Information_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DSCH_TDD_InformationItem(tvb, offset, actx, tree, hf_rnsap_DSCH_TDD_Information_item);
}


static const per_sequence_t DSCH_TDD_Information_sequence_of[1] = {
  { &hf_rnsap_DSCH_TDD_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DSCH_TDD_InformationItem },
};

static int
dissect_rnsap_DSCH_TDD_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DSCH_TDD_Information, DSCH_TDD_Information_sequence_of,
                                                  1, 10);

  return offset;
}
static int dissect_id_DSCHs_to_Add_TDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DSCH_TDD_Information(tvb, offset, actx, tree, hf_rnsap_id_DSCHs_to_Add_TDD);
}
static int dissect_id_DSCH_TDD_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DSCH_TDD_Information(tvb, offset, actx, tree, hf_rnsap_id_DSCH_TDD_Information);
}


static const per_sequence_t DSCH_DeleteItem_RL_ReconfPrepTDD_sequence[] = {
  { &hf_rnsap_dSCH_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DSCH_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DSCH_DeleteItem_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DSCH_DeleteItem_RL_ReconfPrepTDD, DSCH_DeleteItem_RL_ReconfPrepTDD_sequence);

  return offset;
}
static int dissect_DSCH_DeleteList_RL_ReconfPrepTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DSCH_DeleteItem_RL_ReconfPrepTDD(tvb, offset, actx, tree, hf_rnsap_DSCH_DeleteList_RL_ReconfPrepTDD_item);
}


static const per_sequence_t DSCH_DeleteList_RL_ReconfPrepTDD_sequence_of[1] = {
  { &hf_rnsap_DSCH_DeleteList_RL_ReconfPrepTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DSCH_DeleteItem_RL_ReconfPrepTDD },
};

static int
dissect_rnsap_DSCH_DeleteList_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DSCH_DeleteList_RL_ReconfPrepTDD, DSCH_DeleteList_RL_ReconfPrepTDD_sequence_of,
                                                  0, 128);

  return offset;
}
static int dissect_id_DSCH_DeleteList_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DSCH_DeleteList_RL_ReconfPrepTDD(tvb, offset, actx, tree, hf_rnsap_id_DSCH_DeleteList_RL_ReconfPrepTDD);
}


static const value_string rnsap_TransportFormatManagement_vals[] = {
  {   0, "cell-based" },
  {   1, "ue-based" },
  { 0, NULL }
};


static int
dissect_rnsap_TransportFormatManagement(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_transportFormatManagement(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TransportFormatManagement(tvb, offset, actx, tree, hf_rnsap_transportFormatManagement);
}


static const per_sequence_t DSCH_FlowControlItem_sequence[] = {
  { &hf_rnsap_dSCH_SchedulingPriority, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SchedulingPriorityIndicator },
  { &hf_rnsap_mAC_c_sh_SDU_Lengths, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_MAC_c_sh_SDU_LengthList },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DSCH_FlowControlItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DSCH_FlowControlItem, DSCH_FlowControlItem_sequence);

  return offset;
}
static int dissect_DSCH_FlowControlInformation_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DSCH_FlowControlItem(tvb, offset, actx, tree, hf_rnsap_DSCH_FlowControlInformation_item);
}


static const per_sequence_t DSCH_FlowControlInformation_sequence_of[1] = {
  { &hf_rnsap_DSCH_FlowControlInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DSCH_FlowControlItem },
};

static int
dissect_rnsap_DSCH_FlowControlInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DSCH_FlowControlInformation, DSCH_FlowControlInformation_sequence_of,
                                                  1, 16);

  return offset;
}
static int dissect_dSCH_FlowControlInformation(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DSCH_FlowControlInformation(tvb, offset, actx, tree, hf_rnsap_dSCH_FlowControlInformation);
}


static const per_sequence_t DiversityIndication_RL_AdditionRspTDD2_sequence[] = {
  { &hf_rnsap_bindingID     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BindingID },
  { &hf_rnsap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportLayerAddress },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DiversityIndication_RL_AdditionRspTDD2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DiversityIndication_RL_AdditionRspTDD2, DiversityIndication_RL_AdditionRspTDD2_sequence);

  return offset;
}
static int dissect_diversityIndication4(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DiversityIndication_RL_AdditionRspTDD2(tvb, offset, actx, tree, hf_rnsap_diversityIndication4);
}


static const per_sequence_t DSCHInformationItem_RL_AdditionRspTDD_sequence[] = {
  { &hf_rnsap_dsch_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DSCH_ID },
  { &hf_rnsap_transportFormatManagement, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatManagement },
  { &hf_rnsap_dSCH_FlowControlInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DSCH_FlowControlInformation },
  { &hf_rnsap_diversityIndication4, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DiversityIndication_RL_AdditionRspTDD2 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DSCHInformationItem_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DSCHInformationItem_RL_AdditionRspTDD, DSCHInformationItem_RL_AdditionRspTDD_sequence);

  return offset;
}
static int dissect_DSCH_InformationListIE_RL_AdditionRspTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DSCHInformationItem_RL_AdditionRspTDD(tvb, offset, actx, tree, hf_rnsap_DSCH_InformationListIE_RL_AdditionRspTDD_item);
}


static const per_sequence_t DSCH_InformationListIE_RL_AdditionRspTDD_sequence_of[1] = {
  { &hf_rnsap_DSCH_InformationListIE_RL_AdditionRspTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DSCHInformationItem_RL_AdditionRspTDD },
};

static int
dissect_rnsap_DSCH_InformationListIE_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DSCH_InformationListIE_RL_AdditionRspTDD, DSCH_InformationListIE_RL_AdditionRspTDD_sequence_of,
                                                  0, 10);

  return offset;
}
static int dissect_id_DSCH_InformationListIE_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DSCH_InformationListIE_RL_AdditionRspTDD(tvb, offset, actx, tree, hf_rnsap_id_DSCH_InformationListIE_RL_AdditionRspTDD);
}


static const per_sequence_t DSCHInformationItem_RL_SetupRspTDD_sequence[] = {
  { &hf_rnsap_dsch_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DSCH_ID },
  { &hf_rnsap_dSCH_FlowControlInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DSCH_FlowControlInformation },
  { &hf_rnsap_bindingID     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BindingID },
  { &hf_rnsap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportLayerAddress },
  { &hf_rnsap_transportFormatManagement, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatManagement },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DSCHInformationItem_RL_SetupRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DSCHInformationItem_RL_SetupRspTDD, DSCHInformationItem_RL_SetupRspTDD_sequence);

  return offset;
}
static int dissect_DSCH_InformationListIEs_RL_SetupRspTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DSCHInformationItem_RL_SetupRspTDD(tvb, offset, actx, tree, hf_rnsap_DSCH_InformationListIEs_RL_SetupRspTDD_item);
}


static const per_sequence_t DSCH_InformationListIEs_RL_SetupRspTDD_sequence_of[1] = {
  { &hf_rnsap_DSCH_InformationListIEs_RL_SetupRspTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DSCHInformationItem_RL_SetupRspTDD },
};

static int
dissect_rnsap_DSCH_InformationListIEs_RL_SetupRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DSCH_InformationListIEs_RL_SetupRspTDD, DSCH_InformationListIEs_RL_SetupRspTDD_sequence_of,
                                                  0, 10);

  return offset;
}
static int dissect_id_DSCH_InformationListIEs_RL_SetupRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DSCH_InformationListIEs_RL_SetupRspTDD(tvb, offset, actx, tree, hf_rnsap_id_DSCH_InformationListIEs_RL_SetupRspTDD);
}


static const per_sequence_t DSCH_ModifyItem_RL_ReconfPrepTDD_sequence[] = {
  { &hf_rnsap_dSCH_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DSCH_ID },
  { &hf_rnsap_dl_ccTrCHID   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_trChSourceStatisticsDescriptor, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TrCH_SrcStatisticsDescr },
  { &hf_rnsap_transportFormatSet, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportFormatSet },
  { &hf_rnsap_allocationRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_AllocationRetentionPriority },
  { &hf_rnsap_schedulingPriorityIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_SchedulingPriorityIndicator },
  { &hf_rnsap_bLER          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BLER },
  { &hf_rnsap_transportBearerRequestIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportBearerRequestIndicator },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DSCH_ModifyItem_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DSCH_ModifyItem_RL_ReconfPrepTDD, DSCH_ModifyItem_RL_ReconfPrepTDD_sequence);

  return offset;
}
static int dissect_DSCH_ModifyList_RL_ReconfPrepTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DSCH_ModifyItem_RL_ReconfPrepTDD(tvb, offset, actx, tree, hf_rnsap_DSCH_ModifyList_RL_ReconfPrepTDD_item);
}


static const per_sequence_t DSCH_ModifyList_RL_ReconfPrepTDD_sequence_of[1] = {
  { &hf_rnsap_DSCH_ModifyList_RL_ReconfPrepTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DSCH_ModifyItem_RL_ReconfPrepTDD },
};

static int
dissect_rnsap_DSCH_ModifyList_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DSCH_ModifyList_RL_ReconfPrepTDD, DSCH_ModifyList_RL_ReconfPrepTDD_sequence_of,
                                                  0, 128);

  return offset;
}
static int dissect_id_DSCH_ModifyList_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DSCH_ModifyList_RL_ReconfPrepTDD(tvb, offset, actx, tree, hf_rnsap_id_DSCH_ModifyList_RL_ReconfPrepTDD);
}


static const per_sequence_t DSCHToBeAddedOrModifiedItem_RL_ReconfReadyTDD_sequence[] = {
  { &hf_rnsap_dsch_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DSCH_ID },
  { &hf_rnsap_transportFormatManagement, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatManagement },
  { &hf_rnsap_dSCH_FlowControlInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DSCH_FlowControlInformation },
  { &hf_rnsap_bindingID     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BindingID },
  { &hf_rnsap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportLayerAddress },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_DSCHToBeAddedOrModifiedItem_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_DSCHToBeAddedOrModifiedItem_RL_ReconfReadyTDD, DSCHToBeAddedOrModifiedItem_RL_ReconfReadyTDD_sequence);

  return offset;
}
static int dissect_DSCHToBeAddedOrModifiedList_RL_ReconfReadyTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DSCHToBeAddedOrModifiedItem_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_DSCHToBeAddedOrModifiedList_RL_ReconfReadyTDD_item);
}


static const per_sequence_t DSCHToBeAddedOrModifiedList_RL_ReconfReadyTDD_sequence_of[1] = {
  { &hf_rnsap_DSCHToBeAddedOrModifiedList_RL_ReconfReadyTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_DSCHToBeAddedOrModifiedItem_RL_ReconfReadyTDD },
};

static int
dissect_rnsap_DSCHToBeAddedOrModifiedList_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_DSCHToBeAddedOrModifiedList_RL_ReconfReadyTDD, DSCHToBeAddedOrModifiedList_RL_ReconfReadyTDD_sequence_of,
                                                  0, 10);

  return offset;
}
static int dissect_id_DSCHToBeAddedOrModifiedList_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DSCHToBeAddedOrModifiedList_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_id_DSCHToBeAddedOrModifiedList_RL_ReconfReadyTDD);
}


static const per_sequence_t GA_PointWithUnCertainty_sequence[] = {
  { &hf_rnsap_geographicalCoordinates, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GeographicalCoordinate },
  { &hf_rnsap_uncertaintyCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_127 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GA_PointWithUnCertainty(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GA_PointWithUnCertainty, GA_PointWithUnCertainty_sequence);

  return offset;
}
static int dissect_pointWithUncertainty(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_GA_PointWithUnCertainty(tvb, offset, actx, tree, hf_rnsap_pointWithUncertainty);
}



static int
dissect_rnsap_INTEGER_0_179(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 179U, NULL, FALSE);

  return offset;
}
static int dissect_offsetAngle(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_179(tvb, offset, actx, tree, hf_rnsap_offsetAngle);
}
static int dissect_includedAngle(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_179(tvb, offset, actx, tree, hf_rnsap_includedAngle);
}
static int dissect_orientationOfMajorAxis(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_INTEGER_0_179(tvb, offset, actx, tree, hf_rnsap_orientationOfMajorAxis);
}


static const per_sequence_t GA_UncertaintyEllipse_sequence[] = {
  { &hf_rnsap_uncertaintySemi_major, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_127 },
  { &hf_rnsap_uncertaintySemi_minor, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_127 },
  { &hf_rnsap_orientationOfMajorAxis, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_179 },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GA_UncertaintyEllipse(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GA_UncertaintyEllipse, GA_UncertaintyEllipse_sequence);

  return offset;
}
static int dissect_uncertaintyEllipse(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_GA_UncertaintyEllipse(tvb, offset, actx, tree, hf_rnsap_uncertaintyEllipse);
}


static const per_sequence_t GA_PointWithUnCertaintyEllipse_sequence[] = {
  { &hf_rnsap_geographicalCoordinates, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GeographicalCoordinate },
  { &hf_rnsap_uncertaintyEllipse, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GA_UncertaintyEllipse },
  { &hf_rnsap_confidence    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_127 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GA_PointWithUnCertaintyEllipse(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GA_PointWithUnCertaintyEllipse, GA_PointWithUnCertaintyEllipse_sequence);

  return offset;
}
static int dissect_pointWithUncertaintyEllipse(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_GA_PointWithUnCertaintyEllipse(tvb, offset, actx, tree, hf_rnsap_pointWithUncertaintyEllipse);
}


static const value_string rnsap_T_directionOfAltitude_vals[] = {
  {   0, "height" },
  {   1, "depth" },
  { 0, NULL }
};


static int
dissect_rnsap_T_directionOfAltitude(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_directionOfAltitude(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_T_directionOfAltitude(tvb, offset, actx, tree, hf_rnsap_directionOfAltitude);
}


static const per_sequence_t GA_AltitudeAndDirection_sequence[] = {
  { &hf_rnsap_directionOfAltitude, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_T_directionOfAltitude },
  { &hf_rnsap_altitude      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_32767 },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GA_AltitudeAndDirection(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GA_AltitudeAndDirection, GA_AltitudeAndDirection_sequence);

  return offset;
}
static int dissect_altitudeAndDirection(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_GA_AltitudeAndDirection(tvb, offset, actx, tree, hf_rnsap_altitudeAndDirection);
}


static const per_sequence_t GA_PointWithAltitude_sequence[] = {
  { &hf_rnsap_geographicalCoordinates, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GeographicalCoordinate },
  { &hf_rnsap_altitudeAndDirection, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GA_AltitudeAndDirection },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GA_PointWithAltitude(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GA_PointWithAltitude, GA_PointWithAltitude_sequence);

  return offset;
}
static int dissect_pointWithAltitude(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_GA_PointWithAltitude(tvb, offset, actx, tree, hf_rnsap_pointWithAltitude);
}


static const per_sequence_t GA_PointWithAltitudeAndUncertaintyEllipsoid_sequence[] = {
  { &hf_rnsap_geographicalCoordinates, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GeographicalCoordinate },
  { &hf_rnsap_altitudeAndDirection, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GA_AltitudeAndDirection },
  { &hf_rnsap_uncertaintyEllipse, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GA_UncertaintyEllipse },
  { &hf_rnsap_uncertaintyAltitude, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_127 },
  { &hf_rnsap_confidence    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_127 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GA_PointWithAltitudeAndUncertaintyEllipsoid(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GA_PointWithAltitudeAndUncertaintyEllipsoid, GA_PointWithAltitudeAndUncertaintyEllipsoid_sequence);

  return offset;
}
static int dissect_pointWithAltitudeAndUncertaintyEllipsoid(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_GA_PointWithAltitudeAndUncertaintyEllipsoid(tvb, offset, actx, tree, hf_rnsap_pointWithAltitudeAndUncertaintyEllipsoid);
}


static const per_sequence_t GA_EllipsoidArc_sequence[] = {
  { &hf_rnsap_geographicalCoordinates, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GeographicalCoordinate },
  { &hf_rnsap_innerRadius   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_65535 },
  { &hf_rnsap_uncertaintyRadius, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_127 },
  { &hf_rnsap_offsetAngle   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_179 },
  { &hf_rnsap_includedAngle , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_179 },
  { &hf_rnsap_confidence    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_INTEGER_0_127 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_GA_EllipsoidArc(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_GA_EllipsoidArc, GA_EllipsoidArc_sequence);

  return offset;
}
static int dissect_ellipsoidArc(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_GA_EllipsoidArc(tvb, offset, actx, tree, hf_rnsap_ellipsoidArc);
}


static const value_string rnsap_GA_CellAdditionalShapes_vals[] = {
  {   0, "pointWithUncertainty" },
  {   1, "pointWithUncertaintyEllipse" },
  {   2, "pointWithAltitude" },
  {   3, "pointWithAltitudeAndUncertaintyEllipsoid" },
  {   4, "ellipsoidArc" },
  { 0, NULL }
};

static const per_choice_t GA_CellAdditionalShapes_choice[] = {
  {   0, &hf_rnsap_pointWithUncertainty, ASN1_EXTENSION_ROOT    , dissect_rnsap_GA_PointWithUnCertainty },
  {   1, &hf_rnsap_pointWithUncertaintyEllipse, ASN1_EXTENSION_ROOT    , dissect_rnsap_GA_PointWithUnCertaintyEllipse },
  {   2, &hf_rnsap_pointWithAltitude, ASN1_EXTENSION_ROOT    , dissect_rnsap_GA_PointWithAltitude },
  {   3, &hf_rnsap_pointWithAltitudeAndUncertaintyEllipsoid, ASN1_EXTENSION_ROOT    , dissect_rnsap_GA_PointWithAltitudeAndUncertaintyEllipsoid },
  {   4, &hf_rnsap_ellipsoidArc  , ASN1_EXTENSION_ROOT    , dissect_rnsap_GA_EllipsoidArc },
  { 0, NULL, 0, NULL }
};

static int
dissect_rnsap_GA_CellAdditionalShapes(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_rnsap_GA_CellAdditionalShapes, GA_CellAdditionalShapes_choice,
                                 NULL);

  return offset;
}
static int dissect_id_GA_CellAdditionalShapes(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_GA_CellAdditionalShapes(tvb, offset, actx, tree, hf_rnsap_id_GA_CellAdditionalShapes);
}



static int
dissect_rnsap_TGSN(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 14U, NULL, FALSE);

  return offset;
}
static int dissect_tGSN(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TGSN(tvb, offset, actx, tree, hf_rnsap_tGSN);
}



static int
dissect_rnsap_GapLength(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              1U, 14U, NULL, FALSE);

  return offset;
}
static int dissect_tGL1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_GapLength(tvb, offset, actx, tree, hf_rnsap_tGL1);
}
static int dissect_tGL2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_GapLength(tvb, offset, actx, tree, hf_rnsap_tGL2);
}



static int
dissect_rnsap_TGD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 269U, NULL, FALSE);

  return offset;
}
static int dissect_tGD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TGD(tvb, offset, actx, tree, hf_rnsap_tGD);
}



static int
dissect_rnsap_GapDuration(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              1U, 144U, NULL, TRUE);

  return offset;
}
static int dissect_tGPL1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_GapDuration(tvb, offset, actx, tree, hf_rnsap_tGPL1);
}
static int dissect_not_to_be_used_1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_GapDuration(tvb, offset, actx, tree, hf_rnsap_not_to_be_used_1);
}


static const value_string rnsap_UL_DL_mode_vals[] = {
  {   0, "ul-only" },
  {   1, "dl-only" },
  {   2, "both-ul-and-dl" },
  { 0, NULL }
};


static int
dissect_rnsap_UL_DL_mode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}
static int dissect_uL_DL_mode(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_DL_mode(tvb, offset, actx, tree, hf_rnsap_uL_DL_mode);
}


static const value_string rnsap_Downlink_Compressed_Mode_Method_vals[] = {
  {   0, "not-Used-puncturing" },
  {   1, "sFdiv2" },
  {   2, "higher-layer-scheduling" },
  { 0, NULL }
};


static int
dissect_rnsap_Downlink_Compressed_Mode_Method(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_downlink_Compressed_Mode_Method(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Downlink_Compressed_Mode_Method(tvb, offset, actx, tree, hf_rnsap_downlink_Compressed_Mode_Method);
}


static const value_string rnsap_Uplink_Compressed_Mode_Method_vals[] = {
  {   0, "sFdiv2" },
  {   1, "higher-layer-scheduling" },
  { 0, NULL }
};


static int
dissect_rnsap_Uplink_Compressed_Mode_Method(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_uplink_Compressed_Mode_Method(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Uplink_Compressed_Mode_Method(tvb, offset, actx, tree, hf_rnsap_uplink_Compressed_Mode_Method);
}


static const value_string rnsap_DL_FrameType_vals[] = {
  {   0, "typeA" },
  {   1, "typeB" },
  { 0, NULL }
};


static int
dissect_rnsap_DL_FrameType(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}
static int dissect_dL_FrameType(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DL_FrameType(tvb, offset, actx, tree, hf_rnsap_dL_FrameType);
}



static int
dissect_rnsap_DeltaSIR(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 30U, NULL, FALSE);

  return offset;
}
static int dissect_delta_SIR1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DeltaSIR(tvb, offset, actx, tree, hf_rnsap_delta_SIR1);
}
static int dissect_delta_SIR_after1(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DeltaSIR(tvb, offset, actx, tree, hf_rnsap_delta_SIR_after1);
}
static int dissect_delta_SIR2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DeltaSIR(tvb, offset, actx, tree, hf_rnsap_delta_SIR2);
}
static int dissect_delta_SIR_after2(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_DeltaSIR(tvb, offset, actx, tree, hf_rnsap_delta_SIR_after2);
}


static const per_sequence_t Transmission_Gap_Pattern_Sequence_Information_item_sequence[] = {
  { &hf_rnsap_tGPSID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TGPSID },
  { &hf_rnsap_tGSN          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TGSN },
  { &hf_rnsap_tGL1          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GapLength },
  { &hf_rnsap_tGL2          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GapLength },
  { &hf_rnsap_tGD           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TGD },
  { &hf_rnsap_tGPL1         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_GapDuration },
  { &hf_rnsap_not_to_be_used_1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_GapDuration },
  { &hf_rnsap_uL_DL_mode    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_DL_mode },
  { &hf_rnsap_downlink_Compressed_Mode_Method, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Downlink_Compressed_Mode_Method },
  { &hf_rnsap_uplink_Compressed_Mode_Method, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_Uplink_Compressed_Mode_Method },
  { &hf_rnsap_dL_FrameType  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DL_FrameType },
  { &hf_rnsap_delta_SIR1    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DeltaSIR },
  { &hf_rnsap_delta_SIR_after1, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DeltaSIR },
  { &hf_rnsap_delta_SIR2    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DeltaSIR },
  { &hf_rnsap_delta_SIR_after2, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DeltaSIR },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_Transmission_Gap_Pattern_Sequence_Information_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_Transmission_Gap_Pattern_Sequence_Information_item, Transmission_Gap_Pattern_Sequence_Information_item_sequence);

  return offset;
}
static int dissect_Transmission_Gap_Pattern_Sequence_Information_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Transmission_Gap_Pattern_Sequence_Information_item(tvb, offset, actx, tree, hf_rnsap_Transmission_Gap_Pattern_Sequence_Information_item);
}


static const per_sequence_t Transmission_Gap_Pattern_Sequence_Information_sequence_of[1] = {
  { &hf_rnsap_Transmission_Gap_Pattern_Sequence_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_Transmission_Gap_Pattern_Sequence_Information_item },
};

static int
dissect_rnsap_Transmission_Gap_Pattern_Sequence_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_Transmission_Gap_Pattern_Sequence_Information, Transmission_Gap_Pattern_Sequence_Information_sequence_of,
                                                  1, 6);

  return offset;
}
static int dissect_id_Transmission_Gap_Pattern_Sequence_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_Transmission_Gap_Pattern_Sequence_Information(tvb, offset, actx, tree, hf_rnsap_id_Transmission_Gap_Pattern_Sequence_Information);
}


static const per_sequence_t UL_CCTrCH_DeleteInformation_RL_ReconfPrepTDD_sequence[] = {
  { &hf_rnsap_cCTrCH_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UL_CCTrCH_DeleteInformation_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UL_CCTrCH_DeleteInformation_RL_ReconfPrepTDD, UL_CCTrCH_DeleteInformation_RL_ReconfPrepTDD_sequence);

  return offset;
}
static int dissect_id_UL_CCTrCH_DeleteInformation_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_CCTrCH_DeleteInformation_RL_ReconfPrepTDD(tvb, offset, actx, tree, hf_rnsap_id_UL_CCTrCH_DeleteInformation_RL_ReconfPrepTDD);
}


static const per_sequence_t UL_CCTrCH_ModifyInformation_RL_ReconfPrepTDD_sequence[] = {
  { &hf_rnsap_cCTrCH_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_tFCS          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TFCS },
  { &hf_rnsap_tFCI_Coding   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TFCI_Coding },
  { &hf_rnsap_punctureLimit , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_PunctureLimit },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UL_CCTrCH_ModifyInformation_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UL_CCTrCH_ModifyInformation_RL_ReconfPrepTDD, UL_CCTrCH_ModifyInformation_RL_ReconfPrepTDD_sequence);

  return offset;
}
static int dissect_id_UL_CCTrCH_ModifyInformation_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_CCTrCH_ModifyInformation_RL_ReconfPrepTDD(tvb, offset, actx, tree, hf_rnsap_id_UL_CCTrCH_ModifyInformation_RL_ReconfPrepTDD);
}


static const per_sequence_t UL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD_sequence[] = {
  { &hf_rnsap_cCTrCH_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_tFCS          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TFCS },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD, UL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD_sequence);

  return offset;
}
static int dissect_id_UL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD(tvb, offset, actx, tree, hf_rnsap_id_UL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD);
}


static const per_sequence_t UL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD_sequence_of[1] = {
  { &hf_rnsap_UL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_UL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_UL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD, UL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD_sequence_of,
                                                  0, 16);

  return offset;
}
static int dissect_id_UL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD(tvb, offset, actx, tree, hf_rnsap_id_UL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD);
}


static const per_sequence_t UL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD_sequence_of[1] = {
  { &hf_rnsap_UL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_UL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_UL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD, UL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD_sequence_of,
                                                  0, 16);

  return offset;
}
static int dissect_id_UL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD(tvb, offset, actx, tree, hf_rnsap_id_UL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD);
}


static const per_sequence_t UL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD_sequence_of[1] = {
  { &hf_rnsap_UL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_UL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_UL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD, UL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD_sequence_of,
                                                  0, 16);

  return offset;
}
static int dissect_id_UL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD(tvb, offset, actx, tree, hf_rnsap_id_UL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD);
}


static const per_sequence_t UL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD_sequence[] = {
  { &hf_rnsap_cCTrCH_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD, UL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD_sequence);

  return offset;
}
static int dissect_id_UL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD(tvb, offset, actx, tree, hf_rnsap_id_UL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD);
}


static const per_sequence_t UL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD_sequence_of[1] = {
  { &hf_rnsap_UL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_ProtocolIE_Single_Container },
};

static int
dissect_rnsap_UL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_UL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD, UL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD_sequence_of,
                                                  0, 16);

  return offset;
}
static int dissect_id_UL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD(tvb, offset, actx, tree, hf_rnsap_id_UL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD);
}


static const per_sequence_t UL_DPCH_InformationDeleteItem_RL_ReconfReadyTDD_sequence[] = {
  { &hf_rnsap_dPCH_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DPCH_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UL_DPCH_InformationDeleteItem_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UL_DPCH_InformationDeleteItem_RL_ReconfReadyTDD, UL_DPCH_InformationDeleteItem_RL_ReconfReadyTDD_sequence);

  return offset;
}
static int dissect_UL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_DPCH_InformationDeleteItem_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_UL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD_item);
}


static const per_sequence_t UL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD_sequence_of[1] = {
  { &hf_rnsap_UL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_DPCH_InformationDeleteItem_RL_ReconfReadyTDD },
};

static int
dissect_rnsap_UL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_UL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD, UL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD_sequence_of,
                                                  0, 240);

  return offset;
}
static int dissect_id_UL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_id_UL_DPCH_InformationDeleteListIE_RL_ReconfReadyTDD);
}


static const per_sequence_t TDD_UL_Code_InformationModifyItem_RL_ReconfReadyTDD_sequence[] = {
  { &hf_rnsap_dPCH_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_DPCH_ID },
  { &hf_rnsap_tDD_ChannelisationCode, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TDD_ChannelisationCode },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_TDD_UL_Code_InformationModifyItem_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_TDD_UL_Code_InformationModifyItem_RL_ReconfReadyTDD, TDD_UL_Code_InformationModifyItem_RL_ReconfReadyTDD_sequence);

  return offset;
}
static int dissect_TDD_UL_Code_InformationModifyList_RL_ReconfReadyTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TDD_UL_Code_InformationModifyItem_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_TDD_UL_Code_InformationModifyList_RL_ReconfReadyTDD_item);
}


static const per_sequence_t TDD_UL_Code_InformationModifyList_RL_ReconfReadyTDD_sequence_of[1] = {
  { &hf_rnsap_TDD_UL_Code_InformationModifyList_RL_ReconfReadyTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_TDD_UL_Code_InformationModifyItem_RL_ReconfReadyTDD },
};

static int
dissect_rnsap_TDD_UL_Code_InformationModifyList_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_TDD_UL_Code_InformationModifyList_RL_ReconfReadyTDD, TDD_UL_Code_InformationModifyList_RL_ReconfReadyTDD_sequence_of,
                                                  1, 240);

  return offset;
}
static int dissect_uL_Code_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_TDD_UL_Code_InformationModifyList_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_uL_Code_Information);
}


static const per_sequence_t UL_Timeslot_InformationModifyItem_RL_ReconfReadyTDD_sequence[] = {
  { &hf_rnsap_timeSlot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TimeSlot },
  { &hf_rnsap_midambleShiftAndBurstType, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_MidambleShiftAndBurstType },
  { &hf_rnsap_tFCI_Presence , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TFCI_Presence },
  { &hf_rnsap_uL_Code_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TDD_UL_Code_InformationModifyList_RL_ReconfReadyTDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UL_Timeslot_InformationModifyItem_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UL_Timeslot_InformationModifyItem_RL_ReconfReadyTDD, UL_Timeslot_InformationModifyItem_RL_ReconfReadyTDD_sequence);

  return offset;
}
static int dissect_UL_Timeslot_InformationModifyList_RL_ReconfReadyTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_Timeslot_InformationModifyItem_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_UL_Timeslot_InformationModifyList_RL_ReconfReadyTDD_item);
}


static const per_sequence_t UL_Timeslot_InformationModifyList_RL_ReconfReadyTDD_sequence_of[1] = {
  { &hf_rnsap_UL_Timeslot_InformationModifyList_RL_ReconfReadyTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_UL_Timeslot_InformationModifyItem_RL_ReconfReadyTDD },
};

static int
dissect_rnsap_UL_Timeslot_InformationModifyList_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_UL_Timeslot_InformationModifyList_RL_ReconfReadyTDD, UL_Timeslot_InformationModifyList_RL_ReconfReadyTDD_sequence_of,
                                                  1, 15);

  return offset;
}
static int dissect_uL_Timeslot_InformationModifyList_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_Timeslot_InformationModifyList_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_uL_Timeslot_InformationModifyList_RL_ReconfReadyTDD);
}


static const per_sequence_t UL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD_sequence[] = {
  { &hf_rnsap_repetitionPeriod, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_RepetitionPeriod },
  { &hf_rnsap_repetitionLength, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_RepetitionLength },
  { &hf_rnsap_tDD_DPCHOffset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TDD_DPCHOffset },
  { &hf_rnsap_uL_Timeslot_InformationModifyList_RL_ReconfReadyTDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_UL_Timeslot_InformationModifyList_RL_ReconfReadyTDD },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD, UL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD_sequence);

  return offset;
}
static int dissect_id_UL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD(tvb, offset, actx, tree, hf_rnsap_id_UL_DPCH_InformationModifyListIE_RL_ReconfReadyTDD);
}


static const per_sequence_t UnsuccessfulRL_InformationResponse_RL_AdditionFailureTDD_sequence[] = {
  { &hf_rnsap_rL_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RL_ID },
  { &hf_rnsap_cause         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_Cause },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_UnsuccessfulRL_InformationResponse_RL_AdditionFailureTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_UnsuccessfulRL_InformationResponse_RL_AdditionFailureTDD, UnsuccessfulRL_InformationResponse_RL_AdditionFailureTDD_sequence);

  return offset;
}
static int dissect_id_UnsuccessfulRL_InformationResponse_RL_AdditionFailureTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_UnsuccessfulRL_InformationResponse_RL_AdditionFailureTDD(tvb, offset, actx, tree, hf_rnsap_id_UnsuccessfulRL_InformationResponse_RL_AdditionFailureTDD);
}



static int
dissect_rnsap_USCH_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 255U, NULL, FALSE);

  return offset;
}
static int dissect_usch_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_USCH_ID(tvb, offset, actx, tree, hf_rnsap_usch_ID);
}
static int dissect_uSCH_ID(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_USCH_ID(tvb, offset, actx, tree, hf_rnsap_uSCH_ID);
}



static int
dissect_rnsap_RB_Identity(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                              0U, 31U, NULL, FALSE);

  return offset;
}
static int dissect_RB_Info_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RB_Identity(tvb, offset, actx, tree, hf_rnsap_RB_Info_item);
}


static const per_sequence_t RB_Info_sequence_of[1] = {
  { &hf_rnsap_RB_Info_item  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_RB_Identity },
};

static int
dissect_rnsap_RB_Info(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_RB_Info, RB_Info_sequence_of,
                                                  1, 32);

  return offset;
}
static int dissect_rb_Info(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_RB_Info(tvb, offset, actx, tree, hf_rnsap_rb_Info);
}


static const per_sequence_t USCH_InformationItem_sequence[] = {
  { &hf_rnsap_uSCH_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_USCH_ID },
  { &hf_rnsap_ul_CCTrCH_ID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_trChSourceStatisticsDescriptor, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TrCH_SrcStatisticsDescr },
  { &hf_rnsap_transportFormatSet, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatSet },
  { &hf_rnsap_allocationRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_AllocationRetentionPriority },
  { &hf_rnsap_schedulingPriorityIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_SchedulingPriorityIndicator },
  { &hf_rnsap_rb_Info       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_RB_Info },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_USCH_InformationItem(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_USCH_InformationItem, USCH_InformationItem_sequence);

  return offset;
}
static int dissect_USCH_Information_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_USCH_InformationItem(tvb, offset, actx, tree, hf_rnsap_USCH_Information_item);
}


static const per_sequence_t USCH_Information_sequence_of[1] = {
  { &hf_rnsap_USCH_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_USCH_InformationItem },
};

static int
dissect_rnsap_USCH_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_USCH_Information, USCH_Information_sequence_of,
                                                  1, 10);

  return offset;
}
static int dissect_id_USCHs_to_Add(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_USCH_Information(tvb, offset, actx, tree, hf_rnsap_id_USCHs_to_Add);
}
static int dissect_id_USCH_Information(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_USCH_Information(tvb, offset, actx, tree, hf_rnsap_id_USCH_Information);
}


static const per_sequence_t USCH_DeleteItem_RL_ReconfPrepTDD_sequence[] = {
  { &hf_rnsap_uSCH_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_USCH_ID },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_USCH_DeleteItem_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_USCH_DeleteItem_RL_ReconfPrepTDD, USCH_DeleteItem_RL_ReconfPrepTDD_sequence);

  return offset;
}
static int dissect_USCH_DeleteList_RL_ReconfPrepTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_USCH_DeleteItem_RL_ReconfPrepTDD(tvb, offset, actx, tree, hf_rnsap_USCH_DeleteList_RL_ReconfPrepTDD_item);
}


static const per_sequence_t USCH_DeleteList_RL_ReconfPrepTDD_sequence_of[1] = {
  { &hf_rnsap_USCH_DeleteList_RL_ReconfPrepTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_USCH_DeleteItem_RL_ReconfPrepTDD },
};

static int
dissect_rnsap_USCH_DeleteList_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_USCH_DeleteList_RL_ReconfPrepTDD, USCH_DeleteList_RL_ReconfPrepTDD_sequence_of,
                                                  0, 10);

  return offset;
}
static int dissect_id_USCH_DeleteList_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_USCH_DeleteList_RL_ReconfPrepTDD(tvb, offset, actx, tree, hf_rnsap_id_USCH_DeleteList_RL_ReconfPrepTDD);
}


static const per_sequence_t USCHInformationItem_RL_AdditionRspTDD_sequence[] = {
  { &hf_rnsap_uSCH_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_USCH_ID },
  { &hf_rnsap_transportFormatManagement, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatManagement },
  { &hf_rnsap_diversityIndication4, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_DiversityIndication_RL_AdditionRspTDD2 },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_USCHInformationItem_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_USCHInformationItem_RL_AdditionRspTDD, USCHInformationItem_RL_AdditionRspTDD_sequence);

  return offset;
}
static int dissect_USCH_InformationListIE_RL_AdditionRspTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_USCHInformationItem_RL_AdditionRspTDD(tvb, offset, actx, tree, hf_rnsap_USCH_InformationListIE_RL_AdditionRspTDD_item);
}


static const per_sequence_t USCH_InformationListIE_RL_AdditionRspTDD_sequence_of[1] = {
  { &hf_rnsap_USCH_InformationListIE_RL_AdditionRspTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_USCHInformationItem_RL_AdditionRspTDD },
};

static int
dissect_rnsap_USCH_InformationListIE_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_USCH_InformationListIE_RL_AdditionRspTDD, USCH_InformationListIE_RL_AdditionRspTDD_sequence_of,
                                                  0, 10);

  return offset;
}
static int dissect_id_USCH_InformationListIE_RL_AdditionRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_USCH_InformationListIE_RL_AdditionRspTDD(tvb, offset, actx, tree, hf_rnsap_id_USCH_InformationListIE_RL_AdditionRspTDD);
}


static const per_sequence_t USCHInformationItem_RL_SetupRspTDD_sequence[] = {
  { &hf_rnsap_usch_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_USCH_ID },
  { &hf_rnsap_bindingID     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BindingID },
  { &hf_rnsap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportLayerAddress },
  { &hf_rnsap_transportFormatManagement, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportFormatManagement },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_USCHInformationItem_RL_SetupRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_USCHInformationItem_RL_SetupRspTDD, USCHInformationItem_RL_SetupRspTDD_sequence);

  return offset;
}
static int dissect_USCH_InformationListIEs_RL_SetupRspTDD_item(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_USCHInformationItem_RL_SetupRspTDD(tvb, offset, actx, tree, hf_rnsap_USCH_InformationListIEs_RL_SetupRspTDD_item);
}


static const per_sequence_t USCH_InformationListIEs_RL_SetupRspTDD_sequence_of[1] = {
  { &hf_rnsap_USCH_InformationListIEs_RL_SetupRspTDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_rnsap_USCHInformationItem_RL_SetupRspTDD },
};

static int
dissect_rnsap_USCH_InformationListIEs_RL_SetupRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_rnsap_USCH_InformationListIEs_RL_SetupRspTDD, USCH_InformationListIEs_RL_SetupRspTDD_sequence_of,
                                                  0, 10);

  return offset;
}
static int dissect_id_USCH_InformationListIEs_RL_SetupRspTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx, proto_tree *tree) {
  return dissect_rnsap_USCH_InformationListIEs_RL_SetupRspTDD(tvb, offset, actx, tree, hf_rnsap_id_USCH_InformationListIEs_RL_SetupRspTDD);
}


static const per_sequence_t USCH_ModifyItem_RL_ReconfPrepTDD_sequence[] = {
  { &hf_rnsap_uSCH_ID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_USCH_ID },
  { &hf_rnsap_ul_ccTrCHID   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_CCTrCH_ID },
  { &hf_rnsap_trChSourceStatisticsDescriptor, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TrCH_SrcStatisticsDescr },
  { &hf_rnsap_transportFormatSet, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_TransportFormatSet },
  { &hf_rnsap_allocationRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_AllocationRetentionPriority },
  { &hf_rnsap_schedulingPriorityIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_SchedulingPriorityIndicator },
  { &hf_rnsap_bLER          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_BLER },
  { &hf_rnsap_transportBearerRequestIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rnsap_TransportBearerRequestIndicator },
  { &hf_rnsap_rb_Info       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_RB_Info },
  { &hf_rnsap_iE_Extensions , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rnsap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_rnsap_USCH_ModifyItem_RL_ReconfPrepTDD(tvbuff_t *tvb, int offset, asn1_ctx_t *actx _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_rnsap_USCH_ModifyItem_RL_ReconfPrepTDD, USCH_ModifyItem_RL_ReconfPrepTDD_sequence);

 