#!/usr/bin/python

program_name = "woody"
version = "0.1.6"
face = None
mode = "normal"
debug = 0
cfg = None


############################################################
# Converts a number of bytes into a human-readable string
# Ex:  2091257 -> 2042k
#
def size_string(num):
  if num < 1024*10:
    return ("%0.fb" % num)
  if num < 1024*1024*10:
    return ("%0.fk" % (num/1024))
  if float(num) < 1024.0*1024.0*1024.0*10.0:
    return ("%.0fM" % (num/1024.0/1024.0))
  #if num < 1024*1024*1024*1024*10:
  #  return ("%sG" % (num/1024/1024/1024))
  return ("%sb" % num)
  


############################################################
#
#
def run_external_editor(wood, str):
  import whrandom, string
  
  editor = wood.options.external_editor

  filename = "/tmp/woody-%.6f.txt" % whrandom.random()

  # dump variable into a file
  if str:
    #print "editor: dumping %s..." % str
    try:
      file = open(filename, "w")
      file.write(str)
      file.close()
    except:
      return -1
  
  # edit the file
  # TODO: suspend the interface?
  command = editor
  command = string.replace(editor, "%f", filename)

  try:
    import os
    #print "editor: running %s" % command
    os.system(command)
  except:
    #import traceback ; traceback.print_exc()
    return -2
  
  # read the file into the variable
  import os.path
  if os.path.exists(filename):
    #print "editor: reading %s" % filename
    try:
      file = open(filename, "r")
      str = ''
      for line in file.readlines():
        str = str + line
      file.close()
    except:
      #import traceback ; traceback.print_exc()
      return -3

    # remove the file
    #print "editor: removing %s" % filename
    try:
      os.unlink(filename)
    except:
      #import traceback ; traceback.print_exc()
      return -4


  while str  and  (str[-1] == "\n"  or  str[-1] == " "):
    str = str[:-1]

  #print "editor: return %s" % str
  return str


